/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class MultiClientHelper
implements BeforeAllCallback {
    private String[] clusterFiles;
    private Collection<Database> openDatabases;

    public static String[] readClusterFromEnv() {
        String string = System.getenv("FDB_CLUSTERS");
        if (string == null) {
            throw new IllegalStateException("Missing FDB cluster connection file names");
        }
        return string.split(";");
    }

    Collection<Database> openDatabases(FDB fDB) {
        if (this.openDatabases != null) {
            return this.openDatabases;
        }
        if (this.clusterFiles == null) {
            this.clusterFiles = MultiClientHelper.readClusterFromEnv();
        }
        ArrayList<Database> arrayList = new ArrayList<Database>();
        for (String string : this.clusterFiles) {
            System.out.printf("Opening Cluster: %s\n", string);
            arrayList.add(fDB.open(string));
        }
        this.openDatabases = arrayList;
        return arrayList;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.clusterFiles = MultiClientHelper.readClusterFromEnv();
    }
}

