#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
/*
 * StreamingRead.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct StreamingReadWorkload : TestWorkload {
	static constexpr auto NAME = "StreamingRead";

	int actorCount, keyBytes, valueBytes, readsPerTransaction, nodeCount;
	int rangesPerTransaction;
	bool readSequentially;
	double testDuration, warmingDelay;
	Value constantValue;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, readKeys;
	PerfIntCounter readValueBytes;
	DDSketch<double> latencies;

	StreamingReadWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), readKeys("Keys Read"), readValueBytes("Value Bytes Read"),
	    latencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		actorCount = getOption(options, "actorCount"_sr, 20);
		readsPerTransaction = getOption(options, "readsPerTransaction"_sr, 10);
		rangesPerTransaction = getOption(options, "rangesPerTransaction"_sr, 1);
		nodeCount = getOption(options, "nodeCount"_sr, 100000);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);
		valueBytes = std::max(getOption(options, "valueBytes"_sr, 96), 16);
		std::string valueFormat = "%016llx" + deterministicRandom()->randomAlphaNumeric(valueBytes - 16);
		warmingDelay = getOption(options, "warmingDelay"_sr, 0.0);
		constantValue = Value(format(valueFormat.c_str(), 42));
		readSequentially = getOption(options, "readSequentially"_sr, false);
	}

	Future<Void> setup(Database const& cx) override {
		return bulkSetup(cx, this, nodeCount, Promise<double>(), true, warmingDelay);
	}

	Future<Void> start(Database const& cx) override {
		for (int c = clientId; c < actorCount; c += clientCount)
			clients.push_back(timeout(streamingReadClient(cx, this, clientId, c), testDuration, Void()));
		return waitForAll(clients);
	}

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(readKeys.getMetric());
		m.emplace_back("Bytes read/sec",
		               (readKeys.getValue() * keyBytes + readValueBytes.getValue()) / testDuration,
		               Averaged::False);

		m.emplace_back("Mean Latency (ms)", 1000 * latencies.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * latencies.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * latencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Latency (ms, averaged)", 1000 * latencies.percentile(0.98), Averaged::True);
	}

	Key keyForIndex(uint64_t index) {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodeCount;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}

	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(keyForIndex(n), constantValue); }

																#line 101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
// This generated class is to be used only via streamingReadClient()
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
template <class StreamingReadClientActor>
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
class StreamingReadClientActorState {
															#line 107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
public:
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	StreamingReadClientActorState(Database const& cx,StreamingReadWorkload* const& self,int const& clientId,int const& actorId) 
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		 : cx(cx),
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   self(self),
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   clientId(clientId),
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   actorId(actorId),
															#line 100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   minIndex(actorId * self->nodeCount / self->actorCount),
															#line 101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   maxIndex(std::min((actorId + 1) * self->nodeCount / self->actorCount, self->nodeCount)),
															#line 102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		   currentIndex(minIndex)
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("streamingReadClient", reinterpret_cast<unsigned long>(this));

	}
	~StreamingReadClientActorState() 
	{
		fdb_probe_actor_destroy("streamingReadClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			;
															#line 141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StreamingReadClientActorState();
		static_cast<StreamingReadClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		tstart = now();
															#line 106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		tr = Transaction(cx);
															#line 107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		rangeSize = (double)self->readsPerTransaction / self->rangesPerTransaction + 0.5;
															#line 108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		range = 0;
															#line 109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		;
															#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		self->latencies.addSample(now() - tstart);
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		++self->transactions;
															#line 190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		thisRangeSize = (range < self->rangesPerTransaction - 1) ? rangeSize : self->readsPerTransaction - (self->rangesPerTransaction - 1) * rangeSize;
															#line 114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		if (self->readSequentially && thisRangeSize > maxIndex - minIndex)
															#line 208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		{
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			thisRangeSize = maxIndex - minIndex;
															#line 212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		}
															#line 116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		;
															#line 216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		if (now() - tstart > 3)
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		if (++range == self->rangesPerTransaction)
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			if (!self->readSequentially)
															#line 264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			{
															#line 119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
				currentIndex = deterministicRandom()->randomInt(0, self->nodeCount - thisRangeSize);
															#line 268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			}
			else
			{
															#line 120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
				if (currentIndex > maxIndex - thisRangeSize)
															#line 274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
				{
															#line 121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
					currentIndex = minIndex;
															#line 278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
				}
			}
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(firstGreaterOrEqual(self->keyForIndex(currentIndex)), firstGreaterOrEqual(self->keyForIndex(currentIndex + thisRangeSize)), thisRangeSize);
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			if (static_cast<StreamingReadClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StreamingReadClientActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StreamingReadClientActor, 0, RangeResult >*>(static_cast<StreamingReadClientActor*>(this)));
															#line 290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			if (static_cast<StreamingReadClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StreamingReadClientActor*>(this)->actor_wait_state = 2;
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StreamingReadClientActor, 1, Void >*>(static_cast<StreamingReadClientActor*>(this)));
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont2(RangeResult const& values,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		for(int i = 0;i < values.size();i++) {
															#line 129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			self->readValueBytes += values[i].value.size();
															#line 349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		}
															#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		if (self->readSequentially)
															#line 353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		{
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			currentIndex += values.size();
															#line 357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		}
															#line 134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		self->readKeys += values.size();
															#line 361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont2(RangeResult && values,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		for(int i = 0;i < values.size();i++) {
															#line 129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			self->readValueBytes += values[i].value.size();
															#line 372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		}
															#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		if (self->readSequentially)
															#line 376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		{
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
			currentIndex += values.size();
															#line 380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		}
															#line 134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
		self->readKeys += values.size();
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont2(values, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont2(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StreamingReadClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingReadClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingReadClientActor*>(this)->ActorCallback< StreamingReadClientActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StreamingReadClientActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StreamingReadClientActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StreamingReadClientActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StreamingReadClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingReadClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingReadClientActor*>(this)->ActorCallback< StreamingReadClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StreamingReadClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StreamingReadClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StreamingReadClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	Database cx;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	StreamingReadWorkload* self;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int clientId;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int actorId;
															#line 100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int minIndex;
															#line 101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int maxIndex;
															#line 102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int currentIndex;
															#line 105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	double tstart;
															#line 106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	Transaction tr;
															#line 107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int rangeSize;
															#line 108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int range;
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	int thisRangeSize;
															#line 575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via streamingReadClient()
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
class StreamingReadClientActor final : public Actor<Void>, public ActorCallback< StreamingReadClientActor, 0, RangeResult >, public ActorCallback< StreamingReadClientActor, 1, Void >, public FastAllocated<StreamingReadClientActor>, public StreamingReadClientActorState<StreamingReadClientActor> {
															#line 580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<StreamingReadClientActor>::operator new;
	using FastAllocated<StreamingReadClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4778461422203307008UL, 689382569489504256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StreamingReadClientActor, 0, RangeResult >;
friend struct ActorCallback< StreamingReadClientActor, 1, Void >;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	StreamingReadClientActor(Database const& cx,StreamingReadWorkload* const& self,int const& clientId,int const& actorId) 
															#line 598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StreamingReadClientActorState<StreamingReadClientActor>(cx, self, clientId, actorId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("streamingReadClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7597216102276091904UL, 12542454532983343104UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingReadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("streamingReadClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("streamingReadClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StreamingReadClientActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StreamingReadClientActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
[[nodiscard]] Future<Void> streamingReadClient( Database const& cx, StreamingReadWorkload* const& self, int const& clientId, int const& actorId ) {
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
	return Future<Void>(new StreamingReadClientActor(cx, self, clientId, actorId));
															#line 631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRead.actor.g.cpp.py_gen"
}

#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRead.actor.cpp"
};

WorkloadFactory<StreamingReadWorkload> StreamingReadWorkloadFactory;
