#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
/*
 * worker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdlib>
#include <tuple>
#include <boost/lexical_cast.hpp>
#include <unordered_map>

#include "fdbclient/FDBTypes.h"
#include "flow/ApiVersion.h"
#include "flow/Buggify.h"
#include "flow/CodeProbe.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/Locality.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/versions.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/NetworkAddress.h"
#include "fdbrpc/FlowGrpc.h"
#include "flow/ObjectSerializer.h"
#include "flow/Platform.h"
#include "flow/ProtocolVersion.h"
#include "flow/SystemMonitor.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/MetricLogger.actor.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/RoleLineage.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h" // for poisson()
#include "fdbserver/IDiskQueue.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ClientWorkerInterface.h"
#include "flow/Profiler.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include "flow/ChaosMetrics.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "flow/ApiVersion.h"
#include "fdbctl/ControlService.h"

#ifdef __linux__
#include <fcntl.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(__linux__) || defined(__FreeBSD__)
#ifdef USE_GPERFTOOLS
#include "gperftools/profiler.h"
#include "gperftools/heap-profiler.h"
#endif
#include <unistd.h>
#include <execinfo.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

#if CENABLED(0, NOT_IN_CLEAN)
extern IKeyValueStore* keyValueStoreCompressTestData(IKeyValueStore* store);
#define KV_STORE(filename, uid) keyValueStoreCompressTestData(keyValueStoreSQLite(filename, uid))
#elif CENABLED(0, NOT_IN_CLEAN)
#define KV_STORE(filename, uid) keyValueStoreSQLite(filename, uid)
#else
#define KV_STORE(filename, uid) keyValueStoreMemory(filename, uid)
#endif

template class RequestStream<RecruitMasterRequest, false>;
template struct NetNotifiedQueue<RecruitMasterRequest, false>;

template class RequestStream<InitializeCommitProxyRequest, false>;
template struct NetNotifiedQueue<InitializeCommitProxyRequest, false>;

template class RequestStream<InitializeGrvProxyRequest, false>;
template struct NetNotifiedQueue<InitializeGrvProxyRequest, false>;

template class RequestStream<GetServerDBInfoRequest, false>;
template struct NetNotifiedQueue<GetServerDBInfoRequest, false>;

namespace {
RoleLineageCollector roleLineageCollector;
}

															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TryDBInfoBroadcastActor>
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActorState {
															#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActorState(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : stream(stream),
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(req)
															#line 140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~TryDBInfoBroadcastActorState() 
	{
		fdb_probe_actor_destroy("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<std::vector<Endpoint>>> __when_expr_0 = stream.getReplyUnlessFailedFor(req, SERVER_KNOBS->DBINFO_FAILED_DELAY, 0);
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 1;
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*>(static_cast<TryDBInfoBroadcastActor*>(this)));
															#line 162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state > 0) static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<TryDBInfoBroadcastActor*>(this)->ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >::remove();

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> const& value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> && value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,Error err) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RequestStream<UpdateServerDBInfoRequest> stream;
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >, public FastAllocated<TryDBInfoBroadcastActor>, public TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor> {
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<TryDBInfoBroadcastActor>::operator new;
	using FastAllocated<TryDBInfoBroadcastActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17151239344116234496UL, 18140983574476123904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >;
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActor(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<std::vector<Endpoint>>(),
		   TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor>(stream, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4829059694717746176UL, 12815649290741346816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryDBInfoBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> tryDBInfoBroadcast( RequestStream<UpdateServerDBInfoRequest> const& stream, UpdateServerDBInfoRequest const& req ) {
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new TryDBInfoBroadcastActor(stream, req));
															#line 367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class BroadcastDBInfoRequestActor>
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActorState {
															#line 379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActorState(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req),
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendAmount(sendAmount),
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sender(sender),
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendReply(sendReply),
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   replies(),
															#line 138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   reply(req.reply)
															#line 396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastDBInfoRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			resetReply(req);
															#line 140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			int currentStream = 0;
															#line 141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				RequestStream<UpdateServerDBInfoRequest> cur(broadcastEndpoints[currentStream++]);
															#line 145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				replies.push_back(tryDBInfoBroadcast(cur, req));
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				resetReply(req);
															#line 433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 1;
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*>(static_cast<BroadcastDBInfoRequestActor*>(this)));
															#line 444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastDBInfoRequestActor*>(this)->ActorCallback< BroadcastDBInfoRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int sendAmount;
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Endpoint> sender;
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool sendReply;
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<std::vector<Endpoint>>> replies;
															#line 138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ReplyPromise<std::vector<Endpoint>> reply;
															#line 622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< BroadcastDBInfoRequestActor, 0, Void >, public FastAllocated<BroadcastDBInfoRequestActor>, public BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor> {
															#line 627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<BroadcastDBInfoRequestActor>::operator new;
	using FastAllocated<BroadcastDBInfoRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8302737946125810176UL, 12643531946085422592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastDBInfoRequestActor, 0, Void >;
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActor(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<std::vector<Endpoint>>(),
		   BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor>(req, sendAmount, sender, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7360236551166211584UL, 3807311166382409728UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastDBInfoRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> broadcastDBInfoRequest( UpdateServerDBInfoRequest const& req, int const& sendAmount, Optional<Endpoint> const& sender, bool const& sendReply ) {
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new BroadcastDBInfoRequestActor(req, sendAmount, sender, sendReply));
															#line 677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via extractClientInfo()
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClientInfoActor>
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActorState {
															#line 689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   info(info),
															#line 168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxyUIDs(),
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxies(),
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxyUIDs(),
															#line 171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxies()
															#line 706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClientInfoActorState() 
	{
		fdb_probe_actor_destroy("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClientInfoActorState();
		static_cast<ExtractClientInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ClientDBInfo ni = db->get().client;
															#line 174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		shrinkProxyList(ni, lastCommitProxyUIDs, lastCommitProxies, lastGrvProxyUIDs, lastGrvProxies);
															#line 175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		info->setUnconditional(ni);
															#line 176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 1;
															#line 176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClientInfoActor, 0, Void >*>(static_cast<ExtractClientInfoActor*>(this)));
															#line 764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state > 0) static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClientInfoActor*>(this)->ActorCallback< ExtractClientInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClientInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClientDBInfo>> info;
															#line 168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastCommitProxyUIDs;
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<CommitProxyInterface> lastCommitProxies;
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastGrvProxyUIDs;
															#line 171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<GrvProxyInterface> lastGrvProxies;
															#line 868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via extractClientInfo()
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActor final : public Actor<Void>, public ActorCallback< ExtractClientInfoActor, 0, Void >, public FastAllocated<ExtractClientInfoActor>, public ExtractClientInfoActorState<ExtractClientInfoActor> {
															#line 873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExtractClientInfoActor>::operator new;
	using FastAllocated<ExtractClientInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9659019517418592000UL, 4916172711453565440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClientInfoActor, 0, Void >;
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ExtractClientInfoActorState<ExtractClientInfoActor>(db, info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(936284430390917120UL, 5465665005456452352UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClientInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClientInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] static Future<Void> extractClientInfo( Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<ClientDBInfo>> const& info ) {
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClientInfoActor(db, info));
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Database openDBOnServer(Reference<AsyncVar<ServerDBInfo> const> const& db,
                        TaskPriority taskID,
                        LockAware lockAware,
                        EnableLocalityLoadBalance enableLocalityLoadBalance) {
	auto info = makeReference<AsyncVar<ClientDBInfo>>();
	auto cx = DatabaseContext::create(info,
	                                  extractClientInfo(db, info),
	                                  enableLocalityLoadBalance ? db->get().myLocality : LocalityData(),
	                                  enableLocalityLoadBalance,
	                                  taskID,
	                                  lockAware);
	cx->globalConfig->init(db, std::addressof(db->get().client));
	cx->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	cx->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);
	return cx;
}

struct ErrorInfo {
	Error error;
	const Role& role;
	UID id;
	ErrorInfo(Error e, const Role& role, UID id) : error(e), role(role), id(id) {}
	template <class Ar>
	void serialize(Ar&) {
		ASSERT(false);
	}
};

Error checkIOTimeout(Error const& e) {
	// Convert all_errors to io_timeout if global timeout bool was set
	bool timeoutOccurred = (bool)g_network->global(INetwork::enASIOTimedOut);
	// In simulation, have to check global timed out flag for both this process and the machine process on which IO is
	// done
	if (g_network->isSimulated() && !timeoutOccurred)
		timeoutOccurred = g_simulator->getCurrentProcess()->machine->machineProcess->global(INetwork::enASIOTimedOut);

	if (timeoutOccurred) {
		CODE_PROBE(true, "Timeout occurred");
		Error timeout = io_timeout();
		// Preserve injectedness of error
		if (e.isInjectedFault())
			timeout = timeout.asInjectedFault();
		return timeout;
	}
	return e;
}

															#line 975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via forwardError()
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ForwardErrorActor>
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActorState {
															#line 982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActorState(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors),
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   role(role),
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   process(process)
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("forwardError", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("forwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = process;
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ForwardErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorActor, 0, Void >*>(static_cast<ForwardErrorActor*>(this)));
															#line 1018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errors.send(ErrorInfo(e, role, id));
															#line 234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForwardErrorActorState();
			static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorActor*>(this)->ActorCallback< ForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> process;
															#line 1175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via forwardError()
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActor final : public Actor<Void>, public ActorCallback< ForwardErrorActor, 0, Void >, public FastAllocated<ForwardErrorActor>, public ForwardErrorActorState<ForwardErrorActor> {
															#line 1180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ForwardErrorActor>::operator new;
	using FastAllocated<ForwardErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14056638463477479680UL, 13690103036100462592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorActor, 0, Void >;
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActor(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 1197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ForwardErrorActorState<ForwardErrorActor>(errors, role, id, process),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1301226801814355968UL, 15803518444079550976UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> forwardError( PromiseStream<ErrorInfo> const& errors, Role const& role, UID const& id, Future<Void> const& process ) {
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ForwardErrorActor(errors, role, id, process));
															#line 1230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 1235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleIOErrors()
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HandleIOErrorsActor>
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActorState {
															#line 1242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActorState(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : actor(actor),
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeError(storeError),
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   onClosed(onClosed)
															#line 1255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	~HandleIOErrorsActorState() 
	{
		fdb_probe_actor_destroy("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(actor);
															#line 242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = storeError;
															#line 1276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 1;
															#line 243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleIOErrorsActorState();
		static_cast<HandleIOErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> const& __e,int loopDepth) 
	{
															#line 243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e = __e;
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> && __e,int loopDepth) 
	{
		e = std::move(__e);
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >::remove();
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >::remove();

	}
	int a_body1when1cont1(int loopDepth) 
	{
															#line 249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_broken_promise && !storeError.isReady())
															#line 1444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.00001 + FLOW_KNOBS->MAX_BUGGIFIED_DELAY);
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 3;
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 3, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1when1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1when1cont3(int loopDepth) 
	{
															#line 252 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (storeError.isReady() && storeError.isError() && storeError.getError().code() != error_code_file_not_found)
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(storeError.get().getError(), loopDepth);
															#line 1560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 1564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e.getError(), loopDepth);
															#line 1568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> actor;
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<ErrorOr<Void>> storeError;
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> onClosed;
															#line 243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Void> e;
															#line 1794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleIOErrors()
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActor final : public Actor<Void>, public ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >, public ActorCallback< HandleIOErrorsActor, 2, Void >, public ActorCallback< HandleIOErrorsActor, 3, Void >, public ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >, public FastAllocated<HandleIOErrorsActor>, public HandleIOErrorsActorState<HandleIOErrorsActor> {
															#line 1799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleIOErrorsActor>::operator new;
	using FastAllocated<HandleIOErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8038786226905565440UL, 1823122955351463168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< HandleIOErrorsActor, 2, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 3, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >;
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActor(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 1819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleIOErrorsActorState<HandleIOErrorsActor>(actor, storeError, id, onClosed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6206421713096993792UL, 16845784795105158144UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleIOErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> handleIOErrors( Future<Void> const& actor, Future<ErrorOr<Void>> const& storeError, UID const& id, Future<Void> const& onClosed = Void() ) {
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HandleIOErrorsActor(actor, storeError, id, onClosed));
															#line 1854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Future<Void> handleIOErrors(Future<Void> actor, IClosable* store, UID id, Future<Void> onClosed = Void()) {
	Future<ErrorOr<Void>> storeError = actor.isReady() ? Never() : errorOr(store->getError());
	return handleIOErrors(actor, storeError, id, onClosed);
}

Future<Void> deregisterGrpcService(const UID& id) {
#ifdef FLOW_GRPC_ENABLED
	if (g_network->isSimulated()) {
		return Void();
	}

	if (GrpcServer::instance() != nullptr) {
		return GrpcServer::instance()->deregisterRoleServices(id);
	}
#endif
	return Void();
}

															#line 1877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerHandleErrors()
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerHandleErrorsActor>
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActorState {
															#line 1884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActorState(FutureStream<ErrorInfo> const& errors) 
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors)
															#line 1891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	~WorkerHandleErrorsActorState() 
	{
		fdb_probe_actor_destroy("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 1906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerHandleErrorsActorState();
		static_cast<WorkerHandleErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = errors;
															#line 1936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ErrorInfo>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ErrorInfo>>::value, "invalid type");
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*>(static_cast<WorkerHandleErrorsActor*>(this)));
															#line 1945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo const& _err,int loopDepth) 
	{
															#line 299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress || err.error.code() == error_code_audit_storage_task_outdated;
															#line 307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 1968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 1980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 1984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 1988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo && _err,int loopDepth) 
	{
															#line 299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress || err.error.code() == error_code_audit_storage_task_outdated;
															#line 307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 2014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 2022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 2026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state > 0) static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerHandleErrorsActor*>(this)->ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo const& value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo && value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,Error err) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<ErrorInfo> errors;
															#line 313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::optional<Error> rethrow;
															#line 2099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerHandleErrors()
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActor final : public Actor<Void>, public ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >, public FastAllocated<WorkerHandleErrorsActor>, public WorkerHandleErrorsActorState<WorkerHandleErrorsActor> {
															#line 2104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerHandleErrorsActor>::operator new;
	using FastAllocated<WorkerHandleErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16906011039116580352UL, 10174795218439072512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >;
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActor(FutureStream<ErrorInfo> const& errors) 
															#line 2121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerHandleErrorsActorState<WorkerHandleErrorsActor>(errors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8795450729902019072UL, 3187225731259694336UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerHandleErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerHandleErrors( FutureStream<ErrorInfo> const& errors ) {
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerHandleErrorsActor(errors));
															#line 2154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Improve simulation code coverage by sometimes deferring the destruction of workerInterface (and therefore "endpoint
// not found" responses to clients
//		for an extra second, so that clients are more likely to see broken_promise errors
															#line 2162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via zombie()
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T, class ZombieActor>
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActorState {
															#line 2169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActorState(T const& workerInterface,Future<Void> const& worker) 
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : workerInterface(workerInterface),
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   worker(worker)
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("zombie", reinterpret_cast<unsigned long>(this));

	}
	~ZombieActorState() 
	{
		fdb_probe_actor_destroy("zombie", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = worker;
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ZombieActor*>(this)->actor_wait_state = 1;
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 0, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZombieActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ZombieActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZombieActorState(); static_cast<ZombieActor*>(this)->destroy(); return 0; }
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<ZombieActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZombieActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	T workerInterface;
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> worker;
															#line 2469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via zombie()
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActor final : public Actor<Void>, public ActorCallback< ZombieActor<T>, 0, Void >, public ActorCallback< ZombieActor<T>, 1, Void >, public FastAllocated<ZombieActor<T>>, public ZombieActorState<T, ZombieActor<T>> {
															#line 2476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ZombieActor<T>>::operator new;
	using FastAllocated<ZombieActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(420820415541244160UL, 12345801023674585088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZombieActor<T>, 0, Void >;
friend struct ActorCallback< ZombieActor<T>, 1, Void >;
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActor(T const& workerInterface,Future<Void> const& worker) 
															#line 2494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ZombieActorState<T, ZombieActor<T>>(workerInterface, worker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17103515626195448064UL, 1853427329179145472UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zombie");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZombieActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZombieActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> zombie( T const& workerInterface, Future<Void> const& worker ) {
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ZombieActor<T>(workerInterface, worker));
															#line 2530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 2535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via loadedPonger()
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class LoadedPongerActor>
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActorState {
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActorState(FutureStream<LoadedPingRequest> const& pings) 
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : pings(pings),
															#line 345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   payloadBack(std::string(20480, '.'))
															#line 2551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	~LoadedPongerActorState() 
	{
		fdb_probe_actor_destroy("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadedPongerActorState();
		static_cast<LoadedPongerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = pings;
															#line 2596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<LoadedPingRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<LoadedPingRequest>>::value, "invalid type");
															#line 348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<LoadedPongerActor*>(this)->actor_wait_state = 1;
															#line 348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*>(static_cast<LoadedPongerActor*>(this)));
															#line 2605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest const& pong,int loopDepth) 
	{
															#line 349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest && pong,int loopDepth) 
	{
															#line 349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest const& pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(pong, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest && pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(pong), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state > 0) static_cast<LoadedPongerActor*>(this)->actor_wait_state = 0;
		static_cast<LoadedPongerActor*>(this)->ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest const& value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest && value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<LoadedPingRequest> pings;
															#line 345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Standalone<StringRef> payloadBack;
															#line 2719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadedPonger()
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActor final : public Actor<Void>, public ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >, public FastAllocated<LoadedPongerActor>, public LoadedPongerActorState<LoadedPongerActor> {
															#line 2724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<LoadedPongerActor>::operator new;
	using FastAllocated<LoadedPongerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12139297078008844288UL, 5973171492541671680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >;
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActor(FutureStream<LoadedPingRequest> const& pings) 
															#line 2741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LoadedPongerActorState<LoadedPongerActor>(pings),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17672933219176974592UL, 1478809613757852416UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadedPonger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> loadedPonger( FutureStream<LoadedPingRequest> const& pings ) {
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new LoadedPongerActor(pings));
															#line 2774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

StringRef fileStoragePrefix = "storage-"_sr;
StringRef testingStoragePrefix = "testingstorage-"_sr;
StringRef fileLogDataPrefix = "log-"_sr;
StringRef fileVersionedLogDataPrefix = "log2-"_sr;
StringRef fileLogQueuePrefix = "logqueue-"_sr;
StringRef tlogQueueExtension = "fdq"_sr;

enum class FilesystemCheck {
	FILES_ONLY,
	DIRECTORIES_ONLY,
	FILES_AND_DIRECTORIES,
};

struct KeyValueStoreSuffix {
	KeyValueStoreType type;
	std::string suffix;
	FilesystemCheck check;
};

KeyValueStoreSuffix bTreeV1Suffix = { KeyValueStoreType::SSD_BTREE_V1, ".fdb", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix bTreeV2Suffix = { KeyValueStoreType::SSD_BTREE_V2, ".sqlite", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memorySuffix = { KeyValueStoreType::MEMORY, "-0.fdq", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memoryRTSuffix = { KeyValueStoreType::MEMORY_RADIXTREE, "-0.fdr", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix redwoodSuffix = { KeyValueStoreType::SSD_REDWOOD_V1, ".redwood-v1", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix rocksdbSuffix = { KeyValueStoreType::SSD_ROCKSDB_V1,
	                                  ".rocksdb",
	                                  FilesystemCheck::DIRECTORIES_ONLY };
KeyValueStoreSuffix shardedRocksdbSuffix = { KeyValueStoreType::SSD_SHARDED_ROCKSDB,
	                                         ".shardedrocksdb",
	                                         FilesystemCheck::DIRECTORIES_ONLY };

std::string validationFilename = "_validate";

std::string filenameFromSample(KeyValueStoreType storeType, std::string folder, std::string sample_filename) {
	switch (storeType.storeType()) {
	case KeyValueStoreType::SSD_BTREE_V1:
	case KeyValueStoreType::SSD_BTREE_V2:
	case KeyValueStoreType::SSD_REDWOOD_V1:
	case KeyValueStoreType::SSD_ROCKSDB_V1:
	case KeyValueStoreType::SSD_SHARDED_ROCKSDB:
		return joinPath(folder, sample_filename);

	case KeyValueStoreType::MEMORY:
	case KeyValueStoreType::MEMORY_RADIXTREE:
		return joinPath(folder, sample_filename.substr(0, sample_filename.size() - 5));

	default:
		UNREACHABLE();
	}
}

std::string filenameFromId(KeyValueStoreType storeType, std::string folder, std::string prefix, UID id) {

	if (storeType == KeyValueStoreType::SSD_BTREE_V1)
		return joinPath(folder, prefix + id.toString() + ".fdb");
	else if (storeType == KeyValueStoreType::SSD_BTREE_V2)
		return joinPath(folder, prefix + id.toString() + ".sqlite");
	else if (storeType == KeyValueStoreType::MEMORY || storeType == KeyValueStoreType::MEMORY_RADIXTREE)
		return joinPath(folder, prefix + id.toString() + "-");
	else if (storeType == KeyValueStoreType::SSD_REDWOOD_V1)
		return joinPath(folder, prefix + id.toString() + ".redwood-v1");
	else if (storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
		return joinPath(folder, prefix + id.toString() + ".rocksdb");
	else if (storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
		return joinPath(folder, prefix + id.toString() + ".shardedrocksdb");

	TraceEvent(SevError, "UnknownStoreType").detail("StoreType", storeType.toString());
	UNREACHABLE();
}

struct TLogOptions {
	TLogOptions() = default;
	TLogOptions(TLogVersion v, TLogSpillType s) : version(v), spillType(s) {}

	TLogVersion version = TLogVersion::DEFAULT;
	TLogSpillType spillType = TLogSpillType::UNSET;

	static ErrorOr<TLogOptions> FromStringRef(StringRef s) {
		TLogOptions options;
		for (StringRef key = s.eat("_"), value = s.eat("_"); s.size() != 0 || key.size();
		     key = s.eat("_"), value = s.eat("_")) {
			if (key.size() != 0 && value.size() == 0)
				return default_error_or();

			if (key == "V"_sr) {
				ErrorOr<TLogVersion> tLogVersion = TLogVersion::FromStringRef(value);
				if (tLogVersion.isError())
					return tLogVersion.getError();
				options.version = tLogVersion.get();
			} else if (key == "LS"_sr) {
				ErrorOr<TLogSpillType> tLogSpillType = TLogSpillType::FromStringRef(value);
				if (tLogSpillType.isError())
					return tLogSpillType.getError();
				options.spillType = tLogSpillType.get();
			} else {
				return default_error_or();
			}
		}
		return options;
	}

	bool operator==(const TLogOptions& o) {
		return version == o.version && (spillType == o.spillType || version >= TLogVersion::V5);
	}

	std::string toPrefix() const {
		std::string toReturn = "";
		switch (version) {
		case TLogVersion::UNSET:
			ASSERT(false);
		case TLogVersion::V2:
			return "";
		case TLogVersion::V3:
		case TLogVersion::V4:
			toReturn =
			    "V_" + boost::lexical_cast<std::string>(version) + "_LS_" + boost::lexical_cast<std::string>(spillType);
			break;
		case TLogVersion::V5:
		case TLogVersion::V6:
		case TLogVersion::V7:
			toReturn = "V_" + boost::lexical_cast<std::string>(version);
			break;
		}
		ASSERT_WE_THINK(FromStringRef(toReturn).get() == *this);
		return toReturn + "-";
	}

	DiskQueueVersion getDiskQueueVersion() const {
		if (version < TLogVersion::V3) {
			ASSERT(false); // no longer supported
			return DiskQueueVersion::V0;
		}
		if (version < TLogVersion::V7)
			return DiskQueueVersion::V1;
		return DiskQueueVersion::V2;
	}
};

TLogFn tLogFnForOptions(TLogOptions options) {
	switch (options.version) {
	case TLogVersion::V2:
	case TLogVersion::V3:
	case TLogVersion::V4:
		ASSERT(false); // V2 to V4 are no longer supported

	case TLogVersion::V5:
	case TLogVersion::V6:
	case TLogVersion::V7:
		return tLog;
	default:
		ASSERT(false);
	}
	return tLog;
}

struct DiskStore {
	enum COMPONENT { TLogData, Storage, BlobWorker, UNSET };

	UID storeID = UID();
	std::string filename = ""; // For KVStoreMemory just the base filename to be passed to IDiskQueue
	COMPONENT storedComponent = UNSET;
	KeyValueStoreType storeType = KeyValueStoreType::END;
	TLogOptions tLogOptions;
};

std::vector<DiskStore> getDiskStores(std::string folder,
                                     std::string suffix,
                                     KeyValueStoreType type,
                                     FilesystemCheck check) {
	std::vector<DiskStore> result;
	std::vector<std::string> files;

	if (check == FilesystemCheck::FILES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		files = platform::listFiles(folder, suffix);
	}
	if (check == FilesystemCheck::DIRECTORIES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		for (const auto& directory : platform::listDirectories(folder)) {
			if (StringRef(directory).endsWith(suffix)) {
				files.push_back(directory);
			}
		}
	}

	for (int idx = 0; idx < files.size(); idx++) {
		DiskStore store;
		store.storeType = type;

		StringRef filename = StringRef(files[idx]);
		Standalone<StringRef> prefix;
		if (filename.startsWith(fileStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = fileStoragePrefix;
		} else if (filename.startsWith(testingStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = testingStoragePrefix;
		} else if (filename.startsWith(fileVersionedLogDataPrefix)) {
			store.storedComponent = DiskStore::TLogData;
			// Use the option string that's in the file rather than tLogOptions.toPrefix(),
			// because they might be different if a new option was introduced in this version.
			StringRef optionsString = filename.removePrefix(fileVersionedLogDataPrefix).eat("-");
			TraceEvent("DiskStoreVersioned").detail("Filename", filename);
			ErrorOr<TLogOptions> tLogOptions = TLogOptions::FromStringRef(optionsString);
			if (tLogOptions.isError()) {
				TraceEvent(SevWarn, "DiskStoreMalformedFilename").detail("Filename", filename);
				continue;
			}
			TraceEvent("DiskStoreVersionedSuccess").detail("Filename", filename);
			store.tLogOptions = tLogOptions.get();
			prefix = filename.substr(0, fileVersionedLogDataPrefix.size() + optionsString.size() + 1);
		} else if (filename.startsWith(fileLogDataPrefix)) {
			TraceEvent("DiskStoreUnversioned").detail("Filename", filename);
			store.storedComponent = DiskStore::TLogData;
			store.tLogOptions.version = TLogVersion::V2;
			store.tLogOptions.spillType = TLogSpillType::VALUE;
			prefix = fileLogDataPrefix;
		} else {
			continue;
		}

		store.storeID = UID::fromString(files[idx].substr(prefix.size(), 32));
		store.filename = filenameFromSample(type, folder, files[idx]);
		result.push_back(store);
	}
	return result;
}

std::vector<DiskStore> getDiskStores(std::string folder) {
	auto result = getDiskStores(folder, bTreeV1Suffix.suffix, bTreeV1Suffix.type, bTreeV1Suffix.check);
	auto result1 = getDiskStores(folder, bTreeV2Suffix.suffix, bTreeV2Suffix.type, bTreeV2Suffix.check);
	result.insert(result.end(), result1.begin(), result1.end());
	auto result2 = getDiskStores(folder, memorySuffix.suffix, memorySuffix.type, memorySuffix.check);
	result.insert(result.end(), result2.begin(), result2.end());
	auto result3 = getDiskStores(folder, redwoodSuffix.suffix, redwoodSuffix.type, redwoodSuffix.check);
	result.insert(result.end(), result3.begin(), result3.end());
	auto result4 = getDiskStores(folder, memoryRTSuffix.suffix, memoryRTSuffix.type, memoryRTSuffix.check);
	result.insert(result.end(), result4.begin(), result4.end());
	auto result5 = getDiskStores(folder, rocksdbSuffix.suffix, rocksdbSuffix.type, rocksdbSuffix.check);
	result.insert(result.end(), result5.begin(), result5.end());
	auto result6 =
	    getDiskStores(folder, shardedRocksdbSuffix.suffix, shardedRocksdbSuffix.type, shardedRocksdbSuffix.check);
	result.insert(result.end(), result6.begin(), result6.end());
	return result;
}

// Register the worker interf to cluster controller (cc) and
// re-register the worker when key roles interface, e.g., cc, dd, ratekeeper, change.
															#line 3025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registrationClient()
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegistrationClientActor>
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActorState {
															#line 3032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(ddInterf),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(rkInterf),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(csInterf),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(degraded),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   connRecord(connRecord),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   issues(issues),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   recoveredDiskFiles(recoveredDiskFiles),
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   requestGeneration(0),
															#line 622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   processClass(initialClass),
															#line 623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   scInterf(new AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>()),
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheProcessFuture(),
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheErrorsFuture(),
															#line 627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   incorrectTime(),
															#line 628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   firstReg(true)
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	~RegistrationClientActorState() 
	{
		fdb_probe_actor_destroy("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 3098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegistrationClientActorState();
		static_cast<RegistrationClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		storedConnectionString = ClusterConnectionString();
															#line 631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = true;
															#line 632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (connRecord)
															#line 3132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<bool> __when_expr_0 = connRecord->upToDate(storedConnectionString);
															#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegistrationClientActor*>(this)->actor_wait_state = 1;
															#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 0, bool >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 636 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (upToDate)
															#line 3157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			incorrectTime = Optional<double>();
															#line 3161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Optional<EncryptKeyProxyInterface> fakeEpkInterf;
															#line 641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RegisterWorkerRequest request(interf, initialClass, processClass, asyncPriorityInfo->get(), requestGeneration++, ddInterf->get(), rkInterf->get(), fakeEpkInterf, csInterf->get(), degraded->get(), localConfig.isValid() ? localConfig->lastSeenVersion() : Optional<Version>(), localConfig.isValid() ? localConfig->configClassSet() : Optional<ConfigClassSet>(), recoveredDiskFiles.isSet(), configBroadcastInterface, clusterId->get());
															#line 658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto const& i : issues->get() ) {
															#line 659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), i);
															#line 3171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!upToDate)
															#line 3175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), "incorrect_cluster_file_contents"_sr);
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string connectionString = connRecord->getConnectionString().toString();
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!incorrectTime.present())
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				incorrectTime = now();
															#line 3187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(now() - incorrectTime.get() > 300 ? SevWarnAlways : SevWarn, "IncorrectClusterFileContents") .detail("ClusterFile", connRecord->toString()) .detail("StoredConnectionString", storedConnectionString.toString()) .detail("CurrentConnectionString", connectionString);
															#line 3191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto peers = FlowTransport::transport().getIncompatiblePeers();
															#line 677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(auto it = peers->begin();it != peers->end();) {
															#line 678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (now() - it->second.second > FLOW_KNOBS->INCOMPATIBLE_PEER_DELAY_BEFORE_LOGGING)
															#line 3199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.incompatiblePeers.push_back(it->first);
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it = peers->erase(it);
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it++;
															#line 3211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ccInterfacePresent = ccInterface->get().present();
															#line 687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ccInterfacePresent)
															#line 3218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.requestDbInfo = (ccInterface->get().get().id() != dbInfo->get().clusterInterface.id());
															#line 689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (firstReg)
															#line 3224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.requestDbInfo = true;
															#line 691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				firstReg = false;
															#line 3230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("WorkerRegister") .detail("CCID", ccInterface->get().get().id()) .detail("Generation", requestGeneration) .detail("RecoveredDiskFiles", recoveredDiskFiles.isSet()) .detail("ClusterId", clusterId->get());
															#line 3234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		registrationReply = ccInterfacePresent ? brokenPromiseToNever(ccInterface->get().get().registerWorker.getReply(request)) : Never();
															#line 702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recovered = recoveredDiskFiles.isSet() ? Never() : recoveredDiskFiles.getFuture();
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startTime = now();
															#line 704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 3244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& upToDateResult,int loopDepth) 
	{
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && upToDateResult,int loopDepth) 
	{
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(upToDateResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(upToDateResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<RegisterWorkerReply> __when_expr_1 = registrationReply;
															#line 704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->UNKNOWN_CC_TIMEOUT);
															#line 3365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ccInterface->onChange();
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ddInterf->onChange();
															#line 3373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when4(__when_expr_4.get(), loopDepth); };
															#line 724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rkInterf->onChange();
															#line 3377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
															#line 727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = csInterf->onChange();
															#line 3381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when6(__when_expr_6.get(), loopDepth); };
															#line 730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_7 = degraded->onChange();
															#line 3385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when7(__when_expr_7.get(), loopDepth); };
															#line 733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = FlowTransport::transport().onIncompatibleChanged();
															#line 3389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_9 = issues->onChange();
															#line 3393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when9(__when_expr_9.get(), loopDepth); };
															#line 739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_10 = recovered;
															#line 3397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when10(__when_expr_10.get(), loopDepth); };
															#line 742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_11 = clusterId->onChange();
															#line 3401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when11(__when_expr_11.get(), loopDepth); };
		static_cast<RegistrationClientActor*>(this)->actor_wait_state = 2;
															#line 705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*>(static_cast<RegistrationClientActor*>(this)));
															#line 713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 2, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 3, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 4, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 5, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 6, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 7, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 8, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 9, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 10, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 11, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply const& reply,int loopDepth) 
	{
															#line 706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply && reply,int loopDepth) 
	{
															#line 706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 2, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 3, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 4, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 5, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 6, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 7, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 8, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 9, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 10, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>> const> ddInterf;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>> const> rkInterf;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> csInterf;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool> const> degraded;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>> const> issues;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> recoveredDiskFiles;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Generation requestGeneration;
															#line 622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass processClass;
															#line 623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>> scInterf;
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheProcessFuture;
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheErrorsFuture;
															#line 627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<double> incorrectTime;
															#line 628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool firstReg;
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ClusterConnectionString storedConnectionString;
															#line 631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool upToDate;
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool ccInterfacePresent;
															#line 699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<RegisterWorkerReply> registrationReply;
															#line 702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> recovered;
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double startTime;
															#line 4313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registrationClient()
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActor final : public Actor<Void>, public ActorCallback< RegistrationClientActor, 0, bool >, public ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >, public ActorCallback< RegistrationClientActor, 2, Void >, public ActorCallback< RegistrationClientActor, 3, Void >, public ActorCallback< RegistrationClientActor, 4, Void >, public ActorCallback< RegistrationClientActor, 5, Void >, public ActorCallback< RegistrationClientActor, 6, Void >, public ActorCallback< RegistrationClientActor, 7, Void >, public ActorCallback< RegistrationClientActor, 8, Void >, public ActorCallback< RegistrationClientActor, 9, Void >, public ActorCallback< RegistrationClientActor, 10, Void >, public ActorCallback< RegistrationClientActor, 11, Void >, public FastAllocated<RegistrationClientActor>, public RegistrationClientActorState<RegistrationClientActor> {
															#line 4318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegistrationClientActor>::operator new;
	using FastAllocated<RegistrationClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1323823117527770880UL, 17109020212468497664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegistrationClientActor, 0, bool >;
friend struct ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >;
friend struct ActorCallback< RegistrationClientActor, 2, Void >;
friend struct ActorCallback< RegistrationClientActor, 3, Void >;
friend struct ActorCallback< RegistrationClientActor, 4, Void >;
friend struct ActorCallback< RegistrationClientActor, 5, Void >;
friend struct ActorCallback< RegistrationClientActor, 6, Void >;
friend struct ActorCallback< RegistrationClientActor, 7, Void >;
friend struct ActorCallback< RegistrationClientActor, 8, Void >;
friend struct ActorCallback< RegistrationClientActor, 9, Void >;
friend struct ActorCallback< RegistrationClientActor, 10, Void >;
friend struct ActorCallback< RegistrationClientActor, 11, Void >;
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 4346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegistrationClientActorState<RegistrationClientActor>(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853273321946395648UL, 10112439968674810368UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registrationClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegistrationClientActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registrationClient( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf, Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf, Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf, Reference<AsyncVar<bool> const> const& degraded, Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<std::set<std::string>> const> const& issues, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, ConfigBroadcastInterface const& configBroadcastInterface, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, Promise<Void> const& recoveredDiskFiles, Reference<AsyncVar<Optional<UID>>> const& clusterId ) {
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegistrationClientActor(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 4380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary DC.
bool addressInDbAndPrimaryDc(
    const NetworkAddress& address,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	const auto& dbi = dbInfo->get();

	if (dbi.master.addresses().contains(address)) {
		return true;
	}

	if (dbi.distributor.present() && dbi.distributor.get().address() == address) {
		return true;
	}

	if (dbi.ratekeeper.present() && dbi.ratekeeper.get().address() == address) {
		return true;
	}

	if (dbi.consistencyScan.present() && dbi.consistencyScan.get().address() == address) {
		return true;
	}

	for (const auto& resolver : dbi.resolvers) {
		if (resolver.address() == address) {
			return true;
		}
	}

	for (const auto& grvProxy : dbi.client.grvProxies) {
		if (grvProxy.addresses().contains(address)) {
			return true;
		}
	}

	for (const auto& commitProxy : dbi.client.commitProxies) {
		if (commitProxy.addresses().contains(address)) {
			return true;
		}
	}

	auto localityIsInPrimaryDc = [&dbInfo](const LocalityData& locality) {
		return locality.dcId() == dbInfo->get().master.locality.dcId();
	};

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		for (const auto& tlog : logSet.tLogs) {
			if (!tlog.present()) {
				continue;
			}

			if (!localityIsInPrimaryDc(tlog.interf().filteredLocality)) {
				continue;
			}

			if (tlog.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndPrimaryDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndPrimaryDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimaryDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase829()
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase829Actor>
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase829ActorState {
															#line 4471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase829ActorState(UnitTestParameters const& params) 
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase829ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 832 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress testAddress(IPAddress(0x13131313), 1);
															#line 838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.getCommitVersion = RequestStream<struct GetCommitVersionRequest>(Endpoint({ testAddress }, UID(1, 2)));
															#line 842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.clear();
															#line 863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(testAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress grvProxyAddress(IPAddress(0x26262626), 1);
															#line 867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GrvProxyInterface grvProxyInterf;
															#line 868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			grvProxyInterf.getConsistentReadVersion = PublicRequestStream<struct GetReadVersionRequest>(Endpoint({ grvProxyAddress }, UID(1, 2)));
															#line 870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.grvProxies.push_back(grvProxyInterf);
															#line 871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(grvProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress commitProxyAddress(IPAddress(0x37373737), 1);
															#line 874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CommitProxyInterface commitProxyInterf;
															#line 875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			commitProxyInterf.commit = PublicRequestStream<struct CommitTransactionRequest>(Endpoint({ commitProxyAddress }, UID(1, 2)));
															#line 877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.commitProxies.push_back(commitProxyInterf);
															#line 878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(commitProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase829Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase829ActorState(); static_cast<FlowTestCase829Actor*>(this)->destroy(); return 0; }
															#line 4555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase829Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase829ActorState();
			static_cast<FlowTestCase829Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase829()
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase829Actor final : public Actor<Void>, public FastAllocated<FlowTestCase829Actor>, public FlowTestCase829ActorState<FlowTestCase829Actor> {
															#line 4584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase829Actor>::operator new;
	using FastAllocated<FlowTestCase829Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6306671431450214400UL, 17620155553012141568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase829Actor(UnitTestParameters const& params) 
															#line 4600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase829ActorState<FlowTestCase829Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6821780616658211840UL, 3970267137474583040UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase829");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase829( UnitTestParameters const& params ) {
															#line 829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase829Actor(params));
															#line 4631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase829, "/fdbserver/worker/addressInDbAndPrimaryDc")

#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary
// satellite DC.
bool addressInDbAndPrimarySatelliteDc(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	for (const auto& logSet : dbInfo->get().logSystemConfig.tLogs) {
		if (logSet.isLocal && logSet.locality == tagLocalitySatellite) {
			for (const auto& tlog : logSet.tLogs) {
				if (tlog.present() && tlog.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

bool addressesInDbAndPrimarySatelliteDc(const NetworkAddressList& addresses,
                                        Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return addressInDbAndPrimarySatelliteDc(addresses.address, dbInfo) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimarySatelliteDc(addresses.secondaryAddress.get(), dbInfo));
}

namespace {

															#line 4664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase910()
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase910Actor>
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase910ActorState {
															#line 4670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase910ActorState(UnitTestParameters const& params) 
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase910", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase910ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase910", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(testLocal);
															#line 928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimarySatelliteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress primaryTLogAddress(IPAddress(0x26262626), 1);
															#line 935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface primaryTLog(testLocal);
															#line 938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.initEndpoints();
															#line 939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ primaryTLogAddress }, UID(1, 2)));
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(primaryTLog));
															#line 941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(primaryTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress remoteTLogAddress(IPAddress(0x37373737), 1);
															#line 945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTLog(fakeRemote);
															#line 948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.initEndpoints();
															#line 949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ remoteTLogAddress }, UID(1, 2)));
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTLog));
															#line 954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(remoteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase910Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase910ActorState(); static_cast<FlowTestCase910Actor*>(this)->destroy(); return 0; }
															#line 4758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase910Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase910ActorState();
			static_cast<FlowTestCase910Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase910ActorState();
		static_cast<FlowTestCase910Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase910()
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase910Actor final : public Actor<Void>, public FastAllocated<FlowTestCase910Actor>, public FlowTestCase910ActorState<FlowTestCase910Actor> {
															#line 4787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase910Actor>::operator new;
	using FastAllocated<FlowTestCase910Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16679132737185166336UL, 6366686583614095104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase910Actor(UnitTestParameters const& params) 
															#line 4803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase910ActorState<FlowTestCase910Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase910", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16177281170459039488UL, 5293316813954853632UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase910Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase910");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase910", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase910( UnitTestParameters const& params ) {
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase910Actor(params));
															#line 4834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase910, "/fdbserver/worker/addressInDbAndPrimarySatelliteDc")

#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressInDbAndRemoteDc(const NetworkAddress& address,
                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                            Optional<std::vector<NetworkAddress>> storageServers) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (logSet.isLocal || logSet.locality == tagLocalitySatellite) {
			continue;
		}
		for (const auto& tlog : logSet.tLogs) {
			if (tlog.present() && tlog.interf().addresses().contains(address)) {
				return true;
			}
		}

		for (const auto& logRouter : logSet.logRouters) {
			if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndRemoteDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndRemoteDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndRemoteDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase1002()
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1002Actor>
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1002ActorState {
															#line 4889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1002ActorState(UnitTestParameters const& params) 
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1002", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1002ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1002", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 1017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 1018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 1042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(fakeRemote);
															#line 1044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 1045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 1046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 1047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1002Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1002ActorState(); static_cast<FlowTestCase1002Actor*>(this)->destroy(); return 0; }
															#line 4979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1002Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1002ActorState();
			static_cast<FlowTestCase1002Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1002ActorState();
		static_cast<FlowTestCase1002Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1002()
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1002Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1002Actor>, public FlowTestCase1002ActorState<FlowTestCase1002Actor> {
															#line 5008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1002Actor>::operator new;
	using FastAllocated<FlowTestCase1002Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7638290895837961728UL, 4697750913614000384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1002Actor(UnitTestParameters const& params) 
															#line 5024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1002ActorState<FlowTestCase1002Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1002", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14884871858206216448UL, 689444859799607296UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1002Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1002");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1002", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1002( UnitTestParameters const& params ) {
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1002Actor(params));
															#line 5055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1002, "/fdbserver/worker/addressInDbAndRemoteDc")

#line 1051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressIsRemoteLogRouter(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (!logSet.isLocal) {
			for (const auto& logRouter : logSet.logRouters) {
				if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

namespace {

															#line 5081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase1072()
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1072Actor>
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1072ActorState {
															#line 5087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1072ActorState(UnitTestParameters const& params) 
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 5094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1072", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1072ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1072", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface<TLogInterface>());
															#line 1083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1086 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localLogRouter(testLocal);
															#line 1087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localLogRouter.initEndpoints();
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(localLogRouter));
															#line 1089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressIsRemoteLogRouter(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1072Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1072ActorState(); static_cast<FlowTestCase1072Actor*>(this)->destroy(); return 0; }
															#line 5161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1072Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1072ActorState();
			static_cast<FlowTestCase1072Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1072ActorState();
		static_cast<FlowTestCase1072Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1072()
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1072Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1072Actor>, public FlowTestCase1072ActorState<FlowTestCase1072Actor> {
															#line 5190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1072Actor>::operator new;
	using FastAllocated<FlowTestCase1072Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14653318569144043520UL, 11796027070563226624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1072Actor(UnitTestParameters const& params) 
															#line 5206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1072ActorState<FlowTestCase1072Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1072", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3711116882087347712UL, 4577280375825823744UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1072Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1072");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1072", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1072( UnitTestParameters const& params ) {
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1072Actor(params));
															#line 5237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1072, "/fdbserver/worker/addressIsRemoteLogRouter")

#line 1112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if the `peer` has enough measurement samples that should be checked by the health monitor.
bool shouldCheckPeer(Reference<Peer> peer) {
	TraceEvent(SevDebug, "ShouldCheckPeer")
	    .suppressFor(0.1)
	    .detail("ConnectFailedCount", peer->connectFailedCount)
	    .detail("PingLatencyPopulationSize", peer->pingLatencies.getPopulationSize());

	if (peer->connectFailedCount != 0) {
		return true;
	}

	if (peer->pingLatencies.getPopulationSize() >= SERVER_KNOBS->PEER_LATENCY_CHECK_MIN_POPULATION) {
		// Ignore peers that don't have enough samples.
		// TODO(zhewu): Currently, FlowTransport latency monitor clears ping latency samples on a
		// regular basis, which may affect the measurement count. Currently,
		// WORKER_HEALTH_MONITOR_INTERVAL is much smaller than the ping clearance interval, so it may be
		// ok. If this ends to be a problem, we need to consider keep track of last ping latencies
		// logged.
		return true;
	}

	return false;
}

// Returns true if `address` is a degraded/disconnected peer in `lastReq` sent to CC.
bool isDegradedPeer(const UpdateWorkerHealthRequest& lastReq, const NetworkAddress& address) {
	if (std::find(lastReq.degradedPeers.begin(), lastReq.degradedPeers.end(), address) != lastReq.degradedPeers.end()) {
		return true;
	}

	if (std::find(lastReq.disconnectedPeers.begin(), lastReq.disconnectedPeers.end(), address) !=
	    lastReq.disconnectedPeers.end()) {
		return true;
	}

	return false;
}

struct PrimaryAndRemoteAddresses {
	std::vector<NetworkAddress> primary;
	std::vector<NetworkAddress> remote;
};

// Check if the current worker is a transaction worker, and is experiencing degraded or disconnected peers.
UpdateWorkerHealthRequest doPeerHealthCheck(const WorkerInterface& interf,
                                            const LocalityData& locality,
                                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                                            const UpdateWorkerHealthRequest& lastReq,
                                            Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck,
                                            Optional<PrimaryAndRemoteAddresses> storageServers) {
	const auto& allPeers = FlowTransport::transport().getAllPeers();

	// Check remote log router connectivity only when remote TLogs are recruited and in use.
	bool checkRemoteLogRouterConnectivity = dbInfo->get().recoveryState == RecoveryState::ALL_LOGS_RECRUITED ||
	                                        dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED;
	UpdateWorkerHealthRequest req;

	enum WorkerLocation { None, Primary, Satellite, Remote };
	WorkerLocation workerLocation = None;
	if (addressesInDbAndPrimaryDc(interf.addresses(),
	                              dbInfo,
	                              storageServers.present() ? storageServers.get().primary
	                                                       : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Primary;
	} else if (addressesInDbAndRemoteDc(interf.addresses(),
	                                    dbInfo,
	                                    storageServers.present() ? storageServers.get().remote
	                                                             : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Remote;
	} else if (addressesInDbAndPrimarySatelliteDc(interf.addresses(), dbInfo)) {
		workerLocation = Satellite;
	}

	TraceEvent(SevInfo, "DoPeerHealthCheck")
	    .detail("WorkerLocation", workerLocation)
	    .detail("StorageServersPresent", storageServers.present())
	    .detail("StorageServersPrimarySize",
	            storageServers.present() ? std::to_string(storageServers.get().primary.size()) : "NA")
	    .detail("StorageServersRemoteSize",
	            storageServers.present() ? std::to_string(storageServers.get().remote.size()) : "NA");

	if (workerLocation == None && !enablePrimaryTxnSystemHealthCheck->get()) {
		// This worker doesn't need to monitor anything if it is not in transaction system or in remote satellite.
		return req;
	}

	for (const auto& [address, peer] : allPeers) {
		if (!shouldCheckPeer(peer)) {
			continue;
		}

		bool degradedPeer = false;
		bool disconnectedPeer = false;

		// If peer->lastLoggedTime == 0, we just started monitor this peer and haven't logged it once yet.
		double lastLoggedTime = peer->lastLoggedTime <= 0.0 ? peer->lastConnectTime : peer->lastLoggedTime;

		TraceEvent(SevDebug, "PeerHealthMonitor")
		    .suppressFor(5.0)
		    .detail("Peer", address)
		    .detail("PeerAddress", address)
		    .detail("Force", enablePrimaryTxnSystemHealthCheck->get())
		    .detail("Elapsed", now() - lastLoggedTime)
		    .detail("Disconnected", disconnectedPeer)
		    .detail("MinLatency", peer->pingLatencies.min())
		    .detail("MaxLatency", peer->pingLatencies.max())
		    .detail("MeanLatency", peer->pingLatencies.mean())
		    .detail("MedianLatency", peer->pingLatencies.median())
		    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
		    .detail("CheckedPercentileLatency",
		            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
		    .detail("PingCount", peer->pingLatencies.getPopulationSize())
		    .detail("PingTimeoutCount", peer->timeoutCount)
		    .detail("ConnectionFailureCount", peer->connectFailedCount)
		    .detail("WorkerLocation", workerLocation)
		    .detail("PeerInPrimaryDc", addressInDbAndPrimaryDc(address, dbInfo))
		    .detail("PeerInRemoteDc", addressInDbAndRemoteDc(address, dbInfo))
		    .detail("PeerInPrimarySatelliteDc", addressInDbAndPrimarySatelliteDc(address, dbInfo))
		    .detail("PeerIsRemoteLogRouter", addressIsRemoteLogRouter(address, dbInfo));

		if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
		    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo))) {
			// Monitors intra DC latencies between servers that in the primary or remote DC's transaction
			// systems. Note that currently we are not monitor storage servers, since lagging in storage
			// servers today already can trigger server exclusion by data distributor.

			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}
			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) {
			// Monitors inter DC latencies between servers in primary and primary satellite DC. Note that
			// TLog workers in primary satellite DC are on the critical path of serving a commit.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD_SATELLITE ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}

			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Satellite", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
		           addressIsRemoteLogRouter(address, dbInfo)) {
			// Monitor remote log router's connectivity to the primary DCs' transaction system. We ignore
			// latency based degradation between primary region and remote region due to that remote region
			// may be distant from primary region.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("RemoteLogRouter", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		} else if (enablePrimaryTxnSystemHealthCheck->get() &&
		           (addressInDbAndPrimaryDc(address, dbInfo) || addressInDbAndPrimarySatelliteDc(address, dbInfo))) {
			// For force checking, we only detect connection timeout. Currently this should only be used during recovery
			// and only used in TLogs.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("ExtensiveConnectivityCheck", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		}

		if (disconnectedPeer) {
			req.disconnectedPeers.push_back(address);
		} else if (degradedPeer) {
			req.degradedPeers.push_back(address);
		} else if (isDegradedPeer(lastReq, address)) {
			TraceEvent("HealthMonitorDetectRecoveredPeer").detail("Peer", address).detail("PeerAddress", address);
			req.recoveredPeers.push_back(address);
		}
	}

	if (SERVER_KNOBS->WORKER_HEALTH_REPORT_RECENT_DESTROYED_PEER) {
		// When the worker cannot connect to a remote peer, the peer maybe erased from the list returned
		// from getAllPeers(). Therefore, we also look through all the recent closed peers in the flow
		// transport's health monitor. Note that all the closed peers stored here are caused by connection
		// failure, but not normal connection close. Therefore, we report all such peers if they are also
		// part of the transaction sub system.
		// Note that we don't need to calculate recovered peer in this case since all the recently closed peers are
		// considered permanently closed peers.
		for (const auto& address : FlowTransport::transport().healthMonitor()->getRecentClosedPeers()) {
			if (allPeers.find(address) != allPeers.end()) {
				// We have checked this peer in the above for loop.
				continue;
			}

			if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
			    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo)) ||
			    (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) ||
			    (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
			     addressIsRemoteLogRouter(address, dbInfo))) {
				TraceEvent("HealthMonitorDetectRecentClosedPeer")
				    .suppressFor(30)
				    .detail("Peer", address)
				    .detail("PeerAddress", address);
				req.disconnectedPeers.push_back(address);
			}
		}
	}

	if (g_network->isSimulated()) {
		// Invariant check in simulation: for any peers that shouldn't be checked, we won't include it in the
		// UpdateWorkerHealthRequest sent to CC.
		for (const auto& [address, peer] : allPeers) {
			if (!shouldCheckPeer(peer)) {
				for (const auto& disconnectedPeer : req.disconnectedPeers) {
					ASSERT(address != disconnectedPeer);
				}
				for (const auto& degradedPeer : req.degradedPeers) {
					ASSERT(address != degradedPeer);
				}
				for (const auto& recoveredPeer : req.recoveredPeers) {
					ASSERT(address != recoveredPeer);
				}
			}
		}
	}

	return req;
}

static Optional<Standalone<StringRef>> getPrimaryDCId(const ServerDBInfo& dbInfo) {
	return dbInfo.master.locality.dcId();
}

// Makes a "best effort" to return the network addresses of primary and remote storage servers.
// Both primary and secondary (if present) addresses are returned.
// This actor makes a network call, and if that call fails, an empty optional is returned in addition to a
// TraceEvent being logged. Intentionally, this actor does not implement a retry policy, but the client can
// choose to retry by waiting on this actor again.
															#line 5539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class GetStorageServersActor>
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActorState {
															#line 5546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ret(),
															#line 1412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   tr(db)
															#line 5559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 1417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<GetStorageServersActor*>(this)));
															#line 5588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<Optional<PrimaryAndRemoteAddresses>>::futures) { (void)(ret); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 5617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< Optional<PrimaryAndRemoteAddresses> >::value()) Optional<PrimaryAndRemoteAddresses>(std::move(ret)); // state_var_RVO
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("GetStorageServersError").error(e);
															#line 5634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 1419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 1432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					{
															#line 1434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 1419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 1432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					{
															#line 1434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> ret;
															#line 1412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Transaction tr;
															#line 5848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getStorageServers()
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActor final : public Actor<Optional<PrimaryAndRemoteAddresses>>, public ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 5853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15046524002273795584UL, 9575185485095182848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<PrimaryAndRemoteAddresses>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 5870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Optional<PrimaryAndRemoteAddresses>>(),
		   GetStorageServersActorState<GetStorageServersActor>(db, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Optional<PrimaryAndRemoteAddresses>> getStorageServers( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Optional<PrimaryAndRemoteAddresses>>(new GetStorageServersActor(db, dbInfo));
															#line 5903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// The actor that actively monitors the health of local and peer servers, and reports anomaly to the cluster controller.
															#line 5909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via healthMonitor()
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HealthMonitorActor>
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActorState {
															#line 5916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   enablePrimaryTxnSystemHealthCheck(enablePrimaryTxnSystemHealthCheck),
															#line 1453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(),
															#line 1454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db()
															#line 5935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	~HealthMonitorActorState() 
	{
		fdb_probe_actor_destroy("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN || SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN)
															#line 5950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				db = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 5954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 1459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 5958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMonitorActorState();
		static_cast<HealthMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		nextHealthCheckDelay = Never();
															#line 1461 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const RecoveryState& recoveryState = dbInfo->get().recoveryState;
															#line 1462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool primaryTxnSystemHealthCheckEnabled = enablePrimaryTxnSystemHealthCheck->get();
															#line 1463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool ccInterfacePresent = ccInterface->get().present();
															#line 1464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerHealthMonitor") .detail("DBInfoRecoveryState", recoveryState) .detail("PrimaryTxnSystemHealthCheckEnabled", primaryTxnSystemHealthCheckEnabled) .detail("CCInterfacePresent", ccInterface->get().present());
															#line 1468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if ((recoveryState >= RecoveryState::ACCEPTING_COMMITS || primaryTxnSystemHealthCheckEnabled) && ccInterfacePresent)
															#line 5998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			nextHealthCheckDelay = delay(SERVER_KNOBS->WORKER_HEALTH_MONITOR_INTERVAL);
															#line 1471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			storageServers = Optional<PrimaryAndRemoteAddresses>();
															#line 1472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (db.present())
															#line 6006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(storageServers, getStorageServers(db.get(), dbInfo));
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<HealthMonitorActor*>(this)->actor_wait_state = 1;
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 0, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextHealthCheckDelay;
															#line 1498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ccInterface->onChange();
															#line 6042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
															#line 1501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dbInfo->onChange();
															#line 6046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
															#line 1502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = enablePrimaryTxnSystemHealthCheck->onChange();
															#line 6050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
		static_cast<HealthMonitorActor*>(this)->actor_wait_state = 2;
															#line 1499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 1, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 2, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 3, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 4, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req = doPeerHealthCheck(interf, locality, dbInfo, req, enablePrimaryTxnSystemHealthCheck, storageServers);
															#line 1477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!req.disconnectedPeers.empty() || !req.degradedPeers.empty() || !req.recoveredPeers.empty())
															#line 6072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (g_network->isSimulated())
															#line 6076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for( const auto& recoveredPeer : req.recoveredPeers ) {
															#line 1482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& disconnectedPeer : req.disconnectedPeers ) {
															#line 1483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != disconnectedPeer);
															#line 6084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
															#line 1485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& degradedPeer : req.degradedPeers ) {
															#line 1486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != degradedPeer);
															#line 6090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.address = FlowTransport::transport().getLocalAddress();
															#line 1493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (ccInterface->get().present())
															#line 6098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ccInterface->get().get().updateWorkerHealth.send(req);
															#line 6102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 1, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 2, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 3, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 1453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateWorkerHealthRequest req;
															#line 1454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Database> db;
															#line 1460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> nextHealthCheckDelay;
															#line 1471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> storageServers;
															#line 6505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via healthMonitor()
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActor final : public Actor<Void>, public ActorCallback< HealthMonitorActor, 0, Void >, public ActorCallback< HealthMonitorActor, 1, Void >, public ActorCallback< HealthMonitorActor, 2, Void >, public ActorCallback< HealthMonitorActor, 3, Void >, public ActorCallback< HealthMonitorActor, 4, Void >, public FastAllocated<HealthMonitorActor>, public HealthMonitorActorState<HealthMonitorActor> {
															#line 6510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<HealthMonitorActor>::operator new;
	using FastAllocated<HealthMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15895800487172240640UL, 7354634521184567808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMonitorActor, 0, Void >;
friend struct ActorCallback< HealthMonitorActor, 1, Void >;
friend struct ActorCallback< HealthMonitorActor, 2, Void >;
friend struct ActorCallback< HealthMonitorActor, 3, Void >;
friend struct ActorCallback< HealthMonitorActor, 4, Void >;
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 6531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HealthMonitorActorState<HealthMonitorActor>(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11146410862898602752UL, 8671132782290732288UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMonitorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> healthMonitor( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck ) {
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HealthMonitorActor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 6565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
// A set of threads that should be profiled
std::set<std::thread::id> profiledThreads;

// Returns whether or not a given thread should be profiled
int filter_in_thread(void* arg) {
	return profiledThreads.contains(std::this_thread::get_id()) ? 1 : 0;
}
#endif

// Enables the calling thread to be profiled
void registerThreadForProfiling() {
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
	// Not sure if this is actually needed, but a call to backtrace was advised here:
	// http://groups.google.com/group/google-perftools/browse_thread/thread/0dfd74532e038eb8/2686d9f24ac4365f?pli=1
	profiledThreads.insert(std::this_thread::get_id());
	const int num_levels = 100;
	void* pc[num_levels];
	backtrace(pc, num_levels);
#endif
}

// Starts or stops the CPU profiler
void updateCpuProfiler(ProfilerRequest req) {
	switch (req.type) {
	case ProfilerRequest::Type::GPROF:
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE: {
			const char* path = (const char*)req.outputFile.begin();
			ProfilerOptions* options = new ProfilerOptions();
			options->filter_in_thread = &filter_in_thread;
			options->filter_in_thread_arg = nullptr;
			ProfilerStartWithOptions(path, options);
			break;
		}
		case ProfilerRequest::Action::DISABLE:
			ProfilerStop();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
#endif
		break;
	case ProfilerRequest::Type::FLOW:
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE:
			startProfiling(g_network, {}, req.outputFile);
			break;
		case ProfilerRequest::Action::DISABLE:
			stopProfiling();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
		break;
	default:
		ASSERT(false);
		break;
	}
}

															#line 6634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runCpuProfiler()
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunCpuProfilerActor>
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActorState {
															#line 6641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActorState(ProfilerRequest const& req) 
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunCpuProfilerActorState() 
	{
		fdb_probe_actor_destroy("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.action == ProfilerRequest::Action::RUN)
															#line 6663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.action = ProfilerRequest::Action::ENABLE;
															#line 1574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(req.duration);
															#line 1575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 1;
															#line 1575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCpuProfilerActor, 0, Void >*>(static_cast<RunCpuProfilerActor*>(this)));
															#line 6678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunCpuProfilerActorState();
				static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunCpuProfilerActor*>(this)->ActorCallback< RunCpuProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCpuProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 6819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runCpuProfiler()
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActor final : public Actor<Void>, public ActorCallback< RunCpuProfilerActor, 0, Void >, public FastAllocated<RunCpuProfilerActor>, public RunCpuProfilerActorState<RunCpuProfilerActor> {
															#line 6824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunCpuProfilerActor>::operator new;
	using FastAllocated<RunCpuProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3632475214648528640UL, 11601942844281136384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCpuProfilerActor, 0, Void >;
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActor(ProfilerRequest const& req) 
															#line 6841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunCpuProfilerActorState<RunCpuProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9421576084395799552UL, 13013016949884672512UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCpuProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCpuProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runCpuProfiler( ProfilerRequest const& req ) {
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunCpuProfilerActor(req));
															#line 6874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

void runHeapProfiler(const char* msg) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	if (IsHeapProfilerRunning()) {
		HeapProfilerDump(msg);
	} else {
		TraceEvent("ProfilerError").detail("Message", "HeapProfiler not running");
	}
#else
	TraceEvent("ProfilerError").detail("Message", "HeapProfiler Unsupported");
#endif
}

															#line 6891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runProfiler()
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunProfilerActor>
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActorState {
															#line 6898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActorState(ProfilerRequest const& req) 
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunProfilerActorState() 
	{
		fdb_probe_actor_destroy("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.type == ProfilerRequest::Type::GPROF_HEAP)
															#line 6920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				runHeapProfiler("User triggered heap dump");
															#line 6924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = runCpuProfiler(req);
															#line 1601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunProfilerActor*>(this)->actor_wait_state = 1;
															#line 1601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunProfilerActor, 0, Void >*>(static_cast<RunProfilerActor*>(this)));
															#line 6938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunProfilerActorState(); static_cast<RunProfilerActor*>(this)->destroy(); return 0; }
															#line 6962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<RunProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunProfilerActor*>(this)->ActorCallback< RunProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 7059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runProfiler()
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActor final : public Actor<Void>, public ActorCallback< RunProfilerActor, 0, Void >, public FastAllocated<RunProfilerActor>, public RunProfilerActorState<RunProfilerActor> {
															#line 7064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunProfilerActor>::operator new;
	using FastAllocated<RunProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8944510623631013888UL, 17645367912805995264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunProfilerActor, 0, Void >;
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActor(ProfilerRequest const& req) 
															#line 7081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunProfilerActorState<RunProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14649713953804097280UL, 18193392918468773120UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runProfiler( ProfilerRequest const& req ) {
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunProfilerActor(req));
															#line 7114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

bool checkHighMemory(int64_t threshold, bool* error) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	*error = false;
	uint64_t page_size = sysconf(_SC_PAGESIZE);
	int fd = open("/proc/self/statm", O_RDONLY | O_CLOEXEC);
	if (fd < 0) {
		TraceEvent("OpenStatmFileFailure").log();
		*error = true;
		return false;
	}

	const int buf_sz = 256;
	char stat_buf[buf_sz];
	ssize_t stat_nread = read(fd, stat_buf, buf_sz);
	if (stat_nread < 0) {
		TraceEvent("ReadStatmFileFailure").log();
		*error = true;
		return false;
	}

	uint64_t vmsize, rss;
	sscanf(stat_buf, "%lu %lu", &vmsize, &rss);
	rss *= page_size;
	if (rss >= threshold) {
		return true;
	}
#else
	TraceEvent("CheckHighMemoryUnsupported").log();
	*error = true;
#endif
	return false;
}

// Runs heap profiler when RSS memory usage is high.
															#line 7153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorHighMemory()
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorHighMemoryActor>
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActorState {
															#line 7160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActorState(int64_t const& threshold) 
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : threshold(threshold)
															#line 7167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	~MonitorHighMemoryActorState() 
	{
		fdb_probe_actor_destroy("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (threshold <= 0)
															#line 7182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MonitorHighMemoryActorState();
				static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool err = false;
															#line 1647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool highmem = checkHighMemory(threshold, &err);
															#line 1648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err)
															#line 7240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (highmem)
															#line 7246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			runHeapProfiler("Highmem heap dump");
															#line 7250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->HEAP_PROFILER_INTERVAL);
															#line 1653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 1;
															#line 1653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorHighMemoryActor, 0, Void >*>(static_cast<MonitorHighMemoryActor*>(this)));
															#line 7261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state > 0) static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHighMemoryActor*>(this)->ActorCallback< MonitorHighMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t threshold;
															#line 7368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorHighMemory()
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActor final : public Actor<Void>, public ActorCallback< MonitorHighMemoryActor, 0, Void >, public FastAllocated<MonitorHighMemoryActor>, public MonitorHighMemoryActorState<MonitorHighMemoryActor> {
															#line 7373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorHighMemoryActor>::operator new;
	using FastAllocated<MonitorHighMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9577021049817285120UL, 10376060001004288768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorHighMemoryActor, 0, Void >;
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActor(int64_t const& threshold) 
															#line 7390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorHighMemoryActorState<MonitorHighMemoryActor>(threshold),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3552868021743521024UL, 13539544626851908096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorHighMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorHighMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorHighMemory( int64_t const& threshold ) {
															#line 1641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorHighMemoryActor(threshold));
															#line 7423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

struct StorageDiskCleaner {
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	Future<Void> future;
};

struct TrackRunningStorage {
	UID self;
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;

	TrackRunningStorage(UID self,
	                    KeyValueStoreType storeType,
	                    LocalityData locality,
	                    const std::string& filename,
	                    std::set<std::pair<UID, KeyValueStoreType>>* runningStorages,
	                    std::unordered_map<UID, StorageDiskCleaner>* storageCleaners)
	  : self(self), storeType(storeType), locality(locality), filename(filename), runningStorages(runningStorages),
	    storageCleaners(storageCleaners) {
		TraceEvent("StorageServerAddedToRunningStorage", self);
		runningStorages->emplace(self, storeType);
	}
	~TrackRunningStorage() {
		runningStorages->erase(std::make_pair(self, storeType));
		TraceEvent("StorageServerRemoveFromRunningStorage", self);

		// Start a disk cleaner except for tss data store
		try {
			if (basename(filename).find(testingStoragePrefix.toString()) != 0) {
				if (!storageCleaners->contains(self)) {
					StorageDiskCleaner cleaner;
					cleaner.storeType = storeType;
					cleaner.locality = locality;
					cleaner.filename = filename;
					cleaner.future = Void(); // cleaner task will start later
					storageCleaners->insert({ self, cleaner });
					TraceEvent("AddStorageCleaner", self).detail("Size", storageCleaners->size());
				}
			}
		} catch (Error& e) {
			TraceEvent("SkipStorageCleaner", self).error(e).detail("File", filename);
		}
	};
};

															#line 7477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class StorageServerRollbackRebooterActor>
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActorState {
															#line 7484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActorState(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore) 
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : runningStorages(runningStorages),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners(storageCleaners),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   prevStorageServer(prevStorageServer),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeType(storeType),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   isTss(isTss),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db(db),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(filesClosed),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   store(store),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   validateDataFiles(validateDataFiles),
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVStore(rebootKVStore),
															#line 1722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _(id, storeType, locality, filename, runningStorages, storageCleaners)
															#line 7521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerRollbackRebooterActorState() 
	{
		fdb_probe_actor_destroy("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7536 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerRollbackRebooterActorState();
		static_cast<StorageServerRollbackRebooterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(prevStorageServer);
															#line 1724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 1;
															#line 1724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 1731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 1731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = id;
															#line 1764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 1768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 1774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 1778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 1779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 1785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 1786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 1787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(store->getError());
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = storageServer(store, recruited, db, folder, Promise<Void>(), Reference<IClusterConnectionRecord>(nullptr));
															#line 1792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = handleIOErrors(prevStorageServer, storeError, id, store->onClosed());
															#line 7811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> prevStorageServer;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool isTss;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection* filesClosed;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* store;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void>* rebootKVStore;
															#line 1722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TrackRunningStorage _;
															#line 7957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActor final : public Actor<Void>, public ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >, public ActorCallback< StorageServerRollbackRebooterActor, 1, Void >, public FastAllocated<StorageServerRollbackRebooterActor>, public StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor> {
															#line 7962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<StorageServerRollbackRebooterActor>::operator new;
	using FastAllocated<StorageServerRollbackRebooterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12535225116487855360UL, 1179293519996751872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< StorageServerRollbackRebooterActor, 1, Void >;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActor(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore) 
															#line 7980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor>(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9711723034093058560UL, 17546821082729568512UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerRollbackRebooter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> storageServerRollbackRebooter( std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages, std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners, Future<Void> const& prevStorageServer, KeyValueStoreType const& storeType, std::string const& filename, UID const& id, LocalityData const& locality, bool const& isTss, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& folder, ActorCollection* const& filesClosed, int64_t const& memoryLimit, IKeyValueStore* const& store, bool const& validateDataFiles, Promise<Void>* const& rebootKVStore ) {
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new StorageServerRollbackRebooterActor(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore));
															#line 8014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// FIXME:  This will not work correctly in simulation as all workers would share the same roles map
std::set<std::pair<std::string, std::string>> g_roles;

Standalone<StringRef> roleString(std::set<std::pair<std::string, std::string>> roles, bool with_ids) {
	std::string result;
	for (auto& r : roles) {
		if (!result.empty())
			result.append(",");
		result.append(r.first);
		if (with_ids) {
			result.append(":");
			result.append(r.second);
		}
	}
	return StringRef(result);
}

void startRole(const Role& role,
               UID roleId,
               UID workerId,
               const std::map<std::string, std::string>& details,
               const std::string& origination) {
	if (role.includeInTraceRoles) {
		addTraceRole(role.abbreviation);
	}

	TraceEvent ev("Role", roleId);
	ev.detail("As", role.roleName)
	    .detail("Transition", "Begin")
	    .detail("Origination", origination)
	    .detail("OnWorker", workerId);
	for (auto it = details.begin(); it != details.end(); it++)
		ev.detail(it->first.c_str(), it->second);

	ev.trackLatest(roleId.shortString() + ".Role");

	// Update roles map, log Roles metrics
	g_roles.insert({ role.roleName, roleId.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->addRole(g_network->getLocalAddress(), role.roleName);
}

void endRole(const Role& role, UID id, std::string reason, bool ok, Error e) {
	{
		TraceEvent ev("Role", id);
		if (e.code() != invalid_error_code)
			ev.errorUnsuppressed(e);
		ev.detail("Transition", "End").detail("As", role.roleName).detail("Reason", reason);

		ev.trackLatest(id.shortString() + ".Role");
	}

	if (!ok) {
		std::string type = role.roleName + "Failed";

		TraceEvent err(SevError, type.c_str(), id);
		if (e.code() != invalid_error_code) {
			err.errorUnsuppressed(e);
		}
		err.detail("Reason", reason);
	}

	latestEventCache.clear(id.shortString());

	// Update roles map, log Roles metrics
	g_roles.erase({ role.roleName, id.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->removeRole(g_network->getLocalAddress(), role.roleName);

	if (role.includeInTraceRoles) {
		removeTraceRole(role.abbreviation);
	}
}

															#line 8097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via traceRole()
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TraceRoleActor>
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActorState {
															#line 8104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActorState(Role const& role,UID const& roleId) 
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : role(role),
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   roleId(roleId)
															#line 8113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("traceRole", reinterpret_cast<unsigned long>(this));

	}
	~TraceRoleActorState() 
	{
		fdb_probe_actor_destroy("traceRole", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRoleActorState();
		static_cast<TraceRoleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL);
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRoleActor*>(this)->actor_wait_state = 1;
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRoleActor, 0, Void >*>(static_cast<TraceRoleActor*>(this)));
															#line 8165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state > 0) static_cast<TraceRoleActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRoleActor*>(this)->ActorCallback< TraceRoleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRoleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID roleId;
															#line 8267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via traceRole()
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActor final : public Actor<Void>, public ActorCallback< TraceRoleActor, 0, Void >, public FastAllocated<TraceRoleActor>, public TraceRoleActorState<TraceRoleActor> {
															#line 8272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<TraceRoleActor>::operator new;
	using FastAllocated<TraceRoleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10964435169998253056UL, 3787827387758068224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRoleActor, 0, Void >;
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActor(Role const& role,UID const& roleId) 
															#line 8289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TraceRoleActorState<TraceRoleActor>(role, roleId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14398465994869201920UL, 9614722329871585280UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRole");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRoleActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> traceRole( Role const& role, UID const& roleId ) {
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new TraceRoleActor(role, roleId));
															#line 8322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 8327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerSnapCreate()
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerSnapCreateActor>
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActorState {
															#line 8334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActorState(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : snapReq(snapReq),
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapFolder(snapFolder),
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(snapReqMap),
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(snapReqResultMap),
															#line 1887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapArg(snapReq.snapPayload),
															#line 1888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqKey(snapReq.snapUID.toString() + snapReq.role.toString())
															#line 8351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~WorkerSnapCreateActorState() 
	{
		fdb_probe_actor_destroy("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<int> __when_expr_0 = execHelper(&snapArg, snapReq.snapUID, snapFolder, snapReq.role.toString());
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 1;
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerSnapCreateActor, 0, int >*>(static_cast<WorkerSnapCreateActor*>(this)));
															#line 8374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<WorkerSnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerSnapCreateActorState(); static_cast<WorkerSnapCreateActor*>(this)->destroy(); return 0; }
															#line 8403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<WorkerSnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ExecHelperError").errorUnsuppressed(e);
															#line 1909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 8418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->at(snapReqKey).reply.sendError(e);
															#line 1911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->erase(snapReqKey);
															#line 1912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(e);
															#line 8426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& err,int loopDepth) 
	{
															#line 1891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int && err,int loopDepth) 
	{
															#line 1891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& err,int loopDepth) 
	{
		loopDepth = a_body1cont2(err, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && err,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(err), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state > 0) static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerSnapCreateActor*>(this)->ActorCallback< WorkerSnapCreateActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerSnapCreateActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapFolder;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest>* snapReqMap;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>>* snapReqResultMap;
															#line 1887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExecCmdValueString snapArg;
															#line 1888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapReqKey;
															#line 8610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerSnapCreate()
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActor final : public Actor<Void>, public ActorCallback< WorkerSnapCreateActor, 0, int >, public FastAllocated<WorkerSnapCreateActor>, public WorkerSnapCreateActorState<WorkerSnapCreateActor> {
															#line 8615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerSnapCreateActor>::operator new;
	using FastAllocated<WorkerSnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18015163868428462848UL, 5842660889690344960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerSnapCreateActor, 0, int >;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActor(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 8632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerSnapCreateActorState<WorkerSnapCreateActor>(snapReq, snapFolder, snapReqMap, snapReqResultMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10166740224002249728UL, 13188349297975825664UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerSnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerSnapCreateActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerSnapCreate( WorkerSnapRequest const& snapReq, std::string const& snapFolder, std::map<std::string, WorkerSnapRequest>* const& snapReqMap, std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap ) {
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerSnapCreateActor(snapReq, snapFolder, snapReqMap, snapReqResultMap));
															#line 8665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// TODO: `issues` is right now only updated by `monitorTraceLogIssues` and thus is being `set` on every update.
// It could be changed to `insert` and `trigger` later if we want to use it as a generic way for the caller of this
// function to report issues to cluster controller.
															#line 8673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorTraceLogIssuesActor>
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActorState {
															#line 8680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActorState(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : issues(issues),
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   pingTimeout(false)
															#line 8689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	~MonitorTraceLogIssuesActorState() 
	{
		fdb_probe_actor_destroy("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorTraceLogIssuesActorState();
		static_cast<MonitorTraceLogIssuesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TRACE_LOG_FLUSH_FAILURE_CHECK_INTERVAL_SECONDS);
															#line 1926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 1;
															#line 1926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		try {
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		try {
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::set<std::string> _issues;
															#line 1938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retrieveTraceLogIssues(_issues);
															#line 1939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (pingTimeout)
															#line 8881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			_issues.insert("trace_log_writer_thread_unresponsive");
															#line 1942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			pingTimeout = false;
															#line 8887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 1944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		issues->set(_issues);
															#line 8891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 8901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				pingTimeout = true;
															#line 8905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool pingTimeout;
															#line 9027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActor final : public Actor<Void>, public ActorCallback< MonitorTraceLogIssuesActor, 0, Void >, public ActorCallback< MonitorTraceLogIssuesActor, 1, Void >, public FastAllocated<MonitorTraceLogIssuesActor>, public MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor> {
															#line 9032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorTraceLogIssuesActor>::operator new;
	using FastAllocated<MonitorTraceLogIssuesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15472225142847015936UL, 14403796625517263872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorTraceLogIssuesActor, 0, Void >;
friend struct ActorCallback< MonitorTraceLogIssuesActor, 1, Void >;
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActor(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 9050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor>(issues),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17589411279920321024UL, 1269187454341278720UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorTraceLogIssues");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorTraceLogIssues( Reference<AsyncVar<std::set<std::string>>> const& issues ) {
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorTraceLogIssuesActor(issues));
															#line 9084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

class SharedLogsKey {
	TLogVersion logVersion;
	TLogSpillType spillType;
	KeyValueStoreType storeType;

public:
	SharedLogsKey(const TLogOptions& options, KeyValueStoreType kvst)
	  : logVersion(options.version), spillType(options.spillType), storeType(kvst) {
		if (logVersion >= TLogVersion::V5)
			spillType = TLogSpillType::UNSET;
	}

	bool operator<(const SharedLogsKey& other) const {
		return std::tie(logVersion, spillType, storeType) <
		       std::tie(other.logVersion, other.spillType, other.storeType);
	}
};

struct SharedLogsValue {
	Future<Void> actor = Void();
	UID uid = UID();
	PromiseStream<InitializeTLogRequest> requests;

	SharedLogsValue() = default;
	SharedLogsValue(Future<Void> actor, UID uid, PromiseStream<InitializeTLogRequest> requests)
	  : actor(actor), uid(uid), requests(requests) {}
};

															#line 9117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via chaosMetricsLogger()
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ChaosMetricsLoggerActor>
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActorState {
															#line 9124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActorState() 
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 9130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		fdb_probe_actor_create("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~ChaosMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto res = g_network->global(INetwork::enChaosMetrics);
															#line 1979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!res)
															#line 9146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 1980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<ChaosMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChaosMetricsLoggerActorState(); static_cast<ChaosMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 9150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<ChaosMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ChaosMetricsLoggerActorState();
				static_cast<ChaosMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics = static_cast<ChaosMetrics*>(res);
															#line 1983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics->clear();
															#line 1985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChaosMetricsLoggerActorState();
		static_cast<ChaosMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(FLOW_KNOBS->CHAOS_LOGGING_INTERVAL);
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChaosMetricsLoggerActor, 0, Void >*>(static_cast<ChaosMetricsLoggerActor*>(this)));
															#line 9199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 1989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 1991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 1993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 1989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 1991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 1993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosMetricsLoggerActor*>(this)->ActorCallback< ChaosMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetrics* chaosMetrics;
															#line 9319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via chaosMetricsLogger()
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActor final : public Actor<Void>, public ActorCallback< ChaosMetricsLoggerActor, 0, Void >, public FastAllocated<ChaosMetricsLoggerActor>, public ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor> {
															#line 9324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChaosMetricsLoggerActor>::operator new;
	using FastAllocated<ChaosMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6175950309403756288UL, 1614160267370635264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChaosMetricsLoggerActor, 0, Void >;
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActor() 
															#line 9341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11301253459754392576UL, 10330861438325872384UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chaosMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChaosMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> chaosMetricsLogger(  ) {
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ChaosMetricsLoggerActor());
															#line 9374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

static const std::string clusterIdFilename = "clusterId";

															#line 9381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via createClusterIdFile()
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CreateClusterIdFileActor>
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActorState {
															#line 9388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActorState(std::string const& folder,UID const& clusterId) 
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterIdPath(joinPath(folder, clusterIdFilename))
															#line 9399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateClusterIdFileActorState() 
	{
		fdb_probe_actor_destroy("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (fileExists(clusterIdPath))
															#line 9414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateClusterIdFileActorState();
				static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open( clusterIdPath, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_LOCK, 0600));
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 1;
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 2030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!e.isInjectedFault())
															#line 9488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				fprintf(stderr, "ERROR: error creating or opening cluster id file `%s'.\n", joinPath(folder, clusterIdFilename).c_str());
															#line 9492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 2035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "OpenClusterIdError").error(e);
															#line 2036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (clusterIdFile.isError() && clusterIdFile.getError().code() == error_code_file_not_found && !fileExists(clusterIdPath))
															#line 9512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( clusterIdPath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_LOCK | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 2;
															#line 2012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1loopBody1Catch1(clusterIdFile.getError(), loopDepth);
															#line 9530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> const& __clusterIdFile,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = __clusterIdFile;
															#line 9539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> && __clusterIdFile,int loopDepth) 
	{
		clusterIdFile = std::move(__clusterIdFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
															#line 2017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
															#line 2017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_clusterIdFile, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_clusterIdFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9755 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID clusterId;
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string clusterIdPath;
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Reference<IAsyncFile>> clusterIdFile;
															#line 9947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via createClusterIdFile()
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActor final : public Actor<Void>, public ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CreateClusterIdFileActor, 2, Void >, public ActorCallback< CreateClusterIdFileActor, 3, Void >, public FastAllocated<CreateClusterIdFileActor>, public CreateClusterIdFileActorState<CreateClusterIdFileActor> {
															#line 9952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<CreateClusterIdFileActor>::operator new;
	using FastAllocated<CreateClusterIdFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17193113103025093120UL, 6529683559522375168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateClusterIdFileActor, 2, Void >;
friend struct ActorCallback< CreateClusterIdFileActor, 3, Void >;
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActor(std::string const& folder,UID const& clusterId) 
															#line 9972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CreateClusterIdFileActorState<CreateClusterIdFileActor>(folder, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2623832799678928640UL, 8068581988244134144UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createClusterIdFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> createClusterIdFile( std::string const& folder, UID const& clusterId ) {
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CreateClusterIdFileActor(folder, clusterId));
															#line 10008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Updates this processes cluster ID based off the cluster ID received in the
// ServerDBInfo. Persists the cluster ID to disk if it does not already exist.
															#line 10015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateClusterId()
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class UpdateClusterIdActor>
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActorState {
															#line 10022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActorState(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccClusterId(ccClusterId),
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder)
															#line 10033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateClusterIdActorState() 
	{
		fdb_probe_actor_destroy("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!clusterId->get().present() && ccClusterId.isValid())
															#line 10048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = createClusterIdFile(folder, ccClusterId);
															#line 2045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 1;
															#line 2045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterIdActor, 0, Void >*>(static_cast<UpdateClusterIdActor*>(this)));
															#line 10059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<UpdateClusterIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateClusterIdActorState(); static_cast<UpdateClusterIdActor*>(this)->destroy(); return 0; }
															#line 10087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<UpdateClusterIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterIdActor*>(this)->ActorCallback< UpdateClusterIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateClusterIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID ccClusterId;
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 10194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateClusterId()
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActor final : public Actor<Void>, public ActorCallback< UpdateClusterIdActor, 0, Void >, public FastAllocated<UpdateClusterIdActor>, public UpdateClusterIdActorState<UpdateClusterIdActor> {
															#line 10199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateClusterIdActor>::operator new;
	using FastAllocated<UpdateClusterIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10504474745140006144UL, 7433219439790666752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateClusterIdActor, 0, Void >;
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActor(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 10216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateClusterIdActorState<UpdateClusterIdActor>(ccClusterId, clusterId, folder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10009873598315805184UL, 15517297218935779072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateClusterId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateClusterIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> updateClusterId( UID const& ccClusterId, Reference<AsyncVar<Optional<UID>>> const& clusterId, std::string const& folder ) {
															#line 2043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new UpdateClusterIdActor(ccClusterId, clusterId, folder));
															#line 10249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 10254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via deleteStorageFile()
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class DeleteStorageFileActor>
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActorState {
															#line 10261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActorState(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : storeType(storeType),
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   kvs(openKVStore(storeType, filename, storeID, memoryLimit, false, false, false, dbInfo, {}))
															#line 10278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	~DeleteStorageFileActorState() 
	{
		fdb_probe_actor_destroy("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(kvs->init());
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 1;
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteStorageFileActor, 0, Void >*>(static_cast<DeleteStorageFileActor*>(this)));
															#line 10300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state > 0) static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteStorageFileActor*>(this)->ActorCallback< DeleteStorageFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteStorageFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* kvs;
															#line 10446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via deleteStorageFile()
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActor final : public Actor<Void>, public ActorCallback< DeleteStorageFileActor, 0, Void >, public FastAllocated<DeleteStorageFileActor>, public DeleteStorageFileActorState<DeleteStorageFileActor> {
															#line 10451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<DeleteStorageFileActor>::operator new;
	using FastAllocated<DeleteStorageFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(410998972352783872UL, 6134833759015874560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteStorageFileActor, 0, Void >;
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActor(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 10468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DeleteStorageFileActorState<DeleteStorageFileActor>(storeType, filename, storeID, memoryLimit, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7303347310383014400UL, 15168961707397160448UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteStorageFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteStorageFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> deleteStorageFile( KeyValueStoreType const& storeType, std::string const& filename, UID const& storeID, int64_t const& memoryLimit, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new DeleteStorageFileActor(storeType, filename, storeID, memoryLimit, dbInfo));
															#line 10501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 10506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CleanupStaleStorageDiskActor>
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActorState {
															#line 10513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : dbInfo(dbInfo),
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaners(cleaners),
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaner(cleaner),
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   retries(0)
															#line 10530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	~CleanupStaleStorageDiskActorState() 
	{
		fdb_probe_actor_destroy("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 10545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (retries > SERVER_KNOBS->STORAGE_DISK_CLEANUP_MAX_RETRIES)
															#line 10576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").detail("Filename", cleaner.filename).detail("StoreID", storeID);
															#line 2075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerLivenessCheck").detail("StoreID", storeID).detail("Retry", retries);
															#line 2079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<CommitProxyInfo> commitProxies(new CommitProxyInfo(dbInfo->get().client.commitProxies));
															#line 2080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (commitProxies->size() == 0)
															#line 10594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").log();
															#line 2082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GetStorageServerRejoinInfoRequest request(storeID, cleaner.locality.dcId());
															#line 2085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<GetStorageServerRejoinInfoReply> __when_expr_0 = basicLoadBalance(commitProxies, &CommitProxyInterface::getStorageServerRejoinInfo, request);
															#line 2085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 1;
															#line 2085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->STORAGE_DISK_CLEANUP_RETRY_INTERVAL);
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 3;
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 10649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (fileExists(cleaner.filename))
															#line 10653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StrictFuture<Void> __when_expr_1 = deleteStorageFile(cleaner.storeType, cleaner.filename, storeID, memoryLimit, dbInfo);
															#line 2094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 2;
															#line 2094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
															#line 2088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
															#line 2088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 2098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		cleaners->erase(storeID);
															#line 2099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* cleaners;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageDiskCleaner cleaner;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int retries;
															#line 10997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActor final : public Actor<Void>, public ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >, public ActorCallback< CleanupStaleStorageDiskActor, 1, Void >, public ActorCallback< CleanupStaleStorageDiskActor, 2, Void >, public FastAllocated<CleanupStaleStorageDiskActor>, public CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor> {
															#line 11002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<CleanupStaleStorageDiskActor>::operator new;
	using FastAllocated<CleanupStaleStorageDiskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13835603277140090368UL, 11289236659616476416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 1, Void >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 2, Void >;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 11021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor>(dbInfo, cleaners, storeID, cleaner, memoryLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10954477009460037888UL, 11591692359139200000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupStaleStorageDisk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> cleanupStaleStorageDisk( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, std::unordered_map<UID, StorageDiskCleaner>* const& cleaners, UID const& storeID, StorageDiskCleaner const& cleaner, int64_t const& memoryLimit ) {
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CleanupStaleStorageDiskActor(dbInfo, cleaners, storeID, cleaner, memoryLimit));
															#line 11056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Delete storage server data files if it's not alive anymore
void cleanupStorageDisks(Reference<AsyncVar<ServerDBInfo>> dbInfo,
                         std::unordered_map<UID, StorageDiskCleaner>& storageCleaners,
                         int64_t memoryLimit) {
	for (auto& cleaner : storageCleaners) {
		if (cleaner.second.future.isReady()) {
			CODE_PROBE(true, "Cleanup stale disk stores for double recruitment");
			cleaner.second.future =
			    cleanupStaleStorageDisk(dbInfo, &storageCleaners, cleaner.first, cleaner.second, memoryLimit);
		}
	}
}

bool skipInitRspInSim(const UID workerInterfID, const bool allowDropInSim) {
	const bool skip = allowDropInSim && g_network->isSimulated() && BUGGIFY_WITH_PROB(/* 1% */ 0.01);
	if (skip) {
		TraceEvent("SkipInitRspInSimTrue").detail("WorkerInterfID", workerInterfID);
	}
	return skip;
}

#ifdef FLOW_GRPC_ENABLED
															#line 11083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor>
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActorState {
															#line 11090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActorState(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActorState() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (GrpcServer::instance() == nullptr)
															#line 11114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				this->~RegisterWorkerGrpcServicesActorState();
															#line 11118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			else
			{
															#line 2131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 11126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					this->~RegisterWorkerGrpcServicesActorState();
															#line 11130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
					return 0;
				}
			}
															#line 2135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto db = Database::createDatabase(ccr, ApiVersion::LATEST_VERSION);
															#line 2136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = safeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(db));
															#line 2136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 1;
															#line 2136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*>(static_cast<RegisterWorkerGrpcServicesActor*>(this)));
															#line 11146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActorState();
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> const& idb,int loopDepth) 
	{
															#line 2137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{ std::make_shared<fdbctl::ControlServiceImpl>(idb) };
															#line 2138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> && idb,int loopDepth) 
	{
															#line 2137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{ std::make_shared<fdbctl::ControlServiceImpl>(idb) };
															#line 2138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(idb, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(idb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor final : public Actor<Void>, public ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >, public FastAllocated<RegisterWorkerGrpcServicesActor>, public RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor> {
															#line 11281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15398183239703470336UL, 15039173205126116096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >;
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11091973658458607872UL, 4923644862601870848UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor(id, ccr));
															#line 11331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
#else
															#line 11336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor1>
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1State {
															#line 11343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1State(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActor1State() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			this->~RegisterWorkerGrpcServicesActor1State();
															#line 11367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActor1State();
		static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1 final : public Actor<Void>, public FastAllocated<RegisterWorkerGrpcServicesActor1>, public RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1> {
															#line 11396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15398183239703470336UL, 15039173205126116096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6368418377314189568UL, 12623130874699170304UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor1(id, ccr));
															#line 11444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 2146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
#endif

															#line 11450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerServer()
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerServerActor>
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActorState {
															#line 11457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActorState(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : connRecord(connRecord),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccInterface(ccInterface),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsConnFile(metricsConnFile),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsPrefix(metricsPrefix),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryProfileThreshold(memoryProfileThreshold),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _coordFolder(_coordFolder),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   consistencyCheckUrgentMode(consistencyCheckUrgentMode),
															#line 2166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errors(),
															#line 2167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(new AsyncVar<Optional<DataDistributorInterface>>()),
															#line 2169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(new AsyncVar<Optional<RatekeeperInterface>>()),
															#line 2170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(new AsyncVar<Optional<ConsistencyScanInterface>>()),
															#line 2172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   handleErrors(workerHandleErrors(errors.getFuture())),
															#line 2173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errorForwarders(false),
															#line 2174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingTrigger(Void()),
															#line 2175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingDelay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL),
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise(),
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise2(),
															#line 2179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(true),
															#line 2180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   stopping(),
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsLogger(),
															#line 2182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   chaosMetricsActor(),
															#line 2183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(FlowTransport::transport().getDegraded()),
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sharedLogs(),
															#line 2190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   activeSharedTLog(new AsyncVar<UID>()),
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   backupWorkerCache(),
															#line 2192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   logRouterCache(),
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   blobWorkerFuture(Void()),
															#line 2195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapReq(),
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(),
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(),
															#line 2199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapTime(-SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP),
															#line 2200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   coordFolder(abspath(_coordFolder)),
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(locality),
															#line 2204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   runningStorages(),
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners()
															#line 11554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerServer", reinterpret_cast<unsigned long>(this));

	}
	~WorkerServerActorState() 
	{
		fdb_probe_actor_destroy("workerServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			interf.initEndpoints();
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			issues = Reference<AsyncVar<std::set<std::string>>>(new AsyncVar<std::set<std::string>>());
															#line 2215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			updateClusterIdFuture = Future<Void>();
															#line 2219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			enablePrimaryTxnSystemHealthCheck = makeReference<AsyncVar<bool>>(false);
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 1;
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 0, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 11584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerServerActorState();
		static_cast<WorkerServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
				try {
															#line 2234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
				try {
															#line 2234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(resetAfter(degraded, SERVER_KNOBS->DEGRADED_RESET_INTERVAL, false, SERVER_KNOBS->DEGRADED_WARNING_LIMIT, SERVER_KNOBS->DEGRADED_WARNING_RESET_DELAY, "DegradedReset"));
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(loadedPonger(interf.debugPing.getFuture()));
															#line 2258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(waitFailureServer(interf.waitFailure.getFuture()));
															#line 2259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorTraceLogIssues(issues));
															#line 2260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( testerServerCore(interf.testerInterface, connRecord, dbInfo, locality, consistencyCheckUrgentMode ? "ConsistencyCheckUrgent" : Optional<std::string>()));
															#line 2266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorHighMemory(memoryProfileThreshold));
															#line 2268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(stopping.getFuture());
															#line 2270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		initializeSystemMonitorMachineState(SystemMonitorMachineState(folder, locality.dcId(), locality.zoneId(), locality.machineId(), locality.dataHallId(), g_network->getLocalAddress().ip, FDB_VT_VERSION));
															#line 11824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto recruited = interf;
															#line 2280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.reboot);
															#line 2281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.profiler);
															#line 2282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.tLog);
															#line 2283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.master);
															#line 2284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commitProxy);
															#line 2285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.grvProxy);
															#line 2286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.resolver);
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.storage);
															#line 2288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.debugPing);
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.coordinationPing);
															#line 2290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.setMetricsRate);
															#line 2292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.eventLogRequest);
															#line 2293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.traceBatchDumpRequest);
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.updateServerDBInfo);
															#line 11858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries = std::vector<Future<Void>>();
															#line 11862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		try {
															#line 2300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			stores = getDiskStores(folder);
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			validateDataFiles = deleteFile(joinPath(folder, validationFilename));
															#line 2302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			index = 0;
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 11872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "TDMetricsBadClusterFile").error(e).detail("ConnFile", metricsConnFile);
															#line 11900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 3182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for( auto f : recoveries ) {
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				f.cancel();
															#line 11931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 3184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = err;
															#line 3185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_actor_cancelled || e.code() == error_code_please_reboot_delete || e.code() == error_code_local_config_changed || e.code() == error_code_invalid_cluster_id;
															#line 3188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			endRole(Role::WORKER, interf.id(), "WorkerError", ok, e);
															#line 3189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.clear(false);
															#line 3190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			sharedLogs.clear();
															#line 3193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture.cancel();
															#line 3195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 11947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				stopping.send(Void());
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_28 = filesClosed.getResult();
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont2Catch1when1(__when_expr_28.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 6;
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 11960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 2462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["Locality"] = locality.toString();
															#line 2464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["DataFolder"] = folder;
															#line 2465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StoresPresent"] = format("%d", stores.size());
															#line 2467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::WORKER, interf.id(), interf.id(), details);
															#line 2468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(traceRole(Role::WORKER, interf.id()));
															#line 2480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recoveredDiskFiles;
															#line 2481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> recoverDiskFiles = trigger( [=]() { TraceEvent("DiskFileRecoveriesComplete", interf.id()); recoveredDiskFiles.send(Void()); }, waitForAll(recoveries));
															#line 2487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(recoverDiskFiles);
															#line 2489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(registrationClient(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 2506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (configNode.isValid())
															#line 12000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(brokenPromiseToNever(localConfig->consume(configBroadcastInterface)));
															#line 12004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (SERVER_KNOBS->ENABLE_WORKER_HEALTH_MONITOR)
															#line 12008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( healthMonitor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 12012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 12016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!(index < stores.size()))
															#line 12032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		s = stores[index];
															#line 2308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (s.storedComponent == DiskStore::Storage)
															#line 12040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (index >= 2 && SERVER_KNOBS->WORKER_START_STORAGE_DELAY > 0.0)
															#line 12044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->WORKER_START_STORAGE_DELAY);
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 2;
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 1, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont3(loopDepth);
			}
		}
		else
		{
															#line 2400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (s.storedComponent == DiskStore::TLogData)
															#line 12067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				LocalLineage _;
															#line 2402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::string logQueueBasename;
															#line 2404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const std::string filename = basename(s.filename);
															#line 2405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (StringRef(filename).startsWith(fileLogDataPrefix))
															#line 12079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString();
															#line 12083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StringRef optionsString = StringRef(filename).removePrefix(fileVersionedLogDataPrefix).eat("-");
															#line 2409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString() + optionsString.toString() + "-";
															#line 12091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
															#line 2411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT_WE_THINK(abspath(parentDirectory(s.filename)) == folder);
															#line 2412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IKeyValueStore* kv = openKVStore( s.storeType, s.filename, s.storeID, memoryLimit, validateDataFiles, false, false, dbInfo);
															#line 2414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const DiskQueueVersion dqv = s.tLogOptions.getDiskQueueVersion();
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const int64_t diskQueueWarnSize = s.tLogOptions.spillType == TLogSpillType::VALUE ? 10 * SERVER_KNOBS->TARGET_BYTES_PER_TLOG : -1;
															#line 2417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IDiskQueue* queue = openDiskQueue(joinPath(folder, logQueueBasename + s.storeID.toString() + "-"), tlogQueueExtension.toString(), s.storeID, dqv, diskQueueWarnSize);
															#line 2422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(kv->onClosed());
															#line 2423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(queue->onClosed());
															#line 2425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::map<std::string, std::string> details;
															#line 2426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				details["StorageEngine"] = s.storeType.toString();
															#line 2427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::SHARED_TRANSACTION_LOG, s.storeID, interf.id(), details, "Restored");
															#line 2429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> oldLog;
															#line 2430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> recovery;
															#line 2431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TLogFn tLogFn = tLogFnForOptions(s.tLogOptions);
															#line 2432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto& logData = sharedLogs[SharedLogsKey(s.tLogOptions, s.storeType)];
															#line 2433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.push_back(SharedLogsValue());
															#line 2437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> tl = tLogFn(kv, queue, dbInfo, locality, logData.back().requests, s.storeID, interf.id(), true, oldLog, recovery, folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				recoveries.push_back(recovery.getFuture());
															#line 2452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				activeSharedTLog->set(s.storeID);
															#line 2454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, kv, s.storeID);
															#line 2455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, queue, s.storeID);
															#line 2456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().actor = oldLog.getFuture() || tl;
															#line 2457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().uid = s.storeID;
															#line 2458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, s.storeID, tl));
															#line 12139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		++index;
															#line 12163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		IKeyValueStore* kv = openKVStore( s.storeType, s.filename, s.storeID, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( s.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && s.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, 0);
															#line 2332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> kvClosed = kv->onClosed() || rebootKVSPromise.getFuture();
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(kvClosed);
															#line 2338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string tssPrefix = testingStoragePrefix.toString();
															#line 2341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool isTss = s.filename.find(tssPrefix) != std::string::npos;
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 2345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = s.storeID;
															#line 2346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StorageEngine"] = s.storeType.toString();
															#line 2355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["IsTSS"] = isTss ? "Yes" : "No";
															#line 2357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(ssRole, recruited.id(), interf.id(), details, "Restored");
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 2361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 2362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 2364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 2365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 2366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 2369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 2373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 2375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 2376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(kv->getError());
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recovery;
															#line 2380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> f = storageServer(kv, recruited, dbInfo, folder, recovery, connRecord);
															#line 2381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries.push_back(recovery.getFuture());
															#line 2383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = handleIOErrors(f, storeError, s.storeID, kvClosed);
															#line 2384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = storageServerRollbackRebooter(&runningStorages, &storageCleaners, f, s.storeType, s.filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, kv, validateDataFiles, &rebootKVSPromise);
															#line 2399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(forwardError(errors, ssRole, recruited.id(), f));
															#line 12254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 2516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_2 = interf.updateServerDBInfo.getFuture();
															#line 12357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<UpdateServerDBInfoRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<UpdateServerDBInfoRequest>>::value, "invalid type");
															#line 2515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_2.pop(), loopDepth); };
															#line 2551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_3 = interf.clientInterface.reboot.getFuture();
															#line 12365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RebootRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RebootRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2(__when_expr_3.pop(), loopDepth); };
															#line 2582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_4 = interf.clientInterface.setFailureInjection.getFuture();
															#line 12370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<SetFailureInjection>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<SetFailureInjection>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3(__when_expr_4.pop(), loopDepth); };
															#line 2598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_5 = interf.clientInterface.profiler.getFuture();
															#line 12375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ProfilerRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ProfilerRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when4(__when_expr_5.pop(), loopDepth); };
															#line 2619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_6 = interf.master.getFuture();
															#line 12380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RecruitMasterRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RecruitMasterRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when5(__when_expr_6.pop(), loopDepth); };
															#line 2641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_7 = interf.dataDistributor.getFuture();
															#line 12385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<InitializeDataDistributorRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<InitializeDataDistributorRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when6(__when_expr_7.pop(), loopDepth); };
															#line 2667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_8 = interf.ratekeeper.getFuture();
															#line 12390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_8), FutureStream<InitializeRatekeeperRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<InitializeRatekeeperRequest>>::value, "invalid type");
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when7(__when_expr_8.pop(), loopDepth); };
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_9 = interf.consistencyScan.getFuture();
															#line 12395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_9), FutureStream<InitializeConsistencyScanRequest>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<InitializeConsistencyScanRequest>>::value, "invalid type");
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when8(__when_expr_9.pop(), loopDepth); };
															#line 2719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_10 = interf.backup.getFuture();
															#line 12400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_10), FutureStream<InitializeBackupRequest>>::value || std::is_same<decltype(__when_expr_10), ThreadFutureStream<InitializeBackupRequest>>::value, "invalid type");
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when9(__when_expr_10.pop(), loopDepth); };
															#line 2741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_11 = interf.tLog.getFuture();
															#line 12405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_11), FutureStream<InitializeTLogRequest>>::value || std::is_same<decltype(__when_expr_11), ThreadFutureStream<InitializeTLogRequest>>::value, "invalid type");
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont2Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when10(__when_expr_11.pop(), loopDepth); };
															#line 2810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_12 = interf.storage.getFuture();
															#line 12410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_12), FutureStream<InitializeStorageRequest>>::value || std::is_same<decltype(__when_expr_12), ThreadFutureStream<InitializeStorageRequest>>::value, "invalid type");
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont2Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when11(__when_expr_12.pop(), loopDepth); };
															#line 2949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_13 = interf.commitProxy.getFuture();
															#line 12415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_13), FutureStream<InitializeCommitProxyRequest>>::value || std::is_same<decltype(__when_expr_13), ThreadFutureStream<InitializeCommitProxyRequest>>::value, "invalid type");
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont2Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when12(__when_expr_13.pop(), loopDepth); };
															#line 2975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_14 = interf.grvProxy.getFuture();
															#line 12420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_14), FutureStream<InitializeGrvProxyRequest>>::value || std::is_same<decltype(__when_expr_14), ThreadFutureStream<InitializeGrvProxyRequest>>::value, "invalid type");
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont2Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when13(__when_expr_14.pop(), loopDepth); };
															#line 2997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_15 = interf.resolver.getFuture();
															#line 12425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_15), FutureStream<InitializeResolverRequest>>::value || std::is_same<decltype(__when_expr_15), ThreadFutureStream<InitializeResolverRequest>>::value, "invalid type");
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont2Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when14(__when_expr_15.pop(), loopDepth); };
															#line 3016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_16 = interf.logRouter.getFuture();
															#line 12430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_16), FutureStream<InitializeLogRouterRequest>>::value || std::is_same<decltype(__when_expr_16), ThreadFutureStream<InitializeLogRouterRequest>>::value, "invalid type");
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont2Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when15(__when_expr_16.pop(), loopDepth); };
															#line 3054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_17 = interf.coordinationPing.getFuture();
															#line 12435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_17), FutureStream<CoordinationPingMessage>>::value || std::is_same<decltype(__when_expr_17), ThreadFutureStream<CoordinationPingMessage>>::value, "invalid type");
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont2Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when16(__when_expr_17.pop(), loopDepth); };
															#line 3059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_18 = interf.setMetricsRate.getFuture();
															#line 12440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_18), FutureStream<SetMetricsLogRateRequest>>::value || std::is_same<decltype(__when_expr_18), ThreadFutureStream<SetMetricsLogRateRequest>>::value, "invalid type");
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont2Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when17(__when_expr_18.pop(), loopDepth); };
															#line 3068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_19 = interf.eventLogRequest.getFuture();
															#line 12445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_19), FutureStream<EventLogRequest>>::value || std::is_same<decltype(__when_expr_19), ThreadFutureStream<EventLogRequest>>::value, "invalid type");
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont2Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when18(__when_expr_19.pop(), loopDepth); };
															#line 3076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_20 = interf.traceBatchDumpRequest.getFuture();
															#line 12450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_20), FutureStream<TraceBatchDumpRequest>>::value || std::is_same<decltype(__when_expr_20), ThreadFutureStream<TraceBatchDumpRequest>>::value, "invalid type");
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont2Catch1(__when_expr_20.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when19(__when_expr_20.pop(), loopDepth); };
															#line 3080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_21 = interf.diskStoreRequest.getFuture();
															#line 12455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_21), FutureStream<DiskStoreRequest>>::value || std::is_same<decltype(__when_expr_21), ThreadFutureStream<DiskStoreRequest>>::value, "invalid type");
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont2Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when20(__when_expr_21.pop(), loopDepth); };
															#line 3121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_22 = loggingTrigger;
															#line 12460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont2Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when21(__when_expr_22.get(), loopDepth); };
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_23 = interf.workerSnapReq.getFuture();
															#line 12464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_23), FutureStream<WorkerSnapRequest>>::value || std::is_same<decltype(__when_expr_23), ThreadFutureStream<WorkerSnapRequest>>::value, "invalid type");
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont2Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when22(__when_expr_23.pop(), loopDepth); };
															#line 3177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_24 = errorForwarders.getResult();
															#line 12469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont2Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when23(__when_expr_24.get(), loopDepth); };
															#line 3178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_25 = handleErrors;
															#line 12473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont2Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when24(__when_expr_25.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 3;
															#line 2516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*>(static_cast<WorkerServerActor*>(this)));
															#line 2598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >*>(static_cast<WorkerServerActor*>(this)));
															#line 3059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 22, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 24, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 25, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest const& req,int loopDepth) 
	{
															#line 2517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2532 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest && req,int loopDepth) 
	{
															#line 2517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2532 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest const& req,int loopDepth) 
	{
															#line 2552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_26 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont2Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_26.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest && req,int loopDepth) 
	{
															#line 2552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_26 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont2Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_26.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection const& req,int loopDepth) 
	{
															#line 2583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2591 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 2593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection && req,int loopDepth) 
	{
															#line 2583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 2590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2591 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 2593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest const& req,int loopDepth) 
	{
															#line 2599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		try {
															#line 2605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest && req,int loopDepth) 
	{
															#line 2599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		try {
															#line 2605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest const& req,int loopDepth) 
	{
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 12929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest && req,int loopDepth) 
	{
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 12964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest const& req,int loopDepth) 
	{
															#line 2642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 12981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 12987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest && req,int loopDepth) 
	{
															#line 2642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest const& req,int loopDepth) 
	{
															#line 2668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest && req,int loopDepth) 
	{
															#line 2668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 2695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest && req,int loopDepth) 
	{
															#line 2695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest const& req,int loopDepth) 
	{
															#line 2720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest && req,int loopDepth) 
	{
															#line 2720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeTLogRequest const& req,int loopDepth) 
	{
															#line 2746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2755 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo);
															#line 2776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeTLogRequest && req,int loopDepth) 
	{
															#line 2746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2755 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo);
															#line 2776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeStorageRequest const& req,int loopDepth) 
	{
															#line 2811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2814 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, 0);
															#line 2903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 2915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 2916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder);
															#line 2924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 2925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2);
															#line 2940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 2943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeStorageRequest && req,int loopDepth) 
	{
															#line 2811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2814 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 2833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, 0);
															#line 2903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 2915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 2916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder);
															#line 2924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 2925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2);
															#line 2940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 2943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeCommitProxyRequest const& req,int loopDepth) 
	{
															#line 2950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 2952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 2953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 2954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 2955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 2959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 2961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 2962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 2963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 2964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 2965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 2968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 2973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeCommitProxyRequest && req,int loopDepth) 
	{
															#line 2950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 2952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 2953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 2954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 2955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 2959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 2961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 2962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 2963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 2964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 2965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 2968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 2973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeGrvProxyRequest const& req,int loopDepth) 
	{
															#line 2976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 2978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 2979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 2980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 2981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 2987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 2988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 2992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 2995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeGrvProxyRequest && req,int loopDepth) 
	{
															#line 2976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 2978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 2979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 2980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 2981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 2987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 2988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 2992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 2995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeResolverRequest const& req,int loopDepth) 
	{
															#line 2998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeResolverRequest && req,int loopDepth) 
	{
															#line 2998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeLogRouterRequest const& req,int loopDepth) 
	{
															#line 3017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!logRouterCache.exists(req.reqId))
															#line 14003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface recruited(locality);
															#line 3021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.peekMessages);
															#line 3027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.peekStreamMessages);
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.popMessages);
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commit);
															#line 3030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.lock);
															#line 3031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.confirmRunning);
															#line 3033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.recoveryFinished);
															#line 3035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.disablePopRequest);
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.enablePopRequest);
															#line 3037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.snapRequest);
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<TLogInterface> logRouterReady = req.reply;
															#line 3040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logRouterCache.set(req.reqId, logRouterReady.getFuture());
															#line 3041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> logRouterProcess = logRouter(recruited, req, dbInfo);
															#line 3042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logRouterProcess = logRouterCache.removeOnReady(req.reqId, logRouterProcess);
															#line 3043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouterProcess)));
															#line 3046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("LogRouterInitRequest", req.reqId).detail("LogRouterId", recruited.id());
															#line 3047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logRouterReady.send(recruited);
															#line 14059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 3051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, logRouterCache.get(req.reqId));
															#line 14066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeLogRouterRequest && req,int loopDepth) 
	{
															#line 3017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!logRouterCache.exists(req.reqId))
															#line 14076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface recruited(locality);
															#line 3021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.peekMessages);
															#line 3027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.peekStreamMessages);
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.popMessages);
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commit);
															#line 3030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.lock);
															#line 3031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.confirmRunning);
															#line 3033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.recoveryFinished);
															#line 3035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.disablePopRequest);
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.enablePopRequest);
															#line 3037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.snapRequest);
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<TLogInterface> logRouterReady = req.reply;
															#line 3040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logRouterCache.set(req.reqId, logRouterReady.getFuture());
															#line 3041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> logRouterProcess = logRouter(recruited, req, dbInfo);
															#line 3042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logRouterProcess = logRouterCache.removeOnReady(req.reqId, logRouterProcess);
															#line 3043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouterProcess)));
															#line 3046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("LogRouterInitRequest", req.reqId).detail("LogRouterId", recruited.id());
															#line 3047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logRouterReady.send(recruited);
															#line 14132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 3051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, logRouterCache.get(req.reqId));
															#line 14139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(CoordinationPingMessage const& m,int loopDepth) 
	{
															#line 3055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(CoordinationPingMessage && m,int loopDepth) 
	{
															#line 3055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(SetMetricsLogRateRequest const& req,int loopDepth) 
	{
															#line 3060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(SetMetricsLogRateRequest && req,int loopDepth) 
	{
															#line 3060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(EventLogRequest const& req,int loopDepth) 
	{
															#line 3069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 3074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(EventLogRequest && req,int loopDepth) 
	{
															#line 3069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 3074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(TraceBatchDumpRequest const& req,int loopDepth) 
	{
															#line 3077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(TraceBatchDumpRequest && req,int loopDepth) 
	{
															#line 3077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(DiskStoreRequest const& req,int loopDepth) 
	{
															#line 3081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 3093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					{
															#line 3094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
					else
					{
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
						{
															#line 3096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
						}
						else
						{
															#line 3097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
							{
															#line 3098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
							}
							else
							{
															#line 3100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14325 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
								{
															#line 3101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
								}
								else
								{
															#line 3103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									{
															#line 3104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									}
									else
									{
															#line 3106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									}
								}
							}
						}
					}
				}
															#line 3109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 3115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 3119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(DiskStoreRequest && req,int loopDepth) 
	{
															#line 3081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 3093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					{
															#line 3094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
					}
					else
					{
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
						{
															#line 3096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
						}
						else
						{
															#line 3097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
							{
															#line 3098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
							}
							else
							{
															#line 3100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
								{
															#line 3101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
								}
								else
								{
															#line 3103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									{
															#line 3104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									}
									else
									{
															#line 3106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
									}
								}
							}
						}
					}
				}
															#line 3109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
															#line 3115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
		}
															#line 3119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(Void const& _,int loopDepth) 
	{
															#line 3122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(Void && _,int loopDepth) 
	{
															#line 3122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(WorkerSnapRequest const& __snapReq,int loopDepth) 
	{
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReq = __snapReq;
															#line 3126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
															#line 3160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(WorkerSnapRequest && __snapReq,int loopDepth) 
	{
		snapReq = std::move(__snapReq);
															#line 3126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 3136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
															#line 3160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				{
															#line 3172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 3, RebootRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 22, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 24, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12loopBody1when2cont1(int loopDepth) 
	{
															#line 2570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (g_network->isSimulated())
															#line 14770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 2571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("SimulatedReboot").detail("Deletion", rebootReq.deleteData);
															#line 2572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (rebootReq.deleteData)
															#line 14776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			{
															#line 2573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont2Catch1(please_reboot_delete(), std::max(0, loopDepth - 1));
															#line 14780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			}
															#line 2575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1cont2Catch1(please_reboot(), std::max(0, loopDepth - 1));
															#line 14784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ProcessReboot").log();
															#line 2578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!rebootReq.deleteData);
															#line 2579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushAndExit(0);
															#line 14794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_27 = checkFile->sync();
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_27.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 14811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_27 = checkFile->sync();
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_27.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 14827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(checkFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(std::move(checkFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont12loopBody1when2cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			profilerReq.reply.sendError(e);
															#line 15119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >*,InitializeTLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >*,InitializeTLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >*,InitializeStorageRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >*,InitializeStorageRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >*,InitializeResolverRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >*,InitializeResolverRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >*,InitializeLogRouterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >*,InitializeLogRouterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >*,CoordinationPingMessage const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >*,CoordinationPingMessage && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >*,EventLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >*,EventLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >*,TraceBatchDumpRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >*,TraceBatchDumpRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >*,DiskStoreRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >*,DiskStoreRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >*,WorkerSnapRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >*,WorkerSnapRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont2Catch1cont1(int loopDepth) 
	{
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = deregisterGrpcService(interf.id());
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont2Catch1cont1when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 8;
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_29 = delay(0.0);
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_29.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void && _,int loopDepth) 
	{
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_29 = delay(0.0);
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_29.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont2Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 3202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont4(Void && _,int loopDepth) 
	{
															#line 3202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont2Catch1cont6(Void const& _,int loopDepth) 
	{
															#line 3206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2Catch1cont6(Void && _,int loopDepth) 
	{
															#line 3206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsConnFile;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsPrefix;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryProfileThreshold;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string _coordFolder;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string whitelistBinPaths;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool consistencyCheckUrgentMode;
															#line 2166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 2167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>>> ddInterf;
															#line 2169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>>> rkInterf;
															#line 2170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>>> csInterf;
															#line 2172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> handleErrors;
															#line 2173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection errorForwarders;
															#line 2174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> loggingTrigger;
															#line 2175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double loggingDelay;
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise;
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise2;
															#line 2179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection filesClosed;
															#line 2180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> stopping;
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> metricsLogger;
															#line 2182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> chaosMetricsActor;
															#line 2183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> degraded;
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<SharedLogsKey, std::vector<SharedLogsValue>> sharedLogs;
															#line 2190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<UID>> activeSharedTLog;
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerCache<InitializeBackupReply> backupWorkerCache;
															#line 2192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerCache<TLogInterface> logRouterCache;
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> blobWorkerFuture;
															#line 2195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest lastSnapReq;
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest> snapReqMap;
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>> snapReqResultMap;
															#line 2199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double lastSnapTime;
															#line 2200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string coordFolder;
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 2204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>> runningStorages;
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner> storageCleaners;
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 2215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> updateClusterIdFuture;
															#line 2219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> grpc;
															#line 2234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 2297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<Void>> recoveries;
															#line 2300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<DiskStore> stores;
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 2302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int index;
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DiskStore s;
															#line 2552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RebootRequest rebootReq;
															#line 2599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest profilerReq;
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 3184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Error e;
															#line 16767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerServer()
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActor final : public Actor<Void>, public ActorCallback< WorkerServerActor, 0, Void >, public ActorCallback< WorkerServerActor, 1, Void >, public ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >, public ActorSingleCallback< WorkerServerActor, 3, RebootRequest >, public ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >, public ActorCallback< WorkerServerActor, 27, Void >, public ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >, public ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >, public ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >, public ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >, public ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >, public ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >, public ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >, public ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >, public ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >, public ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >, public ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >, public ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >, public ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >, public ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >, public ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >, public ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >, public ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >, public ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >, public ActorCallback< WorkerServerActor, 22, Void >, public ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >, public ActorCallback< WorkerServerActor, 24, Void >, public ActorCallback< WorkerServerActor, 25, Void >, public ActorCallback< WorkerServerActor, 28, Void >, public ActorCallback< WorkerServerActor, 29, Void >, public ActorCallback< WorkerServerActor, 30, Void >, public FastAllocated<WorkerServerActor>, public WorkerServerActorState<WorkerServerActor> {
															#line 16772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerServerActor>::operator new;
	using FastAllocated<WorkerServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7670010157739880192UL, 10531269734729527808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerServerActor, 0, Void >;
friend struct ActorCallback< WorkerServerActor, 1, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 3, RebootRequest >;
friend struct ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >;
friend struct ActorCallback< WorkerServerActor, 27, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >;
friend struct ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 11, InitializeTLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 12, InitializeStorageRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 13, InitializeCommitProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 14, InitializeGrvProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 15, InitializeResolverRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 16, InitializeLogRouterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 17, CoordinationPingMessage >;
friend struct ActorSingleCallback< WorkerServerActor, 18, SetMetricsLogRateRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 19, EventLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 20, TraceBatchDumpRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 21, DiskStoreRequest >;
friend struct ActorCallback< WorkerServerActor, 22, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 23, WorkerSnapRequest >;
friend struct ActorCallback< WorkerServerActor, 24, Void >;
friend struct ActorCallback< WorkerServerActor, 25, Void >;
friend struct ActorCallback< WorkerServerActor, 28, Void >;
friend struct ActorCallback< WorkerServerActor, 29, Void >;
friend struct ActorCallback< WorkerServerActor, 30, Void >;
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActor(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 16819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerServerActorState<WorkerServerActor>(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18295874337252228096UL, 18130278596491120640UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkerServerActor, 26, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WorkerServerActor, 27, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WorkerServerActor, 28, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WorkerServerActor, 29, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WorkerServerActor, 30, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerServer( Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, LocalityData const& locality, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, std::string const& folder, int64_t const& memoryLimit, std::string const& metricsConnFile, std::string const& metricsPrefix, int64_t const& memoryProfileThreshold, std::string const& _coordFolder, std::string const& whitelistBinPaths, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, ConfigBroadcastInterface const& configBroadcastInterface, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, Reference<AsyncVar<Optional<UID>>> const& clusterId, bool const& consistencyCheckUrgentMode ) {
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerServerActor(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode));
															#line 16859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 3209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 16864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via extractClusterInterface()
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClusterInterfaceActor>
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActorState {
															#line 16871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : in(in),
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   out(out)
															#line 16880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClusterInterfaceActorState() 
	{
		fdb_probe_actor_destroy("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 16895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClusterInterfaceActorState();
		static_cast<ExtractClusterInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (in->get().present())
															#line 16925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			out->set(in->get().get().clientInterface);
															#line 16929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			out->set(Optional<ClusterInterface>());
															#line 16935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 3218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = in->onChange();
															#line 3218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 1;
															#line 3218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClusterInterfaceActor, 0, Void >*>(static_cast<ExtractClusterInterfaceActor*>(this)));
															#line 16946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state > 0) static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClusterInterfaceActor*>(this)->ActorCallback< ExtractClusterInterfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> in;
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterInterface>>> out;
															#line 17042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via extractClusterInterface()
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActor final : public Actor<Void>, public ActorCallback< ExtractClusterInterfaceActor, 0, Void >, public FastAllocated<ExtractClusterInterfaceActor>, public ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor> {
															#line 17047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExtractClusterInterfaceActor>::operator new;
	using FastAllocated<ExtractClusterInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16926869157810924288UL, 12363505754922217984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClusterInterfaceActor, 0, Void >;
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 17064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor>(in, out),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(557938279338987264UL, 16164323909019904512UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClusterInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClusterInterfaceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> extractClusterInterface( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in, Reference<AsyncVar<Optional<ClusterInterface>>> const& out ) {
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClusterInterfaceActor(in, out));
															#line 17097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 3221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

static std::set<int> const& normalWorkerErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_please_reboot);
		s.insert(error_code_please_reboot_delete);
		s.insert(error_code_local_config_changed);
		s.insert(error_code_invalid_cluster_id);
	}
	return s;
}

															#line 17113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via printTimeout()
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintTimeoutActor>
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActorState {
															#line 17120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActorState() 
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 17126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		fdb_probe_actor_create("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	~PrintTimeoutActorState() 
	{
		fdb_probe_actor_destroy("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(5);
															#line 3234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 1;
															#line 3234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintTimeoutActor, 0, Void >*>(static_cast<PrintTimeoutActor*>(this)));
															#line 17147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 3239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		{
															#line 3236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		}
															#line 3239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state > 0) static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<PrintTimeoutActor*>(this)->ActorCallback< PrintTimeoutActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via printTimeout()
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActor final : public Actor<Void>, public ActorCallback< PrintTimeoutActor, 0, Void >, public FastAllocated<PrintTimeoutActor>, public PrintTimeoutActorState<PrintTimeoutActor> {
															#line 17289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintTimeoutActor>::operator new;
	using FastAllocated<PrintTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12952178070050121472UL, 18420798152141543936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintTimeoutActor, 0, Void >;
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActor() 
															#line 17306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintTimeoutActorState<PrintTimeoutActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981782795374445824UL, 6705174968519855616UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> printTimeout(  ) {
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new PrintTimeoutActor());
															#line 17339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 3241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 17344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via printOnFirstConnected()
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintOnFirstConnectedActor>
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintOnFirstConnectedActorState {
															#line 17351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintOnFirstConnectedActorState(Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci) 
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ci(ci),
															#line 3243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   timeoutFuture(printTimeout())
															#line 17360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	~PrintOnFirstConnectedActorState() 
	{
		fdb_probe_actor_destroy("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ci->get().present() ? IFailureMonitor::failureMonitor().onStateEqual( ci->get().get().openDatabase.getEndpoint(), FailureStatus(false)) : Never();
															#line 3245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 3253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ci->onChange();
															#line 17411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 1;
															#line 3246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 0, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 3253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 1, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 17418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 3249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 3249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state > 0) static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 0;
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 0, Void >::remove();
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterInterface>> const> ci;
															#line 3243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> timeoutFuture;
															#line 17598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printOnFirstConnected()
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class PrintOnFirstConnectedActor final : public Actor<Void>, public ActorCallback< PrintOnFirstConnectedActor, 0, Void >, public ActorCallback< PrintOnFirstConnectedActor, 1, Void >, public FastAllocated<PrintOnFirstConnectedActor>, public PrintOnFirstConnectedActorState<PrintOnFirstConnectedActor> {
															#line 17603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintOnFirstConnectedActor>::operator new;
	using FastAllocated<PrintOnFirstConnectedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(143034246625844736UL, 13027590988493710336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintOnFirstConnectedActor, 0, Void >;
friend struct ActorCallback< PrintOnFirstConnectedActor, 1, Void >;
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PrintOnFirstConnectedActor(Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci) 
															#line 17621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintOnFirstConnectedActorState<PrintOnFirstConnectedActor>(ci),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7150920790306724352UL, 17823934316399614976UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printOnFirstConnected");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintOnFirstConnectedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> printOnFirstConnected( Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci ) {
															#line 3242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new PrintOnFirstConnectedActor(ci));
															#line 17654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
}

#line 3257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

ClusterControllerPriorityInfo getCCPriorityInfo(std::string filePath, ProcessClass processClass) {
	if (!fileExists(filePath))
		return ClusterControllerPriorityInfo(ProcessClass(processClass.classType(), ProcessClass::CommandLineSource)
		                                         .machineClassFitness(ProcessClass::ClusterController),
		                                     false,
		                                     ClusterControllerPriorityInfo::FitnessUnknown);
	std::string contents(readFileBytes(filePath, 1000));
	BinaryReader br(StringRef(contents), IncludeVersion());
	ClusterControllerPriorityInfo priorityInfo(
	    ProcessClass::UnsetFit, false, ClusterControllerPriorityInfo::FitnessUnknown);
	br >> priorityInfo;
	if (!br.empty()) {
		if (g_network->isSimulated()) {
			ASSERT(false);
		} else {
			TraceEvent(SevWarnAlways, "FitnessFileCorrupted").detail("filePath", filePath);
			return ClusterControllerPriorityInfo(ProcessClass(processClass.classType(), ProcessClass::CommandLineSource)
			                                         .machineClassFitness(ProcessClass::ClusterController),
			                                     false,
			                                     ClusterControllerPriorityInfo::FitnessUnknown);
		}
	}
	return priorityInfo;
}

															#line 17684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp.py_gen"
namespace {
// This generated cla