#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
/*
 * storageserver.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include <functional>
#include <iterator>
#include <limits>
#include <memory>
#include <type_traits>
#include <unordered_map>

#include "fdbclient/BulkLoading.h"
#include "fdbclient/Knobs.h"
#include "flow/ApiVersion.h"
#include "flow/Buggify.h"
#include "flow/Platform.h"
#include "flow/network.h"
#include "fmt/format.h"
#include "fdbclient/Audit.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/FDBTypes.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/LoadBalance.h"
#include "fdbserver/OTELSpanContextMessage.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/Hash3.h"
#include "flow/Histogram.h"
#include "flow/PriorityMultiLock.actor.h"
#include "flow/IRandom.h"
#include "flow/IndexedSet.h"
#include "flow/SystemMonitor.h"
#include "flow/Trace.h"
#include "fdbclient/Tracing.h"
#include "flow/Util.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/Notified.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/StorageServerShard.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/VersionedMap.h"
#include "fdbrpc/sim_validation.h"
#include "fdbrpc/Smoother.h"
#include "fdbrpc/Stats.h"
#include "fdbserver/AccumulativeChecksumUtil.h"
#include "fdbserver/BulkDumpUtil.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbserver/LogProtocolMessage.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/MutationTracking.h"
#include "fdbserver/OTELSpanContextMessage.h"
#include "fdbserver/Ratekeeper.h"
#include "fdbserver/ReadLatencySamples.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/ServerCheckpoint.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SpanContextMessage.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/TLogInterface.h"
#include "fdbserver/TransactionTagCounter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/StorageCorruptionBug.h"
#include "fdbserver/StorageServerUtils.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/Hash3.h"
#include "flow/Histogram.h"
#include "flow/IRandom.h"
#include "flow/IndexedSet.h"
#include "flow/SystemMonitor.h"
#include "flow/TDMetric.actor.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "flow/genericactors.actor.h"
#include "fdbserver/FDBRocksDBVersion.h"

#include "flow/actorcompiler.h" // This must be the last #include.

#ifndef __INTEL_COMPILER
#pragma region Data Structures
#endif

#define SHORT_CIRCUT_ACTUAL_STORAGE 0

namespace {
enum ChangeServerKeysContext { CSK_UPDATE, CSK_RESTORE, CSK_ASSIGN_EMPTY, CSK_FALL_BACK };

std::string changeServerKeysContextName(const ChangeServerKeysContext& context) {
	switch (context) {
	case CSK_UPDATE:
		return "Update";
	case CSK_RESTORE:
		return "Restore";
	case CSK_ASSIGN_EMPTY:
		return "AssignEmpty";
	case CSK_FALL_BACK:
		return "FallBackToFetchKeys";
	default:
		ASSERT(false);
	}
	return "UnknownContext";
}

bool canReplyWith(Error e) {
	switch (e.code()) {
	case error_code_transaction_too_old:
	case error_code_future_version:
	case error_code_wrong_shard_server:
	case error_code_process_behind:
	case error_code_watch_cancelled:
	case error_code_server_overloaded:
	// getMappedRange related exceptions that are not retriable:
	case error_code_mapper_bad_index:
	case error_code_mapper_no_such_key:
	case error_code_mapper_bad_range_decriptor:
	case error_code_quick_get_key_values_has_more:
	case error_code_quick_get_value_miss:
	case error_code_quick_get_key_values_miss:
	case error_code_get_mapped_key_values_has_more:
	case error_code_key_not_tuple:
	case error_code_value_not_tuple:
	case error_code_mapper_not_tuple:
		// case error_code_all_alternatives_failed:
		return true;
	default:
		return false;
	}
}

template <class Req>
Optional<ReadType> trackedReadType(Req const& req)
    requires requires(Req req) {
	    { req.options } -> std::same_as<Optional<ReadOptions>&>;
    }
{
	if (!SERVER_KNOBS->TRACK_READ_LATENCIES_PER_TYPE) {
		return {};
	}
	return req.options.map([](auto const& options) { return options.type; });
}

} // namespace

#define PERSIST_PREFIX "\xff\xff"

FDB_BOOLEAN_PARAM(UnlimitedCommitBytes);
FDB_BOOLEAN_PARAM(MoveInFailed);
FDB_BOOLEAN_PARAM(MoveInUpdatesSpilled);

// Immutable
static const KeyValueRef persistFormat(PERSIST_PREFIX "Format"_sr, "FoundationDB/StorageServer/1/4"_sr);
static const KeyValueRef persistShardAwareFormat(PERSIST_PREFIX "Format"_sr, "FoundationDB/StorageServer/1/5"_sr);
static const KeyRangeRef persistFormatReadableRange("FoundationDB/StorageServer/1/2"_sr,
                                                    "FoundationDB/StorageServer/1/6"_sr);
static const KeyRef persistID = PERSIST_PREFIX "ID"_sr;
static const KeyRef persistTssPairID = PERSIST_PREFIX "tssPairID"_sr;
static const KeyRef persistSSPairID = PERSIST_PREFIX "ssWithTSSPairID"_sr;
static const KeyRef persistTssQuarantine = PERSIST_PREFIX "tssQ"_sr;

// (Potentially) change with the durable version or when fetchKeys completes
static const KeyRef persistVersion = PERSIST_PREFIX "Version"_sr;
static const KeyRangeRef persistShardAssignedKeys =
    KeyRangeRef(PERSIST_PREFIX "ShardAssigned/"_sr, PERSIST_PREFIX "ShardAssigned0"_sr);
static const KeyRangeRef persistShardAvailableKeys =
    KeyRangeRef(PERSIST_PREFIX "ShardAvailable/"_sr, PERSIST_PREFIX "ShardAvailable0"_sr);
static const KeyRangeRef persistByteSampleKeys = KeyRangeRef(PERSIST_PREFIX "BS/"_sr, PERSIST_PREFIX "BS0"_sr);
static const KeyRangeRef persistByteSampleSampleKeys =
    KeyRangeRef(PERSIST_PREFIX "BS/"_sr PERSIST_PREFIX "BS/"_sr, PERSIST_PREFIX "BS/"_sr PERSIST_PREFIX "BS0"_sr);
static const KeyRef persistLogProtocol = PERSIST_PREFIX "LogProtocol"_sr;
static const KeyRef persistPrimaryLocality = PERSIST_PREFIX "PrimaryLocality"_sr;
// data keys are unmangled (but never start with PERSIST_PREFIX because they are always in allKeys)

static const KeyRangeRef persistStorageServerShardKeys =
    KeyRangeRef(PERSIST_PREFIX "StorageServerShard/"_sr, PERSIST_PREFIX "StorageServerShard0"_sr);

// Checkpoint related prefixes.
static const KeyRangeRef persistCheckpointKeys =
    KeyRangeRef(PERSIST_PREFIX "Checkpoint/"_sr, PERSIST_PREFIX "Checkpoint0"_sr);
static const KeyRangeRef persistPendingCheckpointKeys =
    KeyRangeRef(PERSIST_PREFIX "PendingCheckpoint/"_sr, PERSIST_PREFIX "PendingCheckpoint0"_sr);
static const std::string serverCheckpointFolder = "serverCheckpoints";
static const std::string checkpointBytesSampleTempFolder = "/metadata_temp";
static const std::string fetchedCheckpointFolder = "fetchedCheckpoints";
static const std::string serverBulkDumpFolder = "bulkDumpFiles";
static const std::string serverBulkLoadFolder = "bulkLoadFiles";
static const std::string invalidTeamId = "InvalidTeam";

static const KeyRangeRef persistBulkLoadTaskKeys =
    KeyRangeRef(PERSIST_PREFIX "BulkLoadTask/"_sr, PERSIST_PREFIX "BulkLoadTask0"_sr);

// Accumulative checksum related prefix
static const KeyRangeRef persistAccumulativeChecksumKeys =
    KeyRangeRef(PERSIST_PREFIX "AccumulativeChecksum/"_sr, PERSIST_PREFIX "AccumulativeChecksum0"_sr);

inline Key encodePersistAccumulativeChecksumKey(uint16_t acsIndex) {
	BinaryWriter wr(Unversioned());
	wr.serializeBytes(persistAccumulativeChecksumKeys.begin);
	wr << bigEndian16(acsIndex);
	return wr.toValue();
}

inline uint16_t decodePersistAccumulativeChecksumKey(const Key& key) {
	uint16_t acsIndex;
	BinaryReader rd(key.removePrefix(persistAccumulativeChecksumKeys.begin), Unversioned());
	rd >> acsIndex;
	return bigEndian16(acsIndex);
}

// MoveInUpdates caches new updates of a move-in shard, before that shard is ready to accept writes.
struct MoveInUpdates {
	MoveInUpdates() : spilled(MoveInUpdatesSpilled::False) {}
	MoveInUpdates(UID id,
	              Version version,
	              struct StorageServer* data,
	              IKeyValueStore* store,
	              MoveInUpdatesSpilled spilled);

	void addMutation(Version version, bool fromFetch, MutationRef const& mutation, bool allowSpill);

	bool hasNext() const;

	std::vector<Standalone<VerUpdateRef>> next(const int byteLimit);
	const std::deque<Standalone<VerUpdateRef>>& getUpdatesQueue() const { return this->updates; }

	UID id;
	Version lastRepliedVersion;
	std::deque<Standalone<VerUpdateRef>> updates;
	std::vector<Standalone<VerUpdateRef>> spillBuffer;
	struct StorageServer* data;
	IKeyValueStore* store;
	KeyRange range;
	bool fail;
	MoveInUpdatesSpilled spilled;
	size_t size;
	Future<Void> loadFuture;
	Severity logSev;

private:
																#line 277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> loadUpdates( MoveInUpdates* const& self, Version const& begin, Version const& end );
template <class> friend class MoveInUpdates_LoadUpdatesActorState;

#line 276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

	Key getPersistKey(const Version version, const int idx) const;
};

															#line 286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
// This generated class is to be used only via loadUpdates()
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class MoveInUpdates_LoadUpdatesActor>
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class MoveInUpdates_LoadUpdatesActorState {
															#line 292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	MoveInUpdates_LoadUpdatesActorState(MoveInUpdates* const& self,Version const& begin,Version const& end) 
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : self(self),
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   begin(begin),
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   end(end)
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadUpdates", reinterpret_cast<unsigned long>(this));

	}
	~MoveInUpdates_LoadUpdatesActorState() 
	{
		fdb_probe_actor_destroy("loadUpdates", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(self->spilled);
															#line 282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (begin >= end)
															#line 320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				self->spilled = MoveInUpdatesSpilled::False;
															#line 284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveInUpdates_LoadUpdatesActorState(); static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->destroy(); return 0; }
															#line 326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MoveInUpdates_LoadUpdatesActorState();
				static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const Key beginKey = persistUpdatesKey(self->id, begin), endKey = persistUpdatesKey(self->id, end);
															#line 288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(self->logSev, "MoveInUpdatesLoadBegin", self->id) .detail("BeginVersion", begin) .detail("EndVersion", end) .detail("BeginKey", beginKey) .detail("EndKey", endKey);
															#line 293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(beginKey < endKey);
															#line 294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = self->store->readRange(KeyRangeRef(beginKey, endKey), SERVER_KNOBS->FETCH_SHARD_UPDATES_BYTE_LIMIT, SERVER_KNOBS->FETCH_SHARD_UPDATES_BYTE_LIMIT);
															#line 294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->actor_wait_state = 1;
															#line 294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >*>(static_cast<MoveInUpdates_LoadUpdatesActor*>(this)));
															#line 347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveInUpdates_LoadUpdatesActorState();
		static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		std::vector<Standalone<VerUpdateRef>> restored;
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const Version version = decodePersistUpdateVersion(res[i].key.removePrefix(self->range.begin));
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Standalone<VerUpdateRef> vur = BinaryReader::fromStringRef<Standalone<VerUpdateRef>>(res[i].value, IncludeVersion());
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(version == vur.version);
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(self->logSev, "MoveInUpdatesLoadedMutations", self->id) .detail("Version", version) .detail("Mutations", vur.mutations.size());
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			restored.push_back(std::move(vur));
															#line 382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!res.more)
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(int i = restored.size() - 1;i >= 0;--i) {
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (self->updates.empty() || restored[i].version < self->updates.front().version)
															#line 392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					self->updates.push_front(std::move(restored[i]));
															#line 396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
															#line 315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			self->spilled = MoveInUpdatesSpilled::False;
															#line 401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(self->spillBuffer.empty());
															#line 318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::swap(self->spillBuffer, restored);
															#line 409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->loadFuture = Future<Void>();
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(self->logSev, "MoveInUpdatesLoadEnd", self->id) .detail("MinVersion", restored.empty() ? invalidVersion : restored.front().version) .detail("MaxVersion", restored.empty() ? invalidVersion : restored.back().version) .detail("VersionCount", restored.size()) .detail("LastBatch", !res.more);
															#line 328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveInUpdates_LoadUpdatesActorState(); static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->destroy(); return 0; }
															#line 417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveInUpdates_LoadUpdatesActorState();
		static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && res,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		std::vector<Standalone<VerUpdateRef>> restored;
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const Version version = decodePersistUpdateVersion(res[i].key.removePrefix(self->range.begin));
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Standalone<VerUpdateRef> vur = BinaryReader::fromStringRef<Standalone<VerUpdateRef>>(res[i].value, IncludeVersion());
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(version == vur.version);
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(self->logSev, "MoveInUpdatesLoadedMutations", self->id) .detail("Version", version) .detail("Mutations", vur.mutations.size());
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			restored.push_back(std::move(vur));
															#line 441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!res.more)
															#line 445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(int i = restored.size() - 1;i >= 0;--i) {
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (self->updates.empty() || restored[i].version < self->updates.front().version)
															#line 451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					self->updates.push_front(std::move(restored[i]));
															#line 455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
															#line 315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			self->spilled = MoveInUpdatesSpilled::False;
															#line 460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(self->spillBuffer.empty());
															#line 318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::swap(self->spillBuffer, restored);
															#line 468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->loadFuture = Future<Void>();
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(self->logSev, "MoveInUpdatesLoadEnd", self->id) .detail("MinVersion", restored.empty() ? invalidVersion : restored.front().version) .detail("MaxVersion", restored.empty() ? invalidVersion : restored.back().version) .detail("VersionCount", restored.size()) .detail("LastBatch", !res.more);
															#line 328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveInUpdates_LoadUpdatesActorState(); static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->destroy(); return 0; }
															#line 476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveInUpdates_LoadUpdatesActorState();
		static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->actor_wait_state > 0) static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->actor_wait_state = 0;
		static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	MoveInUpdates* self;
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version begin;
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version end;
															#line 565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadUpdates()
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class MoveInUpdates_LoadUpdatesActor final : public Actor<Void>, public ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >, public FastAllocated<MoveInUpdates_LoadUpdatesActor>, public MoveInUpdates_LoadUpdatesActorState<MoveInUpdates_LoadUpdatesActor> {
															#line 570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<MoveInUpdates_LoadUpdatesActor>::operator new;
	using FastAllocated<MoveInUpdates_LoadUpdatesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15724827804464692736UL, 15031779947716001792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >;
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	MoveInUpdates_LoadUpdatesActor(MoveInUpdates* const& self,Version const& begin,Version const& end) 
															#line 587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MoveInUpdates_LoadUpdatesActorState<MoveInUpdates_LoadUpdatesActor>(self, begin, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadUpdates", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5561495993262577152UL, 4925366652637659904UL);
		ActorExecutionContextHelper __helper(static_cast<MoveInUpdates_LoadUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadUpdates");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadUpdates", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveInUpdates_LoadUpdatesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> MoveInUpdates::loadUpdates( MoveInUpdates* const& self, Version const& begin, Version const& end ) {
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new MoveInUpdates_LoadUpdatesActor(self, begin, end));
															#line 619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

bool MoveInUpdates::hasNext() const {
	return this->spilled || (!this->updates.empty() && this->updates.back().version > this->lastRepliedVersion);
}

// MoveInShard corresponds to a move-in physical shard, a class representation of MoveInShardMetaData.
struct MoveInShard {
	std::shared_ptr<MoveInShardMetaData> meta;
	struct StorageServer* server;
	std::shared_ptr<MoveInUpdates> updates;
	bool isRestored;
	Version transferredVersion;
	ConductBulkLoad conductBulkLoad = ConductBulkLoad::False;

	Future<Void> fetchClient; // holds FetchShard() actor
	Promise<Void> fetchComplete;
	Promise<Void> readWrite;

	Severity logSev = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);

	MoveInShard() = default;
	MoveInShard(StorageServer* server,
	            const UID& id,
	            const UID& dataMoveId,
	            const Version version,
	            const ConductBulkLoad conductBulkLoad,
	            MoveInPhase phase);
	MoveInShard(StorageServer* server,
	            const UID& id,
	            const UID& dataMoveId,
	            const Version version,
	            const ConductBulkLoad conductBulkLoad);
	MoveInShard(StorageServer* server, MoveInShardMetaData meta);
	~MoveInShard();

	UID id() const { return this->meta->id; }
	UID dataMoveId() const { return this->meta->dataMoveId; }
	void setPhase(const MoveInPhase& phase) { this->meta->setPhase(phase); }
	MoveInPhase getPhase() const { return this->meta->getPhase(); }
	const std::vector<KeyRange>& ranges() const { return this->meta->ranges; }
	const std::vector<CheckpointMetaData>& checkpoints() const { return this->meta->checkpoints; }
	std::string destShardIdString() const { return this->meta->destShardIdString(); }
	void addRange(const KeyRangeRef range);
	void removeRange(const KeyRangeRef range);
	void cancel(const MoveInFailed failed = MoveInFailed::False);
	bool isDataTransferred() const { return meta->getPhase() >= MoveInPhase::ApplyingUpdates; }
	bool isDataAndCFTransferred() const { throw not_implemented(); }
	bool failed() const { return this->getPhase() == MoveInPhase::Cancel || this->getPhase() == MoveInPhase::Error; }
	void setHighWatermark(const Version version) { this->meta->highWatermark = version; }
	Version getHighWatermark() const { return this->meta->highWatermark; }

	void addMutation(Version version, bool fromFetch, MutationRef const& mutation);

	KeyRangeRef getAffectedRange(const MutationRef& mutation) const;

	std::string toString() const { return meta != nullptr ? meta->toString() : "Empty"; }
};

struct AddingShard : NonCopyable {
	KeyRange keys;
	Future<Void> fetchClient; // holds FetchKeys() actor
	Promise<Void> fetchComplete;
	Promise<Void> readWrite;
	DataMovementReason reason;
	SSBulkLoadMetadata ssBulkLoadMetadata;
	std::string teamId;

	// During the Fetching phase, it saves newer mutations whose version is greater or equal to fetchClient's
	// fetchVersion, while the shard is still busy catching up with fetchClient. It applies these updates after fetching
	// completes.
	std::deque<Standalone<VerUpdateRef>> updates;

	struct StorageServer* server;
	Version transferredVersion;
	Version fetchVersion;

	// To learn more details of the phase transitions, see function fetchKeys(). The phases below are sorted in
	// chronological order and do not go back.
	enum Phase {
		WaitPrevious,
		// During Fetching phase, it fetches data before fetchVersion and write it to storage, then let updater know it
		// is ready to update the deferred updates` (see the comment of member variable `updates` above).
		Fetching,
		// During the FetchingCF phase, the shard data is transferred but the remaining change feed data is still being
		// transferred. This is equivalent to the waiting phase for non-changefeed data.
		// TODO(gglass): remove FetchingCF.  Probably requires some refactoring of permanent logic,
		// not just flat out removal of CF-specific logic, so come back to this.
		FetchingCF,
		// During Waiting phase, it sends updater the deferred updates, and wait until they are durable.
		Waiting
		// The shard's state is changed from adding to readWrite then.
	};

	Phase phase;

	AddingShard(StorageServer* server,
	            KeyRangeRef const& keys,
	            DataMovementReason reason,
	            const SSBulkLoadMetadata& ssBulkLoadMetadata);

	// When fetchKeys "partially completes" (splits an adding shard in two), this is used to construct the left half
	AddingShard(AddingShard* prev, KeyRange const& keys)
	  : keys(keys), fetchClient(prev->fetchClient), server(prev->server), transferredVersion(prev->transferredVersion),
	    fetchVersion(prev->fetchVersion), phase(prev->phase), reason(prev->reason),
	    ssBulkLoadMetadata(prev->ssBulkLoadMetadata) {}
	~AddingShard() {
		if (!fetchComplete.isSet())
			fetchComplete.send(Void());
		if (!readWrite.isSet())
			readWrite.send(Void());
	}

	void addMutation(Version version, bool fromFetch, MutationRef const& mutation);

	bool isDataTransferred() const { return phase >= FetchingCF; }
	bool isDataAndCFTransferred() const { return phase >= Waiting; }

	SSBulkLoadMetadata getSSBulkLoadMetadata() const { return ssBulkLoadMetadata; }
};

class ShardInfo : public ReferenceCounted<ShardInfo>, NonCopyable {
private:
	ShardInfo(KeyRange keys, std::unique_ptr<AddingShard>&& adding, StorageServer* readWrite)
	  : adding(std::move(adding)), readWrite(readWrite), keys(keys), shardId(0LL), desiredShardId(0LL), version(0) {}
	ShardInfo(KeyRange keys, std::shared_ptr<MoveInShard> moveInShard)
	  : adding(nullptr), readWrite(nullptr), moveInShard(moveInShard), keys(keys),
	    shardId(moveInShard->meta->destShardId()), desiredShardId(moveInShard->meta->destShardId()),
	    version(moveInShard->meta->createVersion) {}

	// A shard has 4 mutual exclusive states: adding, moveInShard, readWrite and notAssigned.
	std::unique_ptr<AddingShard> adding;
	struct StorageServer* readWrite;
	std::shared_ptr<MoveInShard> moveInShard; // The shard is being moved in via physical-shard-move.
	KeyRange keys;
	uint64_t changeCounter;
	uint64_t shardId;
	uint64_t desiredShardId;
	std::string teamId = invalidTeamId;
	Version version;

public:
	static ShardInfo* newNotAssigned(KeyRange keys) { return new ShardInfo(keys, nullptr, nullptr); }
	static ShardInfo* newReadWrite(KeyRange keys, StorageServer* data) { return new ShardInfo(keys, nullptr, data); }
	static ShardInfo* newAdding(StorageServer* data,
	                            KeyRange keys,
	                            DataMovementReason reason,
	                            const SSBulkLoadMetadata& ssBulkLoadMetadata) {
		return new ShardInfo(keys, std::make_unique<AddingShard>(data, keys, reason, ssBulkLoadMetadata), nullptr);
	}
	static ShardInfo* addingSplitLeft(KeyRange keys, AddingShard* oldShard) {
		return new ShardInfo(keys, std::make_unique<AddingShard>(oldShard, keys), nullptr);
	}

	static ShardInfo* newShard(StorageServer* data, const StorageServerShard& shard);

	static bool canMerge(const ShardInfo* l, const ShardInfo* r) {
		if (l == nullptr || r == nullptr || l->keys.end != r->keys.begin || l->version == invalidVersion ||
		    r->version == invalidVersion) {
			return false;
		}
		if (l->getShardId() != r->getShardId() || l->getDesiredShardId() != r->getDesiredShardId()) {
			return false;
		}
		return (l->isReadable() && r->isReadable()) || (!l->assigned() && !r->assigned());
	}

	StorageServerShard toStorageServerShard() const {
		StorageServerShard::ShardState st = StorageServerShard::NotAssigned;
		Optional<UID> moveInShardId;
		if (this->isReadable()) {
			st = StorageServerShard::ReadWrite;
		} else if (!this->assigned()) {
			st = StorageServerShard::NotAssigned;
		} else if (this->getAddingShard()) {
			st = this->getAddingShard()->phase == AddingShard::Waiting ? StorageServerShard::ReadWritePending
			                                                           : StorageServerShard::Adding;
		} else {
			ASSERT(this->getMoveInShard());
			const MoveInPhase phase = this->getMoveInShard()->getPhase();
			if (phase < MoveInPhase::ReadWritePending) {
				st = StorageServerShard::MovingIn;
			} else if (phase == MoveInPhase::ReadWritePending) {
				st = StorageServerShard::ReadWritePending;
			} else if (phase == MoveInPhase::Complete) {
				st = StorageServerShard::ReadWrite;
			} else {
				st = StorageServerShard::MovingIn;
			}
			// Clear moveInShardId if the data move is complete.
			if (phase != MoveInPhase::ReadWritePending && phase != MoveInPhase::Complete) {
				moveInShardId = this->getMoveInShard()->id();
			}
		}
		return StorageServerShard(this->keys, this->version, this->shardId, this->desiredShardId, st, moveInShardId);
	}

	// Copies necessary information from `shard`.
	void populateShard(const StorageServerShard& shard) {
		this->version = shard.version;
		this->shardId = shard.id;
		this->desiredShardId = shard.desiredId;
	}

	// Returns true if the current shard is merged with `other`.
	bool mergeWith(const ShardInfo* other) {
		if (!canMerge(this, other)) {
			return false;
		}
		this->keys = KeyRangeRef(this->keys.begin, other->range().end);
		this->version = std::max(this->version, other->getVersion());
		return true;
	}

	void validate() const {
		// TODO: Complete this.
	}

	bool isReadable() const { return readWrite != nullptr; }
	bool notAssigned() const { return !readWrite && !adding && !moveInShard; }
	bool assigned() const { return readWrite || adding || moveInShard; }

	KeyRange range() const { return keys; }
	uint64_t getShardId() const { return shardId; }
	uint64_t getDesiredShardId() const { return desiredShardId; }
	uint64_t getChangeCounter() const { return changeCounter; }
	AddingShard* getAddingShard() const { return adding.get(); }
	std::shared_ptr<MoveInShard> getMoveInShard() const { return moveInShard; }
	Version getVersion() const { return version; }
	std::string getTeamId() const { return teamId; }

	void setChangeCounter(uint64_t shardChangeCounter) { changeCounter = shardChangeCounter; }
	void setShardId(uint64_t id) { shardId = id; }
	void setDesiredShardId(uint64_t id) { desiredShardId = id; }

	bool isInVersionedData() const {
		return readWrite || (adding && adding->isDataTransferred()) ||
		       (moveInShard && moveInShard->isDataTransferred());
	}
	bool isCFInVersionedData() const { return readWrite || (adding && adding->isDataAndCFTransferred()); }
	bool isReadWritePending() const {
		return isCFInVersionedData() || (moveInShard && (moveInShard->getPhase() == MoveInPhase::ReadWritePending ||
		                                                 moveInShard->getPhase() == MoveInPhase::Complete));
	}
	void addMutation(Version version, bool fromFetch, MutationRef const& mutation);
	bool isFetched() const {
		return readWrite || (adding && adding->fetchComplete.isSet()) ||
		       (moveInShard && moveInShard->fetchComplete.isSet());
	}

	bool isFetching() const {
		if (adding) {
			return !adding->fetchComplete.isSet();
		}
		if (moveInShard) {
			return !moveInShard->fetchComplete.isSet();
		}
		return false;
	}

	std::string debugDescribeState() const {
		if (notAssigned()) {
			return "NotAssigned";
		} else if (adding && !adding->isDataAndCFTransferred()) {
			return "AddingFetchingCF";
		} else if (adding && !adding->isDataTransferred()) {
			return "AddingFetching";
		} else if (adding) {
			return "AddingTransferred";
		} else if (moveInShard) {
			return moveInShard->meta->toString();
		} else {
			return "ReadWrite";
		}
	}
};

struct StorageServerDisk {
	explicit StorageServerDisk(struct StorageServer* data, IKeyValueStore* storage) : data(data), storage(storage) {}

	IKeyValueStore* getKeyValueStore() const { return this->storage; }

	void makeNewStorageServerDurable(const bool shardAware);
	bool makeVersionMutationsDurable(Version& prevStorageVersion,
	                                 Version newStorageVersion,
	                                 int64_t& bytesLeft,
	                                 UnlimitedCommitBytes unlimitedCommitBytes,
	                                 int64_t& clearRangesLeft,
	                                 const UID& ssId,
	                                 bool verbose = false);
	void makeVersionDurable(Version version);
	void makeAccumulativeChecksumDurable(const AccumulativeChecksumState& acsState);
	void clearAccumulativeChecksumState(const AccumulativeChecksumState& acsState);
	void makeTssQuarantineDurable();
	Future<bool> restoreDurableState();

	void changeLogProtocol(Version version, ProtocolVersion protocol);

	void writeMutation(MutationRef mutation);
	void writeKeyValue(KeyValueRef kv);
	void clearRange(KeyRangeRef keys);

	Future<Void> addRange(KeyRangeRef range, std::string id) {
		return storage->addRange(range, id, !SERVER_KNOBS->SHARDED_ROCKSDB_DELAY_COMPACTION_FOR_DATA_MOVE);
	}

	std::vector<std::string> removeRange(KeyRangeRef range) { return storage->removeRange(range); }

	void markRangeAsActive(KeyRangeRef range) { storage->markRangeAsActive(range); }

	Future<Void> replaceRange(KeyRange range, Standalone<VectorRef<KeyValueRef>> data) {
		return storage->replaceRange(range, data);
	}

	void persistRangeMapping(KeyRangeRef range, bool isAdd) { storage->persistRangeMapping(range, isAdd); }

	CoalescedKeyRangeMap<std::string> getExistingRanges() { return storage->getExistingRanges(); }

	Future<Void> getError() { return storage->getError(); }
	Future<Void> init() { return storage->init(); }
	Future<Void> canCommit() { return storage->canCommit(); }
	Future<Void> commit() { return storage->commit(); }

	void logRecentRocksDBBackgroundWorkStats(UID ssId, std::string logReason) {
		return storage->logRecentRocksDBBackgroundWorkStats(ssId, logReason);
	}

	// SOMEDAY: Put readNextKeyInclusive in IKeyValueStore
	// Read the key that is equal or greater then 'key' from the storage engine.
	// For example, readNextKeyInclusive("a") should return:
	//  - "a", if key "a" exist
	//  - "b", if key "a" doesn't exist, and "b" is the next existing key in total order
	//  - allKeys.end, if keyrange [a, allKeys.end) is empty
	Future<Key> readNextKeyInclusive(KeyRef key, Optional<ReadOptions> options = Optional<ReadOptions>()) {
		++(*kvScans);
		return readFirstKey(storage, KeyRangeRef(key, allKeys.end), options);
	}
	Future<Optional<Value>> readValue(KeyRef key, Optional<ReadOptions> options = Optional<ReadOptions>()) {
		++(*kvGets);
		return storage->readValue(key, options);
	}
	Future<Optional<Value>> readValuePrefix(KeyRef key,
	                                        int maxLength,
	                                        Optional<ReadOptions> options = Optional<ReadOptions>()) {
		++(*kvGets);
		return storage->readValuePrefix(key, maxLength, options);
	}
	Future<RangeResult> readRange(KeyRangeRef keys,
	                              int rowLimit = 1 << 30,
	                              int byteLimit = 1 << 30,
	                              Optional<ReadOptions> options = Optional<ReadOptions>()) {
		++(*kvScans);
		return storage->readRange(keys, rowLimit, byteLimit, options);
	}

	Future<CheckpointMetaData> checkpoint(const CheckpointRequest& request) { return storage->checkpoint(request); }

	Future<Void> restore(const std::vector<CheckpointMetaData>& checkpoints) { return storage->restore(checkpoints); }

	Future<Void> restore(const std::string& shardId,
	                     const std::vector<KeyRange>& ranges,
	                     const std::vector<CheckpointMetaData>& checkpoints) {
		return storage->restore(shardId, ranges, checkpoints);
	}

	Future<Void> deleteCheckpoint(const CheckpointMetaData& checkpoint) {
		return storage->deleteCheckpoint(checkpoint);
	}

	KeyValueStoreType getKeyValueStoreType() const { return storage->getType(); }
	StorageBytes getStorageBytes() const { return storage->getStorageBytes(); }
	std::tuple<size_t, size_t, size_t> getSize() const { return storage->getSize(); }

	// The following are pointers to the Counters in StorageServer::counters of the same names.
	Counter* kvCommitLogicalBytes;
	Counter* kvClearRanges;
	Counter* kvClearSingleKey;
	Counter* kvGets;
	Counter* kvScans;
	Counter* kvCommits;

private:
	struct StorageServer* data;
	IKeyValueStore* storage;
	void writeMutations(const VectorRef<MutationRef>& mutations, Version debugVersion, const char* debugContext);
	void writeMutationsBuggy(const VectorRef<MutationRef>& mutations, Version debugVersion, const char* debugContext);

																#line 1009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
// This generated class is to be used only via readFirstKey()
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class ReadFirstKeyActor>
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class ReadFirstKeyActorState {
															#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ReadFirstKeyActorState(IKeyValueStore* const& storage,KeyRangeRef const& range,Optional<ReadOptions> const& options) 
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : storage(storage),
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   range(range),
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   options(options)
															#line 1026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readFirstKey", reinterpret_cast<unsigned long>(this));

	}
	~ReadFirstKeyActorState() 
	{
		fdb_probe_actor_destroy("readFirstKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = storage->readRange(range, 1, 1 << 30, options);
															#line 717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<ReadFirstKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFirstKeyActor*>(this)->actor_wait_state = 1;
															#line 717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFirstKeyActor, 0, RangeResult >*>(static_cast<ReadFirstKeyActor*>(this)));
															#line 1048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFirstKeyActorState();
		static_cast<ReadFirstKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& r,int loopDepth) 
	{
															#line 718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (r.size())
															#line 1071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<ReadFirstKeyActor*>(this)->SAV<Key>::futures) { (void)(r[0].key); this->~ReadFirstKeyActorState(); static_cast<ReadFirstKeyActor*>(this)->destroy(); return 0; }
															#line 1075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<ReadFirstKeyActor*>(this)->SAV< Key >::value()) Key(r[0].key);
			this->~ReadFirstKeyActorState();
			static_cast<ReadFirstKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<ReadFirstKeyActor*>(this)->SAV<Key>::futures) { (void)(range.end); this->~ReadFirstKeyActorState(); static_cast<ReadFirstKeyActor*>(this)->destroy(); return 0; }
															#line 1085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<ReadFirstKeyActor*>(this)->SAV< Key >::value()) Key(range.end);
			this->~ReadFirstKeyActorState();
			static_cast<ReadFirstKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(RangeResult && r,int loopDepth) 
	{
															#line 718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (r.size())
															#line 1098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<ReadFirstKeyActor*>(this)->SAV<Key>::futures) { (void)(r[0].key); this->~ReadFirstKeyActorState(); static_cast<ReadFirstKeyActor*>(this)->destroy(); return 0; }
															#line 1102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<ReadFirstKeyActor*>(this)->SAV< Key >::value()) Key(r[0].key);
			this->~ReadFirstKeyActorState();
			static_cast<ReadFirstKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<ReadFirstKeyActor*>(this)->SAV<Key>::futures) { (void)(range.end); this->~ReadFirstKeyActorState(); static_cast<ReadFirstKeyActor*>(this)->destroy(); return 0; }
															#line 1112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<ReadFirstKeyActor*>(this)->SAV< Key >::value()) Key(range.end);
			this->~ReadFirstKeyActorState();
			static_cast<ReadFirstKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& r,int loopDepth) 
	{
		loopDepth = a_body1cont1(r, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && r,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFirstKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstKeyActor*>(this)->ActorCallback< ReadFirstKeyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstKeyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readFirstKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFirstKeyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readFirstKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFirstKeyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	IKeyValueStore* storage;
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRangeRef range;
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Optional<ReadOptions> options;
															#line 1202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readFirstKey()
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class ReadFirstKeyActor final : public Actor<Key>, public ActorCallback< ReadFirstKeyActor, 0, RangeResult >, public FastAllocated<ReadFirstKeyActor>, public ReadFirstKeyActorState<ReadFirstKeyActor> {
															#line 1207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadFirstKeyActor>::operator new;
	using FastAllocated<ReadFirstKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2835615785188662528UL, 13478720864051730432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFirstKeyActor, 0, RangeResult >;
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ReadFirstKeyActor(IKeyValueStore* const& storage,KeyRangeRef const& range,Optional<ReadOptions> const& options) 
															#line 1224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   ReadFirstKeyActorState<ReadFirstKeyActor>(storage, range, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFirstKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4418144802222492160UL, 5296783460543853568UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFirstKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFirstKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFirstKeyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] static Future<Key> readFirstKey( IKeyValueStore* const& storage, KeyRangeRef const& range, Optional<ReadOptions> const& options ) {
															#line 716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Key>(new ReadFirstKeyActor(storage, range, options));
															#line 1256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
};

struct UpdateEagerReadInfo {
	std::vector<KeyRef> keyBegin;
	std::vector<Key> keyEnd; // these are for ClearRange

	std::vector<std::pair<KeyRef, int>> keys;
	std::vector<Optional<Value>> value;

	Arena arena;
	bool enableClearRangeEagerReads;

	UpdateEagerReadInfo(bool enableClearRangeEagerReads) : enableClearRangeEagerReads(enableClearRangeEagerReads) {}

	void addMutations(VectorRef<MutationRef> const& mutations) {
		for (auto& m : mutations)
			addMutation(m);
	}

	void addMutation(MutationRef const& m) {
		// SOMEDAY: Theoretically we can avoid a read if there is an earlier overlapping ClearRange
		if (m.type == MutationRef::ClearRange && !m.param2.startsWith(systemKeys.end) && enableClearRangeEagerReads)
			keyBegin.push_back(m.param2);
		else if (m.type == MutationRef::CompareAndClear) {
			if (enableClearRangeEagerReads)
				keyBegin.push_back(keyAfter(m.param1, arena));
			if (keys.size() > 0 && keys.back().first == m.param1) {
				// Don't issue a second read, if the last read was equal to the current key.
				// CompareAndClear is likely to be used after another atomic operation on same key.
				keys.back().second = std::max(keys.back().second, m.param2.size() + 1);
			} else {
				keys.emplace_back(m.param1, m.param2.size() + 1);
			}
		} else if ((m.type == MutationRef::AppendIfFits) || (m.type == MutationRef::ByteMin) ||
		           (m.type == MutationRef::ByteMax))
			keys.emplace_back(m.param1, CLIENT_KNOBS->VALUE_SIZE_LIMIT);
		else if (isAtomicOp((MutationRef::Type)m.type))
			keys.emplace_back(m.param1, m.param2.size());
	}

	void finishKeyBegin() {
		if (enableClearRangeEagerReads) {
			std::sort(keyBegin.begin(), keyBegin.end());
			keyBegin.resize(std::unique(keyBegin.begin(), keyBegin.end()) - keyBegin.begin());
		}
		std::sort(keys.begin(), keys.end(), [](const std::pair<KeyRef, int>& lhs, const std::pair<KeyRef, int>& rhs) {
			return (lhs.first < rhs.first) || (lhs.first == rhs.first && lhs.second > rhs.second);
		});
		keys.resize(std::unique(keys.begin(),
		                        keys.end(),
		                        [](const std::pair<KeyRef, int>& lhs, const std::pair<KeyRef, int>& rhs) {
			                        return lhs.first == rhs.first;
		                        }) -
		            keys.begin());
		// value gets populated in doEagerReads
	}

	Optional<Value>& getValue(KeyRef key) {
		int i = std::lower_bound(keys.begin(),
		                         keys.end(),
		                         std::pair<KeyRef, int>(key, 0),
		                         [](const std::pair<KeyRef, int>& lhs, const std::pair<KeyRef, int>& rhs) {
			                         return lhs.first < rhs.first;
		                         }) -
		        keys.begin();
		ASSERT(i < keys.size() && keys[i].first == key);
		return value[i];
	}

	KeyRef getKeyEnd(KeyRef key) {
		int i = std::lower_bound(keyBegin.begin(), keyBegin.end(), key) - keyBegin.begin();
		ASSERT(i < keyBegin.size() && keyBegin[i] == key);
		return keyEnd[i];
	}
};

const int VERSION_OVERHEAD =
    64 + sizeof(Version) + sizeof(Standalone<VerUpdateRef>) + // mutationLog, 64b overhead for map
    2 * (64 + sizeof(Version) +
         sizeof(Reference<VersionedMap<KeyRef, ValueOrClearToRef>::PTreeT>)); // versioned map [ x2 for
                                                                              // createNewVersion(version+1) ], 64b
                                                                              // overhead for map

static int mvccStorageBytes(MutationRef const& m) {
	return mvccStorageBytes(m.param1.size() + m.param2.size());
}

struct FetchInjectionInfo {
	Arena arena;
	std::vector<VerUpdateRef> changes;
};

class ServerWatchMetadata : public ReferenceCounted<ServerWatchMetadata> {
public:
	Key key;
	Optional<Value> value;
	Version version;
	Future<Version> watch_impl;
	Promise<Version> versionPromise;
	Optional<TagSet> tags;
	Optional<UID> debugID;

	ServerWatchMetadata(Key key, Optional<Value> value, Version version, Optional<TagSet> tags, Optional<UID> debugID)
	  : key(key), value(value), version(version), tags(tags), debugID(debugID) {}
};

struct BusiestWriteTagContext {
	const std::string busiestWriteTagTrackingKey;
	UID ratekeeperID;
	Reference<EventCacheHolder> busiestWriteTagEventHolder;
	double lastUpdateTime;

	BusiestWriteTagContext(const UID& thisServerID)
	  : busiestWriteTagTrackingKey(thisServerID.toString() + "/BusiestWriteTag"), ratekeeperID(UID()),
	    busiestWriteTagEventHolder(makeReference<EventCacheHolder>(busiestWriteTagTrackingKey)), lastUpdateTime(-1) {}
};

struct SSBulkLoadMetrics {
public:
	SSBulkLoadMetrics() : ongoingTasks(0) {}
	void addTask() { ongoingTasks++; }
	void removeTask() { ongoingTasks--; }
	int getOngoingTasks() { return ongoingTasks; }

private:
	int ongoingTasks = 0;
};

struct StorageServer : public IStorageMetricsService {
	typedef VersionedMap<KeyRef, ValueOrClearToRef> VersionedData;

private:
	// versionedData contains sets and clears.

	// * Nonoverlapping: No clear overlaps a set or another clear, or adjoins another clear.
	// ~ Clears are maximal: If versionedData.at(v) contains a clear [b,e) then
	//      there is a key data[e]@v, or e==allKeys.end, or a shard boundary or former boundary at e

	// * Reads are possible: When k is in a readable shard, for any v in [storageVersion, version.get()],
	//      storage[k] + versionedData.at(v)[k] = database[k] @ v    (storage[k] might be @ any version in
	//      [durableVersion, storageVersion])

	// * Transferred shards are partially readable: When k is in an adding, transferred shard, for any v in
	// [transferredVersion, version.get()],
	//      storage[k] + versionedData.at(v)[k] = database[k] @ v

	// * versionedData contains versions [storageVersion(), version.get()].  It might also contain version
	// (version.get()+1), in which changeDurableVersion may be deleting ghosts, and/or it might
	//      contain later versions if applyUpdate is on the stack.

	// * Old shards are erased: versionedData.atLatest() has entries (sets or intersecting clears) only for keys in
	// readable or adding,transferred shards.
	//   Earlier versions may have extra entries for shards that *were* readable or adding,transferred when those
	//   versions were the latest, but they eventually are forgotten.

	// * Old mutations are erased: All items in versionedData.atLatest() have insertVersion() > durableVersion(), but
	// views
	//   at older versions may contain older items which are also in storage (this is OK because of idempotency)

	VersionedData versionedData;
	std::map<Version, Standalone<VerUpdateRef>> mutationLog; // versions (durableVersion, version]

	using WatchMapKey = Key;
	using WatchMapKeyHasher = boost::hash<WatchMapKey>;
	using WatchMapValue = Reference<ServerWatchMetadata>;
	using WatchMap_t = std::unordered_map<WatchMapKey, WatchMapValue, WatchMapKeyHasher>;
	WatchMap_t watchMap; // keep track of server watches

public:
	struct PendingNewShard {
		PendingNewShard(uint64_t shardId, KeyRangeRef range) : shardId(format("%016llx", shardId)), range(range) {}

		std::string toString() const {
			return fmt::format("PendingNewShard: [ShardID]: {} [Range]: {}",
			                   this->shardId,
			                   Traceable<KeyRangeRef>::toString(this->range));
		}

		std::string shardId;
		KeyRange range;
	};

	std::map<Version, std::vector<CheckpointMetaData>> pendingCheckpoints; // Pending checkpoint requests
	std::unordered_map<UID, CheckpointMetaData> checkpoints; // Existing and deleting checkpoints
	std::unordered_map<UID, ICheckpointReader*> liveCheckpointReaders; // Active checkpoint readers
	std::map<Version, std::vector<PendingNewShard>>
	    pendingAddRanges; // Pending requests to add ranges to physical shards
	std::map<Version, std::vector<KeyRange>>
	    pendingRemoveRanges; // Pending requests to remove ranges from physical shards
	std::deque<std::pair<Standalone<StringRef>, Standalone<StringRef>>> constructedData;

	bool shardAware; // True if the storage server is aware of the physical shards.

	LocalityData locality; // Storage server's locality information.

	// Histograms
	struct FetchKeysHistograms {
		const Reference<Histogram> latency;
		const Reference<Histogram> bytes;
		const Reference<Histogram> bandwidth;
		const Reference<Histogram> bytesPerCommit;

		FetchKeysHistograms()
		  : latency(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
		                                    FETCH_KEYS_LATENCY_HISTOGRAM,
		                                    Histogram::Unit::milliseconds)),
		    bytes(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
		                                  FETCH_KEYS_BYTES_HISTOGRAM,
		                                  Histogram::Unit::bytes)),
		    bandwidth(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
		                                      FETCH_KEYS_BYTES_PER_SECOND_HISTOGRAM,
		                                      Histogram::Unit::bytes_per_second)),
		    bytesPerCommit(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
		                                           FETCH_KEYS_BYTES_PER_COMMIT_HISTOGRAM,
		                                           Histogram::Unit::bytes)) {}
	} fetchKeysHistograms;

	Reference<Histogram> tlogCursorReadsLatencyHistogram;
	Reference<Histogram> ssVersionLockLatencyHistogram;
	Reference<Histogram> eagerReadsLatencyHistogram;
	Reference<Histogram> fetchKeysPTreeUpdatesLatencyHistogram;
	Reference<Histogram> tLogMsgsPTreeUpdatesLatencyHistogram;
	Reference<Histogram> storageUpdatesDurableLatencyHistogram;
	Reference<Histogram> storageCommitLatencyHistogram;
	Reference<Histogram> ssDurableVersionUpdateLatencyHistogram;
	// Histograms of requests sent to KVS.
	Reference<Histogram> readRangeBytesReturnedHistogram;
	Reference<Histogram> readRangeBytesLimitHistogram;
	Reference<Histogram> readRangeKVPairsReturnedHistogram;

	// watch map operations
	Reference<ServerWatchMetadata> getWatchMetadata(KeyRef key) const;
	KeyRef setWatchMetadata(Reference<ServerWatchMetadata> metadata);
	void deleteWatchMetadata(KeyRef key);
	void clearWatchMetadata();

	std::vector<StorageServerShard> getStorageServerShards(KeyRangeRef range);
	std::shared_ptr<MoveInShard> getMoveInShard(const UID& dataMoveId,
	                                            const Version version,
	                                            const ConductBulkLoad conductBulkLoad);

	class CurrentRunningFetchKeys {
		std::unordered_map<UID, double> startTimeMap;
		std::unordered_map<UID, KeyRange> keyRangeMap;

		static const StringRef emptyString;
		static const KeyRangeRef emptyKeyRange;

	public:
		void recordStart(const UID id, const KeyRange& keyRange) {
			startTimeMap[id] = now();
			keyRangeMap[id] = keyRange;
		}

		void recordFinish(const UID id) {
			startTimeMap.erase(id);
			keyRangeMap.erase(id);
		}

		std::pair<double, KeyRange> longestTime() const {
			if (numRunning() == 0) {
				return { -1, emptyKeyRange };
			}

			const double currentTime = now();
			double longest = 0;
			UID UIDofLongest;
			for (const auto& kv : startTimeMap) {
				const double currentRunningTime = currentTime - kv.second;
				if (longest <= currentRunningTime) {
					longest = currentRunningTime;
					UIDofLongest = kv.first;
				}
			}
			if (BUGGIFY) {
				UIDofLongest = deterministicRandom()->randomUniqueID();
			}
			auto it = keyRangeMap.find(UIDofLongest);
			if (it != keyRangeMap.end()) {
				return { longest, it->second };
			}
			return { -1, emptyKeyRange };
		}

		int numRunning() const { return startTimeMap.size(); }
	} currentRunningFetchKeys;

	Tag tag;
	std::vector<std::pair<Version, Tag>> history;
	std::vector<std::pair<Version, Tag>> allHistory;
	Version poppedAllAfter;
	std::map<Version, Arena>
	    freeable; // for each version, an Arena that must be held until that version is < oldestVersion
	Arena lastArena;
	double cpuUsage;
	double diskUsage;

	std::map<Version, Standalone<VerUpdateRef>> const& getMutationLog() const { return mutationLog; }
	std::map<Version, Standalone<VerUpdateRef>>& getMutableMutationLog() { return mutationLog; }
	VersionedData const& data() const { return versionedData; }
	VersionedData& mutableData() { return versionedData; }

	mutable double old_rate = 1.0;
	double currentRate() const {
		auto versionLag = version.get() - durableVersion.get();
		double res;
		if (versionLag >= SERVER_KNOBS->STORAGE_DURABILITY_LAG_HARD_MAX) {
			res = 0.0;
		} else if (versionLag > SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX) {
			res =
			    1.0 -
			    (double(versionLag - SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX) /
			     double(SERVER_KNOBS->STORAGE_DURABILITY_LAG_HARD_MAX - SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX));
		} else {
			res = 1.0;
		}
		if (res != old_rate) {
			TraceEvent(SevDebug, "LocalRatekeeperChange", thisServerID)
			    .detail("Old", old_rate)
			    .detail("New", res)
			    .detail("NonDurableVersions", versionLag);
			old_rate = res;
		}
		return res;
	}

	void addMutationToMutationLogOrStorage(
	    Version ver,
	    MutationRef m); // Appends m to mutationLog@ver, or to storage if ver==invalidVersion

	// Update the byteSample, and write the updates to the mutation log@ver, or to storage if ver==invalidVersion
	void byteSampleApplyMutation(MutationRef const& m, Version ver);
	void byteSampleApplySet(KeyValueRef kv, Version ver);
	void byteSampleApplyClear(KeyRangeRef range, Version ver);

	void popVersion(Version v, bool popAllTags = false) {
		if (logSystem && !isTss()) {
			if (v > poppedAllAfter) {
				popAllTags = true;
				poppedAllAfter = std::numeric_limits<Version>::max();
			}

			std::vector<std::pair<Version, Tag>>* hist = &history;
			std::vector<std::pair<Version, Tag>> allHistoryCopy;
			if (popAllTags) {
				allHistoryCopy = allHistory;
				hist = &allHistoryCopy;
			}

			while (hist->size() && v > hist->back().first) {
				logSystem->pop(v, hist->back().second);
				hist->pop_back();
			}
			if (hist->size()) {
				logSystem->pop(v, hist->back().second);
			} else {
				logSystem->pop(v, tag);
			}
		}
	}

	Standalone<VerUpdateRef>& addVersionToMutationLog(Version v) {
		// return existing version...
		auto m = mutationLog.find(v);
		if (m != mutationLog.end())
			return m->second;

		// ...or create a new one
		auto& u = mutationLog[v];
		u.version = v;
		if (lastArena.getSize() >= 65536)
			lastArena = Arena(4096);
		u.arena() = lastArena;
		counters.bytesInput += VERSION_OVERHEAD;
		return u;
	}

	MutationRef addMutationToMutationLog(Standalone<VerUpdateRef>& mLV, MutationRef const& m) {
		byteSampleApplyMutation(m, mLV.version);
		counters.bytesInput += mvccStorageBytes(m);
		return mLV.push_back_deep(mLV.arena(), m);
	}

	void setTssPair(UID pairId) {
		tssPairID = Optional<UID>(pairId);

		// Set up tss fault injection here, only if we are in simulated mode and with fault injection.
		// With fault injection enabled, the tss will start acting normal for a bit, then after the specified delay
		// start behaving incorrectly.
		if (g_network->isSimulated() && !g_simulator->speedUpSimulation &&
		    g_simulator->tssMode >= ISimulator::TSSMode::EnabledAddDelay) {
			tssFaultInjectTime = now() + deterministicRandom()->randomInt(60, 300);
			TraceEvent(SevWarnAlways, "TSSInjectFaultEnabled", thisServerID)
			    .detail("Mode", g_simulator->tssMode)
			    .detail("At", tssFaultInjectTime.get());
		}
	}

	// If a TSS is "in quarantine", it means it has incorrect data. It is effectively in a "zombie" state where it
	// rejects all read requests and ignores all non-private mutations and data movements, but otherwise is still part
	// of the cluster. The purpose of this state is to "freeze" the TSS state after a mismatch so a human operator can
	// investigate, but preventing a new storage process from replacing the TSS on the worker. It will still get removed
	// from the cluster if it falls behind on the mutation stream, or if its tss pair gets removed and its tag is no
	// longer valid.
	bool isTSSInQuarantine() const { return tssPairID.present() && tssInQuarantine; }

	void startTssQuarantine() {
		if (!tssInQuarantine) {
			// persist quarantine so it's still quarantined if rebooted
			storage.makeTssQuarantineDurable();
		}
		tssInQuarantine = true;
	}

	StorageServerDisk storage;

	KeyRangeMap<Reference<ShardInfo>> shards;
	KeyRangeMap<SSBulkLoadMetadata> ssBulkLoadMetadataMap; // store the latest bulkload task on ranges
	uint64_t shardChangeCounter; // max( shards->changecounter )

	KeyRangeMap<bool> cachedRangeMap; // indicates if a key-range is being cached

	// newestAvailableVersion[k]
	//   == invalidVersion -> k is unavailable at all versions
	//   <= storageVersion -> k is unavailable at all versions (but might be read anyway from storage if we are in the
	//   process of committing makeShardDurable)
	//   == v              -> k is readable (from storage+versionedData) @ [storageVersion,v], and not being updated
	//   when version increases
	//   == latestVersion  -> k is readable (from storage+versionedData) @ [storageVersion,version.get()], and thus
	//   stays available when version increases
	CoalescedKeyRangeMap<Version> newestAvailableVersion;

	CoalescedKeyRangeMap<Version> newestDirtyVersion; // Similar to newestAvailableVersion, but includes (only) keys
	                                                  // that were only partly available (due to cancelled fetchKeys)

	// The following are in rough order from newest to oldest
	Version lastTLogVersion, lastVersionWithData, restoredVersion, prevVersion;
	NotifiedVersion version;
	NotifiedVersion desiredOldestVersion; // We can increase oldestVersion (and then durableVersion) to this version
	                                      // when the disk permits
	NotifiedVersion oldestVersion; // See also storageVersion()
	NotifiedVersion durableVersion; // At least this version will be readable from storage after a power failure
	// In the event of the disk corruption, sqlite and redwood will either not recover, recover to durableVersion
	// but be unable to read some data, or they could lose the last commit. If we lose the last commit, the storage
	// might not be able to peek from the tlog (depending on when it sent the last pop). So this version just keeps
	// track of the version we committed to the storage engine before we did commit durableVersion.
	Version storageMinRecoverVersion = 0;
	Version rebootAfterDurableVersion;
	int8_t primaryLocality;
	NotifiedVersion knownCommittedVersion;

	Deque<std::pair<Version, Version>> recoveryVersionSkips;
	int64_t versionLag; // An estimate for how many versions it takes for the data to move from the logs to this storage
	                    // server

	Optional<UID> sourceTLogID; // the tLog from which the latest batch of versions were fetched

	ProtocolVersion logProtocol;

	Reference<ILogSystem> logSystem;
	Reference<ILogSystem::IPeekCursor> logCursor;

	// The version the cluster starts on. This value is not persisted and may
	// not be valid after a recovery.
	Version initialClusterVersion = 1;
	UID thisServerID;
	Optional<UID> tssPairID; // if this server is a tss, this is the id of its (ss) pair
	Optional<UID> ssPairID; // if this server is an ss, this is the id of its (tss) pair
	Optional<double> tssFaultInjectTime;
	bool tssInQuarantine;

	Key sk;
	Reference<AsyncVar<ServerDBInfo> const> db;
	Database cx;
	ActorCollection actors;

	CoalescedKeyRangeMap<bool, int64_t, KeyBytesMetric<int64_t>> byteSampleClears;
	AsyncVar<bool> byteSampleClearsTooLarge;
	Future<Void> byteSampleRecovery;
	Future<Void> durableInProgress;

	AsyncMap<Key, bool> watches;
	int64_t watchBytes;
	int64_t numWatches;
	AsyncVar<bool> noRecentUpdates;
	double lastUpdate;

	std::string folder;
	std::string checkpointFolder;
	std::string fetchedCheckpointFolder;
	std::string bulkDumpFolder;
	std::string bulkLoadFolder;

	// defined only during splitMutations()/addMutation()
	UpdateEagerReadInfo* updateEagerReads;

	FlowLock durableVersionLock;
	FlowLock fetchKeysParallelismLock;
	int64_t fetchKeysBytesBudget;
	AsyncVar<bool> fetchKeysBudgetUsed;
	int64_t fetchKeysTotalCommitBytes;
	std::vector<Promise<FetchInjectionInfo*>> readyFetchKeys;

	ThroughputLimiter fetchKeysLimiter;

	FlowLock serveFetchCheckpointParallelismLock;

	std::unordered_map<UID, std::shared_ptr<MoveInShard>> moveInShards;

	Reference<PriorityMultiLock> ssLock;
	std::vector<int> readPriorityRanks;

	Future<PriorityMultiLock::Lock> getReadLock(const Optional<ReadOptions>& options) {
		int readType = (int)(options.present() ? options.get().type : ReadType::NORMAL);
		readType = std::clamp<int>(readType, 0, readPriorityRanks.size() - 1);
		return ssLock->lock(readPriorityRanks[readType]);
	}

	FlowLock serveAuditStorageParallelismLock;

	FlowLock serveBulkDumpParallelismLock;

	int64_t instanceID;

	Promise<Void> otherError;
	Promise<Void> coreStarted;
	bool shuttingDown;

	Promise<Void> registerInterfaceAcceptingRequests;
	Future<Void> interfaceRegistered;

	bool behind;
	bool versionBehind;

	bool debug_inApplyUpdate;
	double debug_lastValidateTime;

	int64_t lastBytesInputEBrake;
	Version lastDurableVersionEBrake;

	int maxQueryQueue;
	int getAndResetMaxQueryQueueSize() {
		int val = maxQueryQueue;
		maxQueryQueue = 0;
		return val;
	}

	TransactionTagCounter transactionTagCounter;
	BusiestWriteTagContext busiestWriteTagContext;

	Optional<LatencyBandConfig> latencyBandConfig;

	struct Counters : CommonStorageCounters {

		Counter allQueries, systemKeyQueries, getKeyQueries, getValueQueries, getRangeQueries, getRangeSystemKeyQueries,
		    getRangeStreamQueries, lowPriorityQueries, rowsQueried, watchQueries, emptyQueries;

		// counters related to getMappedRange queries
		Counter getMappedRangeBytesQueried, finishedGetMappedRangeSecondaryQueries, getMappedRangeQueries,
		    finishedGetMappedRangeQueries;

		// Bytes pulled from TLogs, it counts the size of the key value pairs, e.g., key-value pair ("a", "b") is
		// counted as 2 Bytes.
		Counter logicalBytesInput;
		// Bytes pulled from TLogs for moving-in shards, it counts the mutations sent to the moving-in shard during
		// Fetching and Waiting phases.
		Counter logicalBytesMoveInOverhead;
		// Bytes committed to the underlying storage engine by SS, it counts the size of key value pairs.
		Counter kvCommitLogicalBytes;
		// Count of all clearRange operations to the storage engine.
		Counter kvClearRanges;
		// Count of all clearRange operations on a singlekeyRange(key delete) to the storage engine.
		Counter kvClearSingleKey;
		// ClearRange operations issued by FDB, instead of from users, e.g., ClearRange operations to remove a shard
		// from a storage server, as in removeDataRange().
		Counter kvSystemClearRanges;
		// Bytes of the mutations that have been removed from memory because they durable. The counting is same as
		// bytesInput, instead of the actual bytes taken in the storages, so that (bytesInput - bytesDurable) can
		// reflect the current memory footprint of MVCC.
		Counter bytesDurable;
		// Count of all fetchKey clearRange operations to the storage engine.
		Counter kvClearRangesInFetchKeys;

		// Bytes fetched by fetchChangeFeed for data movements.
		Counter feedBytesFetched;

		Counter sampledBytesCleared;
		Counter atomicMutations, changeFeedMutations, changeFeedMutationsDurable;
		Counter updateBatches, updateVersions;
		Counter loops;
		Counter fetchWaitingMS, fetchWaitingCount, fetchExecutingMS, fetchExecutingCount;
		Counter readsRejected;
		Counter wrongShardServer;
		Counter fetchedVersions;
		Counter fetchesFromLogs;
		// The following counters measure how many of lookups in the getMappedRangeQueries are effective. "Miss"
		// means fallback if fallback is enabled, otherwise means failure (so that another layer could implement
		// fallback).
		Counter quickGetValueHit, quickGetValueMiss, quickGetKeyValuesHit, quickGetKeyValuesMiss;

		// The number of logical bytes returned from storage engine, in response to readRange operations.
		Counter kvScanBytes;
		// The number of logical bytes returned from storage engine, in response to readValue operations.
		Counter kvGetBytes;
		// The number of keys read from storage engine by eagerReads.
		Counter eagerReadsKeys;
		// The count of readValue operation to the storage engine.
		Counter kvGets;
		// The count of readValue operation to the storage engine.
		Counter kvScans;
		// The count of commit operation to the storage engine.
		Counter kvCommits;
		// The count of change feed reads that hit disk
		Counter changeFeedDiskReads;
		// The count of ChangeServerKeys actions.
		Counter changeServerKeysAssigned;
		Counter changeServerKeysUnassigned;

		// The count of 'set' inserted to pTree. The actual ptree.insert() number could be higher, because of the range
		// clear split, see metric pTreeClearSplits.
		Counter pTreeSets;
		// The count of clear range inserted to pTree
		Counter pTreeClears;
		// If set is within a range of clear, the clear is split. It's tracking the number of splits, the split could be
		// expensive.
		Counter pTreeClearSplits;

		ReadLatencySamples readLatencySamples;
		std::unique_ptr<LatencySample> updateLatencySample;
		LatencyBands readLatencyBands;
		std::unique_ptr<LatencySample> ingestDurationLatencySample;

		explicit Counters(StorageServer* self)
		  : CommonStorageCounters("StorageServer", self->thisServerID.toString(), &self->metrics),
		    allQueries("QueryQueue", cc), systemKeyQueries("SystemKeyQueries", cc), getKeyQueries("GetKeyQueries", cc),
		    getValueQueries("GetValueQueries", cc), getRangeQueries("GetRangeQueries", cc),
		    getRangeSystemKeyQueries("GetRangeSystemKeyQueries", cc),
		    getMappedRangeQueries("GetMappedRangeQueries", cc), getRangeStreamQueries("GetRangeStreamQueries", cc),
		    lowPriorityQueries("LowPriorityQueries", cc), rowsQueried("RowsQueried", cc),
		    watchQueries("WatchQueries", cc), emptyQueries("EmptyQueries", cc),
		    logicalBytesInput("LogicalBytesInput", cc), logicalBytesMoveInOverhead("LogicalBytesMoveInOverhead", cc),
		    kvCommitLogicalBytes("KVCommitLogicalBytes", cc), kvClearRanges("KVClearRanges", cc),
		    kvClearSingleKey("KVClearSingleKey", cc), kvSystemClearRanges("KVSystemClearRanges", cc),
		    bytesDurable("BytesDurable", cc), feedBytesFetched("FeedBytesFetched", cc),
		    sampledBytesCleared("SampledBytesCleared", cc), atomicMutations("AtomicMutations", cc),
		    changeFeedMutations("ChangeFeedMutations", cc),
		    changeFeedMutationsDurable("ChangeFeedMutationsDurable", cc), updateBatches("UpdateBatches", cc),
		    updateVersions("UpdateVersions", cc), loops("Loops", cc), fetchWaitingMS("FetchWaitingMS", cc),
		    fetchWaitingCount("FetchWaitingCount", cc), fetchExecutingMS("FetchExecutingMS", cc),
		    fetchExecutingCount("FetchExecutingCount", cc), readsRejected("ReadsRejected", cc),
		    wrongShardServer("WrongShardServer", cc), fetchedVersions("FetchedVersions", cc),
		    fetchesFromLogs("FetchesFromLogs", cc), quickGetValueHit("QuickGetValueHit", cc),
		    quickGetValueMiss("QuickGetValueMiss", cc), quickGetKeyValuesHit("QuickGetKeyValuesHit", cc),
		    quickGetKeyValuesMiss("QuickGetKeyValuesMiss", cc), kvScanBytes("KVScanBytes", cc),
		    kvGetBytes("KVGetBytes", cc), eagerReadsKeys("EagerReadsKeys", cc), kvGets("KVGets", cc),
		    kvScans("KVScans", cc), kvCommits("KVCommits", cc), changeFeedDiskReads("ChangeFeedDiskReads", cc),
		    getMappedRangeBytesQueried("GetMappedRangeBytesQueried", cc),
		    finishedGetMappedRangeQueries("FinishedGetMappedRangeQueries", cc),
		    finishedGetMappedRangeSecondaryQueries("FinishedGetMappedRangeSecondaryQueries", cc),
		    pTreeSets("PTreeSets", cc), pTreeClears("PTreeClears", cc), pTreeClearSplits("PTreeClearSplits", cc),
		    changeServerKeysAssigned("ChangeServerKeysAssigned", cc),
		    changeServerKeysUnassigned("ChangeServerKeysUnassigned", cc),
		    kvClearRangesInFetchKeys("KvClearRangesInFetchKeys", cc), readLatencySamples(self->thisServerID),
		    updateLatencySample(std::make_unique<LatencySample>("UpdateLatencyMetrics",
		                                                        self->thisServerID,
		                                                        SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                        SERVER_KNOBS->LATENCY_SKETCH_ACCURACY)),
		    readLatencyBands("ReadLatencyBands", self->thisServerID, SERVER_KNOBS->STORAGE_LOGGING_DELAY),
		    ingestDurationLatencySample(std::make_unique<LatencySample>("IngestDurationMetrics",
		                                                                self->thisServerID,
		                                                                SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                                SERVER_KNOBS->LATENCY_SKETCH_ACCURACY)) {
			specialCounter(cc, "LastTLogVersion", [self]() { return self->lastTLogVersion; });
			specialCounter(cc, "Version", [self]() { return self->version.get(); });
			specialCounter(cc, "StorageVersion", [self]() { return self->storageVersion(); });
			specialCounter(cc, "DurableVersion", [self]() { return self->durableVersion.get(); });
			specialCounter(cc, "DesiredOldestVersion", [self]() { return self->desiredOldestVersion.get(); });
			specialCounter(cc, "VersionLag", [self]() { return self->versionLag; });
			specialCounter(cc, "LocalRate", [self] { return int64_t(self->currentRate() * 100); });

			specialCounter(
			    cc, "FetchKeysFetchActive", [self]() { return self->fetchKeysParallelismLock.activePermits(); });
			specialCounter(cc, "FetchKeysWaiting", [self]() { return self->fetchKeysParallelismLock.waiters(); });
			specialCounter(cc, "ServeFetchCheckpointActive", [self]() {
				return self->serveFetchCheckpointParallelismLock.activePermits();
			});
			specialCounter(cc, "ServeFetchCheckpointWaiting", [self]() {
				return self->serveFetchCheckpointParallelismLock.waiters();
			});
			specialCounter(cc, "ServeValidateStorageActive", [self]() {
				return self->serveAuditStorageParallelismLock.activePermits();
			});
			specialCounter(cc, "ServeValidateStorageWaiting", [self]() {
				return self->serveAuditStorageParallelismLock.waiters();
			});
			specialCounter(
			    cc, "ServerBulkDumpActive", [self]() { return self->serveBulkDumpParallelismLock.activePermits(); });
			specialCounter(
			    cc, "ServerBulkDumpWaiting", [self]() { return self->serveBulkDumpParallelismLock.waiters(); });
			specialCounter(cc, "QueryQueueMax", [self]() { return self->getAndResetMaxQueryQueueSize(); });
			specialCounter(cc, "ActiveWatches", [self]() { return self->numWatches; });
			specialCounter(cc, "WatchBytes", [self]() { return self->watchBytes; });
			specialCounter(cc, "KvstoreSizeTotal", [self]() { return std::get<0>(self->storage.getSize()); });
			specialCounter(cc, "KvstoreNodeTotal", [self]() { return std::get<1>(self->storage.getSize()); });
			specialCounter(cc, "KvstoreInlineKey", [self]() { return std::get<2>(self->storage.getSize()); });
		}
	} counters;

	// Bytes read from storage engine when a storage server starts.
	int64_t bytesRestored = 0;

	Reference<EventCacheHolder> storageServerSourceTLogIDEventHolder;

	std::shared_ptr<AccumulativeChecksumValidator> acsValidator = nullptr;

	std::shared_ptr<SSBulkLoadMetrics> bulkLoadMetrics = nullptr;

	StorageServer(IKeyValueStore* storage,
	              Reference<AsyncVar<ServerDBInfo> const> const& db,
	              StorageServerInterface const& ssi)
	  : shardAware(false), locality(ssi.locality),
	    tlogCursorReadsLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                            TLOG_CURSOR_READS_LATENCY_HISTOGRAM,
	                                                            Histogram::Unit::milliseconds)),
	    ssVersionLockLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                          SS_VERSION_LOCK_LATENCY_HISTOGRAM,
	                                                          Histogram::Unit::milliseconds)),
	    eagerReadsLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                       EAGER_READS_LATENCY_HISTOGRAM,
	                                                       Histogram::Unit::milliseconds)),
	    fetchKeysPTreeUpdatesLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                                  FETCH_KEYS_PTREE_UPDATES_LATENCY_HISTOGRAM,
	                                                                  Histogram::Unit::milliseconds)),
	    tLogMsgsPTreeUpdatesLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                                 TLOG_MSGS_PTREE_UPDATES_LATENCY_HISTOGRAM,
	                                                                 Histogram::Unit::milliseconds)),
	    storageUpdatesDurableLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                                  STORAGE_UPDATES_DURABLE_LATENCY_HISTOGRAM,
	                                                                  Histogram::Unit::milliseconds)),
	    storageCommitLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                          STORAGE_COMMIT_LATENCY_HISTOGRAM,
	                                                          Histogram::Unit::milliseconds)),
	    ssDurableVersionUpdateLatencyHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                                   SS_DURABLE_VERSION_UPDATE_LATENCY_HISTOGRAM,
	                                                                   Histogram::Unit::milliseconds)),
	    readRangeBytesReturnedHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                            SS_READ_RANGE_BYTES_RETURNED_HISTOGRAM,
	                                                            Histogram::Unit::bytes)),
	    readRangeBytesLimitHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                         SS_READ_RANGE_BYTES_LIMIT_HISTOGRAM,
	                                                         Histogram::Unit::bytes)),
	    readRangeKVPairsReturnedHistogram(Histogram::getHistogram(STORAGESERVER_HISTOGRAM_GROUP,
	                                                              SS_READ_RANGE_KV_PAIRS_RETURNED_HISTOGRAM,
	                                                              Histogram::Unit::countLinear)),
	    tag(invalidTag), poppedAllAfter(std::numeric_limits<Version>::max()), cpuUsage(0.0), diskUsage(0.0),
	    storage(this, storage), shardChangeCounter(0), lastTLogVersion(0), lastVersionWithData(0), restoredVersion(0),
	    prevVersion(0), rebootAfterDurableVersion(std::numeric_limits<Version>::max()),
	    primaryLocality(tagLocalityInvalid), knownCommittedVersion(0), versionLag(0), logProtocol(0),
	    thisServerID(ssi.id()), tssInQuarantine(false), db(db), actors(false),
	    trackShardAssignmentMinVersion(invalidVersion), byteSampleClears(false, "\xff\xff\xff"_sr),
	    durableInProgress(Void()), watchBytes(0), numWatches(0), noRecentUpdates(false), lastUpdate(now()),
	    updateEagerReads(nullptr), fetchKeysParallelismLock(SERVER_KNOBS->FETCH_KEYS_PARALLELISM),
	    fetchKeysBytesBudget(SERVER_KNOBS->STORAGE_FETCH_BYTES), fetchKeysBudgetUsed(false),
	    fetchKeysTotalCommitBytes(0), fetchKeysLimiter(SERVER_KNOBS->STORAGE_FETCH_KEYS_RATE_LIMIT),
	    serveFetchCheckpointParallelismLock(SERVER_KNOBS->SERVE_FETCH_CHECKPOINT_PARALLELISM),
	    ssLock(makeReference<PriorityMultiLock>(SERVER_KNOBS->STORAGE_SERVER_READ_CONCURRENCY,
	                                            SERVER_KNOBS->STORAGESERVER_READ_PRIORITIES)),
	    serveAuditStorageParallelismLock(SERVER_KNOBS->SERVE_AUDIT_STORAGE_PARALLELISM),
	    serveBulkDumpParallelismLock(SERVER_KNOBS->SS_SERVE_BULKDUMP_PARALLELISM),
	    instanceID(deterministicRandom()->randomUniqueID().first()), shuttingDown(false), behind(false),
	    versionBehind(false), debug_inApplyUpdate(false), debug_lastValidateTime(0), lastBytesInputEBrake(0),
	    lastDurableVersionEBrake(0), maxQueryQueue(0),
	    transactionTagCounter(ssi.id(),
	                          /*maxTagsTracked=*/SERVER_KNOBS->SS_THROTTLE_TAGS_TRACKED,
	                          /*minRateTracked=*/SERVER_KNOBS->MIN_TAG_READ_PAGES_RATE *
	                              CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE),
	    busiestWriteTagContext(ssi.id()), counters(this),
	    storageServerSourceTLogIDEventHolder(
	        makeReference<EventCacheHolder>(ssi.id().toString() + "/StorageServerSourceTLogID")),
	    acsValidator(CLIENT_KNOBS->ENABLE_MUTATION_CHECKSUM && CLIENT_KNOBS->ENABLE_ACCUMULATIVE_CHECKSUM &&
	                         !SERVER_KNOBS->ENABLE_VERSION_VECTOR && !SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST
	                     ? std::make_shared<AccumulativeChecksumValidator>()
	                     : nullptr),
	    bulkLoadMetrics(std::make_shared<SSBulkLoadMetrics>()) {
		readPriorityRanks = parseStringToVector<int>(SERVER_KNOBS->STORAGESERVER_READTYPE_PRIORITY_MAP, ',');
		ASSERT(readPriorityRanks.size() > (int)ReadType::MAX);
		version.initMetric("StorageServer.Version"_sr, counters.cc.getId());
		oldestVersion.initMetric("StorageServer.OldestVersion"_sr, counters.cc.getId());
		durableVersion.initMetric("StorageServer.DurableVersion"_sr, counters.cc.getId());
		desiredOldestVersion.initMetric("StorageServer.DesiredOldestVersion"_sr, counters.cc.getId());

		newestAvailableVersion.insert(allKeys, invalidVersion);
		newestDirtyVersion.insert(allKeys, invalidVersion);
		if (storage->shardAware()) {
			addShard(ShardInfo::newShard(this, StorageServerShard::notAssigned(allKeys)));
		} else {
			addShard(ShardInfo::newNotAssigned(allKeys));
		}

		cx = openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True);

		this->storage.kvCommitLogicalBytes = &counters.kvCommitLogicalBytes;
		this->storage.kvClearRanges = &counters.kvClearRanges;
		this->storage.kvClearSingleKey = &counters.kvClearSingleKey;
		this->storage.kvGets = &counters.kvGets;
		this->storage.kvScans = &counters.kvScans;
		this->storage.kvCommits = &counters.kvCommits;
	}

	//~StorageServer() { fclose(log); }

	// Puts the given shard into shards.  The caller is responsible for adding shards
	//   for all ranges in shards.getAffectedRangesAfterInsertion(newShard->keys)), because these
	//   shards are invalidated by the call.
	void addShard(ShardInfo* newShard) {
		ASSERT(!newShard->range().empty());
		newShard->setChangeCounter(++shardChangeCounter);
		// TraceEvent("AddShard", this->thisServerID).detail("KeyBegin", newShard->keys.begin).detail("KeyEnd", newShard->keys.end).detail("State",newShard->isReadable() ? "Readable" : newShard->notAssigned() ? "NotAssigned" : "Adding").detail("Version", this->version.get());
		/*auto affected = shards.getAffectedRangesAfterInsertion( newShard->keys, Reference<ShardInfo>() );
		for(auto i = affected.begin(); i != affected.end(); ++i)
		    shards.insert( *i, Reference<ShardInfo>() );*/

		if (shardAware && newShard->notAssigned()) {
			auto sh = shards.intersectingRanges(newShard->range());
			for (auto it = sh.begin(); it != sh.end(); ++it) {
				if (it->value().isValid() && !it->value()->notAssigned()) {
					TraceEvent(SevVerbose, "StorageServerAddShardClear")
					    .detail("NewShardRange", newShard->range())
					    .detail("Range", it->value()->range())
					    .detail("ShardID", format("%016llx", it->value()->getShardId()))
					    .detail("NewShardID", format("%016llx", newShard->getDesiredShardId()))
					    .detail("NewShardActualID", format("%016llx", newShard->getShardId()));
				}
			}
		}

		Reference<ShardInfo> rShard(newShard);
		shards.insert(newShard->range(), rShard);
	}
	void addMutation(Version version,
	                 bool fromFetch,
	                 MutationRef const& mutation,
	                 KeyRangeRef const& shard,
	                 UpdateEagerReadInfo* eagerReads);
	void setInitialVersion(Version ver) {
		version = ver;
		desiredOldestVersion = ver;
		oldestVersion = ver;
		durableVersion = ver;
		storageMinRecoverVersion = ver;
		lastVersionWithData = ver;
		restoredVersion = ver;

		mutableData().createNewVersion(ver);
		mutableData().forgetVersionsBefore(ver);
	}

	bool isTss() const { return tssPairID.present(); }

	bool isSSWithTSSPair() const { return ssPairID.present(); }

	void setSSWithTssPair(UID idOfTSS) { ssPairID = Optional<UID>(idOfTSS); }

	void clearSSWithTssPair() { ssPairID = Optional<UID>(); }

	// This is the maximum version that might be read from storage (the minimum version is durableVersion)
	Version storageVersion() const { return oldestVersion.get(); }

	bool isReadable(KeyRangeRef const& keys) const override {
		auto sh = shards.intersectingRanges(keys);
		for (auto i = sh.begin(); i != sh.end(); ++i)
			if (!i->value()->isReadable())
				return false;
		return true;
	}

	void checkChangeCounter(uint64_t oldShardChangeCounter, KeyRef const& key) {
		if (oldShardChangeCounter != shardChangeCounter && shards[key]->getChangeCounter() > oldShardChangeCounter) {
			CODE_PROBE(true, "shard change during getValueQ");
			throw wrong_shard_server();
		}
	}

	void checkChangeCounter(uint64_t oldShardChangeCounter, KeyRangeRef const& keys) {
		if (oldShardChangeCounter != shardChangeCounter) {
			auto sh = shards.intersectingRanges(keys);
			for (auto i = sh.begin(); i != sh.end(); ++i)
				if (i->value()->getChangeCounter() > oldShardChangeCounter) {
					CODE_PROBE(true, "shard change during range operation");
					throw wrong_shard_server();
				}
		}
	}

	Counter::Value queueSize() const { return counters.bytesInput.getValue() - counters.bytesDurable.getValue(); }

	// penalty used by loadBalance() to balance requests among SSes. We prefer SS with less write queue size.
	double getPenalty() const override {
		return std::max(std::max(1.0,
		                         (queueSize() - (SERVER_KNOBS->TARGET_BYTES_PER_STORAGE_SERVER -
		                                         2.0 * SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER)) /
		                             SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER),
		                (currentRate() < 1e-6 ? 1e6 : 1.0 / currentRate()));
	}

	// Normally the storage server prefers to serve read requests over making mutations
	// durable to disk. However, when the storage server falls to far behind on
	// making mutations durable, this function will change the priority to prefer writes.
	Future<Void> getQueryDelay() {
		if ((version.get() - durableVersion.get() > SERVER_KNOBS->LOW_PRIORITY_DURABILITY_LAG) ||
		    (queueSize() > SERVER_KNOBS->LOW_PRIORITY_STORAGE_QUEUE_BYTES)) {
			++counters.lowPriorityQueries;
			return delay(0, TaskPriority::LowPriorityRead);
		}
		return delay(0, TaskPriority::DefaultEndpoint);
	}

	template <class Reply>
	using isLoadBalancedReply = std::is_base_of<LoadBalancedReply, Reply>;

	template <class Reply>
	typename std::enable_if<isLoadBalancedReply<Reply>::value, void>::type
	sendErrorWithPenalty(const ReplyPromise<Reply>& promise, const Error& err, double penalty) {
		if (err.code() == error_code_wrong_shard_server) {
			++counters.wrongShardServer;
		}
		Reply reply;
		reply.error = err;
		reply.penalty = penalty;
		promise.send(reply);
	}

	template <class Reply>
	typename std::enable_if<!isLoadBalancedReply<Reply>::value, void>::type
	sendErrorWithPenalty(const ReplyPromise<Reply>& promise, const Error& err, double) {
		if (err.code() == error_code_wrong_shard_server) {
			++counters.wrongShardServer;
		}
		promise.sendError(err);
	}

	template <class Request>
	bool shouldRead(const Request& request) {
		auto rate = currentRate();
		if (isTSSInQuarantine() || (rate < SERVER_KNOBS->STORAGE_DURABILITY_LAG_REJECT_THRESHOLD &&
		                            deterministicRandom()->random01() >
		                                std::max(SERVER_KNOBS->STORAGE_DURABILITY_LAG_MIN_RATE,
		                                         rate / SERVER_KNOBS->STORAGE_DURABILITY_LAG_REJECT_THRESHOLD))) {
			sendErrorWithPenalty(request.reply, server_overloaded(), getPenalty());
			++counters.readsRejected;
			return false;
		}
		return true;
	}

	template <class Request, class HandleFunction>
	Future<Void> readGuard(const Request& request, const HandleFunction& fun) {
		bool read = shouldRead(request);
		if (!read) {
			return Void();
		}
		return fun(this, request);
	}

	void getSplitPoints(SplitRangeRequest const& req) override {
		try {
			metrics.getSplitPoints(req, {});
		} catch (Error& e) {
			req.reply.sendError(e);
		}
	}

	void maybeInjectTargetedRestart(Version v) {
		// inject an SS restart at most once per test
		if (g_network->isSimulated() && !g_simulator->speedUpSimulation &&
		    now() > g_simulator->injectTargetedSSRestartTime &&
		    rebootAfterDurableVersion == std::numeric_limits<Version>::max()) {
			CODE_PROBE(true, "Injecting SS targeted restart");
			TraceEvent("SimSSInjectTargetedRestart", thisServerID).detail("Version", v);
			rebootAfterDurableVersion = v;
			g_simulator->injectTargetedSSRestartTime = std::numeric_limits<double>::max();
		}
	}

	bool maybeInjectDelay() {
		if (g_network->isSimulated() && !g_simulator->speedUpSimulation && now() > g_simulator->injectSSDelayTime) {
			CODE_PROBE(true, "Injecting SS targeted delay");
			TraceEvent("SimSSInjectDelay", thisServerID).log();
			g_simulator->injectSSDelayTime = std::numeric_limits<double>::max();
			return true;
		}
		return false;
	}

	Future<Void> waitMetricsForReal(const WaitMetricsRequest& req) override;

	void addActor(Future<Void> future) override { actors.add(future); }

	void getStorageMetrics(const GetStorageMetricsRequest& req) override {
		StorageBytes sb = storage.getStorageBytes();
		metrics.getStorageMetrics(req,
		                          sb,
		                          counters.bytesInput.getRate(),
		                          versionLag,
		                          lastUpdate,
		                          counters.bytesDurable.getValue(),
		                          counters.bytesInput.getValue(),
		                          bulkLoadMetrics->getOngoingTasks());
	}

	void getSplitMetrics(const SplitMetricsRequest& req) override { this->metrics.splitMetrics(req); }

	void getHotRangeMetrics(const ReadHotSubRangeRequest& req) override { this->metrics.getReadHotRanges(req); }

	int64_t getHotShardsMetrics(const KeyRange& range) override { return this->metrics.getHotShards(range); }

	// Used for recording shard assignment history for auditStorage
	std::vector<std::pair<Version, KeyRange>> shardAssignmentHistory;
	Version trackShardAssignmentMinVersion; // == invalidVersion means tracking stopped

	std::string printShardAssignmentHistory() {
		std::string toPrint = "";
		for (const auto& [version, range] : shardAssignmentHistory) {
			toPrint = toPrint + std::to_string(version) + " ";
		}
		return toPrint;
	}

	void startTrackShardAssignment(Version startVersion) {
		ASSERT(startVersion != invalidVersion);
		ASSERT(trackShardAssignmentMinVersion == invalidVersion);
		trackShardAssignmentMinVersion = startVersion;
		return;
	}

	void stopTrackShardAssignment() { trackShardAssignmentMinVersion = invalidVersion; }

	std::vector<std::pair<Version, KeyRangeRef>> getShardAssignmentHistory(Version early, Version later) {
		std::vector<std::pair<Version, KeyRangeRef>> res;
		for (const auto& shardAssignment : shardAssignmentHistory) {
			if (shardAssignment.first >= early && shardAssignment.first <= later) {
				TraceEvent(SevVerbose, "ShardAssignmentHistoryGetOne", thisServerID)
				    .detail("Keys", shardAssignment.second)
				    .detail("Version", shardAssignment.first);
				res.push_back(shardAssignment);
			} else {
				TraceEvent(SevVerbose, "ShardAssignmentHistoryGetSkip", thisServerID)
				    .detail("Keys", shardAssignment.second)
				    .detail("Version", shardAssignment.first)
				    .detail("EarlyVersion", early)
				    .detail("LaterVersion", later);
			}
		}
		TraceEvent(SevVerbose, "ShardAssignmentHistoryGetDone", thisServerID)
		    .detail("EarlyVersion", early)
		    .detail("LaterVersion", later)
		    .detail("HistoryTotalSize", shardAssignmentHistory.size())
		    .detail("HistoryTotal", printShardAssignmentHistory());
		return res;
	}
};

const StringRef StorageServer::CurrentRunningFetchKeys::emptyString = ""_sr;
const KeyRangeRef StorageServer::CurrentRunningFetchKeys::emptyKeyRange =
    KeyRangeRef(StorageServer::CurrentRunningFetchKeys::emptyString,
                StorageServer::CurrentRunningFetchKeys::emptyString);

// If and only if key:=value is in (storage+versionedData),    // NOT ACTUALLY: and key < allKeys.end,
//   and H(key) < |key+value|/bytesPerSample,
//     let sampledSize = max(|key+value|,bytesPerSample)
//     persistByteSampleKeys.begin()+key := sampledSize is in storage
//     (key,sampledSize) is in byteSample

// So P(key is sampled) * sampledSize == |key+value|

void StorageServer::byteSampleApplyMutation(MutationRef const& m, Version ver) {
	if (m.type == MutationRef::ClearRange)
		byteSampleApplyClear(KeyRangeRef(m.param1, m.param2), ver);
	else if (m.type == MutationRef::SetValue)
		byteSampleApplySet(KeyValueRef(m.param1, m.param2), ver);
	else
		ASSERT(false); // Mutation of unknown type modifying byte sample
}

// watchMap Operations
Reference<ServerWatchMetadata> StorageServer::getWatchMetadata(KeyRef key) const {
	const WatchMapKey mapKey(key);
	const auto it = watchMap.find(mapKey);
	if (it == watchMap.end())
		return Reference<ServerWatchMetadata>();
	return it->second;
}

KeyRef StorageServer::setWatchMetadata(Reference<ServerWatchMetadata> metadata) {
	KeyRef keyRef = metadata->key.contents();
	watchMap[keyRef] = metadata;
	return keyRef;
}

void StorageServer::deleteWatchMetadata(KeyRef key) {
	const WatchMapKey mapKey(key);
	watchMap.erase(mapKey);
}

void StorageServer::clearWatchMetadata() {
	watchMap.clear();
}

#ifndef __INTEL_COMPILER
#pragma endregion
#endif

/////////////////////////////////// Validation ///////////////////////////////////////
#ifndef __INTEL_COMPILER
#pragma region Validation
#endif
bool validateRange(StorageServer::VersionedData::ViewAtVersion const& view,
                   KeyRangeRef range,
                   Version version,
                   UID id,
                   Version minInsertVersion) {
	// * Nonoverlapping: No clear overlaps a set or another clear, or adjoins another clear.
	// * Old mutations are erased: All items in versionedData.atLatest() have insertVersion() > durableVersion()

	//TraceEvent("ValidateRange", id).detail("KeyBegin", range.begin).detail("KeyEnd", range.end).detail("Version", version);
	KeyRef k;
	bool ok = true;
	bool kIsClear = false;
	auto i = view.lower_bound(range.begin);
	if (i != view.begin())
		--i;
	for (; i != view.end() && i.key() < range.end; ++i) {
		ASSERT(i.insertVersion() > minInsertVersion);
		if (kIsClear && i->isClearTo() ? i.key() <= k : i.key() < k) {
			TraceEvent(SevError, "InvalidRange", id)
			    .detail("Key1", k)
			    .detail("Key2", i.key())
			    .detail("Version", version);
			ok = false;
		}
		// ASSERT( i.key() >= k );
		kIsClear = i->isClearTo();
		k = kIsClear ? i->getEndKey() : i.key();
	}
	return ok;
}

void validate(StorageServer* data, bool force = false) {
	try {
		if (!data->shuttingDown && (force || (EXPENSIVE_VALIDATION))) {
			data->newestAvailableVersion.validateCoalesced();
			data->newestDirtyVersion.validateCoalesced();

			for (auto s = data->shards.ranges().begin(); s != data->shards.ranges().end(); ++s) {
				TraceEvent(SevVerbose, "ValidateShard", data->thisServerID)
				    .detail("Range", s->range())
				    .detail("ShardID", format("%016llx", s->value()->getShardId()))
				    .detail("DesiredShardID", format("%016llx", s->value()->getDesiredShardId()))
				    .detail("ShardRange", s->value()->range())
				    .detail("ShardState", s->value()->debugDescribeState())
				    .log();
				ASSERT(s->value()->range() == s->range());
				ASSERT(!s->value()->range().empty());
				if (data->shardAware) {
					s->value()->validate();
				}
			}

			for (auto s = data->shards.ranges().begin(); s != data->shards.ranges().end(); ++s) {
				if (s->value()->isReadable()) {
					auto ar = data->newestAvailableVersion.intersectingRanges(s->range());
					for (auto a = ar.begin(); a != ar.end(); ++a) {
						TraceEvent(SevVerbose, "ValidateShardReadable", data->thisServerID)
						    .detail("Range", s->range())
						    .detail("ShardRange", s->value()->range())
						    .detail("ShardState", s->value()->debugDescribeState())
						    .detail("AvailableRange", a->range())
						    .detail("AvailableVersion", a->value())
						    .log();
						ASSERT(a->value() == latestVersion);
					}
				}
			}

			// * versionedData contains versions [storageVersion(), version.get()].  It might also contain version
			// (version.get()+1), in which changeDurableVersion may be deleting ghosts, and/or it might
			//      contain later versions if applyUpdate is on the stack.
			ASSERT(data->data().getOldestVersion() == data->storageVersion());
			ASSERT(data->data().getLatestVersion() == data->version.get() ||
			       data->data().getLatestVersion() == data->version.get() + 1 ||
			       (data->debug_inApplyUpdate && data->data().getLatestVersion() > data->version.get()));

			auto latest = data->data().atLatest();

			// * Old shards are erased: versionedData.atLatest() has entries (sets or clear *begins*) only for keys in
			// readable or adding,transferred shards.
			for (auto s = data->shards.ranges().begin(); s != data->shards.ranges().end(); ++s) {
				ShardInfo* shard = s->value().getPtr();
				if (!shard->isInVersionedData()) {
					auto beginNext = latest.lower_bound(s->begin());
					auto endNext = latest.lower_bound(s->end());
					if (beginNext != endNext) {
						TraceEvent(SevError, "VF", data->thisServerID)
						    .detail("LastValidTime", data->debug_lastValidateTime)
						    .detail("KeyBegin", s->begin())
						    .detail("KeyEnd", s->end())
						    .detail("DbgState", shard->debugDescribeState())
						    .detail("FirstKey", beginNext.key())
						    .detail("LastKey", endNext != latest.end() ? endNext.key() : "End"_sr)
						    .detail("FirstInsertV", beginNext.insertVersion())
						    .detail("LastInsertV", endNext != latest.end() ? endNext.insertVersion() : invalidVersion);
					}
					ASSERT(beginNext == endNext);
				}

				if (shard->assigned() && data->shardAware) {
					TraceEvent(SevVerbose, "ValidateAssignedShard", data->thisServerID)
					    .detail("Range", shard->range())
					    .detailf("ShardID", "%016llx", shard->getShardId())
					    .detailf("DesiredShardID", "%016llx", shard->getDesiredShardId())
					    .detail("State", shard->debugDescribeState());
					ASSERT(shard->getShardId() != 0UL && shard->getDesiredShardId() != 0UL);
				}
			}

			// FIXME: do some change feed validation?

			latest.validate();
			validateRange(latest, allKeys, data->version.get(), data->thisServerID, data->durableVersion.get());

			data->debug_lastValidateTime = now();
		}
	} catch (...) {
		TraceEvent(SevError, "ValidationFailure", data->thisServerID)
		    .detail("LastValidTime", data->debug_lastValidateTime);
		throw;
	}
}
#ifndef __INTEL_COMPILER
#pragma endregion
#endif

void updateProcessStats(StorageServer* self) {
	if (g_network->isSimulated()) {
		// diskUsage and cpuUsage are not relevant in the simulator,
		// and relying on the actual values could break seed determinism
		self->cpuUsage = 100.0;
		self->diskUsage = 100.0;
		return;
	}

	SystemStatistics sysStats = getSystemStatistics();
	if (sysStats.initialized) {
		self->cpuUsage = 100 * sysStats.processCPUSeconds / sysStats.elapsed;
		self->diskUsage = 100 * std::max(0.0, (sysStats.elapsed - sysStats.processDiskIdleSeconds) / sysStats.elapsed);
	}
}

///////////////////////////////////// Queries /////////////////////////////////
#ifndef __INTEL_COMPILER
#pragma region Queries
#endif

															#line 2523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForVersionActor()
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class WaitForVersionActorActor>
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForVersionActorActorState {
															#line 2530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForVersionActorActorState(StorageServer* const& data,Version const& version,SpanContext const& spanContext) 
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   spanContext(spanContext),
															#line 1987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   span("SS:WaitForVersion"_loc, spanContext)
															#line 2543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForVersionActor", reinterpret_cast<unsigned long>(this));

	}
	~WaitForVersionActorActorState() 
	{
		fdb_probe_actor_destroy("waitForVersionActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->version.whenAtLeast(version);
															#line 1988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WaitForVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->FUTURE_VERSION_DELAY);
															#line 2564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForVersionActorActor*>(this)->actor_wait_state = 1;
															#line 1989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForVersionActorActor, 0, Void >*>(static_cast<WaitForVersionActorActor*>(this)));
															#line 1997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForVersionActorActor, 1, Void >*>(static_cast<WaitForVersionActorActor*>(this)));
															#line 2571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForVersionActorActorState();
		static_cast<WaitForVersionActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (version < data->oldestVersion.get())
															#line 2594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 1993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), loopDepth);
															#line 2598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 1995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForVersionActorActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForVersionActorActorState(); static_cast<WaitForVersionActorActor*>(this)->destroy(); return 0; }
															#line 2602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForVersionActorActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForVersionActorActorState();
		static_cast<WaitForVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (version < data->oldestVersion.get())
															#line 2614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 1993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), loopDepth);
															#line 2618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 1995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForVersionActorActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForVersionActorActorState(); static_cast<WaitForVersionActorActor*>(this)->destroy(); return 0; }
															#line 2622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForVersionActorActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForVersionActorActorState();
		static_cast<WaitForVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 2634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 2638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 2642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 2650 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForVersionActorActor*>(this)->actor_wait_state > 0) static_cast<WaitForVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForVersionActorActor*>(this)->ActorCallback< WaitForVersionActorActor, 0, Void >::remove();
		static_cast<WaitForVersionActorActor*>(this)->ActorCallback< WaitForVersionActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForVersionActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForVersionActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForVersionActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForVersionActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForVersionActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForVersionActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	SpanContext spanContext;
															#line 1987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 2791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForVersionActor()
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForVersionActorActor final : public Actor<Version>, public ActorCallback< WaitForVersionActorActor, 0, Void >, public ActorCallback< WaitForVersionActorActor, 1, Void >, public FastAllocated<WaitForVersionActorActor>, public WaitForVersionActorActorState<WaitForVersionActorActor> {
															#line 2796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForVersionActorActor>::operator new;
	using FastAllocated<WaitForVersionActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9985863557435548160UL, 7442012203525984768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForVersionActorActor, 0, Void >;
friend struct ActorCallback< WaitForVersionActorActor, 1, Void >;
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForVersionActorActor(StorageServer* const& data,Version const& version,SpanContext const& spanContext) 
															#line 2814 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WaitForVersionActorActorState<WaitForVersionActorActor>(data, version, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForVersionActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17177306746367876352UL, 6989725333754748672UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForVersionActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForVersionActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForVersionActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Version> waitForVersionActor( StorageServer* const& data, Version const& version, SpanContext const& spanContext ) {
															#line 1986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Version>(new WaitForVersionActorActor(data, version, spanContext));
															#line 2847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// If the latest commit version that mutated the shard(s) being served by the specified storage
// server is below the client specified read version then do a read at the latest commit version
// of the storage server.
Version getRealReadVersion(VersionVector& ssLatestCommitVersions, Tag& tag, Version specifiedReadVersion) {
	Version realReadVersion =
	    ssLatestCommitVersions.hasVersion(tag) ? ssLatestCommitVersions.getVersion(tag) : specifiedReadVersion;
	ASSERT(realReadVersion <= specifiedReadVersion);
	return realReadVersion;
}

// Find the latest commit version of the given tag.
Version getLatestCommitVersion(VersionVector& ssLatestCommitVersions, Tag& tag) {
	Version commitVersion =
	    ssLatestCommitVersions.hasVersion(tag) ? ssLatestCommitVersions.getVersion(tag) : invalidVersion;
	return commitVersion;
}

Future<Version> waitForVersion(StorageServer* data, Version version, SpanContext spanContext) {
	if (version == latestVersion) {
		version = std::max(Version(1), data->version.get());
	}

	if (version < data->oldestVersion.get() || version <= 0) {
		// TraceEvent(SevDebug, "WFVThrow", data->thisServerID).detail("Version", version).detail("OldestVersion", data->oldestVersion.get());
		return transaction_too_old();
	} else if (version <= data->version.get()) {
		return version;
	}

	if ((data->behind || data->versionBehind) && version > data->version.get()) {
		return process_behind();
	}

	if (deterministicRandom()->random01() < 0.001) {
		TraceEvent("WaitForVersion1000x").log();
	}
	return waitForVersionActor(data, version, spanContext);
}

Future<Version> waitForVersion(StorageServer* data,
                               Version commitVersion,
                               Version readVersion,
                               SpanContext spanContext) {
	ASSERT(commitVersion == invalidVersion || commitVersion < readVersion);

	if (commitVersion == invalidVersion) {
		return waitForVersion(data, readVersion, spanContext);
	}

	if (readVersion == latestVersion) {
		readVersion = std::max(Version(1), data->version.get());
	}

	if (readVersion < data->oldestVersion.get() || readVersion <= 0) {
		return transaction_too_old();
	} else {
		// It is correct to read any version between [commitVersion, readVersion],
		// because version vector guarantees no mutations between them.
		if (commitVersion < data->oldestVersion.get()) {
			if (data->version.get() < readVersion) {
				// Majority of the case, try using higher version to avoid
				// transaction_too_old error when oldestVersion advances.
				// BTW, any version in the range [oldestVersion, data->version.get()] is valid in this case.
				return data->version.get();
			} else {
				ASSERT(readVersion >= data->oldestVersion.get());
				return readVersion;
			}
		} else if (commitVersion <= data->version.get()) {
			return commitVersion;
		}
	}

	if ((data->behind || data->versionBehind) && commitVersion > data->version.get()) {
		return process_behind();
	}

	if (deterministicRandom()->random01() < 0.001) {
		TraceEvent("WaitForVersion1000x");
	}
	return waitForVersionActor(data, std::max(commitVersion, data->oldestVersion.get()), spanContext);
}

															#line 2935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForVersionNoTooOld()
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class WaitForVersionNoTooOldActor>
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForVersionNoTooOldActorState {
															#line 2942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForVersionNoTooOldActorState(StorageServer* const& data,Version const& version) 
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version)
															#line 2951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this));

	}
	~WaitForVersionNoTooOldActorState() 
	{
		fdb_probe_actor_destroy("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (version == latestVersion)
															#line 2966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				version = std::max(Version(1), data->version.get());
															#line 2970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (version <= data->version.get())
															#line 2974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<WaitForVersionNoTooOldActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForVersionNoTooOldActorState(); static_cast<WaitForVersionNoTooOldActor*>(this)->destroy(); return 0; }
															#line 2978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<WaitForVersionNoTooOldActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
				this->~WaitForVersionNoTooOldActorState();
				static_cast<WaitForVersionNoTooOldActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->version.whenAtLeast(version);
															#line 2097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WaitForVersionNoTooOldActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 2101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->FUTURE_VERSION_DELAY);
															#line 2992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForVersionNoTooOldActor*>(this)->actor_wait_state = 1;
															#line 2098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForVersionNoTooOldActor, 0, Void >*>(static_cast<WaitForVersionNoTooOldActor*>(this)));
															#line 2101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForVersionNoTooOldActor, 1, Void >*>(static_cast<WaitForVersionNoTooOldActor*>(this)));
															#line 2999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForVersionNoTooOldActorState();
		static_cast<WaitForVersionNoTooOldActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForVersionNoTooOldActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForVersionNoTooOldActorState(); static_cast<WaitForVersionNoTooOldActor*>(this)->destroy(); return 0; }
															#line 3022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForVersionNoTooOldActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForVersionNoTooOldActorState();
		static_cast<WaitForVersionNoTooOldActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForVersionNoTooOldActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForVersionNoTooOldActorState(); static_cast<WaitForVersionNoTooOldActor*>(this)->destroy(); return 0; }
															#line 3034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForVersionNoTooOldActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForVersionNoTooOldActorState();
		static_cast<WaitForVersionNoTooOldActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 3046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 3050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 3054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 3062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 3066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForVersionNoTooOldActor*>(this)->actor_wait_state > 0) static_cast<WaitForVersionNoTooOldActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForVersionNoTooOldActor*>(this)->ActorCallback< WaitForVersionNoTooOldActor, 0, Void >::remove();
		static_cast<WaitForVersionNoTooOldActor*>(this)->ActorCallback< WaitForVersionNoTooOldActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForVersionNoTooOldActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForVersionNoTooOldActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForVersionNoTooOldActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForVersionNoTooOldActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForVersionNoTooOldActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForVersionNoTooOldActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 3199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForVersionNoTooOld()
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForVersionNoTooOldActor final : public Actor<Version>, public ActorCallback< WaitForVersionNoTooOldActor, 0, Void >, public ActorCallback< WaitForVersionNoTooOldActor, 1, Void >, public FastAllocated<WaitForVersionNoTooOldActor>, public WaitForVersionNoTooOldActorState<WaitForVersionNoTooOldActor> {
															#line 3204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForVersionNoTooOldActor>::operator new;
	using FastAllocated<WaitForVersionNoTooOldActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8566883761394579200UL, 11705341299304252160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForVersionNoTooOldActor, 0, Void >;
friend struct ActorCallback< WaitForVersionNoTooOldActor, 1, Void >;
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForVersionNoTooOldActor(StorageServer* const& data,Version const& version) 
															#line 3222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WaitForVersionNoTooOldActorState<WaitForVersionNoTooOldActor>(data, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14315589494631704320UL, 1805358750176616448UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVersionNoTooOldActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForVersionNoTooOld");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForVersionNoTooOld", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForVersionNoTooOldActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Version> waitForVersionNoTooOld( StorageServer* const& data, Version const& version ) {
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Version>(new WaitForVersionNoTooOldActor(data, version));
															#line 3255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

															#line 3260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForMinVersion()
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class WaitForMinVersionActor>
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForMinVersionActorState {
															#line 3267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForMinVersionActorState(StorageServer* const& data,Version const& version) 
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version)
															#line 3276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForMinVersion", reinterpret_cast<unsigned long>(this));

	}
	~WaitForMinVersionActorState() 
	{
		fdb_probe_actor_destroy("waitForMinVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (version == latestVersion)
															#line 3291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				version = std::max(Version(1), data->version.get());
															#line 3295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (version < data->oldestVersion.get() || version <= 0)
															#line 3299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<WaitForMinVersionActor*>(this)->SAV<Version>::futures) { (void)(data->oldestVersion.get()); this->~WaitForMinVersionActorState(); static_cast<WaitForMinVersionActor*>(this)->destroy(); return 0; }
															#line 3303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<WaitForMinVersionActor*>(this)->SAV< Version >::value()) Version(data->oldestVersion.get());
				this->~WaitForMinVersionActorState();
				static_cast<WaitForMinVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (version <= data->version.get())
															#line 3313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (!static_cast<WaitForMinVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForMinVersionActorState(); static_cast<WaitForMinVersionActor*>(this)->destroy(); return 0; }
															#line 3317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					new (&static_cast<WaitForMinVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
					this->~WaitForMinVersionActorState();
					static_cast<WaitForMinVersionActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 2122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->version.whenAtLeast(version);
															#line 2121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WaitForMinVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->FUTURE_VERSION_DELAY);
															#line 3332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForMinVersionActor*>(this)->actor_wait_state = 1;
															#line 2122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForMinVersionActor, 0, Void >*>(static_cast<WaitForMinVersionActor*>(this)));
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForMinVersionActor, 1, Void >*>(static_cast<WaitForMinVersionActor*>(this)));
															#line 3339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForMinVersionActorState();
		static_cast<WaitForMinVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForMinVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForMinVersionActorState(); static_cast<WaitForMinVersionActor*>(this)->destroy(); return 0; }
															#line 3362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForMinVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForMinVersionActorState();
		static_cast<WaitForMinVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WaitForMinVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WaitForMinVersionActorState(); static_cast<WaitForMinVersionActor*>(this)->destroy(); return 0; }
															#line 3374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForMinVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WaitForMinVersionActorState();
		static_cast<WaitForMinVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 2126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 3386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 3390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 3394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 2126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (deterministicRandom()->random01() < 0.001)
															#line 3402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "ShardServerFutureVersion1000x", data->thisServerID) .detail("Version", version) .detail("MyVersion", data->version.get()) .detail("ServerID", data->thisServerID);
															#line 3406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(future_version(), loopDepth);
															#line 3410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForMinVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForMinVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForMinVersionActor*>(this)->ActorCallback< WaitForMinVersionActor, 0, Void >::remove();
		static_cast<WaitForMinVersionActor*>(this)->ActorCallback< WaitForMinVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForMinVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForMinVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForMinVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForMinVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForMinVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForMinVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 3539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForMinVersion()
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WaitForMinVersionActor final : public Actor<Version>, public ActorCallback< WaitForMinVersionActor, 0, Void >, public ActorCallback< WaitForMinVersionActor, 1, Void >, public FastAllocated<WaitForMinVersionActor>, public WaitForMinVersionActorState<WaitForMinVersionActor> {
															#line 3544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForMinVersionActor>::operator new;
	using FastAllocated<WaitForMinVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2046934965276570368UL, 3416679953703041280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForMinVersionActor, 0, Void >;
friend struct ActorCallback< WaitForMinVersionActor, 1, Void >;
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WaitForMinVersionActor(StorageServer* const& data,Version const& version) 
															#line 3562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WaitForMinVersionActorState<WaitForMinVersionActor>(data, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForMinVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3358323868325720064UL, 6852897307082981376UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForMinVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForMinVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForMinVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForMinVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Version> waitForMinVersion( StorageServer* const& data, Version const& version ) {
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Version>(new WaitForMinVersionActor(data, version));
															#line 3595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

std::vector<StorageServerShard> StorageServer::getStorageServerShards(KeyRangeRef range) {
	std::vector<StorageServerShard> res;
	for (auto t : this->shards.intersectingRanges(range)) {
		res.push_back(t.value()->toStorageServerShard());
	}
	return res;
}

static Error dataMoveConflictError(const bool isTss) {
	if (isTss && g_network->isSimulated()) {
		// TSS data move conflicts can happen in both sim and prod, but in sim,
		// the sev40s cause failures of Joshua tests. We have been using please_reboot
		// as means to avoid sev40s, but semantically this is undesired because rebooting
		// will not fix/heal the TSS.
		// TODO: think of a proper TSS move conflict error that does not trigger
		// reboot but also avoids sev40. And throw that error regardless of sim or prod.
		return please_reboot();
	}
	return data_move_conflict();
}

std::shared_ptr<MoveInShard> StorageServer::getMoveInShard(const UID& dataMoveId,
                                                           const Version version,
                                                           const ConductBulkLoad conductBulkLoad) {
	for (auto& [id, moveInShard] : this->moveInShards) {
		if (moveInShard->dataMoveId() == dataMoveId && moveInShard->meta->createVersion == version) {
			return moveInShard;
		}
	}

	const UID id = deterministicRandom()->randomUniqueID();
	std::shared_ptr<MoveInShard> shard = std::make_shared<MoveInShard>(this, id, dataMoveId, version, conductBulkLoad);
	auto [it, inserted] = this->moveInShards.emplace(id, shard);
	ASSERT(inserted);
	TraceEvent(SevDebug, "SSNewMoveInShard", this->thisServerID)
	    .detail("MoveInShard", shard->toString())
	    .detail("ConductBulkLoad", conductBulkLoad);
	return shard;
}

															#line 3640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getValueQ()
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class GetValueQActor>
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetValueQActorState {
															#line 3647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetValueQActorState(StorageServer* const& data,GetValueRequest const& req) 
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req),
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   resultSize(0)
															#line 3658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getValueQ", reinterpret_cast<unsigned long>(this));

	}
	~GetValueQActorState() 
	{
		fdb_probe_actor_destroy("getValueQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Span span("SS:getValue"_loc, req.spanContext);
															#line 3673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			try {
															#line 2183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++data->counters.getValueQueries;
															#line 2184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++data->counters.allQueries;
															#line 2185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (req.key.startsWith(systemKeys.begin))
															#line 3681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					++data->counters.systemKeyQueries;
															#line 3685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
															#line 2188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				data->maxQueryQueue = std::max<int>( data->maxQueryQueue, data->counters.allQueries.getValue() - data->counters.finishedQueries.getValue());
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = data->getQueryDelay();
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (static_cast<GetValueQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetValueQActor*>(this)->actor_wait_state = 1;
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetValueQActor, 0, Void >*>(static_cast<GetValueQActor*>(this)));
															#line 3698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetValueQActorState();
		static_cast<GetValueQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->transactionTagCounter.addRequest(req.tags, req.key.size() + resultSize);
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		++data->counters.finishedQueries;
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		double duration = g_network->timer() - req.requestTime();
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::READ, trackedReadType(req));
															#line 2305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::READ_VALUE, trackedReadType(req));
															#line 2306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->latencyBandConfig.present())
															#line 3737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int maxReadBytes = data->latencyBandConfig.get().readConfig.maxReadBytes.orDefault(std::numeric_limits<int>::max());
															#line 2309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencyBands.addMeasurement(duration, 1, Filtered(resultSize > maxReadBytes));
															#line 3743 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<GetValueQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetValueQActorState(); static_cast<GetValueQActor*>(this)->destroy(); return 0; }
															#line 3747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<GetValueQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetValueQActorState();
		static_cast<GetValueQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!canReplyWith(e))
															#line 3760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->sendErrorWithPenalty(req.reply, e, data->getPenalty());
															#line 3768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<PriorityMultiLock::Lock> __when_expr_1 = data->getReadLock(req.options);
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetValueQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetValueQActor*>(this)->actor_wait_state = 2;
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*>(static_cast<GetValueQActor*>(this)));
															#line 3790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<PriorityMultiLock::Lock> __when_expr_1 = data->getReadLock(req.options);
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetValueQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetValueQActor*>(this)->actor_wait_state = 2;
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*>(static_cast<GetValueQActor*>(this)));
															#line 3806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetValueQActor*>(this)->actor_wait_state > 0) static_cast<GetValueQActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueQActor*>(this)->ActorCallback< GetValueQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetValueQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		queueWaitEnd = g_network->timer();
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( queueWaitEnd - req.requestTime(), ReadLatencySamples::READ_QUEUE_WAIT, trackedReadType(req));
															#line 2201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 3894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", req.options.get().debugID.get().first(), "getValueQ.DoRead");
															#line 3898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		v = Optional<Value>();
															#line 2207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		Version commitVersion = getLatestCommitVersion(req.ssLatestCommitVersions, data->tag);
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Version> __when_expr_2 = waitForVersion(data, commitVersion, req.version, req.spanContext);
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetValueQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetValueQActor*>(this)->actor_wait_state = 3;
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetValueQActor, 2, Version >*>(static_cast<GetValueQActor*>(this)));
															#line 3913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(PriorityMultiLock::Lock const& __readLock,int loopDepth) 
	{
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readLock = __readLock;
															#line 3922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(PriorityMultiLock::Lock && __readLock,int loopDepth) 
	{
		readLock = std::move(__readLock);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetValueQActor*>(this)->actor_wait_state > 0) static_cast<GetValueQActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueQActor*>(this)->ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock const& value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock && value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( g_network->timer() - queueWaitEnd, ReadLatencySamples::READ_VERSION_WAIT, trackedReadType(req));
															#line 2212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 4003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", req.options.get().debugID.get().first(), "getValueQ.AfterVersion");
															#line 4007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		changeCounter = data->shardChangeCounter;
															#line 2219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!data->shards[req.key]->isReadable())
															#line 4013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch2(wrong_shard_server(), loopDepth);
															#line 4017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		path = 0;
															#line 2225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		auto i = data->data().at(version).lastLessOrEqual(req.key);
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (i && i->isValue() && i.key() == req.key)
															#line 4025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			v = (Value)i->getValue();
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			path = 1;
															#line 4031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7(loopDepth);
		}
		else
		{
															#line 2229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!i || !i->isClearTo() || i->getEndKey() <= req.key)
															#line 4038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				path = 2;
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_3 = data->storage.readValue(req.key, req.options);
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (static_cast<GetValueQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetValueQActor*>(this)->actor_wait_state = 4;
															#line 2231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetValueQActor, 3, Optional<Value> >*>(static_cast<GetValueQActor*>(this)));
															#line 4051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont4when1(Version const& __version,int loopDepth) 
	{
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = __version;
															#line 4066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Version && __version,int loopDepth) 
	{
		version = std::move(__version);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetValueQActor*>(this)->actor_wait_state > 0) static_cast<GetValueQActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueQActor*>(this)->ActorCallback< GetValueQActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetValueQActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		DEBUG_MUTATION("ShardGetValue", version, MutationRef(MutationRef::DebugKey, req.key, v.present() ? v.get() : "<null>"_sr), data->thisServerID);
															#line 2246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		DEBUG_MUTATION("ShardGetPath", version, MutationRef(MutationRef::DebugKey, req.key, path == 0 ? "0"_sr : path == 1 ? "1"_sr : "2"_sr), data->thisServerID);
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (v.present())
															#line 4149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.rowsQueried;
															#line 2264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			resultSize = v.get().size();
															#line 2265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.bytesQueried += resultSize;
															#line 4157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.emptyQueries;
															#line 4163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (SERVER_KNOBS->READ_SAMPLING_ENABLED)
															#line 4167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int64_t bytesReadPerKSecond = v.present() ? std::max((int64_t)(req.key.size() + v.get().size()), SERVER_KNOBS->EMPTY_READ_PENALTY) : SERVER_KNOBS->EMPTY_READ_PENALTY;
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->metrics.notifyBytesReadPerKSecond(req.key, bytesReadPerKSecond);
															#line 4173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 4177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", req.options.get().debugID.get().first(), "getValueQ.AfterRead");
															#line 4181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		auto cached = data->cachedRangeMap[req.key];
															#line 2288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetValueReply reply(v, cached);
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reply.penalty = data->getPenalty();
															#line 2290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(reply);
															#line 4191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Optional<Value> const& vv,int loopDepth) 
	{
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvGetBytes += vv.expectedSize();
															#line 2234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (version < data->storageVersion())
															#line 4208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "transaction_too_old after readValue");
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch2(transaction_too_old(), loopDepth);
															#line 4214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->checkChangeCounter(changeCounter, req.key);
															#line 2239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		v = vv;
															#line 4220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Optional<Value> && vv,int loopDepth) 
	{
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvGetBytes += vv.expectedSize();
															#line 2234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (version < data->storageVersion())
															#line 4231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "transaction_too_old after readValue");
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch2(transaction_too_old(), loopDepth);
															#line 4237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->checkChangeCounter(changeCounter, req.key);
															#line 2239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		v = vv;
															#line 4243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Optional<Value> const& vv,int loopDepth) 
	{
		loopDepth = a_body1cont12(vv, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Optional<Value> && vv,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(vv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetValueQActor*>(this)->actor_wait_state > 0) static_cast<GetValueQActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueQActor*>(this)->ActorCallback< GetValueQActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetValueQActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetValueQActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont18(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetValueRequest req;
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t resultSize;
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	PriorityMultiLock::Lock readLock;
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double queueWaitEnd;
															#line 2206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Optional<Value> v;
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	uint64_t changeCounter;
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int path;
															#line 4354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getValueQ()
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetValueQActor final : public Actor<Void>, public ActorCallback< GetValueQActor, 0, Void >, public ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >, public ActorCallback< GetValueQActor, 2, Version >, public ActorCallback< GetValueQActor, 3, Optional<Value> >, public FastAllocated<GetValueQActor>, public GetValueQActorState<GetValueQActor> {
															#line 4359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetValueQActor>::operator new;
	using FastAllocated<GetValueQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10288460924825275648UL, 5841447075340122880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetValueQActor, 0, Void >;
friend struct ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >;
friend struct ActorCallback< GetValueQActor, 2, Version >;
friend struct ActorCallback< GetValueQActor, 3, Optional<Value> >;
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetValueQActor(StorageServer* const& data,GetValueRequest const& req) 
															#line 4379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetValueQActorState<GetValueQActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getValueQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17920039446934625280UL, 7083594275336435200UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getValueQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getValueQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetValueQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetValueQActor, 1, PriorityMultiLock::Lock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetValueQActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetValueQActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> getValueQ( StorageServer* const& data, GetValueRequest const& req ) {
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new GetValueQActor(data, req));
															#line 4415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Pessimistic estimate the number of overhead bytes used by each
// watch. Watch key references are stored in an AsyncMap<Key,bool>, and actors
// must be kept alive until the watch is finished.
extern size_t WATCH_OVERHEAD_WATCHQ, WATCH_OVERHEAD_WATCHIMPL;

															#line 4425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watchWaitForValueChange()
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class WatchWaitForValueChangeActor>
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WatchWaitForValueChangeActorState {
															#line 4432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WatchWaitForValueChangeActorState(StorageServer* const& data,SpanContext const& parent,KeyRef const& key) 
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   parent(parent),
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   key(key),
															#line 2321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   spanLocation("SS:watchWaitForValueChange"_loc),
															#line 2322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   span(spanLocation, parent),
															#line 2323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   metadata(data->getWatchMetadata(key))
															#line 4449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchWaitForValueChange", reinterpret_cast<unsigned long>(this));

	}
	~WatchWaitForValueChangeActorState() 
	{
		fdb_probe_actor_destroy("watchWaitForValueChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (metadata->debugID.present())
															#line 4464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2325 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent("WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.Before");
															#line 4468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			originalMetadataVersion = metadata->version;
															#line 2330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(waitForVersionNoTooOld(data, metadata->version));
															#line 2330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 1;
															#line 2330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchWaitForValueChangeActor, 0, Void >*>(static_cast<WatchWaitForValueChangeActor*>(this)));
															#line 4481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchWaitForValueChangeActorState();
		static_cast<WatchWaitForValueChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (metadata->debugID.present())
															#line 4504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.AfterVersion");
															#line 4508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		minVersion = data->data().latestVersion;
															#line 2337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		watchFuture = data->watches.onChange(metadata->key);
															#line 2338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		options = ReadOptions();
															#line 2339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 4518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (metadata->debugID.present())
															#line 4527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.AfterVersion");
															#line 4531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		minVersion = data->data().latestVersion;
															#line 2337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		watchFuture = data->watches.onChange(metadata->key);
															#line 2338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		options = ReadOptions();
															#line 2339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 4541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state > 0) static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 0;
		static_cast<WatchWaitForValueChangeActor*>(this)->ActorCallback< WatchWaitForValueChangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchWaitForValueChangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			metadata = data->getWatchMetadata(key);
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			latest = data->version.get();
															#line 2343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			options.debugID = metadata->debugID;
															#line 2345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(latest >= minVersion && latest < data->data().latestVersion, "Starting watch loop with latestVersion > data->version", probe::decoration::rare);
															#line 2348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			GetValueRequest getReq(span.context, metadata->key, latest, metadata->tags, options, VersionVector());
															#line 2349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getValue = getValueQ( data, getReq);
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<GetValueReply> __when_expr_1 = getReq.reply.getFuture();
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 2;
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >*>(static_cast<WatchWaitForValueChangeActor*>(this)));
															#line 4652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		watchFuture = data->watches.onChange(metadata->key);
															#line 2431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = data->version.whenAtLeast(data->data().latestVersion);
															#line 2431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 4;
															#line 2431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchWaitForValueChangeActor, 3, Void >*>(static_cast<WatchWaitForValueChangeActor*>(this)));
															#line 4676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() != error_code_transaction_too_old)
															#line 4686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "Reading a watched key failed with transaction_too_old");
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(GetValueReply const& reply,int loopDepth) 
	{
															#line 2352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		span = Span(spanLocation, parent);
															#line 2354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (reply.error.present())
															#line 4711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(reply.error.get().code() != error_code_future_version);
															#line 2356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(reply.error.get(), loopDepth);
															#line 4717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (BUGGIFY)
															#line 4721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(transaction_too_old(), loopDepth);
															#line 4725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		DEBUG_MUTATION("ShardWatchValue", latest, MutationRef(MutationRef::DebugKey, metadata->key, reply.value.present() ? StringRef(reply.value.get()) : "<null>"_sr), data->thisServerID);
															#line 2369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (metadata->debugID.present())
															#line 4731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent( "WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.AfterRead");
															#line 4735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		Version waitVersion = minVersion;
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (reply.value != metadata->value)
															#line 4741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (latest >= metadata->version)
															#line 4745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<WatchWaitForValueChangeActor*>(this)->SAV<Version>::futures) { (void)(latest); this->~WatchWaitForValueChangeActorState(); static_cast<WatchWaitForValueChangeActor*>(this)->destroy(); return 0; }
															#line 4749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<WatchWaitForValueChangeActor*>(this)->SAV< Version >::value()) Version(std::move(latest)); // state_var_RVO
				this->~WatchWaitForValueChangeActorState();
				static_cast<WatchWaitForValueChangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (metadata->version > originalMetadataVersion)
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					CODE_PROBE(true, "racing watches for same value at different versions", probe::decoration::rare);
															#line 2386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (metadata->version > waitVersion)
															#line 4765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					{
															#line 2387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						waitVersion = metadata->version;
															#line 4769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->watchBytes > SERVER_KNOBS->MAX_STORAGE_SERVER_WATCH_BYTES)
															#line 4776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "Too many watches, reverting to polling");
															#line 2394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(watch_cancelled(), loopDepth);
															#line 4782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		watchBytes = (metadata->key.expectedSize() + metadata->value.expectedSize() + key.expectedSize() + sizeof(Reference<ServerWatchMetadata>) + sizeof(ServerWatchMetadata) + WATCH_OVERHEAD_WATCHIMPL);
															#line 2401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes += watchBytes;
															#line 4788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (latest < waitVersion)
															#line 4792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				watchFuture = watchFuture || data->version.whenAtLeast(waitVersion);
															#line 4796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (BUGGIFY)
															#line 4800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				watchFuture = watchFuture || delay(deterministicRandom()->random01());
															#line 4804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (metadata->debugID.present())
															#line 4808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent( "WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.WaitChange");
															#line 4812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 3;
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchWaitForValueChangeActor, 2, Void >*>(static_cast<WatchWaitForValueChangeActor*>(this)));
															#line 4823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(GetValueReply && reply,int loopDepth) 
	{
															#line 2352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		span = Span(spanLocation, parent);
															#line 2354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (reply.error.present())
															#line 4840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(reply.error.get().code() != error_code_future_version);
															#line 2356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(reply.error.get(), loopDepth);
															#line 4846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (BUGGIFY)
															#line 4850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(transaction_too_old(), loopDepth);
															#line 4854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		DEBUG_MUTATION("ShardWatchValue", latest, MutationRef(MutationRef::DebugKey, metadata->key, reply.value.present() ? StringRef(reply.value.get()) : "<null>"_sr), data->thisServerID);
															#line 2369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (metadata->debugID.present())
															#line 4860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent( "WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.AfterRead");
															#line 4864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		Version waitVersion = minVersion;
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (reply.value != metadata->value)
															#line 4870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (latest >= metadata->version)
															#line 4874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<WatchWaitForValueChangeActor*>(this)->SAV<Version>::futures) { (void)(latest); this->~WatchWaitForValueChangeActorState(); static_cast<WatchWaitForValueChangeActor*>(this)->destroy(); return 0; }
															#line 4878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<WatchWaitForValueChangeActor*>(this)->SAV< Version >::value()) Version(std::move(latest)); // state_var_RVO
				this->~WatchWaitForValueChangeActorState();
				static_cast<WatchWaitForValueChangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (metadata->version > originalMetadataVersion)
															#line 4888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					CODE_PROBE(true, "racing watches for same value at different versions", probe::decoration::rare);
															#line 2386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (metadata->version > waitVersion)
															#line 4894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					{
															#line 2387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						waitVersion = metadata->version;
															#line 4898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->watchBytes > SERVER_KNOBS->MAX_STORAGE_SERVER_WATCH_BYTES)
															#line 4905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "Too many watches, reverting to polling");
															#line 2394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(watch_cancelled(), loopDepth);
															#line 4911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		watchBytes = (metadata->key.expectedSize() + metadata->value.expectedSize() + key.expectedSize() + sizeof(Reference<ServerWatchMetadata>) + sizeof(ServerWatchMetadata) + WATCH_OVERHEAD_WATCHIMPL);
															#line 2401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes += watchBytes;
															#line 4917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (latest < waitVersion)
															#line 4921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				watchFuture = watchFuture || data->version.whenAtLeast(waitVersion);
															#line 4925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (BUGGIFY)
															#line 4929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				watchFuture = watchFuture || delay(deterministicRandom()->random01());
															#line 4933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (metadata->debugID.present())
															#line 4937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent( "WatchValueDebug", metadata->debugID.get().first(), "watchValueSendReply.WaitChange");
															#line 4941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 3;
															#line 2415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchWaitForValueChangeActor, 2, Void >*>(static_cast<WatchWaitForValueChangeActor*>(this)));
															#line 4952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetValueReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetValueReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state > 0) static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 0;
		static_cast<WatchWaitForValueChangeActor*>(this)->ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >::remove();

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >*,GetValueReply const& value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >*,GetValueReply && value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->watchBytes -= watchBytes;
															#line 2419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 5051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 2416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= watchBytes;
															#line 5065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 2416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= watchBytes;
															#line 5074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state > 0) static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 0;
		static_cast<WatchWaitForValueChangeActor*>(this)->ActorCallback< WatchWaitForValueChangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchWaitForValueChangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state > 0) static_cast<WatchWaitForValueChangeActor*>(this)->actor_wait_state = 0;
		static_cast<WatchWaitForValueChangeActor*>(this)->ActorCallback< WatchWaitForValueChangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchWaitForValueChangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchWaitForValueChangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	SpanContext parent;
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRef key;
															#line 2321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Location spanLocation;
															#line 2322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 2323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Reference<ServerWatchMetadata> metadata;
															#line 2329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version originalMetadataVersion;
															#line 2336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version minVersion;
															#line 2337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<Void> watchFuture;
															#line 2338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ReadOptions options;
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version latest;
															#line 2349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<Void> getValue;
															#line 2397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t watchBytes;
															#line 5293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchWaitForValueChange()
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WatchWaitForValueChangeActor final : public Actor<Version>, public ActorCallback< WatchWaitForValueChangeActor, 0, Void >, public ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >, public ActorCallback< WatchWaitForValueChangeActor, 2, Void >, public ActorCallback< WatchWaitForValueChangeActor, 3, Void >, public FastAllocated<WatchWaitForValueChangeActor>, public WatchWaitForValueChangeActorState<WatchWaitForValueChangeActor> {
															#line 5298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchWaitForValueChangeActor>::operator new;
	using FastAllocated<WatchWaitForValueChangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7165655810124371456UL, 8785336631487168256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchWaitForValueChangeActor, 0, Void >;
friend struct ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >;
friend struct ActorCallback< WatchWaitForValueChangeActor, 2, Void >;
friend struct ActorCallback< WatchWaitForValueChangeActor, 3, Void >;
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WatchWaitForValueChangeActor(StorageServer* const& data,SpanContext const& parent,KeyRef const& key) 
															#line 5318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WatchWaitForValueChangeActorState<WatchWaitForValueChangeActor>(data, parent, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(510625173218191360UL, 2956297564950870528UL);
		ActorExecutionContextHelper __helper(static_cast<WatchWaitForValueChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchWaitForValueChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchWaitForValueChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchWaitForValueChangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchWaitForValueChangeActor, 1, GetValueReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchWaitForValueChangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatchWaitForValueChangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Version> watchWaitForValueChange( StorageServer* const& data, SpanContext const& parent, KeyRef const& key ) {
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Version>(new WatchWaitForValueChangeActor(data, parent, key));
															#line 5354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

void checkCancelWatchImpl(StorageServer* data, WatchValueRequest req) {
	Reference<ServerWatchMetadata> metadata = data->getWatchMetadata(req.key.contents());
	if (metadata.isValid() && metadata->versionPromise.getFutureReferenceCount() == 1) {
		// last watch timed out so cancel watch_impl and delete key from the map
		data->deleteWatchMetadata(req.key.contents());
		metadata->watch_impl.cancel();
	}
}

															#line 5368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watchValueSendReply()
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class WatchValueSendReplyActor>
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WatchValueSendReplyActorState {
															#line 5375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WatchValueSendReplyActorState(StorageServer* const& data,WatchValueRequest const& req,Future<Version> const& resp,SpanContext const& spanContext) 
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req),
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   resp(resp),
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   spanContext(spanContext),
															#line 2448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   span("SS:watchValue"_loc, spanContext),
															#line 2449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   startTime(now())
															#line 5392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchValueSendReply", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueSendReplyActorState() 
	{
		fdb_probe_actor_destroy("watchValueSendReply", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.watchQueries;
															#line 2451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->numWatches;
															#line 2452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->watchBytes += WATCH_OVERHEAD_WATCHQ;
															#line 2454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 5413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueSendReplyActorState();
		static_cast<WatchValueSendReplyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		double timeoutDelay = -1;
															#line 2456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->noRecentUpdates.get())
															#line 5445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			timeoutDelay = std::max(CLIENT_KNOBS->FAST_WATCH_TIMEOUT - (now() - startTime), 0.0);
															#line 5449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!BUGGIFY)
															#line 5455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				timeoutDelay = std::max(CLIENT_KNOBS->WATCH_TIMEOUT - (now() - startTime), 0.0);
															#line 5459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
		try {
															#line 2464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Version> __when_expr_0 = resp;
															#line 2463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<WatchValueSendReplyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutDelay < 0 ? Never() : delay(timeoutDelay);
															#line 5471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 2480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = data->noRecentUpdates.onChange();
															#line 5475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<WatchValueSendReplyActor*>(this)->actor_wait_state = 1;
															#line 2464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueSendReplyActor, 0, Version >*>(static_cast<WatchValueSendReplyActor*>(this)));
															#line 2472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueSendReplyActor, 1, Void >*>(static_cast<WatchValueSendReplyActor*>(this)));
															#line 2480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchValueSendReplyActor, 2, Void >*>(static_cast<WatchValueSendReplyActor*>(this)));
															#line 5484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->watchBytes -= WATCH_OVERHEAD_WATCHQ;
															#line 2484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			checkCancelWatchImpl(data, req);
															#line 2485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			--data->numWatches;
															#line 2487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!canReplyWith(e))
															#line 5512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->sendErrorWithPenalty(req.reply, e, data->getPenalty());
															#line 2490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<WatchValueSendReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueSendReplyActorState(); static_cast<WatchValueSendReplyActor*>(this)->destroy(); return 0; }
															#line 5522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<WatchValueSendReplyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchValueSendReplyActorState();
			static_cast<WatchValueSendReplyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
															#line 2466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(WatchValueReply{ ver });
															#line 2467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkCancelWatchImpl(data, req);
															#line 2468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		--data->numWatches;
															#line 2469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= WATCH_OVERHEAD_WATCHQ;
															#line 2470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WatchValueSendReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueSendReplyActorState(); static_cast<WatchValueSendReplyActor*>(this)->destroy(); return 0; }
															#line 5554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueSendReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueSendReplyActorState();
		static_cast<WatchValueSendReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
															#line 2466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(WatchValueReply{ ver });
															#line 2467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkCancelWatchImpl(data, req);
															#line 2468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		--data->numWatches;
															#line 2469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= WATCH_OVERHEAD_WATCHQ;
															#line 2470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WatchValueSendReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueSendReplyActorState(); static_cast<WatchValueSendReplyActor*>(this)->destroy(); return 0; }
															#line 5574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueSendReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueSendReplyActorState();
		static_cast<WatchValueSendReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->sendErrorWithPenalty(req.reply, timed_out(), data->getPenalty());
															#line 2475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkCancelWatchImpl(data, req);
															#line 2476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		--data->numWatches;
															#line 2477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= WATCH_OVERHEAD_WATCHQ;
															#line 2478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WatchValueSendReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueSendReplyActorState(); static_cast<WatchValueSendReplyActor*>(this)->destroy(); return 0; }
															#line 5594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueSendReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueSendReplyActorState();
		static_cast<WatchValueSendReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->sendErrorWithPenalty(req.reply, timed_out(), data->getPenalty());
															#line 2475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkCancelWatchImpl(data, req);
															#line 2476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		--data->numWatches;
															#line 2477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->watchBytes -= WATCH_OVERHEAD_WATCHQ;
															#line 2478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<WatchValueSendReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueSendReplyActorState(); static_cast<WatchValueSendReplyActor*>(this)->destroy(); return 0; }
															#line 5614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueSendReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueSendReplyActorState();
		static_cast<WatchValueSendReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueSendReplyActor*>(this)->actor_wait_state > 0) static_cast<WatchValueSendReplyActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueSendReplyActor*>(this)->ActorCallback< WatchValueSendReplyActor, 0, Version >::remove();
		static_cast<WatchValueSendReplyActor*>(this)->ActorCallback< WatchValueSendReplyActor, 1, Void >::remove();
		static_cast<WatchValueSendReplyActor*>(this)->ActorCallback< WatchValueSendReplyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueSendReplyActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueSendReplyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchValueSendReplyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchValueSendReplyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WatchValueRequest req;
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<Version> resp;
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	SpanContext spanContext;
															#line 2448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 2449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double startTime;
															#line 5838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchValueSendReply()
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class WatchValueSendReplyActor final : public Actor<Void>, public ActorCallback< WatchValueSendReplyActor, 0, Version >, public ActorCallback< WatchValueSendReplyActor, 1, Void >, public ActorCallback< WatchValueSendReplyActor, 2, Void >, public FastAllocated<WatchValueSendReplyActor>, public WatchValueSendReplyActorState<WatchValueSendReplyActor> {
															#line 5843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchValueSendReplyActor>::operator new;
	using FastAllocated<WatchValueSendReplyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12047609005457897472UL, 16023314052037063936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueSendReplyActor, 0, Version >;
friend struct ActorCallback< WatchValueSendReplyActor, 1, Void >;
friend struct ActorCallback< WatchValueSendReplyActor, 2, Void >;
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	WatchValueSendReplyActor(StorageServer* const& data,WatchValueRequest const& req,Future<Version> const& resp,SpanContext const& spanContext) 
															#line 5862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WatchValueSendReplyActorState<WatchValueSendReplyActor>(data, req, resp, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValueSendReply", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3738460070669966080UL, 521894726446841856UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueSendReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValueSendReply");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValueSendReply", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueSendReplyActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> watchValueSendReply( StorageServer* const& data, WatchValueRequest const& req, Future<Version> const& resp, SpanContext const& spanContext ) {
															#line 2444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new WatchValueSendReplyActor(data, req, resp, spanContext));
															#line 5895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Finds a checkpoint.
															#line 5901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getCheckpointQ()
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class GetCheckpointQActor>
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetCheckpointQActorState {
															#line 5908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetCheckpointQActorState(StorageServer* const& self,GetCheckpointRequest const& req) 
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : self(self),
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 5917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	~GetCheckpointQActorState() 
	{
		fdb_probe_actor_destroy("getCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->durableVersion.whenAtLeast(req.version + 1);
															#line 2498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<GetCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCheckpointQActor*>(this)->actor_wait_state = 1;
															#line 2498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCheckpointQActor, 0, Void >*>(static_cast<GetCheckpointQActor*>(this)));
															#line 5939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCheckpointQActorState();
		static_cast<GetCheckpointQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevDebug, "ServeGetCheckpointVersionSatisfied", self->thisServerID) .detail("Version", req.version) .detail("Ranges", describe(req.ranges)) .detail("Format", static_cast<int>(req.format));
															#line 2504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(req.ranges.size() == 1);
															#line 2505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( const auto& range : req.ranges ) {
															#line 2506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!self->isReadable(range))
															#line 5968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(wrong_shard_server());
															#line 2508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<GetCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCheckpointQActorState(); static_cast<GetCheckpointQActor*>(this)->destroy(); return 0; }
															#line 5974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<GetCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetCheckpointQActorState();
				static_cast<GetCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		try {
															#line 2513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::unordered_map<UID, CheckpointMetaData>::iterator it = self->checkpoints.begin();
															#line 2514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(;it != self->checkpoints.end();++it) {
															#line 2515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				const CheckpointMetaData& md = it->second;
															#line 2516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (md.version == req.version && md.format == req.format && req.actionId == md.actionId && md.hasRanges(req.ranges) && md.getState() == CheckpointMetaData::Complete)
															#line 5990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.send(md);
															#line 2519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					TraceEvent(SevDebug, "ServeGetCheckpointEnd", self->thisServerID).detail("Checkpoint", md.toString());
															#line 5996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 2524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (it == self->checkpoints.end())
															#line 6002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(checkpoint_not_found());
															#line 6006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevDebug, "ServeGetCheckpointVersionSatisfied", self->thisServerID) .detail("Version", req.version) .detail("Ranges", describe(req.ranges)) .detail("Format", static_cast<int>(req.format));
															#line 2504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(req.ranges.size() == 1);
															#line 2505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( const auto& range : req.ranges ) {
															#line 2506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!self->isReadable(range))
															#line 6028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(wrong_shard_server());
															#line 2508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<GetCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCheckpointQActorState(); static_cast<GetCheckpointQActor*>(this)->destroy(); return 0; }
															#line 6034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<GetCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetCheckpointQActorState();
				static_cast<GetCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		try {
															#line 2513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::unordered_map<UID, CheckpointMetaData>::iterator it = self->checkpoints.begin();
															#line 2514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(;it != self->checkpoints.end();++it) {
															#line 2515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				const CheckpointMetaData& md = it->second;
															#line 2516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (md.version == req.version && md.format == req.format && req.actionId == md.actionId && md.hasRanges(req.ranges) && md.getState() == CheckpointMetaData::Complete)
															#line 6050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.send(md);
															#line 2519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					TraceEvent(SevDebug, "ServeGetCheckpointEnd", self->thisServerID).detail("Checkpoint", md.toString());
															#line 6056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 2524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (it == self->checkpoints.end())
															#line 6062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(checkpoint_not_found());
															#line 6066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<GetCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<GetCheckpointQActor*>(this)->ActorCallback< GetCheckpointQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCheckpointQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCheckpointQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCheckpointQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<GetCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCheckpointQActorState(); static_cast<GetCheckpointQActor*>(this)->destroy(); return 0; }
															#line 6157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<GetCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetCheckpointQActorState();
		static_cast<GetCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!canReplyWith(e))
															#line 6170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(e);
															#line 6178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* self;
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetCheckpointRequest req;
															#line 6206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCheckpointQ()
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetCheckpointQActor final : public Actor<Void>, public ActorCallback< GetCheckpointQActor, 0, Void >, public FastAllocated<GetCheckpointQActor>, public GetCheckpointQActorState<GetCheckpointQActor> {
															#line 6211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCheckpointQActor>::operator new;
	using FastAllocated<GetCheckpointQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17109195114682058240UL, 16401652279099380736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCheckpointQActor, 0, Void >;
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetCheckpointQActor(StorageServer* const& self,GetCheckpointRequest const& req) 
															#line 6228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetCheckpointQActorState<GetCheckpointQActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCheckpointQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7171777638048396032UL, 5824655659692947712UL);
		ActorExecutionContextHelper __helper(static_cast<GetCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCheckpointQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCheckpointQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCheckpointQActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> getCheckpointQ( StorageServer* const& self, GetCheckpointRequest const& req ) {
															#line 2496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new GetCheckpointQActor(self, req));
															#line 6261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Delete the checkpoint from disk, as well as all related persisted meta data.
															#line 6267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via deleteCheckpointQ()
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class DeleteCheckpointQActor>
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class DeleteCheckpointQActorState {
															#line 6274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	DeleteCheckpointQActorState(StorageServer* const& self,Version const& version,CheckpointMetaData const& checkpoint) 
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : self(self),
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   checkpoint(checkpoint)
															#line 6285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("deleteCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	~DeleteCheckpointQActorState() 
	{
		fdb_probe_actor_destroy("deleteCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::Low);
															#line 2538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 1;
															#line 2538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointQActor, 0, Void >*>(static_cast<DeleteCheckpointQActor*>(this)));
															#line 6307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteCheckpointQActorState();
		static_cast<DeleteCheckpointQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->durableVersion.whenAtLeast(version);
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 2;
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointQActor, 1, Void >*>(static_cast<DeleteCheckpointQActor*>(this)));
															#line 6337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->durableVersion.whenAtLeast(version);
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 2;
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointQActor, 1, Void >*>(static_cast<DeleteCheckpointQActor*>(this)));
															#line 6353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointQActor*>(this)->ActorCallback< DeleteCheckpointQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "DeleteCheckpointBegin", self->thisServerID).detail("Checkpoint", checkpoint.toString());
															#line 2544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->checkpoints.erase(checkpoint.checkpointID);
															#line 6439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = deleteCheckpoint(checkpoint);
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 3;
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointQActor, 2, Void >*>(static_cast<DeleteCheckpointQActor*>(this)));
															#line 6450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "DeleteCheckpointBegin", self->thisServerID).detail("Checkpoint", checkpoint.toString());
															#line 2544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->checkpoints.erase(checkpoint.checkpointID);
															#line 6467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = deleteCheckpoint(checkpoint);
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 3;
															#line 2547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointQActor, 2, Void >*>(static_cast<DeleteCheckpointQActor*>(this)));
															#line 6478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointQActor*>(this)->ActorCallback< DeleteCheckpointQActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointQActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		persistCheckpointKey = Key(persistCheckpointKeys.begin.toString() + checkpoint.checkpointID.toString());
															#line 2554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		pendingCheckpointKey = Key(persistPendingCheckpointKeys.begin.toString() + checkpoint.checkpointID.toString());
															#line 2555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		auto& mLV = self->addVersionToMutationLog(self->data().getLatestVersion());
															#line 2556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->addMutationToMutationLog( mLV, MutationRef(MutationRef::ClearRange, pendingCheckpointKey, keyAfter(pendingCheckpointKey)));
															#line 2558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		self->addMutationToMutationLog( mLV, MutationRef(MutationRef::ClearRange, persistCheckpointKey, keyAfter(persistCheckpointKey)));
															#line 2560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "DeleteCheckpointEnd", self->thisServerID).detail("Checkpoint", checkpoint.toString());
															#line 2562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<DeleteCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointQActorState(); static_cast<DeleteCheckpointQActor*>(this)->destroy(); return 0; }
															#line 6580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<DeleteCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointQActorState();
		static_cast<DeleteCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointQActor*>(this)->ActorCallback< DeleteCheckpointQActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointQActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointQActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* self;
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	CheckpointMetaData checkpoint;
															#line 2553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key persistCheckpointKey;
															#line 2554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key pendingCheckpointKey;
															#line 6713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via deleteCheckpointQ()
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class DeleteCheckpointQActor final : public Actor<Void>, public ActorCallback< DeleteCheckpointQActor, 0, Void >, public ActorCallback< DeleteCheckpointQActor, 1, Void >, public ActorCallback< DeleteCheckpointQActor, 2, Void >, public FastAllocated<DeleteCheckpointQActor>, public DeleteCheckpointQActorState<DeleteCheckpointQActor> {
															#line 6718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<DeleteCheckpointQActor>::operator new;
	using FastAllocated<DeleteCheckpointQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15556838761289239040UL, 1496089786153912576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteCheckpointQActor, 0, Void >;
friend struct ActorCallback< DeleteCheckpointQActor, 1, Void >;
friend struct ActorCallback< DeleteCheckpointQActor, 2, Void >;
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	DeleteCheckpointQActor(StorageServer* const& self,Version const& version,CheckpointMetaData const& checkpoint) 
															#line 6737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DeleteCheckpointQActorState<DeleteCheckpointQActor>(self, version, checkpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7967604653483254528UL, 11896452891661470208UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteCheckpointQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteCheckpointQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteCheckpointQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteCheckpointQActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteCheckpointQActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> deleteCheckpointQ( StorageServer* const& self, Version const& version, CheckpointMetaData const& checkpoint ) {
															#line 2537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new DeleteCheckpointQActor(self, version, checkpoint));
															#line 6772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Serves FetchCheckpointRequests.
															#line 6778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchCheckpointQ()
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class FetchCheckpointQActor>
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchCheckpointQActorState {
															#line 6785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointQActorState(StorageServer* const& self,FetchCheckpointRequest const& req) 
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : self(self),
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 6794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointQActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent("ServeFetchCheckpointBegin", self->thisServerID) .detail("CheckpointID", req.checkpointID) .detail("Token", req.token);
															#line 2571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reader = nullptr;
															#line 2572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			totalSize = 0;
															#line 2574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.setByteLimit(SERVER_KNOBS->CHECKPOINT_TRANSFER_BLOCK_BYTES);
															#line 2577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const auto it = self->checkpoints.find(req.checkpointID);
															#line 2578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (it == self->checkpoints.end())
															#line 6819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(checkpoint_not_found());
															#line 2580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent("ServeFetchCheckpointNotFound", self->thisServerID).detail("CheckpointID", req.checkpointID);
															#line 2581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<FetchCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointQActorState(); static_cast<FetchCheckpointQActor*>(this)->destroy(); return 0; }
															#line 6827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<FetchCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FetchCheckpointQActorState();
				static_cast<FetchCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 2585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				reader = newCheckpointReader(it->second, CheckpointAsKeyValues::False, deterministicRandom()->randomUniqueID());
															#line 2586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = reader->init(req.token);
															#line 2586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 1;
															#line 2586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointQActor, 0, Void >*>(static_cast<FetchCheckpointQActor*>(this)));
															#line 6845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointQActorState();
		static_cast<FetchCheckpointQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reader->close();
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 5;
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointQActor, 4, Void >*>(static_cast<FetchCheckpointQActor*>(this)));
															#line 6881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_end_of_stream || e.code() == error_code_checkpoint_not_found)
															#line 6891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(e);
															#line 2599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent("ServeFetchCheckpointEnd", self->thisServerID) .error(e) .detail("CheckpointID", req.checkpointID) .detail("TotalSize", totalSize) .detail("Token", req.token);
															#line 6897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
			else
			{
															#line 2604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (e.code() != error_code_operation_obsolete)
															#line 6904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					TraceEvent(SevWarnAlways, "ServerFetchCheckpointFailure") .errorUnsuppressed(e) .detail("CheckpointID", req.checkpointID) .detail("Token", req.token);
															#line 2609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (canReplyWith(e))
															#line 6910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					{
															#line 2610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						req.reply.sendError(e);
															#line 6914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					}
															#line 2612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					err = e;
															#line 2613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (reader != nullptr)
															#line 6920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					{
															#line 2614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						StrictFuture<Void> __when_expr_3 = reader->close();
															#line 2614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_3.get(), loopDepth); };
						static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 4;
															#line 2614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointQActor, 3, Void >*>(static_cast<FetchCheckpointQActor*>(this)));
															#line 6931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1Catch2cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1Catch2cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 6957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 6966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointQActor*>(this)->ActorCallback< FetchCheckpointQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = reader->nextChunk(CLIENT_KNOBS->REPLY_BYTE_LIMIT);
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 2;
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >*>(static_cast<FetchCheckpointQActor*>(this)));
															#line 7064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 2590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = req.reply.onReady();
															#line 2590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 3;
															#line 2590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointQActor, 2, Void >*>(static_cast<FetchCheckpointQActor*>(this)));
															#line 7080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Standalone<StringRef> const& __data,int loopDepth) 
	{
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data = __data;
															#line 7089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Standalone<StringRef> && __data,int loopDepth) 
	{
		data = std::move(__data);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointQActor*>(this)->ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2591 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		FetchCheckpointReply reply(req.token);
															#line 2592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reply.data = data;
															#line 2593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(reply);
															#line 2594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		totalSize += data.size();
															#line 7174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2591 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		FetchCheckpointReply reply(req.token);
															#line 2592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reply.data = data;
															#line 2593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(reply);
															#line 2594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		totalSize += data.size();
															#line 7189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointQActor*>(this)->ActorCallback< FetchCheckpointQActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchCheckpointQActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1Catch2cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont4(int loopDepth) 
	{
															#line 2616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 7285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1Catch2cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointQActor*>(this)->ActorCallback< FetchCheckpointQActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchCheckpointQActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<FetchCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointQActorState(); static_cast<FetchCheckpointQActor*>(this)->destroy(); return 0; }
															#line 7380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<FetchCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointQActorState();
		static_cast<FetchCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<FetchCheckpointQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointQActorState(); static_cast<FetchCheckpointQActor*>(this)->destroy(); return 0; }
															#line 7392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<FetchCheckpointQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointQActorState();
		static_cast<FetchCheckpointQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FetchCheckpointQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointQActor*>(this)->ActorCallback< FetchCheckpointQActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointQActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FetchCheckpointQActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* self;
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointRequest req;
															#line 2571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ICheckpointReader* reader;
															#line 2572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t totalSize;
															#line 2589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Standalone<StringRef> data;
															#line 2612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Error err;
															#line 7487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchCheckpointQ()
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchCheckpointQActor final : public Actor<Void>, public ActorCallback< FetchCheckpointQActor, 0, Void >, public ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >, public ActorCallback< FetchCheckpointQActor, 2, Void >, public ActorCallback< FetchCheckpointQActor, 3, Void >, public ActorCallback< FetchCheckpointQActor, 4, Void >, public FastAllocated<FetchCheckpointQActor>, public FetchCheckpointQActorState<FetchCheckpointQActor> {
															#line 7492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchCheckpointQActor>::operator new;
	using FastAllocated<FetchCheckpointQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18158568694919305984UL, 13660916156953462272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointQActor, 0, Void >;
friend struct ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >;
friend struct ActorCallback< FetchCheckpointQActor, 2, Void >;
friend struct ActorCallback< FetchCheckpointQActor, 3, Void >;
friend struct ActorCallback< FetchCheckpointQActor, 4, Void >;
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointQActor(StorageServer* const& self,FetchCheckpointRequest const& req) 
															#line 7513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchCheckpointQActorState<FetchCheckpointQActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13937557724080409344UL, 5112112820403248640UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointQActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchCheckpointQActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchCheckpointQActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FetchCheckpointQActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointQ( StorageServer* const& self, FetchCheckpointRequest const& req ) {
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new FetchCheckpointQActor(self, req));
															#line 7550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Serves FetchCheckpointKeyValuesRequest, reads local checkpoint and sends it to the client over wire.
															#line 7556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchCheckpointKeyValuesQ()
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class FetchCheckpointKeyValuesQActor>
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchCheckpointKeyValuesQActorState {
															#line 7563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointKeyValuesQActorState(StorageServer* const& self,FetchCheckpointKeyValuesRequest const& req) 
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : self(self),
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 7572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointKeyValuesQActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->serveFetchCheckpointParallelismLock.take(TaskPriority::DefaultYield);
															#line 2626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 1;
															#line 2626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 7594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointKeyValuesQActorState();
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(self->serveFetchCheckpointParallelismLock);
															#line 2629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent("ServeFetchCheckpointKeyValuesBegin", self->thisServerID) .detail("CheckpointID", req.checkpointID) .detail("Range", req.range);
															#line 2633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.setByteLimit(SERVER_KNOBS->CHECKPOINT_TRANSFER_BLOCK_BYTES);
															#line 2636 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const auto it = self->checkpoints.find(req.checkpointID);
															#line 2637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (it == self->checkpoints.end())
															#line 7625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(checkpoint_not_found());
															#line 2639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent("ServeFetchCheckpointNotFound", self->thisServerID).detail("CheckpointID", req.checkpointID);
															#line 2640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointKeyValuesQActorState(); static_cast<FetchCheckpointKeyValuesQActor*>(this)->destroy(); return 0; }
															#line 7633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchCheckpointKeyValuesQActorState();
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reader = nullptr;
															#line 2644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		auto crIt = self->liveCheckpointReaders.find(req.checkpointID);
															#line 2645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (crIt != self->liveCheckpointReaders.end())
															#line 7645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reader = crIt->second;
															#line 7649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reader = newCheckpointReader(it->second, CheckpointAsKeyValues::True, deterministicRandom()->randomUniqueID());
															#line 2649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			self->liveCheckpointReaders[req.checkpointID] = reader;
															#line 7657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		iter = std::unique_ptr<ICheckpointIterator>();
															#line 7661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = reader->init(BinaryWriter::toValue(req.range, IncludeVersion()));
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 2;
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 7672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(self->serveFetchCheckpointParallelismLock);
															#line 2629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent("ServeFetchCheckpointKeyValuesBegin", self->thisServerID) .detail("CheckpointID", req.checkpointID) .detail("Range", req.range);
															#line 2633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.setByteLimit(SERVER_KNOBS->CHECKPOINT_TRANSFER_BLOCK_BYTES);
															#line 2636 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const auto it = self->checkpoints.find(req.checkpointID);
															#line 2637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (it == self->checkpoints.end())
															#line 7695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(checkpoint_not_found());
															#line 2639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent("ServeFetchCheckpointNotFound", self->thisServerID).detail("CheckpointID", req.checkpointID);
															#line 2640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointKeyValuesQActorState(); static_cast<FetchCheckpointKeyValuesQActor*>(this)->destroy(); return 0; }
															#line 7703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchCheckpointKeyValuesQActorState();
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reader = nullptr;
															#line 2644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		auto crIt = self->liveCheckpointReaders.find(req.checkpointID);
															#line 2645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (crIt != self->liveCheckpointReaders.end())
															#line 7715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reader = crIt->second;
															#line 7719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reader = newCheckpointReader(it->second, CheckpointAsKeyValues::True, deterministicRandom()->randomUniqueID());
															#line 2649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			self->liveCheckpointReaders[req.checkpointID] = reader;
															#line 7727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		iter = std::unique_ptr<ICheckpointIterator>();
															#line 7731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = reader->init(BinaryWriter::toValue(req.range, IncludeVersion()));
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 2;
															#line 2654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 7742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		iter.reset();
															#line 2699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!reader->inUse())
															#line 7834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			self->liveCheckpointReaders.erase(req.checkpointID);
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_4 = reader->close();
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 5;
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 7847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_end_of_stream || e.code() == error_code_checkpoint_not_found)
															#line 7862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(e);
															#line 2683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevInfo, "ServeFetchCheckpointKeyValuesEnd", self->thisServerID) .error(e) .detail("CheckpointID", req.checkpointID) .detail("Range", req.range);
															#line 7868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevWarnAlways, "ServerFetchCheckpointKeyValuesFailure") .errorUnsuppressed(e) .detail("CheckpointID", req.checkpointID) .detail("Range", req.range);
															#line 2692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (canReplyWith(e))
															#line 7876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.sendError(e);
															#line 7880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		iter = reader->getIterator(req.range);
															#line 2657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 7899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		iter = reader->getIterator(req.range);
															#line 2657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 7910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = iter->nextBatch(CLIENT_KNOBS->REPLY_BYTE_LIMIT, CLIENT_KNOBS->REPLY_BYTE_LIMIT);
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 3;
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 8008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 2660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!res.empty())
															#line 8017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevDebug, "FetchCheckpontKeyValuesReadRange", self->thisServerID) .detail("CheckpointID", req.checkpointID) .detail("FirstReturnedKey", res.front().key) .detail("LastReturnedKey", res.back().key) .detail("Size", res.size());
															#line 8021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "FetchCheckpontKeyValuesEmptyRange", self->thisServerID) .detail("CheckpointID", req.checkpointID);
															#line 8027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = req.reply.onReady();
															#line 2671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 4;
															#line 2671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >*>(static_cast<FetchCheckpointKeyValuesQActor*>(this)));
															#line 8038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResult const& __res,int loopDepth) 
	{
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = __res;
															#line 8047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		FetchCheckpointKeyValuesStreamReply reply;
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reply.arena.dependsOn(res.arena());
															#line 2674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 2675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reply.data.push_back(reply.arena, res[i]);
															#line 8132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(reply);
															#line 8136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		FetchCheckpointKeyValuesStreamReply reply;
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		reply.arena.dependsOn(res.arena());
															#line 2674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 2675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			reply.data.push_back(reply.arena, res[i]);
															#line 8151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 2678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(reply);
															#line 8155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchCheckpointKeyValuesQActorState(); static_cast<FetchCheckpointKeyValuesQActor*>(this)->destroy(); return 0; }
															#line 8239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<FetchCheckpointKeyValuesQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchCheckpointKeyValuesQActorState();
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointKeyValuesQActor*>(this)->ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* self;
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointKeyValuesRequest req;
															#line 2627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FlowLock::Releaser holder;
															#line 2643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ICheckpointReader* reader;
															#line 2652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::unique_ptr<ICheckpointIterator> iter;
															#line 2658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	RangeResult res;
															#line 8346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchCheckpointKeyValuesQ()
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchCheckpointKeyValuesQActor final : public Actor<Void>, public ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >, public ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >, public ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >, public ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >, public ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >, public FastAllocated<FetchCheckpointKeyValuesQActor>, public FetchCheckpointKeyValuesQActorState<FetchCheckpointKeyValuesQActor> {
															#line 8351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchCheckpointKeyValuesQActor>::operator new;
	using FastAllocated<FetchCheckpointKeyValuesQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12553174564711900416UL, 15875175028591524864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >;
friend struct ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >;
friend struct ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >;
friend struct ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >;
friend struct ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >;
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchCheckpointKeyValuesQActor(StorageServer* const& self,FetchCheckpointKeyValuesRequest const& req) 
															#line 8372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetchCheckpointKeyValuesQActorState<FetchCheckpointKeyValuesQActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12412750992388461056UL, 6903825642391152640UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointKeyValuesQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointKeyValuesQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointKeyValuesQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchCheckpointKeyValuesQActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchCheckpointKeyValuesQActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchCheckpointKeyValuesQActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FetchCheckpointKeyValuesQActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> fetchCheckpointKeyValuesQ( StorageServer* const& self, FetchCheckpointKeyValuesRequest const& req ) {
															#line 2625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new FetchCheckpointKeyValuesQActor(self, req));
															#line 8409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

#ifdef NO_INTELLISENSE
size_t WATCH_OVERHEAD_WATCHQ =
    sizeof(WatchValueSendReplyActorState<WatchValueSendReplyActor>) + sizeof(WatchValueSendReplyActor);
size_t WATCH_OVERHEAD_WATCHIMPL =
    sizeof(WatchWaitForValueChangeActorState<WatchWaitForValueChangeActor>) + sizeof(WatchWaitForValueChangeActor);
#else
size_t WATCH_OVERHEAD_WATCHQ = 0; // only used in IDE so value is irrelevant
size_t WATCH_OVERHEAD_WATCHIMPL = 0;
#endif

															#line 8424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getShardState_impl()
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class GetShardState_implActor>
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetShardState_implActorState {
															#line 8431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardState_implActorState(StorageServer* const& data,GetShardStateRequest const& req) 
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 8440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getShardState_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetShardState_implActorState() 
	{
		fdb_probe_actor_destroy("getShardState_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(req.mode != GetShardStateRequest::NO_WAIT);
															#line 2719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 8457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetShardState_implActorState();
		static_cast<GetShardState_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		std::vector<Future<Void>> onChange;
															#line 2722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( auto t : data->shards.intersectingRanges(req.keys) ) {
															#line 2723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!t.value()->assigned())
															#line 8491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				onChange.push_back(delay(SERVER_KNOBS->SHARD_READY_DELAY));
															#line 8495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				break;
			}
															#line 2728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.mode == GetShardStateRequest::READABLE && !t.value()->isReadable())
															#line 8500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (t.value()->getAddingShard())
															#line 8504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					onChange.push_back(t.value()->getAddingShard()->readWrite.getFuture());
															#line 8508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					ASSERT(t.value()->getMoveInShard());
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					onChange.push_back(t.value()->getMoveInShard()->readWrite.getFuture());
															#line 8516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
															#line 2737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.mode == GetShardStateRequest::FETCHING && !t.value()->isFetched())
															#line 8521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (t.value()->getAddingShard())
															#line 8525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					onChange.push_back(t.value()->getAddingShard()->fetchComplete.getFuture());
															#line 8529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					ASSERT(t.value()->getMoveInShard());
															#line 2742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					onChange.push_back(t.value()->getMoveInShard()->fetchComplete.getFuture());
															#line 8537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!onChange.size())
															#line 8543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			GetShardStateReply rep(data->version.get(), data->durableVersion.get());
															#line 2749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.includePhysicalShard)
															#line 8549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				rep.shards = data->getStorageServerShards(req.keys);
															#line 8553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.send(rep);
															#line 2753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<GetShardState_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetShardState_implActorState(); static_cast<GetShardState_implActor*>(this)->destroy(); return 0; }
															#line 8559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<GetShardState_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetShardState_implActorState();
			static_cast<GetShardState_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(onChange);
															#line 2756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetShardState_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetShardState_implActor*>(this)->actor_wait_state = 1;
															#line 2756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetShardState_implActor, 0, Void >*>(static_cast<GetShardState_implActor*>(this)));
															#line 8574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0);
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetShardState_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetShardState_implActor*>(this)->actor_wait_state = 2;
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetShardState_implActor, 1, Void >*>(static_cast<GetShardState_implActor*>(this)));
															#line 8590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0);
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetShardState_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetShardState_implActor*>(this)->actor_wait_state = 2;
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetShardState_implActor, 1, Void >*>(static_cast<GetShardState_implActor*>(this)));
															#line 8606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetShardState_implActor*>(this)->actor_wait_state > 0) static_cast<GetShardState_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetShardState_implActor*>(this)->ActorCallback< GetShardState_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetShardState_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetShardState_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetShardState_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetShardState_implActor*>(this)->actor_wait_state > 0) static_cast<GetShardState_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetShardState_implActor*>(this)->ActorCallback< GetShardState_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetShardState_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetShardState_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetShardState_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardStateRequest req;
															#line 8777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getShardState_impl()
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetShardState_implActor final : public Actor<Void>, public ActorCallback< GetShardState_implActor, 0, Void >, public ActorCallback< GetShardState_implActor, 1, Void >, public FastAllocated<GetShardState_implActor>, public GetShardState_implActorState<GetShardState_implActor> {
															#line 8782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetShardState_implActor>::operator new;
	using FastAllocated<GetShardState_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4109733403763887360UL, 2781198442029849344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetShardState_implActor, 0, Void >;
friend struct ActorCallback< GetShardState_implActor, 1, Void >;
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardState_implActor(StorageServer* const& data,GetShardStateRequest const& req) 
															#line 8800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetShardState_implActorState<GetShardState_implActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getShardState_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3570919601400010496UL, 14753609829273848064UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardState_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getShardState_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getShardState_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetShardState_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetShardState_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> getShardState_impl( StorageServer* const& data, GetShardStateRequest const& req ) {
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new GetShardState_implActor(data, req));
															#line 8834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

															#line 8839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getShardStateQ()
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class GetShardStateQActor>
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetShardStateQActorState {
															#line 8846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardStateQActorState(StorageServer* const& data,GetShardStateRequest const& req) 
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 8855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getShardStateQ", reinterpret_cast<unsigned long>(this));

	}
	~GetShardStateQActorState() 
	{
		fdb_probe_actor_destroy("getShardStateQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getShardState_impl(data, req);
															#line 2762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<GetShardStateQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 2764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(g_network->isSimulated() ? 10 : 60);
															#line 8876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<GetShardStateQActor*>(this)->actor_wait_state = 1;
															#line 2763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetShardStateQActor, 0, Void >*>(static_cast<GetShardStateQActor*>(this)));
															#line 2764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetShardStateQActor, 1, Void >*>(static_cast<GetShardStateQActor*>(this)));
															#line 8883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetShardStateQActorState();
		static_cast<GetShardStateQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<GetShardStateQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetShardStateQActorState(); static_cast<GetShardStateQActor*>(this)->destroy(); return 0; }
															#line 8906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<GetShardStateQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetShardStateQActorState();
		static_cast<GetShardStateQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 2765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->sendErrorWithPenalty(req.reply, timed_out(), data->getPenalty());
															#line 8930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 2765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->sendErrorWithPenalty(req.reply, timed_out(), data->getPenalty());
															#line 8939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetShardStateQActor*>(this)->actor_wait_state > 0) static_cast<GetShardStateQActor*>(this)->actor_wait_state = 0;
		static_cast<GetShardStateQActor*>(this)->ActorCallback< GetShardStateQActor, 0, Void >::remove();
		static_cast<GetShardStateQActor*>(this)->ActorCallback< GetShardStateQActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetShardStateQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetShardStateQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetShardStateQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetShardStateQActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetShardStateQActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetShardStateQActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardStateRequest req;
															#line 9069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getShardStateQ()
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetShardStateQActor final : public Actor<Void>, public ActorCallback< GetShardStateQActor, 0, Void >, public ActorCallback< GetShardStateQActor, 1, Void >, public FastAllocated<GetShardStateQActor>, public GetShardStateQActorState<GetShardStateQActor> {
															#line 9074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetShardStateQActor>::operator new;
	using FastAllocated<GetShardStateQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13695263971205446144UL, 294871629902717696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetShardStateQActor, 0, Void >;
friend struct ActorCallback< GetShardStateQActor, 1, Void >;
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetShardStateQActor(StorageServer* const& data,GetShardStateRequest const& req) 
															#line 9092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetShardStateQActorState<GetShardStateQActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getShardStateQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8443565892279057664UL, 11087380315085298688UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardStateQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getShardStateQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getShardStateQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetShardStateQActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> getShardStateQ( StorageServer* const& data, GetShardStateRequest const& req ) {
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new GetShardStateQActor(data, req));
															#line 9125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

KeyRef addPrefix(KeyRef const& key, Optional<KeyRef> prefix, Arena& arena) {
	if (prefix.present()) {
		return key.withPrefix(prefix.get(), arena);
	} else {
		return key;
	}
}

KeyValueRef removePrefix(KeyValueRef const& src, Optional<KeyRef> prefix) {
	if (prefix.present()) {
		return KeyValueRef(src.key.removePrefix(prefix.get()), src.value);
	} else {
		return src;
	}
}

// Combines data from base (at an older version) with sets from newer versions in [start, end) and appends the first (up
// to) |limit| rows to output If limit<0, base and output are in descending order, and start->key()>end->key(), but
// start is still inclusive and end is exclusive
void merge(Arena& arena,
           VectorRef<KeyValueRef, VecSerStrategy::String>& output,
           VectorRef<KeyValueRef> const& vm_output,
           RangeResult const& base,
           int& vCount,
           int limit,
           bool stopAtEndOfBase,
           int& pos,
           int limitBytes) {
	ASSERT(limit != 0);
	// Add a dependency of the new arena on the result from the KVS so that we don't have to copy any of the KVS
	// results.
	arena.dependsOn(base.arena());

	bool forward = limit > 0;
	if (!forward)
		limit = -limit;
	int adjustedLimit = limit + output.size();
	int accumulatedBytes = 0;
	KeyValueRef const* baseStart = base.begin();
	KeyValueRef const* baseEnd = base.end();
	while (baseStart != baseEnd && vCount > 0 && output.size() < adjustedLimit && accumulatedBytes < limitBytes) {
		if (forward ? baseStart->key < vm_output[pos].key : baseStart->key > vm_output[pos].key) {
			output.push_back(arena, *baseStart++);
		} else {
			output.push_back_deep(arena, vm_output[pos]);
			if (baseStart->key == vm_output[pos].key)
				++baseStart;
			++pos;
			vCount--;
		}
		accumulatedBytes += sizeof(KeyValueRef) + output.end()[-1].expectedSize();
	}
	while (baseStart != baseEnd && output.size() < adjustedLimit && accumulatedBytes < limitBytes) {
		output.push_back(arena, *baseStart++);
		accumulatedBytes += sizeof(KeyValueRef) + output.end()[-1].expectedSize();
	}
	if (!stopAtEndOfBase) {
		while (vCount > 0 && output.size() < adjustedLimit && accumulatedBytes < limitBytes) {
			output.push_back_deep(arena, vm_output[pos]);
			accumulatedBytes += sizeof(KeyValueRef) + output.end()[-1].expectedSize();
			++pos;
			vCount--;
		}
	}
}

static inline void copyOptionalValue(Arena* a,
                                     GetValueReqAndResultRef& getValue,
                                     const Optional<Value>& optionalValue) {
	getValue.result = optionalValue.castTo<ValueRef>();
	if (optionalValue.present()) {
		a->dependsOn(optionalValue.get().arena());
	}
}
															#line 9204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via quickGetValue()
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class QuickGetValueActor>
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class QuickGetValueActorState {
															#line 9211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	QuickGetValueActorState(StorageServer* const& data,StringRef const& key,Version const& version,Arena* const& a,GetMappedKeyValuesRequest* const& pOriginalReq) 
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   key(key),
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   a(a),
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   pOriginalReq(pOriginalReq),
															#line 2851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   getValue(),
															#line 2852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   getValueStart(g_network->timer())
															#line 9230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("quickGetValue", reinterpret_cast<unsigned long>(this));

	}
	~QuickGetValueActorState() 
	{
		fdb_probe_actor_destroy("quickGetValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getValue.key = key;
															#line 2855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (data->shards[key]->isReadable())
															#line 9247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
				try {
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					GetValueRequest req( pOriginalReq->spanContext, key, version, pOriginalReq->tags, pOriginalReq->options, VersionVector());
															#line 2863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					data->actors.add(getValueQ(data, req));
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					StrictFuture<GetValueReply> __when_expr_0 = req.reply.getFuture();
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (static_cast<QuickGetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<QuickGetValueActor*>(this)->actor_wait_state = 1;
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< QuickGetValueActor, 0, GetValueReply >*>(static_cast<QuickGetValueActor*>(this)));
															#line 9263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QuickGetValueActorState();
		static_cast<QuickGetValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		++data->counters.quickGetValueMiss;
															#line 2881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (SERVER_KNOBS->QUICK_GET_VALUE_FALLBACK)
															#line 9299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr = Transaction(data->cx);
															#line 2883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setVersion(version);
															#line 2885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.trState->taskID = TaskPriority::DefaultPromiseEndpoint;
															#line 2886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Future<Optional<Value>> valueFuture = tr.get(key, Snapshot::True);
															#line 2888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = valueFuture;
															#line 2888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<QuickGetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<QuickGetValueActor*>(this)->actor_wait_state = 2;
															#line 2888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< QuickGetValueActor, 1, Optional<Value> >*>(static_cast<QuickGetValueActor*>(this)));
															#line 9318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(quick_get_value_miss(), loopDepth);
															#line 9325 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(GetValueReply const& reply,int loopDepth) 
	{
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!reply.error.present())
															#line 9353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.quickGetValueHit;
															#line 2867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			copyOptionalValue(a, getValue, reply.value);
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const double duration = g_network->timer() - getValueStart;
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_LOCAL, trackedReadType(*pOriginalReq));
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<QuickGetValueActor*>(this)->SAV<GetValueReqAndResultRef>::futures) { (void)(getValue); this->~QuickGetValueActorState(); static_cast<QuickGetValueActor*>(this)->destroy(); return 0; }
															#line 9365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<QuickGetValueActor*>(this)->SAV< GetValueReqAndResultRef >::value()) GetValueReqAndResultRef(std::move(getValue)); // state_var_RVO
			this->~QuickGetValueActorState();
			static_cast<QuickGetValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(GetValueReply && reply,int loopDepth) 
	{
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!reply.error.present())
															#line 9379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.quickGetValueHit;
															#line 2867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			copyOptionalValue(a, getValue, reply.value);
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const double duration = g_network->timer() - getValueStart;
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_LOCAL, trackedReadType(*pOriginalReq));
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<QuickGetValueActor*>(this)->SAV<GetValueReqAndResultRef>::futures) { (void)(getValue); this->~QuickGetValueActorState(); static_cast<QuickGetValueActor*>(this)->destroy(); return 0; }
															#line 9391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<QuickGetValueActor*>(this)->SAV< GetValueReqAndResultRef >::value()) GetValueReqAndResultRef(std::move(getValue)); // state_var_RVO
			this->~QuickGetValueActorState();
			static_cast<QuickGetValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetValueReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetValueReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QuickGetValueActor*>(this)->actor_wait_state > 0) static_cast<QuickGetValueActor*>(this)->actor_wait_state = 0;
		static_cast<QuickGetValueActor*>(this)->ActorCallback< QuickGetValueActor, 0, GetValueReply >::remove();

	}
	void a_callback_fire(ActorCallback< QuickGetValueActor, 0, GetValueReply >*,GetValueReply const& value) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QuickGetValueActor, 0, GetValueReply >*,GetValueReply && value) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< QuickGetValueActor, 0, GetValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> const& valueOption,int loopDepth) 
	{
															#line 2889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		copyOptionalValue(a, getValue, valueOption);
															#line 2890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		double duration = g_network->timer() - getValueStart;
															#line 2891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_REMOTE, trackedReadType(*pOriginalReq));
															#line 2893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<QuickGetValueActor*>(this)->SAV<GetValueReqAndResultRef>::futures) { (void)(getValue); this->~QuickGetValueActorState(); static_cast<QuickGetValueActor*>(this)->destroy(); return 0; }
															#line 9499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<QuickGetValueActor*>(this)->SAV< GetValueReqAndResultRef >::value()) GetValueReqAndResultRef(std::move(getValue)); // state_var_RVO
		this->~QuickGetValueActorState();
		static_cast<QuickGetValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && valueOption,int loopDepth) 
	{
															#line 2889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		copyOptionalValue(a, getValue, valueOption);
															#line 2890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		double duration = g_network->timer() - getValueStart;
															#line 2891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_REMOTE, trackedReadType(*pOriginalReq));
															#line 2893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<QuickGetValueActor*>(this)->SAV<GetValueReqAndResultRef>::futures) { (void)(getValue); this->~QuickGetValueActorState(); static_cast<QuickGetValueActor*>(this)->destroy(); return 0; }
															#line 9517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<QuickGetValueActor*>(this)->SAV< GetValueReqAndResultRef >::value()) GetValueReqAndResultRef(std::move(getValue)); // state_var_RVO
		this->~QuickGetValueActorState();
		static_cast<QuickGetValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& valueOption,int loopDepth) 
	{
		loopDepth = a_body1cont8(valueOption, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && valueOption,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(valueOption), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<QuickGetValueActor*>(this)->actor_wait_state > 0) static_cast<QuickGetValueActor*>(this)->actor_wait_state = 0;
		static_cast<QuickGetValueActor*>(this)->ActorCallback< QuickGetValueActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< QuickGetValueActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< QuickGetValueActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< QuickGetValueActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StringRef key;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Arena* a;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetMappedKeyValuesRequest* pOriginalReq;
															#line 2851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetValueReqAndResultRef getValue;
															#line 2852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double getValueStart;
															#line 2882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Transaction tr;
															#line 9616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via quickGetValue()
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class QuickGetValueActor final : public Actor<GetValueReqAndResultRef>, public ActorCallback< QuickGetValueActor, 0, GetValueReply >, public ActorCallback< QuickGetValueActor, 1, Optional<Value> >, public FastAllocated<QuickGetValueActor>, public QuickGetValueActorState<QuickGetValueActor> {
															#line 9621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<QuickGetValueActor>::operator new;
	using FastAllocated<QuickGetValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12859730916528328960UL, 10922062941545866752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetValueReqAndResultRef>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< QuickGetValueActor, 0, GetValueReply >;
friend struct ActorCallback< QuickGetValueActor, 1, Optional<Value> >;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	QuickGetValueActor(StorageServer* const& data,StringRef const& key,Version const& version,Arena* const& a,GetMappedKeyValuesRequest* const& pOriginalReq) 
															#line 9639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<GetValueReqAndResultRef>(),
		   QuickGetValueActorState<QuickGetValueActor>(data, key, version, a, pOriginalReq),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("quickGetValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13229342185383356416UL, 6029856400378886912UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("quickGetValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("quickGetValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< QuickGetValueActor, 0, GetValueReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< QuickGetValueActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<GetValueReqAndResultRef> quickGetValue( StorageServer* const& data, StringRef const& key, Version const& version, Arena* const& a, GetMappedKeyValuesRequest* const& pOriginalReq ) {
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<GetValueReqAndResultRef>(new QuickGetValueActor(data, key, version, a, pOriginalReq));
															#line 9673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 2898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// If limit>=0, it returns the first rows in the range (sorted ascending), otherwise the last rows (sorted descending).
// readRange has O(|result|) + O(log |data|) cost
															#line 9680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readRange()
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class ReadRangeActor>
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class ReadRangeActorState {
															#line 9687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ReadRangeActorState(StorageServer* const& data,Version const& version,KeyRange const& range,int const& limit,int* const& pLimitBytes,SpanContext const& parentSpan,Optional<ReadOptions> const& options) 
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   range(range),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   limit(limit),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   pLimitBytes(pLimitBytes),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   parentSpan(parentSpan),
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   options(options),
															#line 2908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   result(),
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   view(data->data().at(version)),
															#line 2910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   vCurrent(view.end()),
															#line 2911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   readBegin(),
															#line 2912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   readEnd(),
															#line 2913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   readBeginTemp(),
															#line 2914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   vCount(0),
															#line 2915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   span("SS:readRange"_loc, parentSpan),
															#line 2916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   resultLogicalSize(0),
															#line 2917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   logicalSize(0),
															#line 2920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   resultCache(),
															#line 2923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   pos(0)
															#line 9730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readRange", reinterpret_cast<unsigned long>(this));

	}
	~ReadRangeActorState() 
	{
		fdb_probe_actor_destroy("readRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			auto containingRange = data->cachedRangeMap.rangeContaining(range.begin);
															#line 2927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (containingRange.value() && containingRange->range().end >= range.end)
															#line 9747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				result.cached = true;
															#line 9751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				result.cached = false;
															#line 9757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (limit >= 0)
															#line 9761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				vCurrent = view.lastLessOrEqual(range.begin);
															#line 2939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (vCurrent && vCurrent->isClearTo() && vCurrent->getEndKey() > range.begin)
															#line 9767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					readBegin = vCurrent->getEndKey();
															#line 9771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					readBegin = range.begin;
															#line 9777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
															#line 2945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (vCurrent)
															#line 9781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					if (vCurrent.key() != readBegin)
															#line 9785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					{
															#line 2947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
						++vCurrent;
															#line 9789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					vCurrent = view.begin();
															#line 9796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
															#line 2955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (EXPENSIVE_VALIDATION)
															#line 9800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 2956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					ASSERT(vCurrent == view.lower_bound(readBegin));
															#line 9804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
															#line 2959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				;
															#line 9808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 3047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				vCurrent = view.lastLess(range.end);
															#line 3050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (vCurrent && vCurrent->isClearTo() && vCurrent->getEndKey() >= range.end)
															#line 9817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 3051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					readEnd = vCurrent.key();
															#line 3052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					--vCurrent;
															#line 9823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 3054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					readEnd = range.end;
															#line 9829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
															#line 3057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				;
															#line 9833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRangeActorState();
		static_cast<ReadRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeBytesReturnedHistogram->sample(resultLogicalSize);
															#line 3136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeKVPairsReturnedHistogram->sample(result.data.size());
															#line 3139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(result.data.size() == 0 || *pLimitBytes + result.data.end()[-1].expectedSize() + sizeof(KeyValueRef) > 0);
															#line 3140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		result.more = limit == 0 || *pLimitBytes <= 0;
															#line 3141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		result.version = version;
															#line 3142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<ReadRangeActor*>(this)->SAV<GetKeyValuesReply>::futures) { (void)(result); this->~ReadRangeActorState(); static_cast<ReadRangeActor*>(this)->destroy(); return 0; }
															#line 9867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<ReadRangeActor*>(this)->SAV< GetKeyValuesReply >::value()) GetKeyValuesReply(std::move(result)); // state_var_RVO
		this->~ReadRangeActorState();
		static_cast<ReadRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!(limit > 0 && *pLimitBytes > 0 && readBegin < range.end))
															#line 9892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(!vCurrent || vCurrent.key() >= readBegin);
															#line 2961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(data->storageVersion() <= version);
															#line 2964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (pos == resultCache.size())
															#line 9902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent)
															#line 9906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 2966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				auto b = vCurrent;
															#line 2967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				--b;
															#line 2968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(!b || b.key() < readBegin);
															#line 9914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 2972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int vSize = 0;
															#line 2973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(;vCurrent && vCurrent.key() < range.end && !vCurrent->isClearTo() && vCount < limit && vSize < *pLimitBytes;) {
															#line 2976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				resultCache.emplace_back(result.arena, vCurrent.key(), vCurrent->getValue());
															#line 2977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				vSize += sizeof(KeyValueRef) + resultCache.cback().expectedSize();
															#line 2978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++vCount;
															#line 2979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++vCurrent;
															#line 9928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
															#line 2984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readEnd = vCurrent ? std::min(vCurrent.key(), range.end) : range.end;
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = data->storage.readRange(KeyRangeRef(readBegin, readEnd), limit, *pLimitBytes, options);
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<ReadRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ReadRangeActor*>(this)->actor_wait_state = 1;
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRangeActor, 0, RangeResult >*>(static_cast<ReadRangeActor*>(this)));
															#line 9942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& atStorageVersion,int loopDepth) 
	{
															#line 2987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		logicalSize = atStorageVersion.logicalSize();
															#line 2988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvScanBytes += logicalSize;
															#line 2989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultLogicalSize += logicalSize;
															#line 2990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeBytesLimitHistogram->sample(*pLimitBytes);
															#line 2992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(atStorageVersion.size() <= limit);
															#line 2993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->storageVersion() > version)
															#line 9974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			DisabledTraceEvent("SS_TTO", data->thisServerID) .detail("StorageVersion", data->storageVersion()) .detail("Oldest", data->oldestVersion.get()) .detail("Version", version) .detail("Range", range);
															#line 2999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), std::max(0, loopDepth - 1));
															#line 9980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int prevSize = result.data.size();
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		merge(result.arena, result.data, resultCache, atStorageVersion, vCount, limit, atStorageVersion.more, pos, *pLimitBytes);
															#line 3014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit -= result.data.size() - prevSize;
															#line 3016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(auto i = result.data.begin() + prevSize;i != result.data.end();i++) {
															#line 3017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pLimitBytes -= sizeof(KeyValueRef) + i->expectedSize();
															#line 9992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (limit <= 0 || *pLimitBytes <= 0)
															#line 9996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (atStorageVersion.more)
															#line 10002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(atStorageVersion.end()[-1].key.size() == result.data.end()[-1].key.size() && atStorageVersion.end()[-1].key.endsWith(result.data.end()[-1].key));
															#line 3032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readBegin = readBeginTemp = keyAfter(atStorageVersion.end()[-1].key);
															#line 10008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent && vCurrent->isClearTo())
															#line 10014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(vCurrent->getEndKey() > readBegin);
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				readBegin = vCurrent->getEndKey();
															#line 3040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++vCurrent;
															#line 10022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(readEnd == range.end);
															#line 10028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && atStorageVersion,int loopDepth) 
	{
															#line 2987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		logicalSize = atStorageVersion.logicalSize();
															#line 2988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvScanBytes += logicalSize;
															#line 2989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultLogicalSize += logicalSize;
															#line 2990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeBytesLimitHistogram->sample(*pLimitBytes);
															#line 2992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(atStorageVersion.size() <= limit);
															#line 2993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->storageVersion() > version)
															#line 10050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 2994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			DisabledTraceEvent("SS_TTO", data->thisServerID) .detail("StorageVersion", data->storageVersion()) .detail("Oldest", data->oldestVersion.get()) .detail("Version", version) .detail("Range", range);
															#line 2999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), std::max(0, loopDepth - 1));
															#line 10056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int prevSize = result.data.size();
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		merge(result.arena, result.data, resultCache, atStorageVersion, vCount, limit, atStorageVersion.more, pos, *pLimitBytes);
															#line 3014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit -= result.data.size() - prevSize;
															#line 3016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(auto i = result.data.begin() + prevSize;i != result.data.end();i++) {
															#line 3017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pLimitBytes -= sizeof(KeyValueRef) + i->expectedSize();
															#line 10068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (limit <= 0 || *pLimitBytes <= 0)
															#line 10072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (atStorageVersion.more)
															#line 10078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(atStorageVersion.end()[-1].key.size() == result.data.end()[-1].key.size() && atStorageVersion.end()[-1].key.endsWith(result.data.end()[-1].key));
															#line 3032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readBegin = readBeginTemp = keyAfter(atStorageVersion.end()[-1].key);
															#line 10084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent && vCurrent->isClearTo())
															#line 10090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(vCurrent->getEndKey() > readBegin);
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				readBegin = vCurrent->getEndKey();
															#line 3040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++vCurrent;
															#line 10098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(readEnd == range.end);
															#line 10104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& atStorageVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(atStorageVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && atStorageVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(atStorageVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRangeActor*>(this)->actor_wait_state > 0) static_cast<ReadRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangeActor*>(this)->ActorCallback< ReadRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2(int loopDepth) 
	{
															#line 3057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!(limit < 0 && *pLimitBytes > 0 && readEnd > range.begin))
															#line 10204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(!vCurrent || vCurrent.key() < readEnd);
															#line 3059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(data->storageVersion() <= version);
															#line 3062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (pos == resultCache.size())
															#line 10214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent)
															#line 10218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				auto b = vCurrent;
															#line 3065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++b;
															#line 3066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(!b || b.key() >= readEnd);
															#line 10226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			vCount = 0;
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int vSize = 0;
															#line 3071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(;vCurrent && vCurrent.key() >= range.begin && !vCurrent->isClearTo() && vCount < -limit && vSize < *pLimitBytes;) {
															#line 3074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				resultCache.emplace_back(result.arena, vCurrent.key(), vCurrent->getValue());
															#line 3075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				vSize += sizeof(KeyValueRef) + resultCache.cback().expectedSize();
															#line 3076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++vCount;
															#line 3077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				--vCurrent;
															#line 10242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
															#line 3081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBegin = vCurrent ? std::max(vCurrent->isClearTo() ? vCurrent->getEndKey() : vCurrent.key(), range.begin) : range.begin;
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = data->storage.readRange(KeyRangeRef(readBegin, readEnd), limit, *pLimitBytes, options);
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<ReadRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadRangeActor*>(this)->actor_wait_state = 2;
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRangeActor, 1, RangeResult >*>(static_cast<ReadRangeActor*>(this)));
															#line 10256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break2(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody2cont1(RangeResult const& atStorageVersion,int loopDepth) 
	{
															#line 3085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		logicalSize = atStorageVersion.logicalSize();
															#line 3086 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvScanBytes += logicalSize;
															#line 3087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultLogicalSize += logicalSize;
															#line 3088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeBytesLimitHistogram->sample(*pLimitBytes);
															#line 3090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(atStorageVersion.size() <= -limit);
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->storageVersion() > version)
															#line 10288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			DisabledTraceEvent("SS_TTO", data->thisServerID) .detail("StorageVersion", data->storageVersion()) .detail("Oldest", data->oldestVersion.get()) .detail("Version", version) .detail("Range", range);
															#line 3097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), std::max(0, loopDepth - 1));
															#line 10294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int prevSize = result.data.size();
															#line 3101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		merge(result.arena, result.data, resultCache, atStorageVersion, vCount, limit, atStorageVersion.more, pos, *pLimitBytes);
															#line 3110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit += result.data.size() - prevSize;
															#line 3112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(auto i = result.data.begin() + prevSize;i != result.data.end();i++) {
															#line 3113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pLimitBytes -= sizeof(KeyValueRef) + i->expectedSize();
															#line 10306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (limit >= 0 || *pLimitBytes <= 0)
															#line 10310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (atStorageVersion.more)
															#line 10316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(atStorageVersion.end()[-1].key.size() == result.data.end()[-1].key.size() && atStorageVersion.end()[-1].key.endsWith(result.data.end()[-1].key));
															#line 3124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readEnd = atStorageVersion.end()[-1].key;
															#line 10322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent && vCurrent->isClearTo())
															#line 10328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(vCurrent.key() < readEnd);
															#line 3127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				readEnd = vCurrent.key();
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				--vCurrent;
															#line 10336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(readBegin == range.begin);
															#line 10342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				return a_body1break2(loopDepth==0?0:loopDepth-1); // break
			}
		}
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2cont1(RangeResult && atStorageVersion,int loopDepth) 
	{
															#line 3085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		logicalSize = atStorageVersion.logicalSize();
															#line 3086 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.kvScanBytes += logicalSize;
															#line 3087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultLogicalSize += logicalSize;
															#line 3088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->readRangeBytesLimitHistogram->sample(*pLimitBytes);
															#line 3090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(atStorageVersion.size() <= -limit);
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->storageVersion() > version)
															#line 10364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			DisabledTraceEvent("SS_TTO", data->thisServerID) .detail("StorageVersion", data->storageVersion()) .detail("Oldest", data->oldestVersion.get()) .detail("Version", version) .detail("Range", range);
															#line 3097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(transaction_too_old(), std::max(0, loopDepth - 1));
															#line 10370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int prevSize = result.data.size();
															#line 3101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		merge(result.arena, result.data, resultCache, atStorageVersion, vCount, limit, atStorageVersion.more, pos, *pLimitBytes);
															#line 3110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit += result.data.size() - prevSize;
															#line 3112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(auto i = result.data.begin() + prevSize;i != result.data.end();i++) {
															#line 3113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pLimitBytes -= sizeof(KeyValueRef) + i->expectedSize();
															#line 10382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (limit >= 0 || *pLimitBytes <= 0)
															#line 10386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (atStorageVersion.more)
															#line 10392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(atStorageVersion.end()[-1].key.size() == result.data.end()[-1].key.size() && atStorageVersion.end()[-1].key.endsWith(result.data.end()[-1].key));
															#line 3124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readEnd = atStorageVersion.end()[-1].key;
															#line 10398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (vCurrent && vCurrent->isClearTo())
															#line 10404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(vCurrent.key() < readEnd);
															#line 3127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				readEnd = vCurrent.key();
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				--vCurrent;
															#line 10412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(readBegin == range.begin);
															#line 10418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				return a_body1break2(loopDepth==0?0:loopDepth-1); // break
			}
		}
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2when1(RangeResult const& atStorageVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(atStorageVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2when1(RangeResult && atStorageVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(std::move(atStorageVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRangeActor*>(this)->actor_wait_state > 0) static_cast<ReadRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangeActor*>(this)->ActorCallback< ReadRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange range;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int limit;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int* pLimitBytes;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	SpanContext parentSpan;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Optional<ReadOptions> options;
															#line 2908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesReply result;
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer::VersionedData::ViewAtVersion view;
															#line 2910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer::VersionedData::iterator vCurrent;
															#line 2911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRef readBegin;
															#line 2912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRef readEnd;
															#line 2913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key readBeginTemp;
															#line 2914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int vCount;
															#line 2915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 2916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int resultLogicalSize;
															#line 2917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int logicalSize;
															#line 2920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	VectorRef<KeyValueRef> resultCache;
															#line 2923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int pos;
															#line 10539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readRange()
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class ReadRangeActor final : public Actor<GetKeyValuesReply>, public ActorCallback< ReadRangeActor, 0, RangeResult >, public ActorCallback< ReadRangeActor, 1, RangeResult >, public FastAllocated<ReadRangeActor>, public ReadRangeActorState<ReadRangeActor> {
															#line 10544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadRangeActor>::operator new;
	using FastAllocated<ReadRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5982923943322413824UL, 6778363687086178304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetKeyValuesReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRangeActor, 0, RangeResult >;
friend struct ActorCallback< ReadRangeActor, 1, RangeResult >;
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ReadRangeActor(StorageServer* const& data,Version const& version,KeyRange const& range,int const& limit,int* const& pLimitBytes,SpanContext const& parentSpan,Optional<ReadOptions> const& options) 
															#line 10562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<GetKeyValuesReply>(),
		   ReadRangeActorState<ReadRangeActor>(data, version, range, limit, pLimitBytes, parentSpan, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3635396024098275328UL, 3211122134102601216UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<GetKeyValuesReply> readRange( StorageServer* const& data, Version const& version, KeyRange const& range, int const& limit, int* const& pLimitBytes, SpanContext const& parentSpan, Optional<ReadOptions> const& options ) {
															#line 2901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<GetKeyValuesReply>(new ReadRangeActor(data, version, range, limit, pLimitBytes, parentSpan, options));
															#line 10596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 3144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

															#line 10601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via findKey()
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class FindKeyActor>
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FindKeyActorState {
															#line 10608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FindKeyActorState(StorageServer* const& data,KeySelectorRef const& sel,Version const& version,KeyRange const& range,int* const& pOffset,SpanContext const& parentSpan,Optional<ReadOptions> const& options) 
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   sel(sel),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   range(range),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   pOffset(pOffset),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   parentSpan(parentSpan),
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   options(options)
															#line 10627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("findKey", reinterpret_cast<unsigned long>(this));

	}
	~FindKeyActorState() 
	{
		fdb_probe_actor_destroy("findKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(version != latestVersion);
															#line 3164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(selectorInRange(sel, range) && version >= data->oldestVersion.get());
															#line 3167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			forward = sel.offset > 0;
															#line 3168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			sign = forward ? +1 : -1;
															#line 3169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			skipEqualKey = sel.orEqual == forward;
															#line 3170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			distance = forward ? sel.offset : 1 - sel.offset;
															#line 3171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			span = Span("SS.findKey"_loc, parentSpan);
															#line 3175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			maxBytes = int();
															#line 3176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (sel.offset <= 1 && sel.offset >= 0)
															#line 10658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				maxBytes = std::numeric_limits<int>::max();
															#line 10662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				maxBytes = (g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::Disabled && BUGGIFY) ? SERVER_KNOBS->BUGGIFY_LIMIT_BYTES : SERVER_KNOBS->STORAGE_LIMIT_BYTES;
															#line 10668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<GetKeyValuesReply> __when_expr_0 = readRange(data, version, forward ? KeyRangeRef(sel.getKey(), range.end) : KeyRangeRef(range.begin, keyAfter(sel.getKey())), (distance + skipEqualKey) * sign, &maxBytes, span.context, options);
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FindKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FindKeyActor*>(this)->actor_wait_state = 1;
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FindKeyActor, 0, GetKeyValuesReply >*>(static_cast<FindKeyActor*>(this)));
															#line 10679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FindKeyActorState();
		static_cast<FindKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		more = rep.more && rep.data.size() != distance + skipEqualKey;
															#line 3195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (more && !forward && rep.data.size() == 1)
															#line 10704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "Reverse key selector returned only one result in range read");
															#line 3197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			maxBytes = std::numeric_limits<int>::max();
															#line 3198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<GetKeyValuesReply> __when_expr_1 = readRange( data, version, KeyRangeRef(range.begin, keyAfter(sel.getKey())), -2, &maxBytes, span.context, options);
															#line 3198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<FindKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FindKeyActor*>(this)->actor_wait_state = 2;
															#line 3198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FindKeyActor, 1, GetKeyValuesReply >*>(static_cast<FindKeyActor*>(this)));
															#line 10719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(GetKeyValuesReply const& __rep,int loopDepth) 
	{
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rep = __rep;
															#line 10733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetKeyValuesReply && __rep,int loopDepth) 
	{
		rep = std::move(__rep);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FindKeyActor*>(this)->actor_wait_state > 0) static_cast<FindKeyActor*>(this)->actor_wait_state = 0;
		static_cast<FindKeyActor*>(this)->ActorCallback< FindKeyActor, 0, GetKeyValuesReply >::remove();

	}
	void a_callback_fire(ActorCallback< FindKeyActor, 0, GetKeyValuesReply >*,GetKeyValuesReply const& value) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FindKeyActor, 0, GetKeyValuesReply >*,GetKeyValuesReply && value) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FindKeyActor, 0, GetKeyValuesReply >*,Error err) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int index = distance - 1;
															#line 3206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (skipEqualKey && rep.data.size() && rep.data[0].key == sel.getKey())
															#line 10814 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++index;
															#line 10818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (index < rep.data.size())
															#line 10822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pOffset = 0;
															#line 3212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (SERVER_KNOBS->READ_SAMPLING_ENABLED)
															#line 10828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				int64_t bytesReadPerKSecond = std::max((int64_t)rep.data[index].key.size(), SERVER_KNOBS->EMPTY_READ_PENALTY);
															#line 3215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				data->metrics.notifyBytesReadPerKSecond(sel.getKey(), bytesReadPerKSecond);
															#line 10834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<FindKeyActor*>(this)->SAV<Key>::futures) { (void)(rep.data[index].key); this->~FindKeyActorState(); static_cast<FindKeyActor*>(this)->destroy(); return 0; }
															#line 10838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<FindKeyActor*>(this)->SAV< Key >::value()) Key(rep.data[index].key);
			this->~FindKeyActorState();
			static_cast<FindKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 3220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (SERVER_KNOBS->READ_SAMPLING_ENABLED)
															#line 10848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				int64_t bytesReadPerKSecond = SERVER_KNOBS->EMPTY_READ_PENALTY;
															#line 3222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				data->metrics.notifyBytesReadPerKSecond(sel.getKey(), bytesReadPerKSecond);
															#line 10854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			*pOffset = index - rep.data.size() + 1;
															#line 3227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!forward)
															#line 10860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				*pOffset = -*pOffset;
															#line 10864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (more)
															#line 10868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				CODE_PROBE(true, "Key selector read range had more results");
															#line 3233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(rep.data.size());
															#line 3234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				Key returnKey = forward ? keyAfter(rep.data.back().key) : rep.data.back().key;
															#line 3238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(returnKey != sel.getKey());
															#line 3239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<FindKeyActor*>(this)->SAV<Key>::futures) { (void)(returnKey); this->~FindKeyActorState(); static_cast<FindKeyActor*>(this)->destroy(); return 0; }
															#line 10880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<FindKeyActor*>(this)->SAV< Key >::value()) Key(returnKey);
				this->~FindKeyActorState();
				static_cast<FindKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 3241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<FindKeyActor*>(this)->SAV<Key>::futures) { (void)(forward ? range.end : range.begin); this->~FindKeyActorState(); static_cast<FindKeyActor*>(this)->destroy(); return 0; }
															#line 10890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<FindKeyActor*>(this)->SAV< Key >::value()) Key(forward ? range.end : range.begin);
				this->~FindKeyActorState();
				static_cast<FindKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont5(GetKeyValuesReply const& rep2,int loopDepth) 
	{
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rep = rep2;
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		more = rep.more && rep.data.size() != distance + skipEqualKey;
															#line 3202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(rep.data.size() == 2 || !more);
															#line 10908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(GetKeyValuesReply && rep2,int loopDepth) 
	{
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rep = rep2;
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		more = rep.more && rep.data.size() != distance + skipEqualKey;
															#line 3202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ASSERT(rep.data.size() == 2 || !more);
															#line 10921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GetKeyValuesReply const& rep2,int loopDepth) 
	{
		loopDepth = a_body1cont5(rep2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GetKeyValuesReply && rep2,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(rep2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FindKeyActor*>(this)->actor_wait_state > 0) static_cast<FindKeyActor*>(this)->actor_wait_state = 0;
		static_cast<FindKeyActor*>(this)->ActorCallback< FindKeyActor, 1, GetKeyValuesReply >::remove();

	}
	void a_callback_fire(ActorCallback< FindKeyActor, 1, GetKeyValuesReply >*,GetKeyValuesReply const& value) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FindKeyActor, 1, GetKeyValuesReply >*,GetKeyValuesReply && value) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FindKeyActor, 1, GetKeyValuesReply >*,Error err) 
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeySelectorRef sel;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange range;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int* pOffset;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	SpanContext parentSpan;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Optional<ReadOptions> options;
															#line 3167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	bool forward;
															#line 3168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int sign;
															#line 3169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	bool skipEqualKey;
															#line 3170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int distance;
															#line 3171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 3175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int maxBytes;
															#line 3183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesReply rep;
															#line 3191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	bool more;
															#line 11031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via findKey()
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FindKeyActor final : public Actor<Key>, public ActorCallback< FindKeyActor, 0, GetKeyValuesReply >, public ActorCallback< FindKeyActor, 1, GetKeyValuesReply >, public FastAllocated<FindKeyActor>, public FindKeyActorState<FindKeyActor> {
															#line 11036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FindKeyActor>::operator new;
	using FastAllocated<FindKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3997666637255648256UL, 8773374977891209216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FindKeyActor, 0, GetKeyValuesReply >;
friend struct ActorCallback< FindKeyActor, 1, GetKeyValuesReply >;
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FindKeyActor(StorageServer* const& data,KeySelectorRef const& sel,Version const& version,KeyRange const& range,int* const& pOffset,SpanContext const& parentSpan,Optional<ReadOptions> const& options) 
															#line 11054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   FindKeyActorState<FindKeyActor>(data, sel, version, range, pOffset, parentSpan, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("findKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11946933499123123200UL, 11635880071562820096UL);
		ActorExecutionContextHelper __helper(static_cast<FindKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("findKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("findKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FindKeyActor, 0, GetKeyValuesReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FindKeyActor, 1, GetKeyValuesReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Key> findKey( StorageServer* const& data, KeySelectorRef const& sel, Version const& version, KeyRange const& range, int* const& pOffset, SpanContext const& parentSpan, Optional<ReadOptions> const& options ) {
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Key>(new FindKeyActor(data, sel, version, range, pOffset, parentSpan, options));
															#line 11088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 3245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

KeyRange getShardKeyRange(StorageServer* data, const KeySelectorRef& sel)
// Returns largest range such that the shard state isReadable and selectorInRange(sel, range) or wrong_shard_server if
// no such range exists
{
	auto i = sel.isBackward() ? data->shards.rangeContainingKeyBefore(sel.getKey())
	                          : data->shards.rangeContaining(sel.getKey());
	auto fullRange = data->shards.ranges();
	if (!i->value()->isReadable())
		throw wrong_shard_server();
	ASSERT(selectorInRange(sel, i->range()));
	Key begin, end;
	if (sel.isBackward()) {
		end = i->range().end;
		while (i != fullRange.begin() && i.value()->isReadable()) {
			begin = i->range().begin;
			--i;
		}
		if (i.value()->isReadable()) {
			begin = i->range().begin;
		}
	} else {
		begin = i->range().begin;
		while (i != fullRange.end() && i.value()->isReadable()) {
			end = i->range().end;
			++i;
		}
	}
	return KeyRangeRef(begin, end);
}

void maybeInjectConsistencyScanCorruption(UID thisServerID, GetKeyValuesRequest const& req, GetKeyValuesReply& reply) {
	if (g_simulator->consistencyScanState != ISimulator::SimConsistencyScanState::Enabled_InjectCorruption ||
	    !req.options.present() || !req.options.get().consistencyCheckStartVersion.present() ||
	    !g_simulator->consistencyScanCorruptRequestKey.present()) {
		return;
	}

	UID destination = req.reply.getEndpoint().token;

	ASSERT(g_simulator->consistencyScanInjectedCorruptionType.present() ==
	       g_simulator->consistencyScanInjectedCorruptionDestination.present());
	// if we already injected a corruption, reinject it if this request was a retransmit of the same one we corrupted
	// could also check that this storage sent the corruption but the reply endpoints should be globally unique so this
	// covers it
	if (g_simulator->consistencyScanInjectedCorruptionDestination.present() &&
	    (g_simulator->consistencyScanInjectedCorruptionDestination.get() != destination)) {
		return;
	}

	CODE_PROBE(true, "consistency check injecting corruption");
	CODE_PROBE(g_simulator->consistencyScanInjectedCorruptionDestination.present() &&
	               g_simulator->consistencyScanInjectedCorruptionDestination.get() == destination,
	           "consistency check re-injecting corruption after retransmit",
	           probe::decoration::rare);

	g_simulator->consistencyScanInjectedCorruptionDestination = destination;
	// FIXME: reinject same type of corruption once we enable other types

	// FIXME: code probe for each type?

	if (true /*deterministicRandom()->random01() < 0.3*/) {
		// flip more flag
		reply.more = !reply.more;
		g_simulator->consistencyScanInjectedCorruptionType = ISimulator::SimConsistencyScanCorruptionType::FlipMoreFlag;
	} else {
		// FIXME: weird memory issues when messing with actual response data, enable and figure out later
		ASSERT(false);
		// make deep copy of request, since some of the underlying memory can reference storage engine data directly
		GetKeyValuesReply copy = reply;
		reply = GetKeyValuesReply();
		reply.more = copy.more;
		reply.cached = copy.cached;
		reply.version = copy.version;
		reply.data.append_deep(reply.arena, copy.data.begin(), copy.data.size());

		if (reply.data.empty()) {
			// add row to empty response
			g_simulator->consistencyScanInjectedCorruptionType =
			    ISimulator::SimConsistencyScanCorruptionType::AddToEmpty;
			reply.data.push_back_deep(
			    reply.arena,
			    KeyValueRef(g_simulator->consistencyScanCorruptRequestKey.get(), "consistencyCheckCorruptValue"_sr));
		} else if (deterministicRandom()->coinflip() || reply.data.back().value.empty()) {
			// change value in non-empty response
			g_simulator->consistencyScanInjectedCorruptionType =
			    ISimulator::SimConsistencyScanCorruptionType::RemoveLastRow;
			reply.data.pop_back();
		} else {
			// chop off last byte of first value
			g_simulator->consistencyScanInjectedCorruptionType =
			    ISimulator::SimConsistencyScanCorruptionType::ChangeFirstValue;

			reply.data[0].value = reply.data[0].value.substr(0, reply.data[0].value.size() - 1);
		}
	}

	TraceEvent(SevWarnAlways, "InjectedConsistencyScanCorruption", thisServerID)
	    .detail("CorruptionType", g_simulator->consistencyScanInjectedCorruptionType.get())
	    .detail("Version", req.version)
	    .detail("Count", reply.data.size());
}

															#line 11195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyValuesQ()
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class GetKeyValuesQActor>
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetKeyValuesQActorState {
															#line 11202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesQActorState(StorageServer* const& data,GetKeyValuesRequest const& req) 
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req),
															#line 3352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   span("SS:getKeyValues"_loc, req.spanContext),
															#line 3353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   resultSize(0)
															#line 11215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyValuesQ", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyValuesQActorState() 
	{
		fdb_probe_actor_destroy("getKeyValuesQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::txID) = req.spanContext.traceID;
															#line 3357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.getRangeQueries;
															#line 3358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.allQueries;
															#line 3359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.begin.getKey().startsWith(systemKeys.begin))
															#line 11236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++data->counters.systemKeyQueries;
															#line 3361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				++data->counters.getRangeSystemKeyQueries;
															#line 11242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->maxQueryQueue = std::max<int>( data->maxQueryQueue, data->counters.allQueries.getValue() - data->counters.finishedQueries.getValue());
															#line 3368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->getQueryDelay();
															#line 3368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 1;
															#line 3368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 0, Void >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyValuesQActorState();
		static_cast<GetKeyValuesQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<PriorityMultiLock::Lock> __when_expr_1 = data->getReadLock(req.options);
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 2;
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<PriorityMultiLock::Lock> __when_expr_1 = data->getReadLock(req.options);
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 2;
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		queueWaitEnd = g_network->timer();
															#line 3373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( queueWaitEnd - req.requestTime(), ReadLatencySamples::READ_QUEUE_WAIT, trackedReadType(req));
															#line 11387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 3377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.options.present() && req.options.get().debugID.present())
															#line 11391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent( "TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.Before");
															#line 11395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Version commitVersion = getLatestCommitVersion(req.ssLatestCommitVersions, data->tag);
															#line 3382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Version> __when_expr_2 = waitForVersion(data, commitVersion, req.version, span.context);
															#line 3382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 11403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 3;
															#line 3382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 2, Version >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(PriorityMultiLock::Lock const& __readLock,int loopDepth) 
	{
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readLock = __readLock;
															#line 11423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(PriorityMultiLock::Lock && __readLock,int loopDepth) 
	{
		readLock = std::move(__readLock);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->transactionTagCounter.addRequest(req.tags, resultSize);
															#line 3539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		++data->counters.finishedQueries;
															#line 3541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		double duration = g_network->timer() - req.requestTime();
															#line 3542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::READ, trackedReadType(req));
															#line 3543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::READ_RANGE, trackedReadType(req));
															#line 3544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->latencyBandConfig.present())
															#line 11512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int maxReadBytes = data->latencyBandConfig.get().readConfig.maxReadBytes.orDefault(std::numeric_limits<int>::max());
															#line 3547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int maxSelectorOffset = data->latencyBandConfig.get().readConfig.maxKeySelectorOffset.orDefault(std::numeric_limits<int>::max());
															#line 3549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencyBands.addMeasurement(duration, 1, Filtered(resultSize > maxReadBytes || abs(req.begin.offset) > maxSelectorOffset || abs(req.end.offset) > maxSelectorOffset));
															#line 11520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<GetKeyValuesQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyValuesQActorState(); static_cast<GetKeyValuesQActor*>(this)->destroy(); return 0; }
															#line 11524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyValuesQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKeyValuesQActorState();
		static_cast<GetKeyValuesQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!canReplyWith(e))
															#line 11537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->sendErrorWithPenalty(req.reply, e, data->getPenalty());
															#line 11545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 3383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		DisabledTraceEvent("VVV", data->thisServerID) .detail("Version", version) .detail("ReqVersion", req.version) .detail("Oldest", data->oldestVersion.get()) .detail("VV", req.ssLatestCommitVersions.toString()) .detail("DebugID", req.options.present() && req.options.get().debugID.present() ? req.options.get().debugID.get() : UID());
															#line 3391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( g_network->timer() - queueWaitEnd, ReadLatencySamples::READ_VERSION_WAIT, trackedReadType(req));
															#line 3394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		changeCounter = data->shardChangeCounter;
															#line 3396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		shard = getShardKeyRange(data, req.begin);
															#line 3398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 11568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.AfterVersion");
															#line 11572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!selectorInRange(req.end, shard) && !(req.end.isFirstGreaterOrEqual() && req.end.getKey() == shard.end))
															#line 11576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont3Catch1(wrong_shard_server(), loopDepth);
															#line 11580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		offset1 = 0;
															#line 3418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		offset2 = int();
															#line 3419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fBegin = req.begin.isFirstGreaterOrEqual() ? Future<Key>(req.begin.getKey()) : findKey(data, req.begin, version, shard, &offset1, span.context, req.options);
															#line 3422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fEnd = req.end.isFirstGreaterOrEqual() ? Future<Key>(req.end.getKey()) : findKey(data, req.end, version, shard, &offset2, span.context, req.options);
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Key> __when_expr_3 = fBegin;
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 11594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 4;
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 3, Key >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Version const& __version,int loopDepth) 
	{
															#line 3382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = __version;
															#line 11608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Version && __version,int loopDepth) 
	{
		version = std::move(__version);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Key> __when_expr_4 = fEnd;
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 11689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 5;
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 4, Key >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Key const& __begin,int loopDepth) 
	{
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		begin = __begin;
															#line 11703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Key && __begin,int loopDepth) 
	{
		begin = std::move(__begin);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 3, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 3, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 3, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 3, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 3428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 11782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.AfterKeys");
															#line 11786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if ((offset1 && offset1 != 1) || (offset2 && offset2 != 1))
															#line 11790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			CODE_PROBE(true, "wrong_shard_server due to offset");
															#line 3454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont3Catch1(wrong_shard_server(), loopDepth);
															#line 11796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (begin >= end)
															#line 11800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (req.options.present() && req.options.get().debugID.present())
															#line 11804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent( "TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.Send");
															#line 11808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			GetKeyValuesReply none;
															#line 3464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			none.version = version;
															#line 3465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			none.more = false;
															#line 3466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			none.penalty = data->getPenalty();
															#line 3468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->checkChangeCounter(changeCounter, KeyRangeRef(std::min<KeyRef>(req.begin.getKey(), req.end.getKey()), std::max<KeyRef>(req.begin.getKey(), req.end.getKey())));
															#line 3472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (g_network->isSimulated())
															#line 11822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				maybeInjectConsistencyScanCorruption(data->thisServerID, req, none);
															#line 11826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.send(none);
															#line 11830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		else
		{
															#line 3477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			remainingLimitBytes = req.limitBytes;
															#line 3479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			kvReadRange = g_network->timer();
															#line 3480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<GetKeyValuesReply> __when_expr_5 = readRange( data, version, KeyRangeRef(begin, end), req.limit, &remainingLimitBytes, span.context, req.options);
															#line 3480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 11843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
			static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 6;
															#line 3480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >*>(static_cast<GetKeyValuesQActor*>(this)));
															#line 11848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont7when1(Key const& __end,int loopDepth) 
	{
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		end = __end;
															#line 11858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Key && __end,int loopDepth) 
	{
		end = std::move(__end);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 4, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 4, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 4, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 4, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(GetKeyValuesReply const& _r,int loopDepth) 
	{
															#line 3482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const double duration = g_network->timer() - kvReadRange;
															#line 3483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::KV_READ_RANGE, trackedReadType(req));
															#line 3484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetKeyValuesReply r = _r;
															#line 3486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 11949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.AfterReadRange");
															#line 11953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->checkChangeCounter( changeCounter, KeyRangeRef(std::min<KeyRef>(begin, std::min<KeyRef>(req.begin.getKey(), req.end.getKey())), std::max<KeyRef>(end, std::max<KeyRef>(req.begin.getKey(), req.end.getKey()))));
															#line 3495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (EXPENSIVE_VALIDATION)
															#line 11959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(int i = 0;i < r.data.size();i++) {
															#line 3497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(r.data[i].key >= begin && r.data[i].key < end);
															#line 11965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(r.data.size() <= std::abs(req.limit));
															#line 11969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int64_t totalByteSize = 0;
															#line 3504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < r.data.size();i++) {
															#line 3505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			totalByteSize += r.data[i].expectedSize();
															#line 11977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.taskID.present() && req.taskID.get() == TaskPriority::FetchKeys)
															#line 11981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.kvFetchServed += r.data.size();
															#line 3510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.kvFetchBytesServed += (totalByteSize + (8 - (int)sizeof(KeyValueRef)) * r.data.size());
															#line 11987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (totalByteSize > 0 && SERVER_KNOBS->READ_SAMPLING_ENABLED)
															#line 11991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int64_t bytesReadPerKSecond = std::max(totalByteSize, SERVER_KNOBS->EMPTY_READ_PENALTY) / 2;
															#line 3515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->metrics.notifyBytesReadPerKSecond(r.data[0].key, bytesReadPerKSecond);
															#line 3516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->metrics.notifyBytesReadPerKSecond(r.data[r.data.size() - 1].key, bytesReadPerKSecond);
															#line 11999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		r.penalty = data->getPenalty();
															#line 3520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (g_network->isSimulated())
															#line 12005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			maybeInjectConsistencyScanCorruption(data->thisServerID, req, r);
															#line 12009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(r);
															#line 3525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultSize = req.limitBytes - remainingLimitBytes;
															#line 3526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.bytesQueried += resultSize;
															#line 3527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.rowsQueried += r.data.size();
															#line 3528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (r.data.size() == 0)
															#line 12021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.emptyQueries;
															#line 12025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(GetKeyValuesReply && _r,int loopDepth) 
	{
															#line 3482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const double duration = g_network->timer() - kvReadRange;
															#line 3483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample(duration, ReadLatencySamples::KV_READ_RANGE, trackedReadType(req));
															#line 3484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetKeyValuesReply r = _r;
															#line 3486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.options.present() && req.options.get().debugID.present())
															#line 12041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.options.get().debugID.get().first(), "storageserver.getKeyValues.AfterReadRange");
															#line 12045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->checkChangeCounter( changeCounter, KeyRangeRef(std::min<KeyRef>(begin, std::min<KeyRef>(req.begin.getKey(), req.end.getKey())), std::max<KeyRef>(end, std::max<KeyRef>(req.begin.getKey(), req.end.getKey()))));
															#line 3495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (EXPENSIVE_VALIDATION)
															#line 12051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for(int i = 0;i < r.data.size();i++) {
															#line 3497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ASSERT(r.data[i].key >= begin && r.data[i].key < end);
															#line 12057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(r.data.size() <= std::abs(req.limit));
															#line 12061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		int64_t totalByteSize = 0;
															#line 3504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < r.data.size();i++) {
															#line 3505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			totalByteSize += r.data[i].expectedSize();
															#line 12069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (req.taskID.present() && req.taskID.get() == TaskPriority::FetchKeys)
															#line 12073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.kvFetchServed += r.data.size();
															#line 3510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.kvFetchBytesServed += (totalByteSize + (8 - (int)sizeof(KeyValueRef)) * r.data.size());
															#line 12079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (totalByteSize > 0 && SERVER_KNOBS->READ_SAMPLING_ENABLED)
															#line 12083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			int64_t bytesReadPerKSecond = std::max(totalByteSize, SERVER_KNOBS->EMPTY_READ_PENALTY) / 2;
															#line 3515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->metrics.notifyBytesReadPerKSecond(r.data[0].key, bytesReadPerKSecond);
															#line 3516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->metrics.notifyBytesReadPerKSecond(r.data[r.data.size() - 1].key, bytesReadPerKSecond);
															#line 12091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		r.penalty = data->getPenalty();
															#line 3520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (g_network->isSimulated())
															#line 12097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			maybeInjectConsistencyScanCorruption(data->thisServerID, req, r);
															#line 12101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(r);
															#line 3525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		resultSize = req.limitBytes - remainingLimitBytes;
															#line 3526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.bytesQueried += resultSize;
															#line 3527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.rowsQueried += r.data.size();
															#line 3528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (r.data.size() == 0)
															#line 12113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.emptyQueries;
															#line 12117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(GetKeyValuesReply const& _r,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_r, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(GetKeyValuesReply && _r,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetKeyValuesQActor*>(this)->actor_wait_state > 0) static_cast<GetKeyValuesQActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyValuesQActor*>(this)->ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >*,GetKeyValuesReply const& value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >*,GetKeyValuesReply && value) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesRequest req;
															#line 3352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Span span;
															#line 3353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t resultSize;
															#line 3369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	PriorityMultiLock::Lock readLock;
															#line 3372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double queueWaitEnd;
															#line 3382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 3394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	uint64_t changeCounter;
															#line 3396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange shard;
															#line 3417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int offset1;
															#line 3418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int offset2;
															#line 3419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<Key> fBegin;
															#line 3422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<Key> fEnd;
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key begin;
															#line 3426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key end;
															#line 3477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int remainingLimitBytes;
															#line 3479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double kvReadRange;
															#line 12245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyValuesQ()
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class GetKeyValuesQActor final : public Actor<Void>, public ActorCallback< GetKeyValuesQActor, 0, Void >, public ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >, public ActorCallback< GetKeyValuesQActor, 2, Version >, public ActorCallback< GetKeyValuesQActor, 3, Key >, public ActorCallback< GetKeyValuesQActor, 4, Key >, public ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >, public FastAllocated<GetKeyValuesQActor>, public GetKeyValuesQActorState<GetKeyValuesQActor> {
															#line 12250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyValuesQActor>::operator new;
	using FastAllocated<GetKeyValuesQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(67408570149641216UL, 16730319227014765568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyValuesQActor, 0, Void >;
friend struct ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >;
friend struct ActorCallback< GetKeyValuesQActor, 2, Version >;
friend struct ActorCallback< GetKeyValuesQActor, 3, Key >;
friend struct ActorCallback< GetKeyValuesQActor, 4, Key >;
friend struct ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >;
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesQActor(StorageServer* const& data,GetKeyValuesRequest const& req) 
															#line 12272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetKeyValuesQActorState<GetKeyValuesQActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyValuesQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15085295619130978816UL, 4562439640475096832UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyValuesQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyValuesQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyValuesQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 1, PriorityMultiLock::Lock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 3, Key >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 4, Key >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetKeyValuesQActor, 5, GetKeyValuesReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> getKeyValuesQ( StorageServer* const& data, GetKeyValuesRequest const& req ) {
															#line 3348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new GetKeyValuesQActor(data, req));
															#line 12310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 3558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

															#line 12315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via quickGetKeyValues()
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class QuickGetKeyValuesActor>
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class QuickGetKeyValuesActorState {
															#line 12322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	QuickGetKeyValuesActorState(StorageServer* const& data,StringRef const& prefix,Version const& version,Arena* const& a,GetMappedKeyValuesRequest* const& pOriginalReq) 
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   prefix(prefix),
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   a(a),
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   pOriginalReq(pOriginalReq),
															#line 3566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   getRange(),
															#line 3567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   getValuesStart(g_network->timer())
															#line 12341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("quickGetKeyValues", reinterpret_cast<unsigned long>(this));

	}
	~QuickGetKeyValuesActorState() 
	{
		fdb_probe_actor_destroy("quickGetKeyValues", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getRange.begin = firstGreaterOrEqual(KeyRef(*a, prefix));
															#line 3569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getRange.end = firstGreaterOrEqual(strinc(prefix, *a));
															#line 3570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", pOriginalReq->options.get().debugID.get().first(), "storageserver.quickGetKeyValues.Before");
															#line 12364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			try {
															#line 3576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				GetKeyValuesRequest req;
															#line 3577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.spanContext = pOriginalReq->spanContext;
															#line 3578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.options = pOriginalReq->options;
															#line 3579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.arena = *a;
															#line 3580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.begin = getRange.begin;
															#line 3581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.end = getRange.end;
															#line 3582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.version = version;
															#line 3585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.limit = SERVER_KNOBS->QUICK_GET_KEY_VALUES_LIMIT;
															#line 3586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.limitBytes = SERVER_KNOBS->QUICK_GET_KEY_VALUES_LIMIT_BYTES;
															#line 3587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.options = pOriginalReq->options;
															#line 3589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.tags = pOriginalReq->tags;
															#line 3590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.ssLatestCommitVersions = VersionVector();
															#line 3595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				data->actors.add(getKeyValuesQ(data, req));
															#line 3596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				StrictFuture<GetKeyValuesReply> __when_expr_0 = req.reply.getFuture();
															#line 3596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state = 1;
															#line 3596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >*>(static_cast<QuickGetKeyValuesActor*>(this)));
															#line 12402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QuickGetKeyValuesActorState();
		static_cast<QuickGetKeyValuesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		++data->counters.quickGetKeyValuesMiss;
															#line 3617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (SERVER_KNOBS->QUICK_GET_KEY_VALUES_FALLBACK)
															#line 12433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr = Transaction(data->cx);
															#line 3619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setVersion(version);
															#line 3620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				tr.debugTransaction(pOriginalReq->options.get().debugID.get());
															#line 12445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.trState->taskID = TaskPriority::DefaultPromiseEndpoint;
															#line 3625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Future<RangeResult> rangeResultFuture = tr.getRange(prefixRange(prefix), GetRangeLimits::ROW_LIMIT_UNLIMITED, Snapshot::True);
															#line 3628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = rangeResultFuture;
															#line 3628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state = 2;
															#line 3628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >*>(static_cast<QuickGetKeyValuesActor*>(this)));
															#line 12460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 3640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(quick_get_key_values_miss(), loopDepth);
															#line 12467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(GetKeyValuesReply const& reply,int loopDepth) 
	{
															#line 3597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!reply.error.present())
															#line 12489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.quickGetKeyValuesHit;
															#line 3600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			a->dependsOn(reply.arena);
															#line 3601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getRange.result = RangeResultRef(reply.data, reply.more);
															#line 3602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const double duration = g_network->timer() - getValuesStart;
															#line 3603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_LOCAL, trackedReadType(*pOriginalReq));
															#line 3605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", pOriginalReq->options.get().debugID.get().first(), "storageserver.quickGetKeyValues.AfterLocalFetch");
															#line 12507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<QuickGetKeyValuesActor*>(this)->SAV<GetRangeReqAndResultRef>::futures) { (void)(getRange); this->~QuickGetKeyValuesActorState(); static_cast<QuickGetKeyValuesActor*>(this)->destroy(); return 0; }
															#line 12511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<QuickGetKeyValuesActor*>(this)->SAV< GetRangeReqAndResultRef >::value()) GetRangeReqAndResultRef(std::move(getRange)); // state_var_RVO
			this->~QuickGetKeyValuesActorState();
			static_cast<QuickGetKeyValuesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(GetKeyValuesReply && reply,int loopDepth) 
	{
															#line 3597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!reply.error.present())
															#line 12525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			++data->counters.quickGetKeyValuesHit;
															#line 3600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			a->dependsOn(reply.arena);
															#line 3601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			getRange.result = RangeResultRef(reply.data, reply.more);
															#line 3602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			const double duration = g_network->timer() - getValuesStart;
															#line 3603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_LOCAL, trackedReadType(*pOriginalReq));
															#line 3605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", pOriginalReq->options.get().debugID.get().first(), "storageserver.quickGetKeyValues.AfterLocalFetch");
															#line 12543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<QuickGetKeyValuesActor*>(this)->SAV<GetRangeReqAndResultRef>::futures) { (void)(getRange); this->~QuickGetKeyValuesActorState(); static_cast<QuickGetKeyValuesActor*>(this)->destroy(); return 0; }
															#line 12547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<QuickGetKeyValuesActor*>(this)->SAV< GetRangeReqAndResultRef >::value()) GetRangeReqAndResultRef(std::move(getRange)); // state_var_RVO
			this->~QuickGetKeyValuesActorState();
			static_cast<QuickGetKeyValuesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetKeyValuesReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetKeyValuesReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state > 0) static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state = 0;
		static_cast<QuickGetKeyValuesActor*>(this)->ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >::remove();

	}
	void a_callback_fire(ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >*,GetKeyValuesReply const& value) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >*,GetKeyValuesReply && value) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >*,Error err) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(RangeResult const& rangeResult,int loopDepth) 
	{
															#line 3629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		a->dependsOn(rangeResult.arena());
															#line 3630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		getRange.result = rangeResult;
															#line 3631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const double duration = g_network->timer() - getValuesStart;
															#line 3632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_REMOTE, trackedReadType(*pOriginalReq));
															#line 3634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", pOriginalReq->options.get().debugID.get().first(), "storageserver.quickGetKeyValues.AfterRemoteFetch");
															#line 12661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<QuickGetKeyValuesActor*>(this)->SAV<GetRangeReqAndResultRef>::futures) { (void)(getRange); this->~QuickGetKeyValuesActorState(); static_cast<QuickGetKeyValuesActor*>(this)->destroy(); return 0; }
															#line 12665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<QuickGetKeyValuesActor*>(this)->SAV< GetRangeReqAndResultRef >::value()) GetRangeReqAndResultRef(std::move(getRange)); // state_var_RVO
		this->~QuickGetKeyValuesActorState();
		static_cast<QuickGetKeyValuesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(RangeResult && rangeResult,int loopDepth) 
	{
															#line 3629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		a->dependsOn(rangeResult.arena());
															#line 3630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		getRange.result = rangeResult;
															#line 3631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		const double duration = g_network->timer() - getValuesStart;
															#line 3632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->counters.readLatencySamples.sample( duration, ReadLatencySamples::MAPPED_RANGE_REMOTE, trackedReadType(*pOriginalReq));
															#line 3634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (pOriginalReq->options.present() && pOriginalReq->options.get().debugID.present())
															#line 12685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", pOriginalReq->options.get().debugID.get().first(), "storageserver.quickGetKeyValues.AfterRemoteFetch");
															#line 12689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<QuickGetKeyValuesActor*>(this)->SAV<GetRangeReqAndResultRef>::futures) { (void)(getRange); this->~QuickGetKeyValuesActorState(); static_cast<QuickGetKeyValuesActor*>(this)->destroy(); return 0; }
															#line 12693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<QuickGetKeyValuesActor*>(this)->SAV< GetRangeReqAndResultRef >::value()) GetRangeReqAndResultRef(std::move(getRange)); // state_var_RVO
		this->~QuickGetKeyValuesActorState();
		static_cast<QuickGetKeyValuesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& rangeResult,int loopDepth) 
	{
		loopDepth = a_body1cont9(rangeResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && rangeResult,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(rangeResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state > 0) static_cast<QuickGetKeyValuesActor*>(this)->actor_wait_state = 0;
		static_cast<QuickGetKeyValuesActor*>(this)->ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StringRef prefix;
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Arena* a;
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetMappedKeyValuesRequest* pOriginalReq;
															#line 3566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetRangeReqAndResultRef getRange;
															#line 3567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double getValuesStart;
															#line 3618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Transaction tr;
															#line 12792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via quickGetKeyValues()
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class QuickGetKeyValuesActor final : public Actor<GetRangeReqAndResultRef>, public ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >, public ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >, public FastAllocated<QuickGetKeyValuesActor>, public QuickGetKeyValuesActorState<QuickGetKeyValuesActor> {
															#line 12797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<QuickGetKeyValuesActor>::operator new;
	using FastAllocated<QuickGetKeyValuesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1384633608941609728UL, 13644541450394239488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetRangeReqAndResultRef>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >;
friend struct ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >;
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	QuickGetKeyValuesActor(StorageServer* const& data,StringRef const& prefix,Version const& version,Arena* const& a,GetMappedKeyValuesRequest* const& pOriginalReq) 
															#line 12815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<GetRangeReqAndResultRef>(),
		   QuickGetKeyValuesActorState<QuickGetKeyValuesActor>(data, prefix, version, a, pOriginalReq),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("quickGetKeyValues", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10745188868789411328UL, 14092707623558697728UL);
		ActorExecutionContextHelper __helper(static_cast<QuickGetKeyValuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("quickGetKeyValues");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("quickGetKeyValues", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< QuickGetKeyValuesActor, 0, GetKeyValuesReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< QuickGetKeyValuesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<GetRangeReqAndResultRef> quickGetKeyValues( StorageServer* const& data, StringRef const& prefix, Version const& version, Arena* const& a, GetMappedKeyValuesRequest* const& pOriginalReq ) {
															#line 3559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<GetRangeReqAndResultRef>(new QuickGetKeyValuesActor(data, prefix, version, a, pOriginalReq));
															#line 12849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 3643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

void unpackKeyTuple(Tuple** referenceTuple, Optional<Tuple>& keyTuple, KeyValueRef* keyValue) {
	if (!keyTuple.present()) {
		// May throw exception if the key is not parsable as a tuple.
		try {
			keyTuple = Tuple::unpack(keyValue->key);
		} catch (Error& e) {
			TraceEvent("KeyNotTuple").error(e).detail("Key", keyValue->key.printable());
			throw key_not_tuple();
		}
	}
	*referenceTuple = &keyTuple.get();
}

void unpackValueTuple(Tuple** referenceTuple, Optional<Tuple>& valueTuple, KeyValueRef* keyValue) {
	if (!valueTuple.present()) {
		// May throw exception if the value is not parsable as a tuple.
		try {
			valueTuple = Tuple::unpack(keyValue->value);
		} catch (Error& e) {
			TraceEvent("ValueNotTuple").error(e).detail("Value", keyValue->value.printable());
			throw value_not_tuple();
		}
	}
	*referenceTuple = &valueTuple.get();
}

bool unescapeLiterals(std::string& s, std::string before, std::string after) {
	bool escaped = false;
	size_t p = 0;
	while (true) {
		size_t found = s.find(before, p);
		if (found == std::string::npos) {
			break;
		}
		s.replace(found, before.length(), after);
		p = found + after.length();
		escaped = true;
	}
	return escaped;
}

bool singleKeyOrValue(const std::string& s, size_t sz) {
	// format would be {K[??]} or {V[??]}
	return sz > 5 && s[0] == '{' && (s[1] == 'K' || s[1] == 'V') && s[2] == '[' && s[sz - 2] == ']' && s[sz - 1] == '}';
}

bool rangeQuery(const std::string& s) {
	return s == "{...}";
}

// create a vector of Optional<Tuple>
// in case of a singleKeyOrValue, insert an empty Tuple to vector as placeholder
// in case of a rangeQuery, insert Optional.empty as placeholder
// in other cases, insert the correct Tuple to be used.
void preprocessMappedKey(Tuple& mappedKeyFormatTuple, std::vector<Optional<Tuple>>& vt, bool& isRangeQuery) {
	vt.reserve(mappedKeyFormatTuple.size());

	for (int i = 0; i < mappedKeyFormatTuple.size(); i++) {
		Tuple::ElementType type = mappedKeyFormatTuple.getType(i);
		if (type == Tuple::BYTES || type == Tuple::UTF8) {
			std::string s = mappedKeyFormatTuple.getString(i).toString();
			auto sz = s.size();
			bool escaped = unescapeLiterals(s, "{{", "{");
			escaped = unescapeLiterals(s, "}}", "}") || escaped;
			if (escaped) {
				vt.emplace_back(Tuple::makeTuple(s));
			} else if (singleKeyOrValue(s, sz)) {
				// when it is SingleKeyOrValue, insert an empty Tuple to vector as placeholder
				vt.emplace_back(Tuple());
			} else if (rangeQuery(s)) {
				if (i != mappedKeyFormatTuple.size() - 1) {
					// It must be the last element of the mapper tuple
					throw mapper_bad_range_decriptor();
				}
				// when it is rangeQuery, insert Optional.empty as placeholder
				vt.emplace_back(Optional<Tuple>());
				isRangeQuery = true;
			} else {
				Tuple t;
				t.appendRaw(mappedKeyFormatTuple.subTupleRawString(i));
				vt.emplace_back(t);
			}
		} else {
			Tuple t;
			t.appendRaw(mappedKeyFormatTuple.subTupleRawString(i));
			vt.emplace_back(t);
		}
	}
}

Key constructMappedKey(KeyValueRef* keyValue, std::vector<Optional<Tuple>>& vec, Tuple& mappedKeyFormatTuple) {
	// Lazily parse key and/or value to tuple because they may not need to be a tuple if not used.
	Optional<Tuple> keyTuple;
	Optional<Tuple> valueTuple;
	Tuple mappedKeyTuple;

	mappedKeyTuple.reserve(vec.size());

	for (int i = 0; i < vec.size(); i++) {
		if (!vec[i].present()) {
			// rangeQuery
			continue;
		}
		if (vec[i].get().size()) {
			mappedKeyTuple.append(vec[i].get());
		} else {
			// singleKeyOrValue is true
			std::string s = mappedKeyFormatTuple.getString(i).toString();
			auto sz = s.size();
			int idx;
			Tuple* referenceTuple;
			try {
				idx = std::stoi(s.substr(3, sz - 5));
			} catch (std::exception& e) {
				throw mapper_bad_index();
			}
			if (s[1] == 'K') {
				unpackKeyTuple(&referenceTuple, keyTuple, keyValue);
			} else if (s[1] == 'V') {
				unpackValueTuple(&referenceTuple, valueTuple, keyValue);
			} else {
				ASSERT(false);
				throw internal_error();
			}
			if (idx < 0 || idx >= referenceTuple->size()) {
				throw mapper_bad_index();
			}
			mappedKeyTuple.appendRaw(referenceTuple->subTupleRawString(idx));
		}
	}

	return mappedKeyTuple.pack();
}

struct AuditGetShardInfoRes {
	Version readAtVersion;
	UID serverId;
	std::vector<KeyRange> ownRanges;
	AuditGetShardInfoRes() = default;
	AuditGetShardInfoRes(Version readAtVersion, UID serverId, std::vector<KeyRange> ownRanges)
	  : readAtVersion(readAtVersion), serverId(serverId), ownRanges(ownRanges) {}
};

// Given an input server, get ranges with in the input range
// from the perspective of SS->shardInfo
// Input: (1) SS ID; (2) within range
// Return AuditGetShardInfoRes including: (1) version of the read; (2) ranges of the SS
AuditGetShardInfoRes getThisServerShardInfo(StorageServer* data, KeyRange range) {
	std::vector<KeyRange> ownRange;
	for (auto& t : data->shards.intersectingRanges(range)) {
		KeyRange alignedRange = t.value()->range() & range;
		if (alignedRange.empty()) {
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways,
			           "SSAuditStorageReadShardInfoEmptyAlignedRange",
			           data->thisServerID)
			    .detail("Range", range);
			throw audit_storage_cancelled();
		}
		TraceEvent(SevVerbose, "SSAuditStorageGetThisServerShardInfo", data->thisServerID)
		    .detail("AlignedRange", alignedRange)
		    .detail("Range", t.value()->range())
		    .detail("AtVersion", data->version.get())
		    .detail("AuditServer", data->thisServerID)
		    .detail("ReadWrite", t.value()->isReadable() ? "True" : "False")
		    .detail("Adding", t.value()->isFetching() ? "True" : "False");
		if (t.value()->assigned()) {
			ownRange.push_back(alignedRange);
		}
	}
	return AuditGetShardInfoRes(data->version.get(), data->thisServerID, ownRange);
}

// Check consistency between StorageServer->shardInfo and ServerKeys system key space
															#line 13027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via auditStorageServerShardQ()
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class AuditStorageServerShardQActor>
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class AuditStorageServerShardQActorState {
															#line 13034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageServerShardQActorState(StorageServer* const& data,AuditStorageRequest const& req) 
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 13043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageServerShardQActorState() 
	{
		fdb_probe_actor_destroy("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(req.getType() == AuditType::ValidateStorageServerShard);
															#line 3819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->serveAuditStorageParallelismLock.take(TaskPriority::DefaultYield);
															#line 3819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 1;
															#line 3819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 0, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageServerShardQActorState();
		static_cast<AuditStorageServerShardQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->trackShardAssignmentMinVersion != invalidVersion)
															#line 13090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(audit_storage_cancelled());
															#line 3827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ExistStorageServerShardAuditExit") .detail("NewAuditId", req.id) .detail("NewAuditType", req.getType());
															#line 3831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<AuditStorageServerShardQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageServerShardQActorState(); static_cast<AuditStorageServerShardQActor*>(this)->destroy(); return 0; }
															#line 13098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<AuditStorageServerShardQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AuditStorageServerShardQActorState();
			static_cast<AuditStorageServerShardQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 3834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageSsShardBegin", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range);
															#line 3837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, data->thisServerID, req.getType());
															#line 3838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 3839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs = std::vector<Future<Void>>();
															#line 3840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr = Transaction(data->cx);
															#line 3841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyRes = AuditGetServerKeysRes();
															#line 3842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = Version();
															#line 3843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = KeyRange();
															#line 3844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerRes = AuditGetKeyServersRes();
															#line 3845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = Version();
															#line 3846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = KeyRange();
															#line 3847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesLocalViewRes = AuditGetShardInfoRes();
															#line 3848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localShardInfoReadAtVersion = Version();
															#line 3851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByKeyServerMap = std::unordered_map<UID, std::vector<KeyRange>>();
															#line 3852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByServerKey = std::vector<KeyRange>();
															#line 3853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByKeyServer = std::vector<KeyRange>();
															#line 3854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesLocalView = std::vector<KeyRange>();
															#line 3855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		failureReason = std::string();
															#line 3861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 3862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 3863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = KeyRangeRef();
															#line 3864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		retryCount = 0;
															#line 3865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedLocalShardsNum = 0;
															#line 3866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedServerKeysNum = 0;
															#line 3867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 3869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = 0;
															#line 3870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 3871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = 0;
															#line 3872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = 0;
															#line 3873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = 0;
															#line 13166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 3876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 13170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (data->trackShardAssignmentMinVersion != invalidVersion)
															#line 13185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(audit_storage_cancelled());
															#line 3827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ExistStorageServerShardAuditExit") .detail("NewAuditId", req.id) .detail("NewAuditType", req.getType());
															#line 3831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<AuditStorageServerShardQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageServerShardQActorState(); static_cast<AuditStorageServerShardQActor*>(this)->destroy(); return 0; }
															#line 13193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<AuditStorageServerShardQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AuditStorageServerShardQActorState();
			static_cast<AuditStorageServerShardQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 3834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageSsShardBegin", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range);
															#line 3837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, data->thisServerID, req.getType());
															#line 3838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 3839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs = std::vector<Future<Void>>();
															#line 3840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr = Transaction(data->cx);
															#line 3841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyRes = AuditGetServerKeysRes();
															#line 3842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = Version();
															#line 3843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = KeyRange();
															#line 3844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerRes = AuditGetKeyServersRes();
															#line 3845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = Version();
															#line 3846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = KeyRange();
															#line 3847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesLocalViewRes = AuditGetShardInfoRes();
															#line 3848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localShardInfoReadAtVersion = Version();
															#line 3851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByKeyServerMap = std::unordered_map<UID, std::vector<KeyRange>>();
															#line 3852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByServerKey = std::vector<KeyRange>();
															#line 3853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesSeenByKeyServer = std::vector<KeyRange>();
															#line 3854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		ownRangesLocalView = std::vector<KeyRange>();
															#line 3855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		failureReason = std::string();
															#line 3861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 3862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 3863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = KeyRangeRef();
															#line 3864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		retryCount = 0;
															#line 3865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedLocalShardsNum = 0;
															#line 3866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedServerKeysNum = 0;
															#line 3867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 3869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = 0;
															#line 3870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 3871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = 0;
															#line 3872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = 0;
															#line 3873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = 0;
															#line 13261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 3876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 13265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 4231 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->stopTrackShardAssignment();
															#line 4232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevVerbose, "SSShardAssignmentHistoryRecordStopWhenExit", data->thisServerID).detail("AuditID", req.id);
															#line 4234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<AuditStorageServerShardQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageServerShardQActorState(); static_cast<AuditStorageServerShardQActor*>(this)->destroy(); return 0; }
															#line 13359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<AuditStorageServerShardQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditStorageServerShardQActorState();
		static_cast<AuditStorageServerShardQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<AuditStorageServerShardQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageServerShardQActorState(); static_cast<AuditStorageServerShardQActor*>(this)->destroy(); return 0; }
															#line 13376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<AuditStorageServerShardQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditStorageServerShardQActorState();
				static_cast<AuditStorageServerShardQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 4208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageSsShardFailed", data->thisServerID) .errorUnsuppressed(e) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("Reason", failureReason) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime) .detail("TotalTime", now() - startTime);
															#line 4217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->stopTrackShardAssignment();
															#line 4218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevVerbose, "SSShardAssignmentHistoryRecordStopWhenError", data->thisServerID) .detail("AuditID", req.id);
															#line 4221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_audit_storage_cancelled)
															#line 13390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(audit_storage_cancelled());
															#line 13394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 4223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (e.code() == error_code_audit_storage_task_outdated)
															#line 13400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 4224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.sendError(audit_storage_task_outdated());
															#line 13404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 4226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.sendError(audit_storage_failed());
															#line 13410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 3878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (data->version.get() == 0)
															#line 13441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				failureReason = "SS version is 0";
															#line 3880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 13447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			errors.clear();
															#line 3886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesLocalView.clear();
															#line 3887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesSeenByServerKey.clear();
															#line 3888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesSeenByKeyServer.clear();
															#line 3889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesSeenByKeyServerMap.clear();
															#line 3890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, req.range.end);
															#line 3892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(!rangeToRead.empty());
															#line 3896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesLocalViewRes = getThisServerShardInfo(data, rangeToRead);
															#line 3897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			localShardInfoReadAtVersion = ownRangesLocalViewRes.readAtVersion;
															#line 3898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (localShardInfoReadAtVersion != data->version.get())
															#line 13469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 3899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardGRVMismatchError", data->thisServerID);
															#line 3902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 13475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 3906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->startTrackShardAssignment(localShardInfoReadAtVersion);
															#line 3907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevVerbose, "SSShardAssignmentHistoryRecordStart", data->thisServerID) .detail("AuditID", req.id);
															#line 3911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 3912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.clear();
															#line 3914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.push_back( store(serverKeyRes, getThisServerKeysFromServerKeys(data->thisServerID, &tr, rangeToRead)));
															#line 3916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.push_back(store(keyServerRes, getShardMapFromKeyServers(data->thisServerID, &tr, rangeToRead)));
															#line 3917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(fs);
															#line 3917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 2;
															#line 3917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 1, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 4199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = now();
															#line 4200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_9 = rateLimiter->getAllowance(remoteReadBytes);
															#line 4200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13532 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 10;
															#line 4200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 9, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1Catch1(e, std::max(0, loopDepth - 1));
															#line 13551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			data->stopTrackShardAssignment();
															#line 4196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr.onError(e);
															#line 4196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 9;
															#line 4196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 8, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 3919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = serverKeyRes.completeRange;
															#line 3920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = serverKeyRes.readAtVersion;
															#line 3922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = keyServerRes.completeRange;
															#line 3923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = keyServerRes.readAtVersion;
															#line 3925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = keyServerRes.readBytes + serverKeyRes.readBytes;
															#line 3927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 13589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 3919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = serverKeyRes.completeRange;
															#line 3920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = serverKeyRes.readAtVersion;
															#line 3922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = keyServerRes.completeRange;
															#line 3923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = keyServerRes.readAtVersion;
															#line 3925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = keyServerRes.readBytes + serverKeyRes.readBytes;
															#line 3927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		;
															#line 13608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 3953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (serverKeyReadAtVersion < localShardInfoReadAtVersion)
															#line 13692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardComparedVersionError", data->thisServerID);
															#line 3957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 13698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (keyServerReadAtVersion != serverKeyReadAtVersion)
															#line 13702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardKSVersionMismatchError", data->thisServerID);
															#line 3963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 13708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		try {
															#line 3966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_5 = timeoutError(data->version.whenAtLeast(serverKeyReadAtVersion), 30);
															#line 3966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont5Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 6;
															#line 3966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 5, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 3927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!(serverKeyReadAtVersion < localShardInfoReadAtVersion))
															#line 13742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (retryCount >= SERVER_KNOBS->AUDIT_RETRY_COUNT_MAX)
															#line 13748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			failureReason = "Read serverKeys retry count exceeds the max";
															#line 3930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_failed(), std::max(0, loopDepth - 1));
															#line 13754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = rateLimiter->getAllowance(remoteReadBytes);
															#line 3932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 3;
															#line 3932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 2, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		retryCount++;
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 4;
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 3, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		retryCount++;
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 4;
															#line 3934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 3, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13814 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 3935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.reset();
															#line 3936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 3937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.clear();
															#line 3939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back( store(serverKeyRes, getThisServerKeysFromServerKeys(data->thisServerID, &tr, rangeToRead)));
															#line 3941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back(store(keyServerRes, getShardMapFromKeyServers(data->thisServerID, &tr, rangeToRead)));
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(fs);
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 5;
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 4, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 3935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.reset();
															#line 3936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 3937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.clear();
															#line 3939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back( store(serverKeyRes, getThisServerKeysFromServerKeys(data->thisServerID, &tr, rangeToRead)));
															#line 3941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back(store(keyServerRes, getShardMapFromKeyServers(data->thisServerID, &tr, rangeToRead)));
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(fs);
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 5;
															#line 3942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 4, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 13945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 3944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = serverKeyRes.completeRange;
															#line 3945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = serverKeyRes.readAtVersion;
															#line 3947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = keyServerRes.completeRange;
															#line 3948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = keyServerRes.readAtVersion;
															#line 3950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = keyServerRes.readBytes + serverKeyRes.readBytes;
															#line 14037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 3944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyCompleteRange = serverKeyRes.completeRange;
															#line 3945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverKeyReadAtVersion = serverKeyRes.readAtVersion;
															#line 3947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerCompleteRange = keyServerRes.completeRange;
															#line 3948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		keyServerReadAtVersion = keyServerRes.readAtVersion;
															#line 3950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		remoteReadBytes = keyServerRes.readBytes + serverKeyRes.readBytes;
															#line 14054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 3978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->stopTrackShardAssignment();
															#line 3979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevVerbose, "ShardAssignmentHistoryRecordStop", data->thisServerID) .detail("AuditID", req.id);
															#line 3983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		std::vector<std::pair<Version, KeyRangeRef>> shardAssignments = data->getShardAssignmentHistory(localShardInfoReadAtVersion, serverKeyReadAtVersion);
															#line 3985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageSsShardGetHistory", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("ServerKeyAtVersion", serverKeyReadAtVersion) .detail("LocalShardInfoAtVersion", localShardInfoReadAtVersion) .detail("ShardAssignmentsCount", shardAssignments.size());
															#line 3993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!shardAssignments.empty())
															#line 14146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 3994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			failureReason = "Shard assignment history is not empty";
															#line 3995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 14152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 3998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		KeyRange claimRange = rangeToRead;
															#line 3999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = claimRange & serverKeyCompleteRange;
															#line 4000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (claimRange.empty())
															#line 14160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardOverlapRangeEmpty", data->thisServerID);
															#line 4004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 14166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = claimRange & keyServerCompleteRange;
															#line 4007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (claimRange.empty())
															#line 14172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardOverlapRangeEmpty", data->thisServerID);
															#line 4011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 14178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( auto& range : ownRangesLocalViewRes.ownRanges ) {
															#line 4016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			KeyRange overlappingRange = range & claimRange;
															#line 4017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (overlappingRange.empty())
															#line 14186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 4020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesLocalView.push_back(overlappingRange);
															#line 14192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( auto& range : serverKeyRes.ownRanges ) {
															#line 4024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			KeyRange overlappingRange = range & claimRange;
															#line 4025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (overlappingRange.empty())
															#line 14200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 4028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ownRangesSeenByServerKey.push_back(overlappingRange);
															#line 14206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (keyServerRes.rangeOwnershipMap.contains(data->thisServerID))
															#line 14210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::vector mergedRanges = coalesceRangeList(keyServerRes.rangeOwnershipMap[data->thisServerID]);
															#line 4033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for( auto& range : mergedRanges ) {
															#line 4034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				KeyRange overlappingRange = range & claimRange;
															#line 4035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (overlappingRange.empty())
															#line 14220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 4038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				ownRangesSeenByKeyServer.push_back(overlappingRange);
															#line 14226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
															#line 4041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageSsShardReadDone", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("ClaimRange", claimRange) .detail("ServerKeyAtVersion", serverKeyReadAtVersion) .detail("ShardInfoAtVersion", data->version.get());
															#line 4048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedLocalShardsNum = cumulatedValidatedLocalShardsNum + ownRangesLocalView.size();
															#line 4049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		cumulatedValidatedServerKeysNum = cumulatedValidatedServerKeysNum + ownRangesSeenByServerKey.size();
															#line 4050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageStatisticShardInfo", data->thisServerID) .suppressFor(30.0) .detail("AuditType", req.getType()) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("CurrentValidatedLocalShardsNum", ownRangesLocalView.size()) .detail("CurrentValidatedServerKeysNum", ownRangesSeenByServerKey.size()) .detail("CurrentValidatedInclusiveRange", claimRange) .detail("CumulatedValidatedLocalShardsNum", cumulatedValidatedLocalShardsNum) .detail("CumulatedValidatedServerKeysNum", cumulatedValidatedServerKeysNum) .detail("CumulatedValidatedInclusiveRange", KeyRangeRef(req.range.begin, claimRange.end));
															#line 4064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (ownRangesSeenByKeyServer.empty())
															#line 14239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!ownRangesSeenByServerKey.empty())
															#line 14243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				std::string error = format("ServerKeys shows %zu ranges that not appear on keyServers for Server(%s): ", ownRangesSeenByServerKey.size(), data->thisServerID.toString().c_str(), describe(ownRangesSeenByServerKey).c_str());
															#line 4071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevError, "SSAuditStorageSsShardError", data->thisServerID) .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("ClaimRange", claimRange) .detail("ErrorMessage", error) .detail("MismatchedRangeByLocalView", describe(ownRangesSeenByServerKey)) .detail("AuditServer", data->thisServerID);
															#line 14249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 4082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			Optional<std::pair<KeyRange, KeyRange>> anyMismatch = rangesSame(ownRangesSeenByServerKey, ownRangesSeenByKeyServer);
															#line 4084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (anyMismatch.present())
															#line 14258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				KeyRange mismatchedRangeByServerKey = anyMismatch.get().first;
															#line 4086 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				KeyRange mismatchedRangeByKeyServer = anyMismatch.get().second;
															#line 4087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				std::string error = format("KeyServers and serverKeys mismatch on Server(%s): ServerKey: %s; KeyServer: %s", data->thisServerID.toString().c_str(), mismatchedRangeByServerKey.toString().c_str(), mismatchedRangeByKeyServer.toString().c_str());
															#line 4092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevError, "SSAuditStorageSsShardError", data->thisServerID) .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("ClaimRange", claimRange) .detail("ErrorMessage", error) .detail("MismatchedRangeByKeyServer", mismatchedRangeByKeyServer) .detail("MismatchedRangeByServerKey", mismatchedRangeByServerKey) .detail("AuditServer", data->thisServerID);
															#line 4102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				errors.push_back(error);
															#line 14270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
		}
															#line 4107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		Optional<std::pair<KeyRange, KeyRange>> anyMismatch = rangesSame(ownRangesSeenByServerKey, ownRangesLocalView);
															#line 4109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (anyMismatch.present())
															#line 14277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			KeyRange mismatchedRangeByServerKey = anyMismatch.get().first;
															#line 4111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			KeyRange mismatchedRangeByLocalView = anyMismatch.get().second;
															#line 4112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::string error = format("Storage server shard info mismatch on Server(%s): ServerKey: %s; ServerShardInfo: %s", data->thisServerID.toString().c_str(), mismatchedRangeByServerKey.toString().c_str(), mismatchedRangeByLocalView.toString().c_str());
															#line 4117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevError, "SSAuditStorageSsShardError", data->thisServerID) .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("ClaimRange", claimRange) .detail("ErrorMessage", error) .detail("MismatchedRangeByLocalView", mismatchedRangeByLocalView) .detail("MismatchedRangeByServerKey", mismatchedRangeByServerKey) .detail("AuditServer", data->thisServerID);
															#line 4127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			errors.push_back(error);
															#line 14289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!errors.empty())
															#line 14293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevVerbose, "SSAuditStorageSsShardErrorEnd", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID);
															#line 4136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.range = claimRange;
															#line 4137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.setPhase(AuditPhase::Error);
															#line 4138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!req.ddId.isValid())
															#line 14303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardDDIdInvalid", data->thisServerID);
															#line 4142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 14309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.ddId = req.ddId;
															#line 4145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_6 = persistAuditStateByServer(data->cx, res);
															#line 4145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 7;
															#line 4145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 6, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 14322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 4150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.range = Standalone(KeyRangeRef(req.range.begin, claimRange.end));
															#line 4151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.setPhase(AuditPhase::Complete);
															#line 4152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!req.ddId.isValid())
															#line 14333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "SSAuditStorageSsShardDDIdInvalid", data->thisServerID);
															#line 4156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 14339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.ddId = req.ddId;
															#line 4159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_7 = persistAuditStateByServer(data->cx, res);
															#line 4159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont6when2(__when_expr_7.get(), loopDepth); };
			static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 8;
															#line 4159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< AuditStorageServerShardQActor, 7, Void >*>(static_cast<AuditStorageServerShardQActor*>(this)));
															#line 14352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "SSAuditStorageSsShardWaitSSVersionTooLong", data->thisServerID) .detail("ServerKeyReadAtVersion", serverKeyReadAtVersion) .detail("SSVersion", data->version.get());
															#line 3971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			failureReason = "SS version takes long time to catch up with serverKeyReadAtVersion";
															#line 3972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 14367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont27(Void const& _,int loopDepth) 
	{
															#line 4146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.sendError(audit_storage_error());
															#line 14487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont27(Void && _,int loopDepth) 
	{
															#line 4146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.sendError(audit_storage_error());
															#line 14496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont29(Void const& _,int loopDepth) 
	{
															#line 4160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (res.range.end < req.range.end)
															#line 14580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageSsShardPartialDone", data->thisServerID) .suppressFor(10.0) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("CompleteRange", res.range) .detail("ClaimRange", claimRange) .detail("RangeToReadEnd", req.range.end) .detail("LastRateLimiterWaitTime", lastRateLimiterWaitTime) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime);
															#line 4171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			rangeToReadBegin = res.range.end;
															#line 14586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 4173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.send(res);
															#line 4174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageSsShardComplete", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("ClaimRange", claimRange) .detail("CompleteRange", res.range) .detail("NumValidatedLocalShards", cumulatedValidatedLocalShardsNum) .detail("NumValidatedServerKeys", cumulatedValidatedServerKeysNum) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime) .detail("TotalTime", now() - startTime);
															#line 14594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont29(Void && _,int loopDepth) 
	{
															#line 4160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (res.range.end < req.range.end)
															#line 14605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageSsShardPartialDone", data->thisServerID) .suppressFor(10.0) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("CompleteRange", res.range) .detail("ClaimRange", claimRange) .detail("RangeToReadEnd", req.range.end) .detail("LastRateLimiterWaitTime", lastRateLimiterWaitTime) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime);
															#line 4171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			rangeToReadBegin = res.range.end;
															#line 14611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 4173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.send(res);
															#line 4174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageSsShardComplete", data->thisServerID) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("ClaimRange", claimRange) .detail("CompleteRange", res.range) .detail("NumValidatedLocalShards", cumulatedValidatedLocalShardsNum) .detail("NumValidatedServerKeys", cumulatedValidatedServerKeysNum) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime) .detail("TotalTime", now() - startTime);
															#line 14619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont29(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont29(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont6when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont6when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont31(Void const& _,int loopDepth) 
	{
															#line 4201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 4202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = rateLimiterTotalWaitTime + lastRateLimiterWaitTime;
															#line 14807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont31(Void && _,int loopDepth) 
	{
															#line 4201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 4202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = rateLimiterTotalWaitTime + lastRateLimiterWaitTime;
															#line 14818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont31(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont31(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageServerShardQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageServerShardQActor*>(this)->ActorCallback< AuditStorageServerShardQActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< AuditStorageServerShardQActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< AuditStorageServerShardQActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageRequest req;
															#line 3833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FlowLock::Releaser holder;
															#line 3837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageState res;
															#line 3838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<std::string> errors;
															#line 3839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 3840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Transaction tr;
															#line 3841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditGetServerKeysRes serverKeyRes;
															#line 3842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version serverKeyReadAtVersion;
															#line 3843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange serverKeyCompleteRange;
															#line 3844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditGetKeyServersRes keyServerRes;
															#line 3845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version keyServerReadAtVersion;
															#line 3846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange keyServerCompleteRange;
															#line 3847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditGetShardInfoRes ownRangesLocalViewRes;
															#line 3848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version localShardInfoReadAtVersion;
															#line 3851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::unordered_map<UID, std::vector<KeyRange>> ownRangesSeenByKeyServerMap;
															#line 3852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<KeyRange> ownRangesSeenByServerKey;
															#line 3853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<KeyRange> ownRangesSeenByKeyServer;
															#line 3854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<KeyRange> ownRangesLocalView;
															#line 3855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::string failureReason;
															#line 3861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange claimRange;
															#line 3862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key rangeToReadBegin;
															#line 3863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRangeRef rangeToRead;
															#line 3864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int retryCount;
															#line 3865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t cumulatedValidatedLocalShardsNum;
															#line 3866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t cumulatedValidatedServerKeysNum;
															#line 3867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 3869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t remoteReadBytes;
															#line 3870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double startTime;
															#line 3871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double lastRateLimiterWaitTime;
															#line 3872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double rateLimiterBeforeWaitTime;
															#line 3873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double rateLimiterTotalWaitTime;
															#line 14975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via auditStorageServerShardQ()
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class AuditStorageServerShardQActor final : public Actor<Void>, public ActorCallback< AuditStorageServerShardQActor, 0, Void >, public ActorCallback< AuditStorageServerShardQActor, 1, Void >, public ActorCallback< AuditStorageServerShardQActor, 2, Void >, public ActorCallback< AuditStorageServerShardQActor, 3, Void >, public ActorCallback< AuditStorageServerShardQActor, 4, Void >, public ActorCallback< AuditStorageServerShardQActor, 5, Void >, public ActorCallback< AuditStorageServerShardQActor, 6, Void >, public ActorCallback< AuditStorageServerShardQActor, 7, Void >, public ActorCallback< AuditStorageServerShardQActor, 8, Void >, public ActorCallback< AuditStorageServerShardQActor, 9, Void >, public FastAllocated<AuditStorageServerShardQActor>, public AuditStorageServerShardQActorState<AuditStorageServerShardQActor> {
															#line 14980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<AuditStorageServerShardQActor>::operator new;
	using FastAllocated<AuditStorageServerShardQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15471537224565701632UL, 2350016856778318080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageServerShardQActor, 0, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 1, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 2, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 3, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 4, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 5, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 6, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 7, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 8, Void >;
friend struct ActorCallback< AuditStorageServerShardQActor, 9, Void >;
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageServerShardQActor(StorageServer* const& data,AuditStorageRequest const& req) 
															#line 15006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AuditStorageServerShardQActorState<AuditStorageServerShardQActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10868456401308189184UL, 5217512031670601728UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageServerShardQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageServerShardQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageServerShardQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< AuditStorageServerShardQActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> auditStorageServerShardQ( StorageServer* const& data, AuditStorageRequest const& req ) {
															#line 3817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new AuditStorageServerShardQActor(data, req));
															#line 15048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 4236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

/*
 * RESTORE VALIDATION FEATURE - How to Use
 *
 * This feature validates that restored backup data matches the original source data
 * by comparing them within the same cluster.
 *
 * === WORKFLOW ===
 *
 * Step 1: Backup
 *   $ fdbbackup start -C <cluster> -d <backup_url> -z
 *   $ fdbbackup discontinue -C <cluster>
 *   $ fdbbackup wait -C <cluster>
 *
 * Step 2: Restore to Validation Prefix
 *   Production:
 *   $ fdbbackup restore -C <cluster> -r <backup_url> \
 *       --add-prefix "\xff\x02/rlog/" --wait-for-done
 *
 *   Simulation Tests (use in TOML configs):
 *     addPrefix = 'restored/'
 *
 * Step 3: Validate
 *   $ fdbcli -C <cluster>
 *   fdb> audit_storage validate_restore "" "\xff"
 *   # Returns Audit ID
 *   fdb> get_audit_status validate_restore id <AuditID>
 *
 * Step 4: Cleanup
 *   fdb> option on ACCESS_SYSTEM_KEYS
 *   fdb> writemode on
 *   fdb> clearrange "\xff\x02/rlog/" "\xff\x02/rlog0"
 *   # Or for simulation: clearrange "restored/" "restored0"
 *
 * Note: When restoring with a prefix (addPrefix parameter), the restore automatically
 * allows overwriting existing data, making it suitable for validation purposes.
 *
 */

// Helper: Issue a GetKeyValues request for a given range and return the future
static Future<ErrorOr<GetKeyValuesReply>> issueGetKeyValuesRequest(StorageServer* data,
                                                                   KeyRange range,
                                                                   Version version,
                                                                   int limit,
                                                                   int limitBytes) {
	GetKeyValuesRequest req;
	req.begin = firstGreaterOrEqual(range.begin);
	req.end = firstGreaterOrEqual(range.end);
	req.limit = limit;
	req.limitBytes = limitBytes;
	req.version = version;
	req.tags = TagSet();
	data->actors.add(getKeyValuesQ(data, req));
	return errorOr(req.reply.getFuture());
}

// Helper: Read both source and restored data for a given range
//
// Restored data is stored at validateRestoreLogKeys (\xff\x02/rlog/) in system key space.
// NOTE: We read the ENTIRE restored keyspace (not just rangeToRead with prefix),
// because restored keys are stored with their original names under the prefix.
// E.g., source key "mykey" is restored as "\xff\x02/rlog/mykey"
															#line 15114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchSourceAndRestoredData()
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class FetchSourceAndRestoredDataActor>
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchSourceAndRestoredDataActorState {
															#line 15121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchSourceAndRestoredDataActorState(StorageServer* const& data,KeyRange const& rangeToRead,Version const& version,int const& limit,int const& limitBytes) 
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   rangeToRead(rangeToRead),
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   version(version),
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   limit(limit),
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   limitBytes(limitBytes),
															#line 4305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   restoredBegin(rangeToRead.begin.withPrefix(validateRestoreLogKeys.begin)),
															#line 4306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   restoredEnd(rangeToRead.end.withPrefix(validateRestoreLogKeys.begin)),
															#line 4307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   restoredRange(KeyRangeRef(restoredBegin, restoredEnd))
															#line 15142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this));

	}
	~FetchSourceAndRestoredDataActorState() 
	{
		fdb_probe_actor_destroy("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent("SSAuditRestoreFetch", data->thisServerID) .detail("RangeToRead", rangeToRead) .detail("RestoredRange", restoredRange) .detail("Version", version) .detail("Limit", limit) .detail("LimitBytes", limitBytes);
															#line 4317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			sourceFuture = issueGetKeyValuesRequest(data, rangeToRead, version, limit, limitBytes);
															#line 4324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			restoredResult = ErrorOr<GetKeyValuesReply>();
															#line 15161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			try {
															#line 4326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				tr = Transaction(data->cx);
															#line 4327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				tr.setVersion(version);
															#line 4328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				GetRangeLimits limits(limit, limitBytes);
															#line 4331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(restoredRange, limits, Snapshot::False, Reverse::False);
															#line 4331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state = 1;
															#line 4331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >*>(static_cast<FetchSourceAndRestoredDataActor*>(this)));
															#line 15182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchSourceAndRestoredDataActorState();
		static_cast<FetchSourceAndRestoredDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 4343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredFuture = Future<ErrorOr<GetKeyValuesReply>>(restoredResult);
															#line 4345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(sourceFuture) && success(restoredFuture);
															#line 4345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state = 2;
															#line 4345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >*>(static_cast<FetchSourceAndRestoredDataActor*>(this)));
															#line 15220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			restoredResult = e;
															#line 15230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 4334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetKeyValuesReply restoredReply;
															#line 4335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredReply.data.append_deep(restoredReply.arena, restoredData.begin(), restoredData.size());
															#line 4336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredReply.more = restoredData.more;
															#line 4337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredReply.version = version;
															#line 4338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredResult = restoredReply;
															#line 15253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __restoredData,int loopDepth) 
	{
															#line 4331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredData = __restoredData;
															#line 15262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __restoredData,int loopDepth) 
	{
		restoredData = std::move(__restoredData);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state > 0) static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state = 0;
		static_cast<FetchSourceAndRestoredDataActor*>(this)->ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 4348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (sourceFuture.get().isError())
															#line 15354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(sourceFuture.get().getError(), loopDepth);
															#line 15358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (restoredFuture.get().isError())
															#line 15362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(restoredFuture.get().getError(), loopDepth);
															#line 15366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (sourceFuture.get().get().error.present())
															#line 15370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(sourceFuture.get().get().error.get(), loopDepth);
															#line 15374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (restoredFuture.get().get().error.present())
															#line 15378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(restoredFuture.get().get().error.get(), loopDepth);
															#line 15382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent("SSAuditRestoreFetchResult", data->thisServerID) .detail("SourceKeys", sourceFuture.get().get().data.size()) .detail("RestoredKeys", restoredFuture.get().get().data.size()) .detail("SourceBytes", sourceFuture.get().get().data.expectedSize()) .detail("RestoredBytes", restoredFuture.get().get().data.expectedSize()) .detail("SourceMore", sourceFuture.get().get().more) .detail("RestoredMore", restoredFuture.get().get().more);
															#line 4370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<FetchSourceAndRestoredDataActor*>(this)->SAV<std::pair<GetKeyValuesReply, GetKeyValuesReply>>::futures) { (void)(std::make_pair(sourceFuture.get().get(), restoredFuture.get().get())); this->~FetchSourceAndRestoredDataActorState(); static_cast<FetchSourceAndRestoredDataActor*>(this)->destroy(); return 0; }
															#line 15388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<FetchSourceAndRestoredDataActor*>(this)->SAV< std::pair<GetKeyValuesReply, GetKeyValuesReply> >::value()) std::pair<GetKeyValuesReply, GetKeyValuesReply>(std::make_pair(sourceFuture.get().get(), restoredFuture.get().get()));
		this->~FetchSourceAndRestoredDataActorState();
		static_cast<FetchSourceAndRestoredDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 4348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (sourceFuture.get().isError())
															#line 15400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(sourceFuture.get().getError(), loopDepth);
															#line 15404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (restoredFuture.get().isError())
															#line 15408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(restoredFuture.get().getError(), loopDepth);
															#line 15412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (sourceFuture.get().get().error.present())
															#line 15416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(sourceFuture.get().get().error.get(), loopDepth);
															#line 15420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (restoredFuture.get().get().error.present())
															#line 15424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1Catch1(restoredFuture.get().get().error.get(), loopDepth);
															#line 15428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent("SSAuditRestoreFetchResult", data->thisServerID) .detail("SourceKeys", sourceFuture.get().get().data.size()) .detail("RestoredKeys", restoredFuture.get().get().data.size()) .detail("SourceBytes", sourceFuture.get().get().data.expectedSize()) .detail("RestoredBytes", restoredFuture.get().get().data.expectedSize()) .detail("SourceMore", sourceFuture.get().get().more) .detail("RestoredMore", restoredFuture.get().get().more);
															#line 4370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<FetchSourceAndRestoredDataActor*>(this)->SAV<std::pair<GetKeyValuesReply, GetKeyValuesReply>>::futures) { (void)(std::make_pair(sourceFuture.get().get(), restoredFuture.get().get())); this->~FetchSourceAndRestoredDataActorState(); static_cast<FetchSourceAndRestoredDataActor*>(this)->destroy(); return 0; }
															#line 15434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<FetchSourceAndRestoredDataActor*>(this)->SAV< std::pair<GetKeyValuesReply, GetKeyValuesReply> >::value()) std::pair<GetKeyValuesReply, GetKeyValuesReply>(std::make_pair(sourceFuture.get().get(), restoredFuture.get().get()));
		this->~FetchSourceAndRestoredDataActorState();
		static_cast<FetchSourceAndRestoredDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state > 0) static_cast<FetchSourceAndRestoredDataActor*>(this)->actor_wait_state = 0;
		static_cast<FetchSourceAndRestoredDataActor*>(this)->ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange rangeToRead;
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int limit;
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int limitBytes;
															#line 4305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key restoredBegin;
															#line 4306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key restoredEnd;
															#line 4307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange restoredRange;
															#line 4317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<ErrorOr<GetKeyValuesReply>> sourceFuture;
															#line 4324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	ErrorOr<GetKeyValuesReply> restoredResult;
															#line 4326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Transaction tr;
															#line 4331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	RangeResult restoredData;
															#line 4343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Future<ErrorOr<GetKeyValuesReply>> restoredFuture;
															#line 15543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchSourceAndRestoredData()
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class FetchSourceAndRestoredDataActor final : public Actor<std::pair<GetKeyValuesReply, GetKeyValuesReply>>, public ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >, public ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >, public FastAllocated<FetchSourceAndRestoredDataActor>, public FetchSourceAndRestoredDataActorState<FetchSourceAndRestoredDataActor> {
															#line 15548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchSourceAndRestoredDataActor>::operator new;
	using FastAllocated<FetchSourceAndRestoredDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9802060701746370048UL, 6324987845592361216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<GetKeyValuesReply, GetKeyValuesReply>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >;
friend struct ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >;
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FetchSourceAndRestoredDataActor(StorageServer* const& data,KeyRange const& rangeToRead,Version const& version,int const& limit,int const& limitBytes) 
															#line 15566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<std::pair<GetKeyValuesReply, GetKeyValuesReply>>(),
		   FetchSourceAndRestoredDataActorState<FetchSourceAndRestoredDataActor>(data, rangeToRead, version, limit, limitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1917709992795012096UL, 8272175843171259392UL);
		ActorExecutionContextHelper __helper(static_cast<FetchSourceAndRestoredDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchSourceAndRestoredData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchSourceAndRestoredData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchSourceAndRestoredDataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchSourceAndRestoredDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] static Future<std::pair<GetKeyValuesReply, GetKeyValuesReply>> fetchSourceAndRestoredData( StorageServer* const& data, KeyRange const& rangeToRead, Version const& version, int const& limit, int const& limitBytes ) {
															#line 4298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<std::pair<GetKeyValuesReply, GetKeyValuesReply>>(new FetchSourceAndRestoredDataActor(data, rangeToRead, version, limit, limitBytes));
															#line 15600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 4372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

// Helper: Compare source and restored data, returning validation errors
std::vector<std::string> compareSourceAndRestoredData(UID thisServerID,
                                                      UID auditID,
                                                      KeyRange auditRange,
                                                      const GetKeyValuesReply& sourceReply,
                                                      const GetKeyValuesReply& restoredReply,
                                                      KeyRange rangeToRead,
                                                      Version version,
                                                      KeyRange claimRange,
                                                      Key& lastKey,
                                                      int64_t& numValidatedKeys) {
	std::vector<std::string> errors;
	int sourceIdx = 0;
	int restoredIdx = 0;

	TraceEvent("SSAuditRestoreCompare", thisServerID)
	    .detail("AuditID", auditID)
	    .detail("SourceKeys", sourceReply.data.size())
	    .detail("RestoredKeys", restoredReply.data.size())
	    .detail("RangeToRead", rangeToRead)
	    .detail("Version", version);

	// Log first few keys from both sets for debugging
	if (sourceReply.data.size() > 0) {
		TraceEvent("SSAuditRestoreCompareSourceKeys", thisServerID)
		    .detail("FirstSourceKey", sourceReply.data[0].key)
		    .detail("LastSourceKey", sourceReply.data[sourceReply.data.size() - 1].key);
	}
	if (restoredReply.data.size() > 0) {
		TraceEvent("SSAuditRestoreCompareRestoredKeys", thisServerID)
		    .detail("FirstRestoredKey", restoredReply.data[0].key)
		    .detail("LastRestoredKey", restoredReply.data[restoredReply.data.size() - 1].key);
	}

	TraceEvent("SSAuditRestoreCompareStart", thisServerID)
	    .detail("SourceSize", sourceReply.data.size())
	    .detail("RestoredSize", restoredReply.data.size())
	    .detail("SourceMore", sourceReply.more)
	    .detail("RestoredMore", restoredReply.more);

	while (sourceIdx < sourceReply.data.size() && restoredIdx < restoredReply.data.size()) {
		KeyValueRef sourceKV = sourceReply.data[sourceIdx];
		KeyValueRef restoredKV = restoredReply.data[restoredIdx];

		// Remove the restore prefix from restored key to compare
		Key restoredKeyWithoutPrefix = restoredKV.key.removePrefix(validateRestoreLogKeys.begin);

		if (sourceKV.key == restoredKeyWithoutPrefix) {
			// Keys match, compare values
			if (sourceKV.value != restoredKV.value) {
				std::string error = format("Value Mismatch for Key %s: source value: %s, restored value: %s",
				                           Traceable<StringRef>::toString(sourceKV.key).c_str(),
				                           Traceable<StringRef>::toString(sourceKV.value).c_str(),
				                           Traceable<StringRef>::toString(restoredKV.value).c_str());
				TraceEvent(SevError, "SSAuditRestoreError", thisServerID)
				    .setMaxFieldLength(-1)
				    .setMaxEventLength(-1)
				    .detail("AuditId", auditID)
				    .detail("AuditRange", auditRange)
				    .detail("ErrorMessage", error)
				    .detail("Version", version)
				    .detail("ClaimRange", claimRange);
				errors.push_back(error);
				break;
			}
			lastKey = sourceKV.key;
			++numValidatedKeys;
			++sourceIdx;
			++restoredIdx;
		} else if (sourceKV.key < restoredKeyWithoutPrefix) {
			// Source key missing from restored data
			std::string error =
			    format("Missing key in restored data: %s", Traceable<StringRef>::toString(sourceKV.key).c_str());
			TraceEvent(SevError, "SSAuditRestoreError", thisServerID)
			    .setMaxFieldLength(-1)
			    .setMaxEventLength(-1)
			    .detail("AuditId", auditID)
			    .detail("AuditRange", auditRange)
			    .detail("ErrorMessage", error)
			    .detail("Version", version)
			    .detail("ClaimRange", claimRange);
			errors.push_back(error);
			break;
		} else {
			// Extra key in restored data (treat as validation error)
			std::string error =
			    format("Extra key in restored data: %s", Traceable<StringRef>::toString(restoredKV.key).c_str());
			TraceEvent(SevError, "SSAuditRestoreError", thisServerID)
			    .setMaxFieldLength(-1)
			    .setMaxEventLength(-1)
			    .detail("AuditId", auditID)
			    .detail("AuditRange", auditRange)
			    .detail("ErrorMessage", error)
			    .detail("ExtraRestoredKey", restoredKV.key)
			    .detail("NextSourceKey", sourceKV.key)
			    .detail("Version", version)
			    .detail("ClaimRange", claimRange);
			errors.push_back(error);
			break;
		}
	}

	// Check for any remaining source keys that are missing from restored data
	// Only report as error if BOTH source and restored have no more data coming.
	// We require !sourceReply.more because if there's more source data to fetch,
	// we can't definitively say keys are missing until we've seen all source data.
	if (errors.empty() && sourceIdx < sourceReply.data.size() && !sourceReply.more && !restoredReply.more) {
		std::string error = format("Missing key(s) in restored data, next source key: %s",
		                           Traceable<StringRef>::toString(sourceReply.data[sourceIdx].key).c_str());
		TraceEvent(SevError, "SSAuditRestoreError", thisServerID)
		    .setMaxFieldLength(-1)
		    .setMaxEventLength(-1)
		    .detail("AuditId", auditID)
		    .detail("AuditRange", auditRange)
		    .detail("ErrorMessage", error)
		    .detail("Version", version)
		    .detail("ClaimRange", claimRange);
		errors.push_back(error);
	}

	// Check for any remaining restored keys that don't have matching source keys
	if (errors.empty() && restoredIdx < restoredReply.data.size() && !restoredReply.more) {
		// Extra keys found in restored data - treat as validation error
		std::string error = format("Extra key(s) in restored data, first extra key: %s",
		                           Traceable<StringRef>::toString(restoredReply.data[restoredIdx].key).c_str());
		TraceEvent(SevError, "SSAuditRestoreError", thisServerID)
		    .setMaxFieldLength(-1)
		    .setMaxEventLength(-1)
		    .detail("AuditId", auditID)
		    .detail("AuditRange", auditRange)
		    .detail("ErrorMessage", error)
		    .detail("ExtraKeyCount", restoredReply.data.size() - restoredIdx)
		    .detail("FirstExtraKey", restoredReply.data[restoredIdx].key)
		    .detail("Version", version)
		    .detail("ClaimRange", claimRange);
		errors.push_back(error);
	}

	TraceEvent("SSAuditRestoreCompareEnd", thisServerID)
	    .detail("SourceIdx", sourceIdx)
	    .detail("RestoredIdx", restoredIdx)
	    .detail("SourceSize", sourceReply.data.size())
	    .detail("RestoredSize", restoredReply.data.size())
	    .detail("LastKey", printable(lastKey))
	    .detail("ErrorCount", errors.size());

	return errors;
}

															#line 15754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via auditRestoreQ()
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class AuditRestoreQActor>
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class AuditRestoreQActorState {
															#line 15761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditRestoreQActorState(StorageServer* const& data,AuditStorageRequest const& req) 
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 15770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("auditRestoreQ", reinterpret_cast<unsigned long>(this));

	}
	~AuditRestoreQActorState() 
	{
		fdb_probe_actor_destroy("auditRestoreQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(req.getType() == AuditType::ValidateRestore);
															#line 4524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->serveAuditStorageParallelismLock.take(TaskPriority::DefaultYield);
															#line 4524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 1;
															#line 4524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 0, Void >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 15794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditRestoreQActorState();
		static_cast<AuditRestoreQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 4525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 4527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditRestoreBegin", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type);
															#line 4533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!normalKeys.contains(req.range))
															#line 15821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevError, "SSAuditRestoreInvalidRange", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("Error", "Range must be within normalKeys");
															#line 4538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 4539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<AuditRestoreQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditRestoreQActorState(); static_cast<AuditRestoreQActor*>(this)->destroy(); return 0; }
															#line 15829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<AuditRestoreQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AuditRestoreQActorState();
			static_cast<AuditRestoreQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 4542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, req.getType());
															#line 4543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 4544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = Version();
															#line 4545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = req.range;
															#line 4546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 4547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 4548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit = 1e4;
															#line 4549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 4550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBytes = 0;
															#line 4551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		numValidatedKeys = 0;
															#line 4552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		validatedBytes = 0;
															#line 4553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		complete = false;
															#line 4554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 4555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 15863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 4559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 15867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 4525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 4527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditRestoreBegin", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type);
															#line 4533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!normalKeys.contains(req.range))
															#line 15886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevError, "SSAuditRestoreInvalidRange", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("Error", "Range must be within normalKeys");
															#line 4538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 4539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!static_cast<AuditRestoreQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditRestoreQActorState(); static_cast<AuditRestoreQActor*>(this)->destroy(); return 0; }
															#line 15894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			new (&static_cast<AuditRestoreQActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AuditRestoreQActorState();
			static_cast<AuditRestoreQActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 4542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, req.getType());
															#line 4543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 4544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = Version();
															#line 4545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = req.range;
															#line 4546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 4547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 4548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit = 1e4;
															#line 4549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 4550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBytes = 0;
															#line 4551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		numValidatedKeys = 0;
															#line 4552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		validatedBytes = 0;
															#line 4553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		complete = false;
															#line 4554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 4555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 15928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 4559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 15932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 4690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		req.reply.send(res);
															#line 4691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<AuditRestoreQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditRestoreQActorState(); static_cast<AuditRestoreQActor*>(this)->destroy(); return 0; }
															#line 16024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<AuditRestoreQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditRestoreQActorState();
		static_cast<AuditRestoreQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_wrong_shard_server)
															#line 16045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(e);
															#line 4676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<AuditRestoreQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditRestoreQActorState(); static_cast<AuditRestoreQActor*>(this)->destroy(); return 0; }
															#line 16051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<AuditRestoreQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditRestoreQActorState();
				static_cast<AuditRestoreQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 4678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.setPhase(AuditPhase::Error);
															#line 4679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.error = e.what();
															#line 4680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.range = req.range;
															#line 4681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "SSAuditRestoreError", data->thisServerID) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditRange", req.range);
															#line 4685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.ddId = req.ddId;
															#line 4686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.auditServerId = data->thisServerID;
															#line 4687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_5 = persistAuditStateByRange(data->cx, res);
															#line 4687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 6;
															#line 4687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 5, Void >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 16078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 4640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!errors.empty())
															#line 16093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.setPhase(AuditPhase::Error);
															#line 4642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.error = errors[0];
															#line 4643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.range = req.range;
															#line 4644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevWarn, "SSAuditRestoreComplete", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("Complete", complete) .detail("ValidationErrors", errors.size()) .detail("NumValidatedKeys", numValidatedKeys) .detail("ValidatedBytes", validatedBytes) .detail("Duration", now() - startTime);
															#line 16103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 4653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.setPhase(AuditPhase::Complete);
															#line 4654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			res.range = req.range;
															#line 4655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditRestoreComplete", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("Complete", complete) .detail("NumValidatedKeys", numValidatedKeys) .detail("ValidatedBytes", validatedBytes) .detail("Duration", now() - startTime);
															#line 16113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res.ddId = req.ddId;
															#line 4666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res.auditServerId = data->thisServerID;
															#line 4667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_4 = persistAuditStateByRange(data->cx, res);
															#line 4667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 16123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 5;
															#line 4667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 4, Void >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 16128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 4561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readBytes = 0;
															#line 4562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, req.range.end);
															#line 4563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(!rangeToRead.empty());
															#line 4565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevDebug, "SSAuditRestoreNewRoundBegin", data->thisServerID) .suppressFor(10.0) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("ReadRangeBegin", rangeToReadBegin) .detail("ReadRangeEnd", req.range.end);
															#line 4572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			errors.clear();
															#line 4575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			version = data->version.get();
															#line 4578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<std::pair<GetKeyValuesReply, GetKeyValuesReply>> __when_expr_1 = fetchSourceAndRestoredData(data, rangeToRead, version, limit, limitBytes);
															#line 4578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 2;
															#line 4578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 16164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1Catch1(e, std::max(0, loopDepth - 1));
															#line 16203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			return a_body1cont1Catch1(e, std::max(0, loopDepth - 1));
															#line 16207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 4580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		sourceReply = replyPair.first;
															#line 4581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		restoredReply = replyPair.second;
															#line 4583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBytes = sourceReply.data.expectedSize() + restoredReply.data.expectedSize();
															#line 4584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		validatedBytes += readBytes;
															#line 4587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!sourceReply.more)
															#line 16229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			complete = true;
															#line 16233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = rangeToRead;
															#line 4593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastKey = rangeToRead.begin;
															#line 4594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = compareSourceAndRestoredData(data->thisServerID, req.id, req.range, sourceReply, restoredReply, rangeToRead, version, claimRange, lastKey, numValidatedKeys);
															#line 4606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		KeyRange completeRange = Standalone(KeyRangeRef(rangeToRead.begin, keyAfter(lastKey)));
															#line 4607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!complete && !completeRange.empty() && claimRange.begin == completeRange.begin)
															#line 16245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			claimRange = claimRange & completeRange;
															#line 4609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			AuditStorageState progressState(req.id, claimRange, req.getType());
															#line 4610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			progressState.setPhase(AuditPhase::Running);
															#line 4611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			progressState.ddId = req.ddId;
															#line 4612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			progressState.auditServerId = data->thisServerID;
															#line 4613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_2 = persistAuditStateByRange(data->cx, progressState);
															#line 4613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 3;
															#line 4613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 2, Void >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 16266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::pair<GetKeyValuesReply, GetKeyValuesReply> const& __replyPair,int loopDepth) 
	{
															#line 4578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		replyPair = __replyPair;
															#line 16280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::pair<GetKeyValuesReply, GetKeyValuesReply> && __replyPair,int loopDepth) 
	{
		replyPair = std::move(__replyPair);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >*,std::pair<GetKeyValuesReply, GetKeyValuesReply> const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >*,std::pair<GetKeyValuesReply, GetKeyValuesReply> && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 4617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(readBytes);
															#line 4617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 4;
															#line 4617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditRestoreQActor, 3, Void >*>(static_cast<AuditRestoreQActor*>(this)));
															#line 16366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 4620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!errors.empty() || complete)
															#line 16462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 4625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = keyAfter(lastKey);
															#line 4626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (rangeToReadBegin >= req.range.end)
															#line 16470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			complete = true;
															#line 16474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 4620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!errors.empty() || complete)
															#line 16485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 4625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = keyAfter(lastKey);
															#line 4626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (rangeToReadBegin >= req.range.end)
															#line 16493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		{
															#line 4627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			complete = true;
															#line 16497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AuditRestoreQActor*>(this)->actor_wait_state > 0) static_cast<AuditRestoreQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditRestoreQActor*>(this)->ActorCallback< AuditRestoreQActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AuditRestoreQActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AuditRestoreQActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	StorageServer* data;
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageRequest req;
															#line 4525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	FlowLock::Releaser holder;
															#line 4542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageState res;
															#line 4543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::vector<std::string> errors;
															#line 4544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Version version;
															#line 4545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange rangeToRead;
															#line 4546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key rangeToReadBegin;
															#line 4547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	KeyRange claimRange;
															#line 4548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int limit;
															#line 4549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int limitBytes;
															#line 4550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t readBytes;
															#line 4551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t numValidatedKeys;
															#line 4552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	int64_t validatedBytes;
															#line 4553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	bool complete;
															#line 4554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	double startTime;
															#line 4555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 4578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	std::pair<GetKeyValuesReply, GetKeyValuesReply> replyPair;
															#line 4580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesReply sourceReply;
															#line 4581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	GetKeyValuesReply restoredReply;
															#line 4593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	Key lastKey;
															#line 16821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via auditRestoreQ()
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class AuditRestoreQActor final : public Actor<Void>, public ActorCallback< AuditRestoreQActor, 0, Void >, public ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >, public ActorCallback< AuditRestoreQActor, 2, Void >, public ActorCallback< AuditRestoreQActor, 3, Void >, public ActorCallback< AuditRestoreQActor, 4, Void >, public ActorCallback< AuditRestoreQActor, 5, Void >, public FastAllocated<AuditRestoreQActor>, public AuditRestoreQActorState<AuditRestoreQActor> {
															#line 16826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<AuditRestoreQActor>::operator new;
	using FastAllocated<AuditRestoreQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5888860083155880192UL, 11419417757898626304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditRestoreQActor, 0, Void >;
friend struct ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >;
friend struct ActorCallback< AuditRestoreQActor, 2, Void >;
friend struct ActorCallback< AuditRestoreQActor, 3, Void >;
friend struct ActorCallback< AuditRestoreQActor, 4, Void >;
friend struct ActorCallback< AuditRestoreQActor, 5, Void >;
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditRestoreQActor(StorageServer* const& data,AuditStorageRequest const& req) 
															#line 16848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AuditRestoreQActorState<AuditRestoreQActor>(data, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditRestoreQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17518328432970717952UL, 17091446426578852096UL);
		ActorExecutionContextHelper __helper(static_cast<AuditRestoreQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditRestoreQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditRestoreQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditRestoreQActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditRestoreQActor, 1, std::pair<GetKeyValuesReply, GetKeyValuesReply> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditRestoreQActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditRestoreQActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AuditRestoreQActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AuditRestoreQActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
[[nodiscard]] Future<Void> auditRestoreQ( StorageServer* const& data, AuditStorageRequest const& req ) {
															#line 4522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	return Future<Void>(new AuditRestoreQActor(data, req));
															#line 16886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
}

#line 4693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"

															#line 16891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via auditStorageShardReplicaQ()
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
template <class AuditStorageShardReplicaQActor>
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
class AuditStorageShardReplicaQActorState {
															#line 16898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
public:
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
	AuditStorageShardReplicaQActorState(StorageServer* const& data,AuditStorageRequest const& req) 
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		 : data(data),
															#line 4694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		   req(req)
															#line 16907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageShardReplicaQActorState() 
	{
		fdb_probe_actor_destroy("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(req.getType() == AuditType::ValidateHA || req.getType() == AuditType::ValidateReplica);
															#line 4696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = data->serveAuditStorageParallelismLock.take(TaskPriority::DefaultYield);
															#line 4696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 1;
															#line 4696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 0, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 16931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageShardReplicaQActorState();
		static_cast<AuditStorageShardReplicaQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 4697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 4699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageShardReplicaBegin", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type) .detail("TargetServers", describe(req.targetServers));
															#line 4705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, req.getType());
															#line 4706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverListValues = std::vector<Optional<Value>>();
															#line 4707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 4708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 4709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = Version();
															#line 4710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr = Transaction(data->cx);
															#line 4711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = req.range;
															#line 4712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 4713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 4714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit = 1e4;
															#line 4715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 4716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBytes = 0;
															#line 4717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		numValidatedKeys = 0;
															#line 4718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		validatedBytes = 0;
															#line 4719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		complete = false;
															#line 4720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkTimes = 0;
															#line 4721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 4722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = 0;
															#line 4723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = 0;
															#line 4724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = 0;
															#line 4725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 16998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 4728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 17002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 4697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		holder = FlowLock::Releaser(data->serveAuditStorageParallelismLock);
															#line 4699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		TraceEvent(SevInfo, "SSAuditStorageShardReplicaBegin", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type) .detail("TargetServers", describe(req.targetServers));
															#line 4705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		res = AuditStorageState(req.id, req.getType());
															#line 4706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		serverListValues = std::vector<Optional<Value>>();
															#line 4707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 4708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		errors = std::vector<std::string>();
															#line 4709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		version = Version();
															#line 4710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		tr = Transaction(data->cx);
															#line 4711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToRead = req.range;
															#line 4712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rangeToReadBegin = req.range.begin;
															#line 4713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		claimRange = KeyRange();
															#line 4714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limit = 1e4;
															#line 4715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 4716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		readBytes = 0;
															#line 4717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		numValidatedKeys = 0;
															#line 4718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		validatedBytes = 0;
															#line 4719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		complete = false;
															#line 4720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		checkTimes = 0;
															#line 4721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		startTime = now();
															#line 4722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		lastRateLimiterWaitTime = 0;
															#line 4723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = 0;
															#line 4724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterTotalWaitTime = 0;
															#line 4725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(SERVER_KNOBS->AUDIT_STORAGE_RATE_PER_SERVER_MAX, 1));
															#line 17061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		try {
															#line 4728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			;
															#line 17065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageShardReplicaQActor*>(this)->ActorCallback< AuditStorageShardReplicaQActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageShardReplicaQActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 5103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (!static_cast<AuditStorageShardReplicaQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageShardReplicaQActorState(); static_cast<AuditStorageShardReplicaQActor*>(this)->destroy(); return 0; }
															#line 17155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		new (&static_cast<AuditStorageShardReplicaQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditStorageShardReplicaQActorState();
		static_cast<AuditStorageShardReplicaQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 5084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 17168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 5085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (!static_cast<AuditStorageShardReplicaQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageShardReplicaQActorState(); static_cast<AuditStorageShardReplicaQActor*>(this)->destroy(); return 0; }
															#line 17172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				new (&static_cast<AuditStorageShardReplicaQActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditStorageShardReplicaQActorState();
				static_cast<AuditStorageShardReplicaQActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 5087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevInfo, "SSAuditStorageShardReplicaFailed", data->thisServerID) .errorUnsuppressed(e) .detail("AuditId", req.id) .detail("AuditRange", req.range) .detail("AuditServer", data->thisServerID) .detail("RateLimiterTotalWaitTime", rateLimiterTotalWaitTime) .detail("TotalTime", now() - startTime);
															#line 5094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (e.code() == error_code_audit_storage_cancelled)
															#line 17182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 5095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				req.reply.sendError(audit_storage_cancelled());
															#line 17186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 5096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (e.code() == error_code_audit_storage_task_outdated)
															#line 17192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 5097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.sendError(audit_storage_task_outdated());
															#line 17196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 5099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					req.reply.sendError(audit_storage_failed());
															#line 17202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 4730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			readBytes = 0;
															#line 4731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, req.range.end);
															#line 4732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			ASSERT(!rangeToRead.empty());
															#line 4734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			TraceEvent(SevDebug, "SSAuditStorageShardReplicaNewRoundBegin", data->thisServerID) .suppressFor(10.0) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type) .detail("ReadRangeBegin", rangeToReadBegin) .detail("ReadRangeEnd", req.range.end);
															#line 4741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			serverListValues.clear();
															#line 4742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			errors.clear();
															#line 4743 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.clear();
															#line 4744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.reset();
															#line 4745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 4746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 4751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			for( const UID& id : req.targetServers ) {
															#line 4752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				if (id != data->thisServerID)
															#line 17259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				{
															#line 4753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
					serverListEntries.push_back(tr.get(serverListKeyFor(id)));
															#line 17263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
				}
			}
															#line 4756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(serverListValues, getAll(serverListEntries));
															#line 4756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 2;
															#line 4756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 1, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 5076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		rateLimiterBeforeWaitTime = now();
															#line 5077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_7 = rateLimiter->getAllowance(readBytes);
															#line 5077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 8;
															#line 5077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 7, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 5073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 5073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 7;
															#line 5073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 6, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(version, tr.getReadVersion());
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 3;
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 2, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(version, tr.getReadVersion());
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 3;
															#line 4759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 2, Void >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageShardReplicaQActor*>(this)->ActorCallback< AuditStorageShardReplicaQActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageShardReplicaQActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 4762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( const auto& v : serverListValues ) {
															#line 4763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!v.present())
															#line 17453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevWarn, "SSAuditStorageShardReplicaRemoteServerNotFound", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type);
															#line 4768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 17459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StorageServerInterface remoteServer = decodeServerListValue(v.get());
															#line 4771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			GetKeyValuesRequest req;
															#line 4772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.begin = firstGreaterOrEqual(rangeToRead.begin);
															#line 4773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.end = firstGreaterOrEqual(rangeToRead.end);
															#line 4774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.limit = limit;
															#line 4775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.limitBytes = limitBytes;
															#line 4776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.version = version;
															#line 4777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.tags = TagSet();
															#line 4778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.push_back(remoteServer.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 17479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetKeyValuesRequest localReq;
															#line 4783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.begin = firstGreaterOrEqual(rangeToRead.begin);
															#line 4784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.end = firstGreaterOrEqual(rangeToRead.end);
															#line 4785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.limit = limit;
															#line 4786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.limitBytes = limitBytes;
															#line 4787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.version = version;
															#line 4788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.tags = TagSet();
															#line 4789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->actors.add(getKeyValuesQ(data, localReq));
															#line 4790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back(errorOr(localReq.reply.getFuture()));
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<std::vector<ErrorOr<GetKeyValuesReply>>> __when_expr_3 = getAll(fs);
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 4;
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 3, std::vector<ErrorOr<GetKeyValuesReply>> >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 4762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for( const auto& v : serverListValues ) {
															#line 4763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			if (!v.present())
															#line 17519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			{
															#line 4764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				TraceEvent(SevWarn, "SSAuditStorageShardReplicaRemoteServerNotFound", data->thisServerID) .detail("AuditID", req.id) .detail("AuditRange", req.range) .detail("AuditType", req.type);
															#line 4768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
				return a_body1cont1loopBody1Catch1(audit_storage_failed(), loopDepth);
															#line 17525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
			}
															#line 4770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			StorageServerInterface remoteServer = decodeServerListValue(v.get());
															#line 4771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			GetKeyValuesRequest req;
															#line 4772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.begin = firstGreaterOrEqual(rangeToRead.begin);
															#line 4773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.end = firstGreaterOrEqual(rangeToRead.end);
															#line 4774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.limit = limit;
															#line 4775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.limitBytes = limitBytes;
															#line 4776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.version = version;
															#line 4777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			req.tags = TagSet();
															#line 4778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
			fs.push_back(remoteServer.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 17545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		}
															#line 4782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		GetKeyValuesRequest localReq;
															#line 4783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.begin = firstGreaterOrEqual(rangeToRead.begin);
															#line 4784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.end = firstGreaterOrEqual(rangeToRead.end);
															#line 4785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.limit = limit;
															#line 4786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.limitBytes = limitBytes;
															#line 4787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.version = version;
															#line 4788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		localReq.tags = TagSet();
															#line 4789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		data->actors.add(getKeyValuesQ(data, localReq));
															#line 4790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		fs.push_back(errorOr(localReq.reply.getFuture()));
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		StrictFuture<std::vector<ErrorOr<GetKeyValuesReply>>> __when_expr_3 = getAll(fs);
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 4;
															#line 4791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageShardReplicaQActor, 3, std::vector<ErrorOr<GetKeyValuesReply>> >*>(static_cast<AuditStorageShardReplicaQActor*>(this)));
															#line 17574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/storageserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageShardReplicaQActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageShardReplicaQActor*>(this)->ActorCallback< AuditStorageShardReplicaQActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditStorageShardReplicaQActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditStorageShardReplicaQActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageShardReplicaQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageShardReplicaQ", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(std::vector<ErrorOr<GetKeyValuesReply>> const& reps,int loopDepth) 
	{
															#line 4795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/storageserver.actor.cpp"
		for(int i = 0;i < reps.size();++i) {
															#