#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
/*
 * masterserver.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>

#include "fdbrpc/sim_validation.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/Knobs.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/ResolutionBalancer.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "flow/ActorCollection.h"
#include "flow/Trace.h"
#include "flow/swift_support.h"
#include "fdbclient/VersionVector.h"
#include "fdbserver/MasterData.actor.h"

#ifdef WITH_SWIFT
#include "SwiftModules/FDBServer"
#endif

#include "flow/actorcompiler.h" // This must be the last #include.

// Instantiate MasterInterface related templates
template class ReplyPromise<MasterInterface>;
template struct NetSAV<MasterInterface>;

void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req);

Version figureVersionCxx(Version current,
                         double now,
                         Version reference,
                         int64_t toAdd,
                         double maxVersionRateModifier,
                         int64_t maxVersionRateOffset) {
	// Versions should roughly follow wall-clock time, based on the
	// system clock of the current machine and an FDB-specific epoch.
	// Calculate the expected version and determine whether we need to
	// hand out versions faster or slower to stay in sync with the
	// clock.
	Version expected = now * SERVER_KNOBS->VERSIONS_PER_SECOND - reference;

	// Attempt to jump directly to the expected version. But make
	// sure that versions are still being handed out at a rate
	// around VERSIONS_PER_SECOND. This rate is scaled depending on
	// how far off the calculated version is from the expected
	// version.
	int64_t maxOffset = std::min(static_cast<int64_t>(toAdd * maxVersionRateModifier), maxVersionRateOffset);
	return std::clamp(expected, current + toAdd - maxOffset, current + toAdd + maxOffset);
}

#ifdef WITH_SWIFT
Version figureVersion(Version current,
                      double now,
                      Version reference,
                      int64_t toAdd,
                      double maxVersionRateModifier,
                      int64_t maxVersionRateOffset) {
	auto impl = SERVER_KNOBS->FLOW_WITH_SWIFT ? fdbserver_swift::figureVersion : figureVersionCxx;
	return impl(current, now, reference, toAdd, maxVersionRateModifier, maxVersionRateOffset);
}
#else
Version figureVersion(Version current,
                      double now,
                      Version reference,
                      int64_t toAdd,
                      double maxVersionRateModifier,
                      int64_t maxVersionRateOffset) {
	return figureVersionCxx(current, now, reference, toAdd, maxVersionRateModifier, maxVersionRateOffset);
}
#endif

#ifdef WITH_SWIFT
															#line 95 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForPrev()
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class WaitForPrevActor>
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActorState {
															#line 102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActorState(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPrevActorState() 
	{
		fdb_probe_actor_destroy("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 95 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				auto future = self->swiftImpl->waitForPrev(self.getPtr(), req);
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = future;
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<WaitForPrevActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForPrevActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor, 0, Void >*>(static_cast<WaitForPrevActor*>(this)));
															#line 139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 98 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				startTime = now();
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->liveCommittedVersion.whenAtLeast(req.prevVersion.get());
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<WaitForPrevActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WaitForPrevActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor, 1, Void >*>(static_cast<WaitForPrevActor*>(this)));
															#line 155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPrevActorState();
		static_cast<WaitForPrevActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActorState(); static_cast<WaitForPrevActor*>(this)->destroy(); return 0; }
															#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForPrevActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActorState();
		static_cast<WaitForPrevActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPrevActor*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor*>(this)->ActorCallback< WaitForPrevActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		double latency = now() - startTime;
															#line 101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(latency);
															#line 102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		double latency = now() - startTime;
															#line 101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(latency);
															#line 102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForPrevActor*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor*>(this)->ActorCallback< WaitForPrevActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ReportRawCommittedVersionRequest req;
															#line 98 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	double startTime;
															#line 389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForPrev()
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor final : public Actor<Void>, public ActorCallback< WaitForPrevActor, 0, Void >, public ActorCallback< WaitForPrevActor, 1, Void >, public FastAllocated<WaitForPrevActor>, public WaitForPrevActorState<WaitForPrevActor> {
															#line 394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForPrevActor>::operator new;
	using FastAllocated<WaitForPrevActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(869459579005244672UL, 2015757071375152640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPrevActor, 0, Void >;
friend struct ActorCallback< WaitForPrevActor, 1, Void >;
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitForPrevActorState<WaitForPrevActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13368293736754969600UL, 18390976060860084480UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPrev");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPrevActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForPrevActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> waitForPrev( Reference<MasterData> const& self, ReportRawCommittedVersionRequest const& req ) {
															#line 93 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new WaitForPrevActor(self, req));
															#line 446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForPrev()
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class WaitForPrevActor1>
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor1State {
															#line 458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor1State(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req),
															#line 111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   startTime(now())
															#line 469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPrevActor1State() 
	{
		fdb_probe_actor_destroy("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->liveCommittedVersion.whenAtLeast(req.prevVersion.get());
															#line 112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<WaitForPrevActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForPrevActor1*>(this)->actor_wait_state = 1;
															#line 112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor1, 0, Void >*>(static_cast<WaitForPrevActor1*>(this)));
															#line 491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(now() - startTime);
															#line 114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActor1State(); static_cast<WaitForPrevActor1*>(this)->destroy(); return 0; }
															#line 522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForPrevActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(now() - startTime);
															#line 114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActor1State(); static_cast<WaitForPrevActor1*>(this)->destroy(); return 0; }
															#line 542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<WaitForPrevActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPrevActor1*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor1*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor1*>(this)->ActorCallback< WaitForPrevActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ReportRawCommittedVersionRequest req;
															#line 111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	double startTime;
															#line 631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForPrev()
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor1 final : public Actor<Void>, public ActorCallback< WaitForPrevActor1, 0, Void >, public FastAllocated<WaitForPrevActor1>, public WaitForPrevActor1State<WaitForPrevActor1> {
															#line 636 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForPrevActor1>::operator new;
	using FastAllocated<WaitForPrevActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(869459579005244672UL, 2015757071375152640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPrevActor1, 0, Void >;
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor1(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitForPrevActor1State<WaitForPrevActor1>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4684891747435901440UL, 10234393282114369280UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPrev");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPrevActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> waitForPrev( Reference<MasterData> const& self, ReportRawCommittedVersionRequest const& req ) {
															#line 110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new WaitForPrevActor1(self, req));
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersionSwift()
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionSwiftActor>
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionSwiftActorState {
															#line 700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionSwiftActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionSwiftActorState() 
	{
		fdb_probe_actor_destroy("getVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->getVersion(self.getPtr(), req);
															#line 125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionSwiftActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionSwiftActor, 0, Void >*>(static_cast<GetVersionSwiftActor*>(this)));
															#line 733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionSwiftActorState(); static_cast<GetVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionSwiftActorState(); static_cast<GetVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionSwiftActor*>(this)->actor_wait_state > 0) static_cast<GetVersionSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionSwiftActor*>(this)->ActorCallback< GetVersionSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersionSwift()
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionSwiftActor final : public Actor<Void>, public ActorCallback< GetVersionSwiftActor, 0, Void >, public FastAllocated<GetVersionSwiftActor>, public GetVersionSwiftActorState<GetVersionSwiftActor> {
															#line 860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionSwiftActor>::operator new;
	using FastAllocated<GetVersionSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14681473769673435392UL, 6933953656744437504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionSwiftActor, 0, Void >;
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionSwiftActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetVersionSwiftActorState<GetVersionSwiftActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8158956951726960384UL, 10829688634296044544UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersionSwift( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionSwiftActor(self, req));
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersionCxx()
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionCxxActor>
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionCxxActorState {
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionCxxActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req),
															#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   span("M:getVersion"_loc, req.spanContext),
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   proxyItr(self->lastCommitProxyVersionReplies.find(req.requestingProxy))
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionCxxActorState() 
	{
		fdb_probe_actor_destroy("getVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->getCommitVersionRequests;
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (proxyItr == self->lastCommitProxyVersionReplies.end())
															#line 953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetVersionCxxActorState();
				static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(proxyItr->second.latestRequestNum.get() < req.requestNum - 1, "Commit version request queued up", probe::decoration::rare);
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = proxyItr->second.latestRequestNum.whenAtLeast(req.requestNum - 1);
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionCxxActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionCxxActor, 0, Void >*>(static_cast<GetVersionCxxActor*>(this)));
															#line 976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto itr = proxyItr->second.replies.find(req.requestNum);
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (itr != proxyItr->second.replies.end())
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Duplicate request for sequence");
															#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(itr->second);
															#line 1007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (req.requestNum <= proxyItr->second.latestRequestNum.get())
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				CODE_PROBE(true, "Old request for previously acknowledged sequence - may be impossible with current FlowTransport", probe::decoration::rare);
															#line 156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(req.requestNum < proxyItr->second.latestRequestNum.get());
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 1021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				GetCommitVersionReply rep;
															#line 162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (self->version == invalidVersion)
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				{
															#line 163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = now();
															#line 164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->version = self->recoveryTransactionVersion;
															#line 165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->lastEpochEnd;
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					double t1 = now();
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (BUGGIFY)
															#line 1045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					{
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						t1 = self->lastVersionTime;
															#line 1049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
															#line 173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					Version toAdd = std::max<Version>(1, std::min<Version>(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS, SERVER_KNOBS->VERSIONS_PER_SECOND * (t1 - self->lastVersionTime)));
															#line 178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->version;
															#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (self->referenceVersion.present())
															#line 1057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					{
															#line 180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = figureVersion(self->version, g_network->timer(), self->referenceVersion.get(), toAdd, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET);
															#line 186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						ASSERT_GT(self->version, rep.prevVersion);
															#line 1063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
					else
					{
															#line 188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = self->version + toAdd;
															#line 1069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
															#line 191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(self->version - rep.prevVersion == 1, "Minimum possible version gap");
															#line 193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					bool maxVersionGap = self->version - rep.prevVersion == SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS;
															#line 194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(maxVersionGap, "Maximum possible version gap");
															#line 195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = t1;
															#line 197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->resolutionBalancer.setChangesInReply(req.requestingProxy, rep);
															#line 1081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				}
															#line 200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.version = self->version;
															#line 201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.requestNum = req.requestNum;
															#line 203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies.erase(proxyItr->second.replies.begin(), proxyItr->second.replies.upper_bound(req.mostRecentProcessedRequestNum));
															#line 205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies[req.requestNum] = rep;
															#line 206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(rep.prevVersion >= 0);
															#line 208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(rep);
															#line 210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(proxyItr->second.latestRequestNum.get() == req.requestNum - 1);
															#line 211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.latestRequestNum.set(req.requestNum);
															#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 1104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto itr = proxyItr->second.replies.find(req.requestNum);
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (itr != proxyItr->second.replies.end())
															#line 1118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Duplicate request for sequence");
															#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(itr->second);
															#line 1124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (req.requestNum <= proxyItr->second.latestRequestNum.get())
															#line 1130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				CODE_PROBE(true, "Old request for previously acknowledged sequence - may be impossible with current FlowTransport", probe::decoration::rare);
															#line 156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(req.requestNum < proxyItr->second.latestRequestNum.get());
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 1138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
			else
			{
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				GetCommitVersionReply rep;
															#line 162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (self->version == invalidVersion)
															#line 1146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				{
															#line 163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = now();
															#line 164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->version = self->recoveryTransactionVersion;
															#line 165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->lastEpochEnd;
															#line 1154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				}
				else
				{
															#line 168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					double t1 = now();
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (BUGGIFY)
															#line 1162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					{
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						t1 = self->lastVersionTime;
															#line 1166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
															#line 173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					Version toAdd = std::max<Version>(1, std::min<Version>(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS, SERVER_KNOBS->VERSIONS_PER_SECOND * (t1 - self->lastVersionTime)));
															#line 178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->version;
															#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (self->referenceVersion.present())
															#line 1174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					{
															#line 180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = figureVersion(self->version, g_network->timer(), self->referenceVersion.get(), toAdd, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET);
															#line 186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						ASSERT_GT(self->version, rep.prevVersion);
															#line 1180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
					else
					{
															#line 188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = self->version + toAdd;
															#line 1186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
					}
															#line 191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(self->version - rep.prevVersion == 1, "Minimum possible version gap");
															#line 193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					bool maxVersionGap = self->version - rep.prevVersion == SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS;
															#line 194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(maxVersionGap, "Maximum possible version gap");
															#line 195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = t1;
															#line 197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->resolutionBalancer.setChangesInReply(req.requestingProxy, rep);
															#line 1198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				}
															#line 200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.version = self->version;
															#line 201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.requestNum = req.requestNum;
															#line 203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies.erase(proxyItr->second.replies.begin(), proxyItr->second.replies.upper_bound(req.mostRecentProcessedRequestNum));
															#line 205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies[req.requestNum] = rep;
															#line 206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(rep.prevVersion >= 0);
															#line 208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(rep);
															#line 210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(proxyItr->second.latestRequestNum.get() == req.requestNum - 1);
															#line 211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.latestRequestNum.set(req.requestNum);
															#line 1216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 1221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionCxxActor*>(this)->actor_wait_state > 0) static_cast<GetVersionCxxActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionCxxActor*>(this)->ActorCallback< GetVersionCxxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionCxxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionCxxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionCxxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Span span;
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	std::map<UID, CommitProxyVersionReplies>::iterator proxyItr;
															#line 1312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersionCxx()
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionCxxActor final : public Actor<Void>, public ActorCallback< GetVersionCxxActor, 0, Void >, public FastAllocated<GetVersionCxxActor>, public GetVersionCxxActorState<GetVersionCxxActor> {
															#line 1317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionCxxActor>::operator new;
	using FastAllocated<GetVersionCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1941931260418257664UL, 9048729191426340096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionCxxActor, 0, Void >;
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionCxxActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetVersionCxxActorState<GetVersionCxxActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1319049914498069504UL, 7493486619572726528UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionCxxActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersionCxx( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionCxxActor(self, req));
															#line 1367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 1373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersion()
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionActor>
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActorState {
															#line 1380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 1389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 1404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getVersionSwift(self, req);
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 1415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = getVersionCxx(self, req);
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 1651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersion()
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor final : public Actor<Void>, public ActorCallback< GetVersionActor, 0, Void >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 1656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18386764360678875136UL, 9888151931044884224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Void >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetVersionActorState<GetVersionActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersion( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionActor(self, req));
															#line 1708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersion()
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionActor1>
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor1State {
															#line 1720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor1State(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 1729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActor1State() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getVersionCxx(self, req);
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor1*>(this)->actor_wait_state = 1;
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor1, 0, Void >*>(static_cast<GetVersionActor1*>(this)));
															#line 1751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActor1State(); static_cast<GetVersionActor1*>(this)->destroy(); return 0; }
															#line 1774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActor1State(); static_cast<GetVersionActor1*>(this)->destroy(); return 0; }
															#line 1786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor1*>(this)->actor_wait_state > 0) static_cast<GetVersionActor1*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor1*>(this)->ActorCallback< GetVersionActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 1873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersion()
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor1 final : public Actor<Void>, public ActorCallback< GetVersionActor1, 0, Void >, public FastAllocated<GetVersionActor1>, public GetVersionActor1State<GetVersionActor1> {
															#line 1878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionActor1>::operator new;
	using FastAllocated<GetVersionActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18386764360678875136UL, 9888151931044884224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor1, 0, Void >;
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor1(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetVersionActor1State<GetVersionActor1>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14516526064345610496UL, 7985422690004399616UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersion( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionActor1(self, req));
															#line 1928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

CounterValue::CounterValue(std::string const& name, CounterCollection& collection)
  : value(std::make_shared<Counter>(name, collection)) {}

void CounterValue::operator+=(Value delta) {
	value->operator+=(delta);
}

void CounterValue::operator++() {
	value->operator++();
}
void CounterValue::clear() {
	value->clear();
}

MasterData::MasterData(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,
                       MasterInterface const& myInterface,
                       ServerCoordinators const& coordinators,
                       ClusterControllerFullInterface const& clusterController,
                       Standalone<StringRef> const& dbId,
                       PromiseStream<Future<Void>> addActor,
                       bool forceRecovery)
  : dbgid(myInterface.id()), lastEpochEnd(invalidVersion), recoveryTransactionVersion(invalidVersion),
    liveCommittedVersion(invalidVersion), databaseLocked(false), minKnownCommittedVersion(invalidVersion),
    coordinators(coordinators), version(invalidVersion), lastVersionTime(0), myInterface(myInterface),
    resolutionBalancer(&version), forceRecovery(forceRecovery), cc("Master", dbgid.toString()),
    getCommitVersionRequests("GetCommitVersionRequests", cc),
    getLiveCommittedVersionRequests("GetLiveCommittedVersionRequests", cc),
    reportLiveCommittedVersionRequests("ReportLiveCommittedVersionRequests", cc),
    waitForPrevCommitRequests("WaitForPrevCommitRequests", cc),
    nonWaitForPrevCommitRequests("NonWaitForPrevCommitRequests", cc), addActor(addActor) {
	logger = cc.traceCounters("MasterMetrics", dbgid, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "MasterMetrics");
	if (forceRecovery && !myInterface.locality.dcId().present()) {
		TraceEvent(SevError, "ForcedRecoveryRequiresDcID").log();
		forceRecovery = false;
	}
	balancer = resolutionBalancer.resolutionBalancing();
	locality = tagLocalityInvalid;

	if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
		versionVectorTagUpdates = std::make_unique<LatencySample>("VersionVectorTagUpdates",
		                                                          dbgid,
		                                                          SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                          SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		versionVectorSizeOnCVReply = std::make_unique<LatencySample>("VersionVectorSizeOnCVReply",
		                                                             dbgid,
		                                                             SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                             SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		waitForPrevLatencies = std::make_unique<LatencySample>("WaitForPrevLatencies",
		                                                       dbgid,
		                                                       SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                       SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
	}

#ifdef WITH_SWIFT
	using namespace fdbserver_swift;
	// FIXME(swift): can we make a cleaner init?
	swiftImpl.reset(new MasterDataActor((const MasterDataActor&)MasterDataActor::init()));
#endif
}

#ifdef WITH_SWIFT
void MasterData::setSwiftImpl(fdbserver_swift::MasterDataActor* impl) {
	swiftImpl.reset(impl);
}
#endif

MasterData::~MasterData() {}

															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via provideVersionsCxx()
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsCxxActor>
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsCxxActorState {
															#line 2009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsCxxActorState(Reference<MasterData> const& self) 
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   versionActors(false)
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("provideVersionsCxx", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsCxxActorState() 
	{
		fdb_probe_actor_destroy("provideVersionsCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 2033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsCxxActorState();
		static_cast<ProvideVersionsCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.getCommitVersion.getFuture();
															#line 2063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetCommitVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetCommitVersionRequest>>::value, "invalid type");
															#line 305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = versionActors.getResult();
															#line 2071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state = 1;
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*>(static_cast<ProvideVersionsCxxActor*>(this)));
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsCxxActor, 1, Void >*>(static_cast<ProvideVersionsCxxActor*>(this)));
															#line 2078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetCommitVersionRequest const& req,int loopDepth) 
	{
															#line 307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		versionActors.add(getVersion(self, req));
															#line 2093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetCommitVersionRequest && req,int loopDepth) 
	{
															#line 307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		versionActors.add(getVersion(self, req));
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsCxxActor*>(this)->ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >::remove();
		static_cast<ProvideVersionsCxxActor*>(this)->ActorCallback< ProvideVersionsCxxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,GetCommitVersionRequest const& value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,GetCommitVersionRequest && value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ActorCollection versionActors;
															#line 2244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via provideVersionsCxx()
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsCxxActor final : public Actor<Void>, public ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >, public ActorCallback< ProvideVersionsCxxActor, 1, Void >, public FastAllocated<ProvideVersionsCxxActor>, public ProvideVersionsCxxActorState<ProvideVersionsCxxActor> {
															#line 2249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProvideVersionsCxxActor>::operator new;
	using FastAllocated<ProvideVersionsCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2360475591995310336UL, 7507840768548170496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >;
friend struct ActorCallback< ProvideVersionsCxxActor, 1, Void >;
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsCxxActor(Reference<MasterData> const& self) 
															#line 2267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProvideVersionsCxxActorState<ProvideVersionsCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15042829988053588992UL, 14722448576569397504UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersionsCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersionsCxx( Reference<MasterData> const& self ) {
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsCxxActor(self));
															#line 2300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 2306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via provideVersionsSwift()
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsSwiftActor>
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsSwiftActorState {
															#line 2313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsSwiftActorState(Reference<MasterData> const& self) 
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("provideVersionsSwift", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsSwiftActorState() 
	{
		fdb_probe_actor_destroy("provideVersionsSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->provideVersions(self.getPtr());
															#line 316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state = 1;
															#line 316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsSwiftActor, 0, Void >*>(static_cast<ProvideVersionsSwiftActor*>(this)));
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsSwiftActorState(); static_cast<ProvideVersionsSwiftActor*>(this)->destroy(); return 0; }
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ProvideVersionsSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsSwiftActorState(); static_cast<ProvideVersionsSwiftActor*>(this)->destroy(); return 0; }
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ProvideVersionsSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsSwiftActor*>(this)->ActorCallback< ProvideVersionsSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 2464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via provideVersionsSwift()
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsSwiftActor final : public Actor<Void>, public ActorCallback< ProvideVersionsSwiftActor, 0, Void >, public FastAllocated<ProvideVersionsSwiftActor>, public ProvideVersionsSwiftActorState<ProvideVersionsSwiftActor> {
															#line 2469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProvideVersionsSwiftActor>::operator new;
	using FastAllocated<ProvideVersionsSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5936170970914937600UL, 14725080405295912448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsSwiftActor, 0, Void >;
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsSwiftActor(Reference<MasterData> const& self) 
															#line 2486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProvideVersionsSwiftActorState<ProvideVersionsSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9847266601800460544UL, 9650020213108001536UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersionsSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersionsSwift( Reference<MasterData> const& self ) {
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsSwiftActor(self));
															#line 2519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 2526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via provideVersions()
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsActor>
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActorState {
															#line 2533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActorState(Reference<MasterData> const& self) 
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsActorState() 
	{
		fdb_probe_actor_destroy("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 2555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = provideVersionsSwift(self);
															#line 324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor, 0, Void >*>(static_cast<ProvideVersionsActor*>(this)));
															#line 2566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = provideVersionsCxx(self);
															#line 326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 2;
															#line 326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor, 1, Void >*>(static_cast<ProvideVersionsActor*>(this)));
															#line 2580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsActorState();
		static_cast<ProvideVersionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActorState(); static_cast<ProvideVersionsActor*>(this)->destroy(); return 0; }
															#line 2604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ProvideVersionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActorState();
		static_cast<ProvideVersionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor*>(this)->ActorCallback< ProvideVersionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor*>(this)->ActorCallback< ProvideVersionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 2788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via provideVersions()
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor final : public Actor<Void>, public ActorCallback< ProvideVersionsActor, 0, Void >, public ActorCallback< ProvideVersionsActor, 1, Void >, public FastAllocated<ProvideVersionsActor>, public ProvideVersionsActorState<ProvideVersionsActor> {
															#line 2793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProvideVersionsActor>::operator new;
	using FastAllocated<ProvideVersionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7226696757730507008UL, 8592610477024518656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsActor, 0, Void >;
friend struct ActorCallback< ProvideVersionsActor, 1, Void >;
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor(Reference<MasterData> const& self) 
															#line 2811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProvideVersionsActorState<ProvideVersionsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18210927288071320832UL, 6774768627665853952UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProvideVersionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersions( Reference<MasterData> const& self ) {
															#line 322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsActor(self));
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 2850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via provideVersions()
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsActor1>
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor1State {
															#line 2857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor1State(Reference<MasterData> const& self) 
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsActor1State() 
	{
		fdb_probe_actor_destroy("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = provideVersionsCxx(self);
															#line 333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ProvideVersionsActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvideVersionsActor1*>(this)->actor_wait_state = 1;
															#line 333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor1, 0, Void >*>(static_cast<ProvideVersionsActor1*>(this)));
															#line 2886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActor1State(); static_cast<ProvideVersionsActor1*>(this)->destroy(); return 0; }
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ProvideVersionsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActor1State(); static_cast<ProvideVersionsActor1*>(this)->destroy(); return 0; }
															#line 2921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ProvideVersionsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsActor1*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor1*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor1*>(this)->ActorCallback< ProvideVersionsActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via provideVersions()
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor1 final : public Actor<Void>, public ActorCallback< ProvideVersionsActor1, 0, Void >, public FastAllocated<ProvideVersionsActor1>, public ProvideVersionsActor1State<ProvideVersionsActor1> {
															#line 3011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProvideVersionsActor1>::operator new;
	using FastAllocated<ProvideVersionsActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7226696757730507008UL, 8592610477024518656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsActor1, 0, Void >;
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor1(Reference<MasterData> const& self) 
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProvideVersionsActor1State<ProvideVersionsActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12118823315806273792UL, 3214504062547193344UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersions( Reference<MasterData> const& self ) {
															#line 332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsActor1(self));
															#line 3061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
void updateLiveCommittedVersionSwift(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	fdbserver_swift::updateLiveCommittedVersion(self.getPtr(), req);
}
#endif

void updateLiveCommittedVersionCxx(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, req.minKnownCommittedVersion);

	if (req.version > self->liveCommittedVersion.get()) {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.writtenTags.present()) {
			// TraceEvent("Received ReportRawCommittedVersionRequest").detail("Version",req.version);
			int8_t primaryLocality =
			    SERVER_KNOBS->ENABLE_VERSION_VECTOR_HA_OPTIMIZATION ? self->locality : tagLocalityInvalid;
			self->ssVersionVector.setVersion(req.writtenTags.get(), req.version, primaryLocality);
			self->versionVectorTagUpdates->addMeasurement(req.writtenTags.get().size());
		}
		auto curTime = now();
		// add debug here to change liveCommittedVersion to time bound of now()
		debug_advanceVersionTimestamp(self->liveCommittedVersion.get(), curTime + CLIENT_KNOBS->MAX_VERSION_CACHE_LAG);
		// also add req.version but with no time bound
		debug_advanceVersionTimestamp(req.version, std::numeric_limits<double>::max());
		self->databaseLocked = req.locked;
		self->proxyMetadataVersion = req.metadataVersion;
		// Note the set call switches context to any waiters on liveCommittedVersion before continuing.
		self->liveCommittedVersion.set(req.version);
	}
	++self->reportLiveCommittedVersionRequests;
}

#ifdef WITH_SWIFT
void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	if (SERVER_KNOBS->FLOW_WITH_SWIFT) {
		return updateLiveCommittedVersionSwift(self, req);
	} else {
		return updateLiveCommittedVersionCxx(self, req);
	}
}
#else
void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	return updateLiveCommittedVersionCxx(self, req);
}
#endif

#ifdef WITH_SWIFT
															#line 3112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via serveLiveCommittedVersionSwift()
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionSwiftActor>
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionSwiftActorState {
															#line 3119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionSwiftActorState(Reference<MasterData> const& self) 
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionSwiftActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->serveLiveCommittedVersion(self.getPtr());
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state = 1;
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*>(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)));
															#line 3150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionSwiftActorState(); static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 3173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionSwiftActorState(); static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 3185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serveLiveCommittedVersionSwift()
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionSwiftActor final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >, public FastAllocated<ServeLiveCommittedVersionSwiftActor>, public ServeLiveCommittedVersionSwiftActorState<ServeLiveCommittedVersionSwiftActor> {
															#line 3275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServeLiveCommittedVersionSwiftActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7592541846583598336UL, 18183791095792064768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >;
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionSwiftActor(Reference<MasterData> const& self) 
															#line 3292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionSwiftActorState<ServeLiveCommittedVersionSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5620024424280020480UL, 12154023526707530752UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersionSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersionSwift( Reference<MasterData> const& self ) {
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionSwiftActor(self));
															#line 3325 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 3331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via serveLiveCommittedVersionCxx()
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionCxxActor>
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionCxxActorState {
															#line 3338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionCxxActorState(Reference<MasterData> const& self) 
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionCxxActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 3360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionCxxActorState();
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.getLiveCommittedVersion.getFuture();
															#line 3390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetRawCommittedVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetRawCommittedVersionRequest>>::value, "invalid type");
															#line 392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_1 = self->myInterface.reportLiveCommittedVersion.getFuture();
															#line 3398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ReportRawCommittedVersionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ReportRawCommittedVersionRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state = 1;
															#line 393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*>(static_cast<ServeLiveCommittedVersionCxxActor*>(this)));
															#line 414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*>(static_cast<ServeLiveCommittedVersionCxxActor*>(this)));
															#line 3406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetRawCommittedVersionRequest const& req,int loopDepth) 
	{
															#line 394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.debugID.present())
															#line 3421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "MasterServer.serveLiveCommittedVersion.GetRawCommittedVersion");
															#line 3425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (self->liveCommittedVersion.get() == invalidVersion)
															#line 3429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->liveCommittedVersion.set(self->recoveryTransactionVersion);
															#line 3433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->getLiveCommittedVersionRequests;
															#line 403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		GetRawCommittedVersionReply reply;
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.version = self->liveCommittedVersion.get();
															#line 405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.locked = self->databaseLocked;
															#line 406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.metadataVersion = self->proxyMetadataVersion;
															#line 407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.minKnownCommittedVersion = self->minKnownCommittedVersion;
															#line 408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 3449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->ssVersionVector.getDelta(req.maxVersion, reply.ssVersionVectorDelta);
															#line 410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->versionVectorSizeOnCVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 3455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(reply);
															#line 3459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetRawCommittedVersionRequest && req,int loopDepth) 
	{
															#line 394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.debugID.present())
															#line 3468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "MasterServer.serveLiveCommittedVersion.GetRawCommittedVersion");
															#line 3472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (self->liveCommittedVersion.get() == invalidVersion)
															#line 3476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->liveCommittedVersion.set(self->recoveryTransactionVersion);
															#line 3480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->getLiveCommittedVersionRequests;
															#line 403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		GetRawCommittedVersionReply reply;
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.version = self->liveCommittedVersion.get();
															#line 405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.locked = self->databaseLocked;
															#line 406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.metadataVersion = self->proxyMetadataVersion;
															#line 407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.minKnownCommittedVersion = self->minKnownCommittedVersion;
															#line 408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 3496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->ssVersionVector.getDelta(req.maxVersion, reply.ssVersionVectorDelta);
															#line 410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->versionVectorSizeOnCVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 3502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(reply);
															#line 3506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReportRawCommittedVersionRequest const& req,int loopDepth) 
	{
															#line 416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.prevVersion.present() && (self->liveCommittedVersion.get() != invalidVersion) && (self->liveCommittedVersion.get() < req.prevVersion.get()))
															#line 3515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->addActor.send(waitForPrev(self, req));
															#line 3519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			updateLiveCommittedVersion(self, req);
															#line 422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->nonWaitForPrevCommitRequests;
															#line 423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(Void());
															#line 3529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReportRawCommittedVersionRequest && req,int loopDepth) 
	{
															#line 416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.prevVersion.present() && (self->liveCommittedVersion.get() != invalidVersion) && (self->liveCommittedVersion.get() < req.prevVersion.get()))
															#line 3539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->addActor.send(waitForPrev(self, req));
															#line 3543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			updateLiveCommittedVersion(self, req);
															#line 422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->nonWaitForPrevCommitRequests;
															#line 423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(Void());
															#line 3553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >::remove();
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,GetRawCommittedVersionRequest const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,GetRawCommittedVersionRequest && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,ReportRawCommittedVersionRequest const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,ReportRawCommittedVersionRequest && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serveLiveCommittedVersionCxx()
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionCxxActor final : public Actor<Void>, public ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >, public ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >, public FastAllocated<ServeLiveCommittedVersionCxxActor>, public ServeLiveCommittedVersionCxxActorState<ServeLiveCommittedVersionCxxActor> {
															#line 3687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServeLiveCommittedVersionCxxActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8202270178502323712UL, 6680443778517753088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >;
friend struct ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >;
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionCxxActor(Reference<MasterData> const& self) 
															#line 3705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionCxxActorState<ServeLiveCommittedVersionCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7338616132591428096UL, 5154268329048877824UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersionCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersionCxx( Reference<MasterData> const& self ) {
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionCxxActor(self));
															#line 3738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 3744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionActor>
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActorState {
															#line 3751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActorState(Reference<MasterData> const& self) 
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 3773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = serveLiveCommittedVersionSwift(self);
															#line 433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*>(static_cast<ServeLiveCommittedVersionActor*>(this)));
															#line 3784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = serveLiveCommittedVersionCxx(self);
															#line 435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*>(static_cast<ServeLiveCommittedVersionActor*>(this)));
															#line 3798 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionActorState();
		static_cast<ServeLiveCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActorState(); static_cast<ServeLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 3822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ServeLiveCommittedVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActorState();
		static_cast<ServeLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor*>(this)->ActorCallback< ServeLiveCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor*>(this)->ActorCallback< ServeLiveCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionActor, 0, Void >, public ActorCallback< ServeLiveCommittedVersionActor, 1, Void >, public FastAllocated<ServeLiveCommittedVersionActor>, public ServeLiveCommittedVersionActorState<ServeLiveCommittedVersionActor> {
															#line 4011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServeLiveCommittedVersionActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15289933524974574336UL, 1567949512919505152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionActor, 0, Void >;
friend struct ActorCallback< ServeLiveCommittedVersionActor, 1, Void >;
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor(Reference<MasterData> const& self) 
															#line 4029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionActorState<ServeLiveCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15907572454473595904UL, 10660248522553885184UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersion( Reference<MasterData> const& self ) {
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionActor(self));
															#line 4063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 4068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionActor1>
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor1State {
															#line 4075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor1State(Reference<MasterData> const& self) 
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionActor1State() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = serveLiveCommittedVersionCxx(self);
															#line 441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state = 1;
															#line 441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*>(static_cast<ServeLiveCommittedVersionActor1*>(this)));
															#line 4104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActor1State(); static_cast<ServeLiveCommittedVersionActor1*>(this)->destroy(); return 0; }
															#line 4127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActor1State(); static_cast<ServeLiveCommittedVersionActor1*>(this)->destroy(); return 0; }
															#line 4139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor1*>(this)->ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor1 final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >, public FastAllocated<ServeLiveCommittedVersionActor1>, public ServeLiveCommittedVersionActor1State<ServeLiveCommittedVersionActor1> {
															#line 4229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServeLiveCommittedVersionActor1>::operator new;
	using FastAllocated<ServeLiveCommittedVersionActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15289933524974574336UL, 1567949512919505152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >;
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor1(Reference<MasterData> const& self) 
															#line 4246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionActor1State<ServeLiveCommittedVersionActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8890806443078151168UL, 14214187738504197120UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersion( Reference<MasterData> const& self ) {
															#line 440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionActor1(self));
															#line 4279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 4286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRecoveryDataSwift()
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataSwiftActor>
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataSwiftActorState {
															#line 4293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataSwiftActorState(Reference<MasterData> const& self) 
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataSwiftActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->serveUpdateRecoveryData(self.getPtr());
															#line 449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state = 1;
															#line 449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*>(static_cast<UpdateRecoveryDataSwiftActor*>(this)));
															#line 4324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataSwiftActorState(); static_cast<UpdateRecoveryDataSwiftActor*>(this)->destroy(); return 0; }
															#line 4347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataSwiftActorState(); static_cast<UpdateRecoveryDataSwiftActor*>(this)->destroy(); return 0; }
															#line 4359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRecoveryDataSwift()
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataSwiftActor final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >, public FastAllocated<UpdateRecoveryDataSwiftActor>, public UpdateRecoveryDataSwiftActorState<UpdateRecoveryDataSwiftActor> {
															#line 4449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRecoveryDataSwiftActor>::operator new;
	using FastAllocated<UpdateRecoveryDataSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6724981563538761472UL, 15823732122702221056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >;
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataSwiftActor(Reference<MasterData> const& self) 
															#line 4466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRecoveryDataSwiftActorState<UpdateRecoveryDataSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11356062266753340160UL, 9640252687396583936UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryDataSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryDataSwift( Reference<MasterData> const& self ) {
															#line 447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataSwiftActor(self));
															#line 4499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 4505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRecoveryDataCxx()
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataCxxActor>
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataCxxActorState {
															#line 4512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataCxxActorState(Reference<MasterData> const& self) 
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataCxxActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 4534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataCxxActorState();
		static_cast<UpdateRecoveryDataCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.updateRecoveryData.getFuture();
															#line 4564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<UpdateRecoveryDataRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<UpdateRecoveryDataRequest>>::value, "invalid type");
															#line 456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state = 1;
															#line 456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*>(static_cast<UpdateRecoveryDataCxxActor*>(this)));
															#line 4573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(UpdateRecoveryDataRequest const& req,int loopDepth) 
	{
															#line 457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("UpdateRecoveryData", self->dbgid) .detail("ReceivedRecoveryTxnVersion", req.recoveryTransactionVersion) .detail("ReceivedLastEpochEnd", req.lastEpochEnd) .detail("CurrentRecoveryTxnVersion", self->recoveryTransactionVersion) .detail("CurrentLastEpochEnd", self->lastEpochEnd) .detail("NumCommitProxies", req.commitProxies.size()) .detail("VersionEpoch", req.versionEpoch) .detail("PrimaryLocality", req.primaryLocality);
															#line 466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->recoveryTransactionVersion = req.recoveryTransactionVersion;
															#line 467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->lastEpochEnd = req.lastEpochEnd;
															#line 469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.commitProxies.size() > 0)
															#line 4588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->lastCommitProxyVersionReplies.clear();
															#line 472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			for( auto& p : req.commitProxies ) {
															#line 473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->lastCommitProxyVersionReplies[p.id()] = CommitProxyVersionReplies();
															#line 4596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.versionEpoch.present())
															#line 4601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->referenceVersion = req.versionEpoch.get();
															#line 4605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 4611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->referenceVersion = deterministicRandom()->randomInt64(-1e6, 0);
															#line 4615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setCommitProxies(req.commitProxies);
															#line 488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setResolvers(req.resolvers);
															#line 490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->locality = req.primaryLocality;
															#line 492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 4626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(UpdateRecoveryDataRequest && req,int loopDepth) 
	{
															#line 457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("UpdateRecoveryData", self->dbgid) .detail("ReceivedRecoveryTxnVersion", req.recoveryTransactionVersion) .detail("ReceivedLastEpochEnd", req.lastEpochEnd) .detail("CurrentRecoveryTxnVersion", self->recoveryTransactionVersion) .detail("CurrentLastEpochEnd", self->lastEpochEnd) .detail("NumCommitProxies", req.commitProxies.size()) .detail("VersionEpoch", req.versionEpoch) .detail("PrimaryLocality", req.primaryLocality);
															#line 466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->recoveryTransactionVersion = req.recoveryTransactionVersion;
															#line 467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->lastEpochEnd = req.lastEpochEnd;
															#line 469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.commitProxies.size() > 0)
															#line 4641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->lastCommitProxyVersionReplies.clear();
															#line 472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			for( auto& p : req.commitProxies ) {
															#line 473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->lastCommitProxyVersionReplies[p.id()] = CommitProxyVersionReplies();
															#line 4649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.versionEpoch.present())
															#line 4654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->referenceVersion = req.versionEpoch.get();
															#line 4658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
		else
		{
															#line 478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 4664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->referenceVersion = deterministicRandom()->randomInt64(-1e6, 0);
															#line 4668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			}
		}
															#line 487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setCommitProxies(req.commitProxies);
															#line 488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setResolvers(req.resolvers);
															#line 490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->locality = req.primaryLocality;
															#line 492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 4679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(UpdateRecoveryDataRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UpdateRecoveryDataRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataCxxActor*>(this)->ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,UpdateRecoveryDataRequest const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,UpdateRecoveryDataRequest && value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRecoveryDataCxx()
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataCxxActor final : public Actor<Void>, public ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >, public FastAllocated<UpdateRecoveryDataCxxActor>, public UpdateRecoveryDataCxxActorState<UpdateRecoveryDataCxxActor> {
															#line 4766 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRecoveryDataCxxActor>::operator new;
	using FastAllocated<UpdateRecoveryDataCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6991780023141291520UL, 609724302751344640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >;
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataCxxActor(Reference<MasterData> const& self) 
															#line 4783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRecoveryDataCxxActorState<UpdateRecoveryDataCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8530993395171811328UL, 9217547638281496832UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryDataCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryDataCxx( Reference<MasterData> const& self ) {
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataCxxActor(self));
															#line 4816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 4822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRecoveryData()
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataActor>
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActorState {
															#line 4829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActorState(Reference<MasterData> const& self) 
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 4851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateRecoveryDataSwift(self);
															#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 1;
															#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor, 0, Void >*>(static_cast<UpdateRecoveryDataActor*>(this)));
															#line 4862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = updateRecoveryDataCxx(self);
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 2;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor, 1, Void >*>(static_cast<UpdateRecoveryDataActor*>(this)));
															#line 4876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataActorState();
		static_cast<UpdateRecoveryDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActorState(); static_cast<UpdateRecoveryDataActor*>(this)->destroy(); return 0; }
															#line 4900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<UpdateRecoveryDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActorState();
		static_cast<UpdateRecoveryDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor*>(this)->ActorCallback< UpdateRecoveryDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor*>(this)->ActorCallback< UpdateRecoveryDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 5084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRecoveryData()
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataActor, 0, Void >, public ActorCallback< UpdateRecoveryDataActor, 1, Void >, public FastAllocated<UpdateRecoveryDataActor>, public UpdateRecoveryDataActorState<UpdateRecoveryDataActor> {
															#line 5089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRecoveryDataActor>::operator new;
	using FastAllocated<UpdateRecoveryDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1066250242651875072UL, 4974409337347794944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataActor, 0, Void >;
friend struct ActorCallback< UpdateRecoveryDataActor, 1, Void >;
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor(Reference<MasterData> const& self) 
															#line 5107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRecoveryDataActorState<UpdateRecoveryDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14468069868482539264UL, 12417538139821103360UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryData( Reference<MasterData> const& self ) {
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataActor(self));
															#line 5141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 5146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRecoveryData()
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataActor1>
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor1State {
															#line 5153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor1State(Reference<MasterData> const& self) 
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 5160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataActor1State() 
	{
		fdb_probe_actor_destroy("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateRecoveryDataCxx(self);
															#line 507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state = 1;
															#line 507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor1, 0, Void >*>(static_cast<UpdateRecoveryDataActor1*>(this)));
															#line 5182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActor1State(); static_cast<UpdateRecoveryDataActor1*>(this)->destroy(); return 0; }
															#line 5205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<UpdateRecoveryDataActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActor1State(); static_cast<UpdateRecoveryDataActor1*>(this)->destroy(); return 0; }
															#line 5217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<UpdateRecoveryDataActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor1*>(this)->ActorCallback< UpdateRecoveryDataActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 5302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRecoveryData()
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor1 final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataActor1, 0, Void >, public FastAllocated<UpdateRecoveryDataActor1>, public UpdateRecoveryDataActor1State<UpdateRecoveryDataActor1> {
															#line 5307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRecoveryDataActor1>::operator new;
	using FastAllocated<UpdateRecoveryDataActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1066250242651875072UL, 4974409337347794944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataActor1, 0, Void >;
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor1(Reference<MasterData> const& self) 
															#line 5324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRecoveryDataActor1State<UpdateRecoveryDataActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13647694284020221440UL, 17007669884596067840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryData( Reference<MasterData> const& self ) {
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataActor1(self));
															#line 5357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

static std::set<int> const& normalMasterErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_tlog_stopped);
		s.insert(error_code_tlog_failed);
		s.insert(error_code_commit_proxy_failed);
		s.insert(error_code_grv_proxy_failed);
		s.insert(error_code_resolver_failed);
		s.insert(error_code_backup_worker_failed);
		s.insert(error_code_recruitment_failed);
		s.insert(error_code_no_more_servers);
		s.insert(error_code_cluster_recovery_failed);
		s.insert(error_code_coordinated_state_conflict);
		s.insert(error_code_master_max_versions_in_flight);
		s.insert(error_code_worker_removed);
		s.insert(error_code_new_coordinators_timed_out);
		s.insert(error_code_broken_promise);
	}
	return s;
}

															#line 5384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via masterServerCxx()
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerCxxActor>
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerCxxActorState {
															#line 5391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerCxxActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery),
															#line 539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccTimeout(delay(SERVER_KNOBS->CC_INTERFACE_TIMEOUT))
															#line 5410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("masterServerCxx", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerCxxActorState() 
	{
		fdb_probe_actor_destroy("masterServerCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerCxxActorState();
		static_cast<MasterServerCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = Void();
															#line 552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onDBChange;
															#line 552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 2;
															#line 552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 1, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!(!ccInterface->get().present() || db->get().clusterInterface != ccInterface->get().get()))
															#line 5473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ccInterface->onChange() || db->onChange() || ccTimeout;
															#line 541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 1;
															#line 541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 0, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 5508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 5514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 5528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 5534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor = PromiseStream<Future<Void>>();
															#line 554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		collection = actorCollection(addActor.getFuture());
															#line 558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(traceRole(Role::MASTER, mi.id()));
															#line 559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(provideVersions(self));
															#line 560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(serveLiveCommittedVersion(self));
															#line 561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(updateRecoveryDataCxx(self));
															#line 563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()), "Master born doomed");
															#line 565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("MasterLifetime", self->dbgid).detail("LifetimeToken", lifetime.toString());
															#line 5639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		try {
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor = PromiseStream<Future<Void>>();
															#line 554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		collection = actorCollection(addActor.getFuture());
															#line 558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(traceRole(Role::MASTER, mi.id()));
															#line 559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(provideVersions(self));
															#line 560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(serveLiveCommittedVersion(self));
															#line 561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(updateRecoveryDataCxx(self));
															#line 563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()), "Master born doomed");
															#line 565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("MasterLifetime", self->dbgid).detail("LifetimeToken", lifetime.toString());
															#line 5674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		try {
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			err = e;
															#line 589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delay(0.0);
															#line 590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 5;
															#line 590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 5, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onDBChange;
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = collection;
															#line 5815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 3;
															#line 569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 2, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 3, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = db->onChange();
															#line 571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()))
															#line 5839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "LifetimeToken") .detail("MyToken", lifetime.toString()) .detail("CurrentToken", db->get().masterLifetime.toString());
															#line 576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Master replaced, dying");
															#line 577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 5847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(5);
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1when1(__when_expr_4.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 4;
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 4, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = db->onChange();
															#line 571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()))
															#line 5879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "LifetimeToken") .detail("MyToken", lifetime.toString()) .detail("CurrentToken", db->get().masterLifetime.toString());
															#line 576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Master replaced, dying");
															#line 577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 5887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(5);
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1when1(__when_expr_4.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 4;
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 4, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		ASSERT(false);
															#line 584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		ASSERT(false);
															#line 584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 2, Void >::remove();
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 3, Void >::remove();

	}
	int a_body1cont2loopBody1when1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont2(int loopDepth) 
	{
															#line 579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 5950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2Catch1cont1(int loopDepth) 
	{
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		for(;!addActor.isEmpty();) {
															#line 593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			addActor.getFuture().pop();
															#line 6161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		}
															#line 596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (normalMasterErrors().contains(err.code()))
															#line 6165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()).error(err);
															#line 598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 6171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 6179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> ccTimeout;
															#line 551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> onDBChange;
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> collection;
															#line 588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Error err;
															#line 6294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via masterServerCxx()
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerCxxActor final : public Actor<Void>, public ActorCallback< MasterServerCxxActor, 0, Void >, public ActorCallback< MasterServerCxxActor, 1, Void >, public ActorCallback< MasterServerCxxActor, 2, Void >, public ActorCallback< MasterServerCxxActor, 4, Void >, public ActorCallback< MasterServerCxxActor, 3, Void >, public ActorCallback< MasterServerCxxActor, 5, Void >, public FastAllocated<MasterServerCxxActor>, public MasterServerCxxActorState<MasterServerCxxActor> {
															#line 6299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<MasterServerCxxActor>::operator new;
	using FastAllocated<MasterServerCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11703378570015758080UL, 936805718823655680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerCxxActor, 0, Void >;
friend struct ActorCallback< MasterServerCxxActor, 1, Void >;
friend struct ActorCallback< MasterServerCxxActor, 2, Void >;
friend struct ActorCallback< MasterServerCxxActor, 4, Void >;
friend struct ActorCallback< MasterServerCxxActor, 3, Void >;
friend struct ActorCallback< MasterServerCxxActor, 5, Void >;
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerCxxActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MasterServerCxxActorState<MasterServerCxxActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12553048010944550144UL, 1771433832172964864UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerCxxActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerCxxActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MasterServerCxxActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MasterServerCxxActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MasterServerCxxActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerCxx( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerCxxActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 6364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via masterServerImpl()
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerImplActor>
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActorState {
															#line 6371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery)
															#line 6388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerImplActorState() 
	{
		fdb_probe_actor_destroy("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 6403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			{
															#line 612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				auto promise = Promise<Void>();
															#line 613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				addActor = PromiseStream<Future<Void>>();
															#line 614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				fdbserver_swift::masterServerSwift( mi, const_cast<AsyncVar<ServerDBInfo>*>(db.getPtr()), const_cast<AsyncVar<Optional<ClusterControllerFullInterface>>*>(ccInterface.getPtr()), coordinators, lifetime, forceRecovery, self.getPtr(), promise);
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				Future<Void> f = promise.getFuture();
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MasterServerImplActor*>(this)->actor_wait_state = 1;
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor, 0, Void >*>(static_cast<MasterServerImplActor*>(this)));
															#line 6424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = masterServerCxx(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<MasterServerImplActor*>(this)->actor_wait_state = 2;
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor, 1, Void >*>(static_cast<MasterServerImplActor*>(this)));
															#line 6438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerImplActor*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor*>(this)->ActorCallback< MasterServerImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerImplActor*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor*>(this)->ActorCallback< MasterServerImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 6672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via masterServerImpl()
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor final : public Actor<Void>, public ActorCallback< MasterServerImplActor, 0, Void >, public ActorCallback< MasterServerImplActor, 1, Void >, public FastAllocated<MasterServerImplActor>, public MasterServerImplActorState<MasterServerImplActor> {
															#line 6677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<MasterServerImplActor>::operator new;
	using FastAllocated<MasterServerImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5498111610883729664UL, 14748708113006920192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerImplActor, 0, Void >;
friend struct ActorCallback< MasterServerImplActor, 1, Void >;
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MasterServerImplActorState<MasterServerImplActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7489675442780390912UL, 14990147009436098560UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerImpl( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerImplActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 6734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via masterServerImpl()
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerImplActor1>
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor1State {
															#line 6741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor1State(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery)
															#line 6758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerImplActor1State() 
	{
		fdb_probe_actor_destroy("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = masterServerCxx(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<MasterServerImplActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MasterServerImplActor1*>(this)->actor_wait_state = 1;
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor1, 0, Void >*>(static_cast<MasterServerImplActor1*>(this)));
															#line 6780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActor1State(); static_cast<MasterServerImplActor1*>(this)->destroy(); return 0; }
															#line 6803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActor1State(); static_cast<MasterServerImplActor1*>(this)->destroy(); return 0; }
															#line 6815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerImplActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerImplActor1*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor1*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor1*>(this)->ActorCallback< MasterServerImplActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 6910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via masterServerImpl()
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor1 final : public Actor<Void>, public ActorCallback< MasterServerImplActor1, 0, Void >, public FastAllocated<MasterServerImplActor1>, public MasterServerImplActor1State<MasterServerImplActor1> {
															#line 6915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<MasterServerImplActor1>::operator new;
	using FastAllocated<MasterServerImplActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5498111610883729664UL, 14748708113006920192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerImplActor1, 0, Void >;
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor1(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MasterServerImplActor1State<MasterServerImplActor1>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5307128214695394048UL, 3350264534321644288UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerImplActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerImpl( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerImplActor1(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 6971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via masterServer()
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerActor>
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerActorState {
															#line 6978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery),
															#line 652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccTimeout(delay(SERVER_KNOBS->CC_INTERFACE_TIMEOUT))
															#line 6997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("masterServer", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerActorState() 
	{
		fdb_probe_actor_destroy("masterServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 7012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = Void();
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onDBChange;
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 2;
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 1, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!(!ccInterface->get().present() || db->get().clusterInterface != ccInterface->get().get()))
															#line 7060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ccInterface->onChange() || db->onChange() || ccTimeout;
															#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 1;
															#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 0, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 7095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerActorState();
			static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 7115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		{
															#line 656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerActorState();
			static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = masterServerImpl(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 3;
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 2, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = masterServerImpl(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 3;
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 2, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> ccTimeout;
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> onDBChange;
															#line 7428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via masterServer()
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerActor final : public Actor<Void>, public ActorCallback< MasterServerActor, 0, Void >, public ActorCallback< MasterServerActor, 1, Void >, public ActorCallback< MasterServerActor, 2, Void >, public FastAllocated<MasterServerActor>, public MasterServerActorState<MasterServerActor> {
															#line 7433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<MasterServerActor>::operator new;
	using FastAllocated<MasterServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13562787377175315200UL, 15327121185374729984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerActor, 0, Void >;
friend struct ActorCallback< MasterServerActor, 1, Void >;
friend struct ActorCallback< MasterServerActor, 2, Void >;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 7452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MasterServerActorState<MasterServerActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8935799279357725440UL, 15598559655778800384UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MasterServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServer( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 7487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}

#line 669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase670()
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase670Actor>
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase670ActorState {
															#line 7499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase670ActorState(UnitTestParameters const& params) 
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase670", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase670ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase670", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ( figureVersion(0, 1.0, 0, 1e6, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET), 1e6);
															#line 674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 1.5, 0, 100, 0.1, 1e6), 1000110);
															#line 675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 1.5, 0, 550000, 0.1, 1e6), 1500000);
															#line 676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase670Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase670ActorState(); static_cast<FlowTestCase670Actor*>(this)->destroy(); return 0; }
															#line 7527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase670Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase670ActorState();
			static_cast<FlowTestCase670Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase670ActorState();
		static_cast<FlowTestCase670Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase670()
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase670Actor final : public Actor<Void>, public FastAllocated<FlowTestCase670Actor>, public FlowTestCase670ActorState<FlowTestCase670Actor> {
															#line 7556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase670Actor>::operator new;
	using FastAllocated<FlowTestCase670Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(846419456991374080UL, 2219972540949982208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase670Actor(UnitTestParameters const& params) 
															#line 7572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase670ActorState<FlowTestCase670Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase670", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10542339513831649280UL, 12669074419356295936UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase670");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase670", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase670( UnitTestParameters const& params ) {
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase670Actor(params));
															#line 7604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase670, "/fdbserver/MasterServer/FigureVersion/Simple")

#line 678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase679()
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase679Actor>
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase679ActorState {
															#line 7617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase679ActorState(UnitTestParameters const& params) 
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase679", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase679ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase679", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 2.0, 0, 1, 0.0001, 1e6), 1000001);
															#line 682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 0.0, 0, 1, 0.1, 1e6), 1000001);
															#line 683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase679Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase679ActorState(); static_cast<FlowTestCase679Actor*>(this)->destroy(); return 0; }
															#line 7643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase679Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase679ActorState();
			static_cast<FlowTestCase679Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase679ActorState();
		static_cast<FlowTestCase679Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase679()
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase679Actor final : public Actor<Void>, public FastAllocated<FlowTestCase679Actor>, public FlowTestCase679ActorState<FlowTestCase679Actor> {
															#line 7672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase679Actor>::operator new;
	using FastAllocated<FlowTestCase679Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11602022494994931200UL, 6390164419713881344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase679Actor(UnitTestParameters const& params) 
															#line 7688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase679ActorState<FlowTestCase679Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase679", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8555188639991951360UL, 13387254527781047552UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase679Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase679");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase679", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase679( UnitTestParameters const& params ) {
															#line 679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase679Actor(params));
															#line 7720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase679, "/fdbserver/MasterServer/FigureVersion/Small")

#line 685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase686()
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase686Actor>
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase686ActorState {
															#line 7733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase686ActorState(UnitTestParameters const& params) 
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase686", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase686ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase686", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 10.0, 0, 5e6, 0.1, 1e6), 6500000);
															#line 688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 20.0, 0, 15e6, 0.1, 1e6), 17e6);
															#line 689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase686Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase686ActorState(); static_cast<FlowTestCase686Actor*>(this)->destroy(); return 0; }
															#line 7759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase686Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase686ActorState();
			static_cast<FlowTestCase686Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase686ActorState();
		static_cast<FlowTestCase686Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase686()
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase686Actor final : public Actor<Void>, public FastAllocated<FlowTestCase686Actor>, public FlowTestCase686ActorState<FlowTestCase686Actor> {
															#line 7788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase686Actor>::operator new;
	using FastAllocated<FlowTestCase686Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11450453639740759552UL, 9888814061015921152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase686Actor(UnitTestParameters const& params) 
															#line 7804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase686ActorState<FlowTestCase686Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase686", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16954180358030890496UL, 12427883299091467520UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase686Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase686");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase686", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase686( UnitTestParameters const& params ) {
															#line 686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase686Actor(params));
															#line 7836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase686, "/fdbserver/MasterServer/FigureVersion/MaxOffset")

#line 691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase692()
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase692Actor>
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase692ActorState {
															#line 7849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase692ActorState(UnitTestParameters const& params) 
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase692", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase692ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase692", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 3.0, 1e6, 1e6, 0.1, 1e6), 2e6);
															#line 694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 3.0, 1e6, 100, 0.1, 1e6), 1000110);
															#line 695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase692Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase692ActorState(); static_cast<FlowTestCase692Actor*>(this)->destroy(); return 0; }
															#line 7875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase692Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase692ActorState();
			static_cast<FlowTestCase692Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase692ActorState();
		static_cast<FlowTestCase692Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase692()
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase692Actor final : public Actor<Void>, public FastAllocated<FlowTestCase692Actor>, public FlowTestCase692ActorState<FlowTestCase692Actor> {
															#line 7904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase692Actor>::operator new;
	using FastAllocated<FlowTestCase692Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14859951475651456768UL, 15255661628425749248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase692Actor(UnitTestParameters const& params) 
															#line 7920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase692ActorState<FlowTestCase692Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase692", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15820308921571750144UL, 8678373375027345152UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase692Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase692");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase692", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase692( UnitTestParameters const& params ) {
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase692Actor(params));
															#line 7952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase692, "/fdbserver/MasterServer/FigureVersion/PositiveReferenceVersion")

#line 697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase698()
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase698Actor>
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase698ActorState {
															#line 7965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase698ActorState(UnitTestParameters const& params) 
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase698", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase698ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase698", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(0, 2.0, -1e6, 3e6, 0.1, 1e6), 3e6);
															#line 700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(0, 2.0, -1e6, 5e5, 0.1, 1e6), 550000);
															#line 701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase698Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase698ActorState(); static_cast<FlowTestCase698Actor*>(this)->destroy(); return 0; }
															#line 7991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase698Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase698ActorState();
			static_cast<FlowTestCase698Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase698ActorState();
		static_cast<FlowTestCase698Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 8015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase698()
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase698Actor final : public Actor<Void>, public FastAllocated<FlowTestCase698Actor>, public FlowTestCase698ActorState<FlowTestCase698Actor> {
															#line 8020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase698Actor>::operator new;
	using FastAllocated<FlowTestCase698Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(783354079164075264UL, 2883558483063639296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase698Actor(UnitTestParameters const& params) 
															#line 8036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase698ActorState<FlowTestCase698Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase698", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11521035207632617984UL, 17346954008481091072UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase698Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase698");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase698", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase698( UnitTestParameters const& params ) {
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase698Actor(params));
															#line 8068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase698, "/fdbserver/MasterServer/FigureVersion/NegativeReferenceVersion")

#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
