#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
/*
 * Status.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include "fdbclient/json_spirit/json_spirit_value.h"
#include "flow/genericactors.actor.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbserver/Status.actor.h"
#include "flow/ITrace.h"
#include "flow/ProtocolVersion.h"
#include "flow/Trace.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/WorkerInterface.actor.h"
#include <time.h>
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/ConsistencyScanInterface.actor.h"
#include "flow/UnitTest.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const char* RecoveryStatus::names[] = { "reading_coordinated_state",
	                                    "locking_coordinated_state",
	                                    "locking_old_transaction_servers",
	                                    "reading_transaction_system_state",
	                                    "configuration_missing",
	                                    "configuration_never_created",
	                                    "configuration_invalid",
	                                    "recruiting_transaction_servers",
	                                    "initializing_transaction_servers",
	                                    "recovery_transaction",
	                                    "writing_coordinated_state",
	                                    "accepting_commits",
	                                    "all_logs_recruited",
	                                    "storage_recovered",
	                                    "fully_recovered" };
static_assert(sizeof(RecoveryStatus::names) == sizeof(RecoveryStatus::names[0]) * RecoveryStatus::END,
              "RecoveryStatus::names[] size");
const char* RecoveryStatus::descriptions[] = {
	// reading_coordinated_state
	"Requesting information from coordination servers. Verify that a majority of coordination server processes are "
	"active.",
	// locking_coordinated_state
	"Locking coordination state. Verify that a majority of coordination server processes are active.",
	// locking_old_transaction_servers
	"Locking old transaction servers. Verify that at least one transaction server from the previous generation is "
	"running.",
	// reading_transaction_system_state
	"Recovering transaction server state. Verify that the transaction server processes are active.",
	// configuration_missing
	"There appears to be a database, but its configuration does not appear to be initialized.",
	// configuration_never_created
	"The coordinator(s) have no record of this database. Either the coordinator addresses are incorrect, the "
	"coordination state on those machines is missing, or no database has been created.",
	// configuration_invalid
	"The database configuration is invalid. Set a new, valid configuration to recover the database.",
	// recruiting_transaction_servers
	"Recruiting new transaction servers.",
	// initializing_transaction_servers
	"Initializing new transaction servers and recovering transaction logs.",
	// recovery_transaction
	"Performing recovery transaction.",
	// writing_coordinated_state
	"Writing coordinated state. Verify that a majority of coordination server processes are active.",
	// accepting_commits
	"Accepting commits.",
	// all_logs_recruited
	"Accepting commits. All logs recruited.",
	// storage_recovered
	"Accepting commits. All storage servers are reading from the new logs.",
	// fully_recovered
	"Recovery complete."
};
static_assert(sizeof(RecoveryStatus::descriptions) == sizeof(RecoveryStatus::descriptions[0]) * RecoveryStatus::END,
              "RecoveryStatus::descriptions[] size");

// From Ratekeeper.actor.cpp
extern int limitReasonEnd;
extern const char* limitReasonName[];
extern const char* limitReasonDesc[];

typedef std::map<std::string, TraceEventFields> EventMap;

struct StorageServerStatusInfo : public StorageServerMetaInfo {
	EventMap eventMap;
	StorageServerStatusInfo(const StorageServerMetaInfo& info) : StorageServerMetaInfo(info, info.metadata) {}
};

															#line 117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via latestEventOnWorker()
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkerActor>
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActorState {
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActorState(WorkerInterface const& worker,std::string const& eventName) 
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : worker(worker),
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkerActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<TraceEventFields>> __when_expr_0 = errorOr(timeoutError(worker.eventLogRequest.getReply(req), 2.0));
															#line 119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*>(static_cast<LatestEventOnWorkerActor*>(this)));
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(eventTrace, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(eventTrace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkerActor*>(this)->ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerInterface worker;
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via latestEventOnWorker()
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActor final : public Actor<Optional<TraceEventFields>>, public ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >, public FastAllocated<LatestEventOnWorkerActor>, public LatestEventOnWorkerActorState<LatestEventOnWorkerActor> {
															#line 342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LatestEventOnWorkerActor>::operator new;
	using FastAllocated<LatestEventOnWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4843257500738391040UL, 14842926223041125632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TraceEventFields>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >;
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActor(WorkerInterface const& worker,std::string const& eventName) 
															#line 359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Optional<TraceEventFields>>(),
		   LatestEventOnWorkerActorState<LatestEventOnWorkerActor>(worker, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7106470683888923648UL, 11063323833140639488UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Optional<TraceEventFields>> latestEventOnWorker( WorkerInterface const& worker, std::string const& eventName ) {
															#line 115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<TraceEventFields>>(new LatestEventOnWorkerActor(worker, eventName));
															#line 392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via latestEventOnWorkers()
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkersActor>
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActorState {
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActorState(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : workers(workers),
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkersActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				eventTraces = std::vector<Future<ErrorOr<TraceEventFields>>>();
															#line 137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for(int c = 0;c < workers.size();c++) {
															#line 138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					eventTraces.push_back(errorOr(timeoutError(workers[c].interf.eventLogRequest.getReply(req), 2.0)));
															#line 435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(eventTraces);
															#line 143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 1;
															#line 143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkersActor, 0, Void >*>(static_cast<LatestEventOnWorkersActor*>(this)));
															#line 446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(e.code() == error_code_actor_cancelled);
															#line 166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkersActor*>(this)->ActorCallback< LatestEventOnWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<ErrorOr<TraceEventFields>>> eventTraces;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via latestEventOnWorkers()
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActor final : public Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>, public ActorCallback< LatestEventOnWorkersActor, 0, Void >, public FastAllocated<LatestEventOnWorkersActor>, public LatestEventOnWorkersActorState<LatestEventOnWorkersActor> {
															#line 660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LatestEventOnWorkersActor>::operator new;
	using FastAllocated<LatestEventOnWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9361739559518940416UL, 7541220764716780800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkersActor, 0, Void >;
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActor(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(),
		   LatestEventOnWorkersActorState<LatestEventOnWorkersActor>(workers, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17131304875114139904UL, 5790865631530653952UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestEventOnWorkers( std::vector<WorkerDetails> const& workers, std::string const& eventName ) {
															#line 132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(new LatestEventOnWorkersActor(workers, eventName));
															#line 710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
static Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestErrorOnWorkers(
    std::vector<WorkerDetails> workers) {
	return latestEventOnWorkers(workers, "");
}

static Optional<WorkerDetails> getWorker(std::vector<WorkerDetails> const& workers, NetworkAddress const& address) {
	try {
		for (int c = 0; c < workers.size(); c++)
			if (address == workers[c].interf.address())
				return workers[c];
		return Optional<WorkerDetails>();
	} catch (Error&) {
		return Optional<WorkerDetails>();
	}
}

static Optional<WorkerDetails> getWorker(std::map<NetworkAddress, WorkerDetails> const& workersMap,
                                         NetworkAddress const& address) {
	auto itr = workersMap.find(address);
	if (itr == workersMap.end()) {
		return Optional<WorkerDetails>();
	}

	return itr->second;
}

class StatusCounter {
public:
	StatusCounter() : hz(0), roughness(0), counter(0) {}
	StatusCounter(double hz, double roughness, int64_t counter) : hz(hz), roughness(roughness), counter(counter) {}
	StatusCounter(const std::string& parsableText) { parseText(parsableText); }

	StatusCounter& parseText(const std::string& parsableText) {
		sscanf(parsableText.c_str(), "%lf %lf %" SCNd64 "", &hz, &roughness, &counter);
		return *this;
	}

	StatusCounter& updateValues(const StatusCounter& statusCounter) {
		double hzNew = hz + statusCounter.hz;
		double roughnessNew = (hz + statusCounter.hz) ? (roughness * hz + statusCounter.roughness * statusCounter.hz) /
		                                                    (hz + statusCounter.hz)
		                                              : 0.0;
		int64_t counterNew = counter + statusCounter.counter;
		hz = hzNew;
		roughness = roughnessNew;
		counter = counterNew;
		return *this;
	}

	JsonBuilderObject getStatus() const {
		JsonBuilderObject statusObject;
		statusObject["hz"] = hz;
		statusObject["roughness"] = roughness;
		statusObject["counter"] = counter;
		return statusObject;
	}

	double getHz() { return hz; }

	double getRoughness() { return roughness; }

	int64_t getCounter() { return counter; }

protected:
	double hz;
	double roughness;
	int64_t counter;
};

static JsonBuilderObject getError(const TraceEventFields& errorFields) {
	JsonBuilderObject statusObj;
	try {
		if (errorFields.size()) {
			double time = atof(errorFields.getValue("Time").c_str());
			statusObj["time"] = time;

			statusObj["raw_log_message"] = errorFields.toString();

			std::string type = errorFields.getValue("Type");
			statusObj["type"] = type;

			std::string description = type;
			std::string errorName;
			if (errorFields.tryGetValue("Error", errorName)) {
				statusObj["name"] = errorName;
				description += ": " + errorName;
			} else
				statusObj["name"] = "process_error";

			struct tm* timeinfo;
			time_t t = (time_t)time;
			timeinfo = localtime(&t);
			char buffer[128];
			strftime(buffer, 128, "%c", timeinfo);
			description += " at " + std::string(buffer);

			statusObj["description"] = description;
		}
	} catch (Error& e) {
		TraceEvent(SevError, "StatusGetErrorError").error(e).detail("RawError", errorFields.toString());
	}
	return statusObj;
}

namespace {

void reportCgroupCpuStat(JsonBuilderObject& object, const TraceEventFields& eventFields) {
	JsonBuilderObject cgroupCpuStatObj;
	std::string val;
	if (eventFields.tryGetValue("NrPeriods", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_periods", val);
	}
	if (eventFields.tryGetValue("NrThrottled", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_throttled", val);
	}
	if (eventFields.tryGetValue("ThrottledTime", val)) {
		cgroupCpuStatObj.setKeyRawNumber("throttled_time", val);
	}
	if (!cgroupCpuStatObj.empty()) {
		object["cgroup_cpu_stat"] = cgroupCpuStatObj;
	}
}

JsonBuilderObject machineStatusFetcher(WorkerEvents mMetrics,
                                       std::vector<WorkerDetails> workers,
                                       Optional<DatabaseConfiguration> configuration,
                                       std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject machineMap;
	double metric;
	int failed = 0;

	// map from machine networkAddress to datacenter ID
	std::map<NetworkAddress, std::string> dcIds;
	std::map<NetworkAddress, LocalityData> locality;
	std::map<std::string, bool> excludedMap;
	std::map<std::string, int32_t> workerContribMap;
	std::map<std::string, JsonBuilderObject> machineJsonMap;

	for (auto const& worker : workers) {
		locality[worker.interf.address()] = worker.interf.locality;
		if (worker.interf.locality.dcId().present())
			dcIds[worker.interf.address()] = worker.interf.locality.dcId().get().printable();
	}

	for (auto it = mMetrics.begin(); it != mMetrics.end(); it++) {

		if (!it->second.size()) {
			continue;
		}

		JsonBuilderObject statusObj; // Represents the status for a machine
		const TraceEventFields& event = it->second;

		try {
			std::string address = it->first.ip.toString();
			// We will use the "physical" calculated machine ID here to limit exposure to machineID repurposing
			std::string machineId = event.getValue("MachineID");

			// If this machine ID does not already exist in the machineMap, add it
			if (!machineJsonMap.contains(machineId)) {
				statusObj["machine_id"] = machineId;

				if (dcIds.contains(it->first)) {
					statusObj["datacenter_id"] = dcIds[it->first];
				}

				if (locality.contains(it->first)) {
					statusObj["locality"] = locality[it->first].toJSON<JsonBuilderObject>();
				}

				statusObj["address"] = address;

				JsonBuilderObject memoryObj;
				memoryObj.setKeyRawNumber("total_bytes", event.getValue("TotalMemory"));
				memoryObj.setKeyRawNumber("committed_bytes", event.getValue("CommittedMemory"));
				memoryObj.setKeyRawNumber("free_bytes", event.getValue("AvailableMemory"));
				statusObj["memory"] = memoryObj;

#ifdef __linux__
				reportCgroupCpuStat(statusObj, event);
#endif // __linux__

				JsonBuilderObject cpuObj;
				double cpuSeconds = event.getDouble("CPUSeconds");
				double elapsed = event.getDouble("Elapsed");
				if (elapsed > 0) {
					cpuObj["logical_core_utilization"] = std::max(0.0, std::min(cpuSeconds / elapsed, 1.0));
				}
				statusObj["cpu"] = cpuObj;

				JsonBuilderObject networkObj;
				networkObj["megabits_sent"] = JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsSent"));
				networkObj["megabits_received"] =
				    JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsReceived"));

				metric = event.getDouble("RetransSegs");
				JsonBuilderObject retransSegsObj;
				if (elapsed > 0) {
					retransSegsObj["hz"] = metric / elapsed;
				}
				networkObj["tcp_segments_retransmitted"] = retransSegsObj;
				statusObj["network"] = networkObj;

				if (configuration.present()) {
					excludedMap[machineId] =
					    true; // Will be set to false below if this or any later process is not excluded
				}

				workerContribMap[machineId] = 0;
				machineJsonMap[machineId] = statusObj;
			}

			bool excludedServer = true;
			// If the machine is already marked as not excluded, because at least one process was found to not be
			// excluded, we can stop checking further servers on this machine.
			if (configuration.present() && excludedMap[machineId]) {
				NetworkAddressList tempList;
				tempList.address = it->first;
				// Check if the locality data is present and if so, make use of it.
				auto localityData = LocalityData();
				if (locality.contains(it->first)) {
					localityData = locality[it->first];
				}

				// The isExcludedServer method already contains a check for the excluded localities.
				excludedServer = configuration.get().isExcludedServer(tempList, localityData);
			}

			// If any server is not excluded, set the overall exclusion status of the machine to false.
			if (!excludedServer) {
				excludedMap[machineId] = false;
			}
			workerContribMap[machineId]++;
		} catch (Error&) {
			++failed;
		}
	}

	// Add the status json for each machine with tracked values
	for (auto& mapPair : machineJsonMap) {
		auto& machineId = mapPair.first;
		auto& jsonItem = machineJsonMap[machineId];
		jsonItem["excluded"] = excludedMap[machineId];
		jsonItem["contributing_workers"] = workerContribMap[machineId];
		machineMap[machineId] = jsonItem;
	}

	if (failed > 0)
		incomplete_reasons->insert("Cannot retrieve all machine status information.");

	return machineMap;
}

} // anonymous namespace

JsonBuilderObject getLagObject(int64_t versions) {
	JsonBuilderObject lag;
	lag["versions"] = versions;
	lag["seconds"] = versions / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
	return lag;
}

static JsonBuilderObject getBounceImpactInfo(int recoveryStatusCode) {
	JsonBuilderObject bounceImpact;

	if (recoveryStatusCode == RecoveryStatus::fully_recovered) {
		bounceImpact["can_clean_bounce"] = true;
	} else {
		bounceImpact["can_clean_bounce"] = false;
		bounceImpact["reason"] = "cluster hasn't fully recovered yet";
	}

	return bounceImpact;
}

struct MachineMemoryInfo {
	double memoryUsage; // virtual memory usage
	double rssUsage; // RSS memory usage
	double aggregateLimit;

	MachineMemoryInfo() : memoryUsage(0), rssUsage(0), aggregateLimit(0) {}

	bool valid() { return memoryUsage >= 0; }
	void invalidate() { memoryUsage = -1; }
};

struct RolesInfo {
	std::multimap<NetworkAddress, JsonBuilderObject> roles;

	JsonBuilderObject addLatencyStatistics(TraceEventFields const& metrics) {
		JsonBuilderObject latencyStats;
		latencyStats.setKeyRawNumber("count", metrics.getValue("Count"));
		latencyStats.setKeyRawNumber("min", metrics.getValue("Min"));
		latencyStats.setKeyRawNumber("max", metrics.getValue("Max"));
		latencyStats.setKeyRawNumber("median", metrics.getValue("Median"));
		latencyStats.setKeyRawNumber("mean", metrics.getValue("Mean"));
		latencyStats.setKeyRawNumber("p25", metrics.getValue("P25"));
		latencyStats.setKeyRawNumber("p90", metrics.getValue("P90"));
		latencyStats.setKeyRawNumber("p95", metrics.getValue("P95"));
		latencyStats.setKeyRawNumber("p99", metrics.getValue("P99"));
		latencyStats.setKeyRawNumber("p99.9", metrics.getValue("P99.9"));

		return latencyStats;
	}

	JsonBuilderObject addLatencyBandInfo(TraceEventFields const& metrics) {
		JsonBuilderObject latencyBands;
		std::map<std::string, JsonBuilderObject> bands;

		for (auto itr = metrics.begin(); itr != metrics.end(); ++itr) {
			std::string band;
			if (itr->first.substr(0, 4) == "Band") {
				band = itr->first.substr(4);
			} else if (itr->first == "Filtered") {
				band = "filtered";
			} else {
				continue;
			}

			latencyBands[band] = StatusCounter(itr->second).getCounter();
		}

		return latencyBands;
	}

	JsonBuilderObject& addRole(NetworkAddress address, std::string const& role, UID id) {
		JsonBuilderObject obj;
		obj["id"] = id.shortString();
		obj["role"] = role;
		return roles.insert(std::make_pair(address, obj))->second;
	}

	JsonBuilderObject& addRole(std::string const& role,
	                           StorageServerStatusInfo& iface,
	                           Version maxTLogVersion,
	                           double* pDataLagSeconds) {
		JsonBuilderObject obj;
		EventMap const& metrics = iface.eventMap;
		double dataLagSeconds = -1.0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		obj["tss"] = iface.isTss();
		if (iface.metadata.present()) {
			obj["storage_metadata"] = iface.metadata.get().toJSON();
			// printf("%s\n", metadataObj.getJson().c_str());
		}

		try {
			TraceEventFields const& storageMetrics = metrics.at("StorageMetrics");

			obj.setKeyRawNumber("stored_bytes", storageMetrics.getValue("BytesStored"));
			obj.setKeyRawNumber("kvstore_used_bytes", storageMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", storageMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", storageMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", storageMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("kvstore_total_size", storageMetrics.getValue("KvstoreSizeTotal"));
			obj.setKeyRawNumber("kvstore_total_nodes", storageMetrics.getValue("KvstoreNodeTotal"));
			obj.setKeyRawNumber("kvstore_inline_keys", storageMetrics.getValue("KvstoreInlineKey"));
			obj["input_bytes"] = StatusCounter(storageMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(storageMetrics.getValue("BytesDurable")).getStatus();
			obj.setKeyRawNumber("query_queue_max", storageMetrics.getValue("QueryQueueMax"));
			obj["total_queries"] = StatusCounter(storageMetrics.getValue("QueryQueue")).getStatus();
			obj["finished_queries"] = StatusCounter(storageMetrics.getValue("FinishedQueries")).getStatus();
			obj["low_priority_queries"] = StatusCounter(storageMetrics.getValue("LowPriorityQueries")).getStatus();
			obj["bytes_queried"] = StatusCounter(storageMetrics.getValue("BytesQueried")).getStatus();
			obj["keys_queried"] = StatusCounter(storageMetrics.getValue("RowsQueried")).getStatus();
			obj["mutation_bytes"] = StatusCounter(storageMetrics.getValue("MutationBytes")).getStatus();
			obj["mutations"] = StatusCounter(storageMetrics.getValue("Mutations")).getStatus();
			obj.setKeyRawNumber("local_rate", storageMetrics.getValue("LocalRate"));
			obj["fetched_versions"] = StatusCounter(storageMetrics.getValue("FetchedVersions")).getStatus();
			obj["fetches_from_logs"] = StatusCounter(storageMetrics.getValue("FetchesFromLogs")).getStatus();
			obj["rocksdb_version"] = storageMetrics.getValue("RocksDBVersion");

			Version version = storageMetrics.getInt64("Version");
			Version durableVersion = storageMetrics.getInt64("DurableVersion");

			obj["data_version"] = version;
			obj["durable_version"] = durableVersion;

			int64_t versionLag = storageMetrics.getInt64("VersionLag");
			if (maxTLogVersion > 0) {
				// It's possible that the storage server hasn't talked to the logs recently, in which case it may not be
				// aware of how far behind it is. To account for that, we also compute the version difference between
				// each storage server and the tlog with the largest version.
				//
				// Because this data is only logged periodically, this difference will likely be an overestimate for the
				// lag. We subtract off the logging interval in order to make this estimate a bounded underestimate
				// instead.
				versionLag = std::max<int64_t>(
				    versionLag,
				    maxTLogVersion - version - SERVER_KNOBS->STORAGE_LOGGING_DELAY * SERVER_KNOBS->VERSIONS_PER_SECOND);
			}

			TraceEventFields const& readLatencyMetrics = metrics.at("ReadLatencyMetrics");
			if (readLatencyMetrics.size()) {
				obj["read_latency_statistics"] = addLatencyStatistics(readLatencyMetrics);
			}

			TraceEventFields const& readLatencyBands = metrics.at("ReadLatencyBands");
			if (readLatencyBands.size()) {
				obj["read_latency_bands"] = addLatencyBandInfo(readLatencyBands);
			}

			obj["data_lag"] = getLagObject(versionLag);
			obj["durability_lag"] = getLagObject(version - durableVersion);
			dataLagSeconds = versionLag / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;

			TraceEventFields const& busiestReadTag = metrics.at("BusiestReadTag");
			if (busiestReadTag.size()) {
				int64_t tagCost = busiestReadTag.getInt64("TagCost");
				if (tagCost > 0) {
					JsonBuilderObject busiestReadTagObj;
					busiestReadTagObj["tag"] = busiestReadTag.getValue("Tag");
					busiestReadTagObj["cost"] = tagCost;
					busiestReadTagObj["fractional_cost"] = busiestReadTag.getValue("FractionalBusyness");
					obj["busiest_read_tag"] = busiestReadTagObj;
				}
			}

			TraceEventFields const& busiestWriteTag = metrics.at("BusiestWriteTag");
			if (busiestWriteTag.size()) {
				int64_t tagCost = busiestWriteTag.getInt64("TagCost");

				if (tagCost > 0) {
					JsonBuilderObject busiestWriteTagObj;

					int64_t totalCost = busiestWriteTag.getInt64("TotalCost");
					ASSERT(totalCost > 0);

					busiestWriteTagObj["tag"] = busiestWriteTag.getValue("Tag");
					busiestWriteTagObj["fractional_cost"] = (double)tagCost / totalCost;

					double elapsed = busiestWriteTag.getDouble("Elapsed");
					if (elapsed > 0) {
						JsonBuilderObject estimatedCostObj;
						estimatedCostObj["hz"] = tagCost / elapsed;
						busiestWriteTagObj["estimated_cost"] = estimatedCostObj;
					}

					obj["busiest_write_tag"] = busiestWriteTagObj;
				}
			}

			TraceEventFields const& rocksdbMetrics = metrics.at("RocksDBMetrics");
			if (rocksdbMetrics.size()) {
				JsonBuilderObject rocksdbMetricsObj;
				rocksdbMetricsObj.setKeyRawNumber("block_cache_hits", rocksdbMetrics.getValue("BlockCacheHits"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_misses", rocksdbMetrics.getValue("BlockCacheMisses"));
				rocksdbMetricsObj.setKeyRawNumber("pending_compaction_bytes",
				                                  rocksdbMetrics.getValue("EstPendCompactBytes"));
				rocksdbMetricsObj.setKeyRawNumber("memtable_bytes", rocksdbMetrics.getValue("AllMemtablesBytes"));
				rocksdbMetricsObj.setKeyRawNumber("sst_reader_bytes",
				                                  rocksdbMetrics.getValue("EstimateSstReaderBytes"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_usage", rocksdbMetrics.getValue("BlockCacheUsage"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_limit", rocksdbMetrics.getValue("BlockCacheSize"));
				rocksdbMetricsObj.setKeyRawNumber("throttled_commits", rocksdbMetrics.getValue("CommitDelayed"));
				rocksdbMetricsObj.setKeyRawNumber("write_stall_microseconds", rocksdbMetrics.getValue("StallMicros"));

				obj["rocksdb_metrics"] = std::move(rocksdbMetricsObj);
			}

		} catch (AttributeNotFoundError& e) {
			TraceEvent(SevWarnAlways, "StorageServerStatusJson")
			    .suppressFor(5.0)
			    .detail("MissingAttribute", e.getMissingAttribute());
		}
		if (pDataLagSeconds) {
			*pDataLagSeconds = dataLagSeconds;
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role,
	                           TLogInterface& iface,
	                           EventMap const& metrics,
	                           Version* pMetricVersion) {
		JsonBuilderObject obj;
		Version metricVersion = 0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& tlogMetrics = metrics.at("TLogMetrics");

			obj.setKeyRawNumber("kvstore_used_bytes", tlogMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", tlogMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", tlogMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", tlogMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("queue_disk_used_bytes", tlogMetrics.getValue("QueueDiskBytesUsed"));
			obj.setKeyRawNumber("queue_disk_free_bytes", tlogMetrics.getValue("QueueDiskBytesFree"));
			obj.setKeyRawNumber("queue_disk_available_bytes", tlogMetrics.getValue("QueueDiskBytesAvailable"));
			obj.setKeyRawNumber("queue_disk_total_bytes", tlogMetrics.getValue("QueueDiskBytesTotal"));
			obj["input_bytes"] = StatusCounter(tlogMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(tlogMetrics.getValue("BytesDurable")).getStatus();
			metricVersion = tlogMetrics.getInt64("Version");
			obj["data_version"] = metricVersion;
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found)
				throw e;
		}
		if (pMetricVersion)
			*pMetricVersion = metricVersion;
		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role, CommitProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& commitLatencyMetrics = metrics.at("CommitLatencyMetrics");
			if (commitLatencyMetrics.size()) {
				obj["commit_latency_statistics"] = addLatencyStatistics(commitLatencyMetrics);
			}

			TraceEventFields const& commitLatencyBands = metrics.at("CommitLatencyBands");
			if (commitLatencyBands.size()) {
				obj["commit_latency_bands"] = addLatencyBandInfo(commitLatencyBands);
			}

			TraceEventFields const& commitBatchingWindowSize = metrics.at("CommitBatchingWindowSize");
			if (commitBatchingWindowSize.size()) {
				obj["commit_batching_window_size"] = addLatencyStatistics(commitBatchingWindowSize);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}

	// Returns a json object encoding a snapshot of grv proxy statistics
	JsonBuilderObject& addRole(std::string const& role, GrvProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			JsonBuilderObject priorityStats;

			// GRV Latency metrics are grouped according to priority (currently batch or default).
			// Other priorities can be added in the future.
			TraceEventFields const& grvLatencyMetrics = metrics.at("GRVLatencyMetrics");
			if (grvLatencyMetrics.size()) {
				priorityStats["default"] = addLatencyStatistics(grvLatencyMetrics);
			}

			TraceEventFields const& grvBatchMetrics = metrics.at("GRVBatchLatencyMetrics");
			if (grvBatchMetrics.size()) {
				priorityStats["batch"] = addLatencyStatistics(grvBatchMetrics);
			}

			// Add GRV Latency metrics (for all priorities) to parent node.
			if (priorityStats.size()) {
				obj["grv_latency_statistics"] = priorityStats;
			}

			TraceEventFields const& grvLatencyBands = metrics.at("GRVLatencyBands");
			if (grvLatencyBands.size()) {
				obj["grv_latency_bands"] = addLatencyBandInfo(grvLatencyBands);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	template <class InterfaceType>
	JsonBuilderObject& addRole(std::string const& role, InterfaceType& iface) {
		return addRole(iface.address(), role, iface.id());
	}
	JsonBuilderObject& addCoordinatorRole(NetworkAddress addr) {
		JsonBuilderObject obj;
		obj["role"] = "coordinator";
		return roles.insert(std::make_pair(addr, obj))->second;
	}
	JsonBuilderArray getStatusForAddress(NetworkAddress a) {
		JsonBuilderArray v;
		auto it = roles.lower_bound(a);
		while (it != roles.end() && it->first == a) {
			v.push_back(it->second);
			++it;
		}
		return v;
	}
};

															#line 1302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via processStatusFetcher()
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ProcessStatusFetcherActor>
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActorState {
															#line 1309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   pMetrics(pMetrics),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mMetrics(mMetrics),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   nMetrics(nMetrics),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   errors(errors),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileOpenErrors(traceFileOpenErrors),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   programStarts(programStarts),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   processIssues(processIssues),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServers(storageServers),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tLogs(tLogs),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   commitProxies(commitProxies),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   grvProxies(grvProxies),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   coordinators(coordinators),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   coordinatorAddresses(coordinatorAddresses),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   healthyZone(healthyZone),
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   processMap(),
															#line 782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tracefileOpenErrorMap(),
															#line 783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileErrorsItr()
															#line 1358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ProcessStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			traceFileErrorsItr = traceFileOpenErrors.begin();
															#line 1373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		machineMemoryUsage = std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>();
															#line 810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = std::vector<WorkerDetails>::iterator();
															#line 811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 1400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(traceFileErrorsItr != traceFileOpenErrors.end()))
															#line 1416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 0, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			try {
															#line 790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			try {
															#line 790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++traceFileErrorsItr;
															#line 1592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("file_open_error details could not be retrieved");
															#line 1616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles = RolesInfo();
															#line 836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("master", db->get().master);
															#line 837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("cluster_controller", db->get().clusterInterface.clientInterface);
															#line 839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().distributor.present())
															#line 1650 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("data_distributor", db->get().distributor.get());
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 1658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("ratekeeper", db->get().ratekeeper.get());
															#line 1662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().consistencyScan.present())
															#line 1666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("consistency_scan", db->get().consistencyScan.get());
															#line 1670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : db->get().logSystemConfig.tLogs ) {
															#line 852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 1678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 1682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = std::vector<OldTLogConf>::const_iterator();
															#line 860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogs = db->get().logSystemConfig.oldTLogs;
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = oldTLogs.begin();
															#line 1692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 1708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 1, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1743 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1798 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 1908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			memInfo->second.invalidate();
															#line 1918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( const auto& coordinator : coordinatorAddresses ) {
															#line 878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addCoordinatorRole(coordinator);
															#line 1948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator();
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = commitProxies.begin();
															#line 1954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(oldTLogIter != oldTLogs.end()))
															#line 1970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : oldTLogIter->tLogs ) {
															#line 863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.tLogs ) {
															#line 864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 1980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("log", it.interf());
															#line 1984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 1991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 1995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 2, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator();
															#line 888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = grvProxies.begin();
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(commit_proxy != commitProxies.end()))
															#line 2141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("commit_proxy", commit_proxy->first, commit_proxy->second);
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 3, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		log = std::vector<std::pair<TLogInterface, EventMap>>::iterator();
															#line 894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = 0;
															#line 897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		log = tLogs.begin();
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
															#line 888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(grvProxy != grvProxies.end()))
															#line 2291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("grv_proxy", grvProxy->first, grvProxy->second);
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 4, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ss = std::vector<StorageServerStatusInfo>::iterator();
															#line 905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ssLag = std::map<NetworkAddress, double>();
															#line 906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		lagSeconds = double();
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ss = storageServers.begin();
															#line 2427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(log != tLogs.end()))
															#line 2443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		Version tLogVersion = 0;
															#line 899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("log", log->first, log->second, &tLogVersion);
															#line 900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = std::max(maxTLogVersion, tLogVersion);
															#line 901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_5 = yield();
															#line 901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 5, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res = std::vector<ResolverInterface>::const_iterator();
															#line 916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		resolvers = db->get().resolvers;
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res = resolvers.begin();
															#line 2581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1(int loopDepth) 
	{
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(ss != storageServers.end()))
															#line 2597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("storage", *ss, maxTLogVersion, &lagSeconds);
															#line 909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lagSeconds != -1.0)
															#line 2605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ssLag[ss->address()] = lagSeconds;
															#line 2609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_6 = yield();
															#line 912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont2loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 7;
															#line 912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 6, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 2735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3loopBody1(int loopDepth) 
	{
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(res != resolvers.end()))
															#line 2751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("resolver", *res);
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_7 = yield();
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont3loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 8;
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 7, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2766 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont5(int loopDepth) 
	{
															#line 1117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ProcessStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(processMap); this->~ProcessStatusFetcherActorState(); static_cast<ProcessStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 2881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<ProcessStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(processMap)); // state_var_RVO
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1(int loopDepth) 
	{
															#line 922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 2900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_8 = yield();
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont4loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 9;
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 8, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 2935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 2949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 2957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 2961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 1028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			try {
															#line 1098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1cont10cont4loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont10cont4loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont10cont4loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 3237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 3251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 3259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 3263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 3287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 993 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
															#line 1028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3421 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1042 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			try {
															#line 1098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1cont10cont4loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont10cont4loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont10cont4loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont4loopBody1cont3(int loopDepth) 
	{
															#line 1115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		processMap[printable(workerItr->interf.locality.processId())] = statusObj;
															#line 922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 3616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve all process status information.");
															#line 3634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont4loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont10cont4loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve run loop busyness.");
															#line 3656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10cont4loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont23(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont4loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont4loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont4loopBody1cont24(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont4loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents mMetrics;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents nMetrics;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents errors;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents traceFileOpenErrors;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents programStarts;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, std::vector<JsonBuilderObject>> processIssues;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> storageServers;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>> tLogs;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>> commitProxies;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>> grvProxies;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ServerCoordinators coordinators;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<NetworkAddress> coordinatorAddresses;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> configuration;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<Key> healthyZone;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject processMap;
															#line 782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, JsonBuilderObject> tracefileOpenErrorMap;
															#line 783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents::iterator traceFileErrorsItr;
															#line 809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo> machineMemoryUsage;
															#line 810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails>::iterator workerItr;
															#line 813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>::iterator memInfo;
															#line 834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RolesInfo roles;
															#line 859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf>::const_iterator oldTLogIter;
															#line 860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf> oldTLogs;
															#line 881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator commit_proxy;
															#line 887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator grvProxy;
															#line 893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>>::iterator log;
															#line 894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Version maxTLogVersion;
															#line 904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo>::iterator ss;
															#line 905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<NetworkAddress, double> ssLag;
															#line 906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double lagSeconds;
															#line 915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface>::const_iterator res;
															#line 916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface> resolvers;
															#line 924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 3769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processStatusFetcher()
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ProcessStatusFetcherActor, 0, Void >, public ActorCallback< ProcessStatusFetcherActor, 1, Void >, public ActorCallback< ProcessStatusFetcherActor, 2, Void >, public ActorCallback< ProcessStatusFetcherActor, 3, Void >, public ActorCallback< ProcessStatusFetcherActor, 4, Void >, public ActorCallback< ProcessStatusFetcherActor, 5, Void >, public ActorCallback< ProcessStatusFetcherActor, 6, Void >, public ActorCallback< ProcessStatusFetcherActor, 7, Void >, public ActorCallback< ProcessStatusFetcherActor, 8, Void >, public FastAllocated<ProcessStatusFetcherActor>, public ProcessStatusFetcherActorState<ProcessStatusFetcherActor> {
															#line 3774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessStatusFetcherActor>::operator new;
	using FastAllocated<ProcessStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9099643633760992768UL, 17582731778020994560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessStatusFetcherActor, 0, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 1, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 2, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 3, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 4, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 5, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 6, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 7, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 8, Void >;
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 3799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   ProcessStatusFetcherActorState<ProcessStatusFetcherActor>(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16236183218422400512UL, 108313917293822208UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> processStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerEvents const& pMetrics, WorkerEvents const& mMetrics, WorkerEvents const& nMetrics, WorkerEvents const& errors, WorkerEvents const& traceFileOpenErrors, WorkerEvents const& programStarts, std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues, std::vector<StorageServerStatusInfo> const& storageServers, std::vector<std::pair<TLogInterface, EventMap>> const& tLogs, std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies, std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies, ServerCoordinators const& coordinators, std::vector<NetworkAddress> const& coordinatorAddresses, Database const& cx, Optional<DatabaseConfiguration> const& configuration, Optional<Key> const& healthyZone, std::set<std::string>* const& incomplete_reasons ) {
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ProcessStatusFetcherActor(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons));
															#line 3840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject grayFailureStatus(const std::unordered_map<NetworkAddress, double>& excludedDegradedServers) {
	JsonBuilderObject status;
	JsonBuilderArray excludedServers;
	for (const auto& [excludedServer, time] : excludedDegradedServers) {
		JsonBuilderObject server;
		server["address"] = excludedServer.toString();
		server["time"] = time;
		excludedServers.push_back(server);
	}
	status["excluded_servers"] = excludedServers;
	return status;
}

static JsonBuilderObject clientStatusFetcher(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderObject clientStatus;

	int64_t clientCount = 0;
	// Here we handle versions and maxSupportedProtocols, the issues will be handled in getClientIssuesAsMessages
	std::map<Standalone<ClientVersionRef>, OpenDatabaseRequest::Samples> supportedVersions;
	std::map<Key, OpenDatabaseRequest::Samples> maxSupportedProtocol;

	for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
		if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
			iter = clientStatusMap->erase(iter);
			continue;
		}

		clientCount += iter->second.second.clientCount;
		for (const auto& [version, samples] : iter->second.second.supportedVersions) {
			supportedVersions[version] += samples;
		}
		for (const auto& [protocol, samples] : iter->second.second.maxProtocolSupported) {
			maxSupportedProtocol[protocol] += samples;
		}
		++iter;
	}

	clientStatus["count"] = clientCount;

	JsonBuilderArray versionsArray = JsonBuilderArray();
	for (const auto& [clientVersionRef, samples] : supportedVersions) {
		JsonBuilderObject ver;
		ver["count"] = (int64_t)samples.count;
		ver["client_version"] = clientVersionRef.clientVersion.toString();
		ver["protocol_version"] = clientVersionRef.protocolVersion.toString();
		ver["source_version"] = clientVersionRef.sourceVersion.toString();

		JsonBuilderArray clients = JsonBuilderArray();
		for (const auto& [networkAddress, trackLogGroup] : samples.samples) {
			JsonBuilderObject cli;
			cli["address"] = networkAddress.toString();
			cli["log_group"] = trackLogGroup.toString();
			clients.push_back(cli);
		}

		auto iter = maxSupportedProtocol.find(clientVersionRef.protocolVersion);
		if (iter != std::end(maxSupportedProtocol)) {
			JsonBuilderArray maxClients = JsonBuilderArray();
			for (const auto& [networkAddress, trackLogGroup] : iter->second.samples) {
				JsonBuilderObject cli;
				cli["address"] = networkAddress.toString();
				cli["log_group"] = trackLogGroup.toString();
				maxClients.push_back(cli);
			}
			ver["max_protocol_count"] = iter->second.count;
			ver["max_protocol_clients"] = maxClients;
			maxSupportedProtocol.erase(clientVersionRef.protocolVersion);
		}

		ver["connected_clients"] = clients;
		versionsArray.push_back(ver);
	}

	if (versionsArray.size() > 0) {
		clientStatus["supported_versions"] = versionsArray;
	}

	return clientStatus;
}

															#line 3926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class RecoveryStateStatusFetcherActor>
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActorState {
															#line 3933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActorState(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker),
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workerCount(workerCount),
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusCode(statusCode),
															#line 1207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   message(),
															#line 1208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx)
															#line 3954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~RecoveryStateStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mdActiveGensF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME)))), 1.0);
															#line 1214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mdF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME)))), 1.0);
															#line 1218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mDBAvailableF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME)))), 1.0);
															#line 1222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				rvF = errorOr(timeoutError(tr.getReadVersion(), 1.0));
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(mdActiveGensF) && success(mdF) && success(rvF) && success(mDBAvailableF);
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*>(static_cast<RecoveryStateStatusFetcherActor*>(this)));
															#line 3987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (message.empty())
															#line 4016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Recovery Status unavailable.");
															#line 4020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~RecoveryStateStatusFetcherActorState(); static_cast<RecoveryStateStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 4024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 1246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1252 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 1246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1252 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<RecoveryStateStatusFetcherActor*>(this)->ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int workerCount;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* statusCode;
															#line 1207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdActiveGensF;
															#line 1214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdF;
															#line 1218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mDBAvailableF;
															#line 1223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<Version>> rvF;
															#line 4353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >, public FastAllocated<RecoveryStateStatusFetcherActor>, public RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor> {
															#line 4358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator new;
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8042817508349690368UL, 1862688726163789312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >;
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActor(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 4375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor>(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2143522345445455872UL, 12399124894024078592UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoveryStateStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> recoveryStateStatusFetcher( Database const& cx, WorkerDetails const& ccWorker, WorkerDetails const& mWorker, int const& workerCount, std::set<std::string>* const& incomplete_reasons, int* const& statusCode ) {
															#line 1201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new RecoveryStateStatusFetcherActor(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode));
															#line 4408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 4413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doGrvProbe()
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoGrvProbeActor>
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActorState {
															#line 4420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActorState(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : tr(tr),
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   priority(priority),
															#line 1291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   start(g_network->timer_monotonic())
															#line 4431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoGrvProbeActorState() 
	{
		fdb_probe_actor_destroy("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 4446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (priority.present())
															#line 4479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(priority.get());
															#line 4483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->getReadVersion());
															#line 1300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 1;
															#line 1300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 0, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 2;
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 1, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<FDBTransactionOptions::Option> priority;
															#line 1291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 4726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doGrvProbe()
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActor final : public Actor<double>, public ActorCallback< DoGrvProbeActor, 0, Void >, public ActorCallback< DoGrvProbeActor, 1, Void >, public FastAllocated<DoGrvProbeActor>, public DoGrvProbeActorState<DoGrvProbeActor> {
															#line 4731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoGrvProbeActor>::operator new;
	using FastAllocated<DoGrvProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14370220483160099840UL, 4367079413722497792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoGrvProbeActor, 0, Void >;
friend struct ActorCallback< DoGrvProbeActor, 1, Void >;
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActor(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 4749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<double>(),
		   DoGrvProbeActorState<DoGrvProbeActor>(tr, priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12695868933801491712UL, 15656792167232969216UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doGrvProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoGrvProbeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoGrvProbeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doGrvProbe( Transaction* const& tr, Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>() ) {
															#line 1288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoGrvProbeActor(tr, priority));
															#line 4783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 4788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doReadProbe()
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoReadProbeActor>
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActorState {
															#line 4795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActorState(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 4804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoReadProbeActorState() 
	{
		fdb_probe_actor_destroy("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 1;
															#line 1309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 4826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 4849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 4853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 4859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 4868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 4872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 4878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = tr->get("\xff/StatusJsonTestKey62793"_sr);
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 2;
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 4980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 3;
															#line 1322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 2, Void >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
															#line 1320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
															#line 1320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doReadProbe()
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActor final : public Actor<double>, public ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< DoReadProbeActor, 2, Void >, public FastAllocated<DoReadProbeActor>, public DoReadProbeActorState<DoReadProbeActor> {
															#line 5223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoReadProbeActor>::operator new;
	using FastAllocated<DoReadProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16606165990374362880UL, 8193192351447044096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< DoReadProbeActor, 2, Void >;
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActor(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 5242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<double>(),
		   DoReadProbeActorState<DoReadProbeActor>(grvProbe, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18395811845136080640UL, 11329582461020487936UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoReadProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doReadProbe( Future<double> const& grvProbe, Transaction* const& tr ) {
															#line 1308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoReadProbeActor(grvProbe, tr));
															#line 5277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 5282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCommitProbe()
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoCommitProbeActor>
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActorState {
															#line 5289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActorState(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   sourceTr(sourceTr),
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 5300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoCommitProbeActorState() 
	{
		fdb_probe_actor_destroy("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 1;
															#line 1329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5372 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->makeSelfConflicting();
															#line 1346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 2;
															#line 1346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 1, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 3;
															#line 1349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 2, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* sourceTr;
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCommitProbe()
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActor final : public Actor<double>, public ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoCommitProbeActor, 1, Void >, public ActorCallback< DoCommitProbeActor, 2, Void >, public FastAllocated<DoCommitProbeActor>, public DoCommitProbeActorState<DoCommitProbeActor> {
															#line 5734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCommitProbeActor>::operator new;
	using FastAllocated<DoCommitProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16078418485244995072UL, 618964288668509696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoCommitProbeActor, 1, Void >;
friend struct ActorCallback< DoCommitProbeActor, 2, Void >;
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActor(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 5753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<double>(),
		   DoCommitProbeActorState<DoCommitProbeActor>(grvProbe, sourceTr, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12181102828360946944UL, 14510411821951618048UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCommitProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCommitProbeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCommitProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doCommitProbe( Future<double> const& grvProbe, Transaction* const& sourceTr, Transaction* const& tr ) {
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoCommitProbeActor(grvProbe, sourceTr, tr));
															#line 5788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 5793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doProbe()
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoProbeActor>
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActorState {
															#line 5800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActorState(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : probe(probe),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(timeoutSeconds),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   prefix(prefix),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   description(description),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   probeObj(probeObj),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable)
															#line 5821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoProbeActorState() 
	{
		fdb_probe_actor_destroy("doProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(probe);
															#line 1362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(timeoutSeconds);
															#line 5842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<DoProbeActor*>(this)->actor_wait_state = 1;
															#line 1363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 0, ErrorOr<double> >*>(static_cast<DoProbeActor*>(this)));
															#line 1374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 1, Void >*>(static_cast<DoProbeActor*>(this)));
															#line 5849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoProbeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoProbeActorState(); static_cast<DoProbeActor*>(this)->destroy(); return 0; }
															#line 5872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DoProbeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& result,int loopDepth) 
	{
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 5884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 5888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 5892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 5896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 5902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && result,int loopDepth) 
	{
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 5912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 5916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 5920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 5924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 5930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 5940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 5944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 5948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 5957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 5961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 5965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoProbeActor*>(this)->actor_wait_state > 0) static_cast<DoProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 0, ErrorOr<double> >::remove();
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> probe;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	const char* prefix;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	const char* description;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* probeObj;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 6107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doProbe()
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActor final : public Actor<Void>, public ActorCallback< DoProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoProbeActor, 1, Void >, public FastAllocated<DoProbeActor>, public DoProbeActorState<DoProbeActor> {
															#line 6112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoProbeActor>::operator new;
	using FastAllocated<DoProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4373951228055396608UL, 15841552433248407808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoProbeActor, 1, Void >;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActor(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 6130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoProbeActorState<DoProbeActor>(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15729666029307177216UL, 15210686459627708928UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> doProbe( Future<double> const& probe, int const& timeoutSeconds, const char* const& prefix, const char* const& description, JsonBuilderObject* const& probeObj, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable = nullptr ) {
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new DoProbeActor(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable));
															#line 6163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 6168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via latencyProbeFetcher()
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatencyProbeFetcherActor>
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActorState {
															#line 6175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable),
															#line 1391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trImmediate(cx),
															#line 1392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trDefault(cx),
															#line 1393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trBatch(cx),
															#line 1394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trWrite(cx),
															#line 1396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 6198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LatencyProbeFetcherActorState() 
	{
		fdb_probe_actor_destroy("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> immediateGrvProbe = doGrvProbe(&trImmediate, FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> defaultGrvProbe = doGrvProbe(&trDefault);
															#line 1401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> batchGrvProbe = doGrvProbe(&trBatch, FDBTransactionOptions::PRIORITY_BATCH);
															#line 1403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> readProbe = doReadProbe(immediateGrvProbe, &trImmediate);
															#line 1404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> commitProbe = doCommitProbe(immediateGrvProbe, &trImmediate, &trWrite);
															#line 1406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int timeoutSeconds = 5;
															#line 1408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<Void>> probes;
															#line 1409 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(immediateGrvProbe, timeoutSeconds, "immediate_priority_transaction_start", "start immediate priority transaction", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(defaultGrvProbe, timeoutSeconds, "transaction_start", "start default priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(batchGrvProbe, timeoutSeconds, "batch_priority_transaction_start", "start batch priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back( doProbe(readProbe, timeoutSeconds, "read", "read", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe( commitProbe, timeoutSeconds, "commit", "commit", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(probes);
															#line 1436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 1;
															#line 1436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatencyProbeFetcherActor, 0, Void >*>(static_cast<LatencyProbeFetcherActor*>(this)));
															#line 6245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatencyProbeFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LatencyProbeFetcherActorState(); static_cast<LatencyProbeFetcherActor*>(this)->destroy(); return 0; }
															#line 6274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LatencyProbeFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve latency probe information (%s).", e.what()));
															#line 6295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state > 0) static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyProbeFetcherActor*>(this)->ActorCallback< LatencyProbeFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 1391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trImmediate;
															#line 1392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trDefault;
															#line 1393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trBatch;
															#line 1394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trWrite;
															#line 1396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 6424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via latencyProbeFetcher()
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LatencyProbeFetcherActor, 0, Void >, public FastAllocated<LatencyProbeFetcherActor>, public LatencyProbeFetcherActorState<LatencyProbeFetcherActor> {
															#line 6429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LatencyProbeFetcherActor>::operator new;
	using FastAllocated<LatencyProbeFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18316343028789862656UL, 12421518147179831808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatencyProbeFetcherActor, 0, Void >;
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 6446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   LatencyProbeFetcherActorState<LatencyProbeFetcherActor>(cx, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11104724659914187008UL, 14391616900010405120UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latencyProbeFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatencyProbeFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> latencyProbeFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable ) {
															#line 1387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LatencyProbeFetcherActor(cx, messages, incomplete_reasons, isAvailable));
															#line 6479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 6484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class VersionEpochStatusFetcherActor>
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActorState {
															#line 6491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActorState(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   message()
															#line 6502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~VersionEpochStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 6520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<VersionEpochStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~VersionEpochStatusFetcherActorState(); static_cast<VersionEpochStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 6549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<VersionEpochStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve version epoch information (%s).", e.what()));
															#line 6570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(versionEpochKey), 5.0);
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
															#line 1458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && versionEpochVal,int loopDepth) 
	{
															#line 1458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(versionEpochVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(versionEpochVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 6886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< VersionEpochStatusFetcherActor, 1, Void >, public FastAllocated<VersionEpochStatusFetcherActor>, public VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor> {
															#line 6891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<VersionEpochStatusFetcherActor>::operator new;
	using FastAllocated<VersionEpochStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10901761630065741056UL, 11823550637680655104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< VersionEpochStatusFetcherActor, 1, Void >;
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActor(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 6909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor>(cx, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5224719475858352128UL, 5273280573928800768UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("versionEpochStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> versionEpochStatusFetcher( Database const& cx, std::set<std::string>* const& incomplete_reasons ) {
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new VersionEpochStatusFetcherActor(cx, incomplete_reasons));
															#line 6943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 6948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ConsistencyCheckStatusFetcherActor>
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActorState {
															#line 6955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 6966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 6984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyCheckStatusFetcherActorState(); static_cast<ConsistencyCheckStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 7013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve consistency check settings (%s).", e.what()));
															#line 7034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(fdbShouldConsistencyCheckBeSuspended), 5.0);
															#line 1488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("consistencycheck_suspendkey_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(fdbShouldConsistencyCheckBeSuspended).c_str()) .c_str()));
															#line 7115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
															#line 1490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
															#line 1490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1493 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ccSuspendVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ccSuspendVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 7353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActor final : public Actor<Void>, public ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >, public FastAllocated<ConsistencyCheckStatusFetcherActor>, public ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor> {
															#line 7358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator new;
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6148610352643526400UL, 6050188940746550272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >;
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 7376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4551706905108231424UL, 2658363125606068224UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> consistencyCheckStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new ConsistencyCheckStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 7410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct LogRangeAndUID {
	KeyRange range;
	UID destID;

	LogRangeAndUID(KeyRange const& range, UID const& destID) : range(range), destID(destID) {}

	bool operator<(LogRangeAndUID const& r) const {
		if (range.begin != r.range.begin)
			return range.begin < r.range.begin;
		if (range.end != r.range.end)
			return range.end < r.range.end;
		return destID < r.destID;
	}
};

															#line 7430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LogRangeWarningFetcherActor>
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActorState {
															#line 7437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 7448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LogRangeWarningFetcherActorState() 
	{
		fdb_probe_actor_destroy("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				timeoutFuture = timeoutError(Future<Void>(Never()), 5.0);
															#line 1540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 7468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LogRangeWarningFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogRangeWarningFetcherActorState(); static_cast<LogRangeWarningFetcherActor*>(this)->destroy(); return 0; }
															#line 7497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LogRangeWarningFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve log ranges (%s).", e.what()));
															#line 7518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			existingDestUidValues = tr.getRange(KeyRangeRef(destUidLookupPrefix, strinc(destUidLookupPrefix)), CLIENT_KNOBS->TOO_MANY);
															#line 1548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			existingLogRanges = tr.getRange(logRangesRange, CLIENT_KNOBS->TOO_MANY);
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = (success(existingDestUidValues) && success(existingLogRanges)) || timeoutFuture;
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 1;
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 0, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("duplicate_mutation_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(destUidLookupPrefix).c_str()) .c_str()));
															#line 7603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 3;
															#line 1594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 2, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					break;
				}
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					break;
				}
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> timeoutFuture;
															#line 1546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingDestUidValues;
															#line 1548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingLogRanges;
															#line 8026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActor final : public Actor<Void>, public ActorCallback< LogRangeWarningFetcherActor, 0, Void >, public ActorCallback< LogRangeWarningFetcherActor, 1, Void >, public ActorCallback< LogRangeWarningFetcherActor, 2, Void >, public FastAllocated<LogRangeWarningFetcherActor>, public LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor> {
															#line 8031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogRangeWarningFetcherActor>::operator new;
	using FastAllocated<LogRangeWarningFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9994704000798032896UL, 14410847274493219584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogRangeWarningFetcherActor, 0, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 1, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 2, Void >;
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 8050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16741679886096178432UL, 1377216152642019584UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logRangeWarningFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> logRangeWarningFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new LogRangeWarningFetcherActor(cx, messages, incomplete_reasons));
															#line 8085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct ProtocolVersionData {
	ProtocolVersion runningProtocolVersion;
	ProtocolVersion newestProtocolVersion;
	ProtocolVersion lowestCompatibleProtocolVersion;
	ProtocolVersionData() : runningProtocolVersion(currentProtocolVersion()) {}

	ProtocolVersionData(uint64_t newestProtocolVersionValue, uint64_t lowestCompatibleProtocolVersionValue)
	  : runningProtocolVersion(currentProtocolVersion()), newestProtocolVersion(newestProtocolVersionValue),
	    lowestCompatibleProtocolVersion(lowestCompatibleProtocolVersionValue) {}
};

															#line 8101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetNewestProtocolVersionActor>
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActorState {
															#line 8108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActorState(Database const& cx,WorkerDetails const& ccWorker) 
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker)
															#line 8117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetNewestProtocolVersionActorState() 
	{
		fdb_probe_actor_destroy("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				swVersionF = timeoutError( ccWorker.interf.eventLogRequest.getReply(EventLogRequest("SWVersionCompatibilityChecked"_sr)), 1.0);
															#line 1623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(swVersionF);
															#line 1623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 1;
															#line 1623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNewestProtocolVersionActor, 0, Void >*>(static_cast<GetNewestProtocolVersionActor*>(this)));
															#line 8142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionStatusFailed").error(e);
															#line 1637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData()); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData());
			this->~GetNewestProtocolVersionActorState();
			static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewestProtocolVersionActor*>(this)->ActorCallback< GetNewestProtocolVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> swVersionF;
															#line 8313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActor final : public Actor<ProtocolVersionData>, public ActorCallback< GetNewestProtocolVersionActor, 0, Void >, public FastAllocated<GetNewestProtocolVersionActor>, public GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor> {
															#line 8318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetNewestProtocolVersionActor>::operator new;
	using FastAllocated<GetNewestProtocolVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10091937026404532992UL, 1339639227990614272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ProtocolVersionData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNewestProtocolVersionActor, 0, Void >;
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActor(Database const& cx,WorkerDetails const& ccWorker) 
															#line 8335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<ProtocolVersionData>(),
		   GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor>(cx, ccWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10890173716684436736UL, 2976883552386424576UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNewestProtocolVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNewestProtocolVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<ProtocolVersionData> getNewestProtocolVersion( Database const& cx, WorkerDetails const& ccWorker ) {
															#line 1617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<ProtocolVersionData>(new GetNewestProtocolVersionActor(cx, ccWorker));
															#line 8368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct LoadConfigurationResult {
	bool fullReplication;
	Optional<Key> healthyZone;
	double healthyZoneSeconds;
	bool rebalanceDDIgnored;
	// FIXME: possible convert it to int if upgrade value can be resolved?
	std::string rebalanceDDIgnoreHex; // any or combination of 0, 1, 2, see DDIgnore;
	bool dataDistributionDisabled;

	LoadConfigurationResult()
	  : fullReplication(true), healthyZoneSeconds(0), rebalanceDDIgnored(false), dataDistributionDisabled(false) {}
};

															#line 8386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via loadConfiguration()
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LoadConfigurationActor>
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActorState {
															#line 8393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   status_incomplete_reasons(status_incomplete_reasons),
															#line 1656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 1657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   loadResult(),
															#line 1658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 1659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   getConfTimeout(delay(5.0))
															#line 8412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~LoadConfigurationActorState() 
	{
		fdb_probe_actor_destroy("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 8427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LoadConfigurationActor*>(this)->SAV<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>::futures) { (void)(std::make_pair(result, loadResult)); this->~LoadConfigurationActorState(); static_cast<LoadConfigurationActor*>(this)->destroy(); return 0; }
															#line 8450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LoadConfigurationActor*>(this)->SAV< std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >::value()) std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>(std::make_pair(result, loadResult));
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 8471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 1666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH);
															#line 1665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getConfTimeout;
															#line 8481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 1;
															#line 1666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 0, RangeResult >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 1, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 3;
															#line 1742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 4, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(result.present());
															#line 1689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 1690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& region : result.get().regions ) {
															#line 1691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			replicasFutures.push_back(tr.get(datacenterReplicasKeyFor(region.dcId)));
															#line 8551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		healthyZoneValue = tr.get(healthyZoneKey);
															#line 1694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		rebalanceDDIgnored = tr.get(rebalanceDDIgnoreKey);
															#line 1695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ddModeKey = tr.get(dataDistributionModeKey);
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) && success(healthyZoneValue) && success(rebalanceDDIgnored) && success(ddModeKey);
															#line 1697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 1735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = getConfTimeout;
															#line 8567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 2;
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 2, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 3, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
															#line 1667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
															#line 1667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 0, RangeResult >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 8804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 8808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 8817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 8823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 8827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 8833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 8839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 8847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 8851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 8855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 8865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 8869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 8874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 8887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 8891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 8900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 8906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 8910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 8916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 8922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 8930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 8934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 8938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 8948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 8952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 8957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
															#line 1736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
															#line 1736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 2, Void >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* status_incomplete_reasons;
															#line 1656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> result;
															#line 1657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<LoadConfigurationResult> loadResult;
															#line 1658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getConfTimeout;
															#line 1689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 1693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> healthyZoneValue;
															#line 1694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> rebalanceDDIgnored;
															#line 1695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> ddModeKey;
															#line 9210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadConfiguration()
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActor final : public Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>, public ActorCallback< LoadConfigurationActor, 0, RangeResult >, public ActorCallback< LoadConfigurationActor, 1, Void >, public ActorCallback< LoadConfigurationActor, 2, Void >, public ActorCallback< LoadConfigurationActor, 3, Void >, public ActorCallback< LoadConfigurationActor, 4, Void >, public FastAllocated<LoadConfigurationActor>, public LoadConfigurationActorState<LoadConfigurationActor> {
															#line 9215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LoadConfigurationActor>::operator new;
	using FastAllocated<LoadConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4559497696769102080UL, 12142101379944581888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadConfigurationActor, 0, RangeResult >;
friend struct ActorCallback< LoadConfigurationActor, 1, Void >;
friend struct ActorCallback< LoadConfigurationActor, 2, Void >;
friend struct ActorCallback< LoadConfigurationActor, 3, Void >;
friend struct ActorCallback< LoadConfigurationActor, 4, Void >;
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 9236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(),
		   LoadConfigurationActorState<LoadConfigurationActor>(cx, messages, status_incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(440137498882600448UL, 6960115472849028608UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadConfigurationActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadConfigurationActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> loadConfiguration( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& status_incomplete_reasons ) {
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(new LoadConfigurationActor(cx, messages, status_incomplete_reasons));
															#line 9271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject configurationFetcher(Optional<DatabaseConfiguration> conf,
                                              ServerCoordinators coordinators,
                                              std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject statusObj;
	try {
		if (conf.present()) {
			DatabaseConfiguration configuration = conf.get();
			statusObj.addContents(configuration.toJSON());

			JsonBuilderArray excludedServersArr;
			std::set<AddressExclusion> excludedServers = configuration.getExcludedServers();
			for (std::set<AddressExclusion>::iterator it = excludedServers.begin(); it != excludedServers.end(); it++) {
				JsonBuilderObject statusObj;
				statusObj["address"] = it->toString();
				excludedServersArr.push_back(statusObj);
			}
			std::set<std::string> excludedLocalities = configuration.getExcludedLocalities();
			for (const auto& it : excludedLocalities) {
				JsonBuilderObject statusObj;
				statusObj["locality"] = it;
				excludedServersArr.push_back(statusObj);
			}
			statusObj["excluded_servers"] = excludedServersArr;
		}
		int count = coordinators.clientLeaderServers.size();
		statusObj["coordinators_count"] = count;
	} catch (Error& e) {
		if (e.code() == error_code_actor_cancelled) {
			throw;
		}
		incomplete_reasons->insert("Could not retrieve all configuration status information.");
	}
	return statusObj;
}

															#line 9311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via dataStatusFetcher()
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DataStatusFetcherActor>
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActorState {
															#line 9318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActorState(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : ddWorker(ddWorker),
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   minStorageReplicasRemaining(minStorageReplicasRemaining),
															#line 1786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObjData()
															#line 9331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~DataStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<TraceEventFields>> futures;
															#line 1792 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStarting"_sr)), 1.0));
															#line 1794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 1.0));
															#line 1796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0));
															#line 1798 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlight"_sr)), 1.0));
															#line 1800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlightRemote"_sr)), 1.0));
															#line 1803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(futures);
															#line 1803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<DataStatusFetcherActor*>(this)));
															#line 9366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
															#line 1805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 9458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 9470 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1832 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 9486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 9491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 9499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 9509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 1853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 9525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 9531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 9535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 9550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 9560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 9566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 9576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 9582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 9592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 9598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
						{
															#line 1885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 9606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 9612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
							{
															#line 1889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 9620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 9626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
								{
															#line 1893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 9634 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
								}
								else
								{
															#line 1896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
									{
															#line 1897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 9648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
									}
									else
									{
															#line 1900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 9654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
										{
															#line 1901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 9662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
										}
										else
										{
															#line 1904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 9668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
											{
															#line 1905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 9674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
											}
											else
											{
															#line 1907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 9680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
												{
															#line 1908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 9688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
												}
												else
												{
															#line 1911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 9694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
													{
															#line 1912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 9702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
													}
													else
													{
															#line 1915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 9708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
														{
															#line 1916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 9714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 9731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 9739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 9743 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 9748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 9752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 9758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 9762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 9768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
															#line 1805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 9807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 9819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1832 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 9835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 1840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 9840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 9848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 9858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 1853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 9874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 9880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 9884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 9899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 9909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 9915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 9925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 9931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 1880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1881 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 9941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 9947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
						{
															#line 1885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 9955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 9961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
							{
															#line 1889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 9969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 9975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
								{
															#line 1893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 9983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
								}
								else
								{
															#line 1896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
									{
															#line 1897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 9997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
									}
									else
									{
															#line 1900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 10003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
										{
															#line 1901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 10011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
										}
										else
										{
															#line 1904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 10017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
											{
															#line 1905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 10023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
											}
											else
											{
															#line 1907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 10029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
												{
															#line 1908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 10037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
												}
												else
												{
															#line 1911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 10043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
													{
															#line 1912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 10051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
													}
													else
													{
															#line 1915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 10057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
														{
															#line 1916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 10063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 10080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 10088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 10092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 10097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 1936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 10101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 10107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 1938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 10111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 10117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataInfo, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<DataStatusFetcherActor*>(this)->ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont41(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ddWorker;
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* minStorageReplicasRemaining;
															#line 1786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObjData;
															#line 10218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via dataStatusFetcher()
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >, public FastAllocated<DataStatusFetcherActor>, public DataStatusFetcherActorState<DataStatusFetcherActor> {
															#line 10223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<DataStatusFetcherActor>::operator new;
	using FastAllocated<DataStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16279550182015222784UL, 6812391060990764544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >;
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActor(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 10240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   DataStatusFetcherActorState<DataStatusFetcherActor>(ddWorker, configuration, minStorageReplicasRemaining),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14405987564440952576UL, 17712536245104413440UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dataStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> dataStatusFetcher( WorkerDetails const& ddWorker, DatabaseConfiguration const& configuration, int* const& minStorageReplicasRemaining ) {
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new DataStatusFetcherActor(ddWorker, configuration, minStorageReplicasRemaining));
															#line 10273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 10278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getServerMetrics()
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface, class GetServerMetricsActor>
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActorState {
															#line 10285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActorState(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : servers(servers),
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventNames(eventNames),
															#line 1957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   futures()
															#line 10298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetServerMetricsActorState() 
	{
		fdb_probe_actor_destroy("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto s : servers ) {
															#line 1959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto name : eventNames ) {
															#line 1960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					futures.push_back(latestEventOnWorker(address_workers[s.address()], s.id().toString() + "/" + name));
															#line 10317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 1;
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetServerMetricsActor, 0, Void >*>(static_cast<GetServerMetricsActor*>(this)));
															#line 10329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 1973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 1974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 1973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 1974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 1980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerMetricsActor*>(this)->ActorCallback< GetServerMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetServerMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<iface> servers;
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::string> eventNames;
															#line 1957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<TraceEventFields>>> futures;
															#line 10499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getServerMetrics()
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActor final : public Actor<std::vector<std::pair<iface, EventMap>>>, public ActorCallback< GetServerMetricsActor<iface>, 0, Void >, public FastAllocated<GetServerMetricsActor<iface>>, public GetServerMetricsActorState<iface, GetServerMetricsActor<iface>> {
															#line 10506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetServerMetricsActor<iface>>::operator new;
	using FastAllocated<GetServerMetricsActor<iface>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5186232257770020608UL, 14269453208473433856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<iface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetServerMetricsActor<iface>, 0, Void >;
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActor(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 10523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<iface, EventMap>>>(),
		   GetServerMetricsActorState<iface, GetServerMetricsActor<iface>>(servers, address_workers, eventNames),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10378310344083509504UL, 12687082714580923648UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getServerMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetServerMetricsActor<iface>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<iface, EventMap>>> getServerMetrics( std::vector<iface> const& servers, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, std::vector<std::string> const& eventNames ) {
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<iface, EventMap>>>(new GetServerMetricsActor<iface>(servers, address_workers, eventNames));
															#line 10558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 1982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

namespace {

const std::vector<std::string> STORAGE_SERVER_METRICS_LIST{ "StorageMetrics", "ReadLatencyMetrics", "ReadLatencyBands",
	                                                        "BusiestReadTag", "BusiestWriteTag",    "RocksDBMetrics" };

} // namespace

															#line 10570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetStorageServerStatusInfosActor>
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActorState {
															#line 10577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActorState(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : storageMetadatas(storageMetadatas),
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 1994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   servers()
															#line 10590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServerStatusInfosActorState() 
	{
		fdb_probe_actor_destroy("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers.reserve(storageMetadatas.size());
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( const auto& meta : storageMetadatas ) {
															#line 1997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				servers.push_back(StorageServerStatusInfo(meta));
															#line 10609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results = std::vector<std::pair<StorageServerStatusInfo, EventMap>>();
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(results, getServerMetrics(servers, address_workers, STORAGE_SERVER_METRICS_LIST));
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 1;
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*>(static_cast<GetStorageServerStatusInfosActor*>(this)));
															#line 10622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerStatusInfosActor*>(this)->ActorCallback< GetStorageServerStatusInfosActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerMetaInfo> storageMetadatas;
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 1994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> servers;
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<StorageServerStatusInfo, EventMap>> results;
															#line 10762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActor final : public Actor<std::vector<StorageServerStatusInfo>>, public ActorCallback< GetStorageServerStatusInfosActor, 0, Void >, public FastAllocated<GetStorageServerStatusInfosActor>, public GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor> {
															#line 10767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetStorageServerStatusInfosActor>::operator new;
	using FastAllocated<GetStorageServerStatusInfosActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3224099505609415168UL, 13978903254985316864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerStatusInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServerStatusInfosActor, 0, Void >;
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActor(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 10784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::vector<StorageServerStatusInfo>>(),
		   GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor>(storageMetadatas, address_workers, rkWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14011788060670041344UL, 4151862449577500672UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServerStatusInfos");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<StorageServerStatusInfo>> getStorageServerStatusInfos( std::vector<StorageServerMetaInfo> const& storageMetadatas, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, WorkerDetails const& rkWorker ) {
															#line 1990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<StorageServerStatusInfo>>(new GetStorageServerStatusInfosActor(storageMetadatas, address_workers, rkWorker));
															#line 10817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 10822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetTLogsAndMetricsActor>
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActorState {
															#line 10829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 10838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogsAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::vector<TLogInterface> servers = db->get().logSystemConfig.allPresentLogs();
															#line 2011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<TLogInterface, EventMap>>> __when_expr_0 = getServerMetrics(servers, address_workers, std::vector<std::string>{ "TLogMetrics" });
															#line 2011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*>(static_cast<GetTLogsAndMetricsActor*>(this)));
															#line 10862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 10885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 10897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogsAndMetricsActor*>(this)->ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 10984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActor final : public Actor<std::vector<std::pair<TLogInterface, EventMap>>>, public ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >, public FastAllocated<GetTLogsAndMetricsActor>, public GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor> {
															#line 10989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTLogsAndMetricsActor>::operator new;
	using FastAllocated<GetTLogsAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(876916408794930688UL, 14714338384687767296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TLogInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >;
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<TLogInterface, EventMap>>>(),
		   GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7806185236702080000UL, 16667331025509920768UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogsAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<TLogInterface, EventMap>>> getTLogsAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<TLogInterface, EventMap>>>(new GetTLogsAndMetricsActor(db, address_workers));
															#line 11039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// Returns list of tuples of grv proxy interfaces and their latency metrics
															#line 11045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetCommitProxiesAndMetricsActor>
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActorState {
															#line 11052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<CommitProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics( db->get().client.commitProxies, address_workers, std::vector<std::string>{ "CommitLatencyMetrics", "CommitLatencyBands", "CommitBatchingWindowSize" });
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2021 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*>(static_cast<GetCommitProxiesAndMetricsActor*>(this)));
															#line 11083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActor final : public Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>, public ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >, public FastAllocated<GetCommitProxiesAndMetricsActor>, public GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor> {
															#line 11210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11142020730862133760UL, 3230502815363819264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>(),
		   GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1575106491018932224UL, 2149067258200158208UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<CommitProxyInterface, EventMap>>> getCommitProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<CommitProxyInterface, EventMap>>>(new GetCommitProxiesAndMetricsActor(db, address_workers));
															#line 11260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 11265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetGrvProxiesAndMetricsActor>
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActorState {
															#line 11272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetGrvProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<GrvProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics(db->get().client.grvProxies, address_workers, std::vector<std::string>{ "GRVLatencyMetrics", "GRVLatencyBands", "GRVBatchLatencyMetrics" });
															#line 2032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*>(static_cast<GetGrvProxiesAndMetricsActor*>(this)));
															#line 11303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActor final : public Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>, public ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >, public FastAllocated<GetGrvProxiesAndMetricsActor>, public GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor> {
															#line 11430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3479586947369528832UL, 18403486535164650496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >;
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>(),
		   GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16916602236672483840UL, 15447554200206271744UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getGrvProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<GrvProxyInterface, EventMap>>> getGrvProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<GrvProxyInterface, EventMap>>>(new GetGrvProxiesAndMetricsActor(db, address_workers));
															#line 11480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// Returns the number of zones eligible for recruiting new tLogs after zone failures, to maintain the current
// replication factor.
static int getExtraTLogEligibleZones(const std::vector<WorkerDetails>& workers,
                                     const DatabaseConfiguration& configuration) {
	std::set<StringRef> allZones;
	std::map<Key, std::set<StringRef>> dcId_zone;
	for (auto const& worker : workers) {
		if (worker.processClass.machineClassFitness(ProcessClass::TLog) < ProcessClass::NeverAssign &&
		    !configuration.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
			allZones.insert(worker.interf.locality.zoneId().get());
			if (worker.interf.locality.dcId().present()) {
				dcId_zone[worker.interf.locality.dcId().get()].insert(worker.interf.locality.zoneId().get());
			}
		}
	}

	if (configuration.regions.size() == 0) {
		return allZones.size() - std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize);
	}

	int extraTlogEligibleZones = 0;
	int regionsWithNonNegativePriority = 0;
	int maxRequiredReplicationFactor =
	    std::max(configuration.remoteTLogReplicationFactor,
	             std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize));
	for (const auto& region : configuration.regions) {
		if (region.priority >= 0) {
			int eligible = dcId_zone[region.dcId].size() - maxRequiredReplicationFactor;

			// FIXME: does not take into account fallback satellite policies
			if (region.satelliteTLogReplicationFactor > 0 && configuration.usableRegions > 1) {
				int totalSatelliteEligible = 0;
				for (const auto& sat : region.satellites) {
					totalSatelliteEligible += dcId_zone[sat.dcId].size();
				}
				eligible = std::min<int>(eligible, totalSatelliteEligible - region.satelliteTLogReplicationFactor);
			}
			if (eligible >= 0) {
				regionsWithNonNegativePriority++;
			}
			extraTlogEligibleZones = std::max(extraTlogEligibleZones, eligible);
		}
	}
	if (regionsWithNonNegativePriority > 1) {
		// If the database is replicated across multiple regions, we can afford to lose one entire region without
		// losing data.
		extraTlogEligibleZones++;
	}
	return extraTlogEligibleZones;
}

JsonBuilderObject getPerfLimit(TraceEventFields const& ratekeeper, double transPerSec, double tpsLimit) {
	int reason = ratekeeper.getInt("Reason");
	JsonBuilderObject perfLimit;

	if (transPerSec > tpsLimit * 0.8) {
		// If reason is known, set qos.performance_limited_by, otherwise omit
		if (reason >= 0 && reason < limitReasonEnd) {
			perfLimit = JsonString::makeMessage(limitReasonName[reason], limitReasonDesc[reason]);
			std::string reason_server_id = ratekeeper.getValue("ReasonServerID");
			if (!reason_server_id.empty())
				perfLimit["reason_server_id"] = reason_server_id;
		}
	} else {
		perfLimit = JsonString::makeMessage("workload", "The database is not being saturated by the workload.");
	}

	if (!perfLimit.empty()) {
		perfLimit["reason_id"] = reason;
	}

	return perfLimit;
}

															#line 11559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workloadStatusFetcher()
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class WorkloadStatusFetcherActor>
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActorState {
															#line 11566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   qos(qos),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   data_overlay(data_overlay),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   operationsObj(),
															#line 2124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   bytesObj(),
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   keysObj()
															#line 11595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				commitProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				grvProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::map<NetworkAddress, WorkerDetails> workersMap;
															#line 2132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto const& w : workers ) {
															#line 2133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					workersMap[w.interf.address()] = w;
															#line 11619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.commitProxies ) {
															#line 2136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 2138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						commitProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("ProxyMetrics"_sr)), 1.0));
															#line 11631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
				}
															#line 2143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.grvProxies ) {
															#line 2144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					{
															#line 2146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						grvProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("GrvProxyMetrics"_sr)), 1.0));
															#line 11650 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
					}
				}
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(commitProxyStatFutures);
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			f1 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdate"_sr)), 1.0);
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			f2 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdateBatch"_sr)), 1.0);
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(f1) && success(f2);
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 2, Void >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown mutations, conflicts, and transactions state.");
															#line 11733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::vector<TraceEventFields>> __when_expr_1 = getAll(grvProxyStatFutures);
															#line 2152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11755 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& __commitProxyStats,int loopDepth) 
	{
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxyStats = __commitProxyStats;
															#line 11764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && __commitProxyStats,int loopDepth) 
	{
		commitProxyStats = std::move(__commitProxyStats);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnStartOut;
															#line 2155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnSystemPriorityStartOut;
															#line 2156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnDefaultPriorityStartOut;
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnBatchPriorityStartOut;
															#line 2159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutations;
															#line 2160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutationBytes;
															#line 2161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnConflicts;
															#line 2162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnRejectedForQueuedTooLong;
															#line 2163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnCommitOutSuccess;
															#line 2164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnKeyLocationOut;
															#line 2165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnMemoryErrors;
															#line 2167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& gps : grvProxyStats ) {
															#line 2168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnStartOut.updateValues(StatusCounter(gps.getValue("TxnStartOut")));
															#line 2169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnSystemPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnSystemPriorityStartOut")));
															#line 2170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnDefaultPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnDefaultPriorityStartOut")));
															#line 2171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnBatchPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnBatchPriorityStartOut")));
															#line 2172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(gps.getValue("TxnRequestErrors")));
															#line 11875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& cps : commitProxyStats ) {
															#line 2176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			mutations.updateValues(StatusCounter(cps.getValue("Mutations")));
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			mutationBytes.updateValues(StatusCounter(cps.getValue("MutationBytes")));
															#line 2178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnConflicts.updateValues(StatusCounter(cps.getValue("TxnConflicts")));
															#line 2179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnRejectedForQueuedTooLong.updateValues(StatusCounter(cps.getValue("TxnRejectedForQueuedTooLong")));
															#line 2180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnCommitOutSuccess.updateValues(StatusCounter(cps.getValue("TxnCommitOutSuccess")));
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnKeyLocationOut.updateValues(StatusCounter(cps.getValue("KeyServerLocationOut")));
															#line 2182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("KeyServerLocationErrors")));
															#line 2183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("TxnCommitErrors")));
															#line 11895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["writes"] = mutations.getStatus();
															#line 2187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["location_requests"] = txnKeyLocationOut.getStatus();
															#line 2188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["memory_errors"] = txnMemoryErrors.getStatus();
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["written"] = mutationBytes.getStatus();
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject transactions;
															#line 2192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["conflicted"] = txnConflicts.getStatus();
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started"] = txnStartOut.getStatus();
															#line 2194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["rejected_for_queued_too_long"] = txnRejectedForQueuedTooLong.getStatus();
															#line 2195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_immediate_priority"] = txnSystemPriorityStartOut.getStatus();
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_default_priority"] = txnDefaultPriorityStartOut.getStatus();
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_batch_priority"] = txnBatchPriorityStartOut.getStatus();
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["committed"] = txnCommitOutSuccess.getStatus();
															#line 2200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["transactions"] = transactions;
															#line 11923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> const& __grvProxyStats,int loopDepth) 
	{
															#line 2152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxyStats = __grvProxyStats;
															#line 11932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> && __grvProxyStats,int loopDepth) 
	{
		grvProxyStats = std::move(__grvProxyStats);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_3 = storageServerFuture;
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 12027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont11Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont11when1(__when_expr_3.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 12032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown performance state.");
															#line 12056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2242 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 2328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["operations"] = operationsObj;
															#line 2329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["keys"] = keysObj;
															#line 2330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bytes"] = bytesObj;
															#line 2332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<WorkloadStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~WorkloadStatusFetcherActorState(); static_cast<WorkloadStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 12425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<WorkloadStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2325 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown read state.");
															#line 12446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12461 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* qos;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* data_overlay;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject operationsObj;
															#line 2124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject bytesObj;
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject keysObj;
															#line 2129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> commitProxyStatFutures;
															#line 2130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> grvProxyStatFutures;
															#line 2151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> commitProxyStats;
															#line 2152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> grvProxyStats;
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f1;
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f2;
															#line 12693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workloadStatusFetcher()
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 2, Void >, public ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >, public FastAllocated<WorkloadStatusFetcherActor>, public WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor> {
															#line 12698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkloadStatusFetcherActor>::operator new;
	using FastAllocated<WorkloadStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14295616589661819136UL, 4826188364116509952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 2, Void >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >;
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 12718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor>(db, workers, mWorker, rkWorker, qos, data_overlay, incomplete_reasons, storageServerFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1285460558980581376UL, 3509738831502872832UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workloadStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> workloadStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerDetails const& mWorker, WorkerDetails const& rkWorker, JsonBuilderObject* const& qos, JsonBuilderObject* const& data_overlay, std::set<std::string>* const& incomplete_reasons, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture ) {
															#line 2113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new WorkloadStatusFetcherActor(db, workers, mWorker, rkWorker, qos, data_overlay, incomplete_reasons, storageServerFuture));
															#line 12754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 12759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ClusterSummaryStatisticsFetcherActor>
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActorState {
															#line 12766 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActorState(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : pMetrics(pMetrics),
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tlogFuture(tlogFuture),
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 12781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ClusterSummaryStatisticsFetcherActorState() 
	{
		fdb_probe_actor_destroy("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				cacheStatistics = JsonBuilderObject();
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_0 = storageServerFuture;
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 1;
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 12806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~ClusterSummaryStatisticsFetcherActorState(); static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->destroy(); return 0; }
															#line 12835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown cache statistics.");
															#line 12856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 12875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 12887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 12899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 12913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 12926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 12938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 12950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 12964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
															#line 2369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
															#line 2369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2370 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13096 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2380 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 2387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(tlogServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tlogServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> tlogFuture;
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject cacheStatistics;
															#line 13232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >, public FastAllocated<ClusterSummaryStatisticsFetcherActor>, public ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor> {
															#line 13237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator new;
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12127452922599125504UL, 8941699446449702912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >;
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >;
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActor(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 13255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor>(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10444091789670181888UL, 658604576535158016UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterSummaryStatisticsFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> clusterSummaryStatisticsFetcher( WorkerEvents const& pMetrics, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture, Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture, std::set<std::string>* const& incomplete_reasons ) {
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ClusterSummaryStatisticsFetcherActor(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons));
															#line 13289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject tlogFetcher(int* logFaultTolerance,
                                     const std::vector<TLogSet>& tLogs,
                                     std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderObject statusObj;
	JsonBuilderArray logsObj;
	Optional<int32_t> sat_log_replication_factor, sat_log_write_anti_quorum, sat_log_fault_tolerance,
	    log_replication_factor, log_write_anti_quorum, log_fault_tolerance, remote_log_replication_factor,
	    remote_log_fault_tolerance;

	int minFaultTolerance = 1000;
	int localSetsWithNonNegativeFaultTolerance = 0;

	for (const auto& tLogSet : tLogs) {
		if (tLogSet.tLogs.size() == 0) {
			// We can have LogSets where there are no tLogs but some LogRouters. It's the way
			// recruiting is implemented for old LogRouters in TagPartitionedLogSystem, where
			// it adds an empty LogSet for missing locality.
			continue;
		}

		int failedLogs = 0;
		for (auto& log : tLogSet.tLogs) {
			JsonBuilderObject logObj;
			bool failed = !log.present() || !address_workers.contains(log.interf().address());
			logObj["id"] = log.id().shortString();
			logObj["healthy"] = !failed;
			if (log.present()) {
				logObj["address"] = log.interf().address().toString();
			}
			logsObj.push_back(logObj);
			if (failed) {
				failedLogs++;
			}
		}

		if (tLogSet.isLocal) {
			ASSERT_WE_THINK(tLogSet.tLogReplicationFactor > 0);
			int currentFaultTolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
			if (currentFaultTolerance >= 0) {
				localSetsWithNonNegativeFaultTolerance++;
			}

			if (tLogSet.locality == tagLocalitySatellite) {
				// FIXME: This hack to bump satellite fault tolerance, is to make it consistent
				//  with 6.2.
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance + 1);
			} else {
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance);
			}
		}

		if (tLogSet.isLocal && tLogSet.locality == tagLocalitySatellite) {
			sat_log_replication_factor = tLogSet.tLogReplicationFactor;
			sat_log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			sat_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else if (tLogSet.isLocal) {
			log_replication_factor = tLogSet.tLogReplicationFactor;
			log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else {
			remote_log_replication_factor = tLogSet.tLogReplicationFactor;
			remote_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - failedLogs;
		}
	}
	if (minFaultTolerance == 1000) {
		// just in case we do not have any tlog sets
		minFaultTolerance = 0;
	}
	if (localSetsWithNonNegativeFaultTolerance > 1) {
		minFaultTolerance++;
	}
	*logFaultTolerance = std::min(*logFaultTolerance, minFaultTolerance);
	statusObj["log_interfaces"] = logsObj;
	// We may lose logs in this log generation, storage servers may never be able to catch up this log
	// generation.
	statusObj["possibly_losing_data"] = minFaultTolerance < 0;

	if (sat_log_replication_factor.present())
		statusObj["satellite_log_replication_factor"] = sat_log_replication_factor.get();
	if (sat_log_write_anti_quorum.present())
		statusObj["satellite_log_write_anti_quorum"] = sat_log_write_anti_quorum.get();
	if (sat_log_fault_tolerance.present())
		statusObj["satellite_log_fault_tolerance"] = sat_log_fault_tolerance.get();

	if (log_replication_factor.present())
		statusObj["log_replication_factor"] = log_replication_factor.get();
	if (log_write_anti_quorum.present())
		statusObj["log_write_anti_quorum"] = log_write_anti_quorum.get();
	if (log_fault_tolerance.present())
		statusObj["log_fault_tolerance"] = log_fault_tolerance.get();

	if (remote_log_replication_factor.present())
		statusObj["remote_log_replication_factor"] = remote_log_replication_factor.get();
	if (remote_log_fault_tolerance.present())
		statusObj["remote_log_fault_tolerance"] = remote_log_fault_tolerance.get();

	return statusObj;
}

static JsonBuilderArray tlogFetcher(int* logFaultTolerance,
                                    Reference<AsyncVar<ServerDBInfo>> db,
                                    std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderArray tlogsArray;
	JsonBuilderObject tlogsStatus;

	// First, fetch from the current TLog generation.
	tlogsStatus = tlogFetcher(logFaultTolerance, db->get().logSystemConfig.tLogs, address_workers);
	tlogsStatus["epoch"] = db->get().logSystemConfig.epoch;
	tlogsStatus["current"] = true;
	if (db->get().logSystemConfig.recoveredAt.present()) {
		tlogsStatus["begin_version"] = db->get().logSystemConfig.recoveredAt.get();
	}
	tlogsArray.push_back(tlogsStatus);

	// fetch all the old generations of TLogs.
	for (auto it : db->get().logSystemConfig.oldTLogs) {
		JsonBuilderObject oldTlogsStatus = tlogFetcher(logFaultTolerance, it.tLogs, address_workers);
		oldTlogsStatus["epoch"] = it.epoch;
		oldTlogsStatus["current"] = false;
		oldTlogsStatus["begin_version"] = it.epochBegin;
		oldTlogsStatus["end_version"] = it.epochEnd;
		tlogsArray.push_back(oldTlogsStatus);
	}
	return tlogsArray;
}

static JsonBuilderObject faultToleranceStatusFetcher(DatabaseConfiguration configuration,
                                                     ServerCoordinators coordinators,
                                                     const std::vector<NetworkAddress>& coordinatorAddresses,
                                                     const std::vector<WorkerDetails>& workers,
                                                     int extraTlogEligibleZones,
                                                     int minStorageReplicasRemaining,
                                                     int oldLogFaultTolerance,
                                                     int fullyReplicatedRegions,
                                                     bool underMaintenance) {
	JsonBuilderObject statusObj;

	// without losing data
	int32_t maxZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, false);
	if (underMaintenance) {
		maxZoneFailures--;
	}
	int maxCoordinatorFailures = (coordinators.clientLeaderServers.size() - 1) / 2;

	std::map<NetworkAddress, StringRef> workerZones;
	for (const auto& worker : workers) {
		workerZones[worker.interf.address()] = worker.interf.locality.zoneId().orDefault(""_sr);
	}
	std::map<StringRef, int> coordinatorZoneCounts;
	for (const auto& coordinator : coordinatorAddresses) {
		auto zone = workerZones[coordinator];
		coordinatorZoneCounts[zone] += 1;
	}
	std::vector<std::pair<StringRef, int>> coordinatorZones(coordinatorZoneCounts.begin(), coordinatorZoneCounts.end());
	std::sort(coordinatorZones.begin(),
	          coordinatorZones.end(),
	          [](const std::pair<StringRef, int>& lhs, const std::pair<StringRef, int>& rhs) {
		          return lhs.second > rhs.second;
	          });
	int lostCoordinators = 0;
	int maxCoordinatorZoneFailures = 0;
	for (auto zone : coordinatorZones) {
		lostCoordinators += zone.second;
		if (lostCoordinators > maxCoordinatorFailures) {
			break;
		}
		maxCoordinatorZoneFailures += 1;
	}
	// max zone failures that we can tolerate to not lose data
	int zoneFailuresWithoutLosingData = std::min(maxZoneFailures, maxCoordinatorZoneFailures);

	if (minStorageReplicasRemaining >= 0) {
		zoneFailuresWithoutLosingData = std::min(zoneFailuresWithoutLosingData, minStorageReplicasRemaining - 1);
	}

	// oldLogFaultTolerance means max failures we can tolerate to lose logs data. -1 means we lose data or
	// availability.
	zoneFailuresWithoutLosingData = std::max(std::min(zoneFailuresWithoutLosingData, oldLogFaultTolerance), -1);
	statusObj["max_zone_failures_without_losing_data"] = zoneFailuresWithoutLosingData;

	int32_t maxAvaiabilityZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, true);
	if (underMaintenance) {
		maxAvaiabilityZoneFailures--;
	}

	statusObj["max_zone_failures_without_losing_availability"] = std::max(
	    std::min(maxAvaiabilityZoneFailures, std::min(extraTlogEligibleZones, zoneFailuresWithoutLosingData)), -1);
	return statusObj;
}

static std::string getIssueDescription(std::string name) {
	if (name == "incorrect_cluster_file_contents") {
		return "Cluster file contents do not match current cluster connection string. Verify the cluster file and "
		       "its "
		       "parent directory are writable and that the cluster file has not been overwritten externally.";
	}

	// FIXME: name and description will be the same unless the message is 'incorrect_cluster_file_contents', which
	// is currently the only possible message
	return name;
}

static std::map<std::string, std::vector<JsonBuilderObject>> getProcessIssuesAsMessages(
    std::vector<ProcessIssues> const& issues) {
	std::map<std::string, std::vector<JsonBuilderObject>> issuesMap;

	try {
		for (auto processIssues : issues) {
			for (auto issue : processIssues.issues) {
				std::string issueStr = issue.toString();
				issuesMap[processIssues.address.toString()].push_back(
				    JsonString::makeMessage(issueStr.c_str(), getIssueDescription(issueStr).c_str()));
			}
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingProcessIssues").error(e);
		// swallow
	}

	return issuesMap;
}

static JsonBuilderArray getClientIssuesAsMessages(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderArray issuesList;

	try {
		std::map<std::string, std::pair<int, std::vector<std::string>>> deduplicatedIssues;

		for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
			if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
				iter = clientStatusMap->erase(iter);
				continue;
			}

			for (const auto& [issueKey, samples] : iter->second.second.issues) {
				auto& t = deduplicatedIssues[issueKey.toString()];
				t.first += samples.count;
				for (const auto& sample : samples.samples) {
					t.second.push_back(formatIpPort(sample.first.ip, sample.first.port));
				}
			}
			++iter;
		}

		// FIXME: add the log_group in addition to the network address
		for (auto i : deduplicatedIssues) {
			JsonBuilderObject message = JsonString::makeMessage(i.first.c_str(), getIssueDescription(i.first).c_str());
			JsonBuilderArray addresses;
			for (auto addr : i.second.second) {
				addresses.push_back(addr);
			}

			message["count"] = i.second.first;
			message["addresses"] = addresses;
			issuesList.push_back(message);
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingClientIssues").error(e);
		// swallow
	}

	return issuesList;
}

															#line 13559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via layerStatusFetcher()
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LayerStatusFetcherActor>
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActorState {
															#line 13566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 2669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   json(result),
															#line 2670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tStart(now())
															#line 13583 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LayerStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = ReadYourWritesTransaction(cx);
															#line 2674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 13601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.cleanOps();
															#line 2725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject statusObj;
															#line 2726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj.addContents(result);
															#line 2727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEvent("LayerStatusFetcher") .detail("Duration", now() - tStart) .detail("StatusSize", statusObj.getFinalLength());
															#line 2730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LayerStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LayerStatusFetcherActorState(); static_cast<LayerStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 13638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LayerStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(statusObj);
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusError").error(e);
															#line 2716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve layer status (%s).", e.what()));
															#line 2720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_error") = format("Unable to retrieve layer status (%s).", e.what());
															#line 2721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_valid") = false;
															#line 13665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t timeout_ms = 3000;
															#line 2678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::TIMEOUT, StringRef((uint8_t*)&timeout_ms, sizeof(int64_t)));
															#line 2680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string jsonPrefix = layerStatusMetaPrefixRange.begin.toString() + "json/";
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(jsonPrefix, strinc(jsonPrefix)), 1000);
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 13709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 2711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 4, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 13751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& jsonLayers,int loopDepth) 
	{
															#line 2684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 13772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 13780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && jsonLayers,int loopDepth) 
	{
															#line 2684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 13795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2690 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 13803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(jsonLayers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(jsonLayers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.create("_valid") = true;
															#line 13887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(i < docFutures.size()))
															#line 13903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = docFutures[i];
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 13916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		j = int();
															#line 2696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		j = 0;
															#line 13940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& __docs,int loopDepth) 
	{
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docs = __docs;
															#line 13949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && __docs,int loopDepth) 
	{
		docs = std::move(__docs);
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++i;
															#line 14028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(j < docs.size()))
															#line 14044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		doc = json_spirit::mValue();
															#line 14050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 2699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json_spirit::read_string(docs[j].value.toString(), doc);
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yield();
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 2, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 14063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++j;
															#line 14091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusBadJSON").detail("Key", docs[j].key);
															#line 14101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 14125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 14143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	StatusObject result;
															#line 2669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JSONDoc json;
															#line 2670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double tStart;
															#line 2673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2684 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<RangeResult>> docFutures;
															#line 2685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int i;
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RangeResult docs;
															#line 2695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int j;
															#line 2697 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	json_spirit::mValue doc;
															#line 14447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via layerStatusFetcher()
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LayerStatusFetcherActor, 0, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 1, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 2, Void >, public ActorCallback< LayerStatusFetcherActor, 3, Void >, public ActorCallback< LayerStatusFetcherActor, 4, Void >, public FastAllocated<LayerStatusFetcherActor>, public LayerStatusFetcherActorState<LayerStatusFetcherActor> {
															#line 14452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LayerStatusFetcherActor>::operator new;
	using FastAllocated<LayerStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5540409732907263488UL, 8371559316477424896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LayerStatusFetcherActor, 0, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 1, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 2, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 3, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 4, Void >;
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 14473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   LayerStatusFetcherActorState<LayerStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17036008822344536576UL, 14869839289433060096UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("layerStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> layerStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LayerStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 14510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 14515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via lockedStatusFetcher()
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LockedStatusFetcherActor>
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActorState {
															#line 14522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(5),
															#line 2740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   getTimeout(delay(timeoutSeconds))
															#line 14541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LockedStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 14556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LockedStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LockedStatusFetcherActorState(); static_cast<LockedStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 14579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<LockedStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2743 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2745 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 14602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		try {
															#line 2748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(databaseLockedKey);
															#line 2747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getTimeout;
															#line 14612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 2757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 1, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 14619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 2765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 14657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 2, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 14662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& lockUID,int loopDepth) 
	{
															#line 2749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 14689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 14695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 14701 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && lockUID,int loopDepth) 
	{
															#line 2749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 14711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 14717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 14723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 14733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2758 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 14742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >::remove();
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 14883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to determine if database is locked (%s).", e.what()));
															#line 14887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 2739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 2740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getTimeout;
															#line 15012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via lockedStatusFetcher()
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< LockedStatusFetcherActor, 1, Void >, public ActorCallback< LockedStatusFetcherActor, 2, Void >, public FastAllocated<LockedStatusFetcherActor>, public LockedStatusFetcherActorState<LockedStatusFetcherActor> {
															#line 15017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<LockedStatusFetcherActor>::operator new;
	using FastAllocated<LockedStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8348034615623777536UL, 14558632381422770432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< LockedStatusFetcherActor, 1, Void >;
friend struct ActorCallback< LockedStatusFetcherActor, 2, Void >;
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 15036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   LockedStatusFetcherActorState<LockedStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14369978241092976128UL, 3028260835526008320UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockedStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> lockedStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LockedStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 15070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 15075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getActivePrimaryDC()
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetActivePrimaryDCActor>
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActorState {
															#line 15082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActorState(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   fullyReplicatedRegions(fullyReplicatedRegions),
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   readTimeout(delay(5))
															#line 15097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	~GetActivePrimaryDCActorState() 
	{
		fdb_probe_actor_destroy("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 15112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (readTimeout.isReady())
															#line 15143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2785 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1loopBody1Catch1(timed_out(), loopDepth);
															#line 15147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			fReplicaKeys = tr.getRange(datacenterReplicasKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			fPrimaryDatacenterKey = tr.get(primaryDatacenterKey);
															#line 2791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(success(fPrimaryDatacenterKey) && success(fReplicaKeys), 5);
															#line 2791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 1;
															#line 2791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 0, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 15166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 15188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("fetch_primary_dc_timeout", "Fetching primary DC timed out."));
															#line 2804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 15194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
				this->~GetActivePrimaryDCActorState();
				static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 2;
															#line 2806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 1, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 15211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 15229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 15233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 15237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 15251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 15255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 15259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* fullyReplicatedRegions;
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> readTimeout;
															#line 2789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> fReplicaKeys;
															#line 2790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> fPrimaryDatacenterKey;
															#line 15449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getActivePrimaryDC()
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActor final : public Actor<Optional<Value>>, public ActorCallback< GetActivePrimaryDCActor, 0, Void >, public ActorCallback< GetActivePrimaryDCActor, 1, Void >, public FastAllocated<GetActivePrimaryDCActor>, public GetActivePrimaryDCActorState<GetActivePrimaryDCActor> {
															#line 15454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetActivePrimaryDCActor>::operator new;
	using FastAllocated<GetActivePrimaryDCActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2381782224936670208UL, 9575591475100210944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActivePrimaryDCActor, 0, Void >;
friend struct ActorCallback< GetActivePrimaryDCActor, 1, Void >;
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActor(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 15472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   GetActivePrimaryDCActorState<GetActivePrimaryDCActor>(cx, fullyReplicatedRegions, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11163384421170287360UL, 3820190715572017408UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActivePrimaryDC");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getActivePrimaryDC( Database const& cx, int* const& fullyReplicatedRegions, JsonBuilderArray* const& messages ) {
															#line 2778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<Value>>(new GetActivePrimaryDCActor(cx, fullyReplicatedRegions, messages));
															#line 15506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 15511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readStorageWiggleMetrics()
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ReadStorageWiggleMetricsActor>
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ReadStorageWiggleMetricsActorState {
															#line 15518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadStorageWiggleMetricsActorState(Database const& cx,bool const& use_system_priority) 
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 2815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 2816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   primaryV(),
															#line 2817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   remoteV(),
															#line 2818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   wiggleState()
															#line 15535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	~ReadStorageWiggleMetricsActorState() 
	{
		fdb_probe_actor_destroy("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2819 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 15550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (use_system_priority)
															#line 15581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 15585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(primaryV, wiggleState.storageWiggleMetrics(PrimaryRegion(true)).get(tr)) && store(remoteV, wiggleState.storageWiggleMetrics(PrimaryRegion(false)).get(tr));
															#line 2826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 1;
															#line 2826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 15600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 2830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 2;
															#line 2830 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 15629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 15644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 15656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool use_system_priority;
															#line 2815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<StorageWiggleMetrics> primaryV;
															#line 2817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<StorageWiggleMetrics> remoteV;
															#line 2818 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	StorageWiggleData wiggleState;
															#line 15838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readStorageWiggleMetrics()
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ReadStorageWiggleMetricsActor final : public Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>, public ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >, public ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >, public FastAllocated<ReadStorageWiggleMetricsActor>, public ReadStorageWiggleMetricsActorState<ReadStorageWiggleMetricsActor> {
															#line 15843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadStorageWiggleMetricsActor>::operator new;
	using FastAllocated<ReadStorageWiggleMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7622803120665344512UL, 16518162252839464960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >;
friend struct ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >;
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadStorageWiggleMetricsActor(Database const& cx,bool const& use_system_priority) 
															#line 15861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>(),
		   ReadStorageWiggleMetricsActorState<ReadStorageWiggleMetricsActor>(cx, use_system_priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14092575410789312000UL, 17117368816633130496UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readStorageWiggleMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>> readStorageWiggleMetrics( Database const& cx, bool const& use_system_priority ) {
															#line 2812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>(new ReadStorageWiggleMetricsActor(cx, use_system_priority));
															#line 15895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// read storageWigglerStats through Read-only tx, then convert it to JSON field
															#line 15901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via storageWigglerStatsFetcher()
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class StorageWigglerStatsFetcherActor>
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class StorageWigglerStatsFetcherActorState {
															#line 15908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	StorageWigglerStatsFetcherActorState(Optional<DataDistributorInterface> const& ddWorker,DatabaseConfiguration const& conf,Database const& cx,bool const& use_system_priority,JsonBuilderArray* const& messages) 
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : ddWorker(ddWorker),
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   conf(conf),
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   stateFut(),
															#line 2843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   wiggleMetricsFut(timeoutError(readStorageWiggleMetrics(cx, use_system_priority), 2.0)),
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   res()
															#line 15929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this));

	}
	~StorageWigglerStatsFetcherActorState() 
	{
		fdb_probe_actor_destroy("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (ddWorker.present())
															#line 15944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateFut = timeoutError(ddWorker.get().storageWigglerState.getReply(GetStorageWigglerStateRequest()), 2.0);
															#line 2848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ready(stateFut);
															#line 2848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 1;
															#line 2848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*>(static_cast<StorageWigglerStatsFetcherActor*>(this)));
															#line 15957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 15964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
				this->~StorageWigglerStatsFetcherActorState();
				static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 2854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))
															#line 15992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1cont1Catch1(timed_out(), loopDepth);
															#line 15996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(wiggleMetricsFut) && success(stateFut);
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 16002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*>(static_cast<StorageWigglerStatsFetcherActor*>(this)));
															#line 16007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state > 0) static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<StorageWigglerStatsFetcherActor*>(this)->ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 16109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 2880 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("fetch_storage_wiggler_stats_timeout", "Fetching storage wiggler stats timed out."));
															#line 16130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto [primaryV, remoteV] = wiggleMetricsFut.get();
															#line 2860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (primaryV.present())
															#line 16147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = primaryV.get().toJSON();
															#line 2862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 2863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.primary));
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangePrimary;
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangePrimary);
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res["primary"] = obj;
															#line 16161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (conf.regions.size() > 1 && remoteV.present())
															#line 16165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = remoteV.get().toJSON();
															#line 2870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.remote));
															#line 2872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangeRemote;
															#line 2873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangeRemote);
															#line 2874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res["remote"] = obj;
															#line 16179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 16183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto [primaryV, remoteV] = wiggleMetricsFut.get();
															#line 2860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (primaryV.present())
															#line 16197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = primaryV.get().toJSON();
															#line 2862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 2863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.primary));
															#line 2864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangePrimary;
															#line 2865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangePrimary);
															#line 2866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res["primary"] = obj;
															#line 16211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (conf.regions.size() > 1 && remoteV.present())
															#line 16215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 2869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto obj = remoteV.get().toJSON();
															#line 2870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto& reply = stateFut.get();
															#line 2871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["state"] = StorageWiggler::getWiggleStateStr(static_cast<StorageWiggler::State>(reply.remote));
															#line 2872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_timestamp"] = reply.lastStateChangeRemote;
															#line 2873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			obj["last_state_change_datetime"] = epochsToGMTString(reply.lastStateChangeRemote);
															#line 2874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res["remote"] = obj;
															#line 16229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 2876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(res); this->~StorageWigglerStatsFetcherActorState(); static_cast<StorageWigglerStatsFetcherActor*>(this)->destroy(); return 0; }
															#line 16233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		new (&static_cast<StorageWigglerStatsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(res)); // state_var_RVO
		this->~StorageWigglerStatsFetcherActorState();
		static_cast<StorageWigglerStatsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state > 0) static_cast<StorageWigglerStatsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<StorageWigglerStatsFetcherActor*>(this)->ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DataDistributorInterface> ddWorker;
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DatabaseConfiguration conf;
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool use_system_priority;
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<GetStorageWigglerStateReply> stateFut;
															#line 2843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>> wiggleMetricsFut;
															#line 2845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject res;
															#line 16332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
};
// This generated class is to be used only via storageWigglerStatsFetcher()
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class StorageWigglerStatsFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >, public ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >, public FastAllocated<StorageWigglerStatsFetcherActor>, public StorageWigglerStatsFetcherActorState<StorageWigglerStatsFetcherActor> {
															#line 16337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
	using FastAllocated<StorageWigglerStatsFetcherActor>::operator new;
	using FastAllocated<StorageWigglerStatsFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10052707030149809408UL, 4928949192899853056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >;
friend struct ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >;
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	StorageWigglerStatsFetcherActor(Optional<DataDistributorInterface> const& ddWorker,DatabaseConfiguration const& conf,Database const& cx,bool const& use_system_priority,JsonBuilderArray* const& messages) 
															#line 16355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   StorageWigglerStatsFetcherActorState<StorageWigglerStatsFetcherActor>(ddWorker, conf, cx, use_system_priority, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4661988479812632320UL, 8175584891990373120UL);
		ActorExecutionContextHelper __helper(static_cast<StorageWigglerStatsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageWigglerStatsFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageWigglerStatsFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageWigglerStatsFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageWigglerStatsFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> storageWigglerStatsFetcher( Optional<DataDistributorInterface> const& ddWorker, DatabaseConfiguration const& conf, Database const& cx, bool const& use_system_priority, JsonBuilderArray* const& messages ) {
															#line 2836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new StorageWigglerStatsFetcherActor(ddWorker, conf, cx, use_system_priority, messages));
															#line 16389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
}

#line 2885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// constructs the cluster section of the json status output
															#line 16395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterGetStatus()
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ClusterGetStatusActor>
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ClusterGetStatusActorState {
															#line 16402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
public:
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ClusterGetStatusActorState(Reference<AsyncVar<ServerDBInfo>> const& db,Database const& cx,std::vector<WorkerDetails> const& workers,std::vector<ProcessIssues> const& workerIssues,std::vector<StorageServerMetaInfo> const& storageMetadatas,std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* const& clientStatus,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& incompatibleConnections,Version const& datacenterVersionDifference,Version const& dcLogServerVersionDifference,Version const& dcStorageServerVersionDifference,ConfigBroadcaster const* const& configBroadcaster,std::unordered_map<NetworkAddress, double> const& excludedDegradedServers) 
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workerIssues(workerIssues),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageMetadatas(storageMetadatas),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   clientStatus(clientStatus),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   coordinators(coordinators),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incompatibleConnections(incompatibleConnections),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   datacenterVersionDifference(datacenterVersionDifference),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   dcLogServerVersionDifference(dcLogServerVersionDifference),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   dcStorageServerVersionDifference(dcStorageServerVersionDifference),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 2887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   excludedDegradedServers(excludedDegradedServers),
															#line 2902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tStart(timer()),
															#line 2904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(),
															#line 2905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   status_incomplete_reasons(),
															#line 2906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(),
															#line 2907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(),
															#line 2908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ddWorker(),
															#line 2909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(),
															#line 2910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   csWorker()
															#line 16449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterGetStatus", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetStatusActorState() 
	{
		fdb_probe_actor_destroy("clusterGetStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj = JsonBuilderObject();
															#line 2917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Optional<WorkerDetails> _mWorker = getWorker(workers, db->get().master.address());
															#line 2918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (_mWorker.present())
															#line 16469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					mWorker = _mWorker.get();
															#line 16473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages.push_back( JsonString::makeMessage("unreachable_master_worker", "Unable to locate the master worker."));
															#line 16479 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2926 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Optional<WorkerDetails> _ccWorker = getWorker(workers, db->get().clusterInterface.address());
															#line 2927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (_ccWorker.present())
															#line 16485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ccWorker = _ccWorker.get();
															#line 16489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages.push_back(JsonString::makeMessage("unreachable_cluster_controller_worker", "Unable to locate the cluster-controller worker."));
															#line 16495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Optional<WorkerDetails> _ddWorker;
															#line 2936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (db->get().distributor.present())
															#line 16501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					_ddWorker = getWorker(workers, db->get().distributor.get().address());
															#line 16505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!db->get().distributor.present() || !_ddWorker.present())
															#line 16509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages.push_back(JsonString::makeMessage("unreachable_dataDistributor_worker", "Unable to locate the data distributor worker."));
															#line 16513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ddWorker = _ddWorker.get();
															#line 16519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2948 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Optional<WorkerDetails> _rkWorker;
															#line 2949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (db->get().ratekeeper.present())
															#line 16525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					_rkWorker = getWorker(workers, db->get().ratekeeper.get().address());
															#line 16529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!db->get().ratekeeper.present() || !_rkWorker.present())
															#line 16533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages.push_back( JsonString::makeMessage("unreachable_ratekeeper_worker", "Unable to locate the ratekeeper worker."));
															#line 16537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					rkWorker = _rkWorker.get();
															#line 16543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Optional<WorkerDetails> _csWorker;
															#line 2962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (db->get().consistencyScan.present())
															#line 16549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2963 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					_csWorker = getWorker(workers, db->get().consistencyScan.get().address());
															#line 16553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!db->get().consistencyScan.present() || !_csWorker.present())
															#line 16557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 2967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages.push_back(JsonString::makeMessage("unreachable_consistencyScan_worker", "Unable to locate the consistencyScan worker."));
															#line 16561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					csWorker = _csWorker.get();
															#line 16567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
															#line 2976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>>> futures;
															#line 2977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestEventOnWorkers(workers, "MachineMetrics"));
															#line 2978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestEventOnWorkers(workers, "ProcessMetrics"));
															#line 2979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestEventOnWorkers(workers, "NetworkMetrics"));
															#line 2980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestErrorOnWorkers(workers));
															#line 2981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestEventOnWorkers(workers, "TraceFileOpenError"));
															#line 2982 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back(latestEventOnWorkers(workers, "ProgramStart"));
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>>> __when_expr_0 = getAll(futures);
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 1;
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 0, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 16592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetStatusActorState();
		static_cast<ClusterGetStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevError, "StatusError").error(e);
															#line 3443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 16624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> mergeUnreachable;
															#line 2995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto pair : workerEventsVec ) {
															#line 2996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (pair.present() && !pair.get().second.empty())
															#line 16642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 2997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mergeUnreachable.insert(pair.get().second.begin(), pair.get().second.end());
															#line 16646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 3002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!mergeUnreachable.empty())
															#line 16651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject message = JsonBuilder::makeMessage("unreachable_processes", "The cluster has some unreachable processes.");
															#line 3005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray unreachableProcs;
															#line 3006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto m : mergeUnreachable ) {
															#line 3007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				unreachableProcs.push_back(JsonBuilderObject().setKey("address", m));
															#line 16661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 3009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["unreachable_processes"] = unreachableProcs;
															#line 3010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages.push_back(message);
															#line 16667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ProtocolVersionData> __when_expr_1 = getNewestProtocolVersion(cx, ccWorker);
															#line 3013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 2;
															#line 3013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 1, ProtocolVersionData >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 16678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> const& __workerEventsVec,int loopDepth) 
	{
															#line 2985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerEventsVec = __workerEventsVec;
															#line 16687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> && __workerEventsVec,int loopDepth) 
	{
		workerEventsVec = std::move(__workerEventsVec);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 0, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 0, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 0, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 0, std::vector<Optional<std::pair<WorkerEvents, std::set<std::string>>>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont16(int loopDepth) 
	{
															#line 3016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusCode = (int)RecoveryStatus::END;
															#line 3017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatusFuture = recoveryStateStatusFetcher(cx, ccWorker, mWorker, workers.size(), &status_incomplete_reasons, &statusCode);
															#line 3020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatusFuture = getIdmpKeyStatus(cx);
															#line 3022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatusFuture = versionEpochStatusFetcher(cx, &status_incomplete_reasons);
															#line 3025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll<JsonBuilderObject>( { recoveryStateStatusFuture, idmpKeyStatusFuture, versionEpochStatusFuture });
															#line 3025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont16when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 3;
															#line 3025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 2, Void >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 16781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(ProtocolVersionData const& __protocolVersion,int loopDepth) 
	{
															#line 3013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		protocolVersion = __protocolVersion;
															#line 16790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ProtocolVersionData && __protocolVersion,int loopDepth) 
	{
		protocolVersion = std::move(__protocolVersion);
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 1, ProtocolVersionData >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 1, ProtocolVersionData >*,ProtocolVersionData const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 1, ProtocolVersionData >*,ProtocolVersionData && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 1, ProtocolVersionData >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatus = recoveryStateStatusFuture.get();
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatus = idmpKeyStatusFuture.get();
															#line 3030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatus = versionEpochStatusFuture.get();
															#line 3033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		mMetrics = workerEventsVec[0].present() ? workerEventsVec[0].get().first : WorkerEvents();
															#line 3035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		pMetrics = workerEventsVec[1].present() ? workerEventsVec[1].get().first : WorkerEvents();
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		networkMetrics = workerEventsVec[2].present() ? workerEventsVec[2].get().first : WorkerEvents();
															#line 3038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		latestError = workerEventsVec[3].present() ? workerEventsVec[3].get().first : WorkerEvents();
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		traceFileOpenErrors = workerEventsVec[4].present() ? workerEventsVec[4].get().first : WorkerEvents();
															#line 3041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		programStarts = workerEventsVec[5].present() ? workerEventsVec[5].get().first : WorkerEvents();
															#line 3044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().recoveryCount > 0)
															#line 16887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["generation"] = db->get().recoveryCount;
															#line 16891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		processIssues = getProcessIssuesAsMessages(workerIssues);
															#line 3050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageServers = std::vector<StorageServerStatusInfo>();
															#line 3051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tLogs = std::vector<std::pair<TLogInterface, EventMap>>();
															#line 3052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxies = std::vector<std::pair<CommitProxyInterface, EventMap>>();
															#line 3053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxies = std::vector<std::pair<GrvProxyInterface, EventMap>>();
															#line 3055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		qos = JsonBuilderObject();
															#line 3056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		dataOverlay = JsonBuilderObject();
															#line 3057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		metacluster = JsonBuilderObject();
															#line 3058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageWiggler = JsonBuilderObject();
															#line 3059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		wiggleServers = std::unordered_set<UID>();
															#line 3061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["protocol_version"] = format("%" PRIx64, g_network->protocolVersion().version());
															#line 3062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["connection_string"] = coordinators.ccr->getConnectionString().toString();
															#line 3063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bounce_impact"] = getBounceImpactInfo(statusCode);
															#line 3064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["newest_protocol_version"] = format("%" PRIx64, protocolVersion.newestProtocolVersion.version());
															#line 3065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["lowest_compatible_protocol_version"] = format("%" PRIx64, protocolVersion.lowestCompatibleProtocolVersion.version());
															#line 3068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		configuration = Optional<DatabaseConfiguration>();
															#line 3069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = Optional<LoadConfigurationResult>();
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		address_workers = std::unordered_map<NetworkAddress, WorkerInterface>();
															#line 3072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (statusCode != RecoveryStatus::configuration_missing)
															#line 16931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> __when_expr_3 = loadConfiguration(cx, &messages, &status_incomplete_reasons);
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 4;
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 16942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 3028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		recoveryStateStatus = recoveryStateStatusFuture.get();
															#line 3029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		idmpKeyStatus = idmpKeyStatusFuture.get();
															#line 3030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		versionEpochStatus = versionEpochStatusFuture.get();
															#line 3033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		mMetrics = workerEventsVec[0].present() ? workerEventsVec[0].get().first : WorkerEvents();
															#line 3035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		pMetrics = workerEventsVec[1].present() ? workerEventsVec[1].get().first : WorkerEvents();
															#line 3036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		networkMetrics = workerEventsVec[2].present() ? workerEventsVec[2].get().first : WorkerEvents();
															#line 3038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		latestError = workerEventsVec[3].present() ? workerEventsVec[3].get().first : WorkerEvents();
															#line 3039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		traceFileOpenErrors = workerEventsVec[4].present() ? workerEventsVec[4].get().first : WorkerEvents();
															#line 3041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		programStarts = workerEventsVec[5].present() ? workerEventsVec[5].get().first : WorkerEvents();
															#line 3044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().recoveryCount > 0)
															#line 16974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["generation"] = db->get().recoveryCount;
															#line 16978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		processIssues = getProcessIssuesAsMessages(workerIssues);
															#line 3050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageServers = std::vector<StorageServerStatusInfo>();
															#line 3051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tLogs = std::vector<std::pair<TLogInterface, EventMap>>();
															#line 3052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxies = std::vector<std::pair<CommitProxyInterface, EventMap>>();
															#line 3053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxies = std::vector<std::pair<GrvProxyInterface, EventMap>>();
															#line 3055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		qos = JsonBuilderObject();
															#line 3056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		dataOverlay = JsonBuilderObject();
															#line 3057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		metacluster = JsonBuilderObject();
															#line 3058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageWiggler = JsonBuilderObject();
															#line 3059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		wiggleServers = std::unordered_set<UID>();
															#line 3061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["protocol_version"] = format("%" PRIx64, g_network->protocolVersion().version());
															#line 3062 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["connection_string"] = coordinators.ccr->getConnectionString().toString();
															#line 3063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bounce_impact"] = getBounceImpactInfo(statusCode);
															#line 3064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["newest_protocol_version"] = format("%" PRIx64, protocolVersion.newestProtocolVersion.version());
															#line 3065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["lowest_compatible_protocol_version"] = format("%" PRIx64, protocolVersion.lowestCompatibleProtocolVersion.version());
															#line 3068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		configuration = Optional<DatabaseConfiguration>();
															#line 3069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = Optional<LoadConfigurationResult>();
															#line 3070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		address_workers = std::unordered_map<NetworkAddress, WorkerInterface>();
															#line 3072 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (statusCode != RecoveryStatus::configuration_missing)
															#line 17018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> __when_expr_3 = loadConfiguration(cx, &messages, &status_incomplete_reasons);
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 4;
															#line 3073 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 17029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16cont2(int loopDepth) 
	{
															#line 3079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (loadResult.present())
															#line 17118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["full_replication"] = loadResult.get().fullReplication;
															#line 3081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().healthyZone.present())
															#line 17124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 3082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (loadResult.get().healthyZone.get() != ignoreSSFailuresZoneString)
															#line 17128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				{
															#line 3083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["maintenance_zone"] = loadResult.get().healthyZone.get().printable();
															#line 3084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["maintenance_seconds_remaining"] = loadResult.get().healthyZoneSeconds;
															#line 17134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
				else
				{
															#line 3086 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["data_distribution_disabled_for_ss_failures"] = true;
															#line 17140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
				}
			}
															#line 3089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().rebalanceDDIgnored)
															#line 17145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled_for_rebalance"] = true;
															#line 3092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled_hex"] = loadResult.get().rebalanceDDIgnoreHex;
															#line 17151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
															#line 3094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loadResult.get().dataDistributionDisabled)
															#line 17155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["data_distribution_disabled"] = true;
															#line 17159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 3099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["machines"] = machineStatusFetcher(mMetrics, workers, configuration, &status_incomplete_reasons);
															#line 3101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		coordinatorAddresses = std::vector<NetworkAddress>();
															#line 3102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present())
															#line 17168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3104 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			isAvailable = true;
															#line 3105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<JsonBuilderObject> __when_expr_4 = latencyProbeFetcher(cx, &messages, &status_incomplete_reasons, &isAvailable);
															#line 3105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont16cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 5;
															#line 3105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 4, JsonBuilderObject >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 17181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 3295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject layers;
															#line 3296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			layers["_valid"] = false;
															#line 3297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			layers["_error"] = "configurationMissing";
															#line 3298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["layers"] = layers;
															#line 17194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = a_body1cont16cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont4(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& loadResults,int loopDepth) 
	{
															#line 3075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		configuration = loadResults.first;
															#line 3076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = loadResults.second;
															#line 17206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont4(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && loadResults,int loopDepth) 
	{
															#line 3075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		configuration = loadResults.first;
															#line 3076 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = loadResults.second;
															#line 17217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& loadResults,int loopDepth) 
	{
		loopDepth = a_body1cont16cont4(loadResults, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && loadResults,int loopDepth) 
	{
		loopDepth = a_body1cont16cont4(std::move(loadResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetStatusActor*>(this)->ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> const& value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> && value) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterGetStatusActor, 3, std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont16cont6(int loopDepth) 
	{
															#line 3301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<JsonBuilderObject> __when_expr_14 = processStatusFetcher(db, workers, pMetrics, mMetrics, networkMetrics, latestError, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, coordinators, coordinatorAddresses, cx, configuration, loadResult.present() ? loadResult.get().healthyZone : Optional<Key>(), &status_incomplete_reasons);
															#line 3301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont16cont6when1(__when_expr_14.get(), loopDepth); };
		static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 15;
															#line 3301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 14, JsonBuilderObject >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 17308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont13(JsonBuilderObject const& latencyProbeResults,int loopDepth) 
	{
															#line 3108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["database_available"] = isAvailable;
															#line 3109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!latencyProbeResults.empty())
															#line 17319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["latency_probe"] = latencyProbeResults;
															#line 17323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		warningFutures = std::vector<Future<Void>>();
															#line 3114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable)
															#line 17329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			warningFutures.push_back(consistencyCheckStatusFetcher(cx, &messages, &status_incomplete_reasons));
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!SERVER_KNOBS->DISABLE_DUPLICATE_LOG_WARNING)
															#line 17335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 3117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				warningFutures.push_back(logRangeWarningFetcher(cx, &messages, &status_incomplete_reasons));
															#line 17339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 3124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto const& worker : workers ) {
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			address_workers[worker.interf.address()] = worker.interf;
															#line 17346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageServerFuture = errorOr(getStorageServerStatusInfos(storageMetadatas, address_workers, rkWorker));
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tLogFuture = errorOr(getTLogsAndMetrics(db, address_workers));
															#line 3132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxyFuture = errorOr(getCommitProxiesAndMetrics(db, address_workers));
															#line 3134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxyFuture = errorOr(getGrvProxiesAndMetrics(db, address_workers));
															#line 3137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		minStorageReplicasRemaining = -1;
															#line 3138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		fullyReplicatedRegions = -1;
															#line 3140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		primaryDCFO = getActivePrimaryDC(cx, &fullyReplicatedRegions, &messages);
															#line 3141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2 = std::vector<Future<JsonBuilderObject>>();
															#line 3142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(dataStatusFetcher(ddWorker, configuration.get(), &minStorageReplicasRemaining));
															#line 3143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(workloadStatusFetcher( db, workers, mWorker, rkWorker, &qos, &dataOverlay, &status_incomplete_reasons, storageServerFuture));
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(layerStatusFetcher(cx, &messages, &status_incomplete_reasons));
															#line 3146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(lockedStatusFetcher(cx, &messages, &status_incomplete_reasons));
															#line 3147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back( clusterSummaryStatisticsFetcher(pMetrics, storageServerFuture, tLogFuture, &status_incomplete_reasons));
															#line 3150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.get().perpetualStorageWiggleSpeed > 0)
															#line 17376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			primaryWiggleValues = Future<std::vector<std::pair<UID, StorageWiggleValue>>>();
															#line 3152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			remoteWiggleValues = Future<std::vector<std::pair<UID, StorageWiggleValue>>>();
															#line 3153 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			double timeout = g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01) ? 0.0 : 2.0;
															#line 3154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			primaryWiggleValues = timeoutError(readStorageWiggleValues(cx, true, true), timeout);
															#line 3155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			remoteWiggleValues = timeoutError(readStorageWiggleValues(cx, false, true), timeout);
															#line 3156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_5 = store( storageWiggler, storageWigglerStatsFetcher(db->get().distributor, configuration.get(), cx, true, &messages)) && ready(primaryWiggleValues) && ready(remoteWiggleValues);
															#line 3156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ClusterGetStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont16cont13when1(__when_expr_5.get(), loopDepth); };
			static_cast<ClusterGetStatusActor*>(this)->actor_wait_state = 6;
															#line 3156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterGetStatusActor, 5, Void >*>(static_cast<ClusterGetStatusActor*>(this)));
															#line 17397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont13(JsonBuilderObject && latencyProbeResults,int loopDepth) 
	{
															#line 3108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["database_available"] = isAvailable;
															#line 3109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!latencyProbeResults.empty())
															#line 17413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["latency_probe"] = latencyProbeResults;
															#line 17417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		warningFutures = std::vector<Future<Void>>();
															#line 3114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable)
															#line 17423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		{
															#line 3115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			warningFutures.push_back(consistencyCheckStatusFetcher(cx, &messages, &status_incomplete_reasons));
															#line 3116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!SERVER_KNOBS->DISABLE_DUPLICATE_LOG_WARNING)
															#line 17429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			{
															#line 3117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				warningFutures.push_back(logRangeWarningFetcher(cx, &messages, &status_incomplete_reasons));
															#line 17433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
			}
		}
															#line 3124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto const& worker : workers ) {
															#line 3125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			address_workers[worker.interf.address()] = worker.interf;
															#line 17440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp.py_gen"
		}
															#line 3128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		storageServerFuture = errorOr(getStorageServerStatusInfos(storageMetadatas, address_workers, rkWorker));
															#line 3130 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tLogFuture = errorOr(getTLogsAndMetrics(db, address_workers));
															#line 3132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxyFuture = errorOr(getCommitProxiesAndMetrics(db, address_workers));
															#line 3134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxyFuture = errorOr(getGrvProxiesAndMetrics(db, address_workers));
															#line 3137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		minStorageReplicasRemaining = -1;
															#line 3138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		fullyReplicatedRegions = -1;
															#line 3140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		primaryDCFO = getActivePrimaryDC(cx, &fullyReplicatedRegions, &messages);
															#line 3141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2 = std::vector<Future<JsonBuilderObject>>();
															#line 3142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(dataStatusFetcher(ddWorker, configuration.get(), &minStorageReplicasRemaining));
															#line 3143 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		futures2.push_back(workloadStatusFetcher( db, workers, mWorker, rkWorker, &qos, &dataOverlay, &status_incomplete_reasons, storageServerFuture));
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foun