#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
/*
 * RestoreLoader.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// NOTE: this file represents fast restore functionality which is deprecated and
// slated for removal.

#include "fdbclient/CommitProxyInterface.h"
#include "flow/UnitTest.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbserver/RestoreLoader.actor.h"
#include "fdbserver/RestoreRoleCommon.actor.h"
#include "fdbserver/MutationTracking.h"
#include "fdbserver/StorageMetrics.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// SerializedMutationListMap: Buffered mutation lists from data blocks in log files
// Key is the signature/version of the mutation list; Value.first is the mutation list which may come from multiple
// data blocks of log file; Value.second is the largest part number of the mutation list, which is used to sanity check
// the data blocks for the same mutation list are concatenated in increasing order of part number.
typedef std::map<Standalone<StringRef>, std::pair<Standalone<StringRef>, uint32_t>> SerializedMutationListMap;

std::vector<UID> getApplierIDs(std::map<Key, UID>& rangeToApplier);
void splitMutation(const KeyRangeMap<UID>& krMap,
                   MutationRef m,
                   Arena& mvector_arena,
                   VectorRef<MutationRef>& mvector,
                   Arena& nodeIDs_arena,
                   VectorRef<UID>& nodeIDs);
															#line 51 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> _parseSerializedMutation( KeyRangeMap<Version>* const& pRangeVersions, std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, SerializedMutationListMap* const& mutationMap, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, RestoreAsset const& asset, Database const& cx );

#line 56 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

void handleRestoreSysInfoRequest(const RestoreSysInfoRequest& req, Reference<RestoreLoaderData> self);
															#line 57 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> handleLoadFileRequest( RestoreLoadFileRequest const& req, Reference<RestoreLoaderData> const& self, Database const& cx );

#line 59 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 61 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> handleSendMutationsRequest( RestoreSendMutationsToAppliersRequest const& req, Reference<RestoreLoaderData> const& self, Database const& cx );

#line 62 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 65 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> sendMutationsToApplier( std::priority_queue<RestoreLoaderSchedSendLoadParamRequest>* const& sendLoadParamQueue, std::map<int, int>* const& inflightSendLoadParamReqs, NotifiedVersion* const& finishedBatch, VersionedMutationsMap* const& pkvOps, int const& batchIndex, RestoreAsset const& asset, bool const& isRangeFile, std::map<Key, UID>* const& pRangeToApplier, std::map<UID, RestoreApplierInterface>* const& pApplierInterfaces, Database const& cx );

#line 73 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 69 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> _parseLogFileToMutationsOnLoader( NotifiedVersion* const& pProcessedFileOffset, SerializedMutationListMap* const& mutationMap, Reference<IBackupContainer> const& bc, RestoreAsset const& asset );

#line 77 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 73 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> parseLogFileToMutationsOnLoader( NotifiedVersion* const& pProcessedFileOffset, SerializedMutationListMap* const& mutationMap, Reference<IBackupContainer> const& bc, RestoreAsset const& asset );

#line 81 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 77 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> _parseRangeFileToMutationsOnLoader( std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, Reference<IBackupContainer> const& bc, Version const& version, RestoreAsset const& asset, Database const& cx );

#line 89 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 81 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> handleFinishVersionBatchRequest( RestoreVersionBatchRequest const& req, Reference<RestoreLoaderData> const& self );

#line 90 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Dispatch requests based on node's business (i.e, cpu usage for now) and requests' priorities
// Requests for earlier version batches are preferred; which is equivalent to
// sendMuttionsRequests are preferred than loadingFileRequests
															#line 89 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via dispatchRequests()
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class DispatchRequestsActor>
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class DispatchRequestsActorState {
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	DispatchRequestsActorState(Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : self(self),
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx)
															#line 105 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("dispatchRequests", reinterpret_cast<unsigned long>(this));

	}
	~DispatchRequestsActorState() 
	{
		fdb_probe_actor_destroy("dispatchRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				curVBInflightReqs = 0;
															#line 97 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sendLoadParams = 0;
															#line 98 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				lastLoadReqs = 0;
															#line 99 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				;
															#line 127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DispatchRequestsActorState();
		static_cast<DispatchRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<DispatchRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DispatchRequestsActorState(); static_cast<DispatchRequestsActor*>(this)->destroy(); return 0; }
															#line 156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<DispatchRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DispatchRequestsActorState();
		static_cast<DispatchRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderDispatchRequests").errorUnsuppressed(e);
															#line 234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent(SevVerbose, "FastRestoreLoaderDispatchRequests", self->id()) .detail("SendingQueue", self->sendingQueue.size()) .detail("LoadingQueue", self->loadingQueue.size()) .detail("SendingLoadParamQueue", self->sendLoadParamQueue.size()) .detail("InflightSendingReqs", self->inflightSendingReqs) .detail("InflightSendingReqsThreshold", SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_SEND_REQS) .detail("InflightLoadingReqs", self->inflightLoadingReqs) .detail("InflightLoadingReqsThreshold", SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_LOAD_REQS) .detail("LastLoadFileRequests", lastLoadReqs) .detail("LoadFileRequestsBatchThreshold", SERVER_KNOBS->FASTRESTORE_SCHED_LOAD_REQ_BATCHSIZE) .detail("LastDispatchSendLoadParamReqsForCurrentVB", curVBInflightReqs) .detail("LastDispatchSendLoadParamReqsForFutureVB", sendLoadParams) .detail("CpuUsage", self->cpuUsage) .detail("TargetCpuUsage", SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT) .detail("MaxCpuUsage", SERVER_KNOBS->FASTRESTORE_SCHED_MAX_CPU_PERCENT);
															#line 118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_EXPENSIVE_VALIDATION)
															#line 200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!self->loadingQueue.empty() && self->loadingQueue.top().batchIndex <= self->finishedBatch.get())
															#line 204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderSchedulerHasOldLoadFileRequests") .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("PendingRequest", self->loadingQueue.top().toString());
															#line 208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!self->sendingQueue.empty() && self->sendingQueue.top().batchIndex <= self->finishedBatch.get())
															#line 212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderSchedulerHasOldSendRequests") .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("PendingRequest", self->sendingQueue.top().toString());
															#line 216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!self->sendLoadParamQueue.empty() && self->sendLoadParamQueue.top().batchIndex <= self->finishedBatch.get())
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderSchedulerHasOldSendLoadParamRequests") .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("PendingRequest", self->sendLoadParamQueue.top().toString());
															#line 224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!self->sendingQueue.empty())
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 144 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			const RestoreSendMutationsToAppliersRequest& req = self->sendingQueue.top();
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (req.batchIndex - 1 == self->finishedSendingVB || self->cpuUsage < SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT)
															#line 235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->addActor.send(handleSendMutationsRequest(req, self, cx));
															#line 149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendingQueue.pop();
															#line 241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if ((self->inflightSendingReqs > 0 && self->inflightLoadingReqs > 0) && (self->inflightSendingReqs >= SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_SEND_REQS || self->inflightLoadingReqs >= SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_LOAD_REQS || (self->inflightSendingReqs >= 1 && self->cpuUsage >= SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT) || self->cpuUsage >= SERVER_KNOBS->FASTRESTORE_SCHED_MAX_CPU_PERCENT))
															#line 246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (self->inflightSendingReqs >= SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_SEND_REQS)
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderTooManyInflightRequests") .detail("VersionBatchesBlockedAtSendingMutationsToAppliers", self->inflightSendingReqs) .detail("CpuUsage", self->cpuUsage) .detail("InflightSendingReq", self->inflightSendingReqs) .detail("InflightSendingReqThreshold", SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_SEND_REQS) .detail("InflightLoadingReq", self->inflightLoadingReqs) .detail("InflightLoadingReqThreshold", SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_LOAD_REQS);
															#line 254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_SCHED_UPDATE_DELAY);
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DispatchRequestsActor, 0, Void >*>(static_cast<DispatchRequestsActor*>(this)));
															#line 265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(;!self->sendLoadParamQueue.empty();) {
															#line 175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			const RestoreLoaderSchedSendLoadParamRequest& req = self->sendLoadParamQueue.top();
															#line 176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (req.batchIndex - 1 > self->finishedSendingVB)
															#line 283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
				break;
			}
			else
			{
															#line 179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				req.toSched.send(Void());
															#line 180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendLoadParamQueue.pop();
															#line 293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		sendLoadParams = 0;
															#line 184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		curVBInflightReqs = self->inflightSendLoadParamReqs[self->finishedSendingVB + 1];
															#line 185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(;!self->sendLoadParamQueue.empty();) {
															#line 186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			const RestoreLoaderSchedSendLoadParamRequest& req = self->sendLoadParamQueue.top();
															#line 187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (curVBInflightReqs >= SERVER_KNOBS->FASTRESTORE_SCHED_INFLIGHT_SENDPARAM_THRESHOLD || sendLoadParams >= SERVER_KNOBS->FASTRESTORE_SCHED_SEND_FUTURE_VB_REQS_BATCH)
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
				break;
			}
			else
			{
															#line 192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				req.toSched.send(Void());
															#line 193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendLoadParamQueue.pop();
															#line 194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sendLoadParams++;
															#line 318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		lastLoadReqs = 0;
															#line 200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(;!self->loadingQueue.empty();) {
															#line 201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (lastLoadReqs >= SERVER_KNOBS->FASTRESTORE_SCHED_LOAD_REQ_BATCHSIZE)
															#line 327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
				break;
			}
															#line 204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			const RestoreLoadFileRequest& req = self->loadingQueue.top();
															#line 205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (req.batchIndex <= self->finishedBatch.get())
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderDispatchRestoreLoadFileRequestTooOld") .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("RequestBatchIndex", req.batchIndex);
															#line 209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				req.reply.send(RestoreLoadFileReply(req.param, true));
															#line 210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->loadingQueue.pop();
															#line 211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				ASSERT(false);
															#line 345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			else
			{
															#line 213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->addActor.send(handleLoadFileRequest(req, self, cx));
															#line 214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->loadingQueue.pop();
															#line 215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				lastLoadReqs++;
															#line 355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->cpuUsage >= SERVER_KNOBS->FASTRESTORE_SCHED_TARGET_CPU_PERCENT)
															#line 360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->FASTRESTORE_SCHED_UPDATE_DELAY);
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 2;
															#line 220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DispatchRequestsActor, 1, Void >*>(static_cast<DispatchRequestsActor*>(this)));
															#line 371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		updateProcessStats(self);
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		updateProcessStats(self);
															#line 394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state > 0) static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DispatchRequestsActor*>(this)->ActorCallback< DispatchRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DispatchRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
															#line 222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		updateProcessStats(self);
															#line 224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->loadingQueue.empty() && self->sendingQueue.empty() && self->sendLoadParamQueue.empty())
															#line 480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevVerbose, "FastRestoreLoaderDispatchRequestsWaitOnRequests", self->id()) .detail("HasPendingRequests", self->hasPendingRequests->get());
															#line 227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->hasPendingRequests->set(false);
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->hasPendingRequests->onChange();
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 490 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont11when1(__when_expr_2.get(), loopDepth); };
			static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 3;
															#line 228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DispatchRequestsActor, 2, Void >*>(static_cast<DispatchRequestsActor*>(this)));
															#line 495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont22(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state > 0) static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DispatchRequestsActor*>(this)->ActorCallback< DispatchRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DispatchRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DispatchRequestsActor*>(this)->actor_wait_state > 0) static_cast<DispatchRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DispatchRequestsActor*>(this)->ActorCallback< DispatchRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DispatchRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DispatchRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<RestoreLoaderData> self;
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int curVBInflightReqs;
															#line 97 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int sendLoadParams;
															#line 98 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int lastLoadReqs;
															#line 695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via dispatchRequests()
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class DispatchRequestsActor final : public Actor<Void>, public ActorCallback< DispatchRequestsActor, 0, Void >, public ActorCallback< DispatchRequestsActor, 1, Void >, public ActorCallback< DispatchRequestsActor, 2, Void >, public FastAllocated<DispatchRequestsActor>, public DispatchRequestsActorState<DispatchRequestsActor> {
															#line 700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<DispatchRequestsActor>::operator new;
	using FastAllocated<DispatchRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5260375438290881024UL, 11933107640971075584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DispatchRequestsActor, 0, Void >;
friend struct ActorCallback< DispatchRequestsActor, 1, Void >;
friend struct ActorCallback< DispatchRequestsActor, 2, Void >;
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	DispatchRequestsActor(Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DispatchRequestsActorState<DispatchRequestsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dispatchRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18143781752604192768UL, 2372983750154522880UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dispatchRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dispatchRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DispatchRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DispatchRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DispatchRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> dispatchRequests( Reference<RestoreLoaderData> const& self, Database const& cx ) {
															#line 94 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new DispatchRequestsActor(self, cx));
															#line 754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

															#line 759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via restoreLoaderCore()
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class RestoreLoaderCoreActor>
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class RestoreLoaderCoreActorState {
															#line 766 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreLoaderCoreActorState(RestoreLoaderInterface const& loaderInterf,int const& nodeIndex,Database const& cx,RestoreControllerInterface const& ci) 
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : loaderInterf(loaderInterf),
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   nodeIndex(nodeIndex),
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   ci(ci),
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   self(makeReference<RestoreLoaderData>(loaderInterf.id(), nodeIndex, ci)),
															#line 245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   error(actorCollection(self->addActor.getFuture())),
															#line 246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   actors(false),
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   exitRole(Never()),
															#line 248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   hasQueuedRequests(false)
															#line 789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("restoreLoaderCore", reinterpret_cast<unsigned long>(this));

	}
	~RestoreLoaderCoreActorState() 
	{
		fdb_probe_actor_destroy("restoreLoaderCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			actors.add(updateProcessMetrics(self));
															#line 251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			actors.add(traceProcessMetrics(self, "RestoreLoader"));
															#line 253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->addActor.send(dispatchRequests(self, cx));
															#line 255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreLoaderCoreActorState();
		static_cast<RestoreLoaderCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<RestoreLoaderCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreLoaderCoreActorState(); static_cast<RestoreLoaderCoreActor*>(this)->destroy(); return 0; }
															#line 833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<RestoreLoaderCoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreLoaderCoreActorState();
		static_cast<RestoreLoaderCoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "[Init]";
															#line 852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		try {
															#line 260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_0 = loaderInterf.heartbeat.getFuture();
															#line 856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RestoreSimpleRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RestoreSimpleRequest>>::value, "invalid type");
															#line 259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<RestoreLoaderCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_1 = loaderInterf.updateRestoreSysInfo.getFuture();
															#line 864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<RestoreSysInfoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<RestoreSysInfoRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_2 = loaderInterf.loadFile.getFuture();
															#line 869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<RestoreLoadFileRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<RestoreLoadFileRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_3 = loaderInterf.sendMutations.getFuture();
															#line 874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RestoreSendMutationsToAppliersRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RestoreSendMutationsToAppliersRequest>>::value, "invalid type");
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_4 = loaderInterf.initVersionBatch.getFuture();
															#line 879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<RestoreVersionBatchRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<RestoreVersionBatchRequest>>::value, "invalid type");
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_5 = loaderInterf.finishVersionBatch.getFuture();
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<RestoreVersionBatchRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<RestoreVersionBatchRequest>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
															#line 293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto __when_expr_6 = loaderInterf.finishRestore.getFuture();
															#line 889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RestoreFinishRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RestoreFinishRequest>>::value, "invalid type");
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when7(__when_expr_6.pop(), loopDepth); };
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_7 = actors.getResult();
															#line 894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
															#line 301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_8 = exitRole;
															#line 898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when9(__when_expr_8.get(), loopDepth); };
															#line 305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_9 = error;
															#line 902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1when10(__when_expr_9.get(), loopDepth); };
			static_cast<RestoreLoaderCoreActor*>(this)->actor_wait_state = 1;
															#line 260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RestoreLoaderCoreActor, 7, Void >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RestoreLoaderCoreActor, 8, Void >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 305 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RestoreLoaderCoreActor, 9, Void >*>(static_cast<RestoreLoaderCoreActor*>(this)));
															#line 925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			bool isError = e.code() != error_code_operation_cancelled;
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(isError ? SevError : SevWarnAlways, "FastRestoreLoaderError", self->id()) .errorUnsuppressed(e) .detail("RequestType", requestTypeStr);
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			actors.clear(false);
															#line 964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleHeartbeat(req, loaderInterf.id()));
															#line 987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleHeartbeat(req, loaderInterf.id()));
															#line 998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreSysInfoRequest const& req,int loopDepth) 
	{
															#line 265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "updateRestoreSysInfo";
															#line 266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		handleRestoreSysInfoRequest(req, self);
															#line 1009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreSysInfoRequest && req,int loopDepth) 
	{
															#line 265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "updateRestoreSysInfo";
															#line 266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		handleRestoreSysInfoRequest(req, self);
															#line 1020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreLoadFileRequest const& req,int loopDepth) 
	{
															#line 269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "loadFile";
															#line 270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		hasQueuedRequests = !self->loadingQueue.empty() || !self->sendingQueue.empty();
															#line 271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->initBackupContainer(req.param.url, req.param.proxy);
															#line 272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->loadingQueue.push(req);
															#line 273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!hasQueuedRequests)
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->hasPendingRequests->set(true);
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreLoadFileRequest && req,int loopDepth) 
	{
															#line 269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "loadFile";
															#line 270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		hasQueuedRequests = !self->loadingQueue.empty() || !self->sendingQueue.empty();
															#line 271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->initBackupContainer(req.param.url, req.param.proxy);
															#line 272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->loadingQueue.push(req);
															#line 273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!hasQueuedRequests)
															#line 1059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->hasPendingRequests->set(true);
															#line 1063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(RestoreSendMutationsToAppliersRequest const& req,int loopDepth) 
	{
															#line 278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "sendMutations";
															#line 279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		hasQueuedRequests = !self->loadingQueue.empty() || !self->sendingQueue.empty();
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->sendingQueue.push(req);
															#line 281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!hasQueuedRequests)
															#line 1079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->hasPendingRequests->set(true);
															#line 1083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(RestoreSendMutationsToAppliersRequest && req,int loopDepth) 
	{
															#line 278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "sendMutations";
															#line 279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		hasQueuedRequests = !self->loadingQueue.empty() || !self->sendingQueue.empty();
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->sendingQueue.push(req);
															#line 281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!hasQueuedRequests)
															#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->hasPendingRequests->set(true);
															#line 1103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(RestoreVersionBatchRequest const& req,int loopDepth) 
	{
															#line 286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "initVersionBatch";
															#line 287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleInitVersionBatchRequest(req, self));
															#line 1115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(RestoreVersionBatchRequest && req,int loopDepth) 
	{
															#line 286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "initVersionBatch";
															#line 287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleInitVersionBatchRequest(req, self));
															#line 1126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(RestoreVersionBatchRequest const& req,int loopDepth) 
	{
															#line 290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "finishVersionBatch";
															#line 291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleFinishVersionBatchRequest(req, self));
															#line 1137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(RestoreVersionBatchRequest && req,int loopDepth) 
	{
															#line 290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "finishVersionBatch";
															#line 291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		actors.add(handleFinishVersionBatchRequest(req, self));
															#line 1148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(RestoreFinishRequest const& req,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "finishRestore";
															#line 295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		handleFinishRestoreRequest(req, self);
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (req.terminate)
															#line 1161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			exitRole = Void();
															#line 1165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(RestoreFinishRequest && req,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		requestTypeStr = "finishRestore";
															#line 295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		handleFinishRestoreRequest(req, self);
															#line 296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (req.terminate)
															#line 1179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			exitRole = Void();
															#line 1183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void const& _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderCoreExitRole", self->id());
															#line 1205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when9(Void && _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderCoreExitRole", self->id());
															#line 1214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when10(Void const& _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderActorCollectionError", self->id());
															#line 1223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when10(Void && _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderActorCollectionError", self->id());
															#line 1232 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreLoaderCoreActor*>(this)->actor_wait_state > 0) static_cast<RestoreLoaderCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorCallback< RestoreLoaderCoreActor, 7, Void >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorCallback< RestoreLoaderCoreActor, 8, Void >::remove();
		static_cast<RestoreLoaderCoreActor*>(this)->ActorCallback< RestoreLoaderCoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >*,RestoreSysInfoRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >*,RestoreSysInfoRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >*,RestoreLoadFileRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >*,RestoreLoadFileRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >*,RestoreSendMutationsToAppliersRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >*,RestoreSendMutationsToAppliersRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >*,RestoreFinishRequest const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >*,RestoreFinishRequest && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RestoreLoaderCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RestoreLoaderCoreActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RestoreLoaderCoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RestoreLoaderCoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreLoaderInterface loaderInterf;
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int nodeIndex;
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreControllerInterface ci;
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<RestoreLoaderData> self;
															#line 245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Future<Void> error;
															#line 246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	ActorCollection actors;
															#line 247 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Future<Void> exitRole;
															#line 248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	bool hasQueuedRequests;
															#line 256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::string requestTypeStr;
															#line 1855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via restoreLoaderCore()
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class RestoreLoaderCoreActor final : public Actor<Void>, public ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >, public ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >, public ActorCallback< RestoreLoaderCoreActor, 7, Void >, public ActorCallback< RestoreLoaderCoreActor, 8, Void >, public ActorCallback< RestoreLoaderCoreActor, 9, Void >, public FastAllocated<RestoreLoaderCoreActor>, public RestoreLoaderCoreActorState<RestoreLoaderCoreActor> {
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreLoaderCoreActor>::operator new;
	using FastAllocated<RestoreLoaderCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17223512277697434368UL, 552344349725377792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 1, RestoreSysInfoRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 2, RestoreLoadFileRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 3, RestoreSendMutationsToAppliersRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 4, RestoreVersionBatchRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 5, RestoreVersionBatchRequest >;
friend struct ActorSingleCallback< RestoreLoaderCoreActor, 6, RestoreFinishRequest >;
friend struct ActorCallback< RestoreLoaderCoreActor, 7, Void >;
friend struct ActorCallback< RestoreLoaderCoreActor, 8, Void >;
friend struct ActorCallback< RestoreLoaderCoreActor, 9, Void >;
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreLoaderCoreActor(RestoreLoaderInterface const& loaderInterf,int const& nodeIndex,Database const& cx,RestoreControllerInterface const& ci) 
															#line 1886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RestoreLoaderCoreActorState<RestoreLoaderCoreActor>(loaderInterf, nodeIndex, cx, ci),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreLoaderCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15984049626897419520UL, 11190652568262850816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreLoaderCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreLoaderCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreLoaderCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RestoreLoaderCoreActor, 0, RestoreSimpleRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> restoreLoaderCore( RestoreLoaderInterface const& loaderInterf, int const& nodeIndex, Database const& cx, RestoreControllerInterface const& ci ) {
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new RestoreLoaderCoreActor(loaderInterf, nodeIndex, cx, ci));
															#line 1919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

static inline bool _logMutationTooOld(KeyRangeMap<Version>* pRangeVersions, KeyRangeRef keyRange, Version v) {
	ASSERT(pRangeVersions != nullptr);
	auto ranges = pRangeVersions->intersectingRanges(keyRange);
	Version minVersion = MAX_VERSION;
	for (auto r = ranges.begin(); r != ranges.end(); ++r) {
		minVersion = std::min(minVersion, r->value());
	}
	ASSERT(minVersion != MAX_VERSION); // pRangeVersions is initialized as entire keyspace, ranges cannot be empty
	return minVersion >= v;
}

static inline bool logMutationTooOld(KeyRangeMap<Version>* pRangeVersions, MutationRef mutation, Version v) {
	return isRangeMutation(mutation)
	           ? _logMutationTooOld(pRangeVersions, KeyRangeRef(mutation.param1, mutation.param2), v)
	           : _logMutationTooOld(pRangeVersions, KeyRangeRef(singleKeyRange(mutation.param1)), v);
}

// Assume: Only update the local data if it (applierInterf) has not been set
void handleRestoreSysInfoRequest(const RestoreSysInfoRequest& req, Reference<RestoreLoaderData> self) {
	TraceEvent("FastRestoreLoader", self->id()).detail("HandleRestoreSysInfoRequest", self->id());
	ASSERT(self.isValid());

	// The loader has received the appliers interfaces
	if (!self->appliersInterf.empty()) {
		req.reply.send(RestoreCommonReply(self->id()));
		return;
	}

	self->appliersInterf = req.sysInfo.appliers;
	// Update rangeVersions
	ASSERT(req.rangeVersions.size() > 0); // At least the min version of range files will be used
	ASSERT(self->rangeVersions.size() == 1); // rangeVersions has not been set
	for (auto rv = req.rangeVersions.begin(); rv != req.rangeVersions.end(); ++rv) {
		self->rangeVersions.insert(rv->first, rv->second);
	}

	// Debug message for range version in each loader
	auto ranges = self->rangeVersions.ranges();
	int i = 0;
	for (auto r = ranges.begin(); r != ranges.end(); ++r) {
		TraceEvent("FastRestoreLoader", self->id())
		    .detail("RangeIndex", i++)
		    .detail("RangeBegin", r->begin())
		    .detail("RangeEnd", r->end())
		    .detail("Version", r->value());
	}

	req.reply.send(RestoreCommonReply(self->id()));
}

// Parse a data block in a partitioned mutation log file and store mutations
// into "kvOpsIter" and samples into "samplesIter".
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _parsePartitionedLogFileOnLoader()
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class _parsePartitionedLogFileOnLoaderActor>
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parsePartitionedLogFileOnLoaderActorState {
															#line 1983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parsePartitionedLogFileOnLoaderActorState(KeyRangeMap<Version>* const& pRangeVersions,NotifiedVersion* const& processedFileOffset,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,RestoreAsset const& asset,Database const& cx) 
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   processedFileOffset(processedFileOffset),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOpsIter(kvOpsIter),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samplesIter(samplesIter),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cc(cc),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   buf(makeString(asset.len))
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this));

	}
	~_parsePartitionedLogFileOnLoaderActorState() 
	{
		fdb_probe_actor_destroy("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(asset.filename);
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 1;
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >*>(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)));
															#line 2028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_parsePartitionedLogFileOnLoaderActorState();
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<int> __when_expr_1 = file->read(mutateString(buf), asset.len, asset.offset);
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >*>(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)));
															#line 2058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		file = __file;
															#line 2067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int const& rLen,int loopDepth) 
	{
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (rLen != asset.len)
															#line 2146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 2150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		simulateBlobFailure();
															#line 391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodingLogFile") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("Offset", asset.offset) .detail("Length", asset.len);
															#line 397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		tempArena = Arena();
															#line 398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 2160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		try {
															#line 401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (reader.consume<int32_t>() != PARTITIONED_MLOG_VERSION)
															#line 2164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1cont2Catch1(restore_unsupported_file_version(), loopDepth);
															#line 2168 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps = &kvOpsIter->second;
															#line 405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 2174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int && rLen,int loopDepth) 
	{
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (rLen != asset.len)
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		simulateBlobFailure();
															#line 391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodingLogFile") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("Offset", asset.offset) .detail("Length", asset.len);
															#line 397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		tempArena = Arena();
															#line 398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 2203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		try {
															#line 401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (reader.consume<int32_t>() != PARTITIONED_MLOG_VERSION)
															#line 2207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1cont2Catch1(restore_unsupported_file_version(), loopDepth);
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps = &kvOpsIter->second;
															#line 405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont2(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parsePartitionedLogFileOnLoaderActorState(); static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->destroy(); return 0; }
															#line 2307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_parsePartitionedLogFileOnLoaderActorState();
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreCorruptLogFileBlock") .error(e) .detail("BatchIndex", asset.batchIndex) .detail("Filename", file->getFilename()) .detail("BlockOffset", asset.offset) .detail("BlockLen", asset.len);
															#line 495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for( auto b : reader.remainder() ) {
															#line 485 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (b != 0xFF)
															#line 2338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 486 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1cont2Catch1(restore_corrupted_data_padding(), loopDepth);
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (reader.eof() || *reader.rptr == 0xFF)
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		msgVersion = LogMessageVersion();
															#line 412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		msgVersion.version = reader.consumeNetworkUInt64();
															#line 413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		msgVersion.sub = reader.consumeNetworkUInt32();
															#line 414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		msgSize = reader.consumeNetworkInt32();
															#line 415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		message = reader.consume(msgSize);
															#line 418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!asset.isInVersionRange(msgVersion.version))
															#line 2376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yield();
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 3;
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >*>(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)));
															#line 2387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		it = VersionedMutationsMap::iterator();
															#line 424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		bool inserted;
															#line 425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		std::tie(it, inserted) = kvOps->emplace(msgVersion, MutationsVec());
															#line 429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(inserted);
															#line 431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ArenaReader rd(buf.arena(), StringRef(message, msgSize), AssumeVersion(g_network->protocolVersion()));
															#line 432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		mutation = MutationRef();
															#line 433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		rd >> mutation;
															#line 436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (logMutationTooOld(pRangeVersions, mutation, msgVersion.version))
															#line 2428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			cc->oldLogMutations += 1;
															#line 438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_3 = yield();
															#line 438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 4;
															#line 438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >*>(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)));
															#line 2441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont5(int loopDepth) 
	{
															#line 443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (mutation.param1 >= asset.range.end || (isRangeMutation(mutation) && mutation.param2 < asset.range.begin) || (!isRangeMutation(mutation) && mutation.param1 < asset.range.begin))
															#line 2542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_4 = yield();
															#line 446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 5;
															#line 446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >*>(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)));
															#line 2553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont8(int loopDepth) 
	{
															#line 451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(asset.removePrefix.size() == 0);
															#line 452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (isRangeMutation(mutation))
															#line 2656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			mutation.param1 = mutation.param1 >= asset.range.begin ? mutation.param1 : asset.range.begin;
															#line 454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			mutation.param2 = mutation.param2 < asset.range.end ? mutation.param2 : asset.range.end;
															#line 456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (asset.hasPrefix())
															#line 2664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				mutation.param1 = mutation.param1.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				mutation.param2 = mutation.param2.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 2670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 463 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (asset.hasPrefix())
															#line 2677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 464 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				mutation.param1 = mutation.param1.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 2681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent(SevFRMutationInfo, "FastRestoreDecodePartitionedLogFile") .detail("CommitVersion", msgVersion.toString()) .detail("ParsedMutation", mutation.toString());
															#line 472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		it->second.push_back_deep(it->second.arena(), mutation);
															#line 473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		cc->loadedLogBytes += mutation.totalSize();
															#line 475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ByteSampleInfo sampleInfo = isKeyValueInSample(KeyValueRef(mutation.param1, mutation.param2));
															#line 476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (sampleInfo.inSample)
															#line 2694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			cc->sampledLogBytes += sampleInfo.sampledSize;
															#line 478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			samplesIter->second.push_back_deep(samplesIter->second.arena(), SampledMutation(mutation.param1, sampleInfo.sampledSize));
															#line 2700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont9(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1cont9(Void && _,int loopDepth) 
	{
		return a_body1cont2loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion* processedFileOffset;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, VersionedMutationsMap>::iterator kvOpsIter;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, SampledMutationsVec>::iterator samplesIter;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LoaderCounters* cc;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Standalone<StringRef> buf;
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IAsyncFile> file;
															#line 397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Arena tempArena;
															#line 398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	StringRefReader reader;
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap* kvOps;
															#line 411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LogMessageVersion msgVersion;
															#line 414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int msgSize;
															#line 415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	const uint8_t* message;
															#line 423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap::iterator it;
															#line 432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	MutationRef mutation;
															#line 2842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _parsePartitionedLogFileOnLoader()
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parsePartitionedLogFileOnLoaderActor final : public Actor<Void>, public ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >, public ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >, public ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >, public ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >, public ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >, public FastAllocated<_parsePartitionedLogFileOnLoaderActor>, public _parsePartitionedLogFileOnLoaderActorState<_parsePartitionedLogFileOnLoaderActor> {
															#line 2847 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<_parsePartitionedLogFileOnLoaderActor>::operator new;
	using FastAllocated<_parsePartitionedLogFileOnLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1908788084739832320UL, 3281858131359768576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >;
friend struct ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >;
friend struct ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >;
friend struct ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >;
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parsePartitionedLogFileOnLoaderActor(KeyRangeMap<Version>* const& pRangeVersions,NotifiedVersion* const& processedFileOffset,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,RestoreAsset const& asset,Database const& cx) 
															#line 2868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _parsePartitionedLogFileOnLoaderActorState<_parsePartitionedLogFileOnLoaderActor>(pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7902012126463300096UL, 4546667813382691840UL);
		ActorExecutionContextHelper __helper(static_cast<_parsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_parsePartitionedLogFileOnLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _parsePartitionedLogFileOnLoaderActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _parsePartitionedLogFileOnLoaderActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _parsePartitionedLogFileOnLoaderActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _parsePartitionedLogFileOnLoaderActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _parsePartitionedLogFileOnLoaderActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] static Future<Void> _parsePartitionedLogFileOnLoader( KeyRangeMap<Version>* const& pRangeVersions, NotifiedVersion* const& processedFileOffset, std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, Reference<IBackupContainer> const& bc, RestoreAsset const& asset, Database const& cx ) {
															#line 374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new _parsePartitionedLogFileOnLoaderActor(pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx));
															#line 2905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// wrapper of _parsePartitionedLogFileOnLoader to retry on blob error
															#line 2911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via parsePartitionedLogFileOnLoader()
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class ParsePartitionedLogFileOnLoaderActor>
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class ParsePartitionedLogFileOnLoaderActorState {
															#line 2918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	ParsePartitionedLogFileOnLoaderActorState(KeyRangeMap<Version>* const& pRangeVersions,NotifiedVersion* const& processedFileOffset,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,RestoreAsset const& asset,Database const& cx) 
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   processedFileOffset(processedFileOffset),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOpsIter(kvOpsIter),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samplesIter(samplesIter),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cc(cc),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   readFileRetries(0)
															#line 2941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this));

	}
	~ParsePartitionedLogFileOnLoaderActorState() 
	{
		fdb_probe_actor_destroy("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 2956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ParsePartitionedLogFileOnLoaderActorState();
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ParsePartitionedLogFileOnLoaderActorState(); static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->destroy(); return 0; }
															#line 2979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ParsePartitionedLogFileOnLoaderActorState();
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = processedFileOffset->whenAtLeast(asset.offset);
															#line 514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 1;
															#line 514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >*>(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)));
															#line 3006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (e.code() == error_code_restore_bad_read || e.code() == error_code_restore_unsupported_file_version || e.code() == error_code_restore_corrupted_data_padding)
															#line 3041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreFileRestoreCorruptedPartitionedLogFileBlock").error(e);
															#line 531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			else
			{
															#line 532 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (e.code() == error_code_http_request_failed || e.code() == error_code_connection_failed || e.code() == error_code_timed_out || e.code() == error_code_lookup_failed)
															#line 3053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevWarnAlways, "FastRestoreDecodedPartitionedLogFileConnectionFailure") .error(e) .detail("Retries", ++readFileRetries);
															#line 538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delayJittered(0.1);
															#line 538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 3;
															#line 538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >*>(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)));
															#line 3066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevError, "FastRestoreParsePartitionedLogFileOnLoaderUnexpectedError").error(e);
															#line 541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(processedFileOffset->get() == asset.offset);
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = _parsePartitionedLogFileOnLoader( pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx);
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*>(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)));
															#line 3100 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(processedFileOffset->get() == asset.offset);
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = _parsePartitionedLogFileOnLoader( pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx);
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*>(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)));
															#line 3118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		processedFileOffset->set(asset.offset + asset.len);
															#line 521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodingLogFileDone") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("Offset", asset.offset) .detail("Length", asset.len);
															#line 3204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		processedFileOffset->set(asset.offset + asset.len);
															#line 521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodingLogFileDone") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("Offset", asset.offset) .detail("Length", asset.len);
															#line 3215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion* processedFileOffset;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, VersionedMutationsMap>::iterator kvOpsIter;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, SampledMutationsVec>::iterator samplesIter;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LoaderCounters* cc;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int readFileRetries;
															#line 3412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via parsePartitionedLogFileOnLoader()
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class ParsePartitionedLogFileOnLoaderActor final : public Actor<Void>, public ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >, public ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >, public ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >, public FastAllocated<ParsePartitionedLogFileOnLoaderActor>, public ParsePartitionedLogFileOnLoaderActorState<ParsePartitionedLogFileOnLoaderActor> {
															#line 3417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<ParsePartitionedLogFileOnLoaderActor>::operator new;
	using FastAllocated<ParsePartitionedLogFileOnLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16328007349517794048UL, 8963518273064468736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >;
friend struct ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >;
friend struct ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >;
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	ParsePartitionedLogFileOnLoaderActor(KeyRangeMap<Version>* const& pRangeVersions,NotifiedVersion* const& processedFileOffset,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,RestoreAsset const& asset,Database const& cx) 
															#line 3436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ParsePartitionedLogFileOnLoaderActorState<ParsePartitionedLogFileOnLoaderActor>(pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10727208160223462912UL, 17158901896395886080UL);
		ActorExecutionContextHelper __helper(static_cast<ParsePartitionedLogFileOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("parsePartitionedLogFileOnLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("parsePartitionedLogFileOnLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ParsePartitionedLogFileOnLoaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ParsePartitionedLogFileOnLoaderActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ParsePartitionedLogFileOnLoaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] static Future<Void> parsePartitionedLogFileOnLoader( KeyRangeMap<Version>* const& pRangeVersions, NotifiedVersion* const& processedFileOffset, std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, Reference<IBackupContainer> const& bc, RestoreAsset const& asset, Database const& cx ) {
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new ParsePartitionedLogFileOnLoaderActor(pRangeVersions, processedFileOffset, kvOpsIter, samplesIter, cc, bc, asset, cx));
															#line 3471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

															#line 3476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _processLoadingParam()
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class _processLoadingParamActor>
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _processLoadingParamActorState {
															#line 3483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_processLoadingParamActorState(KeyRangeMap<Version>* const& pRangeVersions,LoadingParam const& param,Reference<LoaderBatchData> const& batchData,UID const& loaderID,Reference<IBackupContainer> const& bc,Database const& cx) 
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   param(param),
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   batchData(batchData),
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   loaderID(loaderID),
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   mutationMap(),
															#line 558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   processedFileOffset(0),
															#line 559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   fileParserFutures(),
															#line 560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOpsPerLPIter(batchData->kvOpsPerLP.end()),
															#line 561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samplesIter(batchData->sampleMutations.end())
															#line 3510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_processLoadingParam", reinterpret_cast<unsigned long>(this));

	}
	~_processLoadingParamActorState() 
	{
		fdb_probe_actor_destroy("_processLoadingParam", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent("FastRestoreLoaderProcessLoadingParam", loaderID) .detail("BatchIndex", param.asset.batchIndex) .detail("LoadingParam", param.toString());
															#line 566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(param.blockSize > 0);
															#line 567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(param.asset.offset % param.blockSize == 0);
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(batchData->kvOpsPerLP.find(param) == batchData->kvOpsPerLP.end());
															#line 571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			bool inserted;
															#line 572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::tie(kvOpsPerLPIter, inserted) = batchData->kvOpsPerLP.emplace(param, VersionedMutationsMap());
															#line 573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(inserted);
															#line 574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::tie(samplesIter, inserted) = batchData->sampleMutations.emplace(param, SampledMutationsVec());
															#line 575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(inserted);
															#line 577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(int64_t j = param.asset.offset;j < param.asset.len;j += param.blockSize) {
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				RestoreAsset subAsset = param.asset;
															#line 579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				subAsset.offset = j;
															#line 580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				subAsset.len = std::min<int64_t>(param.blockSize, param.asset.len - j);
															#line 581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (param.isRangeFile)
															#line 3551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					fileParserFutures.push_back(_parseRangeFileToMutationsOnLoader( kvOpsPerLPIter, samplesIter, &batchData->counters, bc, param.rangeVersion.get(), subAsset, cx));
															#line 3555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
				else
				{
															#line 586 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (param.isPartitionedLog())
															#line 3561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						fileParserFutures.push_back(parsePartitionedLogFileOnLoader(pRangeVersions, &processedFileOffset, kvOpsPerLPIter, samplesIter, &batchData->counters, bc, subAsset, cx));
															#line 3565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
					else
					{
															#line 596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						fileParserFutures.push_back( parseLogFileToMutationsOnLoader(&processedFileOffset, &mutationMap, bc, subAsset));
															#line 3571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
				}
			}
															#line 601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fileParserFutures);
															#line 601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_processLoadingParamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_processLoadingParamActor*>(this)->actor_wait_state = 1;
															#line 601 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _processLoadingParamActor, 0, Void >*>(static_cast<_processLoadingParamActor*>(this)));
															#line 3584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_processLoadingParamActorState();
		static_cast<_processLoadingParamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!param.isRangeFile && !param.isPartitionedLog())
															#line 3607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _parseSerializedMutation( pRangeVersions, kvOpsPerLPIter, &mutationMap, samplesIter, &batchData->counters, param.asset, cx);
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_processLoadingParamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_processLoadingParamActor*>(this)->actor_wait_state = 2;
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _processLoadingParamActor, 1, Void >*>(static_cast<_processLoadingParamActor*>(this)));
															#line 3618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!param.isRangeFile && !param.isPartitionedLog())
															#line 3632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _parseSerializedMutation( pRangeVersions, kvOpsPerLPIter, &mutationMap, samplesIter, &batchData->counters, param.asset, cx);
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_processLoadingParamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_processLoadingParamActor*>(this)->actor_wait_state = 2;
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _processLoadingParamActor, 1, Void >*>(static_cast<_processLoadingParamActor*>(this)));
															#line 3643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_processLoadingParamActor*>(this)->actor_wait_state > 0) static_cast<_processLoadingParamActor*>(this)->actor_wait_state = 0;
		static_cast<_processLoadingParamActor*>(this)->ActorCallback< _processLoadingParamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _processLoadingParamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _processLoadingParamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _processLoadingParamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderProcessLoadingParamDone", loaderID) .detail("BatchIndex", param.asset.batchIndex) .detail("LoadingParam", param.toString());
															#line 612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<_processLoadingParamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_processLoadingParamActorState(); static_cast<_processLoadingParamActor*>(this)->destroy(); return 0; }
															#line 3734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<_processLoadingParamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_processLoadingParamActorState();
		static_cast<_processLoadingParamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_processLoadingParamActor*>(this)->actor_wait_state > 0) static_cast<_processLoadingParamActor*>(this)->actor_wait_state = 0;
		static_cast<_processLoadingParamActor*>(this)->ActorCallback< _processLoadingParamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _processLoadingParamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _processLoadingParamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _processLoadingParamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LoadingParam param;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<LoaderBatchData> batchData;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	UID loaderID;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SerializedMutationListMap mutationMap;
															#line 558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion processedFileOffset;
															#line 559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::vector<Future<Void>> fileParserFutures;
															#line 560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, VersionedMutationsMap>::iterator kvOpsPerLPIter;
															#line 561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, SampledMutationsVec>::iterator samplesIter;
															#line 3851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _processLoadingParam()
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _processLoadingParamActor final : public Actor<Void>, public ActorCallback< _processLoadingParamActor, 0, Void >, public ActorCallback< _processLoadingParamActor, 1, Void >, public FastAllocated<_processLoadingParamActor>, public _processLoadingParamActorState<_processLoadingParamActor> {
															#line 3856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<_processLoadingParamActor>::operator new;
	using FastAllocated<_processLoadingParamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8163201165325594624UL, 7813775451652118016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _processLoadingParamActor, 0, Void >;
friend struct ActorCallback< _processLoadingParamActor, 1, Void >;
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_processLoadingParamActor(KeyRangeMap<Version>* const& pRangeVersions,LoadingParam const& param,Reference<LoaderBatchData> const& batchData,UID const& loaderID,Reference<IBackupContainer> const& bc,Database const& cx) 
															#line 3874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _processLoadingParamActorState<_processLoadingParamActor>(pRangeVersions, param, batchData, loaderID, bc, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_processLoadingParam", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13545672572649757440UL, 786106040274737664UL);
		ActorExecutionContextHelper __helper(static_cast<_processLoadingParamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_processLoadingParam");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_processLoadingParam", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _processLoadingParamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _processLoadingParamActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> _processLoadingParam( KeyRangeMap<Version>* const& pRangeVersions, LoadingParam const& param, Reference<LoaderBatchData> const& batchData, UID const& loaderID, Reference<IBackupContainer> const& bc, Database const& cx ) {
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new _processLoadingParamActor(pRangeVersions, param, batchData, loaderID, bc, cx));
															#line 3908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// A loader can process multiple RestoreLoadFileRequest in parallel.
															#line 3914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleLoadFileRequest()
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class HandleLoadFileRequestActor>
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleLoadFileRequestActorState {
															#line 3921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleLoadFileRequestActorState(RestoreLoadFileRequest const& req,Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : req(req),
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   self(self),
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   batchData(self->batch[req.batchIndex]),
															#line 618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   isDuplicated(true),
															#line 619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   printTrace(false)
															#line 3938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleLoadFileRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleLoadFileRequestActorState() 
	{
		fdb_probe_actor_destroy("handleLoadFileRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(batchData.isValid());
															#line 621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(req.batchIndex > self->finishedBatch.get());
															#line 622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			bool paramExist = batchData->processedFileParams.find(req.param) != batchData->processedFileParams.end();
															#line 623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			bool isReady = paramExist ? batchData->processedFileParams[req.param].isReady() : false;
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->loadFileReqs += 1;
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			printTrace = (batchData->loadFileReqs % 10 == 1);
															#line 628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(printTrace ? SevInfo : SevFRDebugInfo, "FastRestoreLoaderPhaseLoadFile", self->id()) .detail("BatchIndex", req.batchIndex) .detail("ProcessLoadParam", req.param.toString()) .detail("NotProcessed", !paramExist) .detail("Processed", isReady) .detail("CurrentMemory", getSystemStatistics().processMemory);
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(self->finishedBatch.get() < req.batchIndex);
															#line 637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = isSchedulable(self, req.batchIndex, __FUNCTION__);
															#line 637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 1;
															#line 637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleLoadFileRequestActor, 0, Void >*>(static_cast<HandleLoadFileRequestActor*>(this)));
															#line 3976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleLoadFileRequestActorState();
		static_cast<HandleLoadFileRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (batchData->processedFileParams.find(req.param) == batchData->processedFileParams.end())
															#line 3999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreLoadFile", self->id()) .detail("BatchIndex", req.batchIndex) .detail("ProcessLoadParam", req.param.toString());
															#line 643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(batchData->sampleMutations.find(req.param) == batchData->sampleMutations.end());
															#line 644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->processedFileParams[req.param] = _processLoadingParam(&self->rangeVersions, req.param, batchData, self->id(), self->bc, cx);
															#line 646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->inflightLoadingReqs++;
															#line 647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			isDuplicated = false;
															#line 4011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreLoadFile", self->id()) .detail("BatchIndex", req.batchIndex) .detail("WaitOnProcessLoadParam", req.param.toString());
															#line 4017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		auto it = batchData->processedFileParams.find(req.param);
															#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(it != batchData->processedFileParams.end());
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = it->second;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 2;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleLoadFileRequestActor, 1, Void >*>(static_cast<HandleLoadFileRequestActor*>(this)));
															#line 4032 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (batchData->processedFileParams.find(req.param) == batchData->processedFileParams.end())
															#line 4041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreLoadFile", self->id()) .detail("BatchIndex", req.batchIndex) .detail("ProcessLoadParam", req.param.toString());
															#line 643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(batchData->sampleMutations.find(req.param) == batchData->sampleMutations.end());
															#line 644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->processedFileParams[req.param] = _processLoadingParam(&self->rangeVersions, req.param, batchData, self->id(), self->bc, cx);
															#line 646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->inflightLoadingReqs++;
															#line 647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			isDuplicated = false;
															#line 4053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreLoadFile", self->id()) .detail("BatchIndex", req.batchIndex) .detail("WaitOnProcessLoadParam", req.param.toString());
															#line 4059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		auto it = batchData->processedFileParams.find(req.param);
															#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		ASSERT(it != batchData->processedFileParams.end());
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = it->second;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4069 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 2;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleLoadFileRequestActor, 1, Void >*>(static_cast<HandleLoadFileRequestActor*>(this)));
															#line 4074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleLoadFileRequestActor*>(this)->ActorCallback< HandleLoadFileRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleLoadFileRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		std::vector<Future<RestoreCommonReply>> fSendSamples;
															#line 659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		SampledMutationsVec& samples = batchData->sampleMutations[req.param];
															#line 660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		SampledMutationsVec sampleBatch = SampledMutationsVec();
															#line 661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		long sampleBatchSize = 0;
															#line 662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(int i = 0;i < samples.size();++i) {
															#line 663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatchSize += samples[i].totalSize();
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatch.push_back_deep(sampleBatch.arena(), samples[i]);
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (sampleBatchSize >= SERVER_KNOBS->FASTRESTORE_SAMPLE_MSG_BYTES)
															#line 4172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				fSendSamples.push_back(self->ci.samples.getReply( RestoreSamplesRequest(deterministicRandom()->randomUniqueID(), req.batchIndex, sampleBatch)));
															#line 668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sampleBatchSize = 0;
															#line 669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sampleBatch = SampledMutationsVec();
															#line 4180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (sampleBatchSize > 0)
															#line 4185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			fSendSamples.push_back(self->ci.samples.getReply( RestoreSamplesRequest(deterministicRandom()->randomUniqueID(), req.batchIndex, sampleBatch)));
															#line 675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatchSize = 0;
															#line 4191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		samplesMessages = fSendSamples.size();
															#line 4195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		try {
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(fSendSamples);
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 3;
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleLoadFileRequestActor, 2, Void >*>(static_cast<HandleLoadFileRequestActor*>(this)));
															#line 4206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		std::vector<Future<RestoreCommonReply>> fSendSamples;
															#line 659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		SampledMutationsVec& samples = batchData->sampleMutations[req.param];
															#line 660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		SampledMutationsVec sampleBatch = SampledMutationsVec();
															#line 661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		long sampleBatchSize = 0;
															#line 662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(int i = 0;i < samples.size();++i) {
															#line 663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatchSize += samples[i].totalSize();
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatch.push_back_deep(sampleBatch.arena(), samples[i]);
															#line 665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (sampleBatchSize >= SERVER_KNOBS->FASTRESTORE_SAMPLE_MSG_BYTES)
															#line 4235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				fSendSamples.push_back(self->ci.samples.getReply( RestoreSamplesRequest(deterministicRandom()->randomUniqueID(), req.batchIndex, sampleBatch)));
															#line 668 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sampleBatchSize = 0;
															#line 669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sampleBatch = SampledMutationsVec();
															#line 4243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (sampleBatchSize > 0)
															#line 4248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			fSendSamples.push_back(self->ci.samples.getReply( RestoreSamplesRequest(deterministicRandom()->randomUniqueID(), req.batchIndex, sampleBatch)));
															#line 675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sampleBatchSize = 0;
															#line 4254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		samplesMessages = fSendSamples.size();
															#line 4258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		try {
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(fSendSamples);
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 3;
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleLoadFileRequestActor, 2, Void >*>(static_cast<HandleLoadFileRequestActor*>(this)));
															#line 4269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleLoadFileRequestActor*>(this)->ActorCallback< HandleLoadFileRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleLoadFileRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->inflightLoadingReqs--;
															#line 693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		req.reply.send(RestoreLoadFileReply(req.param, isDuplicated));
															#line 694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent(printTrace ? SevInfo : SevFRDebugInfo, "FastRestoreLoaderPhaseLoadFileDone", self->id()) .detail("BatchIndex", req.batchIndex) .detail("ProcessLoadParam", req.param.toString());
															#line 698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<HandleLoadFileRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleLoadFileRequestActorState(); static_cast<HandleLoadFileRequestActor*>(this)->destroy(); return 0; }
															#line 4365 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<HandleLoadFileRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleLoadFileRequestActorState();
		static_cast<HandleLoadFileRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (e.code() == error_code_broken_promise || e.code() == error_code_operation_cancelled)
															#line 4378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarnAlways, "FastRestoreLoaderPhaseLoadFileSendSamples") .errorUnsuppressed(e) .detail("SamplesMessages", samplesMessages);
															#line 4382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			else
			{
															#line 687 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreLoaderPhaseLoadFileSendSamplesUnexpectedError").errorUnsuppressed(e);
															#line 4388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleLoadFileRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleLoadFileRequestActor*>(this)->ActorCallback< HandleLoadFileRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleLoadFileRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleLoadFileRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreLoadFileRequest req;
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<RestoreLoaderData> self;
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<LoaderBatchData> batchData;
															#line 618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	bool isDuplicated;
															#line 619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	bool printTrace;
															#line 678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int samplesMessages;
															#line 4514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleLoadFileRequest()
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleLoadFileRequestActor final : public Actor<Void>, public ActorCallback< HandleLoadFileRequestActor, 0, Void >, public ActorCallback< HandleLoadFileRequestActor, 1, Void >, public ActorCallback< HandleLoadFileRequestActor, 2, Void >, public FastAllocated<HandleLoadFileRequestActor>, public HandleLoadFileRequestActorState<HandleLoadFileRequestActor> {
															#line 4519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleLoadFileRequestActor>::operator new;
	using FastAllocated<HandleLoadFileRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14690550731964683520UL, 1556469132687453696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleLoadFileRequestActor, 0, Void >;
friend struct ActorCallback< HandleLoadFileRequestActor, 1, Void >;
friend struct ActorCallback< HandleLoadFileRequestActor, 2, Void >;
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleLoadFileRequestActor(RestoreLoadFileRequest const& req,Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 4538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleLoadFileRequestActorState<HandleLoadFileRequestActor>(req, self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10774282972533323520UL, 5747108555484606464UL);
		ActorExecutionContextHelper __helper(static_cast<HandleLoadFileRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleLoadFileRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleLoadFileRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleLoadFileRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleLoadFileRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleLoadFileRequestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> handleLoadFileRequest( RestoreLoadFileRequest const& req, Reference<RestoreLoaderData> const& self, Database const& cx ) {
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new HandleLoadFileRequestActor(req, self, cx));
															#line 4573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Send buffered mutations to appliers.
// Do not need to block on low memory usage because this actor should not increase memory usage.
															#line 4580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleSendMutationsRequest()
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class HandleSendMutationsRequestActor>
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleSendMutationsRequestActorState {
															#line 4587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleSendMutationsRequestActorState(RestoreSendMutationsToAppliersRequest const& req,Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : req(req),
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   self(self),
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   batchData(),
															#line 707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   batchStatus(),
															#line 708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   isDuplicated(true)
															#line 4604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleSendMutationsRequestActorState() 
	{
		fdb_probe_actor_destroy("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (req.batchIndex <= self->finishedBatch.get())
															#line 4619 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderRestoreSendMutationsToAppliersRequestTooOld") .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("RequestBatchIndex", req.batchIndex);
															#line 714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				req.reply.send(RestoreCommonReply(self->id(), isDuplicated));
															#line 715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (!static_cast<HandleSendMutationsRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleSendMutationsRequestActorState(); static_cast<HandleSendMutationsRequestActor*>(this)->destroy(); return 0; }
															#line 4627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				new (&static_cast<HandleSendMutationsRequestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~HandleSendMutationsRequestActorState();
				static_cast<HandleSendMutationsRequestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData = self->batch[req.batchIndex];
															#line 719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchStatus = self->status[req.batchIndex];
															#line 720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(batchData.isValid() && batchStatus.isValid());
															#line 722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(req.batchIndex > self->finishedBatch.get());
															#line 723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent("FastRestoreLoaderPhaseSendMutations", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile) .detail("LoaderSendStatus", batchStatus->toString());
															#line 728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->finishedLoadingVB = std::max(self->finishedLoadingVB, req.batchIndex);
															#line 731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!req.useRangeFile)
															#line 4647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (!batchStatus->sendAllLogs.present())
															#line 4651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					batchStatus->sendAllLogs = Never();
															#line 734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					isDuplicated = false;
															#line 735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevInfo, "FastRestoreSendMutationsProcessLogRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 4659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					loopDepth = a_body1cont3(loopDepth);
				}
				else
				{
															#line 738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (!batchStatus->sendAllLogs.get().isReady())
															#line 4666 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 739 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreSendMutationsWaitDuplicateLogRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						StrictFuture<Void> __when_expr_0 = batchStatus->sendAllLogs.get();
															#line 742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 1;
															#line 742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationsRequestActor, 0, Void >*>(static_cast<HandleSendMutationsRequestActor*>(this)));
															#line 4679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreSendMutationsSkipDuplicateLogRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 4686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						loopDepth = a_body1cont5(loopDepth);
					}
				}
			}
			else
			{
															#line 749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (!batchStatus->sendAllRanges.present())
															#line 4695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 750 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					batchStatus->sendAllRanges = Never();
															#line 751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					isDuplicated = false;
															#line 752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevInfo, "FastRestoreSendMutationsProcessRangeRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 4703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					loopDepth = a_body1cont8(loopDepth);
				}
				else
				{
															#line 755 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (!batchStatus->sendAllRanges.get().isReady())
															#line 4710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreSendMutationsWaitDuplicateRangeRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						StrictFuture<Void> __when_expr_1 = batchStatus->sendAllRanges.get();
															#line 759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 2;
															#line 759 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationsRequestActor, 1, Void >*>(static_cast<HandleSendMutationsRequestActor*>(this)));
															#line 4723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 761 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreSendMutationsSkipDuplicateRangeRequest", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile);
															#line 4730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						loopDepth = a_body1cont10(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleSendMutationsRequestActorState();
		static_cast<HandleSendMutationsRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 767 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!isDuplicated)
															#line 4756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->inflightSendingReqs++;
															#line 769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::vector<Future<Void>> fSendMutations;
															#line 770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->rangeToApplier = req.rangeToApplier;
															#line 771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for( auto& [loadParam, kvOps] : batchData->kvOpsPerLP ) {
															#line 772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (loadParam.isRangeFile == req.useRangeFile)
															#line 4768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					fSendMutations.push_back(sendMutationsToApplier(&self->sendLoadParamQueue, &self->inflightSendLoadParamReqs, &self->finishedBatch, &kvOps, req.batchIndex, loadParam.asset, loadParam.isRangeFile, &batchData->rangeToApplier, &self->appliersInterf, cx));
															#line 4772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
			}
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(fSendMutations);
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 3;
															#line 786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationsRequestActor, 2, Void >*>(static_cast<HandleSendMutationsRequestActor*>(this)));
															#line 4784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleSendMutationsRequestActor*>(this)->ActorCallback< HandleSendMutationsRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleSendMutationsRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleSendMutationsRequestActor*>(this)->ActorCallback< HandleSendMutationsRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleSendMutationsRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13(int loopDepth) 
	{
															#line 801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderPhaseSendMutationsDone", self->id()) .detail("BatchIndex", req.batchIndex) .detail("UseRangeFile", req.useRangeFile) .detail("LoaderSendStatus", batchStatus->toString());
															#line 805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), isDuplicated));
															#line 806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<HandleSendMutationsRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleSendMutationsRequestActorState(); static_cast<HandleSendMutationsRequestActor*>(this)->destroy(); return 0; }
															#line 5000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<HandleSendMutationsRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleSendMutationsRequestActorState();
		static_cast<HandleSendMutationsRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->inflightSendingReqs--;
															#line 788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (req.useRangeFile)
															#line 5014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchStatus->sendAllRanges = Void();
															#line 5018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchStatus->sendAllLogs = Void();
															#line 5024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if ((batchStatus->sendAllRanges.present() && batchStatus->sendAllRanges.get().isReady()) && (batchStatus->sendAllLogs.present() && batchStatus->sendAllLogs.get().isReady()))
															#line 5028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->finishedSendingVB = std::max(self->finishedSendingVB, req.batchIndex);
															#line 797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->kvOpsPerLP.clear();
															#line 5034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		self->inflightSendingReqs--;
															#line 788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (req.useRangeFile)
															#line 5046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchStatus->sendAllRanges = Void();
															#line 5050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchStatus->sendAllLogs = Void();
															#line 5056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if ((batchStatus->sendAllRanges.present() && batchStatus->sendAllRanges.get().isReady()) && (batchStatus->sendAllLogs.present() && batchStatus->sendAllLogs.get().isReady()))
															#line 5060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 796 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->finishedSendingVB = std::max(self->finishedSendingVB, req.batchIndex);
															#line 797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			batchData->kvOpsPerLP.clear();
															#line 5066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleSendMutationsRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleSendMutationsRequestActor*>(this)->ActorCallback< HandleSendMutationsRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleSendMutationsRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleSendMutationsRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreSendMutationsToAppliersRequest req;
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<RestoreLoaderData> self;
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<LoaderBatchData> batchData;
															#line 707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<LoaderBatchStatus> batchStatus;
															#line 708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	bool isDuplicated;
															#line 5159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleSendMutationsRequest()
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleSendMutationsRequestActor final : public Actor<Void>, public ActorCallback< HandleSendMutationsRequestActor, 0, Void >, public ActorCallback< HandleSendMutationsRequestActor, 1, Void >, public ActorCallback< HandleSendMutationsRequestActor, 2, Void >, public FastAllocated<HandleSendMutationsRequestActor>, public HandleSendMutationsRequestActorState<HandleSendMutationsRequestActor> {
															#line 5164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleSendMutationsRequestActor>::operator new;
	using FastAllocated<HandleSendMutationsRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6459437592167211776UL, 5051298388113937664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleSendMutationsRequestActor, 0, Void >;
friend struct ActorCallback< HandleSendMutationsRequestActor, 1, Void >;
friend struct ActorCallback< HandleSendMutationsRequestActor, 2, Void >;
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleSendMutationsRequestActor(RestoreSendMutationsToAppliersRequest const& req,Reference<RestoreLoaderData> const& self,Database const& cx) 
															#line 5183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleSendMutationsRequestActorState<HandleSendMutationsRequestActor>(req, self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8573583701915677184UL, 1417748668425823488UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleSendMutationsRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleSendMutationsRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleSendMutationsRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleSendMutationsRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleSendMutationsRequestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> handleSendMutationsRequest( RestoreSendMutationsToAppliersRequest const& req, Reference<RestoreLoaderData> const& self, Database const& cx ) {
															#line 703 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new HandleSendMutationsRequestActor(req, self, cx));
															#line 5218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

void buildApplierRangeMap(KeyRangeMap<UID>* krMap, std::map<Key, UID>* pRangeToApplier) {
	std::map<Key, UID>::iterator beginKey = pRangeToApplier->begin();
	std::map<Key, UID>::iterator endKey = std::next(beginKey, 1);
	while (endKey != pRangeToApplier->end()) {
		krMap->insert(KeyRangeRef(beginKey->first, endKey->first), beginKey->second);
		beginKey = endKey;
		endKey++;
	}
	if (beginKey != pRangeToApplier->end()) {
		krMap->insert(KeyRangeRef(beginKey->first, allKeys.end), beginKey->second);
	}
}

// Assume: kvOps data are from the same RestoreAsset.
// Input: pkvOps: versioned kv mutation for the asset in the version batch (batchIndex)
//   isRangeFile: is pkvOps from range file? Let receiver (applier) know if the mutation is log mutation;
//   pRangeToApplier: range to applierID mapping, deciding which applier is responsible for which range
//   pApplierInterfaces: applier interfaces to send the mutations to
															#line 5241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sendMutationsToApplier()
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class SendMutationsToApplierActor>
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class SendMutationsToApplierActorState {
															#line 5248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SendMutationsToApplierActorState(std::priority_queue<RestoreLoaderSchedSendLoadParamRequest>* const& sendLoadParamQueue,std::map<int, int>* const& inflightSendLoadParamReqs,NotifiedVersion* const& finishedBatch,VersionedMutationsMap* const& pkvOps,int const& batchIndex,RestoreAsset const& asset,bool const& isRangeFile,std::map<Key, UID>* const& pRangeToApplier,std::map<UID, RestoreApplierInterface>* const& pApplierInterfaces,Database const& cx) 
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : sendLoadParamQueue(sendLoadParamQueue),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   inflightSendLoadParamReqs(inflightSendLoadParamReqs),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   finishedBatch(finishedBatch),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pkvOps(pkvOps),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   batchIndex(batchIndex),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   isRangeFile(isRangeFile),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pRangeToApplier(pRangeToApplier),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pApplierInterfaces(pApplierInterfaces),
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOps(*pkvOps),
															#line 839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOp(kvOps.begin()),
															#line 840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvCount(0),
															#line 841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   splitMutationIndex(0),
															#line 842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   msgIndex(1),
															#line 843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   applierIDs(getApplierIDs(*pRangeToApplier)),
															#line 844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   msgSize(0),
															#line 845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   arena()
															#line 5289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sendMutationsToApplier", reinterpret_cast<unsigned long>(this));

	}
	~SendMutationsToApplierActorState() 
	{
		fdb_probe_actor_destroy("sendMutationsToApplier", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Promise<Void> toSched;
															#line 849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			sendLoadParamQueue->push(RestoreLoaderSchedSendLoadParamRequest(batchIndex, toSched, now()));
															#line 850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = toSched.getFuture();
															#line 850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state = 1;
															#line 850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendMutationsToApplierActor, 0, Void >*>(static_cast<SendMutationsToApplierActor*>(this)));
															#line 5315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendMutationsToApplierActorState();
		static_cast<SendMutationsToApplierActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (finishedBatch->get() >= batchIndex)
															#line 5338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevError, "FastRestoreLoaderSendMutationToApplierLateRequest") .detail("FinishedBatchIndex", finishedBatch->get()) .detail("RequestBatchIndex", batchIndex);
															#line 855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(false);
															#line 856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!static_cast<SendMutationsToApplierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsToApplierActorState(); static_cast<SendMutationsToApplierActor*>(this)->destroy(); return 0; }
															#line 5346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			new (&static_cast<SendMutationsToApplierActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SendMutationsToApplierActorState();
			static_cast<SendMutationsToApplierActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		(*inflightSendLoadParamReqs)[batchIndex]++;
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderSendMutationToApplier") .detail("IsRangeFile", isRangeFile) .detail("EndVersion", asset.endVersion) .detail("RestoreAsset", asset.toString());
															#line 867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (kvOps.lower_bound(LogMessageVersion(asset.endVersion)) != kvOps.end())
															#line 5358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevError, "FastRestoreLoaderSendMutationToApplier") .detail("BatchIndex", batchIndex) .detail("RestoreAsset", asset.toString()) .detail("IsRangeFile", isRangeFile) .detail("Data loss at version", asset.endVersion);
															#line 5362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps[LogMessageVersion(asset.endVersion)] = MutationsVec();
															#line 5368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		splitMutationIndex = 0;
															#line 879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		kvCount = 0;
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		applierVersionedMutationsBuffer = std::map<UID, VersionedMutationsVec>();
															#line 883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		mIndex = 0;
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		commitVersion = LogMessageVersion();
															#line 885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		fSends = std::vector<Future<Void>>();
															#line 886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for( auto& applierID : applierIDs ) {
															#line 887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			applierVersionedMutationsBuffer[applierID] = VersionedMutationsVec();
															#line 5386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		krMap = KeyRangeMap<UID>();
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		buildApplierRangeMap(&krMap, pRangeToApplier);
															#line 891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(kvOp = kvOps.begin();kvOp != kvOps.end();kvOp++) {
															#line 892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			commitVersion = kvOp->first;
															#line 893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(commitVersion.version >= asset.beginVersion);
															#line 894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(commitVersion.version <= asset.endVersion);
															#line 895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(mIndex = 0;mIndex < kvOp->second.size();mIndex++) {
															#line 896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				kvm = kvOp->second[mIndex];
															#line 898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (isRangeMutation(kvm))
															#line 5406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					MutationsVec mvector;
															#line 900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					Standalone<VectorRef<UID>> nodeIDs;
															#line 903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					splitMutation(krMap, kvm, mvector.arena(), mvector.contents(), nodeIDs.arena(), nodeIDs.contents());
															#line 904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					ASSERT(mvector.size() == nodeIDs.size());
															#line 906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (MUTATION_TRACKING_ENABLED)
															#line 5418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent&& e = debugMutation("RestoreLoaderDebugSplit", commitVersion.version, kvm);
															#line 908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						if (e.isEnabled())
															#line 5424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						{
															#line 909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							int i = 0;
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							for( auto& [key, uid] : *pRangeToApplier ) {
															#line 911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								e.detail(format("Range%d", i).c_str(), printable(key)) .detail(format("UID%d", i).c_str(), uid.toString());
															#line 913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								i++;
															#line 5434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
							}
						}
					}
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for(splitMutationIndex = 0;splitMutationIndex < mvector.size();splitMutationIndex++) {
															#line 918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						MutationRef mutation = mvector[splitMutationIndex];
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						UID applierID = nodeIDs[splitMutationIndex];
															#line 920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						DEBUG_MUTATION("RestoreLoaderSplitMutation", commitVersion.version, mutation) .detail("CommitVersion", commitVersion.toString());
															#line 924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						applierVersionedMutationsBuffer[applierID].push_back_deep( applierVersionedMutationsBuffer[applierID].arena(), VersionedMutationSerialized(mutation, commitVersion));
															#line 927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						msgSize += mutation.expectedSize();
															#line 929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						kvCount++;
															#line 5452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					std::map<Key, UID>::iterator itlow = pRangeToApplier->upper_bound(kvm.param1);
															#line 933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					--itlow;
															#line 934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					ASSERT(itlow->first <= kvm.param1);
															#line 935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					UID applierID = itlow->second;
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					kvCount++;
															#line 938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					DEBUG_MUTATION("RestoreLoaderSendMutation", commitVersion.version, kvm) .detail("Applier", applierID) .detail("SubVersion", commitVersion.toString());
															#line 942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					applierVersionedMutationsBuffer[applierID].push_back(applierVersionedMutationsBuffer[applierID].arena(), VersionedMutationSerialized(kvm, commitVersion));
															#line 944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgSize += kvm.expectedSize();
															#line 5473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
															#line 949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (msgSize >= SERVER_KNOBS->FASTRESTORE_LOADER_SEND_MUTATION_MSG_BYTES)
															#line 5477 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					std::vector<std::pair<UID, RestoreSendVersionedMutationsRequest>> requests;
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					requests.reserve(applierIDs.size());
															#line 952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for( const UID& applierID : applierIDs ) {
															#line 953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						requests.emplace_back( applierID, RestoreSendVersionedMutationsRequest( batchIndex, asset, msgIndex, isRangeFile, applierVersionedMutationsBuffer[applierID]));
															#line 5487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
															#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevInfo, "FastRestoreLoaderSendMutationToApplier") .detail("MessageIndex", msgIndex) .detail("RestoreAsset", asset.toString()) .detail("Requests", requests.size());
															#line 962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					fSends.push_back(sendBatchRequests(&RestoreApplierInterface::sendMutationVector, *pApplierInterfaces, requests, TaskPriority::RestoreLoaderSendMutations));
															#line 966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgIndex++;
															#line 967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgSize = 0;
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for( auto& applierID : applierIDs ) {
															#line 969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						applierVersionedMutationsBuffer[applierID] = VersionedMutationsVec();
															#line 5501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (msgSize > 0)
															#line 5508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::vector<std::pair<UID, RestoreSendVersionedMutationsRequest>> requests;
															#line 979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			requests.reserve(applierIDs.size());
															#line 980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for( const UID& applierID : applierIDs ) {
															#line 981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				requests.emplace_back( applierID, RestoreSendVersionedMutationsRequest( batchIndex, asset, msgIndex, isRangeFile, applierVersionedMutationsBuffer[applierID]));
															#line 5518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreLoaderSendMutationToApplier") .detail("MessageIndex", msgIndex) .detail("RestoreAsset", asset.toString()) .detail("Requests", requests.size());
															#line 990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			fSends.push_back(sendBatchRequests(&RestoreApplierInterface::sendMutationVector, *pApplierInterfaces, requests, TaskPriority::RestoreLoaderSendMutations));
															#line 5524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fSends);
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state = 2;
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendMutationsToApplierActor, 1, Void >*>(static_cast<SendMutationsToApplierActor*>(this)));
															#line 5535 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 851 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (finishedBatch->get() >= batchIndex)
															#line 5544 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevError, "FastRestoreLoaderSendMutationToApplierLateRequest") .detail("FinishedBatchIndex", finishedBatch->get()) .detail("RequestBatchIndex", batchIndex);
															#line 855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(false);
															#line 856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!static_cast<SendMutationsToApplierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsToApplierActorState(); static_cast<SendMutationsToApplierActor*>(this)->destroy(); return 0; }
															#line 5552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			new (&static_cast<SendMutationsToApplierActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SendMutationsToApplierActorState();
			static_cast<SendMutationsToApplierActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		(*inflightSendLoadParamReqs)[batchIndex]++;
															#line 861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderSendMutationToApplier") .detail("IsRangeFile", isRangeFile) .detail("EndVersion", asset.endVersion) .detail("RestoreAsset", asset.toString());
															#line 867 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (kvOps.lower_bound(LogMessageVersion(asset.endVersion)) != kvOps.end())
															#line 5564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevError, "FastRestoreLoaderSendMutationToApplier") .detail("BatchIndex", batchIndex) .detail("RestoreAsset", asset.toString()) .detail("IsRangeFile", isRangeFile) .detail("Data loss at version", asset.endVersion);
															#line 5568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps[LogMessageVersion(asset.endVersion)] = MutationsVec();
															#line 5574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 878 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		splitMutationIndex = 0;
															#line 879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		kvCount = 0;
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		applierVersionedMutationsBuffer = std::map<UID, VersionedMutationsVec>();
															#line 883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		mIndex = 0;
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		commitVersion = LogMessageVersion();
															#line 885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		fSends = std::vector<Future<Void>>();
															#line 886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for( auto& applierID : applierIDs ) {
															#line 887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			applierVersionedMutationsBuffer[applierID] = VersionedMutationsVec();
															#line 5592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		krMap = KeyRangeMap<UID>();
															#line 890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		buildApplierRangeMap(&krMap, pRangeToApplier);
															#line 891 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(kvOp = kvOps.begin();kvOp != kvOps.end();kvOp++) {
															#line 892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			commitVersion = kvOp->first;
															#line 893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(commitVersion.version >= asset.beginVersion);
															#line 894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(commitVersion.version <= asset.endVersion);
															#line 895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(mIndex = 0;mIndex < kvOp->second.size();mIndex++) {
															#line 896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				kvm = kvOp->second[mIndex];
															#line 898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (isRangeMutation(kvm))
															#line 5612 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					MutationsVec mvector;
															#line 900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					Standalone<VectorRef<UID>> nodeIDs;
															#line 903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					splitMutation(krMap, kvm, mvector.arena(), mvector.contents(), nodeIDs.arena(), nodeIDs.contents());
															#line 904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					ASSERT(mvector.size() == nodeIDs.size());
															#line 906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (MUTATION_TRACKING_ENABLED)
															#line 5624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 907 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						TraceEvent&& e = debugMutation("RestoreLoaderDebugSplit", commitVersion.version, kvm);
															#line 908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						if (e.isEnabled())
															#line 5630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						{
															#line 909 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							int i = 0;
															#line 910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							for( auto& [key, uid] : *pRangeToApplier ) {
															#line 911 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								e.detail(format("Range%d", i).c_str(), printable(key)) .detail(format("UID%d", i).c_str(), uid.toString());
															#line 913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								i++;
															#line 5640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
							}
						}
					}
															#line 917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for(splitMutationIndex = 0;splitMutationIndex < mvector.size();splitMutationIndex++) {
															#line 918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						MutationRef mutation = mvector[splitMutationIndex];
															#line 919 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						UID applierID = nodeIDs[splitMutationIndex];
															#line 920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						DEBUG_MUTATION("RestoreLoaderSplitMutation", commitVersion.version, mutation) .detail("CommitVersion", commitVersion.toString());
															#line 924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						applierVersionedMutationsBuffer[applierID].push_back_deep( applierVersionedMutationsBuffer[applierID].arena(), VersionedMutationSerialized(mutation, commitVersion));
															#line 927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						msgSize += mutation.expectedSize();
															#line 929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						kvCount++;
															#line 5658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					std::map<Key, UID>::iterator itlow = pRangeToApplier->upper_bound(kvm.param1);
															#line 933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					--itlow;
															#line 934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					ASSERT(itlow->first <= kvm.param1);
															#line 935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					UID applierID = itlow->second;
															#line 936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					kvCount++;
															#line 938 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					DEBUG_MUTATION("RestoreLoaderSendMutation", commitVersion.version, kvm) .detail("Applier", applierID) .detail("SubVersion", commitVersion.toString());
															#line 942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					applierVersionedMutationsBuffer[applierID].push_back(applierVersionedMutationsBuffer[applierID].arena(), VersionedMutationSerialized(kvm, commitVersion));
															#line 944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgSize += kvm.expectedSize();
															#line 5679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
															#line 949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (msgSize >= SERVER_KNOBS->FASTRESTORE_LOADER_SEND_MUTATION_MSG_BYTES)
															#line 5683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					std::vector<std::pair<UID, RestoreSendVersionedMutationsRequest>> requests;
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					requests.reserve(applierIDs.size());
															#line 952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for( const UID& applierID : applierIDs ) {
															#line 953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						requests.emplace_back( applierID, RestoreSendVersionedMutationsRequest( batchIndex, asset, msgIndex, isRangeFile, applierVersionedMutationsBuffer[applierID]));
															#line 5693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
															#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevInfo, "FastRestoreLoaderSendMutationToApplier") .detail("MessageIndex", msgIndex) .detail("RestoreAsset", asset.toString()) .detail("Requests", requests.size());
															#line 962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					fSends.push_back(sendBatchRequests(&RestoreApplierInterface::sendMutationVector, *pApplierInterfaces, requests, TaskPriority::RestoreLoaderSendMutations));
															#line 966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgIndex++;
															#line 967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					msgSize = 0;
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					for( auto& applierID : applierIDs ) {
															#line 969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						applierVersionedMutationsBuffer[applierID] = VersionedMutationsVec();
															#line 5707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (msgSize > 0)
															#line 5714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::vector<std::pair<UID, RestoreSendVersionedMutationsRequest>> requests;
															#line 979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			requests.reserve(applierIDs.size());
															#line 980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for( const UID& applierID : applierIDs ) {
															#line 981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				requests.emplace_back( applierID, RestoreSendVersionedMutationsRequest( batchIndex, asset, msgIndex, isRangeFile, applierVersionedMutationsBuffer[applierID]));
															#line 5724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreLoaderSendMutationToApplier") .detail("MessageIndex", msgIndex) .detail("RestoreAsset", asset.toString()) .detail("Requests", requests.size());
															#line 990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			fSends.push_back(sendBatchRequests(&RestoreApplierInterface::sendMutationVector, *pApplierInterfaces, requests, TaskPriority::RestoreLoaderSendMutations));
															#line 5730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fSends);
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state = 2;
															#line 995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendMutationsToApplierActor, 1, Void >*>(static_cast<SendMutationsToApplierActor*>(this)));
															#line 5741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state > 0) static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state = 0;
		static_cast<SendMutationsToApplierActor*>(this)->ActorCallback< SendMutationsToApplierActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendMutationsToApplierActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendMutationsToApplierActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendMutationsToApplierActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		(*inflightSendLoadParamReqs)[batchIndex]--;
															#line 999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (finishedBatch->get() < batchIndex)
															#line 5827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps = VersionedMutationsMap();
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent("FastRestoreLoaderSendMutationToApplierDone") .detail("BatchIndex", batchIndex) .detail("RestoreAsset", asset.toString()) .detail("Mutations", kvCount);
															#line 5833 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevWarnAlways, "FastRestoreLoaderSendMutationToApplierDoneTooLate") .detail("BatchIndex", batchIndex) .detail("FinishedBatchIndex", finishedBatch->get()) .detail("RestoreAsset", asset.toString()) .detail("Mutations", kvCount);
															#line 5839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<SendMutationsToApplierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsToApplierActorState(); static_cast<SendMutationsToApplierActor*>(this)->destroy(); return 0; }
															#line 5843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<SendMutationsToApplierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendMutationsToApplierActorState();
		static_cast<SendMutationsToApplierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		(*inflightSendLoadParamReqs)[batchIndex]--;
															#line 999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (finishedBatch->get() < batchIndex)
															#line 5857 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			kvOps = VersionedMutationsMap();
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent("FastRestoreLoaderSendMutationToApplierDone") .detail("BatchIndex", batchIndex) .detail("RestoreAsset", asset.toString()) .detail("Mutations", kvCount);
															#line 5863 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevWarnAlways, "FastRestoreLoaderSendMutationToApplierDoneTooLate") .detail("BatchIndex", batchIndex) .detail("FinishedBatchIndex", finishedBatch->get()) .detail("RestoreAsset", asset.toString()) .detail("Mutations", kvCount);
															#line 5869 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<SendMutationsToApplierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsToApplierActorState(); static_cast<SendMutationsToApplierActor*>(this)->destroy(); return 0; }
															#line 5873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<SendMutationsToApplierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendMutationsToApplierActorState();
		static_cast<SendMutationsToApplierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state > 0) static_cast<SendMutationsToApplierActor*>(this)->actor_wait_state = 0;
		static_cast<SendMutationsToApplierActor*>(this)->ActorCallback< SendMutationsToApplierActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendMutationsToApplierActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendMutationsToApplierActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendMutationsToApplierActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::priority_queue<RestoreLoaderSchedSendLoadParamRequest>* sendLoadParamQueue;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<int, int>* inflightSendLoadParamReqs;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion* finishedBatch;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap* pkvOps;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int batchIndex;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	bool isRangeFile;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<Key, UID>* pRangeToApplier;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<UID, RestoreApplierInterface>* pApplierInterfaces;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap& kvOps;
															#line 839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap::iterator kvOp;
															#line 840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int kvCount;
															#line 841 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int splitMutationIndex;
															#line 842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Version msgIndex;
															#line 843 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::vector<UID> applierIDs;
															#line 844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	double msgSize;
															#line 845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Arena arena;
															#line 882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<UID, VersionedMutationsVec> applierVersionedMutationsBuffer;
															#line 883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int mIndex;
															#line 884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LogMessageVersion commitVersion;
															#line 885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::vector<Future<Void>> fSends;
															#line 889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	KeyRangeMap<UID> krMap;
															#line 896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	MutationRef kvm;
															#line 6004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sendMutationsToApplier()
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class SendMutationsToApplierActor final : public Actor<Void>, public ActorCallback< SendMutationsToApplierActor, 0, Void >, public ActorCallback< SendMutationsToApplierActor, 1, Void >, public FastAllocated<SendMutationsToApplierActor>, public SendMutationsToApplierActorState<SendMutationsToApplierActor> {
															#line 6009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<SendMutationsToApplierActor>::operator new;
	using FastAllocated<SendMutationsToApplierActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8516075153031646208UL, 15765928316376283392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendMutationsToApplierActor, 0, Void >;
friend struct ActorCallback< SendMutationsToApplierActor, 1, Void >;
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SendMutationsToApplierActor(std::priority_queue<RestoreLoaderSchedSendLoadParamRequest>* const& sendLoadParamQueue,std::map<int, int>* const& inflightSendLoadParamReqs,NotifiedVersion* const& finishedBatch,VersionedMutationsMap* const& pkvOps,int const& batchIndex,RestoreAsset const& asset,bool const& isRangeFile,std::map<Key, UID>* const& pRangeToApplier,std::map<UID, RestoreApplierInterface>* const& pApplierInterfaces,Database const& cx) 
															#line 6027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SendMutationsToApplierActorState<SendMutationsToApplierActor>(sendLoadParamQueue, inflightSendLoadParamReqs, finishedBatch, pkvOps, batchIndex, asset, isRangeFile, pRangeToApplier, pApplierInterfaces, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16763716999320588800UL, 7668554472144770816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsToApplierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendMutationsToApplier");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendMutationsToApplier", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendMutationsToApplierActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SendMutationsToApplierActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> sendMutationsToApplier( std::priority_queue<RestoreLoaderSchedSendLoadParamRequest>* const& sendLoadParamQueue, std::map<int, int>* const& inflightSendLoadParamReqs, NotifiedVersion* const& finishedBatch, VersionedMutationsMap* const& pkvOps, int const& batchIndex, RestoreAsset const& asset, bool const& isRangeFile, std::map<Key, UID>* const& pRangeToApplier, std::map<UID, RestoreApplierInterface>* const& pApplierInterfaces, Database const& cx ) {
															#line 827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new SendMutationsToApplierActor(sendLoadParamQueue, inflightSendLoadParamReqs, finishedBatch, pkvOps, batchIndex, asset, isRangeFile, pRangeToApplier, pApplierInterfaces, cx));
															#line 6061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Splits a clear range mutation for Appliers and puts results of split mutations and
// Applier IDs into "mvector" and "nodeIDs" on return.
void splitMutation(const KeyRangeMap<UID>& krMap,
                   MutationRef m,
                   Arena& mvector_arena,
                   VectorRef<MutationRef>& mvector,
                   Arena& nodeIDs_arena,
                   VectorRef<UID>& nodeIDs) {
	TraceEvent(SevVerbose, "FastRestoreSplitMutation").detail("Mutation", m);
	ASSERT(mvector.empty());
	ASSERT(nodeIDs.empty());
	auto r = krMap.intersectingRanges(KeyRangeRef(m.param1, m.param2));
	for (auto i = r.begin(); i != r.end(); ++i) {
		// Calculate the overlap range
		KeyRef rangeBegin = m.param1 > i->range().begin ? m.param1 : i->range().begin;
		KeyRef rangeEnd = m.param2 < i->range().end ? m.param2 : i->range().end;
		KeyRange krange1(KeyRangeRef(rangeBegin, rangeEnd));
		mvector.push_back_deep(mvector_arena, MutationRef(MutationRef::ClearRange, rangeBegin, rangeEnd));
		nodeIDs.push_back(nodeIDs_arena, i->cvalue());
	}
}

// key_input format:
// [logRangeMutation.first][hash_value_of_commit_version:1B][bigEndian64(commitVersion)][bigEndian32(part)]
// value_input: serialized binary of mutations at the same version
bool concatenateBackupMutationForLogFile(SerializedMutationListMap* pMutationMap,
                                         Standalone<StringRef> key_input,
                                         Standalone<StringRef> val_input,
                                         const RestoreAsset& asset) {
	SerializedMutationListMap& mutationMap = *pMutationMap;
	const int key_prefix_len = sizeof(uint8_t) + sizeof(Version) + sizeof(uint32_t);

	StringRefReader readerKey(key_input, restore_corrupted_data()); // read key_input!
	int logRangeMutationFirstLength = key_input.size() - key_prefix_len;
	bool concatenated = false;

	ASSERT_WE_THINK(key_input.size() >= key_prefix_len);

	if (logRangeMutationFirstLength > 0) {
		// Strip out the [logRangeMutation.first]; otherwise, the following readerKey.consume will produce wrong value
		readerKey.consume(logRangeMutationFirstLength);
	}

	readerKey.consume<uint8_t>(); // uint8_t hashValue = readerKey.consume<uint8_t>()
	Version commitVersion = readerKey.consumeNetworkUInt64();
	// Skip mutations not in [asset.beginVersion, asset.endVersion), which is what we are only processing right now
	if (!asset.isInVersionRange(commitVersion)) {
		return false;
	}

	uint32_t part = readerKey.consumeNetworkUInt32();
	// Use commitVersion as id
	Standalone<StringRef> id = StringRef((uint8_t*)&commitVersion, sizeof(Version));

	auto it = mutationMap.find(id);
	if (it == mutationMap.end()) {
		mutationMap.emplace(id, std::make_pair(val_input, 0));
		if (part != 0) {
			TraceEvent(SevError, "FastRestoreLoader")
			    .detail("FirstPartNotZero", part)
			    .detail("KeyInput", getHexString(key_input));
		}
	} else { // Concatenate the val string with the same commitVersion
		it->second.first =
		    it->second.first.contents().withSuffix(val_input.contents()); // Assign the new Areana to the map's value
		auto& currentPart = it->second.second;
		if (part != (currentPart + 1)) {
			// Check if the same range or log file has been processed more than once!
			TraceEvent(SevError, "FastRestoreLoader")
			    .detail("CurrentPart1", currentPart)
			    .detail("CurrentPart2", part)
			    .detail("KeyInput", getHexString(key_input))
			    .detail("Hint", "Check if the same range or log file has been processed more than once");
		}
		currentPart = part;
		concatenated = true;
	}

	return concatenated;
}

// Parse the kv pair (version, serialized_mutation), which are the results parsed from log file, into
// (version, <K, V, mutationType>) pair;
// Put the parsed versioned mutations into *pkvOps.
//
// Input key: [commitVersion_of_the_mutation_batch:uint64_t];
// Input value: [includeVersion:uint64_t][val_length:uint32_t][encoded_list_of_mutations], where
// includeVersion is the serialized version in the batch commit. It is not the commitVersion in Input key.
//
// val_length is always equal to (val.size() - 12); otherwise,
// we may not get the entire mutation list for the version encoded_list_of_mutations:
// [mutation1][mutation2]...[mutationk], where
//	a mutation is encoded as [type:uint32_t][keyLength:uint32_t][valueLength:uint32_t][keyContent][valueContent]
															#line 6159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _parseSerializedMutation()
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class _parseSerializedMutationActor>
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseSerializedMutationActorState {
															#line 6166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseSerializedMutationActorState(KeyRangeMap<Version>* const& pRangeVersions,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,SerializedMutationListMap* const& pmutationMap,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,RestoreAsset const& asset,Database const& cx) 
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOpsIter(kvOpsIter),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pmutationMap(pmutationMap),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samplesIter(samplesIter),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cc(cc),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 1116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOps(&kvOpsIter->second),
															#line 1117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samples(&samplesIter->second),
															#line 1118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   mutationMapIterator(pmutationMap->begin())
															#line 6191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_parseSerializedMutation", reinterpret_cast<unsigned long>(this));

	}
	~_parseSerializedMutationActorState() 
	{
		fdb_probe_actor_destroy("_parseSerializedMutation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRMutationInfo, "FastRestoreLoaderParseSerializedLogMutation") .detail("BatchIndex", asset.batchIndex) .detail("RestoreAsset", asset.toString());
															#line 1124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			tempArena = Arena();
															#line 1125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;;) {
															#line 1126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (mutationMapIterator == pmutationMap->end())
															#line 6212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
					break;
				}
															#line 1132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				StringRef outer_k = mutationMapIterator->first.contents();
															#line 1133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				val = mutationMapIterator->second.first.contents();
															#line 1135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				StringRefReader kReader(outer_k, restore_corrupted_data());
															#line 1136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				commitVersion = kReader.consume<uint64_t>();
															#line 1138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				ASSERT_WE_THINK(asset.isInVersionRange(commitVersion));
															#line 1140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				vReader = StringRefReader(val, restore_corrupted_data());
															#line 1141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				vReader.consume<uint64_t>();
															#line 1145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				uint32_t val_length_decoded = vReader.consume<uint32_t>();
															#line 1146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				ASSERT(val_length_decoded == val.size() - sizeof(uint64_t) - sizeof(uint32_t));
															#line 1148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sub = 0;
															#line 1149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				for(;;) {
															#line 1151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (vReader.eof())
															#line 6240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 1155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					type = vReader.consume<uint32_t>();
															#line 1156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					kLen = vReader.consume<uint32_t>();
															#line 1157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					vLen = vReader.consume<uint32_t>();
															#line 1158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					k = vReader.consume(kLen);
															#line 1159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					v = vReader.consume(vLen);
															#line 1161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					mutation = MutationRef((MutationRef::Type)type, KeyRef(k, kLen), KeyRef(v, vLen));
															#line 1164 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (logMutationTooOld(pRangeVersions, mutation, commitVersion))
															#line 6258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					{
															#line 1165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						cc->oldLogMutations += 1;
															#line 6262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
						if (mutation.param1 >= asset.range.end || (isRangeMutation(mutation) && mutation.param2 < asset.range.begin) || (!isRangeMutation(mutation) && mutation.param1 < asset.range.begin))
															#line 6268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						{
						}
						else
						{
															#line 1172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ASSERT(asset.removePrefix.size() == 0);
															#line 1173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							if (isRangeMutation(mutation))
															#line 6277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
							{
															#line 1174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								mutation.param1 = mutation.param1 >= asset.range.begin ? mutation.param1 : asset.range.begin;
															#line 1175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								mutation.param2 = mutation.param2 < asset.range.end ? mutation.param2 : asset.range.end;
															#line 1177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								if (asset.hasPrefix())
															#line 6285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
								{
															#line 1178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
									mutation.param1 = mutation.param1.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 1180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
									mutation.param2 = mutation.param2.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 6291 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
								}
							}
							else
							{
															#line 1184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								if (asset.hasPrefix())
															#line 6298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
								{
															#line 1185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
									mutation.param1 = mutation.param1.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 6302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
								}
							}
															#line 1190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							cc->loadedLogBytes += mutation.totalSize();
															#line 1192 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							TraceEvent(SevFRMutationInfo, "FastRestoreDecodeLogFile") .detail("CommitVersion", commitVersion) .detail("ParsedMutation", mutation.toString());
															#line 1196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							auto it = kvOps->insert(std::make_pair(LogMessageVersion(commitVersion, sub++), MutationsVec()));
															#line 1197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ASSERT(it.second);
															#line 1198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ASSERT(sub < std::numeric_limits<int32_t>::max());
															#line 1200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							it.first->second.push_back_deep(it.first->second.arena(), mutation);
															#line 1203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ByteSampleInfo sampleInfo = isKeyValueInSample(KeyValueRef(mutation.param1, mutation.param2));
															#line 1204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							if (sampleInfo.inSample)
															#line 6321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
							{
															#line 1205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								cc->sampledLogBytes += sampleInfo.sampledSize;
															#line 1206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
								samples->push_back_deep(samples->arena(), SampledMutation(mutation.param1, sampleInfo.sampledSize));
															#line 6327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
							}
															#line 1209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ASSERT_WE_THINK(kLen >= 0 && kLen < val.size());
															#line 1210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
							ASSERT_WE_THINK(vLen >= 0 && vLen < val.size());
															#line 6333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
						}
					}
				}
															#line 1214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				mutationMapIterator++;
															#line 6339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!static_cast<_parseSerializedMutationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parseSerializedMutationActorState(); static_cast<_parseSerializedMutationActor*>(this)->destroy(); return 0; }
															#line 6343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			new (&static_cast<_parseSerializedMutationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_parseSerializedMutationActorState();
			static_cast<_parseSerializedMutationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_parseSerializedMutationActorState();
		static_cast<_parseSerializedMutationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, VersionedMutationsMap>::iterator kvOpsIter;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SerializedMutationListMap* pmutationMap;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, SampledMutationsVec>::iterator samplesIter;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LoaderCounters* cc;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 1116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap* kvOps;
															#line 1117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SampledMutationsVec* samples;
															#line 1118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SerializedMutationListMap::iterator mutationMapIterator;
															#line 1124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Arena tempArena;
															#line 1133 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	StringRef val;
															#line 1136 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	uint64_t commitVersion;
															#line 1140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	StringRefReader vReader;
															#line 1148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int sub;
															#line 1155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	uint32_t type;
															#line 1156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	uint32_t kLen;
															#line 1157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	uint32_t vLen;
															#line 1158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	const uint8_t* k;
															#line 1159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	const uint8_t* v;
															#line 1161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	MutationRef mutation;
															#line 6407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _parseSerializedMutation()
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseSerializedMutationActor final : public Actor<Void>, public FastAllocated<_parseSerializedMutationActor>, public _parseSerializedMutationActorState<_parseSerializedMutationActor> {
															#line 6412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<_parseSerializedMutationActor>::operator new;
	using FastAllocated<_parseSerializedMutationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2623712942545729280UL, 14940454861779434752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseSerializedMutationActor(KeyRangeMap<Version>* const& pRangeVersions,std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,SerializedMutationListMap* const& pmutationMap,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,RestoreAsset const& asset,Database const& cx) 
															#line 6428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _parseSerializedMutationActorState<_parseSerializedMutationActor>(pRangeVersions, kvOpsIter, pmutationMap, samplesIter, cc, asset, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_parseSerializedMutation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15016177361176697600UL, 16359698251024097536UL);
		ActorExecutionContextHelper __helper(static_cast<_parseSerializedMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_parseSerializedMutation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_parseSerializedMutation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> _parseSerializedMutation( KeyRangeMap<Version>* const& pRangeVersions, std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, SerializedMutationListMap* const& pmutationMap, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, RestoreAsset const& asset, Database const& cx ) {
															#line 1109 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new _parseSerializedMutationActor(pRangeVersions, kvOpsIter, pmutationMap, samplesIter, cc, asset, cx));
															#line 6460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Parsing the data blocks in a range file
// kvOpsIter: saves the parsed versioned-mutations for the specific LoadingParam;
// samplesIter: saves the sampled mutations from the parsed versioned-mutations;
// bc: backup container to read the backup file
// version: the version the parsed mutations should be at
// asset: RestoreAsset about which backup data should be parsed
															#line 6471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _parseRangeFileToMutationsOnLoader()
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class _parseRangeFileToMutationsOnLoaderActor>
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseRangeFileToMutationsOnLoaderActorState {
															#line 6478 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseRangeFileToMutationsOnLoaderActorState(std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,Version const& version,RestoreAsset const& asset,Database const& cx) 
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : kvOpsIter(kvOpsIter),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   samplesIter(samplesIter),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cc(cc),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   version(version),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   cx(cx),
															#line 1233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   kvOps(kvOpsIter->second),
															#line 1234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   sampleMutations(samplesIter->second)
															#line 6501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	~_parseRangeFileToMutationsOnLoaderActorState() 
	{
		fdb_probe_actor_destroy("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreDecodedRangeFile") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("Version", version) .detail("BeginVersion", asset.beginVersion) .detail("EndVersion", asset.endVersion) .detail("RestoreAsset", asset.toString());
															#line 1244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT_WE_THINK(asset.isInVersionRange(version));
															#line 1246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			blockData = Standalone<VectorRef<KeyValueRef>>();
															#line 1248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			readFileRetries = 0;
															#line 1249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 6524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_parseRangeFileToMutationsOnLoaderActorState();
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		KeyRange fileRange = KeyRangeRef(blockData.front().key, blockData.back().key);
															#line 1285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!fileRange.intersects(asset.range))
															#line 6549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parseRangeFileToMutationsOnLoaderActorState(); static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->destroy(); return 0; }
															#line 6553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			new (&static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_parseRangeFileToMutationsOnLoaderActorState();
			static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		int rangeStart = 1;
															#line 1294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		int rangeEnd = blockData.size() - 1;
															#line 1298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(;rangeStart < rangeEnd && !asset.range.contains(blockData[rangeStart].key);) {
															#line 1299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			++rangeStart;
															#line 6567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for(;rangeEnd > rangeStart && !asset.range.contains(blockData[rangeEnd - 1].key);) {
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			--rangeEnd;
															#line 6573 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		VectorRef<KeyValueRef> data = blockData.slice(rangeStart, rangeEnd);
															#line 1310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		const LogMessageVersion msgVersion(version, std::numeric_limits<int32_t>::max());
															#line 1313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		Arena tempArena;
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		for( const KeyValueRef& kv : data ) {
															#line 1316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			MutationRef m(MutationRef::Type::SetValue, kv.key, kv.value);
															#line 1318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (asset.hasPrefix())
															#line 6587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				ASSERT(asset.removePrefix.size() == 0);
															#line 1320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				m.param1 = m.param1.removePrefix(asset.removePrefix).withPrefix(asset.addPrefix, tempArena);
															#line 6593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			cc->loadedRangeBytes += m.totalSize();
															#line 1326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			auto it = kvOps.insert(std::make_pair(msgVersion, MutationsVec()));
															#line 1327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent(SevFRMutationInfo, "FastRestoreDecodeRangeFile") .detail("BatchIndex", asset.batchIndex) .detail("CommitVersion", version) .detail("ParsedMutationKV", m.toString());
															#line 1332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			it.first->second.push_back_deep(it.first->second.arena(), m);
															#line 1334 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ByteSampleInfo sampleInfo = isKeyValueInSample(KeyValueRef(m.param1, m.param2));
															#line 1335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (sampleInfo.inSample)
															#line 6607 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 1336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				cc->sampledRangeBytes += sampleInfo.sampledSize;
															#line 1337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				sampleMutations.push_back_deep(sampleMutations.arena(), SampledMutation(m.param1, sampleInfo.sampledSize));
															#line 6613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
		}
															#line 1341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parseRangeFileToMutationsOnLoaderActorState(); static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->destroy(); return 0; }
															#line 6618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_parseRangeFileToMutationsOnLoaderActorState();
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(asset.filename);
															#line 1253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 1;
															#line 1253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*>(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)));
															#line 6645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (e.code() == error_code_restore_bad_read || e.code() == error_code_restore_unsupported_file_version || e.code() == error_code_restore_corrupted_data_padding)
															#line 6680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 1265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreFileRestoreCorruptedRangeFileBlock").error(e);
															#line 1266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6686 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (e.code() == error_code_http_request_failed || e.code() == error_code_connection_failed || e.code() == error_code_timed_out || e.code() == error_code_lookup_failed)
															#line 6692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 1270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevWarnAlways, "FastRestoreDecodedRangeFileConnectionFailure") .error(e) .detail("Retries", ++readFileRetries);
															#line 1273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delayJittered(0.1);
															#line 1273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 3;
															#line 1273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >*>(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)));
															#line 6705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevError, "FastRestoreParseRangeFileOnLoaderUnexpectedError").error(e);
															#line 1276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> const& inFile,int loopDepth) 
	{
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = fileBackup::decodeRangeFileBlock(inFile, asset.offset, asset.len, cx);
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)));
															#line 6737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> && inFile,int loopDepth) 
	{
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = fileBackup::decodeRangeFileBlock(inFile, asset.offset, asset.len, cx);
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 1254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)));
															#line 6753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& inFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(inFile, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && inFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(inFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Standalone<VectorRef<KeyValueRef>> const& kvs,int loopDepth) 
	{
															#line 1256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodedRangeFile") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("DataSize", kvs.contents().size());
															#line 1260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		blockData = kvs;
															#line 6839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Standalone<VectorRef<KeyValueRef>> && kvs,int loopDepth) 
	{
															#line 1256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodedRangeFile") .detail("BatchIndex", asset.batchIndex) .detail("Filename", asset.filename) .detail("DataSize", kvs.contents().size());
															#line 1260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		blockData = kvs;
															#line 6850 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Standalone<VectorRef<KeyValueRef>> const& kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Standalone<VectorRef<KeyValueRef>> && kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, VersionedMutationsMap>::iterator kvOpsIter;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	std::map<LoadingParam, SampledMutationsVec>::iterator samplesIter;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	LoaderCounters* cc;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Version version;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Database cx;
															#line 1233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	VersionedMutationsMap& kvOps;
															#line 1234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SampledMutationsVec& sampleMutations;
															#line 1246 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> blockData;
															#line 1248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int readFileRetries;
															#line 7051 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _parseRangeFileToMutationsOnLoader()
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseRangeFileToMutationsOnLoaderActor final : public Actor<Void>, public ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >, public ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >, public ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >, public FastAllocated<_parseRangeFileToMutationsOnLoaderActor>, public _parseRangeFileToMutationsOnLoaderActorState<_parseRangeFileToMutationsOnLoaderActor> {
															#line 7056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<_parseRangeFileToMutationsOnLoaderActor>::operator new;
	using FastAllocated<_parseRangeFileToMutationsOnLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13160824661597061632UL, 11720020812447413248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >;
friend struct ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >;
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseRangeFileToMutationsOnLoaderActor(std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter,std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter,LoaderCounters* const& cc,Reference<IBackupContainer> const& bc,Version const& version,RestoreAsset const& asset,Database const& cx) 
															#line 7075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _parseRangeFileToMutationsOnLoaderActorState<_parseRangeFileToMutationsOnLoaderActor>(kvOpsIter, samplesIter, cc, bc, version, asset, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4535240017738753792UL, 10161002796720235520UL);
		ActorExecutionContextHelper __helper(static_cast<_parseRangeFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_parseRangeFileToMutationsOnLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_parseRangeFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _parseRangeFileToMutationsOnLoaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] static Future<Void> _parseRangeFileToMutationsOnLoader( std::map<LoadingParam, VersionedMutationsMap>::iterator const& kvOpsIter, std::map<LoadingParam, SampledMutationsVec>::iterator const& samplesIter, LoaderCounters* const& cc, Reference<IBackupContainer> const& bc, Version const& version, RestoreAsset const& asset, Database const& cx ) {
															#line 1225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new _parseRangeFileToMutationsOnLoaderActor(kvOpsIter, samplesIter, cc, bc, version, asset, cx));
															#line 7110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Parse data blocks in a log file into a vector of <string, string> pairs.
// Each pair.second contains the mutations at a version encoded in pair.first;
// Step 1: decodeLogFileBlock into <string, string> pairs;
// Step 2: Concatenate the second of pairs with the same pair.first.
// pProcessedFileOffset: ensure each data block is processed in order exactly once;
// pMutationMap: concatenated mutation list string at the mutation's commit version
															#line 7121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _parseLogFileToMutationsOnLoader()
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class _parseLogFileToMutationsOnLoaderActor>
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseLogFileToMutationsOnLoaderActorState {
															#line 7128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseLogFileToMutationsOnLoaderActorState(NotifiedVersion* const& pProcessedFileOffset,SerializedMutationListMap* const& pMutationMap,Reference<IBackupContainer> const& bc,RestoreAsset const& asset) 
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pProcessedFileOffset(pProcessedFileOffset),
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pMutationMap(pMutationMap),
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset)
															#line 7141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	~_parseLogFileToMutationsOnLoaderActorState() 
	{
		fdb_probe_actor_destroy("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(asset.filename);
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 1;
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*>(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7163 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_parseLogFileToMutationsOnLoaderActorState();
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& inFile,int loopDepth) 
	{
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = parallelFileRestore::decodeLogFileBlock(inFile, asset.offset, asset.len);
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && inFile,int loopDepth) 
	{
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = parallelFileRestore::decodeLogFileBlock(inFile, asset.offset, asset.len);
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& inFile,int loopDepth) 
	{
		loopDepth = a_body1cont1(inFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && inFile,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(inFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		TraceEvent("FastRestoreLoaderDecodeLogFile") .detail("BatchIndex", asset.batchIndex) .detail("RestoreAsset", asset.toString()) .detail("DataSize", data.contents().size());
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pProcessedFileOffset->whenAtLeast(asset.offset);
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 3;
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >*>(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyValueRef>> const& __data,int loopDepth) 
	{
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		data = __data;
															#line 7311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyValueRef>> && __data,int loopDepth) 
	{
		data = std::move(__data);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (pProcessedFileOffset->get() == asset.offset)
															#line 7390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for( const KeyValueRef& kv : data ) {
															#line 1369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				concatenateBackupMutationForLogFile(pMutationMap, kv.key, kv.value, asset);
															#line 7396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			pProcessedFileOffset->set(asset.offset + asset.len);
															#line 7400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parseLogFileToMutationsOnLoaderActorState(); static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->destroy(); return 0; }
															#line 7404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_parseLogFileToMutationsOnLoaderActorState();
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (pProcessedFileOffset->get() == asset.offset)
															#line 7416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for( const KeyValueRef& kv : data ) {
															#line 1369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				concatenateBackupMutationForLogFile(pMutationMap, kv.key, kv.value, asset);
															#line 7422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			pProcessedFileOffset->set(asset.offset + asset.len);
															#line 7426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1374 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_parseLogFileToMutationsOnLoaderActorState(); static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->destroy(); return 0; }
															#line 7430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_parseLogFileToMutationsOnLoaderActorState();
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion* pProcessedFileOffset;
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SerializedMutationListMap* pMutationMap;
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 1356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 7523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _parseLogFileToMutationsOnLoader()
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class _parseLogFileToMutationsOnLoaderActor final : public Actor<Void>, public ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >, public ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >, public ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >, public FastAllocated<_parseLogFileToMutationsOnLoaderActor>, public _parseLogFileToMutationsOnLoaderActorState<_parseLogFileToMutationsOnLoaderActor> {
															#line 7528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<_parseLogFileToMutationsOnLoaderActor>::operator new;
	using FastAllocated<_parseLogFileToMutationsOnLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1961082984609566720UL, 408800956228504064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >;
friend struct ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >;
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	_parseLogFileToMutationsOnLoaderActor(NotifiedVersion* const& pProcessedFileOffset,SerializedMutationListMap* const& pMutationMap,Reference<IBackupContainer> const& bc,RestoreAsset const& asset) 
															#line 7547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _parseLogFileToMutationsOnLoaderActorState<_parseLogFileToMutationsOnLoaderActor>(pProcessedFileOffset, pMutationMap, bc, asset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4697254379906928896UL, 9633597727824938240UL);
		ActorExecutionContextHelper __helper(static_cast<_parseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_parseLogFileToMutationsOnLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _parseLogFileToMutationsOnLoaderActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _parseLogFileToMutationsOnLoaderActor, 1, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _parseLogFileToMutationsOnLoaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] static Future<Void> _parseLogFileToMutationsOnLoader( NotifiedVersion* const& pProcessedFileOffset, SerializedMutationListMap* const& pMutationMap, Reference<IBackupContainer> const& bc, RestoreAsset const& asset ) {
															#line 1350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new _parseLogFileToMutationsOnLoaderActor(pProcessedFileOffset, pMutationMap, bc, asset));
															#line 7582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1376 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// retry on _parseLogFileToMutationsOnLoader
															#line 7588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via parseLogFileToMutationsOnLoader()
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class ParseLogFileToMutationsOnLoaderActor>
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class ParseLogFileToMutationsOnLoaderActorState {
															#line 7595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	ParseLogFileToMutationsOnLoaderActorState(NotifiedVersion* const& pProcessedFileOffset,SerializedMutationListMap* const& pMutationMap,Reference<IBackupContainer> const& bc,RestoreAsset const& asset) 
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : pProcessedFileOffset(pProcessedFileOffset),
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   pMutationMap(pMutationMap),
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   bc(bc),
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   asset(asset),
															#line 1382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   readFileRetries(0)
															#line 7610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	~ParseLogFileToMutationsOnLoaderActorState() 
	{
		fdb_probe_actor_destroy("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			;
															#line 7625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ParseLogFileToMutationsOnLoaderActorState();
		static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ParseLogFileToMutationsOnLoaderActorState(); static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->destroy(); return 0; }
															#line 7648 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ParseLogFileToMutationsOnLoaderActorState();
		static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = _parseLogFileToMutationsOnLoader(pProcessedFileOffset, pMutationMap, bc, asset);
															#line 1385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 1;
															#line 1385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >*>(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1388 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (e.code() == error_code_restore_bad_read || e.code() == error_code_restore_unsupported_file_version || e.code() == error_code_restore_corrupted_data_padding)
															#line 7710 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			{
															#line 1390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevError, "FastRestoreFileRestoreCorruptedLogFileBlock").error(e);
															#line 1391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1392 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (e.code() == error_code_http_request_failed || e.code() == error_code_connection_failed || e.code() == error_code_timed_out || e.code() == error_code_lookup_failed)
															#line 7722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 1395 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevWarnAlways, "FastRestoreDecodedLogFileConnectionFailure") .error(e) .detail("Retries", ++readFileRetries);
															#line 1398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					StrictFuture<Void> __when_expr_1 = delayJittered(0.1);
															#line 1398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					if (static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7730 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 2;
															#line 1398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >*>(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)));
															#line 7735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevError, "FastRestoreParseLogFileToMutationsOnLoaderUnexpectedError").error(e);
															#line 1401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state > 0) static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	NotifiedVersion* pProcessedFileOffset;
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	SerializedMutationListMap* pMutationMap;
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreAsset asset;
															#line 1382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	int readFileRetries;
															#line 7952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via parseLogFileToMutationsOnLoader()
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class ParseLogFileToMutationsOnLoaderActor final : public Actor<Void>, public ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >, public ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >, public FastAllocated<ParseLogFileToMutationsOnLoaderActor>, public ParseLogFileToMutationsOnLoaderActorState<ParseLogFileToMutationsOnLoaderActor> {
															#line 7957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<ParseLogFileToMutationsOnLoaderActor>::operator new;
	using FastAllocated<ParseLogFileToMutationsOnLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3747621673179729664UL, 10234709091709659904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >;
friend struct ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >;
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	ParseLogFileToMutationsOnLoaderActor(NotifiedVersion* const& pProcessedFileOffset,SerializedMutationListMap* const& pMutationMap,Reference<IBackupContainer> const& bc,RestoreAsset const& asset) 
															#line 7975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ParseLogFileToMutationsOnLoaderActorState<ParseLogFileToMutationsOnLoaderActor>(pProcessedFileOffset, pMutationMap, bc, asset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7147058364602684160UL, 18069780838765750016UL);
		ActorExecutionContextHelper __helper(static_cast<ParseLogFileToMutationsOnLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("parseLogFileToMutationsOnLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("parseLogFileToMutationsOnLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ParseLogFileToMutationsOnLoaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ParseLogFileToMutationsOnLoaderActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] static Future<Void> parseLogFileToMutationsOnLoader( NotifiedVersion* const& pProcessedFileOffset, SerializedMutationListMap* const& pMutationMap, Reference<IBackupContainer> const& bc, RestoreAsset const& asset ) {
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new ParseLogFileToMutationsOnLoaderActor(pProcessedFileOffset, pMutationMap, bc, asset));
															#line 8009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

// Return applier IDs that are used to apply key-values
std::vector<UID> getApplierIDs(std::map<Key, UID>& rangeToApplier) {
	std::vector<UID> applierIDs;
	applierIDs.reserve(rangeToApplier.size());
	for (auto& applier : rangeToApplier) {
		applierIDs.push_back(applier.second);
	}

	ASSERT(!applierIDs.empty());
	return applierIDs;
}

// Notify loaders that the version batch (index) has been applied.
// This affects which version batch each loader can release actors even when the worker has low memory
															#line 8028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleFinishVersionBatchRequest()
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class HandleFinishVersionBatchRequestActor>
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleFinishVersionBatchRequestActorState {
															#line 8035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleFinishVersionBatchRequestActorState(RestoreVersionBatchRequest const& req,Reference<RestoreLoaderData> const& self) 
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : req(req),
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		   self(self)
															#line 8044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleFinishVersionBatchRequestActorState() 
	{
		fdb_probe_actor_destroy("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			TraceEvent("FastRestoreLoaderHandleFinishVersionBatch", self->id()) .detail("FinishedBatchIndex", self->finishedBatch.get()) .detail("RequestedBatchIndex", req.batchIndex);
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->finishedBatch.whenAtLeast(req.batchIndex - 1);
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (static_cast<HandleFinishVersionBatchRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleFinishVersionBatchRequestActor*>(this)->actor_wait_state = 1;
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >*>(static_cast<HandleFinishVersionBatchRequestActor*>(this)));
															#line 8068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleFinishVersionBatchRequestActorState();
		static_cast<HandleFinishVersionBatchRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 8091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->loadingQueue.empty() && self->loadingQueue.top().batchIndex <= req.batchIndex;) {
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingLoadFileRequests") .detail("PendingRequest", self->loadingQueue.top().toString());
															#line 1435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->loadingQueue.pop();
															#line 8099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->sendingQueue.empty() && self->sendingQueue.top().batchIndex <= req.batchIndex;) {
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingSendRequests") .detail("PendingRequest", self->sendingQueue.top().toString());
															#line 1440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendingQueue.pop();
															#line 8107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->sendLoadParamQueue.empty() && self->sendLoadParamQueue.top().batchIndex <= req.batchIndex;) {
															#line 1443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingSendLoadParamRequests") .detail("PendingRequest", self->sendLoadParamQueue.top().toString());
															#line 1445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendLoadParamQueue.pop();
															#line 8115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->finishedBatch.set(req.batchIndex);
															#line 1450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->batch.erase(req.batchIndex);
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->status.erase(req.batchIndex);
															#line 8123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->delayedActors > 0)
															#line 8127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->checkMemory.trigger();
															#line 8131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), false));
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<HandleFinishVersionBatchRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleFinishVersionBatchRequestActorState(); static_cast<HandleFinishVersionBatchRequestActor*>(this)->destroy(); return 0; }
															#line 8137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<HandleFinishVersionBatchRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleFinishVersionBatchRequestActorState();
		static_cast<HandleFinishVersionBatchRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 8149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->loadingQueue.empty() && self->loadingQueue.top().batchIndex <= req.batchIndex;) {
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingLoadFileRequests") .detail("PendingRequest", self->loadingQueue.top().toString());
															#line 1435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->loadingQueue.pop();
															#line 8157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->sendingQueue.empty() && self->sendingQueue.top().batchIndex <= req.batchIndex;) {
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingSendRequests") .detail("PendingRequest", self->sendingQueue.top().toString());
															#line 1440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendingQueue.pop();
															#line 8165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;!self->sendLoadParamQueue.empty() && self->sendLoadParamQueue.top().batchIndex <= req.batchIndex;) {
															#line 1443 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreLoaderHasPendingSendLoadParamRequests") .detail("PendingRequest", self->sendLoadParamQueue.top().toString());
															#line 1445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				self->sendLoadParamQueue.pop();
															#line 8173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->finishedBatch.set(req.batchIndex);
															#line 1450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->batch.erase(req.batchIndex);
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->status.erase(req.batchIndex);
															#line 8181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1453 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (self->delayedActors > 0)
															#line 8185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		{
															#line 1454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			self->checkMemory.trigger();
															#line 8189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		}
															#line 1456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), false));
															#line 1457 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		if (!static_cast<HandleFinishVersionBatchRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleFinishVersionBatchRequestActorState(); static_cast<HandleFinishVersionBatchRequestActor*>(this)->destroy(); return 0; }
															#line 8195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		new (&static_cast<HandleFinishVersionBatchRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleFinishVersionBatchRequestActorState();
		static_cast<HandleFinishVersionBatchRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleFinishVersionBatchRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleFinishVersionBatchRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleFinishVersionBatchRequestActor*>(this)->ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleFinishVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleFinishVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleFinishVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	RestoreVersionBatchRequest req;
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	Reference<RestoreLoaderData> self;
															#line 8282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleFinishVersionBatchRequest()
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class HandleFinishVersionBatchRequestActor final : public Actor<Void>, public ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >, public FastAllocated<HandleFinishVersionBatchRequestActor>, public HandleFinishVersionBatchRequestActorState<HandleFinishVersionBatchRequestActor> {
															#line 8287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleFinishVersionBatchRequestActor>::operator new;
	using FastAllocated<HandleFinishVersionBatchRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11717011020993621760UL, 2282551567407209984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >;
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	HandleFinishVersionBatchRequestActor(RestoreVersionBatchRequest const& req,Reference<RestoreLoaderData> const& self) 
															#line 8304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleFinishVersionBatchRequestActorState<HandleFinishVersionBatchRequestActor>(req, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1696849145794423296UL, 12258433220474640128UL);
		ActorExecutionContextHelper __helper(static_cast<HandleFinishVersionBatchRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleFinishVersionBatchRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleFinishVersionBatchRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleFinishVersionBatchRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
[[nodiscard]] Future<Void> handleFinishVersionBatchRequest( RestoreVersionBatchRequest const& req, Reference<RestoreLoaderData> const& self ) {
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new HandleFinishVersionBatchRequestActor(req, self));
															#line 8337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}

#line 1459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

namespace {

void oldSplitMutation(std::map<Key, UID>* pRangeToApplier,
                      MutationRef m,
                      Arena& mvector_arena,
                      VectorRef<MutationRef>& mvector,
                      Arena& nodeIDs_arena,
                      VectorRef<UID>& nodeIDs) {
	// mvector[i] should be mapped to nodeID[i]
	ASSERT(mvector.empty());
	ASSERT(nodeIDs.empty());
	// key range [m->param1, m->param2)
	std::map<Key, UID>::iterator itlow, itup; // we will return [itlow, itup)
	itlow = pRangeToApplier->lower_bound(m.param1); // lower_bound returns the iterator that is >= m.param1
	if (itlow == pRangeToApplier->end()) {
		--itlow;
		mvector.push_back_deep(mvector_arena, m);
		nodeIDs.push_back(nodeIDs_arena, itlow->second);
		return;
	}
	if (itlow->first > m.param1) {
		if (itlow != pRangeToApplier->begin()) {
			--itlow;
		}
	}

	itup = pRangeToApplier->upper_bound(m.param2); // return rmap::end if no key is after m.param2.
	ASSERT(itup == pRangeToApplier->end() || itup->first > m.param2);

	std::map<Key, UID>::iterator itApplier;
	while (itlow != itup) {
		Standalone<MutationRef> curm; // current mutation
		curm.type = m.type;
		// The first split mutation should starts with m.first.
		// The later ones should start with the rangeToApplier boundary.
		if (m.param1 > itlow->first) {
			curm.param1 = m.param1;
		} else {
			curm.param1 = itlow->first;
		}
		itApplier = itlow;
		itlow++;
		if (itlow == itup) {
			ASSERT(m.param2 <= allKeys.end);
			curm.param2 = m.param2;
		} else if (m.param2 < itlow->first) {
			UNREACHABLE();
			curm.param2 = m.param2;
		} else {
			curm.param2 = itlow->first;
		}
		ASSERT(curm.param1 <= curm.param2);
		// itup > m.param2: (itup-1) may be out of mutation m's range
		// Ensure the added mutations have overlap with mutation m
		if (m.param1 < curm.param2 && m.param2 > curm.param1) {
			mvector.push_back_deep(mvector_arena, curm);
			nodeIDs.push_back(nodeIDs_arena, itApplier->second);
		}
	}
}

// Test splitMutation
															#line 8404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase1522()
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
template <class FlowTestCase1522Actor>
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class FlowTestCase1522ActorState {
															#line 8410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	FlowTestCase1522ActorState(UnitTestParameters const& params) 
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
		 : params(params)
															#line 8417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1522", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1522ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1522", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			std::map<Key, UID> rangeToApplier;
															#line 1524 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			MutationsVec mvector;
															#line 1525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Standalone<VectorRef<UID>> nodeIDs;
															#line 1528 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			rangeToApplier.emplace(allKeys.begin, deterministicRandom()->randomUniqueID());
															#line 1529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			int numAppliers = deterministicRandom()->randomInt(1, 50);
															#line 1530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(int i = 0;i < numAppliers;++i) {
															#line 1531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				Key k = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(1, 1000)));
															#line 1532 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				UID node = deterministicRandom()->randomUniqueID();
															#line 1533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				rangeToApplier.emplace(k, node);
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent("RangeToApplier").detail("Key", k).detail("Node", node);
															#line 8450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			}
															#line 1536 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Key k1 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(1, 500)));
															#line 1537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Key k2 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(1, 1000)));
															#line 1538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Key beginK = k1 < k2 ? k1 : k2;
															#line 1539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Key endK = k1 < k2 ? k2 : k1;
															#line 1540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Standalone<MutationRef> mutation(MutationRef(MutationRef::ClearRange, beginK.contents(), endK.contents()));
															#line 1543 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			oldSplitMutation( &rangeToApplier, mutation, mvector.arena(), mvector.contents(), nodeIDs.arena(), nodeIDs.contents());
															#line 1545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(mvector.size() == nodeIDs.size());
															#line 1548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			KeyRangeMap<UID> krMap;
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			buildApplierRangeMap(&krMap, &rangeToApplier);
															#line 1551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			MutationsVec mvector2;
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			Standalone<VectorRef<UID>> nodeIDs2;
															#line 1553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			splitMutation(krMap, mutation, mvector2.arena(), mvector2.contents(), nodeIDs2.arena(), nodeIDs2.contents());
															#line 1554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(mvector2.size() == nodeIDs2.size());
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			ASSERT(mvector.size() == mvector2.size());
															#line 1557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			int splitMutationIndex = 0;
															#line 1558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			for(;splitMutationIndex < mvector.size();splitMutationIndex++) {
															#line 1559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				MutationRef result = mvector[splitMutationIndex];
															#line 1560 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				MutationRef result2 = mvector2[splitMutationIndex];
															#line 1561 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				UID applierID = nodeIDs[splitMutationIndex];
															#line 1562 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				UID applierID2 = nodeIDs2[splitMutationIndex];
															#line 1563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				KeyRange krange(KeyRangeRef(result.param1, result.param2));
															#line 1564 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				KeyRange krange2(KeyRangeRef(result2.param1, result2.param2));
															#line 1565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				TraceEvent("Result") .detail("KeyRange1", krange) .detail("KeyRange2", krange2) .detail("ApplierID1", applierID) .detail("ApplierID2", applierID2);
															#line 1570 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
				if (krange != krange2 || applierID != applierID2)
															#line 8500 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				{
															#line 1571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
					TraceEvent(SevError, "IncorrectResult") .detail("Mutation", mutation) .detail("KeyRange1", krange) .detail("KeyRange2", krange2) .detail("ApplierID1", applierID) .detail("ApplierID2", applierID2);
															#line 8504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
				}
			}
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
			if (!static_cast<FlowTestCase1522Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1522ActorState(); static_cast<FlowTestCase1522Actor*>(this)->destroy(); return 0; }
															#line 8509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1522Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1522ActorState();
			static_cast<FlowTestCase1522Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1522ActorState();
		static_cast<FlowTestCase1522Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	UnitTestParameters params;
															#line 8533 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1522()
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
class FlowTestCase1522Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1522Actor>, public FlowTestCase1522ActorState<FlowTestCase1522Actor> {
															#line 8538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1522Actor>::operator new;
	using FastAllocated<FlowTestCase1522Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10156899289113499904UL, 46194640212999168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	FlowTestCase1522Actor(UnitTestParameters const& params) 
															#line 8554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1522ActorState<FlowTestCase1522Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1522", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(890763992424678400UL, 7828399482479424768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1522Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1522");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1522", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
static Future<Void> flowTestCase1522( UnitTestParameters const& params ) {
															#line 1522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"
	return Future<Void>(new FlowTestCase1522Actor(params));
															#line 8585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreLoader.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1522, "/FastRestore/RestoreLoader/splitMutation")

#line 1582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/RestoreLoader.actor.cpp"

} // namespace
