#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
/*
 * ClusterController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>
#include <map>
#include <memory>
#include <set>
#include <tuple>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/LeaderElection.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SingletonRoles.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbrpc/sim_validation.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 76 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getPreviousCoordinators()
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class GetPreviousCoordinatorsActor>
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActorState {
															#line 83 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActorState(ClusterControllerData* const& self) 
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 75 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(self->db.db)
															#line 92 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~GetPreviousCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 78 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 79 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 80 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 81 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(previousCoordinatorsKey);
															#line 81 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 151 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 84 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
															#line 82 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && previousCoordinators,int loopDepth) 
	{
															#line 82 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previousCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previousCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 75 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 381 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getPreviousCoordinators()
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActor final : public Actor<Optional<Value>>, public ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< GetPreviousCoordinatorsActor, 1, Void >, public FastAllocated<GetPreviousCoordinatorsActor>, public GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor> {
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetPreviousCoordinatorsActor>::operator new;
	using FastAllocated<GetPreviousCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4928153165462512384UL, 369380660428864256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetPreviousCoordinatorsActor, 1, Void >;
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActor(ClusterControllerData* const& self) 
															#line 404 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9522256357088947712UL, 3090868322878582016UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPreviousCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getPreviousCoordinators( ClusterControllerData* const& self ) {
															#line 74 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Optional<Value>>(new GetPreviousCoordinatorsActor(self));
															#line 438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 88 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

bool ClusterControllerData::processesInSameDC(const NetworkAddress& addr1, const NetworkAddress& addr2) const {
	return this->addr_locality.contains(addr1) && this->addr_locality.contains(addr2) &&
	       this->addr_locality.at(addr1).dcId().present() && this->addr_locality.at(addr2).dcId().present() &&
	       this->addr_locality.at(addr1).dcId().get() == this->addr_locality.at(addr2).dcId().get();
}

bool ClusterControllerData::transactionSystemContainsDegradedServers() {
	const ServerDBInfo& dbi = db.serverInfo->get();
	const Reference<ClusterRecoveryData> recoveryData = db.recoveryData;
	auto transactionWorkerInList = [&dbi, &recoveryData](const std::unordered_set<NetworkAddress>& serverList,
	                                                     bool skipSatellite,
	                                                     bool skipRemoteTLog,
	                                                     bool skipRemoteLogRouter) -> bool {
		for (const auto& server : serverList) {
			if (dbi.master.addresses().contains(server)) {
				return true;
			}

			// Getting the current log system config to check if any TLogs are degraded. recoveryData->logSystem has the
			// most up to date log system and we should use it whenever available.
			auto logSystemConfig = (recoveryData.isValid() && recoveryData->logSystem.isValid())
			                           ? recoveryData->logSystem->getLogSystemConfig()
			                           : dbi.logSystemConfig;
			for (const auto& logSet : logSystemConfig.tLogs) {
				if (skipSatellite && logSet.locality == tagLocalitySatellite) {
					continue;
				}

				if (!logSet.isLocal) {
					if (!skipRemoteTLog) {
						for (const auto& tlog : logSet.tLogs) {
							if (tlog.present() && tlog.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
					if (!skipRemoteLogRouter) {
						for (const auto& logRouter : logSet.logRouters) {
							if (logRouter.present() && logRouter.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
				} else {
					for (const auto& tlog : logSet.tLogs) {
						if (tlog.present() && tlog.interf().addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			if (SERVER_KNOBS->GRAY_FAILURE_ENABLE_TLOG_RECOVERY_MONITORING && recoveryData.isValid() &&
			    recoveryData->recoveryState < RecoveryState::ACCEPTING_COMMITS) {
				// During recovery, TLogs may not be able to pull data from previous generation TLogs due to gray
				// failures. In this case, we rely on the latest recruitment information and see if any newly recruited
				// TLogs are degraded.
				for (const auto& tlog : recoveryData->primaryRecruitment.tLogs) {
					if (tlog.addresses().contains(server)) {
						return true;
					}
				}

				if (!skipSatellite) {
					for (const auto& satelliteLog : recoveryData->primaryRecruitment.satelliteTLogs) {
						if (satelliteLog.addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			for (const auto& proxy : dbi.client.grvProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& proxy : dbi.client.commitProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& resolver : dbi.resolvers) {
				if (resolver.addresses().contains(server)) {
					return true;
				}
			}
		}
		return false;
	};

	// Check if transaction system contains degraded/disconnected servers. For satellite, we only
	// check for disconnection since the latency between prmary and satellite is across WAN and may not be very
	// stable.
	// TODO: Consider adding satellite latency degradation check and rely on
	//       SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY for accurate health signal
	return transactionWorkerInList(degradationInfo.degradedServers,
	                               /*skipSatellite=*/true,
	                               /*skipRemoteTLog=*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DEGRADATION_MONITORING),
	                               /*skipRemoteLogRouter*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DEGRADATION_MONITORING)) ||
	       transactionWorkerInList(
	           degradationInfo.disconnectedServers,
	           /*skipSatellite=*/false,
	           /*skipRemoteTLog=*/!SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DISCONNECT_MONITORING,
	           /*skipRemoteLogRouter*/ !SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DISCONNECT_MONITORING);
}

bool ClusterControllerData::remoteTransactionSystemContainsDegradedServers() {
	if (db.config.usableRegions <= 1) {
		return false;
	}

	for (const auto& excludedServer : degradationInfo.degradedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	for (const auto& excludedServer : degradationInfo.disconnectedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	return false;
}

// Recruit failed log routers in parallel
															#line 577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recruitFailedLogRouters()
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RecruitFailedLogRoutersActor>
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedLogRoutersActorState {
															#line 584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedLogRoutersActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tagIds(tagIds),
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(logSetIndex),
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSystem(logSystem),
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(config),
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   targetDcId(db->recoveryData->remoteDcIds.size() ? db->recoveryData->remoteDcIds[0] : Optional<Key>())
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~RecruitFailedLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 233 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateKnownIds(&id_used);
															#line 236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers = cluster->getWorkersForRoleInDatacenter(targetDcId, ProcessClass::LogRouter, tagIds.size(), db->config, id_used);
															#line 239 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (workers.size() < tagIds.size())
															#line 624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "NotEnoughWorkersForLogRouters", cluster->id) .detail("Required", tagIds.size()) .detail("Available", workers.size()) .detail("TargetDcId", targetDcId);
															#line 244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("RecruitingLogRouters", cluster->id) .detail("Count", tagIds.size()) .detail("LogSetIndex", logSetIndex) .detail("TargetDcId", targetDcId);
															#line 255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitments = std::vector<Future<ErrorOr<TLogInterface>>>();
															#line 257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < tagIds.size();i++) {
															#line 258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				InitializeLogRouterRequest req;
															#line 260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reqId = deterministicRandom()->randomUniqueID();
															#line 261 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.recoveryCount = db->recoveryData->cstate.myDBState.recoveryCount;
															#line 262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.routerTag = routerTag;
															#line 265 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.startVersion = 0;
															#line 266 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.locality = config.tLogs[logSetIndex].locality;
															#line 267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.isReplacement = true;
															#line 269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				for( auto& tLogSet : config.tLogs ) {
															#line 270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!tLogSet.isLocal && tLogSet.tLogs.size() > 0)
															#line 658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 271 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogLocalities = tLogSet.tLogLocalities;
															#line 272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogPolicy = tLogSet.tLogPolicy;
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (db->recoveryData->logSystem.isValid())
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 278 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					auto lsConfig = db->recoveryData->logSystem->getLogSystemConfig();
															#line 279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (lsConfig.recoveredAt.present())
															#line 676 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.recoverAt = lsConfig.recoveredAt.get();
															#line 680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
															#line 284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.allowDropInSim = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(req.allowDropInSim, "Log router recruitment requests dropped in simulation");
															#line 287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("RecruitingLogRouterOnWorker", cluster->id) .detail("WorkerID", workers[i].interf.id()) .detail("Tag", routerTag) .detail("TagId", tagIds[i]);
															#line 292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				recruitments.push_back(workers[i].interf.logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY));
															#line 691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			timeout = delay(SERVER_KNOBS->CC_RERECRUIT_LOG_ROUTER_TIMEOUT);
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(recruitments) || timeout;
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*>(static_cast<RecruitFailedLogRoutersActor*>(this)));
															#line 704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 727 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedLogRoutersActorState(); static_cast<RecruitFailedLogRoutersActor*>(this)->destroy(); return 0; }
															#line 765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedLogRoutersActorState(); static_cast<RecruitFailedLogRoutersActor*>(this)->destroy(); return 0; }
															#line 815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitFailedLogRoutersActor*>(this)->ActorCallback< RecruitFailedLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> tagIds;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 229 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Key> targetDcId;
															#line 236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<ErrorOr<TLogInterface>>> recruitments;
															#line 297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> timeout;
															#line 918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recruitFailedLogRouters()
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedLogRoutersActor final : public Actor<Void>, public ActorCallback< RecruitFailedLogRoutersActor, 0, Void >, public FastAllocated<RecruitFailedLogRoutersActor>, public RecruitFailedLogRoutersActorState<RecruitFailedLogRoutersActor> {
															#line 923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecruitFailedLogRoutersActor>::operator new;
	using FastAllocated<RecruitFailedLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7947739075492653568UL, 6091033238021106944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitFailedLogRoutersActor, 0, Void >;
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedLogRoutersActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RecruitFailedLogRoutersActorState<RecruitFailedLogRoutersActor>(cluster, db, tagIds, logSetIndex, logSystem, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13500469936385790208UL, 18191486286878409728UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitFailedLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> recruitFailedLogRouters( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, std::vector<int> const& tagIds, int const& logSetIndex, Reference<ILogSystem> const& logSystem, LogSystemConfig const& config ) {
															#line 223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RecruitFailedLogRoutersActor(cluster, db, tagIds, logSetIndex, logSystem, config));
															#line 973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorLogRouters()
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorLogRoutersActor>
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorLogRoutersActorState {
															#line 985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorLogRoutersActorState(Reference<ILogSystem> const& logSystem,int const& logSetIndex) 
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : logSystem(logSystem),
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(logSetIndex),
															#line 339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failures(),
															#line 340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(logSystem->getLogSystemConfig()),
															#line 341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failedTagIds()
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~MonitorLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("monitorLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (logSetIndex == -1)
															#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				this->~MonitorLogRoutersActorState();
															#line 1019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				static_cast<MonitorLogRoutersActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT_WE_THINK(logSetIndex >= 0 && logSetIndex < config.tLogs.size());
															#line 349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < config.tLogs[logSetIndex].logRouters.size();i++) {
															#line 350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(config.tLogs[logSetIndex].logRouters[i].present());
															#line 351 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = config.tLogs[logSetIndex].logRouters[i];
															#line 352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failures.push_back( waitFailureClient(worker.interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true, "LogRouterFailed"_sr));
															#line 1033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures.empty())
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				this->~MonitorLogRoutersActorState();
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				static_cast<MonitorLogRoutersActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(failures, 1);
															#line 364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorLogRoutersActor, 0, Void >*>(static_cast<MonitorLogRoutersActor*>(this)));
															#line 1054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 1079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 1083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorLogRoutersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorLogRoutersActorState(); static_cast<MonitorLogRoutersActor*>(this)->destroy(); return 0; }
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorLogRoutersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 1102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 1106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorLogRoutersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorLogRoutersActorState(); static_cast<MonitorLogRoutersActor*>(this)->destroy(); return 0; }
															#line 1111 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorLogRoutersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorLogRoutersActor*>(this)->ActorCallback< MonitorLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Void>> failures;
															#line 340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> failedTagIds;
															#line 1204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorLogRouters()
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorLogRoutersActor final : public Actor<std::vector<int>>, public ActorCallback< MonitorLogRoutersActor, 0, Void >, public FastAllocated<MonitorLogRoutersActor>, public MonitorLogRoutersActorState<MonitorLogRoutersActor> {
															#line 1209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorLogRoutersActor>::operator new;
	using FastAllocated<MonitorLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12125983439249550336UL, 5614120010453316352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorLogRoutersActor, 0, Void >;
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorLogRoutersActor(Reference<ILogSystem> const& logSystem,int const& logSetIndex) 
															#line 1226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<int>>(),
		   MonitorLogRoutersActorState<MonitorLogRoutersActor>(logSystem, logSetIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981865692395027200UL, 16458587610827814912UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<int>> monitorLogRouters( Reference<ILogSystem> const& logSystem, int const& logSetIndex ) {
															#line 338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<int>>(new MonitorLogRoutersActor(logSystem, logSetIndex));
															#line 1259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// When in fully_recovered state, the cluster controller will monitor log routers
// and backup workers, and re-recruit any failed log routers or backup workers.
// This actor will be restarted in each recovery and will exit when a new recovery is detected.
															#line 1267 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorAndRecruitWorkerSet()
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorAndRecruitWorkerSetActor>
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitWorkerSetActorState {
															#line 1274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitWorkerSetActorState(ClusterControllerData* const& self,uint64_t const& recoveryCount,const char* const& workerName,std::function<Future<std::vector<int>>()> const& monitor,std::function<Future<Void>(std::vector<int>)> const& recruit) 
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   workerName(workerName),
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   monitor(monitor),
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruit(recruit)
															#line 1289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this));

	}
	~MonitorAndRecruitWorkerSetActorState() 
	{
		fdb_probe_actor_destroy("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent((std::string(workerName) + "MonitoringStart").c_str(), self->id).detail("RecoveryCount", recoveryCount);
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedRecruitDelay = 1.0;
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitment = Never();
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 387 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = newRecovery;
															#line 389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<int>> __when_expr_1 = monitor();
															#line 1349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = recruitment;
															#line 1353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 1;
															#line 390 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 401 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 1362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(failedRecruitDelay);
															#line 429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 2;
															#line 429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 1384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (strcmp(workerName, "LogRouter") == 0)
															#line 1394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "LogRouter re-recruitment failed");
															#line 1398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 419 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(strcmp(workerName, "BackupWorker") == 0);
															#line 420 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "BackupWorker re-recruitment failed");
															#line 1406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, (std::string(workerName) + "MonitoringRecruitmentFailed").c_str(), self->id) .error(e) .detail("RecoveryCount", recoveryCount);
															#line 425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedRecruitDelay = std::min(failedRecruitDelay * 2, 60.0);
															#line 426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitment = Never();
															#line 1414 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.recoveryData.isValid() && self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount)
															#line 1435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 1439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "MonitoringEnded").c_str(), self->id) .detail("Reason", "RecoveryChanged") .detail("RecoveryCount", recoveryCount);
															#line 399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorAndRecruitWorkerSetActorState(); static_cast<MonitorAndRecruitWorkerSetActor*>(this)->destroy(); return 0; }
															#line 1446 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 391 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.recoveryData.isValid() && self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount)
															#line 1458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 393 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 1462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "MonitoringEnded").c_str(), self->id) .detail("Reason", "RecoveryChanged") .detail("RecoveryCount", recoveryCount);
															#line 399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorAndRecruitWorkerSetActorState(); static_cast<MonitorAndRecruitWorkerSetActor*>(this)->destroy(); return 0; }
															#line 1469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<int> const& failedWorkers,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = recruit(failedWorkers);
															#line 403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "FailureDetected").c_str(), self->id) .detail("FailedCount", failedWorkers.size());
															#line 1483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<int> && failedWorkers,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = recruit(failedWorkers);
															#line 403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "FailureDetected").c_str(), self->id) .detail("FailedCount", failedWorkers.size());
															#line 1494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecruitDelay = 1.0;
															#line 408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "ReRecruitmentSuccess").c_str(), self->id) .detail("RecoveryCount", recoveryCount);
															#line 410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = Never();
															#line 1507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecruitDelay = 1.0;
															#line 408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "ReRecruitmentSuccess").c_str(), self->id) .detail("RecoveryCount", recoveryCount);
															#line 410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = Never();
															#line 1520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >::remove();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >::remove();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,std::vector<int> const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,std::vector<int> && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	uint64_t recoveryCount;
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	const char* workerName;
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::function<Future<std::vector<int>>()> monitor;
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::function<Future<Void>(std::vector<int>)> recruit;
															#line 384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double failedRecruitDelay;
															#line 385 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recruitment;
															#line 386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> newRecovery;
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorAndRecruitWorkerSet()
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitWorkerSetActor final : public Actor<Void>, public ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >, public FastAllocated<MonitorAndRecruitWorkerSetActor>, public MonitorAndRecruitWorkerSetActorState<MonitorAndRecruitWorkerSetActor> {
															#line 1825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorAndRecruitWorkerSetActor>::operator new;
	using FastAllocated<MonitorAndRecruitWorkerSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15163223733855291904UL, 13030536291674327040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >;
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitWorkerSetActor(ClusterControllerData* const& self,uint64_t const& recoveryCount,const char* const& workerName,std::function<Future<std::vector<int>>()> const& monitor,std::function<Future<Void>(std::vector<int>)> const& recruit) 
															#line 1845 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorAndRecruitWorkerSetActorState<MonitorAndRecruitWorkerSetActor>(self, recoveryCount, workerName, monitor, recruit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10141132090468743168UL, 3661297284784934400UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorAndRecruitWorkerSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorAndRecruitWorkerSet( ClusterControllerData* const& self, uint64_t const& recoveryCount, const char* const& workerName, std::function<Future<std::vector<int>>()> const& monitor, std::function<Future<Void>(std::vector<int>)> const& recruit ) {
															#line 377 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorAndRecruitWorkerSetActor(self, recoveryCount, workerName, monitor, recruit));
															#line 1879 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

Future<Void> monitorAndRecruitLogRouters(ClusterControllerData* self) {
	while (true) {
		// Wait until fully recovered
		while (self->db.serverInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED) {
			co_await self->db.serverInfo->onChange();
		}

		ASSERT(self->db.recoveryData.isValid());
		uint64_t recoveryCount = self->db.recoveryData->cstate.myDBState.recoveryCount;
		Reference<ILogSystem> logSystem = self->db.recoveryData->logSystem;
		LogSystemConfig config = logSystem->getLogSystemConfig();

		// Find the log set with log routers (should be remote/satellite)
		int logSetIndex = -1;
		for (int i = 0; i < config.tLogs.size(); i++) {
			if (config.tLogs[i].logRouters.size() > 0) {
				ASSERT_WE_THINK(logSetIndex == -1); // only one log set should have log routers
				logSetIndex = i;
			}
		}

		if (logSetIndex == -1) {
			TraceEvent("NoLogRoutersToMonitor", self->id).detail("RecoveryCount", recoveryCount).log();
			// Wait for recovery to change before trying again
			while (self->db.serverInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED &&
			       self->db.recoveryData.isValid() &&
			       self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount) {
				co_await self->db.serverInfo->onChange();
			}
			continue;
		}

		TraceEvent("LogRouterMonitoringDetails", self->id)
		    .detail("LogSetIndex", logSetIndex)
		    .detail("LogRouterCount", config.tLogs[logSetIndex].logRouters.size())
		    .detail("IsLocal", config.tLogs[logSetIndex].isLocal)
		    .detail("Locality", config.tLogs[logSetIndex].locality);

		std::function<Future<std::vector<int>>()> monitor = [logSystem, logSetIndex]() {
			return monitorLogRouters(logSystem, logSetIndex);
		};
		std::function<Future<Void>(std::vector<int>)> recruit =
		    [self, logSetIndex, logSystem](std::vector<int> failedWorkers) {
			    return recruitFailedLogRouters(
			        self, &self->db, failedWorkers, logSetIndex, logSystem, logSystem->getLogSystemConfig());
		    };

		co_await monitorAndRecruitWorkerSet(self, recoveryCount, "LogRouter", monitor, recruit);
	}
}

															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterWatchDatabase()
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterWatchDatabaseActor>
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActorState {
															#line 1942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   iMaster(),
															#line 488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   addActor(),
															#line 489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCore()
															#line 1959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterWatchDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterWatchDatabaseActorState();
		static_cast<ClusterWatchDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 495 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).log();
															#line 2004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		try {
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recoveryStart = now();
															#line 498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newMaster = MasterInterface();
															#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			collection = Future<Void>();
															#line 501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).detail("Recruiting", "Master");
															#line 502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = recruitNewMaster(cluster, db, std::addressof(newMaster));
															#line 502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 1;
															#line 502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 0, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			err = e;
															#line 598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).errorUnsuppressed(e).detail("Master", iMaster.id());
															#line 599 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2049 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(0.0);
															#line 600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 5;
															#line 600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 8, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 536 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 2132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 506 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 511 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 515 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 517 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 520 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 536 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 2193 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide)
															#line 2277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 2281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cleanupRecoveryActorCollection(db->recoveryData);
															#line 589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 3;
															#line 589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 6, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2294 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = recoveryCore;
															#line 553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitFailureClient( iMaster.waitFailure, db->masterRegistrationCount ? SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME : (now() - recoveryStart) * SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY, db->masterRegistrationCount ? -SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY : SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY), "CCWDBMasterFailed") || traceAfter(db->forceMasterFailure.onTrigger(), "CCWDBForceMasterFailureTriggered");
															#line 2316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = db->serverInfo->onChange();
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_4 = db->serverInfo->get().clusterInterface.notifyBackupWorkerDone.getFuture();
															#line 2324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<BackupWorkerDoneRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<BackupWorkerDoneRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = collection;
															#line 2329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 2;
															#line 554 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 1, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 2, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 568 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 3, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 5, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest const& req,int loopDepth) 
	{
															#line 571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 2406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 2410 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 2418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest && req,int loopDepth) 
	{
															#line 571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 2427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 2431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 2439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void && _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 1, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 2, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 3, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 590 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 592 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 2872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 594 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 2883 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 602 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_9 = cleanupRecoveryActorCollection(db->recoveryData);
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 6;
															#line 603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 9, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2989 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 3087 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 3091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 3095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 3099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 3117 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 3123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 3127 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 3131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3150 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 3161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 606 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 3165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 3169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 3173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 617 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 618 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 624 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 3191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 3197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 629 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 3201 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 3205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 632 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 633 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3213 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 487 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface iMaster;
															#line 488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recoveryCore;
															#line 497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double recoveryStart;
															#line 498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface newMaster;
															#line 499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> collection;
															#line 531 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> spinDelay;
															#line 597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Error err;
															#line 3413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterWatchDatabase()
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterWatchDatabaseActor, 0, Void >, public ActorCallback< ClusterWatchDatabaseActor, 1, Void >, public ActorCallback< ClusterWatchDatabaseActor, 2, Void >, public ActorCallback< ClusterWatchDatabaseActor, 3, Void >, public ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >, public ActorCallback< ClusterWatchDatabaseActor, 5, Void >, public ActorCallback< ClusterWatchDatabaseActor, 6, Void >, public ActorCallback< ClusterWatchDatabaseActor, 7, Void >, public ActorCallback< ClusterWatchDatabaseActor, 8, Void >, public ActorCallback< ClusterWatchDatabaseActor, 9, Void >, public ActorCallback< ClusterWatchDatabaseActor, 10, Void >, public FastAllocated<ClusterWatchDatabaseActor>, public ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor> {
															#line 3418 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterWatchDatabaseActor>::operator new;
	using FastAllocated<ClusterWatchDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16274116693803289600UL, 3201864833248287744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterWatchDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 1, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 2, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 3, Void >;
friend struct ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 5, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 6, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 7, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 8, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 9, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 10, Void >;
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 3445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor>(cluster, db, coordinators),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15084720662247522304UL, 7134482422509323520UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterWatchDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterWatchDatabase( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, ServerCoordinators const& coordinators ) {
															#line 484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterWatchDatabaseActor(cluster, db, coordinators));
															#line 3484 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 639 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterGetServerInfo()
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterGetServerInfoActor>
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActorState {
															#line 3496 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActorState(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   knownServerInfoID(knownServerInfoID),
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   reply(reply)
															#line 3507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetServerInfoActorState() 
	{
		fdb_probe_actor_destroy("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 3522 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		reply.send(db->serverInfo->get());
															#line 652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterGetServerInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterGetServerInfoActorState(); static_cast<ClusterGetServerInfoActor*>(this)->destroy(); return 0; }
															#line 3547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterGetServerInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 643 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->serverInfo->get().id == knownServerInfoID))
															#line 3566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(db->serverInfo->onChange());
															#line 644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3574 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(300);
															#line 3578 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 1;
															#line 645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 0, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 646 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 1, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 3585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 0, Void >::remove();
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID knownServerInfoID;
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReplyPromise<ServerDBInfo> reply;
															#line 3760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterGetServerInfo()
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActor final : public Actor<Void>, public ActorCallback< ClusterGetServerInfoActor, 0, Void >, public ActorCallback< ClusterGetServerInfoActor, 1, Void >, public FastAllocated<ClusterGetServerInfoActor>, public ClusterGetServerInfoActorState<ClusterGetServerInfoActor> {
															#line 3765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterGetServerInfoActor>::operator new;
	using FastAllocated<ClusterGetServerInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4652973620736997888UL, 9585099722964344832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterGetServerInfoActor, 0, Void >;
friend struct ActorCallback< ClusterGetServerInfoActor, 1, Void >;
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActor(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 3783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterGetServerInfoActorState<ClusterGetServerInfoActor>(db, knownServerInfoID, reply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8722247202050210304UL, 18223546808676413184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterGetServerInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterGetServerInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterGetServerInfo( ClusterControllerData::DBInfo* const& db, UID const& knownServerInfoID, ReplyPromise<ServerDBInfo> const& reply ) {
															#line 640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterGetServerInfoActor(db, knownServerInfoID, reply));
															#line 3816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterOpenDatabase()
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterOpenDatabaseActor>
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActorState {
															#line 3828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActorState(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 3837 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->clientStatus[req.reply.getEndpoint().getPrimaryAddress()] = std::make_pair(now(), req);
															#line 657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (db->clientStatus.size() > 10000)
															#line 3854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyClientStatusEntries").suppressFor(1.0);
															#line 3858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 3862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(db->clientInfo->get());
															#line 671 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterOpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterOpenDatabaseActorState(); static_cast<ClusterOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 3887 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterOpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 661 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->clientInfo->get().id == req.knownClientInfoID))
															#line 3906 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->clientInfo->onChange();
															#line 662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3914 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL);
															#line 3918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 0, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 1, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 3925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 0, Void >::remove();
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	OpenDatabaseRequest req;
															#line 4098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterOpenDatabase()
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterOpenDatabaseActor, 0, Void >, public ActorCallback< ClusterOpenDatabaseActor, 1, Void >, public FastAllocated<ClusterOpenDatabaseActor>, public ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor> {
															#line 4103 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterOpenDatabaseActor>::operator new;
	using FastAllocated<ClusterOpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8796146706348587776UL, 3502306501824703232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterOpenDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterOpenDatabaseActor, 1, Void >;
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActor(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 4121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4479359797486159872UL, 7876825679301567232UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterOpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterOpenDatabase( ClusterControllerData::DBInfo* const& db, OpenDatabaseRequest const& req ) {
															#line 655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterOpenDatabaseActor(db, req));
															#line 4154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRecruitmentRequests.size(); i++) {
		Reference<RecruitWorkersInfo> info = self->outstandingRecruitmentRequests[i];
		try {
			info->rep = self->findWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingRemoteRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRemoteRecruitmentRequests.size(); i++) {
		Reference<RecruitRemoteWorkersInfo> info = self->outstandingRemoteRecruitmentRequests[i];
		try {
			info->rep = self->findRemoteWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRemoteRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRemoteRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitRemoteTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitRemoteTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingStorageRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingStorageRequests.size(); i++) {
		auto& req = self->outstandingStorageRequests[i];
		try {
			if (req.second < now()) {
				req.first.reply.sendError(timed_out());
				swapAndPop(&self->outstandingStorageRequests, i--);
			} else {
				if (!self->gotProcessClasses && !req.first.criticalRecruitment)
					throw no_more_servers();

				auto worker = self->getStorageWorker(req.first);
				RecruitStorageReply rep;
				rep.worker = worker.interf;
				rep.processClass = worker.processClass;
				req.first.reply.send(rep);
				swapAndPop(&self->outstandingStorageRequests, i--);
			}
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers) {
				TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
				    .errorUnsuppressed(e)
				    .suppressFor(1.0)
				    .detail("OutstandingReq", i)
				    .detail("IsCriticalRecruitment", req.first.criticalRecruitment);
			} else {
				TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
				throw;
			}
		}
	}
}

// Finds and returns a new process for role
WorkerDetails findNewProcessForSingleton(ClusterControllerData* self,
                                         const ProcessClass::ClusterRole role,
                                         std::map<Optional<Standalone<StringRef>>, int>& id_used) {
	// find new process in cluster for role
	WorkerDetails newWorker =
	    self->getWorkerForRoleInDatacenter(
	            self->clusterControllerDcId, role, ProcessClass::NeverAssign, self->db.config, id_used, {}, true)
	        .worker;

	// check if master's process is actually better suited for role
	if (self->onMasterIsBetter(newWorker, role)) {
		newWorker = self->id_worker[self->masterProcessId.get()].details;
	}

	// acknowledge that the pid is now potentially used by this role as well
	id_used[newWorker.interf.locality.processId()]++;

	return newWorker;
}

// Return best possible fitness for singleton. Note that lower fitness is better.
ProcessClass::Fitness findBestFitnessForSingleton(const ClusterControllerData* self,
                                                  const WorkerDetails& worker,
                                                  const ProcessClass::ClusterRole& role) {
	auto bestFitness = worker.processClass.machineClassFitness(role);
	// If the process has been marked as excluded, we take the max with ExcludeFit to ensure its fit
	// is at least as bad as ExcludeFit. This assists with successfully offboarding such processes
	// and removing them from the cluster.
	if (self->db.config.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
		bestFitness = std::max(bestFitness, ProcessClass::ExcludeFit);
	}
	return bestFitness;
}

// Returns true iff the singleton is healthy. "Healthy" here means that
// the singleton is stable (see below) and doesn't need to be rerecruited.
// Side effects: (possibly) initiates recruitment
template <class SingletonClass>
bool isHealthySingleton(ClusterControllerData* self,
                        const WorkerDetails& newWorker,
                        const SingletonClass& singleton,
                        const ProcessClass::Fitness& bestFitness,
                        const Optional<UID> recruitingID) {
	// A singleton is stable if it exists in cluster, has not been killed off of proc and is not being recruited
	bool isStableSingleton = singleton.isPresent() &&
	                         self->id_worker.contains(singleton.getInterface().locality.processId()) &&
	                         (!recruitingID.present() || (recruitingID.get() == singleton.getInterface().id()));

	if (!isStableSingleton) {
		return false; // not healthy because unstable
	}

	auto& currWorker = self->id_worker[singleton.getInterface().locality.processId()];
	auto currFitness = currWorker.details.processClass.machineClassFitness(singleton.getClusterRole());
	if (currWorker.priorityInfo.isExcluded) {
		currFitness = ProcessClass::ExcludeFit;
	}
	// If any of the following conditions are met, we will switch the singleton's process:
	// - if the current proc is used by some non-master, non-singleton role
	// - if the current fitness is less than optimal (lower fitness is better)
	// - if currently at peak fitness but on same process as master, and the new worker is on different process
	bool shouldRerecruit =
	    self->isUsedNotMaster(currWorker.details.interf.locality.processId()) || bestFitness < currFitness ||
	    (currFitness == bestFitness && currWorker.details.interf.locality.processId() == self->masterProcessId &&
	     newWorker.interf.locality.processId() != self->masterProcessId);
	if (g_network->isSimulated() && singleton.getRole() == Role::DATA_DISTRIBUTOR &&
	    SERVER_KNOBS->CC_ENFORCE_USE_UNFIT_DD_IN_SIM) {
		// It is possible that DD location is not optimal in the simulation.
		// This can cause the simulation stuck if it always halts DD.
		// TODO(BulkLoad): this is a work around. We should figure out why DD can be repeatedly
		// terminated by CC throughout the simulation.
		shouldRerecruit = false;
	}
	if (shouldRerecruit) {
		std::string roleAbbr = singleton.getRole().abbreviation;
		TraceEvent(("CCHalt" + roleAbbr).c_str(), self->id)
		    .detail(roleAbbr + "ID", singleton.getInterface().id())
		    .detail("Excluded", currWorker.priorityInfo.isExcluded)
		    .detail("Fitness", currFitness)
		    .detail("BestFitness", bestFitness)
		    .detail("MasterProcessId", self->masterProcessId)
		    .detail("CurrentWorkerProcessId", currWorker.details.interf.locality.processId())
		    .detail("NewWorkerProcessId", newWorker.interf.locality.processId())
		    .detail("IsUsedNotMaster", self->isUsedNotMaster(currWorker.details.interf.locality.processId()));
		singleton.recruit(*self); // SIDE EFFECT: initiating recruitment
		return false; // not healthy since needed to be rerecruited
	} else {
		return true; // healthy because doesn't need to be rerecruited
	}
}

// Returns a mapping from pid->pidCount for pids
std::map<Optional<Standalone<StringRef>>, int> getColocCounts(
    const std::vector<Optional<Standalone<StringRef>>>& pids) {
	std::map<Optional<Standalone<StringRef>>, int> counts;
	for (const auto& pid : pids) {
		if (pid.present()) {
			++counts[pid];
		}
	}
	return counts;
}

// Checks if there exists a better process for each singleton (e.g. DD) compared
// to the process it is currently on.
// When adding new singletons, just follow the ratekeeper/data distributor examples.
void checkBetterSingletons(ClusterControllerData* self) {
	if (!self->masterProcessId.present() ||
	    self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS) {
		return;
	}

	// note: this map doesn't consider pids used by existing singletons
	std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();

	// We prefer spreading out other roles more than separating singletons on their own process
	// so we artificially amplify the pid count for the processes used by non-singleton roles.
	// In other words, we make the processes used for other roles less desirable to be used
	// by singletons as well.
	for (auto& it : id_used) {
		it.second *= PID_USED_AMP_FOR_NON_SINGLETON;
	}

	// Try to find a new process for each singleton.
	WorkerDetails newRKWorker = findNewProcessForSingleton(self, ProcessClass::Ratekeeper, id_used);
	WorkerDetails newDDWorker = findNewProcessForSingleton(self, ProcessClass::DataDistributor, id_used);
	WorkerDetails newCSWorker = findNewProcessForSingleton(self, ProcessClass::ConsistencyScan, id_used);

	// Find best possible fitnesses for each singleton.
	auto bestFitnessForRK = findBestFitnessForSingleton(self, newRKWorker, ProcessClass::Ratekeeper);
	auto bestFitnessForDD = findBestFitnessForSingleton(self, newDDWorker, ProcessClass::DataDistributor);
	auto bestFitnessForCS = findBestFitnessForSingleton(self, newCSWorker, ProcessClass::ConsistencyScan);

	auto& db = self->db.serverInfo->get();
	auto rkSingleton = RatekeeperSingleton(db.ratekeeper);
	auto ddSingleton = DataDistributorSingleton(db.distributor);
	ConsistencyScanSingleton csSingleton(db.consistencyScan);

	// Check if the singletons are healthy.
	// side effect: try to rerecruit the singletons to more optimal processes
	bool rkHealthy = isHealthySingleton<RatekeeperSingleton>(
	    self, newRKWorker, rkSingleton, bestFitnessForRK, self->recruitingRatekeeperID);

	bool ddHealthy = isHealthySingleton<DataDistributorSingleton>(
	    self, newDDWorker, ddSingleton, bestFitnessForDD, self->recruitingDistributorID);

	bool csHealthy = isHealthySingleton<ConsistencyScanSingleton>(
	    self, newCSWorker, csSingleton, bestFitnessForCS, self->recruitingConsistencyScanID);

	// if any of the singletons are unhealthy (rerecruited or not stable), then do not
	// consider any further re-recruitments
	if (!(rkHealthy && ddHealthy && csHealthy)) {
		return;
	}

	// if we reach here, we know that the singletons are healthy so let's
	// check if we can colocate the singletons in a more optimal way
	Optional<Standalone<StringRef>> currRKProcessId = rkSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currDDProcessId = ddSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currCSProcessId = csSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> newRKProcessId = newRKWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newDDProcessId = newDDWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newCSProcessId = newCSWorker.interf.locality.processId();

	std::vector<Optional<Standalone<StringRef>>> currPids = { currRKProcessId, currDDProcessId, currCSProcessId };
	std::vector<Optional<Standalone<StringRef>>> newPids = { newRKProcessId, newDDProcessId, newCSProcessId };

	auto currColocMap = getColocCounts(currPids);
	auto newColocMap = getColocCounts(newPids);

	// if the new coloc counts are collectively better (i.e. each singleton's coloc count has not increased)
	if (newColocMap[newRKProcessId] <= currColocMap[currRKProcessId] &&
	    newColocMap[newDDProcessId] <= currColocMap[currDDProcessId] &&
	    newColocMap[newCSProcessId] <= currColocMap[currCSProcessId]) {
		// rerecruit the singleton for which we have found a better process, if any
		if (newColocMap[newRKProcessId] < currColocMap[currRKProcessId]) {
			rkSingleton.recruit(*self);
		} else if (newColocMap[newDDProcessId] < currColocMap[currDDProcessId]) {
			ddSingleton.recruit(*self);
		} else if (newColocMap[newCSProcessId] < currColocMap[currCSProcessId]) {
			csSingleton.recruit(*self);
		}
	}
}

															#line 4422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRequestsActor>
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActorState {
															#line 4429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActorState(ClusterControllerData* const& self) 
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 4436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4454 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 1;
															#line 939 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4459 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRequestsActorState(); static_cast<DoCheckOutstandingRequestsActor*>(this)->destroy(); return 0; }
															#line 4488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 4501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 4505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRecruitmentRequests(self);
															#line 951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingStorageRequests(self);
															#line 953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkBetterSingletons(self);
															#line 955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->checkRecoveryStalled();
															#line 956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->betterMasterExists())
															#line 4622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.forceMasterFailure.trigger();
															#line 958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("MasterRegistrationKill", self->id).detail("MasterId", self->db.serverInfo->get().master.id());
															#line 4628 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY || !self->goodRecruitmentTime.isReady()))
															#line 4645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 942 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY)
															#line 4651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY + 0.001 - (now() - self->lastRecruitTime));
															#line 943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 2;
															#line 943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->goodRecruitmentTime.isReady())
															#line 4689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->goodRecruitmentTime;
															#line 946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 3;
															#line 946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 4700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 4905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >, public FastAllocated<DoCheckOutstandingRequestsActor>, public DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor> {
															#line 4910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6521856582870005248UL, 5933210926869420032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >;
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActor(ClusterControllerData* const& self) 
															#line 4929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18376869144156441344UL, 10196932547024268032UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRequests( ClusterControllerData* const& self ) {
															#line 937 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRequestsActor(self));
															#line 4964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 4969 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRemoteRequestsActor>
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActorState {
															#line 4976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActorState(ClusterControllerData* const& self) 
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 4983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRemoteRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 1;
															#line 970 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 5006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 981 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRemoteRequestsActorState(); static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->destroy(); return 0; }
															#line 5035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 5048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 5052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRemoteRecruitmentRequests(self);
															#line 5161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 5177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->goodRemoteRecruitmentTime;
															#line 972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 2;
															#line 972 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 5190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 5310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >, public FastAllocated<DoCheckOutstandingRemoteRequestsActor>, public DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor> {
															#line 5315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3198405596225274880UL, 15694711360562680320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >;
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActor(ClusterControllerData* const& self) 
															#line 5333 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11202796549843407360UL, 6198894268515362560UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRemoteRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRemoteRequests( ClusterControllerData* const& self ) {
															#line 968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRemoteRequestsActor(self));
															#line 5367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRequests(ClusterControllerData* self) {
	if (self->outstandingRemoteRequestChecker.isReady()) {
		self->outstandingRemoteRequestChecker = doCheckOutstandingRemoteRequests(self);
	}

	if (self->outstandingRequestChecker.isReady()) {
		self->outstandingRequestChecker = doCheckOutstandingRequests(self);
	}
}

															#line 5382 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rebootAndCheck()
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RebootAndCheckActor>
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActorState {
															#line 5389 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActorState(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   processID(processID)
															#line 5398 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~RebootAndCheckActorState() 
	{
		fdb_probe_actor_destroy("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(processID.present());
															#line 997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto watcher = cluster->id_worker.find(processID);
															#line 998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(watcher != cluster->id_worker.end());
															#line 1000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots++;
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(g_network->isSimulated() ? SERVER_KNOBS->SIM_SHUTDOWN_TIMEOUT : SERVER_KNOBS->SHUTDOWN_TIMEOUT);
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 1;
															#line 1001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RebootAndCheckActor, 0, Void >*>(static_cast<RebootAndCheckActor*>(this)));
															#line 5429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto watcher = cluster->id_worker.find(processID);
															#line 1006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (watcher != cluster->id_worker.end())
															#line 5456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots--;
															#line 1008 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (watcher->second.reboots < 2)
															#line 5462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					checkOutstandingRequests(cluster);
															#line 5466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RebootAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RebootAndCheckActorState(); static_cast<RebootAndCheckActor*>(this)->destroy(); return 0; }
															#line 5472 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RebootAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state > 0) static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RebootAndCheckActor*>(this)->ActorCallback< RebootAndCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RebootAndCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Standalone<StringRef>> processID;
															#line 5571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rebootAndCheck()
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActor final : public Actor<Void>, public ActorCallback< RebootAndCheckActor, 0, Void >, public FastAllocated<RebootAndCheckActor>, public RebootAndCheckActorState<RebootAndCheckActor> {
															#line 5576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RebootAndCheckActor>::operator new;
	using FastAllocated<RebootAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6646281383993095168UL, 6821918256844940544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RebootAndCheckActor, 0, Void >;
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActor(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 5593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RebootAndCheckActorState<RebootAndCheckActor>(cluster, processID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17703883454640654592UL, 13640791943228081920UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rebootAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RebootAndCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> rebootAndCheck( ClusterControllerData* const& cluster, Optional<Standalone<StringRef>> const& processID ) {
															#line 994 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RebootAndCheckActor(cluster, processID));
															#line 5626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 5631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class WorkerAvailabilityWatchActor>
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActorState {
															#line 5638 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActorState(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : worker(worker),
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   startingClass(startingClass),
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cluster(cluster),
															#line 1019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failed((worker.address() == g_network->getLocalAddress()) ? Never() : waitFailureClient(worker.waitFailure, SERVER_KNOBS->WORKER_FAILURE_TIME))
															#line 5651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	~WorkerAvailabilityWatchActorState() 
	{
		fdb_probe_actor_destroy("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateWorkerList.set( worker.locality.processId(), ProcessData(worker.locality, startingClass, worker.stableAddress(), worker.grpcAddress()));
															#line 1027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 1027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 1;
															#line 1027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 5675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = IFailureMonitor::failureMonitor().onStateEqual( worker.storage.getEndpoint(), FailureStatus( IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable()));
															#line 1030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failed;
															#line 5804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 2;
															#line 1031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 1040 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 5811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 5826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 5832 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1035 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 5842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 5848 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 5860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 5864 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 5868 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 5872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 5888 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 5892 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 5899 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1043 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 5913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 5917 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1047 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 5921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 5925 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1050 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1054 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 5941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 5945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1064 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 5952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 1, Void >::remove();
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerInterface worker;
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ProcessClass startingClass;
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 1019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> failed;
															#line 6089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActor final : public Actor<Void>, public ActorCallback< WorkerAvailabilityWatchActor, 0, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 1, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 2, Void >, public FastAllocated<WorkerAvailabilityWatchActor>, public WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor> {
															#line 6094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerAvailabilityWatchActor>::operator new;
	using FastAllocated<WorkerAvailabilityWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5529666782413434880UL, 3081563509168165376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerAvailabilityWatchActor, 0, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 1, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 2, Void >;
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActor(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 6113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor>(worker, startingClass, cluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10692884594389689856UL, 3271400941493304320UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerAvailabilityWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> workerAvailabilityWatch( WorkerInterface const& worker, ProcessClass const& startingClass, ClusterControllerData* const& cluster ) {
															#line 1016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new WorkerAvailabilityWatchActor(worker, startingClass, cluster));
															#line 6147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

struct FailureStatusInfo {
	FailureStatus status;
	double lastRequestTime;
	double penultimateRequestTime;

	FailureStatusInfo() : lastRequestTime(0), penultimateRequestTime(0) {}

	void insertRequest(double now) {
		penultimateRequestTime = lastRequestTime;
		lastRequestTime = now;
	}

	double latency(double now) const {
		return std::max(now - lastRequestTime, lastRequestTime - penultimateRequestTime);
	}
};

															#line 6169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via requireAll()
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RequireAllActor>
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActorState {
															#line 6176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActorState(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : in(in),
															#line 1089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   out(),
															#line 1090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   i()
															#line 6187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("requireAll", reinterpret_cast<unsigned long>(this));

	}
	~RequireAllActorState() 
	{
		fdb_probe_actor_destroy("requireAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			i = 0;
															#line 6202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RequireAllActor*>(this)->SAV<std::vector<TLogInterface>>::futures) { (void)(out); this->~RequireAllActorState(); static_cast<RequireAllActor*>(this)->destroy(); return 0; }
															#line 6225 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RequireAllActor*>(this)->SAV< std::vector<TLogInterface> >::value()) std::vector<TLogInterface>(std::move(out)); // state_var_RVO
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(i < in.size()))
															#line 6244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Optional<std::vector<TLogInterface>>> __when_expr_0 = in[i];
															#line 1092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RequireAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6252 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequireAllActor*>(this)->actor_wait_state = 1;
															#line 1092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*>(static_cast<RequireAllActor*>(this)));
															#line 6257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 6279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 6283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 6289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 6298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 6302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1095 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 6308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireAllActor*>(this)->actor_wait_state > 0) static_cast<RequireAllActor*>(this)->actor_wait_state = 0;
		static_cast<RequireAllActor*>(this)->ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> const& value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> && value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Optional<std::vector<TLogInterface>>>> in;
															#line 1089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<TLogInterface> out;
															#line 1090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int i;
															#line 6394 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via requireAll()
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActor final : public Actor<std::vector<TLogInterface>>, public ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >, public FastAllocated<RequireAllActor>, public RequireAllActorState<RequireAllActor> {
															#line 6399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RequireAllActor>::operator new;
	using FastAllocated<RequireAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14422500979599337216UL, 12799427773406814208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TLogInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >;
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActor(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 6416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<TLogInterface>>(),
		   RequireAllActorState<RequireAllActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16593527381228025088UL, 9468838150300793600UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requireAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<TLogInterface>> requireAll( std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in ) {
															#line 1088 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<TLogInterface>>(new RequireAllActor(in));
															#line 6449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1099 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void clusterRecruitStorage(ClusterControllerData* self, RecruitStorageRequest req) {
	try {
		if (!self->gotProcessClasses && !req.criticalRecruitment)
			throw no_more_servers();
		auto worker = self->getStorageWorker(req);
		RecruitStorageReply rep;
		rep.worker = worker.interf;
		rep.processClass = worker.processClass;
		req.reply.send(rep);
	} catch (Error& e) {
		if (e.code() == error_code_no_more_servers) {
			self->outstandingStorageRequests.emplace_back(req, now() + SERVER_KNOBS->RECRUITMENT_TIMEOUT);
			TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
			    .error(e)
			    .detail("IsCriticalRecruitment", req.criticalRecruitment);
		} else {
			TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
			throw; // Any other error will bring down the cluster controller
		}
	}
}

void clusterRegisterMaster(ClusterControllerData* self, RegisterMasterRequest const& req) {
	++self->registerMasterRequests;

	TraceEvent("MasterRegistrationReceived", self->id)
	    .detail("MasterId", req.id)
	    .detail("Master", req.mi.toString())
	    .detail("Tlogs", describe(req.logSystemConfig.tLogs))
	    .detail("Resolvers", req.resolvers.size())
	    .detail("RecoveryState", (int)req.recoveryState)
	    .detail("RegistrationCount", req.registrationCount)
	    .detail("CommitProxies", req.commitProxies.size())
	    .detail("GrvProxies", req.grvProxies.size())
	    .detail("RecoveryCount", req.recoveryCount)
	    .detail("Stalled", req.recoveryStalled)
	    .detail("OldestBackupEpoch", req.logSystemConfig.oldestBackupEpoch);

	// make sure the request comes from an active database
	auto db = &self->db;
	if (db->serverInfo->get().master.id() != req.id || req.registrationCount <= db->masterRegistrationCount) {
		TraceEvent("MasterRegistrationNotFound", self->id)
		    .detail("MasterId", req.id)
		    .detail("ExistingId", db->serverInfo->get().master.id())
		    .detail("RegCount", req.registrationCount)
		    .detail("ExistingRegCount", db->masterRegistrationCount);
		return;
	}

	if (req.recoveryState == RecoveryState::FULLY_RECOVERED) {
		self->db.unfinishedRecoveries = 0;
		ASSERT(!req.logSystemConfig.oldTLogs.size());
	}

	db->masterRegistrationCount = req.registrationCount;
	db->recoveryStalled = req.recoveryStalled;
	if (req.configuration.present()) {
		db->config = req.configuration.get();

		if (req.recoveryState >= RecoveryState::ACCEPTING_COMMITS) {
			self->gotFullyRecoveredConfig = true;
			db->fullyRecoveredConfig = req.configuration.get();
			for (auto& it : self->id_worker) {
				bool isExcludedFromConfig = db->fullyRecoveredConfig.isExcludedServer(
				    it.second.details.interf.addresses(), it.second.details.interf.locality);
				if (it.second.priorityInfo.isExcluded != isExcludedFromConfig) {
					it.second.priorityInfo.isExcluded = isExcludedFromConfig;
					if (!it.second.reply.isSet()) {
						it.second.reply.send(
						    RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
					}
				}
			}
		}
	}

	bool isChanged = false;
	auto dbInfo = self->db.serverInfo->get();

	if (dbInfo.recoveryState != req.recoveryState) {
		dbInfo.recoveryState = req.recoveryState;
		isChanged = true;
	}

	if (dbInfo.priorCommittedLogServers != req.priorCommittedLogServers) {
		dbInfo.priorCommittedLogServers = req.priorCommittedLogServers;
		isChanged = true;
	}

	// Construct the client information
	if (db->clientInfo->get().commitProxies != req.commitProxies ||
	    db->clientInfo->get().grvProxies != req.grvProxies ||
	    db->clientInfo->get().clusterId != db->serverInfo->get().client.clusterId ||
	    db->clientInfo->get().clusterType != db->clusterType) {
		TraceEvent("PublishNewClientInfo", self->id)
		    .detail("Master", dbInfo.master.id())
		    .detail("GrvProxies", db->clientInfo->get().grvProxies)
		    .detail("ReqGrvProxies", req.grvProxies)
		    .detail("CommitProxies", db->clientInfo->get().commitProxies)
		    .detail("GlobalConfigHistorySize", db->clientInfo->get().history.size())
		    .detail("ReqCPs", req.commitProxies)
		    .detail("ClusterId", db->serverInfo->get().client.clusterId)
		    .detail("ClientClusterId", db->clientInfo->get().clusterId)
		    .detail("ClusterType", db->clientInfo->get().clusterType)
		    .detail("ReqClusterType", db->clusterType);
		isChanged = true;
		// TODO why construct a new one and not just copy the old one and change proxies + id?
		ClientDBInfo clientInfo;
		clientInfo.id = deterministicRandom()->randomUniqueID();
		clientInfo.commitProxies = req.commitProxies;
		clientInfo.grvProxies = req.grvProxies;
		clientInfo.history = db->clientInfo->get().history;
		clientInfo.clusterId = db->serverInfo->get().client.clusterId;
		clientInfo.clusterType = db->clusterType;
		db->clientInfo->set(clientInfo);
		dbInfo.client = db->clientInfo->get();
	}

	if (!dbInfo.logSystemConfig.isEqual(req.logSystemConfig)) {
		isChanged = true;
		dbInfo.logSystemConfig = req.logSystemConfig;
	}

	if (dbInfo.resolvers != req.resolvers) {
		isChanged = true;
		dbInfo.resolvers = req.resolvers;
	}

	if (dbInfo.recoveryCount != req.recoveryCount) {
		isChanged = true;
		dbInfo.recoveryCount = req.recoveryCount;
	}

	if (isChanged) {
		dbInfo.id = deterministicRandom()->randomUniqueID();
		dbInfo.infoGeneration = ++self->db.dbInfoCount;
		self->db.serverInfo->set(dbInfo);
	}

	checkOutstandingRequests(self);
}

// Halts the registering (i.e. requesting) singleton if one is already in the process of being recruited
// or, halts the existing singleton in favour of the requesting one
template <class SingletonClass>
void haltRegisteringOrCurrentSingleton(ClusterControllerData* self,
                                       const WorkerInterface& worker,
                                       const SingletonClass& currSingleton,
                                       const SingletonClass& registeringSingleton,
                                       const Optional<UID> recruitingID) {
	ASSERT(currSingleton.getRole() == registeringSingleton.getRole());
	const UID registeringID = registeringSingleton.getInterface().id();
	const std::string roleName = currSingleton.getRole().roleName;
	const std::string roleAbbr = currSingleton.getRole().abbreviation;

	// halt the requesting singleton if it isn't the one currently being recruited
	if ((recruitingID.present() && recruitingID.get() != registeringID) ||
	    self->clusterControllerDcId != worker.locality.dcId()) {
		TraceEvent(("CCHaltRegistering" + roleName).c_str(), self->id)
		    .detail(roleAbbr + "ID", registeringID)
		    .detail("DcID", printable(self->clusterControllerDcId))
		    .detail("ReqDcID", printable(worker.locality.dcId()))
		    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
		registeringSingleton.halt(*self, worker.locality.processId());
	} else if (!recruitingID.present()) {
		// if not currently recruiting, then halt previous one in favour of requesting one
		TraceEvent(("CCRegister" + roleName).c_str(), self->id).detail(roleAbbr + "ID", registeringID);
		if (currSingleton.isPresent() && currSingleton.getInterface().id() != registeringID &&
		    self->id_worker.contains(currSingleton.getInterface().locality.processId())) {
			TraceEvent(("CCHaltPrevious" + roleName).c_str(), self->id)
			    .detail(roleAbbr + "ID", currSingleton.getInterface().id())
			    .detail("DcID", printable(self->clusterControllerDcId))
			    .detail("ReqDcID", printable(worker.locality.dcId()))
			    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
			currSingleton.halt(*self, currSingleton.getInterface().locality.processId());
		}
		// set the curr singleton if it doesn't exist or its different from the requesting one
		if (!currSingleton.isPresent() || currSingleton.getInterface().id() != registeringID) {
			registeringSingleton.setInterfaceToDbInfo(*self);
		}
	}
}

															#line 6637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerWorker()
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RegisterWorkerActor>
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActorState {
															#line 6644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActorState(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : req(req),
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cs(cs),
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster)
															#line 6657 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerActorState() 
	{
		fdb_probe_actor_destroy("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 1;
															#line 1287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*>(static_cast<RegisterWorkerActor*>(this)));
															#line 6679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 6704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 6712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 6732 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 6738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 6746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 6752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 6756 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 6760 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 6764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 6768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 6775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 6779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 6787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 6791 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 6795 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 6802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 6806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 6812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 6816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 6822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 6826 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 6832 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 6836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 6840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 6844 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 6849 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 6855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 6861 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 6865 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 6873 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 6877 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 6882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 6886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 6890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 6894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 6902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 6908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 6912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 6916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 6936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 6946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 6950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 6956 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 6960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 6964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 6968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 6974 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 6979 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 6987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 6991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 6999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 7003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 7011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 7015 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 7019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7023 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 7037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1302 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1306 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1314 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 7065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1319 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1328 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 7079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 7085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1341 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 7089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 7093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 7120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1354 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7128 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1358 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1364 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7145 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 7149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1369 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 7155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 7159 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1373 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 7165 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1375 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 7169 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 7173 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1379 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 7177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1384 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1396 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 7188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1399 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 7194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1400 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 7198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1405 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1406 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 7206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1408 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 7210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1411 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 7215 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1413 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 7219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1415 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1416 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 7227 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1423 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1424 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 7235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1425 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7241 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1426 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 7245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1427 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 7249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1429 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1430 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1431 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1432 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1434 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1435 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 7269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1440 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1444 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 7279 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 7283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1448 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1449 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 7289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1451 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7293 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 7297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1458 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 7301 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1460 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 7307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1466 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 7312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1467 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 7320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1473 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 7324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1475 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1476 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 7332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 7336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1482 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1483 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 7344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1488 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 7348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1489 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 7352 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1492 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(coordinatorAddresses, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(coordinatorAddresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerActor*>(this)->ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerRequest req;
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterConnectionString cs;
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster* configBroadcaster;
															#line 7447 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerWorker()
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActor final : public Actor<Void>, public ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >, public FastAllocated<RegisterWorkerActor>, public RegisterWorkerActorState<RegisterWorkerActor> {
															#line 7452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterWorkerActor>::operator new;
	using FastAllocated<RegisterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10988010133300146432UL, 8359489818695635200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >;
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActor(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 7469 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterWorkerActorState<RegisterWorkerActor>(req, self, cs, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14446594949420451840UL, 3262990831982615808UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> registerWorker( RegisterWorkerRequest const& req, ClusterControllerData* const& self, ClusterConnectionString const& cs, ConfigBroadcaster* const& configBroadcaster ) {
															#line 1283 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RegisterWorkerActor(req, self, cs, configBroadcaster));
															#line 7502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1494 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

#define TIME_KEEPER_VERSION "1"_sr

															#line 7509 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperSetVersionActor>
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActorState {
															#line 7516 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActorState(ClusterControllerData* const& self) 
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx))
															#line 7525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperSetVersionActorState() 
	{
		fdb_probe_actor_destroy("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 7540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1512 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TimeKeeperSetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TimeKeeperSetVersionActorState(); static_cast<TimeKeeperSetVersionActor*>(this)->destroy(); return 0; }
															#line 7563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TimeKeeperSetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1501 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1502 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1504 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->set(timeKeeperVersionKey, TIME_KEEPER_VERSION);
															#line 1505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 1;
															#line 1505 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 0, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 7598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7635 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 2;
															#line 1508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 1, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 7640 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 7829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActor final : public Actor<Void>, public ActorCallback< TimeKeeperSetVersionActor, 0, Void >, public ActorCallback< TimeKeeperSetVersionActor, 1, Void >, public FastAllocated<TimeKeeperSetVersionActor>, public TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor> {
															#line 7834 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperSetVersionActor>::operator new;
	using FastAllocated<TimeKeeperSetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12666696803171656192UL, 4947412044234433024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperSetVersionActor, 0, Void >;
friend struct ActorCallback< TimeKeeperSetVersionActor, 1, Void >;
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActor(ClusterControllerData* const& self) 
															#line 7852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15389618584066260224UL, 624794717111917056UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeperSetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeperSetVersion( ClusterControllerData* const& self ) {
															#line 1497 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperSetVersionActor(self));
															#line 7886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1514 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// This actor periodically gets read version and writes it to cluster with current timestamp as key. To avoid
// running out of space, it limits the max number of entries and clears old entries on each update. This mapping is
// used from backup and restore to get the version information for a timestamp.
															#line 7894 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeper()
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperActor>
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActorState {
															#line 7901 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActorState(ClusterControllerData* const& self) 
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   versionMap(timeKeeperPrefixRange.begin)
															#line 7910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperActorState() 
	{
		fdb_probe_actor_destroy("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperStarted").log();
															#line 1523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeKeeperSetVersion(self);
															#line 1523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 1;
															#line 1523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 0, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 7934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperActorState();
		static_cast<TimeKeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 7957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 7966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(self->cx);
															#line 1527 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 1563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 5;
															#line 1563 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 4, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8075 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 1530 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!g_network->isSimulated())
															#line 8094 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				tr->debugTransaction(debugID);
															#line 8098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1536 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1537 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1538 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(timeKeeperDisableKey);
															#line 1540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 2;
															#line 1540 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 1, Optional<Value> >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8152 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 4;
															#line 1559 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 3, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> const& disableValue,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 8172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 8184 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 8188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 8194 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 8198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> && disableValue,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 8218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1546 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1547 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 8230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 8234 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1551 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1552 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 8240 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1553 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 8244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8250 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1556 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8255 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> const& disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(disableValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> && disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(disableValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedMap<int64_t, Version> versionMap;
															#line 1526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID debugID;
															#line 8604 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeper()
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActor final : public Actor<Void>, public ActorCallback< TimeKeeperActor, 0, Void >, public ActorCallback< TimeKeeperActor, 1, Optional<Value> >, public ActorCallback< TimeKeeperActor, 2, Void >, public ActorCallback< TimeKeeperActor, 3, Void >, public ActorCallback< TimeKeeperActor, 4, Void >, public FastAllocated<TimeKeeperActor>, public TimeKeeperActorState<TimeKeeperActor> {
															#line 8609 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperActor>::operator new;
	using FastAllocated<TimeKeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12214654965203861504UL, 13081142295728498432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperActor, 0, Void >;
friend struct ActorCallback< TimeKeeperActor, 1, Optional<Value> >;
friend struct ActorCallback< TimeKeeperActor, 2, Void >;
friend struct ActorCallback< TimeKeeperActor, 3, Void >;
friend struct ActorCallback< TimeKeeperActor, 4, Void >;
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActor(ClusterControllerData* const& self) 
															#line 8630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperActorState<TimeKeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10218480498489324032UL, 15738055826982653184UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TimeKeeperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TimeKeeperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TimeKeeperActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeper( ClusterControllerData* const& self ) {
															#line 1518 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperActor(self));
															#line 8667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1566 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 8672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via statusServer()
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StatusServerActor>
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActorState {
															#line 8679 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActorState(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : requests(requests),
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 1572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   last_request_time(0.0),
															#line 1575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   requests_batch()
															#line 8696 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusServer", reinterpret_cast<unsigned long>(this));

	}
	~StatusServerActorState() 
	{
		fdb_probe_actor_destroy("statusServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1577 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 8711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusServerActorState();
		static_cast<StatusServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto __when_expr_0 = requests;
															#line 8742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StatusRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StatusRequest>>::value, "invalid type");
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8746 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StatusServerActor*>(this)->actor_wait_state = 1;
															#line 1580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StatusServerActor, 0, StatusRequest >*>(static_cast<StatusServerActor*>(this)));
															#line 8751 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1669 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "StatusServerError").error(e);
															#line 1670 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest const& req,int loopDepth) 
	{
															#line 1581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest && req,int loopDepth) 
	{
															#line 1581 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1589 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorSingleCallback< StatusServerActor, 0, StatusRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 8916 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 8922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 8928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 8941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 8945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 8954 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 8958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 8966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 8978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1595 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1597 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 8991 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 8997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 9003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1610 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1611 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1614 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 9016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 9020 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1620 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 9029 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1623 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 9033 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1625 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1626 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 9041 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 9053 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1644 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError() && result.getError().code() == error_code_actor_cancelled)
															#line 9137 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(result.getError(), loopDepth);
															#line 9141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		last_request_time = now();
															#line 1651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus = Optional<StatusReply>();
															#line 1652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9149 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> const& __result,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		result = __result;
															#line 9158 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus.reset();
															#line 9237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 1652 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!requests_batch.empty()))
															#line 9253 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1653 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError())
															#line 9259 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1654 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			requests_batch.back().reply.sendError(result.getError());
															#line 9263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (requests_batch.back().statusField.empty())
															#line 9269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1656 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(result.get());
															#line 9273 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(requests_batch.back().statusField == "fault_tolerance");
															#line 1659 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!faultToleranceRelatedStatus.present())
															#line 9281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1660 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					faultToleranceRelatedStatus = clusterGetFaultToleranceStatus(result.get().statusStr);
															#line 9285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1662 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(faultToleranceRelatedStatus.get());
															#line 9289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.pop_back();
															#line 1665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 4;
															#line 1665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 3, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 9303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	FutureStream<StatusRequest> requests;
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster const* configBroadcaster;
															#line 1572 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double last_request_time;
															#line 1575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StatusRequest> requests_batch;
															#line 1630 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ErrorOr<StatusReply> result;
															#line 1651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<StatusReply> faultToleranceRelatedStatus;
															#line 9437 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusServer()
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActor final : public Actor<Void>, public ActorSingleCallback< StatusServerActor, 0, StatusRequest >, public ActorCallback< StatusServerActor, 1, Void >, public ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >, public ActorCallback< StatusServerActor, 3, Void >, public FastAllocated<StatusServerActor>, public StatusServerActorState<StatusServerActor> {
															#line 9442 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusServerActor>::operator new;
	using FastAllocated<StatusServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16374608444142322176UL, 9586169520573121792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StatusServerActor, 0, StatusRequest >;
friend struct ActorCallback< StatusServerActor, 1, Void >;
friend struct ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >;
friend struct ActorCallback< StatusServerActor, 3, Void >;
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActor(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 9462 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusServerActorState<StatusServerActor>(requests, self, coordinators, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7571137253636277504UL, 14171083556526699776UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StatusServerActor, 0, StatusRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> statusServer( FutureStream<StatusRequest> const& requests, ClusterControllerData* const& self, ServerCoordinators const& coordinators, ConfigBroadcaster const* const& configBroadcaster ) {
															#line 1567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StatusServerActor(requests, self, coordinators, configBroadcaster));
															#line 9498 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 9503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorProcessClasses()
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorProcessClassesActor>
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActorState {
															#line 9510 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActorState(ClusterControllerData* const& self) 
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   trVer(self->db.db)
															#line 9519 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 9534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProcessClassesActorState();
		static_cast<MonitorProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9557 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1680 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1681 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = trVer.get(processClassVersionKey);
															#line 1683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 1683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = trVer.onError(e);
															#line 1702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9622 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 4;
															#line 1702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 3, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9627 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 9642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9650 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9655 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 9664 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1688 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 9771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9777 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && processClasses,int loopDepth) 
	{
															#line 1689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1692 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1695 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 9801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9807 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 9896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 9905 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(self->db.db);
															#line 1709 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1712 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10114 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 5;
															#line 1713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10119 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 1757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10156 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 8;
															#line 1757 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 7, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10161 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 10178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 10190 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 10200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 10204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 10210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 10214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 10222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 10226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 10236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10244 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10249 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && processClasses,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1716 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 10260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1718 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1719 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 10272 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1724 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1725 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1726 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1728 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 10282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 10286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1733 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 10292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1736 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 10296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1738 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 10304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 10308 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1749 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 10318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1753 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10417 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10422 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10433 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10438 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction trVer;
															#line 1707 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 10700 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorProcessClasses()
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActor final : public Actor<Void>, public ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >, public ActorCallback< MonitorProcessClassesActor, 1, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 2, Void >, public ActorCallback< MonitorProcessClassesActor, 3, Void >, public ActorCallback< MonitorProcessClassesActor, 4, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 5, Void >, public ActorCallback< MonitorProcessClassesActor, 6, Void >, public ActorCallback< MonitorProcessClassesActor, 7, Void >, public FastAllocated<MonitorProcessClassesActor>, public MonitorProcessClassesActorState<MonitorProcessClassesActor> {
															#line 10705 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorProcessClassesActor>::operator new;
	using FastAllocated<MonitorProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18062449691198322944UL, 11475701989840500480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorProcessClassesActor, 1, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 2, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 3, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 4, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 5, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 6, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 7, Void >;
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActor(ClusterControllerData* const& self) 
															#line 10729 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorProcessClassesActorState<MonitorProcessClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588372557279712768UL, 7971599830169234176UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorProcessClasses( ClusterControllerData* const& self ) {
															#line 1675 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorProcessClassesActor(self));
															#line 10769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1762 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 10774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorServerInfoConfigActor>
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActorState {
															#line 10781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 10788 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerInfoConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1764 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerInfoConfigActorState();
		static_cast<MonitorServerInfoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1766 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1770 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(latencyBandConfigKey);
															#line 1772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 1;
															#line 1772 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 10871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10908 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 4;
															#line 1794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 3, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 10913 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& configVal,int loopDepth) 
	{
															#line 1773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 10930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 10934 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 10940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 10952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 10965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && configVal,int loopDepth) 
	{
															#line 1773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 10976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1775 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 10980 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1778 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 10986 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1781 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1782 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1783 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1784 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 10998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(configVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(configVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11097 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11113 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11118 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> configChangeFuture;
															#line 11378 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActor final : public Actor<Void>, public ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorServerInfoConfigActor, 1, Void >, public ActorCallback< MonitorServerInfoConfigActor, 2, Void >, public ActorCallback< MonitorServerInfoConfigActor, 3, Void >, public FastAllocated<MonitorServerInfoConfigActor>, public MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor> {
															#line 11383 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorServerInfoConfigActor>::operator new;
	using FastAllocated<MonitorServerInfoConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(676552823745568256UL, 6020023680048973568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 1, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 2, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 3, Void >;
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 11403 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7361646417378993920UL, 12905750869672403968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerInfoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorServerInfoConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorServerInfoConfigActor(db));
															#line 11439 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1799 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors storage metadata changes and updates to storage servers.
															#line 11445 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorStorageMetadata()
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorStorageMetadataActor>
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActorState {
															#line 11452 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActorState(ClusterControllerData* const& self) 
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx)),
															#line 1805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   servers()
															#line 11465 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1806 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 11480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageMetadataActorState();
		static_cast<MonitorStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.clear();
															#line 1809 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1811 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11521 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11526 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 1842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11550 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 5;
															#line 1842 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 4, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11555 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1813 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1815 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		servers.reserve(serverList.size());
															#line 1816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto ss : serverList ) {
															#line 1817 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.push_back(StorageServerMetaInfo(decodeServerListValue(ss.value)));
															#line 11576 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverMetadataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11582 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11587 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __serverList,int loopDepth) 
	{
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverList = __serverList;
															#line 11596 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __serverList,int loopDepth) 
	{
		serverList = std::move(__serverList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1821 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverMetadata.more && serverMetadata.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1822 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<UID, StorageMetadataType> idMetadata;
															#line 1823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& sm : serverMetadata ) {
															#line 1824 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const UID id = decodeServerMetadataKey(sm.key);
															#line 1825 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			idMetadata[id] = decodeServerMetadataValue(sm.value);
															#line 11683 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1827 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& s : servers ) {
															#line 1828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (idMetadata.contains(s.id()))
															#line 11689 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1829 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				s.metadata = idMetadata[s.id()];
															#line 11693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1831 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "StorageServerMetadataMissing", self->id).detail("ServerID", s.id());
															#line 11699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr->watch(serverMetadataChangeKey);
															#line 1836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1836 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 2, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11713 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __serverMetadata,int loopDepth) 
	{
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverMetadata = __serverMetadata;
															#line 11722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __serverMetadata,int loopDepth) 
	{
		serverMetadata = std::move(__serverMetadata);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11810 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1838 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11823 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1839 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 11828 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 11912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 11921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1802 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1805 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StorageServerMetaInfo> servers;
															#line 1812 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverList;
															#line 1820 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverMetadata;
															#line 1835 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 12115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorStorageMetadata()
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActor final : public Actor<Void>, public ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 2, Void >, public ActorCallback< MonitorStorageMetadataActor, 3, Void >, public ActorCallback< MonitorStorageMetadataActor, 4, Void >, public FastAllocated<MonitorStorageMetadataActor>, public MonitorStorageMetadataActorState<MonitorStorageMetadataActor> {
															#line 12120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorStorageMetadataActor>::operator new;
	using FastAllocated<MonitorStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11781128329978090496UL, 14030041887418683392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 2, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 3, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 4, Void >;
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActor(ClusterControllerData* const& self) 
															#line 12141 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorStorageMetadataActorState<MonitorStorageMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8345257820642168576UL, 250769687947896832UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorStorageMetadata( ClusterControllerData* const& self ) {
															#line 1801 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorStorageMetadataActor(self));
															#line 12178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1846 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors the global configuration version key for changes. When changes are
// made, the global configuration history is read and any updates are sent to
// all processes in the system by updating the ClientDBInfo object. The
// GlobalConfig actor class contains the functionality to read the latest
// history and update the processes local view.
															#line 12188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorGlobalConfig()
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorGlobalConfigActor>
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActorState {
															#line 12195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 12202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGlobalConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1853 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGlobalConfigActorState();
		static_cast<MonitorGlobalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = ClientDBInfo();
															#line 1856 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 12251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1858 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1859 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(globalConfigVersionKey);
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 1;
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 5;
															#line 1935 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 4, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 1862 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (globalConfigVersion.present())
															#line 12342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 2;
															#line 1866 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 12367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigFuture = tr.watch(globalConfigVersionKey);
															#line 1931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12450 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 3;
															#line 1931 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 2, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12455 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult const& globalConfigHistory,int loopDepth) 
	{
															#line 1870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 12474 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 12480 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 1889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 12499 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 12503 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 12507 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 12523 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult && globalConfigHistory,int loopDepth) 
	{
															#line 1870 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1871 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1872 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1874 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1875 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1876 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 12542 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1884 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1885 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 12548 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 1889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1890 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1893 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1895 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1897 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1898 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1900 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 12567 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1903 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 12571 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 12575 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1918 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1921 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1923 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1924 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1927 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 12591 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(globalConfigHistory, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(globalConfigHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12682 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12693 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1932 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 12698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1854 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1855 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClientDBInfo clientInfo;
															#line 1860 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1930 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> globalConfigFuture;
															#line 12962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorGlobalConfig()
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActor final : public Actor<Void>, public ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >, public ActorCallback< MonitorGlobalConfigActor, 2, Void >, public ActorCallback< MonitorGlobalConfigActor, 3, Void >, public ActorCallback< MonitorGlobalConfigActor, 4, Void >, public FastAllocated<MonitorGlobalConfigActor>, public MonitorGlobalConfigActorState<MonitorGlobalConfigActor> {
															#line 12967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorGlobalConfigActor>::operator new;
	using FastAllocated<MonitorGlobalConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8540771797786988032UL, 32437365528062720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >;
friend struct ActorCallback< MonitorGlobalConfigActor, 2, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 3, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 4, Void >;
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 12988 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorGlobalConfigActorState<MonitorGlobalConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619138829789891328UL, 5514350300057065984UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGlobalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorGlobalConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1852 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorGlobalConfigActor(db));
															#line 13025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 13030 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangingDatacentersActor>
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActorState {
															#line 13037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActorState(ClusterControllerData* const& self) 
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 13044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangingDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangingDatacentersActorState();
		static_cast<UpdatedChangingDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13089 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1944 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13098 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->desiredDcIds.onChange();
															#line 1946 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->desiredDcIds.get().present())
															#line 13191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set(std::make_pair(false, self->desiredDcIds.get()));
															#line 13195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 1949 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1950 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->desiredDcIds.get().get());
															#line 1952 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set( std::make_pair(worker.priorityInfo.dcFitness > newFitness, self->desiredDcIds.get()));
															#line 1955 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangingDatacenter", self->id) .detail("OldFitness", worker.priorityInfo.dcFitness) .detail("NewFitness", newFitness);
															#line 1958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.priorityInfo.dcFitness > newFitness)
															#line 13210 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1959 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				worker.priorityInfo.dcFitness = newFitness;
															#line 1960 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!worker.reply.isSet())
															#line 13216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1961 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.reply.send(RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13220 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onChange;
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 3;
															#line 1992 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13248 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1965 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 13276 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1966 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1967 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1968 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 13286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1971 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changingDcIds.get().second.get());
															#line 1973 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 13292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1975 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1977 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 13300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1978 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send( RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 13304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1984 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 13311 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 1985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13317 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 2;
															#line 1985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 13322 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1987 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 13349 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1945 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1964 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 13534 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangingDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangingDatacentersActor>, public UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor> {
															#line 13539 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangingDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangingDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1603754078579004416UL, 9889122211086815488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangingDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 2, Void >;
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActor(ClusterControllerData* const& self) 
															#line 13558 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7981795789287489024UL, 15976645570533241600UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangingDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangingDatacenters( ClusterControllerData* const& self ) {
															#line 1941 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangingDatacentersActor(self));
															#line 13593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1995 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 13598 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangedDatacentersActor>
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActorState {
															#line 13605 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActorState(ClusterControllerData* const& self) 
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   changeDelay(delay(SERVER_KNOBS->CC_CHANGE_DELAY)),
															#line 1998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   onChange(self->changingDcIds.onChange())
															#line 13616 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangedDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 13631 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangedDatacentersActorState();
		static_cast<UpdatedChangedDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 2000 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = changeDelay;
															#line 13667 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 1;
															#line 2001 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 2005 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 13674 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 13691 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2002 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2003 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 13702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 13717 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 13723 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 13731 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 13737 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13741 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13752 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2007 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2009 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2010 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 13773 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2011 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2012 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 13779 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2013 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2016 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 13787 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2017 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2018 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 13793 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 13797 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 13808 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 0, Void >::remove();
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 2025 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 13912 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2026 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 2027 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 2028 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 13922 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2031 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2034 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 13928 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2036 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 2037 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 2038 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 13936 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2039 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send(RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 13940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2045 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 13947 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 2046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13953 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 2;
															#line 2046 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 13958 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(int loopDepth) 
	{
															#line 2048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 13985 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> changeDelay;
															#line 1998 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2024 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 14142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangedDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangedDatacentersActor>, public UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor> {
															#line 14147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangedDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangedDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5849846416406404608UL, 8164828583299461632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangedDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 2, Void >;
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActor(ClusterControllerData* const& self) 
															#line 14166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151090047836179200UL, 49094124038652928UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangedDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangedDatacenters( ClusterControllerData* const& self ) {
															#line 1996 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangedDatacentersActor(self));
															#line 14200 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateDatacenterVersionDifferenceActor>
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActorState {
															#line 14212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActorState(ClusterControllerData* const& self) 
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   lastLogTime(0)
															#line 14221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDatacenterVersionDifferenceActorState() 
	{
		fdb_probe_actor_destroy("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2059 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDatacenterVersionDifferenceActorState();
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2060 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->versionDifferenceUpdated = false;
															#line 2061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && self->db.config.usableRegions == 1)
															#line 14268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2065 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2066 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = 0;
															#line 2067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = 0;
															#line 2068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = 0;
															#line 2070 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge)
															#line 14282 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14292 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 1;
															#line 2074 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 2079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 2080 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 14315 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2081 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& logSet : self->db.serverInfo->get().logSystemConfig.tLogs ) {
															#line 2082 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (logSet.isLocal && logSet.locality != tagLocalitySatellite)
															#line 14321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2083 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2084 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 14327 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2085 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							primaryLog = tLog.interf();
															#line 14331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
															#line 2090 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!logSet.isLocal)
															#line 14338 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2091 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 14344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2093 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							remoteLog = tLog.interf();
															#line 14348 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
			}
		}
															#line 2101 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present() || !self->db.serverInfo->get().ratekeeper.present())
															#line 14357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 2;
															#line 2102 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 2106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->db.serverInfo->onChange();
															#line 2107 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 14471 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 2108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ssVersionLagReply = brokenPromiseToNever( self->db.serverInfo->get().ratekeeper.get().getSSVersionLag.getReply(GetSSVersionLagRequest()));
															#line 2115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = (success(primaryMetrics) && success(remoteMetrics) && success(ssVersionLagReply)) || onChange;
															#line 2115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14588 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 3;
															#line 2115 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14593 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14615 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 14621 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 14637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14641 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 14645 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 14651 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14663 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2116 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14672 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2120 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 14678 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2121 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2123 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2124 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2125 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2129 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2132 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2134 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 14694 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2135 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 14698 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2138 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 14702 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2139 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2140 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 14708 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14715 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2147 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 14720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14804 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 14816 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2058 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double lastLogTime;
															#line 2078 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 2079 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 2106 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2108 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 2110 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 2112 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<GetSSVersionLagReply> ssVersionLagReply;
															#line 14915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActor final : public Actor<Void>, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >, public FastAllocated<UpdateDatacenterVersionDifferenceActor>, public UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor> {
															#line 14920 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator new;
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15182730816699571200UL, 3616186237491516928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >;
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActor(ClusterControllerData* const& self) 
															#line 14940 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937717957229000960UL, 3709248056524776448UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDatacenterVersionDifference");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateDatacenterVersionDifference( ClusterControllerData* const& self ) {
															#line 2057 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateDatacenterVersionDifferenceActor(self));
															#line 14976 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// A background actor that periodically checks remote DC health, and `checkOutstandingRequests` if remote DC
// recovers.
															#line 14983 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateRemoteDCHealthActor>
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActorState {
															#line 14990 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActorState(ClusterControllerData* const& self) 
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 14997 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRemoteDCHealthActorState() 
	{
		fdb_probe_actor_destroy("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->INITIAL_UPDATE_CROSS_DC_INFO_DELAY);
															#line 2160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15014 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 1;
															#line 2160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 15019 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRemoteDCHealthActorState();
		static_cast<UpdateRemoteDCHealthActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 15044 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15048 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 15052 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2162 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 15063 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2167 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15067 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 15071 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2171 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool oldRemoteTransactionSystemDegraded = self->remoteTransactionSystemDegraded;
															#line 2172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteTransactionSystemDegraded = self->remoteTransactionSystemContainsDegradedServers();
															#line 2174 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (oldRemoteTransactionSystemDegraded && !self->remoteTransactionSystemDegraded)
															#line 15166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2175 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 15170 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_REMOTE_HEALTH_INTERVAL);
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15176 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 2;
															#line 2177 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 15181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 15275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActor final : public Actor<Void>, public ActorCallback< UpdateRemoteDCHealthActor, 0, Void >, public ActorCallback< UpdateRemoteDCHealthActor, 1, Void >, public FastAllocated<UpdateRemoteDCHealthActor>, public UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor> {
															#line 15280 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRemoteDCHealthActor>::operator new;
	using FastAllocated<UpdateRemoteDCHealthActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4552146892861510400UL, 2215365576249161216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRemoteDCHealthActor, 0, Void >;
friend struct ActorCallback< UpdateRemoteDCHealthActor, 1, Void >;
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActor(ClusterControllerData* const& self) 
															#line 15298 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4727392956320167168UL, 13078950417560124416UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRemoteDCHealth");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateRemoteDCHealth( ClusterControllerData* const& self ) {
															#line 2157 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateRemoteDCHealthActor(self));
															#line 15332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2180 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15337 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doEmptyCommit()
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoEmptyCommitActor>
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActorState {
															#line 15344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActorState(Database const& cx) 
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cx(cx),
															#line 2182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(cx)
															#line 15353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoEmptyCommitActorState() 
	{
		fdb_probe_actor_destroy("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2183 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2185 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2186 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2187 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.makeSelfConflicting();
															#line 2188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 2188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15407 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 1;
															#line 2188 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 0, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 15412 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15436 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 2;
															#line 2191 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 1, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 15441 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 15456 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2189 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 15468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 2182 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Transaction tr;
															#line 15642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doEmptyCommit()
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActor final : public Actor<Void>, public ActorCallback< DoEmptyCommitActor, 0, Void >, public ActorCallback< DoEmptyCommitActor, 1, Void >, public FastAllocated<DoEmptyCommitActor>, public DoEmptyCommitActorState<DoEmptyCommitActor> {
															#line 15647 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoEmptyCommitActor>::operator new;
	using FastAllocated<DoEmptyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7297420197052084992UL, 17944179077674551296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoEmptyCommitActor, 0, Void >;
friend struct ActorCallback< DoEmptyCommitActor, 1, Void >;
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActor(Database const& cx) 
															#line 15665 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoEmptyCommitActorState<DoEmptyCommitActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9964447062675513344UL, 11254058382217442560UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doEmptyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doEmptyCommit( Database const& cx ) {
															#line 2181 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoEmptyCommitActor(cx));
															#line 15699 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2195 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15704 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleForcedRecoveries()
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleForcedRecoveriesActor>
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActorState {
															#line 15711 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 15720 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	~HandleForcedRecoveriesActorState() 
	{
		fdb_probe_actor_destroy("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2197 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15735 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleForcedRecoveriesActorState();
		static_cast<HandleForcedRecoveriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.forceRecovery.getFuture();
															#line 15765 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ForceRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ForceRecoveryRequest>>::value, "invalid type");
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15769 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 1;
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15774 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2199 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryStart", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("DcId", req.dcId.printable());
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		fCommit = doEmptyCommit(self->cx);
															#line 2203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = fCommit || delay(SERVER_KNOBS->FORCE_RECOVERY_CHECK_DELAY);
															#line 2203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15789 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 2;
															#line 2203 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 1, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest const& __req,int loopDepth) 
	{
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req = __req;
															#line 15803 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 15882 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 15886 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 15896 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 15904 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15910 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15915 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2204 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 15929 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2205 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 15933 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2206 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2207 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2208 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2209 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 15943 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2211 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2212 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 15951 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15957 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 15962 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2216 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryFinish", self->id).log();
															#line 2217 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.forceRecovery = false;
															#line 2218 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 16055 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 2198 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ForceRecoveryRequest req;
															#line 2202 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> fCommit;
															#line 16155 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleForcedRecoveries()
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActor final : public Actor<Void>, public ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >, public ActorCallback< HandleForcedRecoveriesActor, 1, Void >, public ActorCallback< HandleForcedRecoveriesActor, 2, Void >, public FastAllocated<HandleForcedRecoveriesActor>, public HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor> {
															#line 16160 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleForcedRecoveriesActor>::operator new;
	using FastAllocated<HandleForcedRecoveriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5671473837580086528UL, 14007346976116974336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 1, Void >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 2, Void >;
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 16179 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14107891886794473728UL, 6151159479286482432UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleForcedRecoveries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleForcedRecoveries( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2196 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleForcedRecoveriesActor(self, interf));
															#line 16214 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2221 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16219 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via triggerAuditStorage()
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TriggerAuditStorageActor>
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActorState {
															#line 16226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req),
															#line 2223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   auditId()
															#line 16237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2224 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(!req.cancel);
															#line 16252 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 16256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2254 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TriggerAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerAuditStorageActorState(); static_cast<TriggerAuditStorageActor*>(this)->destroy(); return 0; }
															#line 16285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TriggerAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2245 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCTriggerAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2251 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 16300 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2230 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageBegin", self->id) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2235 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.range, req.engineType);
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16321 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2236 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 1, UID >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 16326 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2226 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 16342 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2228 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 0, Void >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 16355 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 2237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16468 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId_,int loopDepth) 
	{
															#line 2237 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2238 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2243 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16481 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 2223 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID auditId;
															#line 16580 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via triggerAuditStorage()
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActor final : public Actor<Void>, public ActorCallback< TriggerAuditStorageActor, 0, Void >, public ActorCallback< TriggerAuditStorageActor, 1, UID >, public FastAllocated<TriggerAuditStorageActor>, public TriggerAuditStorageActorState<TriggerAuditStorageActor> {
															#line 16585 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TriggerAuditStorageActor>::operator new;
	using FastAllocated<TriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8831915891837551104UL, 13649215852772394496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageActor, 0, Void >;
friend struct ActorCallback< TriggerAuditStorageActor, 1, UID >;
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 16603 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TriggerAuditStorageActorState<TriggerAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12747449799772827392UL, 11482104197366523904UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> triggerAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2222 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TriggerAuditStorageActor(self, req));
															#line 16637 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2256 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16642 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancelAuditStorage()
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class CancelAuditStorageActor>
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActorState {
															#line 16649 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 16658 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2258 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.cancel);
															#line 16673 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 16677 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2284 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<CancelAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditStorageActorState(); static_cast<CancelAuditStorageActor*>(this)->destroy(); return 0; }
															#line 16706 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<CancelAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2277 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCCancelAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditType", req.getType());
															#line 2281 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(cancel_audit_storage_failed());
															#line 16721 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2264 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageBegin", self->id) .detail("AuditID", req.id) .detail("AuditType", req.getType()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.id);
															#line 2269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16742 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2269 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 1, UID >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 16747 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2260 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 16763 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16771 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2262 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 0, Void >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 16776 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId,int loopDepth) 
	{
															#line 2270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16889 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId,int loopDepth) 
	{
															#line 2270 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2274 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2275 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 16902 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 16999 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cancelAuditStorage()
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActor final : public Actor<Void>, public ActorCallback< CancelAuditStorageActor, 0, Void >, public ActorCallback< CancelAuditStorageActor, 1, UID >, public FastAllocated<CancelAuditStorageActor>, public CancelAuditStorageActorState<CancelAuditStorageActor> {
															#line 17004 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<CancelAuditStorageActor>::operator new;
	using FastAllocated<CancelAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2889710296956144128UL, 4055330737054762240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditStorageActor, 0, Void >;
friend struct ActorCallback< CancelAuditStorageActor, 1, UID >;
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 17022 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CancelAuditStorageActorState<CancelAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10342539104284409856UL, 5939736706038642176UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2257 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new CancelAuditStorageActor(self, req));
															#line 17056 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2286 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17061 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleTriggerAuditStorageActor>
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActorState {
															#line 17068 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 17077 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~HandleTriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2288 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17092 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleTriggerAuditStorageActorState();
		static_cast<HandleTriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.triggerAudit.getFuture();
															#line 17122 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TriggerAuditRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TriggerAuditRequest>>::value, "invalid type");
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17126 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2289 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*>(static_cast<HandleTriggerAuditStorageActor*>(this)));
															#line 17131 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest const& req,int loopDepth) 
	{
															#line 2290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 17142 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 17148 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 17154 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest && req,int loopDepth) 
	{
															#line 2290 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2295 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 17166 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2296 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2297 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 17172 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2299 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 17178 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTriggerAuditStorageActor*>(this)->ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest const& value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest && value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 17263 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActor final : public Actor<Void>, public ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >, public FastAllocated<HandleTriggerAuditStorageActor>, public HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor> {
															#line 17268 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleTriggerAuditStorageActor>::operator new;
	using FastAllocated<HandleTriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2277794036021372672UL, 10504028197640941056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >;
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 17285 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15197834898829094656UL, 1920184061417848064UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleTriggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleTriggerAuditStorage( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2287 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleTriggerAuditStorageActor(self, interf));
															#line 17318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2303 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startDataDistributor()
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartDataDistributorActor>
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActorState {
															#line 17330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2304 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 17339 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~StartDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17356 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2307 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 0, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17361 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartDataDistributorActorState();
		static_cast<StartDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17386 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2309 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2310 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17397 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2312 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			noDistributor = !self->db.serverInfo->get().distributor.present();
															#line 2313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17491 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17508 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 4;
															#line 2371 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 3, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17513 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2366 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruitError", self->id).error(e);
															#line 2367 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 17525 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2368 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17529 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2318 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (noDistributor && self->db.serverInfo->get().distributor.present())
															#line 17545 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2320 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17549 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2323 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> idUsed = self->getUsedIds();
															#line 2324 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo ddWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::DataDistributor, ProcessClass::NeverAssign, self->db.config, idUsed);
															#line 2329 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeDataDistributorRequest req(deterministicRandom()->randomUniqueID());
															#line 2330 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = ddWorker.worker;
															#line 2331 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::DataDistributor))
															#line 17565 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2332 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 17569 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2335 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingDistributorID = req.reqId;
															#line 2336 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitDataDistributor", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", req.reqId);
															#line 2340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<DataDistributorInterface>> __when_expr_2 = worker.interf.dataDistributor.getReplyUnlessFailedFor( req, SERVER_KNOBS->WAIT_FOR_DISTRIBUTOR_JOIN_DELAY, 0);
															#line 2340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17579 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2340 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17584 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2313 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 17600 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17608 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2316 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 1, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 17613 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
															#line 2343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 17722 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 17734 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 17740 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 17744 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 17748 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17754 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
															#line 2343 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 17768 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2344 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2345 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2346 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2347 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2350 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 17780 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2353 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2357 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 17786 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2359 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 17790 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2360 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 17794 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2362 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2363 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 17800 "/codebuild/output/src3530752165/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddInterf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914