/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.test.Context;
import com.apple.foundationdb.test.Stack;
import com.apple.foundationdb.test.StackEntry;
import com.apple.foundationdb.tuple.Tuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class Instruction
extends Stack {
    private static final String SUFFIX_SNAPSHOT = "_SNAPSHOT";
    private static final String SUFFIX_DATABASE = "_DATABASE";
    final String op;
    final Tuple tokens;
    final Context context;
    final boolean isDatabase;
    final boolean isSnapshot;
    final Transaction tr;
    final ReadTransaction readTr;
    final TransactionContext tcx;
    final ReadTransactionContext readTcx;

    Instruction(Context context, Tuple tuple) {
        this.context = context;
        this.tokens = tuple;
        String string = tuple.getString(0);
        boolean bl = string.endsWith(SUFFIX_DATABASE);
        this.isSnapshot = string.endsWith(SUFFIX_SNAPSHOT);
        if (bl) {
            this.tr = null;
            this.readTr = null;
            this.op = string.substring(0, string.length() - SUFFIX_DATABASE.length());
        } else if (this.isSnapshot) {
            this.tr = context.getCurrentTransaction();
            this.readTr = this.tr.snapshot();
            this.op = string.substring(0, string.length() - SUFFIX_SNAPSHOT.length());
        } else {
            this.tr = context.getCurrentTransaction();
            this.readTr = this.tr;
            this.op = string;
        }
        this.isDatabase = bl;
        this.tcx = this.isDatabase ? context.db : this.tr;
        this.readTcx = this.isDatabase ? context.db : this.readTr;
    }

    boolean replaceTransaction(Transaction transaction) {
        if (!this.isDatabase) {
            this.context.replaceTransaction(transaction);
            return true;
        }
        return false;
    }

    boolean replaceTransaction(Transaction transaction, Transaction transaction2) {
        if (!this.isDatabase) {
            return this.context.replaceTransaction(transaction, transaction2);
        }
        return false;
    }

    void releaseTransaction() {
        Context.releaseTransaction(this.tr);
    }

    void push(Object object2) {
        if (object2 instanceof CompletableFuture && this.tr != null) {
            CompletableFuture completableFuture = (CompletableFuture)object2;
            Context.addTransactionReference(this.tr);
            completableFuture.whenComplete((object, throwable) -> Context.releaseTransaction(this.tr));
        }
        this.context.stack.push(this.context.instructionIndex, object2);
    }

    @Override
    void push(int n, Object object) {
        this.context.stack.push(n, object);
    }

    @Override
    void push(StackEntry stackEntry) {
        this.context.stack.push(stackEntry);
    }

    @Override
    StackEntry pop() {
        return this.context.stack.pop();
    }

    @Override
    void swap(int n) {
        this.context.stack.swap(n);
    }

    @Override
    int size() {
        return this.context.stack.size();
    }

    @Override
    void clear() {
        this.context.stack.clear();
    }

    CompletableFuture<List<Object>> popParams(int n) {
        return this.context.popParams(n);
    }

    CompletableFuture<Object> popParam() {
        return this.popParams(1).thenApplyAsync(list -> list.get(0));
    }
}

