/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RequiresDatabase
implements ExecutionCondition,
BeforeAllCallback {
    private static boolean networkOptionsSet = false;

    public static boolean canRunIntegrationTest() {
        String string = System.getProperty("run.integration.tests");
        if (string == null) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        if (RequiresDatabase.canRunIntegrationTest()) {
            return ConditionEvaluationResult.enabled((String)"Database is running");
        }
        return ConditionEvaluationResult.disabled((String)"Database is not running");
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Object object;
        FDB fDB = FDB.selectAPIVersion((int)800);
        if (!networkOptionsSet) {
            networkOptionsSet = true;
            object = extensionContext.getConfigurationParameter("external_client_library");
            if (((Optional)object).isPresent()) {
                System.err.printf("external_client_library : %s\n", ((Optional)object).get());
                fDB.options().setExternalClientLibrary((String)((Optional)object).get());
                fDB.options().setDisableLocalClient();
            }
        }
        object = fDB.open();
        try {
            object.run(transaction -> {
                transaction.options().setTimeout(100L);
                CompletableFuture completableFuture = transaction.get("test".getBytes());
                try {
                    return (byte[])completableFuture.join();
                }
                catch (FDBException fDBException) {
                    if (fDBException.getCode() == 1031) {
                        Assertions.fail((String)("Test " + extensionContext.getDisplayName() + " failed to start: cannot to database within timeout"));
                    }
                    throw fDBException;
                }
            });
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
    }
}

