#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
/*
 * BackupCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain the purpose of this workload and how it different from the
// 20+ (literally) other backup/restore workloads.

struct RestoreWorkload : TestWorkload {
	static constexpr auto NAME = "Restore";
	Key backupTag, backupTag1, backupTag2;
	bool performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges, restoreRanges;
	static int backupAgentRequests;
	LockDB locked{ false };
	bool allowPauses;
	bool shareLogRange;
	bool shouldSkipRestoreRanges;
	UID randomID;

	RestoreWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag1 = getOption(options, "backupTag1"_sr, BackupAgentBase::getDefaultTag());
		backupTag2 = getOption(options, "backupTag2"_sr, BackupAgentBase::getDefaultTag());
		backupTag = deterministicRandom()->coinflip() ? backupTag1 : backupTag2;
		agentRequest = getOption(options, "simBackupAgents"_sr, true);
		allowPauses = getOption(options, "allowPauses"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);

		std::vector<std::string> restorePrefixesToInclude =
		    getOption(options, "restorePrefixesToInclude"_sr, std::vector<std::string>());

		shouldSkipRestoreRanges = deterministicRandom()->random01() < 0.3 ? true : false;
		randomID = nondeterministicRandom()->randomUniqueID();
		TraceEvent("RW_ClientId").detail("Id", wcx.clientId);
		TraceEvent("RW_PerformRestore", randomID).detail("Value", performRestore);

		backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
		restoreRanges = backupRanges; // may be modified later

		for (auto& range : restoreRanges) {
			TraceEvent("RW_RestoreRange", randomID)
			    .detail("RangeBegin", printable(range.begin))
			    .detail("RangeEnd", printable(range.end));
		}
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		TraceEvent(SevInfo, "RW_Param")
		    .detail("Locked", locked)
		    .detail("PerformRestore", performRestore)
		    .detail("BackupTag", printable(backupTag).c_str())
		    .detail("AgentRequest", agentRequest);

		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
// This generated class is to be used only via changePaused()
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
template <class ChangePausedActor>
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class ChangePausedActorState {
															#line 104 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	ChangePausedActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		 : cx(cx),
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   backupAgent(backupAgent)
															#line 113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("changePaused", reinterpret_cast<unsigned long>(this));

	}
	~ChangePausedActorState() 
	{
		fdb_probe_actor_destroy("changePaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			;
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangePausedActorState();
		static_cast<ChangePausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, true);
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 160 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 0, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 165 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentPaused").log();
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 178 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 183 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentPaused").log();
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 201 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 287 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 292 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 303 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 308 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentResumed").log();
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 396 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 401 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentResumed").log();
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 414 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 419 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 590 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via changePaused()
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class ChangePausedActor final : public Actor<Void>, public ActorCallback< ChangePausedActor, 0, Void >, public ActorCallback< ChangePausedActor, 1, Void >, public ActorCallback< ChangePausedActor, 2, Void >, public ActorCallback< ChangePausedActor, 3, Void >, public FastAllocated<ChangePausedActor>, public ChangePausedActorState<ChangePausedActor> {
															#line 595 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangePausedActor>::operator new;
	using FastAllocated<ChangePausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17552820553194042880UL, 2732574695650784768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangePausedActor, 0, Void >;
friend struct ActorCallback< ChangePausedActor, 1, Void >;
friend struct ActorCallback< ChangePausedActor, 2, Void >;
friend struct ActorCallback< ChangePausedActor, 3, Void >;
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	ChangePausedActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 615 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangePausedActorState<ChangePausedActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5431177707453768448UL, 12966551901980677120UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changePaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangePausedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangePausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangePausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangePausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
[[nodiscard]] static Future<Void> changePaused( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	return Future<Void>(new ChangePausedActor(cx, backupAgent));
															#line 650 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
}

#line 106 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"

	// Resume the backup agent if it is paused
																#line 656 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
// This generated class is to be used only via resumeAgent()
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
template <class ResumeAgentActor>
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class ResumeAgentActorState {
															#line 662 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	ResumeAgentActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		 : cx(cx),
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   backupAgent(backupAgent)
															#line 671 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("resumeAgent", reinterpret_cast<unsigned long>(this));

	}
	~ResumeAgentActorState() 
	{
		fdb_probe_actor_destroy("resumeAgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent("RW_AgentResuming").log();
															#line 110 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, false);
															#line 110 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<ResumeAgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 690 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResumeAgentActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResumeAgentActor, 0, Void >*>(static_cast<ResumeAgentActor*>(this)));
															#line 695 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentResumed").log();
															#line 112 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!static_cast<ResumeAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResumeAgentActorState(); static_cast<ResumeAgentActor*>(this)->destroy(); return 0; }
															#line 720 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		new (&static_cast<ResumeAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentResumed").log();
															#line 112 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!static_cast<ResumeAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResumeAgentActorState(); static_cast<ResumeAgentActor*>(this)->destroy(); return 0; }
															#line 734 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		new (&static_cast<ResumeAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResumeAgentActor*>(this)->actor_wait_state > 0) static_cast<ResumeAgentActor*>(this)->actor_wait_state = 0;
		static_cast<ResumeAgentActor*>(this)->ActorCallback< ResumeAgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResumeAgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResumeAgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResumeAgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 821 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via resumeAgent()
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class ResumeAgentActor final : public Actor<Void>, public ActorCallback< ResumeAgentActor, 0, Void >, public FastAllocated<ResumeAgentActor>, public ResumeAgentActorState<ResumeAgentActor> {
															#line 826 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
	using FastAllocated<ResumeAgentActor>::operator new;
	using FastAllocated<ResumeAgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3609658914942753792UL, 4464444846919275008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResumeAgentActor, 0, Void >;
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	ResumeAgentActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 843 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ResumeAgentActorState<ResumeAgentActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(235103107035615488UL, 11787397912531345664UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resumeAgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResumeAgentActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
[[nodiscard]] static Future<Void> resumeAgent( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	return Future<Void>(new ResumeAgentActor(cx, backupAgent));
															#line 875 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
}

#line 114 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"

																#line 880 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
// This generated class is to be used only via statusLoop()
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
template <class StatusLoopActor>
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class StatusLoopActorState {
															#line 886 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	StatusLoopActorState(Database const& cx,std::string const& tag) 
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		 : cx(cx),
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   tag(tag),
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   agent()
															#line 897 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	~StatusLoopActorState() 
	{
		fdb_probe_actor_destroy("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			;
															#line 912 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusLoopActorState();
		static_cast<StatusLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<bool> __when_expr_0 = agent.checkActive(cx);
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 944 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 0, bool >*>(static_cast<StatusLoopActor*>(this)));
															#line 949 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& active,int loopDepth) 
	{
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentActivityCheck").detail("IsActive", active);
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 962 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 967 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && active,int loopDepth) 
	{
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_AgentActivityCheck").detail("IsActive", active);
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 980 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 985 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(active, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(active), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(std::string const& status,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		puts(status.c_str());
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1073 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1078 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::string && status,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		puts(status.c_str());
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1091 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1096 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(std::string const& statusJSON,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		puts(statusJSON.c_str());
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1189 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && statusJSON,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		puts(statusJSON.c_str());
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1202 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1207 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(statusJSON, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(statusJSON), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Database cx;
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	std::string tag;
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	FileBackupAgent agent;
															#line 1380 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusLoop()
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class StatusLoopActor final : public Actor<Void>, public ActorCallback< StatusLoopActor, 0, bool >, public ActorCallback< StatusLoopActor, 1, std::string >, public ActorCallback< StatusLoopActor, 2, std::string >, public ActorCallback< StatusLoopActor, 3, Void >, public FastAllocated<StatusLoopActor>, public StatusLoopActorState<StatusLoopActor> {
															#line 1385 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusLoopActor>::operator new;
	using FastAllocated<StatusLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16290838128002289664UL, 6664729967091482624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusLoopActor, 0, bool >;
friend struct ActorCallback< StatusLoopActor, 1, std::string >;
friend struct ActorCallback< StatusLoopActor, 2, std::string >;
friend struct ActorCallback< StatusLoopActor, 3, Void >;
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	StatusLoopActor(Database const& cx,std::string const& tag) 
															#line 1405 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusLoopActorState<StatusLoopActor>(cx, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1858547908313483776UL, 2242404897950274816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusLoopActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusLoopActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusLoopActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusLoopActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
[[nodiscard]] static Future<Void> statusLoop( Database const& cx, std::string const& tag ) {
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	return Future<Void>(new StatusLoopActor(cx, tag));
															#line 1440 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
}

#line 127 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"

																#line 1445 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
template <class _startActor>
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class _startActorState {
															#line 1451 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	_startActorState(Database const& cx,RestoreWorkload* const& self) 
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		 : cx(cx),
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   self(self),
															#line 129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   backupAgent(),
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		   cp()
															#line 1464 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1481 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 1486 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("PerformRestore", self->performRestore) .detail("AllowPauses", self->allowPauses);
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (self->allowPauses && BUGGIFY)
															#line 1511 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 138 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			cp = changePaused(cx, &backupAgent);
															#line 1515 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		else
		{
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			cp = resumeAgent(cx, &backupAgent);
															#line 1521 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 142 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		status = statusLoop(cx, self->backupTag.toString());
															#line 145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (self->agentRequest)
															#line 1527 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 146 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			RestoreWorkload::backupAgentRequests++;
															#line 1531 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		try {
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<UidAndAbortedFlagT> __when_expr_1 = keyBackedTag.getOrThrow(cx.getReference());
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1540 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 1545 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		config = __config;
															#line 1560 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 363 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1639 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupAndRestorePartitionedCorrectness").error(e).GetLastError();
															#line 361 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1654 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		logUid = uidFlag.first;
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Key> __when_expr_2 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1672 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Key >*>(static_cast<_startActor*>(this)));
															#line 1677 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		logUid = uidFlag.first;
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Key> __when_expr_2 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1690 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Key >*>(static_cast<_startActor*>(this)));
															#line 1695 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont6(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1781 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 1786 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Key const& __destUidValue,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		destUidValue = __destUidValue;
															#line 1795 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Key && __destUidValue,int loopDepth) 
	{
		destUidValue = std::move(__destUidValue);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 157 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 1874 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 158 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), lastBackupContainer->getEncryptionKeyFileName());
															#line 161 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_4 = container->describeBackup();
															#line 161 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1882 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 161 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 1887 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(Reference<IBackupContainer> const& __lastBackupContainer,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		lastBackupContainer = __lastBackupContainer;
															#line 1901 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Reference<IBackupContainer> && __lastBackupContainer,int loopDepth) 
	{
		lastBackupContainer = std::move(__lastBackupContainer);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		backupAgentKey = uidPrefixKey(logRangesRange.begin, logUid);
															#line 242 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		backupLogValuesKey = destUidValue.withPrefix(backupLogKeys.begin);
															#line 243 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		backupLatestVersionsPath = destUidValue.withPrefix(backupLatestVersionsPrefix);
															#line 244 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		backupLatestVersionsKey = uidPrefixKey(backupLatestVersionsPath, logUid);
															#line 245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		displaySystemKeys = 0;
															#line 248 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		;
															#line 1990 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(BackupDescription const& desc,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Restore", self->randomID) .setMaxEventLength(12000) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("BackupTag", printable(self->backupTag)) .setMaxFieldLength(10000) .detail("Description", desc.toString());
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		targetVersion = -1;
															#line 169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 2003 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 170 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 2007 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			{
															#line 171 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 2011 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
			else
			{
															#line 172 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 2017 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				{
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 2021 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				}
				else
				{
															#line 174 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 2027 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
					{
															#line 175 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 2031 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_5 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& kvrange : self->backupRanges) { tr->clear(kvrange); } return Void(); });
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2040 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2045 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(BackupDescription && desc,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Restore", self->randomID) .setMaxEventLength(12000) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("BackupTag", printable(self->backupTag)) .setMaxFieldLength(10000) .detail("Description", desc.toString());
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		targetVersion = -1;
															#line 169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 2058 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 170 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 2062 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			{
															#line 171 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 2066 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
			else
			{
															#line 172 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 2072 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				{
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 2076 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				}
				else
				{
															#line 174 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 2082 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
					{
															#line 175 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 2086 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_5 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& kvrange : self->backupRanges) { tr->clear(kvrange); } return Void(); });
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2095 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont10(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Restore", self->randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("BackupTag", printable(self->backupTag)) .detail("TargetVersion", targetVersion);
															#line 195 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restoreIndex = 0;
															#line 198 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 2192 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			{
															#line 201 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 2196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
			else
			{
															#line 203 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 204 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				if (!normalKeyRange.empty())
															#line 2204 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				{
															#line 205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 2208 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				}
			}
		}
															#line 209 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 211 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for restoreIndex:%d tag:%s\n", restoreIndex, restoreTag.toString().c_str());
															#line 215 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_RestoreRanges", self->randomID) .detail("RestoreIndex", restoreIndex) .detail("RestoreTag", printable(restoreTag)) .detail("RestoreRanges", self->restoreRanges.size());
															#line 219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restore = Future<Version>();
															#line 220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restore = backupAgent.restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(restore);
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2228 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2233 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Restore", self->randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("BackupTag", printable(self->backupTag)) .detail("TargetVersion", targetVersion);
															#line 195 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restoreIndex = 0;
															#line 198 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 2250 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			{
															#line 201 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 2254 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
			else
			{
															#line 203 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 204 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				if (!normalKeyRange.empty())
															#line 2262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				{
															#line 205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 2266 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
				}
			}
		}
															#line 209 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 211 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for restoreIndex:%d tag:%s\n", restoreIndex, restoreTag.toString().c_str());
															#line 215 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_RestoreRanges", self->randomID) .detail("RestoreIndex", restoreIndex) .detail("RestoreTag", printable(restoreTag)) .detail("RestoreRanges", self->restoreRanges.size());
															#line 219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restore = Future<Version>();
															#line 220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		restore = backupAgent.restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(restore);
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2291 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont8(Void const& _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		ASSERT(!restore.isError());
															#line 2375 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8(Void && _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		ASSERT(!restore.isError());
															#line 2384 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 343 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (displaySystemKeys)
															#line 2468 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 344 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<Void> __when_expr_15 = TaskBucket::debugPrintRange(cx, normalKeys.end, StringRef());
															#line 344 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2474 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 344 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 2479 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont9loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1(int loopDepth) 
	{
															#line 249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 251 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_CheckLeftoverKeys", self->randomID).detail("BackupTag", printable(self->backupTag));
															#line 2502 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		try {
															#line 257 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent("RW_CheckLeftoverTasks", self->randomID).detail("BackupTag", printable(self->backupTag));
															#line 258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = backupAgent.getTaskCount(tr);
															#line 258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2510 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, int64_t >*>(static_cast<_startActor*>(this)));
															#line 2515 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 338 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent("RW_CheckException", self->randomID).error(e);
															#line 339 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<Void> __when_expr_14 = tr->onError(e);
															#line 339 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2554 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 339 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 2559 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2(int loopDepth) 
	{
															#line 259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		waitCycles = 0;
															#line 261 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		;
															#line 2576 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		taskCount = __taskCount;
															#line 2585 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1cont9loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9loopBody1cont3(int loopDepth) 
	{
															#line 280 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<RangeResult> __when_expr_10 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 280 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2666 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont9loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont9loopBody1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 280 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 2671 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont9loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 261 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!(taskCount > 0))
															#line 2687 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
			return a_body1cont9loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		waitCycles++;
															#line 264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_NonzeroTaskWait", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 268 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), self->randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(5.0);
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2701 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont9loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1cont2loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2706 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont9loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont9loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_9 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2732 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont9loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2737 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Void> __when_expr_9 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2750 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont9loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2755 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont9loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont9loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont9loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont9loopBody1cont4(RangeResult const& agentValues,int loopDepth) 
	{
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (agentValues.size() > 0)
															#line 2926 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 285 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			displaySystemKeys++;
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 289 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			for( auto& s : agentValues ) {
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				TraceEvent("RW_LeftOverKey", self->randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 2940 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 2947 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_11 = tr->get(backupLatestVersionsKey);
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2953 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont9loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont9loopBody1cont4when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2958 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont4(RangeResult && agentValues,int loopDepth) 
	{
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (agentValues.size() > 0)
															#line 2967 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 285 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			displaySystemKeys++;
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 289 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			for( auto& s : agentValues ) {
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				TraceEvent("RW_LeftOverKey", self->randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 2981 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 2988 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_11 = tr->get(backupLatestVersionsKey);
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2994 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont9loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont9loopBody1cont4when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2999 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont3when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont4(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont3when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont4(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont9loopBody1cont5(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 306 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (latestVersion.present())
															#line 3083 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 3087 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		else
		{
															#line 312 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup version key\n");
															#line 3093 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<RangeResult> __when_expr_12 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3099 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont9loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont9loopBody1cont5when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3104 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont5(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 306 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (latestVersion.present())
															#line 3113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 3117 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		else
		{
															#line 312 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup version key\n");
															#line 3123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		StrictFuture<RangeResult> __when_expr_12 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont9loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont9loopBody1cont5when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3134 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopBody1cont4when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont5(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont4when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont5(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont9loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont9loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont9loopBody1cont9(RangeResult const& versions,int loopDepth) 
	{
															#line 317 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 3218 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3224 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont9loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont9loopBody1cont9when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3229 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont9(RangeResult && versions,int loopDepth) 
	{
															#line 317 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 3243 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont9loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont9loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont9loopBody1cont9when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3254 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont5when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont9(versions, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont5when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont9(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont9loopBody1cont12(int loopDepth) 
	{
		return a_body1cont9break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont9loopBody1cont13(RangeResult const& logValues,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (logValues.size() > 0)
															#line 3349 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			displaySystemKeys++;
															#line 324 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 327 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 3357 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		else
		{
															#line 332 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup log keys\n");
															#line 3363 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont9loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont13(RangeResult && logValues,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (logValues.size() > 0)
															#line 3373 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			displaySystemKeys++;
															#line 324 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 327 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", self->randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 3381 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		else
		{
															#line 332 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			printf("No left over backup log keys\n");
															#line 3387 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont9loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont9when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont13(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont9when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont13(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont9loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont9loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont9loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont9loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont9loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont9loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont9loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 347 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		TraceEvent("RW_Complete", self->randomID).detail("BackupTag", printable(self->backupTag));
															#line 350 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if (self->agentRequest)
															#line 3561 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 351 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			RestoreWorkload::backupAgentRequests--;
															#line 3565 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
															#line 355 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
		if ((g_simulator->backupAgents == ISimulator::BackupAgentType::BackupToFile) && (!RestoreWorkload::backupAgentRequests))
															#line 3569 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		{
															#line 357 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
			g_simulator->backupAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 3573 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Database cx;
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	RestoreWorkload* self;
															#line 129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	FileBackupAgent backupAgent;
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Future<Void> cp;
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	DatabaseConfiguration config;
															#line 142 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Future<Void> status;
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	KeyBackedTag keyBackedTag;
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	UID logUid;
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Key destUidValue;
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Version targetVersion;
															#line 195 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	int restoreIndex;
															#line 219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Future<Version> restore;
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Key backupAgentKey;
															#line 242 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Key backupLogValuesKey;
															#line 243 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Key backupLatestVersionsPath;
															#line 244 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Key backupLatestVersionsKey;
															#line 245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	int displaySystemKeys;
															#line 249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	int64_t taskCount;
															#line 259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	int waitCycles;
															#line 3721 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, UidAndAbortedFlagT >, public ActorCallback< _startActor, 2, Key >, public ActorCallback< _startActor, 3, Reference<IBackupContainer> >, public ActorCallback< _startActor, 4, BackupDescription >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, int64_t >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, RangeResult >, public ActorCallback< _startActor, 11, Optional<Value> >, public ActorCallback< _startActor, 12, RangeResult >, public ActorCallback< _startActor, 13, RangeResult >, public ActorCallback< _startActor, 14, Void >, public ActorCallback< _startActor, 15, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3726 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1408789823980570880UL, 13825577696836815616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, UidAndAbortedFlagT >;
friend struct ActorCallback< _startActor, 2, Key >;
friend struct ActorCallback< _startActor, 3, Reference<IBackupContainer> >;
friend struct ActorCallback< _startActor, 4, BackupDescription >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, int64_t >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, RangeResult >;
friend struct ActorCallback< _startActor, 11, Optional<Value> >;
friend struct ActorCallback< _startActor, 12, RangeResult >;
friend struct ActorCallback< _startActor, 13, RangeResult >;
friend struct ActorCallback< _startActor, 14, Void >;
friend struct ActorCallback< _startActor, 15, Void >;
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	_startActor(Database const& cx,RestoreWorkload* const& self) 
															#line 3758 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, BackupDescription >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, int64_t >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, RangeResult >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Optional<Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, RangeResult >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, RangeResult >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, RestoreWorkload* const& self ) {
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3805 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Restore.actor.g.cpp.py_gen"
}

#line 365 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbserver/workloads/Restore.actor.cpp"
};

int RestoreWorkload::backupAgentRequests = 0;

WorkloadFactory<RestoreWorkload> RestoreWorkloadFactory;
