#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
/*
 * AsyncFileEncrypted.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/AsyncFileEncrypted.h"
#include "flow/StreamCipher.h"
#include "flow/UnitTest.h"
#include "flow/xxhash.h"
#include "flow/actorcompiler.h" // must be last include

class AsyncFileEncryptedImpl {
public:
	// Determine the initialization for the first block of a file based on a hash of
	// the filename.
	static auto getFirstBlockIV(const std::string& filename) {
		StreamCipher::IV iv;
		auto salt = basename(filename);
		auto pos = salt.find('.');
		salt = salt.substr(0, pos);
		auto hash = XXH3_128bits(salt.c_str(), salt.size());
		auto pHigh = reinterpret_cast<unsigned char*>(&hash.high64);
		auto pLow = reinterpret_cast<unsigned char*>(&hash.low64);
		std::copy(pHigh, pHigh + 8, &iv[0]);
		std::copy(pLow, pLow + 4, &iv[8]);
		uint32_t blockZero = 0;
		auto pBlock = reinterpret_cast<unsigned char*>(&blockZero);
		std::copy(pBlock, pBlock + 4, &iv[12]);
		return iv;
	}

	// Read a single block of size ENCRYPTION_BLOCK_SIZE bytes, and decrypt.
																#line 50 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
// This generated class is to be used only via readBlock()
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class ReadBlockActor>
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ReadBlockActorState {
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ReadBlockActorState(AsyncFileEncrypted* const& self,uint32_t const& block) 
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : self(self),
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   block(block),
															#line 49 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   arena(),
															#line 50 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   encrypted(new (arena) unsigned char[FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE])
															#line 69 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readBlock", reinterpret_cast<unsigned long>(this));

	}
	~ReadBlockActorState() 
	{
		fdb_probe_actor_destroy("readBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<int> __when_expr_0 = uncancellable(holdWhile(arena, self->file->read(encrypted, FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE, FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE * block)));
															#line 51 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<ReadBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadBlockActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadBlockActor, 0, int >*>(static_cast<ReadBlockActor*>(this)));
															#line 91 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadBlockActorState();
		static_cast<ReadBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& bytes,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StreamCipherKey const* cipherKey = StreamCipherKey::getGlobalCipherKey();
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		DecryptionStreamCipher decryptor(cipherKey, self->getIV(block));
															#line 57 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto decrypted = decryptor.decrypt(encrypted, bytes, arena);
															#line 58 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<ReadBlockActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>(decrypted, arena)); this->~ReadBlockActorState(); static_cast<ReadBlockActor*>(this)->destroy(); return 0; }
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<ReadBlockActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>(decrypted, arena));
		this->~ReadBlockActorState();
		static_cast<ReadBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && bytes,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StreamCipherKey const* cipherKey = StreamCipherKey::getGlobalCipherKey();
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		DecryptionStreamCipher decryptor(cipherKey, self->getIV(block));
															#line 57 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto decrypted = decryptor.decrypt(encrypted, bytes, arena);
															#line 58 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<ReadBlockActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>(decrypted, arena)); this->~ReadBlockActorState(); static_cast<ReadBlockActor*>(this)->destroy(); return 0; }
															#line 138 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<ReadBlockActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>(decrypted, arena));
		this->~ReadBlockActorState();
		static_cast<ReadBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& bytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(bytes, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && bytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(bytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadBlockActor*>(this)->actor_wait_state > 0) static_cast<ReadBlockActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBlockActor*>(this)->ActorCallback< ReadBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("readBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("readBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBlock", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	AsyncFileEncrypted* self;
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	uint32_t block;
															#line 49 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Arena arena;
															#line 50 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	unsigned char* encrypted;
															#line 229 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readBlock()
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ReadBlockActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadBlockActor, 0, int >, public FastAllocated<ReadBlockActor>, public ReadBlockActorState<ReadBlockActor> {
															#line 234 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadBlockActor>::operator new;
	using FastAllocated<ReadBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11131273295657609472UL, 93624151763661824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadBlockActor, 0, int >;
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ReadBlockActor(AsyncFileEncrypted* const& self,uint32_t const& block) 
															#line 251 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<Standalone<StringRef>>(),
		   ReadBlockActorState<ReadBlockActor>(self, block),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8789183085673993728UL, 4633063668185402624UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readBlock( AsyncFileEncrypted* const& self, uint32_t const& block ) {
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadBlockActor(self, block));
															#line 283 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}

#line 60 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"

																#line 288 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
// This generated class is to be used only via read()
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class ReadActor>
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ReadActorState {
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ReadActorState(Reference<AsyncFileEncrypted> const& self,void* const& data,int const& length,int64_t const& offset) 
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : self(self),
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   data(data),
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   length(length),
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   offset(offset)
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActorState() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (self->fileSize == -1)
															#line 322 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			{
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
				StrictFuture<int64_t> __when_expr_0 = self->file->size();
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
				if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 328 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 0, int64_t >*>(static_cast<ReadActor*>(this)));
															#line 333 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (offset >= self->fileSize)
															#line 361 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
															#line 67 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (!static_cast<ReadActor*>(this)->SAV<int>::futures) { (void)(0); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 365 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			new (&static_cast<ReadActor*>(this)->SAV< int >::value()) int(0);
			this->~ReadActorState();
			static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 69 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (offset + length > self->fileSize)
															#line 373 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
															#line 70 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			length = self->fileSize - offset;
															#line 377 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		}
															#line 72 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		firstBlock = offset / FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE;
															#line 73 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		lastBlock = (offset + length - 1) / FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE;
															#line 74 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		block = uint32_t();
															#line 75 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		output = reinterpret_cast<unsigned char*>(data);
															#line 76 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead = 0;
															#line 77 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT(self->mode == AsyncFileEncrypted::Mode::READ_ONLY);
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		block = firstBlock;
															#line 393 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 64 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->fileSize = fileSize;
															#line 402 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		fileSize = __fileSize;
															#line 411 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<int>::futures) { (void)(bytesRead); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 490 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<ReadActor*>(this)->SAV< int >::value()) int(std::move(bytesRead)); // state_var_RVO
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!(block <= lastBlock))
															#line 509 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 79 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		plaintext = Standalone<StringRef>();
															#line 81 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto cachedBlock = self->readBuffers.get(block);
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (cachedBlock.present())
															#line 519 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
															#line 83 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			plaintext = cachedBlock.get();
															#line 523 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 85 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(plaintext, readBlock(self.getPtr(), block));
															#line 85 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 532 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadActor*>(this)->actor_wait_state = 2;
															#line 85 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 1, Void >*>(static_cast<ReadActor*>(this)));
															#line 537 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto start = (block == firstBlock) ? plaintext.begin() + (offset % FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE) : plaintext.begin();
															#line 90 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto end = (block == lastBlock) ? plaintext.begin() + ((offset + length) % FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE) : plaintext.end();
															#line 93 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if ((offset + length) % FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE == 0)
															#line 564 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
															#line 94 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			end = plaintext.end();
															#line 568 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		}
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		end = std::min(end, plaintext.end());
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (start == end || start >= plaintext.end())
															#line 574 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 104 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		std::copy(start, end, output);
															#line 105 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		output += (end - start);
															#line 106 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead += (end - start);
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		++block;
															#line 586 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->readBuffers.insert(block, plaintext);
															#line 595 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->readBuffers.insert(block, plaintext);
															#line 604 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Reference<AsyncFileEncrypted> self;
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	void* data;
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int length;
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int64_t offset;
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int64_t fileSize;
															#line 72 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	uint32_t firstBlock;
															#line 73 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	uint32_t lastBlock;
															#line 74 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	uint32_t block;
															#line 75 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	unsigned char* output;
															#line 76 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int bytesRead;
															#line 79 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Standalone<StringRef> plaintext;
															#line 706 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via read()
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ReadActor final : public Actor<int>, public ActorCallback< ReadActor, 0, int64_t >, public ActorCallback< ReadActor, 1, Void >, public FastAllocated<ReadActor>, public ReadActorState<ReadActor> {
															#line 711 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadActor>::operator new;
	using FastAllocated<ReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2197418470480227328UL, 10813865094957080320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor, 0, int64_t >;
friend struct ActorCallback< ReadActor, 1, Void >;
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ReadActor(Reference<AsyncFileEncrypted> const& self,void* const& data,int const& length,int64_t const& offset) 
															#line 729 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   ReadActorState<ReadActor>(self, data, length, offset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3377648328873480704UL, 6210503387287458048UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
[[nodiscard]] static Future<int> read( Reference<AsyncFileEncrypted> const& self, void* const& data, int const& length, int64_t const& offset ) {
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<int>(new ReadActor(self, data, length, offset));
															#line 762 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}

#line 110 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"

																#line 767 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
// This generated class is to be used only via write()
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class WriteActor>
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class WriteActorState {
															#line 773 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	WriteActorState(Reference<AsyncFileEncrypted> const& self,void const* const& data,int const& length,int64_t const& offset) 
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : self(self),
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   data(data),
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   length(length),
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   offset(offset)
															#line 786 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("write", reinterpret_cast<unsigned long>(this));

	}
	~WriteActorState() 
	{
		fdb_probe_actor_destroy("write", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			ASSERT(self->mode == AsyncFileEncrypted::Mode::APPEND_ONLY);
															#line 114 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			ASSERT_EQ(offset, self->currentBlock * FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE + self->offsetInBlock);
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			input = reinterpret_cast<unsigned char const*>(data);
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			;
															#line 807 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteActorState();
		static_cast<WriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 134 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<WriteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteActorState(); static_cast<WriteActor*>(this)->destroy(); return 0; }
															#line 830 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<WriteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteActorState();
		static_cast<WriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!(length > 0))
															#line 849 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 117 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		const auto chunkSize = std::min(length, FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE - self->offsetInBlock);
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		Arena arena;
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		auto encrypted = self->encryptor->encrypt(input, chunkSize, arena);
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		std::copy(encrypted.begin(), encrypted.end(), &self->writeBuffer[self->offsetInBlock]);
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		offset += encrypted.size();
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->offsetInBlock += chunkSize;
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		length -= chunkSize;
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		input += chunkSize;
															#line 125 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (self->offsetInBlock == FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE)
															#line 871 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->writeLastBlockToFile();
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<WriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 877 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteActor*>(this)->actor_wait_state = 1;
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteActor, 0, Void >*>(static_cast<WriteActor*>(this)));
															#line 882 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->offsetInBlock = 0;
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT_LT(self->currentBlock, std::numeric_limits<uint32_t>::max());
															#line 129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		++self->currentBlock;
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->encryptor = std::make_unique<EncryptionStreamCipher>(StreamCipherKey::getGlobalCipherKey(), self->getIV(self->currentBlock));
															#line 921 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->offsetInBlock = 0;
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT_LT(self->currentBlock, std::numeric_limits<uint32_t>::max());
															#line 129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		++self->currentBlock;
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		self->encryptor = std::make_unique<EncryptionStreamCipher>(StreamCipherKey::getGlobalCipherKey(), self->getIV(self->currentBlock));
															#line 936 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteActor*>(this)->actor_wait_state > 0) static_cast<WriteActor*>(this)->actor_wait_state = 0;
		static_cast<WriteActor*>(this)->ActorCallback< WriteActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Reference<AsyncFileEncrypted> self;
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	void const* data;
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int length;
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int64_t offset;
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	unsigned char const* input;
															#line 1026 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via write()
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class WriteActor final : public Actor<Void>, public ActorCallback< WriteActor, 0, Void >, public FastAllocated<WriteActor>, public WriteActorState<WriteActor> {
															#line 1031 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteActor>::operator new;
	using FastAllocated<WriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15491176057416427776UL, 5074729713495338752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteActor, 0, Void >;
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	WriteActor(Reference<AsyncFileEncrypted> const& self,void const* const& data,int const& length,int64_t const& offset) 
															#line 1048 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteActorState<WriteActor>(self, data, length, offset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("write", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12930151081403648768UL, 3575641775399886848UL);
		ActorExecutionContextHelper __helper(static_cast<WriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("write");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("write", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
[[nodiscard]] static Future<Void> write( Reference<AsyncFileEncrypted> const& self, void const* const& data, int const& length, int64_t const& offset ) {
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<Void>(new WriteActor(self, data, length, offset));
															#line 1080 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}

#line 136 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"

																#line 1085 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
// This generated class is to be used only via sync()
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class SyncActor>
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class SyncActorState {
															#line 1091 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	SyncActorState(Reference<AsyncFileEncrypted> const& self) 
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : self(self)
															#line 1098 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sync", reinterpret_cast<unsigned long>(this));

	}
	~SyncActorState() 
	{
		fdb_probe_actor_destroy("sync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			ASSERT(self->mode == AsyncFileEncrypted::Mode::APPEND_ONLY);
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->writeLastBlockToFile();
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<SyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1117 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SyncActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SyncActor, 0, Void >*>(static_cast<SyncActor*>(this)));
															#line 1122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SyncActorState();
		static_cast<SyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->sync();
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (static_cast<SyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1147 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SyncActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SyncActor, 1, Void >*>(static_cast<SyncActor*>(this)));
															#line 1152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->sync();
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (static_cast<SyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1163 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SyncActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SyncActor, 1, Void >*>(static_cast<SyncActor*>(this)));
															#line 1168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SyncActor*>(this)->actor_wait_state > 0) static_cast<SyncActor*>(this)->actor_wait_state = 0;
		static_cast<SyncActor*>(this)->ActorCallback< SyncActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SyncActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SyncActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SyncActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<SyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SyncActorState(); static_cast<SyncActor*>(this)->destroy(); return 0; }
															#line 1252 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<SyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SyncActorState();
		static_cast<SyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<SyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SyncActorState(); static_cast<SyncActor*>(this)->destroy(); return 0; }
															#line 1264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<SyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SyncActorState();
		static_cast<SyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SyncActor*>(this)->actor_wait_state > 0) static_cast<SyncActor*>(this)->actor_wait_state = 0;
		static_cast<SyncActor*>(this)->ActorCallback< SyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Reference<AsyncFileEncrypted> self;
															#line 1349 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sync()
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class SyncActor final : public Actor<Void>, public ActorCallback< SyncActor, 0, Void >, public ActorCallback< SyncActor, 1, Void >, public FastAllocated<SyncActor>, public SyncActorState<SyncActor> {
															#line 1354 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<SyncActor>::operator new;
	using FastAllocated<SyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17262581415561628672UL, 14874923834948276480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SyncActor, 0, Void >;
friend struct ActorCallback< SyncActor, 1, Void >;
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	SyncActor(Reference<AsyncFileEncrypted> const& self) 
															#line 1372 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SyncActorState<SyncActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6528364731675487488UL, 2149237228916432896UL);
		ActorExecutionContextHelper __helper(static_cast<SyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SyncActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SyncActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
[[nodiscard]] static Future<Void> sync( Reference<AsyncFileEncrypted> const& self ) {
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<Void>(new SyncActor(self));
															#line 1405 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}

#line 143 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"

																#line 1410 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
// This generated class is to be used only via zeroRange()
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class ZeroRangeActor>
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ZeroRangeActorState {
															#line 1416 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ZeroRangeActorState(AsyncFileEncrypted* const& self,int64_t const& offset,int64_t const& length) 
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : self(self),
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   offset(offset),
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   length(length)
															#line 1427 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("zeroRange", reinterpret_cast<unsigned long>(this));

	}
	~ZeroRangeActorState() 
	{
		fdb_probe_actor_destroy("zeroRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			ASSERT(self->mode == AsyncFileEncrypted::Mode::APPEND_ONLY);
															#line 147 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			Arena arena;
															#line 148 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			auto zeroes = new (arena) unsigned char[length];
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			memset(zeroes, 0, length);
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<Void> __when_expr_0 = uncancellable(holdWhile(arena, self->write(zeroes, length, offset)));
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<ZeroRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1452 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ZeroRangeActor*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeActor, 0, Void >*>(static_cast<ZeroRangeActor*>(this)));
															#line 1457 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZeroRangeActorState();
		static_cast<ZeroRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<ZeroRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroRangeActorState(); static_cast<ZeroRangeActor*>(this)->destroy(); return 0; }
															#line 1480 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<ZeroRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroRangeActorState();
		static_cast<ZeroRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<ZeroRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroRangeActorState(); static_cast<ZeroRangeActor*>(this)->destroy(); return 0; }
															#line 1492 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<ZeroRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroRangeActorState();
		static_cast<ZeroRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZeroRangeActor*>(this)->actor_wait_state > 0) static_cast<ZeroRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroRangeActor*>(this)->ActorCallback< ZeroRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZeroRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZeroRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	AsyncFileEncrypted* self;
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int64_t offset;
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int64_t length;
															#line 1581 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via zeroRange()
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class ZeroRangeActor final : public Actor<Void>, public ActorCallback< ZeroRangeActor, 0, Void >, public FastAllocated<ZeroRangeActor>, public ZeroRangeActorState<ZeroRangeActor> {
															#line 1586 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<ZeroRangeActor>::operator new;
	using FastAllocated<ZeroRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4564025923099567616UL, 13934647088155734784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZeroRangeActor, 0, Void >;
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	ZeroRangeActor(AsyncFileEncrypted* const& self,int64_t const& offset,int64_t const& length) 
															#line 1603 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ZeroRangeActorState<ZeroRangeActor>(self, offset, length),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zeroRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13258503316997770240UL, 3770442812400012544UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zeroRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zeroRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZeroRangeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
[[nodiscard]] static Future<Void> zeroRange( AsyncFileEncrypted* const& self, int64_t const& offset, int64_t const& length ) {
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<Void>(new ZeroRangeActor(self, offset, length));
															#line 1635 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}

#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
};

AsyncFileEncrypted::AsyncFileEncrypted(Reference<IAsyncFile> file, Mode mode)
  : file(file), mode(mode), readBuffers(FLOW_KNOBS->MAX_DECRYPTED_BLOCKS), currentBlock(0) {
	firstBlockIV = AsyncFileEncryptedImpl::getFirstBlockIV(file->getFilename());
	if (mode == Mode::APPEND_ONLY) {
		encryptor =
		    std::make_unique<EncryptionStreamCipher>(StreamCipherKey::getGlobalCipherKey(), getIV(currentBlock));
		writeBuffer = std::vector<unsigned char>(FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE, 0);
	}
}

void AsyncFileEncrypted::addref() {
	ReferenceCounted<AsyncFileEncrypted>::addref();
}

void AsyncFileEncrypted::delref() {
	ReferenceCounted<AsyncFileEncrypted>::delref();
}

Future<int> AsyncFileEncrypted::read(void* data, int length, int64_t offset) {
	return AsyncFileEncryptedImpl::read(Reference<AsyncFileEncrypted>::addRef(this), data, length, offset);
}

Future<Void> AsyncFileEncrypted::write(void const* data, int length, int64_t offset) {
	return AsyncFileEncryptedImpl::write(Reference<AsyncFileEncrypted>::addRef(this), data, length, offset);
}

Future<Void> AsyncFileEncrypted::zeroRange(int64_t offset, int64_t length) {
	return AsyncFileEncryptedImpl::zeroRange(this, offset, length);
}

Future<Void> AsyncFileEncrypted::truncate(int64_t size) {
	ASSERT(mode == Mode::APPEND_ONLY);
	return file->truncate(size);
}

Future<Void> AsyncFileEncrypted::sync() {
	ASSERT(mode == Mode::APPEND_ONLY);
	return AsyncFileEncryptedImpl::sync(Reference<AsyncFileEncrypted>::addRef(this));
}

Future<Void> AsyncFileEncrypted::flush() {
	ASSERT(mode == Mode::APPEND_ONLY);
	return Void();
}

Future<int64_t> AsyncFileEncrypted::size() const {
	ASSERT(mode == Mode::READ_ONLY);
	return file->size();
}

std::string AsyncFileEncrypted::getFilename() const {
	return file->getFilename();
}

Future<Void> AsyncFileEncrypted::readZeroCopy(void** data, int* length, int64_t offset) {
	throw io_error();
	return Void();
}

void AsyncFileEncrypted::releaseZeroCopy(void* data, int length, int64_t offset) {
	throw io_error();
}

int64_t AsyncFileEncrypted::debugFD() const {
	return file->debugFD();
}

StreamCipher::IV AsyncFileEncrypted::getIV(uint32_t block) const {
	auto iv = firstBlockIV;

	auto pBlock = reinterpret_cast<unsigned char*>(&block);
	std::copy(pBlock, pBlock + 4, &iv[12]);

	return iv;
}

Future<Void> AsyncFileEncrypted::writeLastBlockToFile() {
	// The source buffer for the write is owned by *this so this must be kept alive by reference count until the write
	// is finished.
	return uncancellable(
	    holdWhile(Reference<AsyncFileEncrypted>::addRef(this),
	              file->write(&writeBuffer[0], offsetInBlock, currentBlock * FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE)));
}

size_t AsyncFileEncrypted::RandomCache::evict() {
	ASSERT_EQ(vec.size(), maxSize);
	auto index = deterministicRandom()->randomInt(0, maxSize);
	hashMap.erase(vec[index]);
	return index;
}

AsyncFileEncrypted::RandomCache::RandomCache(size_t maxSize) : maxSize(maxSize) {
	vec.reserve(maxSize);
}

void AsyncFileEncrypted::RandomCache::insert(uint32_t block, const Standalone<StringRef>& value) {
	auto [_, found] = hashMap.insert({ block, value });
	if (found) {
		return;
	} else if (vec.size() < maxSize) {
		vec.push_back(block);
	} else {
		auto index = evict();
		vec[index] = block;
	}
}

Optional<Standalone<StringRef>> AsyncFileEncrypted::RandomCache::get(uint32_t block) const {
	auto it = hashMap.find(block);
	if (it == hashMap.end()) {
		return {};
	} else {
		return it->second;
	}
}

// This test writes random data into an encrypted file in random increments,
// then reads this data back from the file in random increments, then confirms that
// the bytes read match the bytes written.
															#line 1760 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase274()
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
template <class FlowTestCase274Actor>
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class FlowTestCase274ActorState {
															#line 1767 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	FlowTestCase274ActorState(UnitTestParameters const& params) 
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		 : params(params),
															#line 275 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   bytes(FLOW_KNOBS->ENCRYPTION_BLOCK_SIZE * deterministicRandom()->randomInt(0, 1000)),
															#line 276 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		   writeBuffer(bytes, 0)
															#line 1778 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase274", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase274ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase274", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			deterministicRandom()->randomBytes(&writeBuffer.front(), bytes);
															#line 278 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			readBuffer = std::vector<unsigned char>(bytes, 0);
															#line 279 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 280 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StreamCipherKey::initializeGlobalRandomTestKey();
															#line 281 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			int flags = IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_ENCRYPTED | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO;
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open(joinPath(params.getDataDir(), "test-encrypted-file"), flags, 0600);
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1805 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 1;
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase274Actor*>(this)));
															#line 1810 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase274ActorState();
		static_cast<FlowTestCase274Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesWritten = 0;
															#line 287 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		chunkSize = int();
															#line 288 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		;
															#line 1837 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		file = __file;
															#line 1846 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase274Actor*>(this)->ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->sync();
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1927 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 3;
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase274Actor, 2, Void >*>(static_cast<FlowTestCase274Actor*>(this)));
															#line 1932 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 288 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!(bytesWritten < bytes))
															#line 1948 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 289 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		chunkSize = std::min(deterministicRandom()->randomInt(0, 100), bytes - bytesWritten);
															#line 290 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(&writeBuffer[bytesWritten], chunkSize, bytesWritten);
															#line 290 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1958 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 2;
															#line 290 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase274Actor, 1, Void >*>(static_cast<FlowTestCase274Actor*>(this)));
															#line 1963 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesWritten += chunkSize;
															#line 1985 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesWritten += chunkSize;
															#line 1994 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase274Actor*>(this)->ActorCallback< FlowTestCase274Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase274Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead = 0;
															#line 295 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		;
															#line 2080 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead = 0;
															#line 295 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		;
															#line 2091 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase274Actor*>(this)->ActorCallback< FlowTestCase274Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase274Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 301 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT(writeBuffer == readBuffer);
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!static_cast<FlowTestCase274Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase274ActorState(); static_cast<FlowTestCase274Actor*>(this)->destroy(); return 0; }
															#line 2177 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase274Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase274ActorState();
		static_cast<FlowTestCase274Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 295 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (!(bytesRead < bytes))
															#line 2196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 296 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		chunkSize = std::min(deterministicRandom()->randomInt(0, 100), bytes - bytesRead);
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		StrictFuture<int> __when_expr_3 = file->read(&readBuffer[bytesRead], chunkSize, bytesRead);
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2206 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 4;
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase274Actor, 3, int >*>(static_cast<FlowTestCase274Actor*>(this)));
															#line 2211 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int const& bytesReadInChunk,int loopDepth) 
	{
															#line 298 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT_EQ(bytesReadInChunk, chunkSize);
															#line 299 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead += bytesReadInChunk;
															#line 2235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int && bytesReadInChunk,int loopDepth) 
	{
															#line 298 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		ASSERT_EQ(bytesReadInChunk, chunkSize);
															#line 299 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
		bytesRead += bytesReadInChunk;
															#line 2246 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int const& bytesReadInChunk,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(bytesReadInChunk, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int && bytesReadInChunk,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(bytesReadInChunk), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase274Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase274Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase274Actor*>(this)->ActorCallback< FlowTestCase274Actor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase274Actor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase274Actor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	UnitTestParameters params;
															#line 275 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	const int bytes;
															#line 276 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	std::vector<unsigned char> writeBuffer;
															#line 278 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	std::vector<unsigned char> readBuffer;
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	Reference<IAsyncFile> file;
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int bytesWritten;
															#line 287 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int chunkSize;
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	int bytesRead;
															#line 2342 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase274()
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
class FlowTestCase274Actor final : public Actor<Void>, public ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase274Actor, 1, Void >, public ActorCallback< FlowTestCase274Actor, 2, Void >, public ActorCallback< FlowTestCase274Actor, 3, int >, public FastAllocated<FlowTestCase274Actor>, public FlowTestCase274ActorState<FlowTestCase274Actor> {
															#line 2347 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase274Actor>::operator new;
	using FastAllocated<FlowTestCase274Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14079281605156608256UL, 3881839704311606272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase274Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase274Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase274Actor, 3, int >;
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	FlowTestCase274Actor(UnitTestParameters const& params) 
															#line 2367 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase274ActorState<FlowTestCase274Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase274", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6685172694965512448UL, 12203350448755824384UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase274Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase274");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase274", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase274Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase274Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase274Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase274Actor, 3, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
static Future<Void> flowTestCase274( UnitTestParameters const& params ) {
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
	return Future<Void>(new FlowTestCase274Actor(params));
															#line 2403 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbrpc/AsyncFileEncrypted.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase274, "fdbrpc/AsyncFileEncrypted")

#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbrpc/AsyncFileEncrypted.actor.cpp"
