#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
/*
 * ThrottleCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"
#include "fdbclient/TagThrottle.actor.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/CommitTransaction.h"

#include "flow/Arena.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

static constexpr int defaultThrottleListLimit = 100;

															#line 40 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via throttleCommandActor()
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
template <class ThrottleCommandActorActor>
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
class ThrottleCommandActorActorState {
															#line 46 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
public:
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	ThrottleCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		 : db(db),
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		   tokens(tokens)
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("throttleCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ThrottleCommandActorActorState() 
	{
		fdb_probe_actor_destroy("throttleCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 70 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
			{
															#line 41 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 42 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 76 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ThrottleCommandActorActorState();
				static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 43 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				if (tokencmp(tokens[1], "list"))
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				{
															#line 44 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (tokens.size() > 4)
															#line 90 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 45 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						fmt::print("Usage: throttle list [throttled|recommended|all] [LIMIT]\n\n");
															#line 46 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						fmt::print("Lists tags that are currently throttled.\n");
															#line 47 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						fmt::print("The default LIMIT is {} tags.\n", defaultThrottleListLimit);
															#line 48 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ThrottleCommandActorActorState();
						static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 51 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					reportThrottled = true;
															#line 52 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					reportRecommended = false;
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (tokens.size() >= 3)
															#line 112 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 54 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokencmp(tokens[2], "recommended"))
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							reportThrottled = false;
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							reportRecommended = true;
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						}
						else
						{
															#line 57 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (tokencmp(tokens[2], "all"))
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 58 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								reportThrottled = true;
															#line 59 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								reportRecommended = true;
															#line 134 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							}
							else
							{
															#line 60 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!tokencmp(tokens[2], "throttled"))
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								{
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									printf("ERROR: failed to parse `%s'.\n", printable(tokens[2]).c_str());
															#line 62 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 146 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
									this->~ThrottleCommandActorActorState();
									static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
							}
						}
					}
															#line 66 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					throttleListLimit = defaultThrottleListLimit;
															#line 67 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (tokens.size() >= 4)
															#line 159 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 68 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						char* end;
															#line 69 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						throttleListLimit = std::strtol((const char*)tokens[3].begin(), &end, 10);
															#line 70 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if ((tokens.size() > 4 && !std::isspace(*end)) || (tokens.size() == 4 && *end != '\0'))
															#line 167 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 71 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							fprintf(stderr, "ERROR: failed to parse limit `%s'.\n", printable(tokens[3]).c_str());
															#line 72 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~ThrottleCommandActorActorState();
							static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
															#line 76 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					tags = std::vector<TagThrottleInfo>();
															#line 77 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (reportThrottled && reportRecommended)
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						StrictFuture<Void> __when_expr_0 = store(tags, ThrottleApi::getThrottledTags(db, throttleListLimit, ContainsRecommended::True));
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 190 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 1;
															#line 78 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 0, Void >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 195 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 79 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (reportThrottled)
															#line 202 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 80 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							StrictFuture<Void> __when_expr_1 = store(tags, ThrottleApi::getThrottledTags(db, throttleListLimit));
															#line 80 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 208 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 2;
															#line 80 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 1, Void >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 213 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 81 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (reportRecommended)
															#line 220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								StrictFuture<Void> __when_expr_2 = store(tags, ThrottleApi::getRecommendedTags(db, throttleListLimit));
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 226 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
								static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 3;
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 2, Void >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 231 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1cont17(loopDepth);
							}
						}
					}
				}
				else
				{
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (tokencmp(tokens[1], "on"))
															#line 245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokens.size() < 4 || !tokencmp(tokens[2], "tag") || tokens.size() > 7)
															#line 249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 125 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("Usage: throttle on tag <TAG> [RATE] [DURATION] [PRIORITY]\n");
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("\n");
															#line 127 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("Enables throttling for transactions with the specified tag.\n");
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("An optional transactions per second rate can be specified (default 0).\n");
															#line 129 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("An optional duration can be specified, which must include a time suffix (s, m, h, " "d) (default 1h).\n");
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							printf("An optional priority can be specified. Choices are `default', `immediate', and " "`batch' (default `default').\n");
															#line 133 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 265 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~ThrottleCommandActorActorState();
							static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 136 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						double tpsRate = 0.0;
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						uint64_t duration = 3600;
															#line 138 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						TransactionPriority priority = TransactionPriority::DEFAULT;
															#line 140 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokens.size() >= 5)
															#line 279 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 141 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							char* end;
															#line 142 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							tpsRate = std::strtod((const char*)tokens[4].begin(), &end);
															#line 143 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if ((tokens.size() > 5 && !std::isspace(*end)) || (tokens.size() == 5 && *end != '\0'))
															#line 287 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								fprintf(stderr, "ERROR: failed to parse rate `%s'.\n", printable(tokens[4]).c_str());
															#line 145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ThrottleCommandActorActorState();
								static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 147 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (tpsRate < 0)
															#line 301 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 148 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								fprintf(stderr, "ERROR: rate cannot be negative `%f'\n", tpsRate);
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ThrottleCommandActorActorState();
								static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokens.size() == 6)
															#line 316 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							Optional<uint64_t> parsedDuration = parseDuration(tokens[5].toString());
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (!parsedDuration.present())
															#line 322 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 155 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								fprintf(stderr, "ERROR: failed to parse duration `%s'.\n", printable(tokens[5]).c_str());
															#line 156 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 328 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ThrottleCommandActorActorState();
								static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 158 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							duration = parsedDuration.get();
															#line 160 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (duration == 0)
															#line 338 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 161 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								fprintf(stderr, "ERROR: throttle duration cannot be 0\n");
															#line 162 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ThrottleCommandActorActorState();
								static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
															#line 165 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokens.size() == 7)
															#line 353 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 166 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (tokens[6] == "default"_sr)
															#line 357 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 167 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								priority = TransactionPriority::DEFAULT;
															#line 361 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							}
							else
							{
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (tokens[6] == "immediate"_sr)
															#line 367 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								{
															#line 169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									priority = TransactionPriority::IMMEDIATE;
															#line 371 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								}
								else
								{
															#line 170 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (tokens[6] == "batch"_sr)
															#line 377 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									{
															#line 171 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										priority = TransactionPriority::BATCH;
															#line 381 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									}
									else
									{
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										fprintf(stderr, "ERROR: unrecognized priority `%s'. Must be one of `default',\n  `immediate', " "or `batch'.\n", tokens[6].toString().c_str());
															#line 177 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 389 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
										new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~ThrottleCommandActorActorState();
										static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
								}
							}
						}
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						TagSet tagSet;
															#line 182 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						tagSet.addTag(tokens[3]);
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						StrictFuture<Void> __when_expr_3 = ThrottleApi::throttleTags(db, tagSet, tpsRate, duration, TagThrottleType::MANUAL, priority);
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 406 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
						static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 4;
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 3, Void >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 411 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 186 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (tokencmp(tokens[1], "off"))
															#line 418 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 187 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							int nextIndex = 2;
															#line 188 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							tagSet = TagSet();
															#line 189 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							bool throttleTypeSpecified = false;
															#line 190 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							bool is_error = false;
															#line 191 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							Optional<TagThrottleType> throttleType = TagThrottleType::MANUAL;
															#line 192 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							Optional<TransactionPriority> priority;
															#line 194 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (tokens.size() == 2)
															#line 434 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 195 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								is_error = true;
															#line 438 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							}
															#line 198 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							for(;nextIndex < tokens.size() && !is_error;) {
															#line 199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (tokencmp(tokens[nextIndex], "all"))
															#line 444 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								{
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (throttleTypeSpecified)
															#line 448 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									{
															#line 201 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										is_error = true;
															#line 452 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
										continue;
									}
															#line 204 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									throttleTypeSpecified = true;
															#line 205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									throttleType = Optional<TagThrottleType>();
															#line 206 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									++nextIndex;
															#line 461 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								}
								else
								{
															#line 207 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (tokencmp(tokens[nextIndex], "auto"))
															#line 467 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									{
															#line 208 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										if (throttleTypeSpecified)
															#line 471 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
										{
															#line 209 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											is_error = true;
															#line 475 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
											continue;
										}
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										throttleTypeSpecified = true;
															#line 213 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										throttleType = TagThrottleType::AUTO;
															#line 214 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										++nextIndex;
															#line 484 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									}
									else
									{
															#line 215 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
										if (tokencmp(tokens[nextIndex], "manual"))
															#line 490 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
										{
															#line 216 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											if (throttleTypeSpecified)
															#line 494 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
											{
															#line 217 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
												is_error = true;
															#line 498 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
												continue;
											}
															#line 220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											throttleTypeSpecified = true;
															#line 221 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											throttleType = TagThrottleType::MANUAL;
															#line 222 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											++nextIndex;
															#line 507 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
										}
										else
										{
															#line 223 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
											if (tokencmp(tokens[nextIndex], "default"))
															#line 513 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
											{
															#line 224 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
												if (priority.present())
															#line 517 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
												{
															#line 225 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
													is_error = true;
															#line 521 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
													continue;
												}
															#line 228 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
												priority = TransactionPriority::DEFAULT;
															#line 229 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
												++nextIndex;
															#line 528 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
											}
											else
											{
															#line 230 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
												if (tokencmp(tokens[nextIndex], "immediate"))
															#line 534 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
												{
															#line 231 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
													if (priority.present())
															#line 538 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
													{
															#line 232 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
														is_error = true;
															#line 542 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
														continue;
													}
															#line 235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
													priority = TransactionPriority::IMMEDIATE;
															#line 236 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
													++nextIndex;
															#line 549 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
												}
												else
												{
															#line 237 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
													if (tokencmp(tokens[nextIndex], "batch"))
															#line 555 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
													{
															#line 238 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
														if (priority.present())
															#line 559 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
														{
															#line 239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															is_error = true;
															#line 563 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
															continue;
														}
															#line 242 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
														priority = TransactionPriority::BATCH;
															#line 243 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
														++nextIndex;
															#line 570 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
													}
													else
													{
															#line 244 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
														if (tokencmp(tokens[nextIndex], "tag"))
															#line 576 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
														{
															#line 245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															if (tagSet.size() > 0 || nextIndex == tokens.size() - 1)
															#line 580 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
															{
															#line 246 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
																is_error = true;
															#line 584 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
																continue;
															}
															#line 249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															tagSet.addTag(tokens[nextIndex + 1]);
															#line 250 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															nextIndex += 2;
															#line 591 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
														}
														else
														{
															#line 252 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
															is_error = true;
															#line 597 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
														}
													}
												}
											}
										}
									}
								}
							}
															#line 256 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (!is_error)
															#line 608 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 257 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								throttleTypeString = !throttleType.present() ? "" : (throttleType.get() == TagThrottleType::AUTO ? "auto-" : "manually ");
															#line 259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								priorityString = priority.present() ? format(" at %s priority", transactionPriorityToString(priority.get(), false)) : "";
															#line 262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (tagSet.size() > 0)
															#line 616 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								{
															#line 263 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									StrictFuture<bool> __when_expr_4 = ThrottleApi::unthrottleTags(db, tagSet, throttleType, priority);
															#line 263 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 622 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
									static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 5;
															#line 263 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 4, bool >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 627 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
															#line 273 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									StrictFuture<bool> __when_expr_5 = ThrottleApi::unthrottleAll(db, throttleType, priority);
															#line 273 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 636 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when6(__when_expr_5.get(), loopDepth); };
									static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 6;
															#line 273 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 5, bool >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 641 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
							}
							else
							{
															#line 281 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("Usage: throttle off [all|auto|manual] [tag <TAG>] [PRIORITY]\n");
															#line 282 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("\n");
															#line 283 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("Disables throttling for throttles matching the specified filters. At least one " "filter must be used.\n\n");
															#line 285 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("An optional qualifier `all', `auto', or `manual' can be used to specify the type " "of throttle\n");
															#line 287 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("affected. `all' targets all throttles, `auto' targets those created by the " "cluster, and\n");
															#line 289 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("`manual' targets those created manually (default `manual').\n\n");
															#line 290 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("The `tag' filter can be use to turn off only a specific tag.\n\n");
															#line 291 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("The priority filter can be used to turn off only throttles at specific priorities. " "Choices are\n");
															#line 293 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printf("`default', `immediate', or `batch'. By default, all priorities are targeted.\n");
															#line 665 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								loopDepth = a_body1cont47(loopDepth);
							}
						}
						else
						{
															#line 295 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							if (tokencmp(tokens[1], "enable") || tokencmp(tokens[1], "disable"))
															#line 673 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
							{
															#line 296 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (tokens.size() != 3 || !tokencmp(tokens[2], "auto"))
															#line 677 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								{
															#line 297 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									printf("Usage: throttle <enable|disable> auto\n");
															#line 298 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									printf("\n");
															#line 299 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									printf("Enables or disable automatic tag throttling.\n");
															#line 300 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
									if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 687 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
									new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
									this->~ThrottleCommandActorActorState();
									static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								autoTagThrottlingEnabled = tokencmp(tokens[1], "enable");
															#line 303 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								StrictFuture<Void> __when_expr_6 = ThrottleApi::enableAuto(db, autoTagThrottlingEnabled);
															#line 303 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 699 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when7(__when_expr_6.get(), loopDepth); };
								static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 7;
															#line 303 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ThrottleCommandActorActor, 6, Void >*>(static_cast<ThrottleCommandActorActor*>(this)));
															#line 704 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
															#line 306 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
								if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 713 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
								new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ThrottleCommandActorActorState();
								static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThrottleCommandActorActorState();
		static_cast<ThrottleCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 310 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (!static_cast<ThrottleCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ThrottleCommandActorActorState(); static_cast<ThrottleCommandActorActor*>(this)->destroy(); return 0; }
															#line 744 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		new (&static_cast<ThrottleCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ThrottleCommandActorActorState();
		static_cast<ThrottleCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 85 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		bool anyLogged = false;
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		for(auto itr = tags.begin();itr != tags.end();++itr) {
															#line 87 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			if (itr->expirationTime > now())
															#line 766 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
			{
															#line 88 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				if (!anyLogged)
															#line 770 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				{
															#line 89 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					printf("Throttled tags:\n\n");
															#line 90 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					printf("  Rate (txn/s) | Expiration (s) | Priority  | Type   | Reason     |Tag\n");
															#line 91 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					printf(" --------------+----------------+-----------+--------+------------+------\n");
															#line 93 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					anyLogged = true;
															#line 780 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				}
															#line 96 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				std::string reasonStr = "unset";
															#line 97 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				if (itr->reason == TagThrottledReason::MANUAL)
															#line 786 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				{
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					reasonStr = "manual";
															#line 790 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 99 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
					if (itr->reason == TagThrottledReason::BUSY_WRITE)
															#line 796 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					{
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						reasonStr = "busy write";
															#line 800 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
						if (itr->reason == TagThrottledReason::BUSY_READ)
															#line 806 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						{
															#line 102 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
							reasonStr = "busy read";
															#line 810 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
						}
					}
				}
															#line 105 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
				printf("  %12d | %13ds | %9s | %6s | %10s |%s\n", (int)(itr->tpsRate), std::min((int)(itr->expirationTime - now()), (int)(itr->initialDuration)), transactionPriorityToString(itr->priority, false), itr->throttleType == TagThrottleType::AUTO ? "auto" : "manual", reasonStr.c_str(), itr->tag.toString().c_str());
															#line 816 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
			}
		}
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (tags.size() == throttleListLimit)
															#line 821 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 116 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("\nThe tag limit `%d' was reached. Use the [LIMIT] argument to view additional tags.\n", throttleListLimit);
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("Usage: throttle list [LIMIT]\n");
															#line 827 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (!anyLogged)
															#line 831 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("There are no %s tags\n", reportThrottled ? "throttled" : "recommended");
															#line 835 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont30(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont31(Void const& _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		printf("Tag `%s' has been throttled\n", tokens[3].toString().c_str());
															#line 1124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1cont31(Void && _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		printf("Tag `%s' has been throttled\n", tokens[3].toString().c_str());
															#line 1133 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont31(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont31(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont46(int loopDepth) 
	{
		loopDepth = a_body1cont30(loopDepth);

		return loopDepth;
	}
	int a_body1cont47(int loopDepth) 
	{
		loopDepth = a_body1cont46(loopDepth);

		return loopDepth;
	}
	int a_body1cont71(int loopDepth) 
	{
		loopDepth = a_body1cont47(loopDepth);

		return loopDepth;
	}
	int a_body1cont72(bool const& success,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (success)
															#line 1235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 265 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			fmt::print("Unthrottled {0}{1}\n", tagSet.toString(), priorityString);
															#line 1239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 267 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			fmt::print("{0} was not {1}throttled{2}\n", tagSet.toString(Capitalize::True), throttleTypeString, priorityString);
															#line 1245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont71(loopDepth);

		return loopDepth;
	}
	int a_body1cont72(bool && success,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (success)
															#line 1255 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 265 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			fmt::print("Unthrottled {0}{1}\n", tagSet.toString(), priorityString);
															#line 1259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 267 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			fmt::print("{0} was not {1}throttled{2}\n", tagSet.toString(Capitalize::True), throttleTypeString, priorityString);
															#line 1265 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont71(loopDepth);

		return loopDepth;
	}
	int a_body1when5(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont72(success, loopDepth);

		return loopDepth;
	}
	int a_body1when5(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont72(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont73(bool const& unthrottled,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (unthrottled)
															#line 1350 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 275 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("Unthrottled all %sthrottled tags%s\n", throttleTypeString, priorityString.c_str());
															#line 1354 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("There were no tags being %sthrottled%s\n", throttleTypeString, priorityString.c_str());
															#line 1360 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont71(loopDepth);

		return loopDepth;
	}
	int a_body1cont73(bool && unthrottled,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		if (unthrottled)
															#line 1370 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		{
															#line 275 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("Unthrottled all %sthrottled tags%s\n", throttleTypeString, priorityString.c_str());
															#line 1374 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
			printf("There were no tags being %sthrottled%s\n", throttleTypeString, priorityString.c_str());
															#line 1380 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont71(loopDepth);

		return loopDepth;
	}
	int a_body1when6(bool const& unthrottled,int loopDepth) 
	{
		loopDepth = a_body1cont73(unthrottled, loopDepth);

		return loopDepth;
	}
	int a_body1when6(bool && unthrottled,int loopDepth) 
	{
		loopDepth = a_body1cont73(std::move(unthrottled), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont75(int loopDepth) 
	{
		loopDepth = a_body1cont46(loopDepth);

		return loopDepth;
	}
	int a_body1cont76(Void const& _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		printf("Automatic tag throttling has been %s\n", autoTagThrottlingEnabled ? "enabled" : "disabled");
															#line 1471 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont75(loopDepth);

		return loopDepth;
	}
	int a_body1cont76(Void && _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
		printf("Automatic tag throttling has been %s\n", autoTagThrottlingEnabled ? "enabled" : "disabled");
															#line 1480 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont75(loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont76(_, loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont76(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ThrottleCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleCommandActorActor*>(this)->ActorCallback< ThrottleCommandActorActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ThrottleCommandActorActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ThrottleCommandActorActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 51 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	bool reportThrottled;
															#line 52 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	bool reportRecommended;
															#line 66 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	int throttleListLimit;
															#line 76 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	std::vector<TagThrottleInfo> tags;
															#line 188 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	TagSet tagSet;
															#line 257 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	const char* throttleTypeString;
															#line 259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	std::string priorityString;
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	bool autoTagThrottlingEnabled;
															#line 1580 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via throttleCommandActor()
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
class ThrottleCommandActorActor final : public Actor<bool>, public ActorCallback< ThrottleCommandActorActor, 0, Void >, public ActorCallback< ThrottleCommandActorActor, 1, Void >, public ActorCallback< ThrottleCommandActorActor, 2, Void >, public ActorCallback< ThrottleCommandActorActor, 3, Void >, public ActorCallback< ThrottleCommandActorActor, 4, bool >, public ActorCallback< ThrottleCommandActorActor, 5, bool >, public ActorCallback< ThrottleCommandActorActor, 6, Void >, public FastAllocated<ThrottleCommandActorActor>, public ThrottleCommandActorActorState<ThrottleCommandActorActor> {
															#line 1585 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<ThrottleCommandActorActor>::operator new;
	using FastAllocated<ThrottleCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(64055677899915520UL, 11349636970029008384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThrottleCommandActorActor, 0, Void >;
friend struct ActorCallback< ThrottleCommandActorActor, 1, Void >;
friend struct ActorCallback< ThrottleCommandActorActor, 2, Void >;
friend struct ActorCallback< ThrottleCommandActorActor, 3, Void >;
friend struct ActorCallback< ThrottleCommandActorActor, 4, bool >;
friend struct ActorCallback< ThrottleCommandActorActor, 5, bool >;
friend struct ActorCallback< ThrottleCommandActorActor, 6, Void >;
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	ThrottleCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1608 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   ThrottleCommandActorActorState<ThrottleCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throttleCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17235173093112421632UL, 13668290616039942144UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throttleCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throttleCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ThrottleCommandActorActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
[[nodiscard]] Future<bool> throttleCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 38 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"
	return Future<bool>(new ThrottleCommandActorActor(db, tokens));
															#line 1646 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/ThrottleCommand.actor.g.cpp.py_gen"
}

#line 312 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/ThrottleCommand.actor.cpp"

void throttleGenerator(const char* text,
                       const char* line,
                       std::vector<std::string>& lc,
                       std::vector<StringRef> const& tokens) {
	if (tokens.size() == 1) {
		const char* opts[] = { "on tag", "off", "enable auto", "disable auto", "list", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() >= 2 && tokencmp(tokens[1], "on")) {
		if (tokens.size() == 2) {
			const char* opts[] = { "tag", nullptr };
			arrayGenerator(text, line, opts, lc);
		} else if (tokens.size() == 6) {
			const char* opts[] = { "default", "immediate", "batch", nullptr };
			arrayGenerator(text, line, opts, lc);
		}
	} else if (tokens.size() >= 2 && tokencmp(tokens[1], "off") && !tokencmp(tokens[tokens.size() - 1], "tag")) {
		const char* opts[] = { "all", "auto", "manual", "tag", "default", "immediate", "batch", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() == 2 && (tokencmp(tokens[1], "enable") || tokencmp(tokens[1], "disable"))) {
		const char* opts[] = { "auto", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() >= 2 && tokencmp(tokens[1], "list")) {
		if (tokens.size() == 2) {
			const char* opts[] = { "throttled", "recommended", "all", nullptr };
			arrayGenerator(text, line, opts, lc);
		} else if (tokens.size() == 3) {
			const char* opts[] = { "LIMITS", nullptr };
			arrayGenerator(text, line, opts, lc);
		}
	}
}

std::vector<const char*> throttleHintGenerator(std::vector<StringRef> const& tokens, bool inArgument) {
	if (tokens.size() == 1) {
		return { "<on|off|enable auto|disable auto|list>", "[ARGS]" };
	} else if (tokencmp(tokens[1], "on")) {
		std::vector<const char*> opts = { "tag", "<TAG>", "[RATE]", "[DURATION]", "[default|immediate|batch]" };
		if (tokens.size() == 2) {
			return opts;
		} else if (((tokens.size() == 3 && inArgument) || tokencmp(tokens[2], "tag")) && tokens.size() < 7) {
			return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
		}
	} else if (tokencmp(tokens[1], "off")) {
		if (tokencmp(tokens[tokens.size() - 1], "tag")) {
			return { "<TAG>" };
		} else {
			bool hasType = false;
			bool hasTag = false;
			bool hasPriority = false;
			for (int i = 2; i < tokens.size(); ++i) {
				if (tokencmp(tokens[i], "all") || tokencmp(tokens[i], "auto") || tokencmp(tokens[i], "manual")) {
					hasType = true;
				} else if (tokencmp(tokens[i], "default") || tokencmp(tokens[i], "immediate") ||
				           tokencmp(tokens[i], "batch")) {
					hasPriority = true;
				} else if (tokencmp(tokens[i], "tag")) {
					hasTag = true;
					++i;
				} else {
					return {};
				}
			}

			std::vector<const char*> options;
			if (!hasType) {
				options.push_back("[all|auto|manual]");
			}
			if (!hasTag) {
				options.push_back("[tag <TAG>]");
			}
			if (!hasPriority) {
				options.push_back("[default|immediate|batch]");
			}

			return options;
		}
	} else if ((tokencmp(tokens[1], "enable") || tokencmp(tokens[1], "disable")) && tokens.size() == 2) {
		return { "auto" };
	} else if (tokens.size() >= 2 && tokencmp(tokens[1], "list")) {
		if (tokens.size() == 2) {
			return { "[throttled|recommended|all]", "[LIMITS]" };
		} else if (tokens.size() == 3 && (tokencmp(tokens[2], "throttled") || tokencmp(tokens[2], "recommended") ||
		                                  tokencmp(tokens[2], "all"))) {
			return { "[LIMITS]" };
		}
	} else if (tokens.size() == 2 && inArgument) {
		return { "[ARGS]" };
	}

	return std::vector<const char*>();
}

CommandFactory throttleFactory(
    "throttle",
    CommandHelp("throttle <on|off|enable auto|disable auto|list> [ARGS]",
                "view and control throttled tags",
                "Use `on' and `off' to manually throttle or unthrottle tags. Use `enable auto' or `disable auto' "
                "to enable or disable automatic tag throttling. Use `list' to print the list of throttled tags.\n"),
    &throttleGenerator,
    &throttleHintGenerator);
} // namespace fdb_cli
