#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
/*
 * BulkLoadCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/BulkLoading.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

static const std::string BULK_LOAD_MODE_USAGE = "To set bulkload mode: bulkload mode [on|off]\n";
static const std::string BULK_LOAD_LOAD_USAGE =
    "To load a range of key/values: bulkload load <JOBID> <BEGINKEY> <ENDKEY> <DIR>\n"
    " where <JOBID> is the id of the bulkdumped job to load, <BEGINKEY> to <ENDKEY>\n"
    " denotes the key/value range to load, and <DIR> is a local directory OR \n"
    " blobstore url to load SST files from.\n";
static const std::string BULK_LOAD_STATUS_USAGE = "To get status: bulkload status\n";
static const std::string BULK_LOAD_CANCEL_USAGE = "To cancel current bulkload job: bulkload cancel <JOBID>\n";
static const std::string BULK_LOAD_HISTORY_USAGE = "To print bulkload job history: bulkload history\n";
static const std::string BULK_LOAD_HISTORY_CLEAR_USAGE = "To clear history: bulkload history clear [all|id]\n";

static const std::string BULKLOAD_ADD_LOCK_OWNER_USAGE =
    "To add a range lock owner: bulkload addlockowner <OWNER_UNIQUE_ID>\n";
static const std::string BULKLOAD_PRINT_LOCK_USAGE = "To print locked ranges: bulkload printlock\n";
static const std::string BULKLOAD_PRINT_LOCK_OWNER_USAGE = "To print range lock owners: bulkload printlockowner\n";
static const std::string BULKLOAD_CLEAR_LOCK_USAGE = "To clear a range lock: bulkload clearlock <OWNER_UNIQUE_ID>\n";

static const std::string BULK_LOAD_HELP_MESSAGE =
    BULK_LOAD_MODE_USAGE + BULK_LOAD_LOAD_USAGE + BULK_LOAD_STATUS_USAGE + BULK_LOAD_CANCEL_USAGE +
    BULK_LOAD_HISTORY_USAGE + BULK_LOAD_HISTORY_CLEAR_USAGE + BULKLOAD_ADD_LOCK_OWNER_USAGE +
    BULKLOAD_PRINT_LOCK_USAGE + BULKLOAD_PRINT_LOCK_OWNER_USAGE + BULKLOAD_CLEAR_LOCK_USAGE;

															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printPastBulkLoadJob()
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class PrintPastBulkLoadJobActor>
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintPastBulkLoadJobActorState {
															#line 61 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintPastBulkLoadJobActorState(Database const& cx) 
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx)
															#line 68 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this));

	}
	~PrintPastBulkLoadJobActorState() 
	{
		fdb_probe_actor_destroy("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<std::vector<BulkLoadJobState>> __when_expr_0 = getBulkLoadJobFromHistory(cx);
															#line 54 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 85 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state = 1;
															#line 54 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*>(static_cast<PrintPastBulkLoadJobActor*>(this)));
															#line 90 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> const& jobs,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (jobs.empty())
															#line 113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job in the history");
															#line 57 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PrintPastBulkLoadJobActorState();
			static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 59 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& job : jobs ) {
															#line 60 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			ASSERT(job.getPhase() == BulkLoadJobPhase::Complete || job.getPhase() == BulkLoadJobPhase::Error || job.getPhase() == BulkLoadJobPhase::Cancelled);
															#line 62 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!job.getTaskCount().present())
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Job {} submitted at {} for range {}. The job has not initialized for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 135 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 71 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println( "Job {} submitted at {} for range {}. The job has {} tasks. The job ran for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), job.getTaskCount().get(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 141 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
															#line 81 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (job.getPhase() == BulkLoadJobPhase::Error)
															#line 145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				Optional<std::string> errorMessage = job.getErrorMessage();
															#line 83 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error message: {}", errorMessage.present() ? errorMessage.get() : "Not provided.");
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
		}
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 156 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> && jobs,int loopDepth) 
	{
															#line 55 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (jobs.empty())
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 56 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job in the history");
															#line 57 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PrintPastBulkLoadJobActorState();
			static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 59 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& job : jobs ) {
															#line 60 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			ASSERT(job.getPhase() == BulkLoadJobPhase::Complete || job.getPhase() == BulkLoadJobPhase::Error || job.getPhase() == BulkLoadJobPhase::Cancelled);
															#line 62 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!job.getTaskCount().present())
															#line 186 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 63 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Job {} submitted at {} for range {}. The job has not initialized for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 190 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 71 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println( "Job {} submitted at {} for range {}. The job has {} tasks. The job ran for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), job.getTaskCount().get(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
															#line 81 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (job.getPhase() == BulkLoadJobPhase::Error)
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 82 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				Optional<std::string> errorMessage = job.getErrorMessage();
															#line 83 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error message: {}", errorMessage.present() ? errorMessage.get() : "Not provided.");
															#line 206 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
		}
															#line 86 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 211 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> const& jobs,int loopDepth) 
	{
		loopDepth = a_body1cont1(jobs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> && jobs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(jobs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state > 0) static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state = 0;
		static_cast<PrintPastBulkLoadJobActor*>(this)->ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 296 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printPastBulkLoadJob()
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintPastBulkLoadJobActor final : public Actor<Void>, public ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >, public FastAllocated<PrintPastBulkLoadJobActor>, public PrintPastBulkLoadJobActorState<PrintPastBulkLoadJobActor> {
															#line 301 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintPastBulkLoadJobActor>::operator new;
	using FastAllocated<PrintPastBulkLoadJobActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7114948623170907904UL, 6796408125271543296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >;
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintPastBulkLoadJobActor(Database const& cx) 
															#line 318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintPastBulkLoadJobActorState<PrintPastBulkLoadJobActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5590200633345809408UL, 11637533527039951616UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printPastBulkLoadJob");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<Void> printPastBulkLoadJob( Database const& cx ) {
															#line 53 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<Void>(new PrintPastBulkLoadJobActor(cx));
															#line 350 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
}

#line 88 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

void printBulkLoadJobTotalTaskCount(Optional<uint64_t> count) {
	if (count.present()) {
		fmt::println("Total {} tasks", count.get());
	} else {
		fmt::println("Total task count is unknown");
	}
	return;
}

															#line 364 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printBulkLoadJobProgress()
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class PrintBulkLoadJobProgressActor>
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintBulkLoadJobProgressActorState {
															#line 370 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintBulkLoadJobProgressActorState(Database const& cx,BulkLoadJobState const& job) 
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx),
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   job(job),
															#line 99 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   tr(cx),
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   readBegin(job.getJobRange().begin),
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   readEnd(job.getJobRange().end),
															#line 102 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   jobId(job.getJobId()),
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   rangeResult(),
															#line 104 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   completeTaskCount(0),
															#line 105 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   submitTaskCount(0),
															#line 106 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   errorTaskCount(0),
															#line 107 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   totalTaskCount(job.getTaskCount())
															#line 397 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this));

	}
	~PrintBulkLoadJobProgressActorState() 
	{
		fdb_probe_actor_destroy("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			;
															#line 412 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintBulkLoadJobProgressActorState();
		static_cast<PrintBulkLoadJobProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 142 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Submitted {} tasks", submitTaskCount);
															#line 143 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Finished {} tasks", completeTaskCount);
															#line 144 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Error {} tasks", errorTaskCount);
															#line 145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 146 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 443 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintBulkLoadJobProgressActorState();
		static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 108 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!(readBegin < readEnd))
															#line 462 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 110 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			rangeResult.clear();
															#line 111 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 112 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rangeResult, krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(readBegin, readEnd)));
															#line 113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 477 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*>(static_cast<PrintBulkLoadJobProgressActor*>(this)));
															#line 482 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 519 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 2;
															#line 139 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*>(static_cast<PrintBulkLoadJobProgressActor*>(this)));
															#line 524 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 541 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BulkLoadTaskState bulkLoadTask = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.getJobId() != jobId)
															#line 549 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Submitted {} tasks", submitTaskCount);
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Finished {} tasks", completeTaskCount);
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error {} tasks", errorTaskCount);
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Submitted && bulkLoadTask.getJobId() != UID::fromString("00000000-0000-0000-0000-000000000000"))
															#line 561 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("Job {} has been cancelled or has completed", jobId.toString());
															#line 565 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				}
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 569 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrintBulkLoadJobProgressActorState();
				static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.phase == BulkLoadPhase::Complete)
															#line 577 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				completeTaskCount = completeTaskCount + bulkLoadTask.getManifests().size();
															#line 581 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 132 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Error)
															#line 587 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 133 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					errorTaskCount = errorTaskCount + bulkLoadTask.getManifests().size();
															#line 591 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				}
			}
															#line 135 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			submitTaskCount = submitTaskCount + bulkLoadTask.getManifests().size();
															#line 596 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		readBegin = rangeResult.back().key;
															#line 600 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 115 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 611 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 118 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BulkLoadTaskState bulkLoadTask = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 119 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.getJobId() != jobId)
															#line 619 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 120 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Submitted {} tasks", submitTaskCount);
															#line 121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Finished {} tasks", completeTaskCount);
															#line 122 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error {} tasks", errorTaskCount);
															#line 123 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 124 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Submitted && bulkLoadTask.getJobId() != UID::fromString("00000000-0000-0000-0000-000000000000"))
															#line 631 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 126 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("Job {} has been cancelled or has completed", jobId.toString());
															#line 635 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				}
															#line 128 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 639 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrintBulkLoadJobProgressActorState();
				static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 130 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.phase == BulkLoadPhase::Complete)
															#line 647 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 131 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				completeTaskCount = completeTaskCount + bulkLoadTask.getManifests().size();
															#line 651 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 132 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Error)
															#line 657 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 133 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					errorTaskCount = errorTaskCount + bulkLoadTask.getManifests().size();
															#line 661 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				}
			}
															#line 135 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			submitTaskCount = submitTaskCount + bulkLoadTask.getManifests().size();
															#line 666 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		readBegin = rangeResult.back().key;
															#line 670 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state > 0) static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBulkLoadJobProgressActor*>(this)->ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state > 0) static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBulkLoadJobProgressActor*>(this)->ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadJobState job;
															#line 99 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Transaction tr;
															#line 100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Key readBegin;
															#line 101 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Key readEnd;
															#line 102 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	UID jobId;
															#line 103 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	RangeResult rangeResult;
															#line 104 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t completeTaskCount;
															#line 105 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t submitTaskCount;
															#line 106 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t errorTaskCount;
															#line 107 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Optional<uint64_t> totalTaskCount;
															#line 872 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printBulkLoadJobProgress()
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintBulkLoadJobProgressActor final : public Actor<Void>, public ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >, public ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >, public FastAllocated<PrintBulkLoadJobProgressActor>, public PrintBulkLoadJobProgressActorState<PrintBulkLoadJobProgressActor> {
															#line 877 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintBulkLoadJobProgressActor>::operator new;
	using FastAllocated<PrintBulkLoadJobProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12243679135005118720UL, 13335490530429060608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >;
friend struct ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >;
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintBulkLoadJobProgressActor(Database const& cx,BulkLoadJobState const& job) 
															#line 895 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintBulkLoadJobProgressActorState<PrintBulkLoadJobProgressActor>(cx, job),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10655978368853905920UL, 17576660726047062784UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printBulkLoadJobProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<Void> printBulkLoadJobProgress( Database const& cx, BulkLoadJobState const& job ) {
															#line 98 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<Void>(new PrintBulkLoadJobProgressActor(cx, job));
															#line 928 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
}

#line 148 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

															#line 933 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via bulkLoadCommandActor()
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class BulkLoadCommandActorActor>
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class BulkLoadCommandActorActorState {
															#line 939 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx),
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   tokens(tokens)
															#line 948 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadCommandActorActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[1], "mode"))
															#line 963 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokens.size() == 2)
															#line 967 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<int> __when_expr_0 = getBulkLoadMode(cx);
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 1;
															#line 152 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 0, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 978 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 180 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokencmp(tokens[1], "load"))
															#line 990 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<int> __when_expr_3 = getBulkLoadMode(cx);
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 996 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 4;
															#line 181 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 3, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1001 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 214 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (tokencmp(tokens[1], "cancel"))
															#line 1008 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					{
															#line 215 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 1012 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
						{
															#line 216 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("{}", BULK_LOAD_CANCEL_USAGE);
															#line 217 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1018 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkLoadCommandActorActorState();
							static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						jobId = UID::fromString(tokens[2].toString());
															#line 220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (!jobId.isValid())
															#line 1028 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
						{
															#line 221 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 222 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("{}", BULK_LOAD_CANCEL_USAGE);
															#line 223 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1036 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkLoadCommandActorActorState();
							static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 225 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						StrictFuture<Void> __when_expr_5 = cancelBulkLoadJob(cx, jobId);
															#line 225 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1046 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
						if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when3(__when_expr_5.get(), loopDepth); };
						static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 6;
															#line 225 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 5, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1051 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 229 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (tokencmp(tokens[1], "status"))
															#line 1058 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
						{
															#line 230 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (tokens.size() != 2)
															#line 1062 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							{
															#line 231 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								fmt::println("{}", BULK_LOAD_STATUS_USAGE);
															#line 232 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1068 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
								new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
								this->~BulkLoadCommandActorActorState();
								static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 234 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							StrictFuture<Optional<BulkLoadJobState>> __when_expr_6 = getRunningBulkLoadJob(cx);
															#line 234 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1078 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when4(__when_expr_6.get(), loopDepth); };
							static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 7;
															#line 234 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1083 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 244 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (tokencmp(tokens[1], "history"))
															#line 1090 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
							{
															#line 245 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (tokens.size() == 2)
															#line 1094 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
								{
															#line 246 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									StrictFuture<Void> __when_expr_8 = printPastBulkLoadJob(cx);
															#line 246 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1100 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1when5(__when_expr_8.get(), loopDepth); };
									static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 9;
															#line 246 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 8, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1105 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
									loopDepth = a_body1cont25(loopDepth);
								}
							}
							else
							{
															#line 292 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (tokencmp(tokens[1], "addlockowner"))
															#line 1117 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
								{
															#line 294 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (tokens.size() != 3)
															#line 1121 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									{
															#line 295 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("{}", BULK_LOAD_STATUS_USAGE);
															#line 296 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1127 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
										this->~BulkLoadCommandActorActorState();
										static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
															#line 298 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									std::string ownerUniqueID = tokens[2].toString();
															#line 299 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (ownerUniqueID.empty())
															#line 1137 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									{
															#line 300 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("ERROR: Owner unique id cannot be empty");
															#line 301 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("{}", BULKLOAD_ADD_LOCK_OWNER_USAGE);
															#line 302 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1145 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
										this->~BulkLoadCommandActorActorState();
										static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
															#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									StrictFuture<Void> __when_expr_11 = registerRangeLockOwner(cx, ownerUniqueID, ownerUniqueID);
															#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1155 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1when6(__when_expr_11.get(), loopDepth); };
									static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 12;
															#line 304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 11, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1160 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
															#line 307 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (tokencmp(tokens[1], "printlock"))
															#line 1167 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
									{
															#line 309 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (tokens.size() != 2)
															#line 1171 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										{
															#line 310 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											fmt::println("{}", BULKLOAD_PRINT_LOCK_USAGE);
															#line 311 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1177 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
											new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
											this->~BulkLoadCommandActorActorState();
											static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
											return 0;
										}
															#line 313 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_12 = findExclusiveReadLockOnRange(cx, normalKeys);
															#line 313 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1187 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1when7(__when_expr_12.get(), loopDepth); };
										static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 13;
															#line 313 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1192 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										loopDepth = 0;
									}
									else
									{
															#line 329 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (tokencmp(tokens[1], "printlockowner"))
															#line 1199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
										{
															#line 331 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (tokens.size() != 2)
															#line 1203 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
											{
															#line 332 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												fmt::println("{}", BULKLOAD_PRINT_LOCK_OWNER_USAGE);
															#line 333 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1209 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
												new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
												this->~BulkLoadCommandActorActorState();
												static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
												return 0;
											}
															#line 335 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											StrictFuture<std::vector<RangeLockOwner>> __when_expr_13 = getAllRangeLockOwners(cx);
															#line 335 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
											if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1when8(__when_expr_13.get(), loopDepth); };
											static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 14;
															#line 335 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1224 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
											loopDepth = 0;
										}
										else
										{
															#line 341 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (tokencmp(tokens[1], "clearlock"))
															#line 1231 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
											{
															#line 343 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (tokens.size() != 3)
															#line 1235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
												{
															#line 344 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
													fmt::println("{}", BULKLOAD_CLEAR_LOCK_USAGE);
															#line 345 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
													if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
													new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
													this->~BulkLoadCommandActorActorState();
													static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
													return 0;
												}
															#line 347 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												std::string ownerUniqueID = tokens[2].toString();
															#line 348 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												StrictFuture<Void> __when_expr_14 = releaseExclusiveReadLockByUser(cx, ownerUniqueID);
															#line 348 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1253 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
												if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1when9(__when_expr_14.get(), loopDepth); };
												static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 15;
															#line 348 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 14, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1258 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
												loopDepth = 0;
											}
											else
											{
															#line 352 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												printUsage(tokens[0]);
															#line 353 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												printLongDesc(tokens[0]);
															#line 354 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1269 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
												new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
												this->~BulkLoadCommandActorActorState();
												static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
												return 0;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 163 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 3)
															#line 1304 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 164 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_MODE_USAGE);
															#line 165 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1310 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 167 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokencmp(tokens[2], "on"))
															#line 1318 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<int> __when_expr_1 = setBulkLoadMode(cx, 1);
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1324 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 1, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1329 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 171 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "off"))
															#line 1336 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 172 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				StrictFuture<int> __when_expr_2 = setBulkLoadMode(cx, 0);
															#line 172 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1342 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 3;
															#line 172 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 2, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1347 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 176 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid bulkload mode value {}", tokens[2].toString());
															#line 177 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_MODE_USAGE);
															#line 178 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1358 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont3(int const& mode,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1372 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Bulkload mode is disabled");
															#line 1376 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 155 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (mode == 1)
															#line 1382 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 156 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Bulkload mode is enabled");
															#line 1386 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 1392 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
		}
															#line 160 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1397 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int && mode,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1409 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 154 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Bulkload mode is disabled");
															#line 1413 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 155 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (mode == 1)
															#line 1419 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 156 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Bulkload mode is enabled");
															#line 1423 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 1429 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			}
		}
															#line 160 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1434 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont3(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(int const& old,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 170 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1523 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int && old,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 170 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1537 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont11(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13(int const& old,int loopDepth) 
	{
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 174 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1626 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13(int && old,int loopDepth) 
	{
															#line 173 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 174 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1640 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when2(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont13(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16(int const& mode,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1727 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 183 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Bulkload mode must be enabled to load data");
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1733 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 186 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 6)
															#line 1741 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 187 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 188 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1747 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 190 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		UID jobId = UID::fromString(tokens[2].toString());
															#line 191 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!jobId.isValid())
															#line 1757 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 193 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 194 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1765 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeBegin = tokens[3];
															#line 197 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeEnd = tokens[4];
															#line 199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 1777 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 202 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 203 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1785 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		std::string jobRoot = tokens[5].toString();
															#line 206 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 207 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		bulkLoadJob = createBulkLoadJob( jobId, range, jobRoot, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1801 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 5;
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 4, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1806 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(int && mode,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1815 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 183 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Bulkload mode must be enabled to load data");
															#line 184 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1821 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 186 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 6)
															#line 1829 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 187 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 188 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1835 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 190 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		UID jobId = UID::fromString(tokens[2].toString());
															#line 191 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!jobId.isValid())
															#line 1845 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 193 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 194 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1853 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 196 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeBegin = tokens[3];
															#line 197 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeEnd = tokens[4];
															#line 199 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 1865 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 202 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 203 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1873 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		std::string jobRoot = tokens[5].toString();
															#line 206 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 207 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		bulkLoadJob = createBulkLoadJob( jobId, range, jobRoot, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1889 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 5;
															#line 212 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 4, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1894 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when2(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 213 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkLoadJob.getJobId()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1978 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkLoadJob.getJobId());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 213 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkLoadJob.getJobId()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1990 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkLoadJob.getJobId());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. The job range lock has been cleared", jobId.toString());
															#line 227 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2079 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. The job range lock has been cleared", jobId.toString());
															#line 227 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2093 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont22(Optional<BulkLoadJobState> const& job,int loopDepth) 
	{
															#line 235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!job.present())
															#line 2180 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job is running");
															#line 237 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2186 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Running bulk loading job: {}", job.get().getJobId().toString());
															#line 240 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job information: {}", job.get().toString());
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = printBulkLoadJobProgress(cx, job.get());
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2200 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont22when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 8;
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 7, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2205 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont22(Optional<BulkLoadJobState> && job,int loopDepth) 
	{
															#line 235 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!job.present())
															#line 2214 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job is running");
															#line 237 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2220 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Running bulk loading job: {}", job.get().getJobId().toString());
															#line 240 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job information: {}", job.get().toString());
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = printBulkLoadJobProgress(cx, job.get());
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2234 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont22when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 8;
															#line 241 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 7, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2239 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when4(Optional<BulkLoadJobState> const& job,int loopDepth) 
	{
		loopDepth = a_body1cont22(job, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Optional<BulkLoadJobState> && job,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(job), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2323 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont22cont1(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2335 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont25(int loopDepth) 
	{
															#line 249 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 3)
															#line 2422 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 250 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear"))
															#line 2426 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 251 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 252 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2432 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 254 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid history option {}", tokens[2].toString());
															#line 255 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 256 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2446 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 259 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 4)
															#line 2455 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 260 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear"))
															#line 2459 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 261 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokencmp(tokens[3], "all"))
															#line 2463 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<Void> __when_expr_9 = clearBulkLoadJobHistory(cx);
															#line 262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2469 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont25when1(__when_expr_9.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 10;
															#line 262 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 9, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2474 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 266 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("ERROR: Invalid history clear option {}", tokens[3].toString());
															#line 267 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 268 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2485 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~BulkLoadCommandActorActorState();
					static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 271 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid history clear option {}", tokens[2].toString());
															#line 272 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 273 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2500 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
			loopDepth = a_body1cont25cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont26(Void const& _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2518 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont26(Void && _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2530 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont26(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont26(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont25cont1(int loopDepth) 
	{
															#line 276 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 5)
															#line 2617 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 277 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear") && tokencmp(tokens[3], "id"))
															#line 2621 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
															#line 278 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				UID jobId = UID::fromString(tokens[4].toString());
															#line 279 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!jobId.isValid())
															#line 2627 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				{
															#line 280 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("ERROR: Invalid job id {}", tokens[4].toString());
															#line 281 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 282 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2635 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
					new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~BulkLoadCommandActorActorState();
					static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				StrictFuture<Void> __when_expr_10 = clearBulkLoadJobHistory(cx, jobId);
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2645 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont25cont1when1(__when_expr_10.get(), loopDepth); };
				static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 11;
															#line 284 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 10, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2650 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont25cont12(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont25cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont25cont7(Void const& _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("All bulkload job history has been cleared");
															#line 264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2671 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont7(Void && _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("All bulkload job history has been cleared");
															#line 264 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2685 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont25when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont25when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont25when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont25cont11(int loopDepth) 
	{
															#line 289 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		printLongDesc(tokens[0]);
															#line 290 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2774 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont12(int loopDepth) 
	{
		loopDepth = a_body1cont25cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont25cont13(Void const& _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Bulkload job {} has been cleared from history", jobId.toString());
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(jobId); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2794 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(jobId)); // state_var_RVO
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont13(Void && _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Bulkload job {} has been cleared from history", jobId.toString());
															#line 286 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(jobId); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2808 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(jobId)); // state_var_RVO
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont25cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont25cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont25cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont28(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2895 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont28(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2907 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont28(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont28(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont32(std::vector<std::pair<KeyRange, RangeLockState>> const& lockedRanges,int loopDepth) 
	{
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Total {} locked ranges", lockedRanges.size());
															#line 316 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (lockedRanges.size() > 10)
															#line 2996 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 317 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("First 10 locks are:");
															#line 3000 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 319 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		int count = 1;
															#line 320 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& lock : lockedRanges ) {
															#line 321 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (count > 10)
															#line 3008 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
				break;
			}
															#line 324 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Lock {} on {} for {}", count, lock.first.toString(), lock.second.toString());
															#line 325 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			count++;
															#line 3016 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 327 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3020 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont32(std::vector<std::pair<KeyRange, RangeLockState>> && lockedRanges,int loopDepth) 
	{
															#line 315 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Total {} locked ranges", lockedRanges.size());
															#line 316 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (lockedRanges.size() > 10)
															#line 3034 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		{
															#line 317 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("First 10 locks are:");
															#line 3038 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 319 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		int count = 1;
															#line 320 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& lock : lockedRanges ) {
															#line 321 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (count > 10)
															#line 3046 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
			{
				break;
			}
															#line 324 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Lock {} on {} for {}", count, lock.first.toString(), lock.second.toString());
															#line 325 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			count++;
															#line 3054 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 327 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3058 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when7(std::vector<std::pair<KeyRange, RangeLockState>> const& lockedRanges,int loopDepth) 
	{
		loopDepth = a_body1cont32(lockedRanges, loopDepth);

		return loopDepth;
	}
	int a_body1when7(std::vector<std::pair<KeyRange, RangeLockState>> && lockedRanges,int loopDepth) 
	{
		loopDepth = a_body1cont32(std::move(lockedRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont35(std::vector<RangeLockOwner> const& owners,int loopDepth) 
	{
															#line 336 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto owner : owners ) {
															#line 337 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", owner.toString());
															#line 3147 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 339 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3151 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont35(std::vector<RangeLockOwner> && owners,int loopDepth) 
	{
															#line 336 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto owner : owners ) {
															#line 337 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", owner.toString());
															#line 3165 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		}
															#line 339 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3169 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when8(std::vector<RangeLockOwner> const& owners,int loopDepth) 
	{
		loopDepth = a_body1cont35(owners, loopDepth);

		return loopDepth;
	}
	int a_body1when8(std::vector<RangeLockOwner> && owners,int loopDepth) 
	{
		loopDepth = a_body1cont35(std::move(owners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont38(Void const& _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3256 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont38(Void && _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3268 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont38(_, loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont38(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 207 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadJobState bulkLoadJob;
															#line 219 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	UID jobId;
															#line 3359 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkLoadCommandActor()
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class BulkLoadCommandActorActor final : public Actor<UID>, public ActorCallback< BulkLoadCommandActorActor, 0, int >, public ActorCallback< BulkLoadCommandActorActor, 1, int >, public ActorCallback< BulkLoadCommandActorActor, 2, int >, public ActorCallback< BulkLoadCommandActorActor, 3, int >, public ActorCallback< BulkLoadCommandActorActor, 4, Void >, public ActorCallback< BulkLoadCommandActorActor, 5, Void >, public ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >, public ActorCallback< BulkLoadCommandActorActor, 7, Void >, public ActorCallback< BulkLoadCommandActorActor, 8, Void >, public ActorCallback< BulkLoadCommandActorActor, 9, Void >, public ActorCallback< BulkLoadCommandActorActor, 10, Void >, public ActorCallback< BulkLoadCommandActorActor, 11, Void >, public ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >, public ActorCallback< BulkLoadCommandActorActor, 14, Void >, public FastAllocated<BulkLoadCommandActorActor>, public BulkLoadCommandActorActorState<BulkLoadCommandActorActor> {
															#line 3364 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkLoadCommandActorActor>::operator new;
	using FastAllocated<BulkLoadCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15361926422671397120UL, 14946102785428973312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadCommandActorActor, 0, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 1, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 2, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 3, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 4, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 5, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 7, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 8, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 9, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 10, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 11, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 14, Void >;
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 3395 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
		 : Actor<UID>(),
		   BulkLoadCommandActorActorState<BulkLoadCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5735936966811031040UL, 12288206974481010944UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<UID> bulkLoadCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 149 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<UID>(new BulkLoadCommandActorActor(cx, tokens));
															#line 3441 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/build_output/fdbcli/BulkLoadCommand.actor.g.cpp.py_gen"
}

#line 357 "/codebuild/output/src1032356206/src/github.com/apple/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

CommandFactory bulkLoadFactory("bulkload",
                               CommandHelp("bulkload [mode|load|status|cancel|history] [ARGs]",
                                           "bulkload commands",
                                           BULK_LOAD_HELP_MESSAGE.c_str()));
} // namespace fdb_cli
