#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
/*
 * S3ClientWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/MockS3Server.h"

#include "fdbrpc/HTTP.h"
#include "fdbrpc/simulator.h"
#include "flow/Trace.h"
#include "flow/ActorCollection.h"
#include "flow/IRandom.h"
#include "flow/serialize.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/S3Client.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "flow/Platform.h"

#include <string>
#include <vector>
#include <libgen.h>

#include "flow/actorcompiler.h" // This must be the last #include.

// Test s3client operations against s3.
// Run this workload with ../build_output/bin/fdbserver -r simulation -f
// ../src/foundationdb/tests/slow/S3ClientWorkload.toml
struct S3ClientWorkload : TestWorkload {
	static constexpr auto NAME = "S3ClientWorkload";
	const bool enabled;
	bool pass;
	std::string s3Url;
	std::string credentials;
	std::string simfdbDir;

	S3ClientWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(true), pass(true) {
		s3Url = getOption(options, "s3Url"_sr, ""_sr).toString();
		if (s3Url.empty()) {
			// Default location for s3 instance.
			s3Url = "blobstore://127.0.0.1:8333";
		}
		simfdbDir = getOption(options, "simfdb"_sr, "simfdb"_sr).toString();
		// Place credentials file in the simulation root, NOT inside the server's data dir (simfdbDir)
		credentials = "S3ClientWorkload.blob-credentials.json";
	}
	~S3ClientWorkload() {
		if (pass) {
			TraceEvent("S3ClientWorkloadPass");
		} else {
			TraceEvent("S3ClientWorkloadFail");
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (!enabled)
			return Void();
		return _setup(this, cx);
	}

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

private:
	void setupCredentialsFile() {
		// Write the credentials file content -- hardcoded and nonsense for now. It just needs to be present.
		writeFile(
		    credentials,
		    "{\"accounts\":{\"@host\":{\"api_key\":\"seaweedfs\",\"secret\":\"tot4llys3cure\",\"token\":\"TOKEN\"}}}");

		// Set the credentials file path into the global network configuration
		auto* blobCredFiles = (std::vector<std::string>*)g_network->global(INetwork::enBlobCredentialFiles);
		if (!blobCredFiles) {
			blobCredFiles = new std::vector<std::string>();
			g_network->setGlobal(INetwork::enBlobCredentialFiles, blobCredFiles);
		}
		blobCredFiles->push_back(credentials);
	}

	// Add the basename of a file to the URL path
	static std::string addFileToUrl(std::string filePath, std::string baseUrl) {
		std::string basename = ::basename(const_cast<char*>(filePath.c_str()));

		// Parse the URL and append the basename to the path
		try {
			// Find the position after the host:port part
			size_t hostEnd = baseUrl.find('/', baseUrl.find("://") + 3);
			if (hostEnd == std::string::npos) {
				hostEnd = baseUrl.length();
			}

			// Find the query string start
			size_t queryStart = baseUrl.find('?', hostEnd);
			if (queryStart == std::string::npos) {
				queryStart = baseUrl.length();
			}

			// Get the current path
			std::string currentPath = baseUrl.substr(hostEnd, queryStart - hostEnd);
			if (!currentPath.empty() && currentPath.back() != '/') {
				currentPath += '/';
			}

			// Construct the new URL
			return baseUrl.substr(0, hostEnd) + currentPath + basename + baseUrl.substr(queryStart);
		} catch (Error& e) {
			TraceEvent(SevError, "S3ClientWorkloadURLParseError")
			    .error(e)
			    .detail("URL", baseUrl)
			    .detail("Path", filePath);
			throw;
		}
	}

																#line 135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
template <class _startActor>
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _startActorState {
															#line 141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_startActorState(S3ClientWorkload* const& self,Database const& cx) 
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		 : self(self),
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		   cx(cx)
															#line 150 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (self->clientId != 0)
															#line 165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			{
															#line 137 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (g_network->isSimulated())
															#line 177 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			{
															#line 143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				disableConnectionFailures("BulkLoading");
															#line 181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			}
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			download_path_to_clean = "downloaded_credentials";
															#line 185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			try {
															#line 150 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (fileExists(self->credentials))
															#line 189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
				{
															#line 151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					deleteFile(self->credentials);
															#line 152 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					TraceEvent(SevDebug, "S3ClientWorkloadCleanedPreExistingFile").detail("File", self->credentials);
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
				}
															#line 156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				platform::eraseDirectoryRecursive(download_path_to_clean);
															#line 157 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				TraceEvent(SevDebug, "S3ClientWorkloadAttemptedCleanPreExistingDownload") .detail("Path", download_path_to_clean);
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
				loopDepth = a_body1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uniqueRunDir = format("s3_workload_run_%08x_%08x", self->clientId, deterministicRandom()->randomInt(0, 1000000));
															#line 230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		try {
															#line 172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			platform::createDirectory(uniqueRunDir);
															#line 173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevDebug, "S3ClientWorkloadCreatedRunDir").detail("Dir", uniqueRunDir);
															#line 236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadPreCleanupError").errorUnsuppressed(e);
															#line 252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		self->credentials = joinPath(uniqueRunDir, "S3ClientWorkload.blob-credentials.json");
															#line 182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		download = joinPath(uniqueRunDir, "downloaded_credentials");
															#line 185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		self->setupCredentialsFile();
															#line 188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string baseFilename = ::basename(const_cast<char*>(self->credentials.c_str()));
															#line 192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string deterministicId = format("%08x_%08x", self->clientId, deterministicRandom()->randomInt(0, 1000000));
															#line 193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string uniqueObjectKey = baseFilename + "_" + deterministicId;
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		file_url = self->addFileToUrl(uniqueObjectKey, self->s3Url);
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = false;
															#line 196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		errorToThrow = Optional<Error>();
															#line 296 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		try {
															#line 200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(self->credentials, file_url);
															#line 200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1cont7Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont7when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadCreateRunDirError").errorUnsuppressed(e).detail("Dir", uniqueRunDir);
															#line 176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 325 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (errorToThrow.present())
															#line 352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		{
															#line 231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(errorToThrow.get(), loopDepth);
															#line 356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		}
															#line 236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string originalContent = readFileBytes(self->credentials, 1024 * 1024);
															#line 237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		std::string downloadedContent = readFileBytes(download, 1024 * 1024);
															#line 238 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (originalContent != downloadedContent)
															#line 364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		{
															#line 239 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadContentMismatch") .detailf("OriginalSize", "%zu", originalContent.size()) .detailf("DownloadedSize", "%zu", downloadedContent.size());
															#line 242 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 370 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		}
		try {
															#line 247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			deleteFile(self->credentials);
															#line 248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			deleteFile(download);
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevDebug, "S3ClientWorkloadCleanedLocalFiles") .detail("CredentialsFile", self->credentials) .detail("DownloadFile", download);
															#line 253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			platform::eraseDirectoryRecursive(uniqueRunDir);
															#line 254 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevDebug, "S3ClientWorkloadCleanedRunDir").detail("Dir", uniqueRunDir);
															#line 383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont10cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 205 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevError, "S3ClientWorkloadError") .error(e) .detail("S3URL", file_url) .detail("Path", self->credentials) .detail("Download", download);
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			errorToThrow = e;
															#line 215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (uploaded)
															#line 403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			{
				try {
															#line 217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_3 = deleteResource(file_url);
															#line 217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1Catch1(actor_cancelled(), loopDepth);
															#line 410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont7Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7Catch1when1(__when_expr_3.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont7Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont7Catch1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont7Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = true;
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = copyDownFile(file_url, download);
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont7Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		uploaded = true;
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = copyDownFile(file_url, download);
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont7Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = deleteResource(file_url);
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = deleteResource(file_url);
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1Catch1(const Error& cleanup_e,int loopDepth=0) 
	{
		try {
															#line 221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadS3CleanupError") .errorUnsuppressed(cleanup_e) .detail("S3URL", file_url);
															#line 772 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont7Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent(SevWarn, "S3ClientWorkloadCleanedS3AfterError").detail("S3URL", file_url);
															#line 787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont7Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1cont3(Void && _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent(SevWarn, "S3ClientWorkloadCleanedS3AfterError").detail("S3URL", file_url);
															#line 796 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont7Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			TraceEvent(SevWarn, "S3ClientWorkloadCleanupError").errorUnsuppressed(e);
															#line 906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	S3ClientWorkload* self;
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Database cx;
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string download_path_to_clean;
															#line 169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string uniqueRunDir;
															#line 182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string download;
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	std::string file_url;
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	bool uploaded;
															#line 196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Optional<Error> errorToThrow;
															#line 946 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 951 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7918814777552284160UL, 16211804278113649920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_startActor(S3ClientWorkload* const& self,Database const& cx) 
															#line 971 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
[[nodiscard]] Future<Void> _start( S3ClientWorkload* const& self, Database const& cx ) {
															#line 133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1006 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
}

#line 262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"

																#line 1011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
template <class _setupActor>
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _setupActorState {
															#line 1017 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
public:
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_setupActorState(S3ClientWorkload* const& self,Database const& cx) 
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		 : self(self),
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		   cx(cx)
															#line 1026 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
			if (self->clientId == 0)
															#line 1041 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				bool useMockS3 = self->s3Url.find("127.0.0.1") != std::string::npos || self->s3Url.find("localhost") != std::string::npos || self->s3Url.find("mock-s3-server") != std::string::npos;
															#line 271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
				if (useMockS3 && g_network->isSimulated())
															#line 1047 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
				{
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					TraceEvent("S3ClientWorkload").detail("Phase", "Registering MockS3Server").detail("URL", self->s3Url);
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer("127.0.0.1", "8080", makeReference<MockS3RequestHandler>());
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 1060 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 1093 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 1111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
		TraceEvent("S3ClientWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 1120 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	S3ClientWorkload* self;
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	Database cx;
															#line 1204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7826061478942974976UL, 14052062772740604416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	_setupActor(S3ClientWorkload* const& self,Database const& cx) 
															#line 1226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
[[nodiscard]] Future<Void> _setup( S3ClientWorkload* const& self, Database const& cx ) {
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/S3ClientWorkload.actor.g.cpp"
}

#line 286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/workloads/S3ClientWorkload.actor.cpp"
};

WorkloadFactory<S3ClientWorkload> S3ClientWorkloadFactory;
