#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
/*
 * MoveKeys.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <vector>
#include <limits.h>

#include "fdbclient/FDBOptions.g.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/TSSMappingUtil.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

template <typename... T>
static inline void dprint(fmt::format_string<T...> fmt, T&&... args) {
	if (g_network->isSimulated())
		fmt::print(fmt, std::forward<T>(args)...);
}

namespace {
struct Shard {
	Shard() = default;
	Shard(KeyRangeRef range, const UID& id) : range(range), id(id) {}

	KeyRange range;
	UID id;
};

bool shouldCreateCheckpoint(const UID& dataMoveId) {
	bool assigned, emptyRange;
	DataMoveType type;
	DataMovementReason reason;
	decodeDataMoveId(dataMoveId, assigned, emptyRange, type, reason);
	return (type == DataMoveType::PHYSICAL || type == DataMoveType::PHYSICAL_EXP);
}

// Unassigns keyrange `range` from server `ssId`, except ranges in `shards`.
// Note: krmSetRangeCoalescing() doesn't work in this case since each shard is assigned an ID.
															#line 67 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via unassignServerKeys()
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class UnassignServerKeysActor>
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class UnassignServerKeysActorState {
															#line 73 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UnassignServerKeysActorState(Transaction* const& tr,UID const& ssId,KeyRange const& range,std::vector<Shard> const& shards,UID const& logId) 
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ssId(ssId),
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   shards(shards),
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   logId(logId),
															#line 66 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   mapPrefix(serverKeysPrefixFor(ssId))
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("unassignServerKeys", reinterpret_cast<unsigned long>(this));

	}
	~UnassignServerKeysActorState() 
	{
		fdb_probe_actor_destroy("unassignServerKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shards.empty())
															#line 105 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = krmSetRangeCoalescing(tr, mapPrefix, range, allKeys, serverKeysFalse);
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnassignServerKeysActor, 0, Void >*>(static_cast<UnassignServerKeysActor*>(this)));
															#line 116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		withPrefix = KeyRangeRef(mapPrefix.toString() + range.begin.toString(), mapPrefix.toString() + range.end.toString());
															#line 74 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		maxWithPrefix = KeyRangeRef(mapPrefix.toString() + allKeys.begin.toString(), mapPrefix.toString() + allKeys.end.toString());
															#line 77 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = std::vector<Future<RangeResult>>();
															#line 78 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys.push_back( tr->getRange(lastLessThan(withPrefix.begin), firstGreaterOrEqual(withPrefix.begin), 1, Snapshot::True));
															#line 80 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys.push_back( tr->getRange(lastLessOrEqual(withPrefix.end), firstGreaterThan(withPrefix.end) + 1, 2, Snapshot::True));
															#line 82 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keys);
															#line 82 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnassignServerKeysActor, 1, Void >*>(static_cast<UnassignServerKeysActor*>(this)));
															#line 161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state > 0) static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UnassignServerKeysActor*>(this)->ActorCallback< UnassignServerKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnassignServerKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto beginRange = keys[0].get();
															#line 86 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : serverKeysFalse;
															#line 89 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key beginKey = withPrefix.begin;
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value value = range.begin == shards[0].range.begin ? serverKeysValue(shards[0].id) : serverKeysFalse;
															#line 91 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginValue == value)
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 93 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<KeyValue> kvs;
															#line 97 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginKey < withPrefix.begin)
															#line 291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(beginKey, value));
															#line 295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 100 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key preEnd = range.begin;
															#line 101 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size();++i) {
															#line 102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Shard& shard = shards[i];
															#line 103 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shard.range.begin > preEnd && (kvs.empty() || kvs.back().value != serverKeysFalse))
															#line 305 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 104 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 106 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			preEnd = shard.range.end;
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Value cv = serverKeysValue(shard.id);
															#line 108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (kvs.empty() || cv != kvs.back().value)
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(shard.range.begin.withPrefix(mapPrefix), cv));
															#line 321 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end > preEnd)
															#line 326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 113 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 330 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto endRange = keys[1].get();
															#line 118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 121 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : serverKeysFalse;
															#line 123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key endKey;
															#line 124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value endValue;
															#line 125 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const bool valueMatches = kvs.back().value == existingValue;
															#line 128 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (hasNext && endRange.back().key <= maxWithPrefix.end && valueMatches)
															#line 348 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endKey = endRange.back().key;
															#line 130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endValue = endRange.back().value;
															#line 354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (valueMatches)
															#line 360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = withPrefix.end;
															#line 142 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		kvs.push_back(KeyValueRef(endKey, endValue));
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size();++i) {
															#line 148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "UnassignServerKeys", logId) .detail("SSID", ssId) .detail("Range", range) .detail("Point", kvs[i]);
															#line 383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 158 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 160 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size() - 1;++i) {
															#line 167 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(kvs[i].value != kvs[i + 1].value || kvs[i + 1].key.removePrefix(mapPrefix) == allKeys.end);
															#line 168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i].key, kvs[i].value);
															#line 169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i + 1].key, kvs[i + 1].value);
															#line 415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto beginRange = keys[0].get();
															#line 86 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasBegin = beginRange.size() > 0 && beginRange[0].key.startsWith(mapPrefix);
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value beginValue = hasBegin ? beginRange[0].value : serverKeysFalse;
															#line 89 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key beginKey = withPrefix.begin;
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value value = range.begin == shards[0].range.begin ? serverKeysValue(shards[0].id) : serverKeysFalse;
															#line 91 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginValue == value)
															#line 441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool outsideRange = !hasBegin || beginRange[0].key < maxWithPrefix.begin;
															#line 93 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			beginKey = outsideRange ? maxWithPrefix.begin : beginRange[0].key;
															#line 447 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<KeyValue> kvs;
															#line 97 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (beginKey < withPrefix.begin)
															#line 453 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(beginKey, value));
															#line 457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 100 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key preEnd = range.begin;
															#line 101 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size();++i) {
															#line 102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Shard& shard = shards[i];
															#line 103 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (shard.range.begin > preEnd && (kvs.empty() || kvs.back().value != serverKeysFalse))
															#line 467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 104 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 471 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 106 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			preEnd = shard.range.end;
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Value cv = serverKeysValue(shard.id);
															#line 108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (kvs.empty() || cv != kvs.back().value)
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				kvs.push_back(KeyValueRef(shard.range.begin.withPrefix(mapPrefix), cv));
															#line 483 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (range.end > preEnd)
															#line 488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 113 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			kvs.push_back(KeyValueRef(preEnd.withPrefix(mapPrefix), serverKeysFalse));
															#line 492 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		auto endRange = keys[1].get();
															#line 118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasEnd = endRange.size() >= 1 && endRange[0].key.startsWith(mapPrefix) && endRange[0].key <= withPrefix.end;
															#line 119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool hasNext = (endRange.size() == 2 && endRange[1].key.startsWith(mapPrefix)) || (endRange.size() == 1 && withPrefix.end < endRange[0].key && endRange[0].key.startsWith(mapPrefix));
															#line 121 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value existingValue = hasEnd ? endRange[0].value : serverKeysFalse;
															#line 123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Key endKey;
															#line 124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		Value endValue;
															#line 125 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const bool valueMatches = kvs.back().value == existingValue;
															#line 128 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (hasNext && endRange.back().key <= maxWithPrefix.end && valueMatches)
															#line 510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endKey = endRange.back().key;
															#line 130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			endValue = endRange.back().value;
															#line 516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (valueMatches)
															#line 522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = maxWithPrefix.end;
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 528 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endKey = withPrefix.end;
															#line 142 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				endValue = existingValue;
															#line 536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		kvs.push_back(KeyValueRef(endKey, endValue));
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size();++i) {
															#line 148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "UnassignServerKeys", logId) .detail("SSID", ssId) .detail("Range", range) .detail("Point", kvs[i]);
															#line 545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		KeyRange conflictRange = KeyRangeRef(hasBegin ? beginRange[0].key : mapPrefix, withPrefix.begin);
															#line 155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 158 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		conflictRange = KeyRangeRef(hasEnd ? endRange[0].key : mapPrefix, hasNext ? keyAfter(endRange.end()[-1].key) : strinc(mapPrefix));
															#line 160 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!conflictRange.empty())
															#line 561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->addReadConflictRange(conflictRange);
															#line 565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr->clear(KeyRangeRef(beginKey, endKey));
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < kvs.size() - 1;++i) {
															#line 167 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(kvs[i].value != kvs[i + 1].value || kvs[i + 1].key.removePrefix(mapPrefix) == allKeys.end);
															#line 168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i].key, kvs[i].value);
															#line 169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(kvs[i + 1].key, kvs[i + 1].value);
															#line 577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<UnassignServerKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnassignServerKeysActorState(); static_cast<UnassignServerKeysActor*>(this)->destroy(); return 0; }
															#line 581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<UnassignServerKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnassignServerKeysActorState();
		static_cast<UnassignServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnassignServerKeysActor*>(this)->actor_wait_state > 0) static_cast<UnassignServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UnassignServerKeysActor*>(this)->ActorCallback< UnassignServerKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnassignServerKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnassignServerKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ssId;
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Shard> shards;
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID logId;
															#line 66 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key mapPrefix;
															#line 72 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange withPrefix;
															#line 74 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange maxWithPrefix;
															#line 77 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<RangeResult>> keys;
															#line 682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via unassignServerKeys()
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class UnassignServerKeysActor final : public Actor<Void>, public ActorCallback< UnassignServerKeysActor, 0, Void >, public ActorCallback< UnassignServerKeysActor, 1, Void >, public FastAllocated<UnassignServerKeysActor>, public UnassignServerKeysActorState<UnassignServerKeysActor> {
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<UnassignServerKeysActor>::operator new;
	using FastAllocated<UnassignServerKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1445152265819089920UL, 6224273296665352192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnassignServerKeysActor, 0, Void >;
friend struct ActorCallback< UnassignServerKeysActor, 1, Void >;
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UnassignServerKeysActor(Transaction* const& tr,UID const& ssId,KeyRange const& range,std::vector<Shard> const& shards,UID const& logId) 
															#line 705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   UnassignServerKeysActorState<UnassignServerKeysActor>(tr, ssId, range, shards, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unassignServerKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16965164928171750144UL, 12742658307583911936UL);
		ActorExecutionContextHelper __helper(static_cast<UnassignServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unassignServerKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unassignServerKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnassignServerKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnassignServerKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> unassignServerKeys( Transaction* const& tr, UID const& ssId, KeyRange const& range, std::vector<Shard> const& shards, UID const& logId ) {
															#line 65 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new UnassignServerKeysActor(tr, ssId, range, shards, logId));
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via deleteCheckpoints()
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class DeleteCheckpointsActor>
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class DeleteCheckpointsActorState {
															#line 749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DeleteCheckpointsActorState(Transaction* const& tr,std::set<UID> const& checkpointIds,UID const& dataMoveId) 
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   checkpointIds(checkpointIds),
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	~DeleteCheckpointsActorState() 
	{
		fdb_probe_actor_destroy("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!shouldCreateCheckpoint(dataMoveId))
															#line 775 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 177 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteCheckpointsActorState();
				static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoints", dataMoveId).detail("Checkpoints", describe(checkpointIds));
															#line 180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Optional<Value>>> checkpointEntries;
															#line 181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& id : checkpointIds ) {
															#line 182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				checkpointEntries.push_back(tr->get(checkpointKeyFor(id)));
															#line 793 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(checkpointEntries);
															#line 184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!value.present())
															#line 831 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound", dataMoveId);
															#line 835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				continue;
			}
															#line 192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(checkpointIds.find(checkpoint.checkpointID) != checkpointIds.end());
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(key, checkpointValue(checkpoint));
															#line 197 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->clear(singleKeyRange(key));
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint", dataMoveId).detail("Checkpoint", checkpoint.toString());
															#line 852 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 856 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!value.present())
															#line 872 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound", dataMoveId);
															#line 876 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				continue;
			}
															#line 192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(checkpointIds.find(checkpoint.checkpointID) != checkpointIds.end());
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(key, checkpointValue(checkpoint));
															#line 197 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->clear(singleKeyRange(key));
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint", dataMoveId).detail("Checkpoint", checkpoint.toString());
															#line 893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(checkpointValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(checkpointValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointsActor*>(this)->ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> checkpointIds;
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 986 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via deleteCheckpoints()
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class DeleteCheckpointsActor final : public Actor<Void>, public ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >, public FastAllocated<DeleteCheckpointsActor>, public DeleteCheckpointsActorState<DeleteCheckpointsActor> {
															#line 991 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<DeleteCheckpointsActor>::operator new;
	using FastAllocated<DeleteCheckpointsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3565596584825507584UL, 1016475324225755648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >;
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DeleteCheckpointsActor(Transaction* const& tr,std::set<UID> const& checkpointIds,UID const& dataMoveId) 
															#line 1008 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteCheckpointsActorState<DeleteCheckpointsActor>(tr, checkpointIds, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3647092636759606016UL, 17911147285598091008UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteCheckpoints");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> deleteCheckpoints( Transaction* const& tr, std::set<UID> const& checkpointIds, UID const& dataMoveId ) {
															#line 175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new DeleteCheckpointsActor(tr, checkpointIds, dataMoveId));
															#line 1040 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
} // namespace

bool DDEnabledState::sameId(const UID& id) const {
	return ddEnabledStatusUID == id;
}
bool DDEnabledState::isEnabled() const {
	return stateValue == ENABLED;
}

bool DDEnabledState::isBlobRestorePreparing() const {
	return stateValue == BLOB_RESTORE_PREPARING;
}

bool DDEnabledState::trySetSnapshot(UID requesterId) {
	ASSERT(requesterId != UID());
	// disabling DD
	if (!isEnabled()) {
		// only allow state modification to snapshot when DD is enabled.
		return false;
	}
	ddEnabledStatusUID = requesterId;
	stateValue = SNAPSHOT;
	TraceEvent("SetDDSnapshot").detail("RequesterUID", requesterId);

	return true;
}

bool DDEnabledState::trySetEnabled(UID requesterId) {
	ASSERT(requesterId != UID());
	// enabling DD
	if (!sameId(requesterId)) {
		// enabling DD not allowed if UID does not match with the previous request
		return false;
	}
	// reset to default status
	ddEnabledStatusUID = UID();
	stateValue = ENABLED;
	TraceEvent("SetDDEnabled").detail("RequesterUID", requesterId);
	return true;
}

bool DDEnabledState::trySetBlobRestorePreparing(UID requesterId) {
	ASSERT(requesterId != UID());
	if (!isEnabled()) {
		// only allow state modification to RestorePreparing when DD is enabled.
		return false;
	}
	ddEnabledStatusUID = requesterId;
	stateValue = BLOB_RESTORE_PREPARING;
	TraceEvent("SetDDBlobRestorePreparing").detail("RequesterUID", requesterId);
	return true;
}

															#line 1097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via readMoveKeysLock()
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ReadMoveKeysLockActor>
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActorState {
															#line 1104 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActorState(Transaction* const& tr,MoveKeysLock* const& lock) 
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock)
															#line 1113 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~ReadMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*>(static_cast<ReadMoveKeysLockActor*>(this)));
															#line 1136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMoveKeysLockActorState();
		static_cast<ReadMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1163 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<ReadMoveKeysLockActor*>(this)));
															#line 1168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && readVal,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont2(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor*>(this)->ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadMoveKeysLockActorState(); static_cast<ReadMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 1271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadMoveKeysLockActorState();
		static_cast<ReadMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> && readVal,int loopDepth) 
	{
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock->prevWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 1292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor*>(this)->ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock* lock;
															#line 1376 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via readMoveKeysLock()
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor final : public Actor<Void>, public ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >, public ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >, public FastAllocated<ReadMoveKeysLockActor>, public ReadMoveKeysLockActorState<ReadMoveKeysLockActor> {
															#line 1381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ReadMoveKeysLockActor>::operator new;
	using FastAllocated<ReadMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3513775368612955136UL, 5072666231453314560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >;
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor(Transaction* const& tr,MoveKeysLock* const& lock) 
															#line 1399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   ReadMoveKeysLockActorState<ReadMoveKeysLockActor>(tr, lock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18311156923523866624UL, 5785599686231584512UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> readMoveKeysLock( Transaction* const& tr, MoveKeysLock* const& lock ) {
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new ReadMoveKeysLockActor(tr, lock));
															#line 1433 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 1438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via readMoveKeysLock()
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ReadMoveKeysLockActor1>
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor1State {
															#line 1445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor1State(Database const& cx) 
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 1454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~ReadMoveKeysLockActor1State() 
	{
		fdb_probe_actor_destroy("readMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 1469 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			lock = MoveKeysLock();
															#line 273 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readMoveKeysLock(&tr, &lock);
															#line 275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 1;
															#line 275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor1, 0, Void >*>(static_cast<ReadMoveKeysLockActor1*>(this)));
															#line 1513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1537 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMoveKeysLockActor1, 1, Void >*>(static_cast<ReadMoveKeysLockActor1*>(this)));
															#line 1542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor1*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~ReadMoveKeysLockActor1State(); static_cast<ReadMoveKeysLockActor1*>(this)->destroy(); return 0; }
															#line 1557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor1*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ReadMoveKeysLockActor1*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~ReadMoveKeysLockActor1State(); static_cast<ReadMoveKeysLockActor1*>(this)->destroy(); return 0; }
															#line 1569 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ReadMoveKeysLockActor1*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~ReadMoveKeysLockActor1State();
		static_cast<ReadMoveKeysLockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor1*>(this)->ActorCallback< ReadMoveKeysLockActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "readMoveKeysLock retry");
															#line 1656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "readMoveKeysLock retry");
															#line 1665 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state > 0) static_cast<ReadMoveKeysLockActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadMoveKeysLockActor1*>(this)->ActorCallback< ReadMoveKeysLockActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMoveKeysLockActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via readMoveKeysLock()
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ReadMoveKeysLockActor1 final : public Actor<MoveKeysLock>, public ActorCallback< ReadMoveKeysLockActor1, 0, Void >, public ActorCallback< ReadMoveKeysLockActor1, 1, Void >, public FastAllocated<ReadMoveKeysLockActor1>, public ReadMoveKeysLockActor1State<ReadMoveKeysLockActor1> {
															#line 1756 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ReadMoveKeysLockActor1>::operator new;
	using FastAllocated<ReadMoveKeysLockActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3513775368612955136UL, 5072666231453314560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MoveKeysLock>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadMoveKeysLockActor1, 0, Void >;
friend struct ActorCallback< ReadMoveKeysLockActor1, 1, Void >;
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ReadMoveKeysLockActor1(Database const& cx) 
															#line 1774 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<MoveKeysLock>(),
		   ReadMoveKeysLockActor1State<ReadMoveKeysLockActor1>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9018890959737607424UL, 7351906858584551936UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMoveKeysLockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadMoveKeysLockActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<MoveKeysLock> readMoveKeysLock( Database const& cx ) {
															#line 268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<MoveKeysLock>(new ReadMoveKeysLockActor1(cx));
															#line 1808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 1813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via takeMoveKeysLock()
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class TakeMoveKeysLockActor>
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class TakeMoveKeysLockActorState {
															#line 1820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TakeMoveKeysLockActorState(Database const& cx,UID const& ddId) 
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddId(ddId),
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 1831 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("takeMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~TakeMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("takeMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 1846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			lock = MoveKeysLock();
															#line 289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			txnId = UID();
															#line 290 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!g_network->isSimulated())
															#line 1887 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				txnId = deterministicRandom()->randomUniqueID();
															#line 295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.debugTransaction(txnId);
															#line 1893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readMoveKeysLock(&tr, &lock);
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 0, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1928 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 3;
															#line 308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 2, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1933 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock.myOwner = deterministicRandom()->randomUniqueID();
															#line 299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(moveKeysLockOwnerKey, BinaryWriter::toValue(lock.myOwner, Unversioned()));
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 1, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1959 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		lock.myOwner = deterministicRandom()->randomUniqueID();
															#line 299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(moveKeysLockOwnerKey, BinaryWriter::toValue(lock.myOwner, Unversioned()));
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1974 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TakeMoveKeysLockActor, 1, Void >*>(static_cast<TakeMoveKeysLockActor*>(this)));
															#line 1979 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("TakeMoveKeysLockTransaction", ddId) .detail("TransactionUID", txnId) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<TakeMoveKeysLockActor*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~TakeMoveKeysLockActorState(); static_cast<TakeMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<TakeMoveKeysLockActor*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent("TakeMoveKeysLockTransaction", ddId) .detail("TransactionUID", txnId) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<TakeMoveKeysLockActor*>(this)->SAV<MoveKeysLock>::futures) { (void)(lock); this->~TakeMoveKeysLockActorState(); static_cast<TakeMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<TakeMoveKeysLockActor*>(this)->SAV< MoveKeysLock >::value()) MoveKeysLock(std::move(lock)); // state_var_RVO
		this->~TakeMoveKeysLockActorState();
		static_cast<TakeMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "takeMoveKeysLock retry");
															#line 2166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(true, "takeMoveKeysLock retry");
															#line 2175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<TakeMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<TakeMoveKeysLockActor*>(this)->ActorCallback< TakeMoveKeysLockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TakeMoveKeysLockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ddId;
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID txnId;
															#line 2265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via takeMoveKeysLock()
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class TakeMoveKeysLockActor final : public Actor<MoveKeysLock>, public ActorCallback< TakeMoveKeysLockActor, 0, Void >, public ActorCallback< TakeMoveKeysLockActor, 1, Void >, public ActorCallback< TakeMoveKeysLockActor, 2, Void >, public FastAllocated<TakeMoveKeysLockActor>, public TakeMoveKeysLockActorState<TakeMoveKeysLockActor> {
															#line 2270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<TakeMoveKeysLockActor>::operator new;
	using FastAllocated<TakeMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1696362431935055360UL, 9060248244964979456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MoveKeysLock>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TakeMoveKeysLockActor, 0, Void >;
friend struct ActorCallback< TakeMoveKeysLockActor, 1, Void >;
friend struct ActorCallback< TakeMoveKeysLockActor, 2, Void >;
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TakeMoveKeysLockActor(Database const& cx,UID const& ddId) 
															#line 2289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<MoveKeysLock>(),
		   TakeMoveKeysLockActorState<TakeMoveKeysLockActor>(cx, ddId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7589019723009657600UL, 17537804489524614912UL);
		ActorExecutionContextHelper __helper(static_cast<TakeMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("takeMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("takeMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TakeMoveKeysLockActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<MoveKeysLock> takeMoveKeysLock( Database const& cx, UID const& ddId ) {
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<MoveKeysLock>(new TakeMoveKeysLockActor(cx, ddId));
															#line 2324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 2329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
namespace {
// This generated class is to be used only via checkPersistentMoveKeysLock()
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckPersistentMoveKeysLockActor>
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckPersistentMoveKeysLockActorState {
															#line 2336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckPersistentMoveKeysLockActorState(Transaction* const& tr,MoveKeysLock const& lock,bool const& isWrite = true) 
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   isWrite(isWrite)
															#line 2347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~CheckPersistentMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 353 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (isWrite)
															#line 2418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 357 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->makeSelfConflicting();
															#line 2428 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2432 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckPersistentMoveKeysLockActorState();
				static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 365 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "checkMoveKeysLock: Conflict with new owner");
															#line 366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, "CheckPersistentMoveKeysLockOwnerConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString());
															#line 372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && readVal,int loopDepth) 
	{
															#line 318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2464 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*>(static_cast<CheckPersistentMoveKeysLockActor*>(this)));
															#line 2469 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 353 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (isWrite)
															#line 2480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 357 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					tr->makeSelfConflicting();
															#line 2490 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2494 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckPersistentMoveKeysLockActorState();
				static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 365 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "checkMoveKeysLock: Conflict with new owner");
															#line 366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, "CheckPersistentMoveKeysLockOwnerConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString());
															#line 372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2595 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 325 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "checkMoveKeysLock: Conflict with previous owner");
															#line 326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckPersistentMoveKeysWritterConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString()) .detail("Writer", lastWrite.toString());
															#line 333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (isWrite)
															#line 2607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrLastWrite << lastWriter;
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 345 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("CheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2625 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && readVal,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 325 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "checkMoveKeysLock: Conflict with previous owner");
															#line 326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckPersistentMoveKeysWritterConflict") .errorUnsuppressed(movekeys_conflict()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("CurrentOwner", currentOwner.toString()) .detail("Writer", lastWrite.toString());
															#line 333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (isWrite)
															#line 2655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			wrLastWrite << lastWriter;
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 345 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("CheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2673 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPersistentMoveKeysLockActorState(); static_cast<CheckPersistentMoveKeysLockActor*>(this)->destroy(); return 0; }
															#line 2677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckPersistentMoveKeysLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPersistentMoveKeysLockActorState();
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<CheckPersistentMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPersistentMoveKeysLockActor*>(this)->ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool isWrite;
															#line 318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID currentOwner;
															#line 2768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkPersistentMoveKeysLock()
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckPersistentMoveKeysLockActor final : public Actor<Void>, public ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >, public ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >, public FastAllocated<CheckPersistentMoveKeysLockActor>, public CheckPersistentMoveKeysLockActorState<CheckPersistentMoveKeysLockActor> {
															#line 2773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckPersistentMoveKeysLockActor>::operator new;
	using FastAllocated<CheckPersistentMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9545948837380814080UL, 18230842853152168448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >;
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckPersistentMoveKeysLockActor(Transaction* const& tr,MoveKeysLock const& lock,bool const& isWrite = true) 
															#line 2791 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckPersistentMoveKeysLockActorState<CheckPersistentMoveKeysLockActor>(tr, lock, isWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6644785154087050496UL, 6768596532248216832UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPersistentMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPersistentMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPersistentMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPersistentMoveKeysLockActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPersistentMoveKeysLockActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> checkPersistentMoveKeysLock( Transaction* const& tr, MoveKeysLock const& lock, bool const& isWrite = true ) {
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckPersistentMoveKeysLockActor(tr, lock, isWrite));
															#line 2825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 375 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

Future<Void> checkMoveKeysLock(Transaction* tr,
                               MoveKeysLock const& lock,
                               const DDEnabledState* ddEnabledState,
                               bool isWrite) {
	if (!ddEnabledState->isEnabled()) {
		TraceEvent(SevDebug, "DDDisabledByInMemoryCheck").log();
		throw movekeys_conflict();
	}
	return checkPersistentMoveKeysLock(tr, lock, isWrite);
}

Future<Void> checkMoveKeysLockReadOnly(Transaction* tr, MoveKeysLock lock, const DDEnabledState* ddEnabledState) {
	return checkMoveKeysLock(tr, lock, ddEnabledState, false);
}

namespace {
															#line 2846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkReadWrite()
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckReadWriteActor>
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckReadWriteActorState {
															#line 2852 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckReadWriteActorState(Future<ErrorOr<GetShardStateReply>> const& fReply,UID const& uid,Version const& version) 
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : fReply(fReply),
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   uid(uid),
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   version(version)
															#line 2863 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkReadWrite", reinterpret_cast<unsigned long>(this));

	}
	~CheckReadWriteActorState() 
	{
		fdb_probe_actor_destroy("checkReadWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<ErrorOr<GetShardStateReply>> __when_expr_0 = fReply;
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckReadWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2880 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckReadWriteActor*>(this)->actor_wait_state = 1;
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*>(static_cast<CheckReadWriteActor*>(this)));
															#line 2885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<GetShardStateReply> const& reply,int loopDepth) 
	{
															#line 394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!reply.present() || reply.get().first < version)
															#line 2908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>()); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>());
			this->~CheckReadWriteActorState();
			static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>(uid)); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>(uid));
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<GetShardStateReply> && reply,int loopDepth) 
	{
															#line 394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!reply.present() || reply.get().first < version)
															#line 2932 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>()); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>());
			this->~CheckReadWriteActorState();
			static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckReadWriteActor*>(this)->SAV<Optional<UID>>::futures) { (void)(Optional<UID>(uid)); this->~CheckReadWriteActorState(); static_cast<CheckReadWriteActor*>(this)->destroy(); return 0; }
															#line 2944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckReadWriteActor*>(this)->SAV< Optional<UID> >::value()) Optional<UID>(Optional<UID>(uid));
		this->~CheckReadWriteActorState();
		static_cast<CheckReadWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<GetShardStateReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<GetShardStateReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckReadWriteActor*>(this)->actor_wait_state > 0) static_cast<CheckReadWriteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckReadWriteActor*>(this)->ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,ErrorOr<GetShardStateReply> const& value) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,ErrorOr<GetShardStateReply> && value) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*,Error err) 
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<ErrorOr<GetShardStateReply>> fReply;
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID uid;
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version version;
															#line 3033 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkReadWrite()
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckReadWriteActor final : public Actor<Optional<UID>>, public ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >, public FastAllocated<CheckReadWriteActor>, public CheckReadWriteActorState<CheckReadWriteActor> {
															#line 3038 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckReadWriteActor>::operator new;
	using FastAllocated<CheckReadWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8523203063935099392UL, 10888180247313356032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >;
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckReadWriteActor(Future<ErrorOr<GetShardStateReply>> const& fReply,UID const& uid,Version const& version) 
															#line 3055 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Optional<UID>>(),
		   CheckReadWriteActorState<CheckReadWriteActor>(fReply, uid, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkReadWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12330645937060475904UL, 6831126454717508352UL);
		ActorExecutionContextHelper __helper(static_cast<CheckReadWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkReadWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkReadWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckReadWriteActor, 0, ErrorOr<GetShardStateReply> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Optional<UID>> checkReadWrite( Future<ErrorOr<GetShardStateReply>> const& fReply, UID const& uid, Version const& version ) {
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Optional<UID>>(new CheckReadWriteActor(fReply, uid, version));
															#line 3087 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 398 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Must propagate corruption signal to outside
															#line 3093 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via validateRangeAssignment()
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class ValidateRangeAssignmentActor>
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ValidateRangeAssignmentActorState {
															#line 3099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ValidateRangeAssignmentActorState(Database const& occ,Transaction* const& tr,KeyRange const& range,UID const& ssid,std::string const& context,UID const& dataMoveId) 
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ssid(ssid),
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 3116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("validateRangeAssignment", reinterpret_cast<unsigned long>(this));

	}
	~ValidateRangeAssignmentActorState() 
	{
		fdb_probe_actor_destroy("validateRangeAssignment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!range.empty());
															#line 407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = range.begin;
															#line 408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allCorrect = true;
															#line 409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 3139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateRangeAssignmentActorState();
		static_cast<ValidateRangeAssignmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 453 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			try {
															#line 457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success(setDDMode(occ, 2));
															#line 457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 2;
															#line 457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateRangeAssignmentActor, 1, Void >*>(static_cast<ValidateRangeAssignmentActor*>(this)));
															#line 3174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, serverKeysPrefixFor(ssid), KeyRangeRef(toReadRangeBegin, range.end), CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 1;
															#line 411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*>(static_cast<ValidateRangeAssignmentActor*>(this)));
															#line 3208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& readResult,int loopDepth) 
	{
															#line 417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;i++) {
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID shardId;
															#line 419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool assigned, emptyRange;
															#line 420 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeServerKeysValue(readResult[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!assigned)
															#line 3242 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "ValidateRangeAssignmentCorruptionDetected") .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("AuditRange", range) .detail("ErrorMessage", "KeyServers has range but ServerKeys does not have") .detail("CurrentEmptyRange", emptyRange) .detail("CurrentAssignment", assigned) .detail("DataMoveType", static_cast<uint8_t>(dataMoveType)) .detail("ServerID", ssid) .detail("ShardID", shardId);
															#line 436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allCorrect = false;
															#line 3248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResult.back().key < range.end)
															#line 3259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = readResult.back().key;
															#line 444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentMultipleReads") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && readResult,int loopDepth) 
	{
															#line 417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;i++) {
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID shardId;
															#line 419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool assigned, emptyRange;
															#line 420 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeServerKeysValue(readResult[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!assigned)
															#line 3291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "ValidateRangeAssignmentCorruptionDetected") .setMaxFieldLength(-1) .setMaxEventLength(-1) .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("AuditRange", range) .detail("ErrorMessage", "KeyServers has range but ServerKeys does not have") .detail("CurrentEmptyRange", emptyRange) .detail("CurrentAssignment", assigned) .detail("DataMoveType", static_cast<uint8_t>(dataMoveType)) .detail("ServerID", ssid) .detail("ShardID", shardId);
															#line 436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allCorrect = false;
															#line 3297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!allCorrect)
															#line 3302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResult.back().key < range.end)
															#line 3308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			toReadRangeBegin = readResult.back().key;
															#line 444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentMultipleReads") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(readResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(readResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state > 0) static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateRangeAssignmentActor*>(this)->ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 470 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<ValidateRangeAssignmentActor*>(this)->SAV<bool>::futures) { (void)(allCorrect); this->~ValidateRangeAssignmentActorState(); static_cast<ValidateRangeAssignmentActor*>(this)->destroy(); return 0; }
															#line 3403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<ValidateRangeAssignmentActor*>(this)->SAV< bool >::value()) bool(std::move(allCorrect)); // state_var_RVO
		this->~ValidateRangeAssignmentActorState();
		static_cast<ValidateRangeAssignmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "ValidateRangeAssignmentCorruptionDetectedButFailedToStopDD") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "ValidateRangeAssignmentCorruptionDetectedAndDDStopped") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "ValidateRangeAssignmentCorruptionDetectedAndDDStopped") .detail("DataMoveID", dataMoveId) .detail("Range", range) .detail("StorageServer", ssid);
															#line 3446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state > 0) static_cast<ValidateRangeAssignmentActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateRangeAssignmentActor*>(this)->ActorCallback< ValidateRangeAssignmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateRangeAssignmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID ssid;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key toReadRangeBegin;
															#line 408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool allCorrect;
															#line 3555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via validateRangeAssignment()
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class ValidateRangeAssignmentActor final : public Actor<bool>, public ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >, public ActorCallback< ValidateRangeAssignmentActor, 1, Void >, public FastAllocated<ValidateRangeAssignmentActor>, public ValidateRangeAssignmentActorState<ValidateRangeAssignmentActor> {
															#line 3560 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<ValidateRangeAssignmentActor>::operator new;
	using FastAllocated<ValidateRangeAssignmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1414627072544906496UL, 10149272965099424768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >;
friend struct ActorCallback< ValidateRangeAssignmentActor, 1, Void >;
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	ValidateRangeAssignmentActor(Database const& occ,Transaction* const& tr,KeyRange const& range,UID const& ssid,std::string const& context,UID const& dataMoveId) 
															#line 3578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<bool>(),
		   ValidateRangeAssignmentActorState<ValidateRangeAssignmentActor>(occ, tr, range, ssid, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateRangeAssignment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1410897700964751360UL, 1906203362245434880UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateRangeAssignmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateRangeAssignment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateRangeAssignment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateRangeAssignmentActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateRangeAssignmentActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<bool> validateRangeAssignment( Database const& occ, Transaction* const& tr, KeyRange const& range, UID const& ssid, std::string const& context, UID const& dataMoveId ) {
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<bool>(new ValidateRangeAssignmentActor(occ, tr, range, ssid, context, dataMoveId));
															#line 3611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 3616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via auditLocationMetadataPreCheck()
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AuditLocationMetadataPreCheckActor>
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPreCheckActorState {
															#line 3622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPreCheckActorState(Database const& occ,Transaction* const& tr,KeyRange const& range,std::vector<UID> const& servers,std::string const& context,UID const& dataMoveId) 
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 3639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this));

	}
	~AuditLocationMetadataPreCheckActorState() 
	{
		fdb_probe_actor_destroy("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (range.empty())
															#line 3654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "CheckLocationMetadataEmptyInputRange").detail("By", "PreCheck").detail("Range", range);
															#line 481 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPreCheckActorState(); static_cast<AuditLocationMetadataPreCheckActor*>(this)->destroy(); return 0; }
															#line 3660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditLocationMetadataPreCheckActorState();
				static_cast<AuditLocationMetadataPreCheckActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 483 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors = std::vector<Future<Void>>();
															#line 484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results = std::unordered_map<UID, Optional<bool>>();
															#line 485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataStart") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3672 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			try {
															#line 492 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.clear();
															#line 493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				results.clear();
															#line 494 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& ssid : servers ) {
															#line 495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					actors.push_back(store(results[ssid], validateRangeAssignment(occ, tr, range, ssid, context, dataMoveId)));
															#line 3682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAllReadyThenThrow(actors);
															#line 497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state = 1;
															#line 497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*>(static_cast<AuditLocationMetadataPreCheckActor*>(this)));
															#line 3693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditLocationMetadataPreCheckActorState();
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPreCheckActorState(); static_cast<AuditLocationMetadataPreCheckActor*>(this)->destroy(); return 0; }
															#line 3722 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AuditLocationMetadataPreCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditLocationMetadataPreCheckActorState();
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_location_metadata_corruption)
															#line 3735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 518 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 520 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevInfo, "CheckLocationMetadataFailed") .errorUnsuppressed(e) .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& [ssid, res] : results ) {
															#line 528 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (res.present() && !res.get())
															#line 3749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						TraceEvent(SevError, "CheckLocationMetadataCorruptionDetectedWhenFailed") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1Catch1(location_metadata_corruption(), loopDepth);
															#line 3755 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [ssid, res] : results ) {
															#line 499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 3777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "CheckLocationMetadataCorruptionDetected") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(location_metadata_corruption(), loopDepth);
															#line 3783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [ssid, res] : results ) {
															#line 499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 3801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "CheckLocationMetadataCorruptionDetected") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(location_metadata_corruption(), loopDepth);
															#line 3807 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PreCheck") .detail("DataMoveID", dataMoveId) .detail("Servers", describe(servers)) .detail("Context", context) .detail("Range", range);
															#line 3812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPreCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPreCheckActor*>(this)->ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 483 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_map<UID, Optional<bool>> results;
															#line 3921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via auditLocationMetadataPreCheck()
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPreCheckActor final : public Actor<Void>, public ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >, public FastAllocated<AuditLocationMetadataPreCheckActor>, public AuditLocationMetadataPreCheckActorState<AuditLocationMetadataPreCheckActor> {
															#line 3926 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AuditLocationMetadataPreCheckActor>::operator new;
	using FastAllocated<AuditLocationMetadataPreCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5809097207806836736UL, 15984573663119165952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >;
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPreCheckActor(Database const& occ,Transaction* const& tr,KeyRange const& range,std::vector<UID> const& servers,std::string const& context,UID const& dataMoveId) 
															#line 3943 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   AuditLocationMetadataPreCheckActorState<AuditLocationMetadataPreCheckActor>(occ, tr, range, servers, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14141982025076651776UL, 5931598278174956800UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPreCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditLocationMetadataPreCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditLocationMetadataPreCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditLocationMetadataPreCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> auditLocationMetadataPreCheck( Database const& occ, Transaction* const& tr, KeyRange const& range, std::vector<UID> const& servers, std::string const& context, UID const& dataMoveId ) {
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new AuditLocationMetadataPreCheckActor(occ, tr, range, servers, context, dataMoveId));
															#line 3975 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 3980 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via auditLocationMetadataPostCheck()
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AuditLocationMetadataPostCheckActor>
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPostCheckActorState {
															#line 3986 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPostCheckActorState(Database const& occ,KeyRange const& range,std::string const& context,UID const& dataMoveId) 
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range),
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   context(context),
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId)
															#line 3999 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this));

	}
	~AuditLocationMetadataPostCheckActorState() 
	{
		fdb_probe_actor_destroy("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (range.empty())
															#line 4014 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "CheckLocationMetadataEmptyInputRange") .detail("By", "PostCheck") .detail("Range", range) .detail("Context", context) .detail("DataMoveId", dataMoveId.toString());
															#line 551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPostCheckActorState(); static_cast<AuditLocationMetadataPostCheckActor*>(this)->destroy(); return 0; }
															#line 4020 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditLocationMetadataPostCheckActorState();
				static_cast<AuditLocationMetadataPostCheckActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors = std::vector<Future<Void>>();
															#line 554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results = std::unordered_map<uint64_t, Optional<bool>>();
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = range.begin;
															#line 556 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readResultKS = RangeResult();
															#line 557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UIDtoTagMap = RangeResult();
															#line 558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr = Transaction(occ);
															#line 559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retryCount = 0;
															#line 560 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataStart") .detail("By", "PostCheck") .detail("Context", context) .detail("Range", range);
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4044 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditLocationMetadataPostCheckActorState();
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditLocationMetadataPostCheckActorState(); static_cast<AuditLocationMetadataPostCheckActor*>(this)->destroy(); return 0; }
															#line 4067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AuditLocationMetadataPostCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditLocationMetadataPostCheckActorState();
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 566 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4087 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_location_metadata_corruption)
															#line 4122 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 636 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( const auto& [idx, res] : results ) {
															#line 640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (res.present() && !res.get())
															#line 4134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						TraceEvent(SevError, "CheckLocationMetadataCorruptionDetectedWhenFailed") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 646 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 4140 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
															#line 649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (retryCount > SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK_RETRY_COUNT_MAX)
															#line 4145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevInfo, "CheckLocationMetadataFailed") .errorUnsuppressed(e) .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
				else
				{
															#line 658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4158 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
					static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 4;
															#line 658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4163 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 568 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.clear();
															#line 569 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readResultKS.clear();
															#line 570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			results.clear();
															#line 571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(store(readResultKS, krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(rangeToReadBegin, range.end), CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES)));
															#line 581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(store(UIDtoTagMap, tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY)));
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 1;
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4254 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 3;
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataReadDone") .detail("By", "PostCheck") .detail("ResultSize", readResultKS.size());
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors.clear();
															#line 589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		resIdx = 0;
															#line 590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResultKS.size() - 1;++i) {
															#line 591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcID;
															#line 594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destID;
															#line 595 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResultKS[i].value, src, dest, srcID, destID);
															#line 596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( store(results[resIdx], validateRangeAssignment(occ, &tr, KeyRangeRef(readResultKS[i].key, readResultKS[i + 1].key), ssid, context, dataMoveId)));
															#line 607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				++resIdx;
															#line 4302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAllReadyThenThrow(actors);
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 2;
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevVerbose, "CheckLocationMetadataReadDone") .detail("By", "PostCheck") .detail("ResultSize", readResultKS.size());
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors.clear();
															#line 589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		resIdx = 0;
															#line 590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < readResultKS.size() - 1;++i) {
															#line 591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcID;
															#line 594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destID;
															#line 595 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResultKS[i].value, src, dest, srcID, destID);
															#line 596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( store(results[resIdx], validateRangeAssignment(occ, &tr, KeyRangeRef(readResultKS[i].key, readResultKS[i + 1].key), ssid, context, dataMoveId)));
															#line 607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				++resIdx;
															#line 4351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAllReadyThenThrow(actors);
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 2;
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*>(static_cast<AuditLocationMetadataPostCheckActor*>(this)));
															#line 4363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [idx, res] : results ) {
															#line 612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 613 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 4451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 614 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(location_metadata_corruption(), loopDepth);
															#line 4455 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResultKS.back().key < range.end)
															#line 4460 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 618 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = readResultKS.back().key;
															#line 4464 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 621 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4471 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& [idx, res] : results ) {
															#line 612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(res.present());
															#line 613 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!res.get())
															#line 4485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 614 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(location_metadata_corruption(), loopDepth);
															#line 4489 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readResultKS.back().key < range.end)
															#line 4494 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 618 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			rangeToReadBegin = readResultKS.back().key;
															#line 4498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 621 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckLocationMetadataComplete") .detail("By", "PostCheck") .detail("DataMoveID", dataMoveId) .detail("Context", context) .detail("Range", range);
															#line 4505 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retryCount++;
															#line 4704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state > 0) static_cast<AuditLocationMetadataPostCheckActor*>(this)->actor_wait_state = 0;
		static_cast<AuditLocationMetadataPostCheckActor*>(this)->ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange range;
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::string context;
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_map<uint64_t, Optional<bool>> results;
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key rangeToReadBegin;
															#line 556 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult readResultKS;
															#line 557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retryCount;
															#line 589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	uint64_t resIdx;
															#line 4808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via auditLocationMetadataPostCheck()
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AuditLocationMetadataPostCheckActor final : public Actor<Void>, public ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >, public ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >, public FastAllocated<AuditLocationMetadataPostCheckActor>, public AuditLocationMetadataPostCheckActorState<AuditLocationMetadataPostCheckActor> {
															#line 4813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AuditLocationMetadataPostCheckActor>::operator new;
	using FastAllocated<AuditLocationMetadataPostCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11284046121667145216UL, 6977722778263149824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >;
friend struct ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >;
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AuditLocationMetadataPostCheckActor(Database const& occ,KeyRange const& range,std::string const& context,UID const& dataMoveId) 
															#line 4833 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   AuditLocationMetadataPostCheckActorState<AuditLocationMetadataPostCheckActor>(occ, range, context, dataMoveId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2581926754743871744UL, 6396892187787654656UL);
		ActorExecutionContextHelper __helper(static_cast<AuditLocationMetadataPostCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditLocationMetadataPostCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditLocationMetadataPostCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditLocationMetadataPostCheckActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> auditLocationMetadataPostCheck( Database const& occ, KeyRange const& range, std::string const& context, UID const& dataMoveId ) {
															#line 544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new AuditLocationMetadataPostCheckActor(occ, range, context, dataMoveId));
															#line 4868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Cleans up dest servers of a single shard, and unassigns the keyrange from the dest servers if necessary.
															#line 4874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via cleanUpSingleShardDataMove()
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CleanUpSingleShardDataMoveActor>
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CleanUpSingleShardDataMoveActorState {
															#line 4880 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CleanUpSingleShardDataMoveActorState(Database const& occ,KeyRange const& keys,MoveKeysLock const& lock,FlowLock* const& cleanUpDataMoveParallelismLock,UID const& dataMoveId,const DDEnabledState* const& ddEnabledState) 
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   cleanUpDataMoveParallelismLock(cleanUpDataMoveParallelismLock),
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState)
															#line 4897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this));

	}
	~CleanUpSingleShardDataMoveActorState() 
	{
		fdb_probe_actor_destroy("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "CleanUpSingleShardDataMoveBegin", dataMoveId).detail("Range", keys);
															#line 677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			runPreCheck = true;
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 4918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanUpSingleShardDataMoveActorState();
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 762 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "CleanUpSingleShardDataMoveEnd", dataMoveId).detail("Range", keys);
															#line 764 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanUpSingleShardDataMoveActorState(); static_cast<CleanUpSingleShardDataMoveActor*>(this)->destroy(); return 0; }
															#line 4943 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanUpSingleShardDataMoveActorState();
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 4962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 684 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, keys, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4974 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 1;
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 4979 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = e;
															#line 749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (err.code() == error_code_location_metadata_corruption)
															#line 5016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 750 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 5020 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				runPreCheck = false;
															#line 753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(err);
															#line 753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5030 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 7;
															#line 753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5035 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!currentShards.empty() && !currentShards.more);
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5055 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 2;
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5060 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __currentShards,int loopDepth) 
	{
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentShards = __currentShards;
															#line 5069 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __currentShards,int loopDepth) 
	{
		currentShards = std::move(__currentShards);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (KeyRangeRef(currentShards[0].key, currentShards[1].key) != keys)
															#line 5150 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 698 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1loopBody1Catch1(operation_cancelled(), loopDepth);
															#line 5154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, currentShards[0].value, src, dest, srcId, destId);
															#line 707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dest.empty() || destId != anonymousShardId)
															#line 5168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanUpSingleShardDataMoveActorState(); static_cast<CleanUpSingleShardDataMoveActor*>(this)->destroy(); return 0; }
															#line 5172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<CleanUpSingleShardDataMoveActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CleanUpSingleShardDataMoveActorState();
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 5180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = auditLocationMetadataPreCheck( occ, &tr, keys, servers, "cleanUpSingleShardDataMove_precheck", dataMoveId);
															#line 715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5190 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 3;
															#line 715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 5209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "CleanUpSingleShardDataMove", dataMoveId) .detail("Range", keys) .detail("Src", describe(src)) .detail("Dest", describe(dest)) .detail("SrcID", srcId) .detail("DestID", destId) .detail("ReadVersion", tr.getReadVersion().get());
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		krmSetPreviouslyEmptyRange( &tr, keyServersPrefix, keys, keyServersValue(UIDtoTagMap, src, {}), currentShards[1].value);
															#line 730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& uid : dest ) {
															#line 732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(src.begin(), src.end(), uid) == src.end())
															#line 5296 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(uid), keys, allKeys, serverKeysFalse));
															#line 5300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(actors);
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 4;
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 5;
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 5;
															#line 740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 5515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_5 = auditLocationMetadataPostCheck(occ, keys, "cleanUpSingleShardDataMove_postcheck", dataMoveId);
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 6;
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 5540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_5 = auditLocationMetadataPostCheck(occ, keys, "cleanUpSingleShardDataMove_postcheck", dataMoveId);
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
			static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 6;
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*>(static_cast<CleanUpSingleShardDataMoveActor*>(this)));
															#line 5551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 756 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarn, "CleanUpSingleShardDataMoveRetriableError", dataMoveId) .error(err) .detail("Range", keys);
															#line 5733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state > 0) static_cast<CleanUpSingleShardDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<CleanUpSingleShardDataMoveActor*>(this)->ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* cleanUpDataMoveParallelismLock;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool runPreCheck;
															#line 680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult currentShards;
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID srcId;
															#line 704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID destId;
															#line 748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 5855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via cleanUpSingleShardDataMove()
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CleanUpSingleShardDataMoveActor final : public Actor<Void>, public ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >, public ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >, public ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >, public ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >, public FastAllocated<CleanUpSingleShardDataMoveActor>, public CleanUpSingleShardDataMoveActorState<CleanUpSingleShardDataMoveActor> {
															#line 5860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CleanUpSingleShardDataMoveActor>::operator new;
	using FastAllocated<CleanUpSingleShardDataMoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7976289734130125824UL, 6174915124351481600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >;
friend struct ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CleanUpSingleShardDataMoveActor(Database const& occ,KeyRange const& keys,MoveKeysLock const& lock,FlowLock* const& cleanUpDataMoveParallelismLock,UID const& dataMoveId,const DDEnabledState* const& ddEnabledState) 
															#line 5883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CleanUpSingleShardDataMoveActorState<CleanUpSingleShardDataMoveActor>(occ, keys, lock, cleanUpDataMoveParallelismLock, dataMoveId, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5109264975150891520UL, 10929003504954912000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanUpSingleShardDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanUpSingleShardDataMove");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanUpSingleShardDataMove", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CleanUpSingleShardDataMoveActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> cleanUpSingleShardDataMove( Database const& occ, KeyRange const& keys, MoveKeysLock const& lock, FlowLock* const& cleanUpDataMoveParallelismLock, UID const& dataMoveId, const DDEnabledState* const& ddEnabledState ) {
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CleanUpSingleShardDataMoveActor(occ, keys, lock, cleanUpDataMoveParallelismLock, dataMoveId, ddEnabledState));
															#line 5921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

Future<Void> removeOldDestinations(Reference<ReadYourWritesTransaction> tr,
                                   UID oldDest,
                                   VectorRef<KeyRangeRef> shards,
                                   KeyRangeRef currentKeys) {
	KeyRef beginKey = currentKeys.begin;

	std::vector<Future<Void>> actors;
	for (int i = 0; i < shards.size(); i++) {
		if (beginKey < shards[i].begin)
			actors.push_back(krmSetRangeCoalescing(
			    tr, serverKeysPrefixFor(oldDest), KeyRangeRef(beginKey, shards[i].begin), allKeys, serverKeysFalse));

		beginKey = shards[i].end;
	}

	if (beginKey < currentKeys.end)
		actors.push_back(krmSetRangeCoalescing(
		    tr, serverKeysPrefixFor(oldDest), KeyRangeRef(beginKey, currentKeys.end), allKeys, serverKeysFalse));

	return waitForAll(actors);
}

															#line 5948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via addReadWriteDestinations()
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AddReadWriteDestinationsActor>
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AddReadWriteDestinationsActorState {
															#line 5954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AddReadWriteDestinationsActorState(KeyRangeRef const& shard,std::vector<StorageServerInterface> const& srcInterfs,std::vector<StorageServerInterface> const& destInterfs,Version const& version,int const& desiredHealthy,int const& maxServers) 
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : shard(shard),
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   srcInterfs(srcInterfs),
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destInterfs(destInterfs),
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   version(version),
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   desiredHealthy(desiredHealthy),
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   maxServers(maxServers)
															#line 5971 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("addReadWriteDestinations", reinterpret_cast<unsigned long>(this));

	}
	~AddReadWriteDestinationsActorState() 
	{
		fdb_probe_actor_destroy("addReadWriteDestinations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 795 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (srcInterfs.size() >= maxServers)
															#line 5986 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 796 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(std::vector<UID>()); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 5990 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(std::vector<UID>());
				this->~AddReadWriteDestinationsActorState();
				static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcChecks = std::vector<Future<Optional<UID>>>();
															#line 800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcChecks.reserve(srcInterfs.size());
															#line 801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < srcInterfs.size();s++) {
															#line 802 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcChecks.push_back(checkReadWrite(srcInterfs[s].getShardState.getReplyUnlessFailedFor( GetShardStateRequest(shard, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), srcInterfs[s].id(), 0));
															#line 6004 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 811 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			destChecks = std::vector<Future<Optional<UID>>>();
															#line 812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			destChecks.reserve(destInterfs.size());
															#line 813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < destInterfs.size();s++) {
															#line 814 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				destChecks.push_back(checkReadWrite(destInterfs[s].getShardState.getReplyUnlessFailedFor( GetShardStateRequest(shard, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), destInterfs[s].id(), version));
															#line 6014 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(srcChecks) && waitForAll(destChecks);
															#line 823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6020 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state = 1;
															#line 823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddReadWriteDestinationsActor, 0, Void >*>(static_cast<AddReadWriteDestinationsActor*>(this)));
															#line 6025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int healthySrcs = 0;
															#line 826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto it : srcChecks ) {
															#line 827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6052 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				healthySrcs++;
															#line 6056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 832 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 833 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int totalDesired = std::min<int>(desiredHealthy - healthySrcs, maxServers - srcInterfs.size());
															#line 834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < destInterfs.size() && result.size() < totalDesired;s++) {
															#line 835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destChecks[s].get().present())
															#line 6067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(destChecks[s].get().get());
															#line 6071 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 6076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int healthySrcs = 0;
															#line 826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto it : srcChecks ) {
															#line 827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				healthySrcs++;
															#line 6096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 832 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 833 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int totalDesired = std::min<int>(desiredHealthy - healthySrcs, maxServers - srcInterfs.size());
															#line 834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < destInterfs.size() && result.size() < totalDesired;s++) {
															#line 835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destChecks[s].get().present())
															#line 6107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(destChecks[s].get().get());
															#line 6111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AddReadWriteDestinationsActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~AddReadWriteDestinationsActorState(); static_cast<AddReadWriteDestinationsActor*>(this)->destroy(); return 0; }
															#line 6116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AddReadWriteDestinationsActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~AddReadWriteDestinationsActorState();
		static_cast<AddReadWriteDestinationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state > 0) static_cast<AddReadWriteDestinationsActor*>(this)->actor_wait_state = 0;
		static_cast<AddReadWriteDestinationsActor*>(this)->ActorCallback< AddReadWriteDestinationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddReadWriteDestinationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef shard;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> srcInterfs;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> destInterfs;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version version;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int desiredHealthy;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxServers;
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> srcChecks;
															#line 811 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> destChecks;
															#line 6215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via addReadWriteDestinations()
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AddReadWriteDestinationsActor final : public Actor<std::vector<UID>>, public ActorCallback< AddReadWriteDestinationsActor, 0, Void >, public FastAllocated<AddReadWriteDestinationsActor>, public AddReadWriteDestinationsActorState<AddReadWriteDestinationsActor> {
															#line 6220 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AddReadWriteDestinationsActor>::operator new;
	using FastAllocated<AddReadWriteDestinationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15230245266445147648UL, 5263836330003626752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddReadWriteDestinationsActor, 0, Void >;
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AddReadWriteDestinationsActor(KeyRangeRef const& shard,std::vector<StorageServerInterface> const& srcInterfs,std::vector<StorageServerInterface> const& destInterfs,Version const& version,int const& desiredHealthy,int const& maxServers) 
															#line 6237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<UID>>(),
		   AddReadWriteDestinationsActorState<AddReadWriteDestinationsActor>(shard, srcInterfs, destInterfs, version, desiredHealthy, maxServers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1693877289819123200UL, 6093049964566661888UL);
		ActorExecutionContextHelper __helper(static_cast<AddReadWriteDestinationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addReadWriteDestinations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addReadWriteDestinations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddReadWriteDestinationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<UID>> addReadWriteDestinations( KeyRangeRef const& shard, std::vector<StorageServerInterface> const& srcInterfs, std::vector<StorageServerInterface> const& destInterfs, Version const& version, int const& desiredHealthy, int const& maxServers ) {
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<UID>>(new AddReadWriteDestinationsActor(shard, srcInterfs, destInterfs, version, desiredHealthy, maxServers));
															#line 6269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Returns storage servers selected from 'candidates', who is serving a read-write copy of 'range'.
															#line 6275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via pickReadWriteServers()
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class PickReadWriteServersActor>
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class PickReadWriteServersActorState {
															#line 6281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	PickReadWriteServersActorState(Transaction* const& tr,std::vector<UID> const& candidates,KeyRangeRef const& range) 
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : tr(tr),
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   candidates(candidates),
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   range(range)
															#line 6292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("pickReadWriteServers", reinterpret_cast<unsigned long>(this));

	}
	~PickReadWriteServersActorState() 
	{
		fdb_probe_actor_destroy("pickReadWriteServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID id : candidates ) {
															#line 848 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				serverListEntries.push_back(tr->get(serverListKeyFor(id)));
															#line 6311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(serverListEntries);
															#line 851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 1;
															#line 851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 853 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<StorageServerInterface> ssis;
															#line 854 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssis.push_back(decodeServerListValue(v.get()));
															#line 6349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks = std::vector<Future<Optional<UID>>>();
															#line 859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks.reserve(ssis.size());
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& ssi : ssis ) {
															#line 861 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checks.push_back(checkReadWrite( ssi.getShardState.getReplyUnlessFailedFor(GetShardStateRequest(range, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), ssi.id(), 0));
															#line 6359 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(checks);
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6365 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 2;
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 1, Void >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6370 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 853 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<StorageServerInterface> ssis;
															#line 854 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssis.push_back(decodeServerListValue(v.get()));
															#line 6383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks = std::vector<Future<Optional<UID>>>();
															#line 859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		checks.reserve(ssis.size());
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& ssi : ssis ) {
															#line 861 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checks.push_back(checkReadWrite( ssi.getShardState.getReplyUnlessFailedFor(GetShardStateRequest(range, GetShardStateRequest::NO_WAIT), SERVER_KNOBS->SERVER_READY_QUORUM_INTERVAL, 0, TaskPriority::MoveKeys), ssi.id(), 0));
															#line 6393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(checks);
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 2;
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PickReadWriteServersActor, 1, Void >*>(static_cast<PickReadWriteServersActor*>(this)));
															#line 6404 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state > 0) static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 0;
		static_cast<PickReadWriteServersActor*>(this)->ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 872 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 873 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& it : checks ) {
															#line 874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6492 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(it.get().get());
															#line 6496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<PickReadWriteServersActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~PickReadWriteServersActorState(); static_cast<PickReadWriteServersActor*>(this)->destroy(); return 0; }
															#line 6501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<PickReadWriteServersActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 872 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> result;
															#line 873 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const auto& it : checks ) {
															#line 874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (it.get().present())
															#line 6517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				result.push_back(it.get().get());
															#line 6521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<PickReadWriteServersActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(result); this->~PickReadWriteServersActorState(); static_cast<PickReadWriteServersActor*>(this)->destroy(); return 0; }
															#line 6526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<PickReadWriteServersActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(result);
		this->~PickReadWriteServersActorState();
		static_cast<PickReadWriteServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PickReadWriteServersActor*>(this)->actor_wait_state > 0) static_cast<PickReadWriteServersActor*>(this)->actor_wait_state = 0;
		static_cast<PickReadWriteServersActor*>(this)->ActorCallback< PickReadWriteServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PickReadWriteServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PickReadWriteServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction* tr;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> candidates;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef range;
															#line 858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Optional<UID>>> checks;
															#line 6617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via pickReadWriteServers()
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class PickReadWriteServersActor final : public Actor<std::vector<UID>>, public ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >, public ActorCallback< PickReadWriteServersActor, 1, Void >, public FastAllocated<PickReadWriteServersActor>, public PickReadWriteServersActorState<PickReadWriteServersActor> {
															#line 6622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<PickReadWriteServersActor>::operator new;
	using FastAllocated<PickReadWriteServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9581219736744317696UL, 9764286132778321152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >;
friend struct ActorCallback< PickReadWriteServersActor, 1, Void >;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	PickReadWriteServersActor(Transaction* const& tr,std::vector<UID> const& candidates,KeyRangeRef const& range) 
															#line 6640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<UID>>(),
		   PickReadWriteServersActorState<PickReadWriteServersActor>(tr, candidates, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pickReadWriteServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8503206445238439424UL, 11680636101714118400UL);
		ActorExecutionContextHelper __helper(static_cast<PickReadWriteServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pickReadWriteServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pickReadWriteServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PickReadWriteServersActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PickReadWriteServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<UID>> pickReadWriteServers( Transaction* const& tr, std::vector<UID> const& candidates, KeyRangeRef const& range ) {
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<UID>>(new PickReadWriteServersActor(tr, candidates, range));
															#line 6673 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 881 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 6678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via additionalSources()
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class AdditionalSourcesActor>
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AdditionalSourcesActorState {
															#line 6684 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AdditionalSourcesActorState(RangeResult const& shards,Reference<ReadYourWritesTransaction> const& tr,int const& desiredHealthy,int const& maxServers) 
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : shards(shards),
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(tr),
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   desiredHealthy(desiredHealthy),
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   maxServers(maxServers)
															#line 6697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("additionalSources", reinterpret_cast<unsigned long>(this));

	}
	~AdditionalSourcesActorState() 
	{
		fdb_probe_actor_destroy("additionalSources", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 1;
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 0, RangeResult >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 887 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 888 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> fetching;
															#line 890 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 896 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!fetching.contains(src[s]))
															#line 6758 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					fetching.insert(src[s]);
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					serverListEntries.push_back(tr->get(serverListKeyFor(src[s])));
															#line 6764 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!fetching.contains(dest[s]))
															#line 6771 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					fetching.insert(dest[s]);
															#line 906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					serverListEntries.push_back(tr->get(serverListKeyFor(dest[s])));
															#line 6777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_1 = getAll(serverListEntries);
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 2;
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 6799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::map<UID, StorageServerInterface> ssiMap;
															#line 914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[s].get());
															#line 916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssiMap[ssi.id()] = ssi;
															#line 6884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<std::vector<UID>>> allChecks;
															#line 920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(shards[i].key, shards[i + 1].key);
															#line 922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> srcInterfs;
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> destInterfs;
															#line 927 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcInterfs.reserve(src.size());
															#line 930 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 931 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcInterfs.push_back(ssiMap[src[s]]);
															#line 6908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 935 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(src.begin(), src.end(), dest[s]) == src.end())
															#line 6914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					destInterfs.push_back(ssiMap[dest[s]]);
															#line 6918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 940 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allChecks.push_back(addReadWriteDestinations( rangeIntersectKeys, srcInterfs, destInterfs, tr->getReadVersion().get(), desiredHealthy, maxServers));
															#line 6923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_2 = getAll(allChecks);
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 3;
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::map<UID, StorageServerInterface> ssiMap;
															#line 914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[s].get());
															#line 916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssiMap[ssi.id()] = ssi;
															#line 6949 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<std::vector<UID>>> allChecks;
															#line 920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(shards[i].key, shards[i + 1].key);
															#line 922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> srcInterfs;
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<StorageServerInterface> destInterfs;
															#line 927 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest);
															#line 929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcInterfs.reserve(src.size());
															#line 930 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 931 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcInterfs.push_back(ssiMap[src[s]]);
															#line 6973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 935 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(src.begin(), src.end(), dest[s]) == src.end())
															#line 6979 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					destInterfs.push_back(ssiMap[dest[s]]);
															#line 6983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 940 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allChecks.push_back(addReadWriteDestinations( rangeIntersectKeys, srcInterfs, destInterfs, tr->getReadVersion().get(), desiredHealthy, maxServers));
															#line 6988 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_2 = getAll(allChecks);
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 3;
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*>(static_cast<AdditionalSourcesActor*>(this)));
															#line 6999 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont2(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(std::vector<std::vector<UID>> const& result,int loopDepth) 
	{
															#line 945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AdditionalSourcesActor*>(this)->SAV<std::vector<std::vector<UID>>>::futures) { (void)(result); this->~AdditionalSourcesActorState(); static_cast<AdditionalSourcesActor*>(this)->destroy(); return 0; }
															#line 7083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AdditionalSourcesActor*>(this)->SAV< std::vector<std::vector<UID>> >::value()) std::vector<std::vector<UID>>(result);
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(std::vector<std::vector<UID>> && result,int loopDepth) 
	{
															#line 945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<AdditionalSourcesActor*>(this)->SAV<std::vector<std::vector<UID>>>::futures) { (void)(result); this->~AdditionalSourcesActorState(); static_cast<AdditionalSourcesActor*>(this)->destroy(); return 0; }
															#line 7095 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<AdditionalSourcesActor*>(this)->SAV< std::vector<std::vector<UID>> >::value()) std::vector<std::vector<UID>>(result);
		this->~AdditionalSourcesActorState();
		static_cast<AdditionalSourcesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::vector<UID>> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont8(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::vector<UID>> && result,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdditionalSourcesActor*>(this)->actor_wait_state > 0) static_cast<AdditionalSourcesActor*>(this)->actor_wait_state = 0;
		static_cast<AdditionalSourcesActor*>(this)->ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> const& value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> && value) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*,Error err) 
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult shards;
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int desiredHealthy;
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxServers;
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 7188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via additionalSources()
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class AdditionalSourcesActor final : public Actor<std::vector<std::vector<UID>>>, public ActorCallback< AdditionalSourcesActor, 0, RangeResult >, public ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >, public ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >, public FastAllocated<AdditionalSourcesActor>, public AdditionalSourcesActorState<AdditionalSourcesActor> {
															#line 7193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<AdditionalSourcesActor>::operator new;
	using FastAllocated<AdditionalSourcesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9360800505386634240UL, 3762111731122527232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::vector<UID>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdditionalSourcesActor, 0, RangeResult >;
friend struct ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >;
friend struct ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >;
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	AdditionalSourcesActor(RangeResult const& shards,Reference<ReadYourWritesTransaction> const& tr,int const& desiredHealthy,int const& maxServers) 
															#line 7212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<std::vector<std::vector<UID>>>(),
		   AdditionalSourcesActorState<AdditionalSourcesActor>(shards, tr, desiredHealthy, maxServers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("additionalSources", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7335489034521655552UL, 3441724204008605440UL);
		ActorExecutionContextHelper __helper(static_cast<AdditionalSourcesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("additionalSources");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("additionalSources", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 1, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdditionalSourcesActor, 2, std::vector<std::vector<UID>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<std::vector<std::vector<UID>>> additionalSources( RangeResult const& shards, Reference<ReadYourWritesTransaction> const& tr, int const& desiredHealthy, int const& maxServers ) {
															#line 882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<std::vector<std::vector<UID>>>(new AdditionalSourcesActor(shards, tr, desiredHealthy, maxServers));
															#line 7246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 947 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 7251 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via logWarningAfter()
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class LogWarningAfterActor>
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class LogWarningAfterActorState {
															#line 7257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	LogWarningAfterActorState(const char* const& context,double const& duration,std::vector<UID> const& servers) 
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : context(context),
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   duration(duration),
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 949 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startTime(now())
															#line 7270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("logWarningAfter", reinterpret_cast<unsigned long>(this));

	}
	~LogWarningAfterActorState() 
	{
		fdb_probe_actor_destroy("logWarningAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 950 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogWarningAfterActorState();
		static_cast<LogWarningAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 951 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(duration);
															#line 951 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<LogWarningAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogWarningAfterActor*>(this)->actor_wait_state = 1;
															#line 951 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogWarningAfterActor, 0, Void >*>(static_cast<LogWarningAfterActor*>(this)));
															#line 7322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 952 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarnAlways, context).detail("Duration", now() - startTime).detail("Servers", describe(servers));
															#line 7331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 952 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevWarnAlways, context).detail("Duration", now() - startTime).detail("Servers", describe(servers));
															#line 7340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogWarningAfterActor*>(this)->actor_wait_state > 0) static_cast<LogWarningAfterActor*>(this)->actor_wait_state = 0;
		static_cast<LogWarningAfterActor*>(this)->ActorCallback< LogWarningAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogWarningAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogWarningAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogWarningAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const char* context;
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	double duration;
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 949 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	double startTime;
															#line 7428 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via logWarningAfter()
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class LogWarningAfterActor final : public Actor<Void>, public ActorCallback< LogWarningAfterActor, 0, Void >, public FastAllocated<LogWarningAfterActor>, public LogWarningAfterActorState<LogWarningAfterActor> {
															#line 7433 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<LogWarningAfterActor>::operator new;
	using FastAllocated<LogWarningAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9126808448445652992UL, 6061726710066886144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogWarningAfterActor, 0, Void >;
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	LogWarningAfterActor(const char* const& context,double const& duration,std::vector<UID> const& servers) 
															#line 7450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   LogWarningAfterActorState<LogWarningAfterActor>(context, duration, servers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logWarningAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1066170188761392640UL, 13649371151223103488UL);
		ActorExecutionContextHelper __helper(static_cast<LogWarningAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logWarningAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logWarningAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogWarningAfterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> logWarningAfter( const char* const& context, double const& duration, std::vector<UID> const& servers ) {
															#line 948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new LogWarningAfterActor(context, duration, servers));
															#line 7482 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 955 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// keyServer: map from keys to destination servers
// serverKeys: two-dimension map: [servers][keys], value is the servers' state of having the keys: active(not-have),
// complete(already has), ""(). Set keyServers[keys].dest = servers. Set serverKeys[servers][keys] = active for each
// subrange of keys that the server did not already have, = complete for each subrange that it already has. Set
// serverKeys[dest][keys] = "" for the dest servers of each existing shard in keys (unless that destination is a member
// of servers OR if the source list is sufficiently degraded)
															#line 7493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via startMoveKeys()
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class StartMoveKeysActor>
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveKeysActorState {
															#line 7499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveKeysActorState(Database const& occ,KeyRange const& keys,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startMoveKeysLock(startMoveKeysLock),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 970 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   interval("RelocateShard_StartMoveKeys"),
															#line 971 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("StartMoveKeysTooLong", 600, servers))
															#line 7524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("startMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~StartMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("startMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 974 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = startMoveKeysLock->take(TaskPriority::DataDistributionLaunch);
															#line 974 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 974 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 0, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMoveKeysActorState();
		static_cast<StartMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 975 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 976 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.begin(), relocationIntervalId);
															#line 7573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keys.begin;
															#line 982 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			batches = 0;
															#line 983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shards = 0;
															#line 984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = 0;
															#line 989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7585 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 975 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 976 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.begin(), relocationIntervalId);
															#line 7604 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keys.begin;
															#line 982 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			batches = 0;
															#line 983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shards = 0;
															#line 984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = 0;
															#line 989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 7616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1167 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<StartMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveKeysActorState(); static_cast<StartMoveKeysActor*>(this)->destroy(); return 0; }
															#line 7706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<StartMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMoveKeysActorState();
		static_cast<StartMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1163 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, interval.end(), relocationIntervalId).errorUnsuppressed(e);
															#line 1164 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1158 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.end(), relocationIntervalId) .detail("Batches", batches) .detail("Shards", shards) .detail("MaxRetries", maxRetries);
															#line 7735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 7751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 990 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(begin > keys.begin, "Multi-transactional startMoveKeys");
															#line 991 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		batches++;
															#line 994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(occ);
															#line 995 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries = 0;
															#line 997 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 7765 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries > maxRetries)
															#line 7787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1152 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			maxRetries = retries;
															#line 7791 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 999 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retries++;
															#line 1002 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			oldDests = std::set<UID>();
															#line 1005 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			shardMap = Map<UID, VectorRef<KeyRangeRef>>();
															#line 1007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->getTransaction().trState->taskID = TaskPriority::MoveKeys;
															#line 1008 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1009 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&(tr->getTransaction()), lock, ddEnabledState);
															#line 1011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 1, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = e;
															#line 1136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (err.code() == error_code_move_to_removed_server)
															#line 7865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1137 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(e, std::max(0, loopDepth - 2));
															#line 7869 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr->onError(e);
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 10;
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 9, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7880 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1013 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 7895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = readTSSMappingRYW(tr, tssMapping);
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 2, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1013 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 7920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = readTSSMappingRYW(tr, tssMapping);
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7926 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 2, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 7931 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1020 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(servers.size());
															#line 1021 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < servers.size();s++) {
															#line 1022 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr->get(serverListKeyFor(servers[s])));
															#line 8026 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_3 = getAll(serverListEntries);
															#line 1023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8032 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 1023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 8046 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 8055 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1027 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 8141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1028 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				CODE_PROBE(true, "start move keys moving to a removed server", probe::decoration::rare);
															#line 1029 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 8147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1035 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = krmGetRanges(tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 5;
															#line 1037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 4, RangeResult >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 8170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont8(int loopDepth) 
	{
															#line 1044 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = old.end()[-1].key;
															#line 1045 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8255 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 6;
															#line 1056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 5, RangeResult >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6when1(RangeResult const& __old,int loopDepth) 
	{
															#line 1037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		old = __old;
															#line 8269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6when1(RangeResult && __old,int loopDepth) 
	{
		old = std::move(__old);
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont11(int loopDepth) 
	{
															#line 1057 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<std::vector<UID>>> __when_expr_6 = additionalSources( old, tr, servers.size(), SERVER_KNOBS->MAX_ADDED_SOURCES_MULTIPLIER * servers.size());
															#line 1058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_6.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8357 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 8366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11cont1(std::vector<std::vector<UID>> const& addAsSource,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < old.size() - 1;++i) {
															#line 1064 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(old[i].key, old[i + 1].key);
															#line 1065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 1066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 1067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, old[i].value, src, dest);
															#line 1076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : addAsSource[i] ) {
															#line 1077 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				src.push_back(uid);
															#line 8457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			uniquify(src);
															#line 1082 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			krmSetPreviouslyEmptyRange(&(tr->getTransaction()), keyServersPrefix, rangeIntersectKeys, keyServersValue(UIDtoTagMap, src, servers), old[i + 1].value);
															#line 1090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(auto s = dest.begin();s != dest.end();++s) {
															#line 1091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				oldDests.insert(*s);
															#line 8467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : src ) {
															#line 1097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				shardMap[uid].push_back(old.arena(), rangeIntersectKeys);
															#line 8473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldDest = std::set<UID>::iterator();
															#line 1109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(oldDest = oldDests.begin();oldDest != oldDests.end();++oldDest) {
															#line 1111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(servers.begin(), servers.end(), *oldDest) == servers.end())
															#line 8484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back(removeOldDestinations(tr, *oldDest, shardMap[*oldDest], currentKeys));
															#line 8488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1120 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysTrue));
															#line 8495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 7, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8506 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1(std::vector<std::vector<UID>> && addAsSource,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < old.size() - 1;++i) {
															#line 1064 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(old[i].key, old[i + 1].key);
															#line 1065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 1066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 1067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, old[i].value, src, dest);
															#line 1076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : addAsSource[i] ) {
															#line 1077 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				src.push_back(uid);
															#line 8527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			uniquify(src);
															#line 1082 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			krmSetPreviouslyEmptyRange(&(tr->getTransaction()), keyServersPrefix, rangeIntersectKeys, keyServersValue(UIDtoTagMap, src, servers), old[i + 1].value);
															#line 1090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(auto s = dest.begin();s != dest.end();++s) {
															#line 1091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				oldDests.insert(*s);
															#line 8537 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& uid : src ) {
															#line 1097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				shardMap[uid].push_back(old.arena(), rangeIntersectKeys);
															#line 8543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldDest = std::set<UID>::iterator();
															#line 1109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(oldDest = oldDests.begin();oldDest != oldDests.end();++oldDest) {
															#line 1111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (std::find(servers.begin(), servers.end(), *oldDest) == servers.end())
															#line 8554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back(removeOldDestinations(tr, *oldDest, shardMap[*oldDest], currentKeys));
															#line 8558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1120 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysTrue));
															#line 8565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 7, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(std::vector<std::vector<UID>> const& addAsSource,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(addAsSource, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(std::vector<std::vector<UID>> && addAsSource,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(std::move(addAsSource), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,std::vector<std::vector<UID>> && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 8, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8667 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2(Void && _,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveKeysActor, 8, Void >*>(static_cast<StartMoveKeysActor*>(this)));
															#line 8683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1loopBody1cont11cont10(Void const& _,int loopDepth) 
	{
															#line 1131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 1132 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		shards += old.size() - 1;
															#line 8769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont10(Void && _,int loopDepth) 
	{
															#line 1131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 1132 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		shards += old.size() - 1;
															#line 8780 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1140 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 8864 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( retries == 50 ? SevWarnAlways : SevWarn, "StartMoveKeysRetrying", relocationIntervalId) .error(err) .detail("Keys", keys) .detail("BeginKey", begin) .detail("NumTries", retries);
															#line 8868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1140 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 8878 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent( retries == 50 ? SevWarnAlways : SevWarn, "StartMoveKeysRetrying", relocationIntervalId) .error(err) .detail("Keys", keys) .detail("BeginKey", begin) .detail("NumTries", retries);
															#line 8882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<StartMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<StartMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveKeysActor*>(this)->ActorCallback< StartMoveKeysActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StartMoveKeysActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StartMoveKeysActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* startMoveKeysLock;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 970 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval interval;
															#line 971 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 975 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 976 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool loadedTssMapping;
															#line 981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 982 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int batches;
															#line 983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int shards;
															#line 984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int maxRetries;
															#line 994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 995 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retries;
															#line 1002 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> oldDests;
															#line 1005 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Map<UID, VectorRef<KeyRangeRef>> shardMap;
															#line 1023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1035 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult old;
															#line 1044 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID>::iterator oldDest;
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 9030 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via startMoveKeys()
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveKeysActor final : public Actor<Void>, public ActorCallback< StartMoveKeysActor, 0, Void >, public ActorCallback< StartMoveKeysActor, 1, Void >, public ActorCallback< StartMoveKeysActor, 2, Void >, public ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >, public ActorCallback< StartMoveKeysActor, 4, RangeResult >, public ActorCallback< StartMoveKeysActor, 5, RangeResult >, public ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >, public ActorCallback< StartMoveKeysActor, 7, Void >, public ActorCallback< StartMoveKeysActor, 8, Void >, public ActorCallback< StartMoveKeysActor, 9, Void >, public FastAllocated<StartMoveKeysActor>, public StartMoveKeysActorState<StartMoveKeysActor> {
															#line 9035 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<StartMoveKeysActor>::operator new;
	using FastAllocated<StartMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16480036945186084096UL, 456628023005921280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMoveKeysActor, 0, Void >;
friend struct ActorCallback< StartMoveKeysActor, 1, Void >;
friend struct ActorCallback< StartMoveKeysActor, 2, Void >;
friend struct ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >;
friend struct ActorCallback< StartMoveKeysActor, 4, RangeResult >;
friend struct ActorCallback< StartMoveKeysActor, 5, RangeResult >;
friend struct ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >;
friend struct ActorCallback< StartMoveKeysActor, 7, Void >;
friend struct ActorCallback< StartMoveKeysActor, 8, Void >;
friend struct ActorCallback< StartMoveKeysActor, 9, Void >;
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveKeysActor(Database const& occ,KeyRange const& keys,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 9061 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   StartMoveKeysActorState<StartMoveKeysActor>(occ, keys, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16904875003351271680UL, 14119854258617811200UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartMoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartMoveKeysActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartMoveKeysActor, 3, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartMoveKeysActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartMoveKeysActor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartMoveKeysActor, 6, std::vector<std::vector<UID>> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< StartMoveKeysActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< StartMoveKeysActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< StartMoveKeysActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> startMoveKeys( Database const& occ, KeyRange const& keys, std::vector<UID> const& servers, MoveKeysLock const& lock, FlowLock* const& startMoveKeysLock, UID const& relocationIntervalId, std::map<UID, StorageServerInterface>* const& tssMapping, const DDEnabledState* const& ddEnabledState ) {
															#line 962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new StartMoveKeysActor(occ, keys, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState));
															#line 9102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 9107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via waitForShardReady()
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class WaitForShardReadyActor>
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class WaitForShardReadyActorState {
															#line 9113 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	WaitForShardReadyActorState(StorageServerInterface const& server,KeyRange const& keys,Version const& minVersion,GetShardStateRequest::waitMode const& mode) 
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : server(server),
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   minVersion(minVersion),
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   mode(mode)
															#line 9126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForShardReady", reinterpret_cast<unsigned long>(this));

	}
	~WaitForShardReadyActorState() 
	{
		fdb_probe_actor_destroy("waitForShardReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 9141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForShardReadyActorState();
		static_cast<WaitForShardReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<GetShardStateReply> __when_expr_0 = server.getShardState.getReply(GetShardStateRequest(keys, mode), TaskPriority::MoveKeys);
															#line 1176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 1;
															#line 1176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1183 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("GetShardStateReadyError", server.id()).error(e).log();
															#line 1184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() != error_code_timed_out)
															#line 9203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (e.code() != error_code_broken_promise)
															#line 9207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9211 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_2 = Never();
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 3;
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 2, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetShardStateReply const& rep,int loopDepth) 
	{
															#line 1178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (rep.first >= minVersion)
															#line 9242 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<WaitForShardReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForShardReadyActorState(); static_cast<WaitForShardReadyActor*>(this)->destroy(); return 0; }
															#line 9246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<WaitForShardReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForShardReadyActorState();
			static_cast<WaitForShardReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->SHARD_READY_DELAY, TaskPriority::MoveKeys);
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 2;
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 1, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetShardStateReply && rep,int loopDepth) 
	{
															#line 1178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (rep.first >= minVersion)
															#line 9270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<WaitForShardReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForShardReadyActorState(); static_cast<WaitForShardReadyActor*>(this)->destroy(); return 0; }
															#line 9274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<WaitForShardReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForShardReadyActorState();
			static_cast<WaitForShardReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->SHARD_READY_DELAY, TaskPriority::MoveKeys);
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 2;
															#line 1181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForShardReadyActor, 1, Void >*>(static_cast<WaitForShardReadyActor*>(this)));
															#line 9289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,GetShardStateReply const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,GetShardStateReply && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 1188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 9479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 1188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 9487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForShardReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForShardReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForShardReadyActor*>(this)->ActorCallback< WaitForShardReadyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForShardReadyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForShardReadyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StorageServerInterface server;
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Version minVersion;
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	GetShardStateRequest::waitMode mode;
															#line 9574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via waitForShardReady()
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class WaitForShardReadyActor final : public Actor<Void>, public ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >, public ActorCallback< WaitForShardReadyActor, 1, Void >, public ActorCallback< WaitForShardReadyActor, 2, Void >, public FastAllocated<WaitForShardReadyActor>, public WaitForShardReadyActorState<WaitForShardReadyActor> {
															#line 9579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<WaitForShardReadyActor>::operator new;
	using FastAllocated<WaitForShardReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1064661405091645184UL, 4403550938024155136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >;
friend struct ActorCallback< WaitForShardReadyActor, 1, Void >;
friend struct ActorCallback< WaitForShardReadyActor, 2, Void >;
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	WaitForShardReadyActor(StorageServerInterface const& server,KeyRange const& keys,Version const& minVersion,GetShardStateRequest::waitMode const& mode) 
															#line 9598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForShardReadyActorState<WaitForShardReadyActor>(server, keys, minVersion, mode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForShardReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10925432230277775104UL, 4991613340205893120UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForShardReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForShardReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForShardReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 0, GetShardStateReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForShardReadyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> waitForShardReady( StorageServerInterface const& server, KeyRange const& keys, Version const& minVersion, GetShardStateRequest::waitMode const& mode ) {
															#line 1170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new WaitForShardReadyActor(server, keys, minVersion, mode));
															#line 9632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// best effort to also wait for TSS on data move

															#line 9639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkFetchingState()
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckFetchingStateActor>
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckFetchingStateActorState {
															#line 9645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckFetchingStateActorState(Database const& cx,std::vector<UID> const& dest,KeyRange const& keys,Promise<Void> const& dataMovementComplete,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : cx(cx),
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dest(dest),
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMovementComplete(dataMovementComplete),
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tr(cx)
															#line 9664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	~CheckFetchingStateActorState() 
	{
		fdb_probe_actor_destroy("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 9679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (BUGGIFY)
															#line 9710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(5);
															#line 1207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9716 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 1;
															#line 1207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 0, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1255 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 9748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.reset();
															#line 9752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 5;
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 4, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1210 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1211 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1213 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1214 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(dest.size());
															#line 1215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < dest.size();s++) {
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(dest[s])));
															#line 9794 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_1 = getAll(serverListEntries);
															#line 1217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 2;
															#line 1217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> requests;
															#line 1219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssRequests = std::vector<Future<Void>>();
															#line 1220 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT_WE_THINK(serverListValues[s].present());
															#line 1224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 9909 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1227 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 9913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 1230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == dest[s]);
															#line 1231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			requests.push_back( waitForShardReady(si, keys, tr.getReadVersion().get(), GetShardStateRequest::FETCHING));
															#line 1234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(si.id());
															#line 1235 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end())
															#line 9925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssRequests.push_back(waitForShardReady( tssPair->second, keys, tr.getReadVersion().get(), GetShardStateRequest::FETCHING));
															#line 9929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeoutError(waitForAll(requests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, TaskPriority::MoveKeys);
															#line 1241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 3;
															#line 1241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 2, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9941 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 9950 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1245 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssRequests.size())
															#line 10029 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeout(waitForAllReady(tssRequests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT / 2, Void(), TaskPriority::MoveKeys);
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10035 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 4;
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 3, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 10040 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1245 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssRequests.size())
															#line 10054 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeout(waitForAllReady(tssRequests), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT / 2, Void(), TaskPriority::MoveKeys);
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10060 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 4;
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 3, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 10065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
															#line 1252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMovementComplete.send(Void());
															#line 1253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckFetchingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFetchingStateActorState(); static_cast<CheckFetchingStateActor*>(this)->destroy(); return 0; }
															#line 10156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckFetchingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database cx;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Promise<Void> dataMovementComplete;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> tssRequests;
															#line 10362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkFetchingState()
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckFetchingStateActor final : public Actor<Void>, public ActorCallback< CheckFetchingStateActor, 0, Void >, public ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >, public ActorCallback< CheckFetchingStateActor, 2, Void >, public ActorCallback< CheckFetchingStateActor, 3, Void >, public ActorCallback< CheckFetchingStateActor, 4, Void >, public FastAllocated<CheckFetchingStateActor>, public CheckFetchingStateActorState<CheckFetchingStateActor> {
															#line 10367 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckFetchingStateActor>::operator new;
	using FastAllocated<CheckFetchingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13277054939531975424UL, 5576613105354769152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFetchingStateActor, 0, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >;
friend struct ActorCallback< CheckFetchingStateActor, 2, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 3, Void >;
friend struct ActorCallback< CheckFetchingStateActor, 4, Void >;
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckFetchingStateActor(Database const& cx,std::vector<UID> const& dest,KeyRange const& keys,Promise<Void> const& dataMovementComplete,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 10388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFetchingStateActorState<CheckFetchingStateActor>(cx, dest, keys, dataMovementComplete, relocationIntervalId, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13605890424979058688UL, 18070830385337103360UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFetchingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 1, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] Future<Void> checkFetchingState( Database const& cx, std::vector<UID> const& dest, KeyRange const& keys, Promise<Void> const& dataMovementComplete, UID const& relocationIntervalId, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckFetchingStateActor(cx, dest, keys, dataMovementComplete, relocationIntervalId, tssMapping));
															#line 10424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Set keyServers[keys].src = keyServers[keys].dest and keyServers[keys].dest=[], return when successful
// keyServers[k].dest must be the same for all k in keys
// Set serverKeys[dest][keys] = true; serverKeys[src][keys] = false for all src not in dest
// Should be cancelled and restarted if keyServers[keys].dest changes (?so this is no longer true?)
															#line 10433 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via finishMoveKeys()
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class FinishMoveKeysActor>
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveKeysActorState {
															#line 10439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveKeysActorState(Database const& occ,KeyRange const& keys,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destinationTeam(destinationTeam),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   finishMoveKeysParallelismLock(finishMoveKeysParallelismLock),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   hasRemote(hasRemote),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 1276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   interval("RelocateShard_FinishMoveKeys"),
															#line 1277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   waitInterval(""),
															#line 1278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("FinishMoveKeysTooLong", 600, destinationTeam)),
															#line 1279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   begin(keys.begin),
															#line 1280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   endKey(),
															#line 1281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   retries(0),
															#line 1282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   releaser(),
															#line 1284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssToIgnore(),
															#line 1286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   waitForTSSCounter(2)
															#line 10480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("finishMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~FinishMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("finishMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!destinationTeam.empty());
															#line 10495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			try {
															#line 1291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevDebug, interval.begin(), relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end);
															#line 1297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				;
															#line 10501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishMoveKeysActorState();
		static_cast<FinishMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1608 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveKeysActorState(); static_cast<FinishMoveKeysActor*>(this)->destroy(); return 0; }
															#line 10530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveKeysActorState();
		static_cast<FinishMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1605 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, interval.end(), relocationIntervalId).errorUnsuppressed(e);
															#line 1606 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, interval.end(), relocationIntervalId);
															#line 10559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 10575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		CODE_PROBE(begin > keys.begin, "Multi-transactional finishMoveKeys");
															#line 1300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 1303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 10585 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1310 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			releaser.release();
															#line 1311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 1311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 0, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10636 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 1584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (error.code() == error_code_actor_cancelled)
															#line 10671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1585 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1Catch2(error, std::max(0, loopDepth - 2));
															#line 10675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1586 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			err = error;
															#line 1587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr.onError(error);
															#line 1587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 10;
															#line 1587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 9, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 1, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 1, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10818 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 2, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 2, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 1318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = krmGetRanges(&tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 3, RangeResult >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 10934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 10943 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 1326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = keyServers.end()[-1].key;
															#line 1327 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		bool alreadyMoved = true;
															#line 1335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 1336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers = std::set<UID>();
															#line 1337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		intendedTeam = std::set<UID>(destinationTeam.begin(), destinationTeam.end());
															#line 1338 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 1339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<UID> completeSrc;
															#line 1342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int currentIndex;
															#line 1343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(currentIndex = 0;currentIndex < keyServers.size() - 1 && alreadyMoved;currentIndex++) {
															#line 1344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src, dest);
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> srcSet;
															#line 1347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src.size();s++) {
															#line 1348 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcSet.insert(src[s]);
															#line 11048 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (currentIndex == 0)
															#line 11052 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				completeSrc = src;
															#line 11056 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 1354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for(int i = 0;i < completeSrc.size();i++) {
															#line 1355 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!srcSet.contains(completeSrc[i]))
															#line 11064 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						swapAndPop(&completeSrc, i--);
															#line 11068 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					}
				}
			}
															#line 1361 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> destSet;
															#line 1362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < dest.size();s++) {
															#line 1363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				destSet.insert(dest[s]);
															#line 11078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(srcSet.begin(), srcSet.end());
															#line 1367 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(destSet.begin(), destSet.end());
															#line 1371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool isSubset = std::includes(intendedTeam.begin(), intendedTeam.end(), srcSet.begin(), srcSet.end());
															#line 1373 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			alreadyMoved = destSet.empty() && isSubset;
															#line 1374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destSet != intendedTeam && !alreadyMoved)
															#line 11090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1375 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "MoveKeysDestTeamNotIntended", relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey) .detail("SrcSet", describe(srcSet)) .detail("DestSet", describe(destSet)) .detail("IntendedTeam", describe(intendedTeam)) .detail("KeyServers", keyServers);
															#line 1386 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				ASSERT(!dest.empty());
															#line 1389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				intendedTeam.clear();
															#line 1390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for(int i = 0;i < dest.size();i++) {
															#line 1391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					intendedTeam.insert(dest[i]);
															#line 11102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
			else
			{
															#line 1392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (alreadyMoved)
															#line 11109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					dest.clear();
															#line 1394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					src.clear();
															#line 1395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					CODE_PROBE(true, "FinishMoveKeys first key in iteration sub-range has already been processed");
															#line 11117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 1401 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;currentIndex < keyServers.size() - 1;currentIndex++) {
															#line 1402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src2, dest2;
															#line 1403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src2, dest2);
															#line 1405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::set<UID> srcSet;
															#line 1406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int s = 0;s < src2.size();s++) {
															#line 1407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				srcSet.insert(src2[s]);
															#line 11133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int i = 0;i < completeSrc.size();i++) {
															#line 1410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!srcSet.contains(completeSrc[i]))
															#line 11139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					swapAndPop(&completeSrc, i--);
															#line 11143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
															#line 1415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			allServers.insert(srcSet.begin(), srcSet.end());
															#line 1419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool isSubset = std::includes(intendedTeam.begin(), intendedTeam.end(), srcSet.begin(), srcSet.end());
															#line 1421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			alreadyMoved = dest2.empty() && isSubset;
															#line 1422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dest2 != dest && !alreadyMoved)
															#line 11154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevError, "FinishMoveKeysError", relocationIntervalId) .detail("Reason", "dest mismatch") .detail("Dest", describe(dest)) .detail("Dest2", describe(dest2));
															#line 1427 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				ASSERT(false);
															#line 11160 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1430 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!dest.size())
															#line 11165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CODE_PROBE(true, "A previous finishMoveKeys for this range committed just as it was cancelled to " "start this one?");
															#line 1434 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent("FinishMoveKeysNothingToDo", relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 1439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			begin = keyServers.end()[-1].key;
															#line 11173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		waitInterval = TraceInterval("RelocateShard_FinishMoveKeysWaitDurable");
															#line 1444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevDebug, waitInterval.begin(), relocationIntervalId) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end);
															#line 1451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady = std::vector<Future<Void>>();
															#line 1452 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady = std::vector<Future<Void>>();
															#line 1453 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs = std::vector<StorageServerInterface>();
															#line 1454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newDestinations = std::vector<UID>();
															#line 1455 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> completeSrcSet(completeSrc.begin(), completeSrc.end());
															#line 1456 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( auto& it : dest ) {
															#line 1457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!hasRemote || !completeSrcSet.contains(it))
															#line 11194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newDestinations.push_back(it);
															#line 11198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1464 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(newDestinations.size());
															#line 1466 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < newDestinations.size();s++) {
															#line 1467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(newDestinations[s])));
															#line 11211 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_4 = getAll(serverListEntries);
															#line 1468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 5;
															#line 1468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 11231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 1470 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser.release();
															#line 1472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(serverListValues[s] .present());
															#line 1475 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 1476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == newDestinations[s]);
															#line 1477 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			storageServerInterfaces.push_back(si);
															#line 11320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady.reserve(storageServerInterfaces.size());
															#line 1485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady.reserve(storageServerInterfaces.size());
															#line 1486 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs.reserve(storageServerInterfaces.size());
															#line 1487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < storageServerInterfaces.size();s++) {
															#line 1488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverReady.push_back(waitForShardReady(storageServerInterfaces[s], keys, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 1493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(storageServerInterfaces[s].id());
															#line 1495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end() && waitForTSSCounter > 0 && !tssToIgnore.contains(tssPair->second.id()))
															#line 11336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReadyInterfs.push_back(tssPair->second);
															#line 1498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReady.push_back(waitForShardReady( tssPair->second, keys, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 11342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1505 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeout(waitForAll(serverReady) && waitForAllReady(tssReady), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, Void(), TaskPriority::MoveKeys);
															#line 1505 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 6;
															#line 1505 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 5, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 11363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont27(Void const& _,int loopDepth) 
	{
															#line 1513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1514 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool allSSDone = true;
															#line 1515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& f : serverReady ) {
															#line 1516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allSSDone &= f.isReady() && !f.isError();
															#line 1517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!allSSDone)
															#line 11452 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
					break;
				}
			}
															#line 1522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (allSSDone)
															#line 11459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				bool anyTssNotDone = false;
															#line 1525 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( auto& f : tssReady ) {
															#line 1526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!f.isReady() || f.isError())
															#line 11467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						anyTssNotDone = true;
															#line 1528 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						waitForTSSCounter--;
															#line 11473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						break;
					}
				}
															#line 1533 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (anyTssNotDone && waitForTSSCounter == 0)
															#line 11479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					for(int i = 0;i < tssReady.size();i++) {
															#line 1535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (!tssReady[i].isReady() || tssReady[i].isError())
															#line 11485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						{
															#line 1536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
							tssToIgnore.insert(tssReadyInterfs[i].id());
															#line 11489 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 1543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int count = dest.size() - newDestinations.size();
															#line 1544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();s++) {
															#line 1545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			count += serverReady[s].isReady() && !serverReady[s].isError();
															#line 11501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1547 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 1548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 1549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tssCount += tssReady[s].isReady() && !tssReady[s].isError();
															#line 11509 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent readyServersEv(SevDebug, waitInterval.end(), relocationIntervalId);
															#line 1552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServersEv.detail("ReadyServers", count).detail("Dests", dest.size());
															#line 1553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readyServersEv.detail("ReadyTSS", tssCount);
															#line 11521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (count == dest.size())
															#line 11525 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_6 = krmSetRangeCoalescing( &tr, keyServersPrefix, currentKeys, keys, keyServersValue(UIDtoTagMap, dest));
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27when1(__when_expr_6.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 6, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont27cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27(Void && _,int loopDepth) 
	{
															#line 1513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1514 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool allSSDone = true;
															#line 1515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( auto& f : serverReady ) {
															#line 1516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				allSSDone &= f.isReady() && !f.isError();
															#line 1517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!allSSDone)
															#line 11560 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
					break;
				}
			}
															#line 1522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (allSSDone)
															#line 11567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				bool anyTssNotDone = false;
															#line 1525 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				for( auto& f : tssReady ) {
															#line 1526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (!f.isReady() || f.isError())
															#line 11575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 1527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						anyTssNotDone = true;
															#line 1528 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						waitForTSSCounter--;
															#line 11581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						break;
					}
				}
															#line 1533 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (anyTssNotDone && waitForTSSCounter == 0)
															#line 11587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					for(int i = 0;i < tssReady.size();i++) {
															#line 1535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (!tssReady[i].isReady() || tssReady[i].isError())
															#line 11593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						{
															#line 1536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
							tssToIgnore.insert(tssReadyInterfs[i].id());
															#line 11597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 1543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int count = dest.size() - newDestinations.size();
															#line 1544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();s++) {
															#line 1545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			count += serverReady[s].isReady() && !serverReady[s].isError();
															#line 11609 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1547 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 1548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 1549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tssCount += tssReady[s].isReady() && !tssReady[s].isError();
															#line 11617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent readyServersEv(SevDebug, waitInterval.end(), relocationIntervalId);
															#line 1552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServersEv.detail("ReadyServers", count).detail("Dests", dest.size());
															#line 1553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (tssReady.size())
															#line 11625 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			readyServersEv.detail("ReadyTSS", tssCount);
															#line 11629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (count == dest.size())
															#line 11633 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_6 = krmSetRangeCoalescing( &tr, keyServersPrefix, currentKeys, keys, keyServersValue(UIDtoTagMap, dest));
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27when1(__when_expr_6.get(), loopDepth); };
			static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 7;
															#line 1561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 6, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont27cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1loopBody1cont27cont1(int loopDepth) 
	{
															#line 1582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.reset();
															#line 11733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont27cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14(Void const& _,int loopDepth) 
	{
															#line 1564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID>::iterator asi = allServers.begin();
															#line 1565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1566 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;asi != allServers.end();) {
															#line 1567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool destHasServer = std::find(dest.begin(), dest.end(), *asi) != dest.end();
															#line 1568 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing(&tr, serverKeysPrefixFor(*asi), currentKeys, allKeys, destHasServer ? serverKeysTrue : serverKeysFalse));
															#line 1573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			++asi;
															#line 11752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11758 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14when1(__when_expr_7.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 7, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11763 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14(Void && _,int loopDepth) 
	{
															#line 1564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID>::iterator asi = allServers.begin();
															#line 1565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Void>> actors;
															#line 1566 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(;asi != allServers.end();) {
															#line 1567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			bool destHasServer = std::find(dest.begin(), dest.end(), *asi) != dest.end();
															#line 1568 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing(&tr, serverKeysPrefixFor(*asi), currentKeys, allKeys, destHasServer ? serverKeysTrue : serverKeysFalse));
															#line 1573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			++asi;
															#line 11782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(actors);
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14when1(__when_expr_7.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 8;
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 7, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11793 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont27when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont27when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1loopBody1cont27cont14cont1(Void const& _,int loopDepth) 
	{
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr.commit();
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 8, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1(Void && _,int loopDepth) 
	{
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr.commit();
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1loopBody1cont27cont14cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 9;
															#line 1577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveKeysActor, 8, Void >*>(static_cast<FinishMoveKeysActor*>(this)));
															#line 11900 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont27cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont27cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1loopBody1cont27cont14cont3(Void const& _,int loopDepth) 
	{
															#line 1579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 11984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont3(Void && _,int loopDepth) 
	{
															#line 1579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 11993 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont27cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont27cont14cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1cont27cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1cont27cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1loopBody1cont27cont16(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 1589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 12092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveKeysRetrying", relocationIntervalId) .error(err) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 12096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		retries++;
															#line 1589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (retries % 10 == 0)
															#line 12108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(retries == 20 ? SevWarnAlways : SevWarn, "RelocateShard_FinishMoveKeysRetrying", relocationIntervalId) .error(err) .detail("KeyBegin", keys.begin) .detail("KeyEnd", keys.end) .detail("IterationBegin", begin) .detail("IterationEnd", endKey);
															#line 12112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FinishMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveKeysActor*>(this)->ActorCallback< FinishMoveKeysActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FinishMoveKeysActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FinishMoveKeysActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> destinationTeam;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* finishMoveKeysParallelismLock;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool hasRemote;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 1276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval interval;
															#line 1277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	TraceInterval waitInterval;
															#line 1278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 1279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int retries;
															#line 1282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::unordered_set<UID> tssToIgnore;
															#line 1286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int waitForTSSCounter;
															#line 1300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult keyServers;
															#line 1335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> allServers;
															#line 1337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::set<UID> intendedTeam;
															#line 1338 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 1451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> serverReady;
															#line 1452 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> tssReady;
															#line 1453 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> tssReadyInterfs;
															#line 1454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> newDestinations;
															#line 1463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 1468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1586 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Error err;
															#line 12272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via finishMoveKeys()
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveKeysActor final : public Actor<Void>, public ActorCallback< FinishMoveKeysActor, 0, Void >, public ActorCallback< FinishMoveKeysActor, 1, Void >, public ActorCallback< FinishMoveKeysActor, 2, RangeResult >, public ActorCallback< FinishMoveKeysActor, 3, RangeResult >, public ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >, public ActorCallback< FinishMoveKeysActor, 5, Void >, public ActorCallback< FinishMoveKeysActor, 6, Void >, public ActorCallback< FinishMoveKeysActor, 7, Void >, public ActorCallback< FinishMoveKeysActor, 8, Void >, public ActorCallback< FinishMoveKeysActor, 9, Void >, public FastAllocated<FinishMoveKeysActor>, public FinishMoveKeysActorState<FinishMoveKeysActor> {
															#line 12277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<FinishMoveKeysActor>::operator new;
	using FastAllocated<FinishMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1266476185229393408UL, 73989553083819520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishMoveKeysActor, 0, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 1, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 2, RangeResult >;
friend struct ActorCallback< FinishMoveKeysActor, 3, RangeResult >;
friend struct ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >;
friend struct ActorCallback< FinishMoveKeysActor, 5, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 6, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 7, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 8, Void >;
friend struct ActorCallback< FinishMoveKeysActor, 9, Void >;
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveKeysActor(Database const& occ,KeyRange const& keys,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState) 
															#line 12303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   FinishMoveKeysActorState<FinishMoveKeysActor>(occ, keys, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14752164062687862784UL, 9104012867374661120UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 4, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FinishMoveKeysActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> finishMoveKeys( Database const& occ, KeyRange const& keys, std::vector<UID> const& destinationTeam, MoveKeysLock const& lock, FlowLock* const& finishMoveKeysParallelismLock, bool const& hasRemote, UID const& relocationIntervalId, std::map<UID, StorageServerInterface> const& tssMapping, const DDEnabledState* const& ddEnabledState ) {
															#line 1267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new FinishMoveKeysActor(occ, keys, destinationTeam, lock, finishMoveKeysParallelismLock, hasRemote, relocationIntervalId, tssMapping, ddEnabledState));
															#line 12344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// keyServer: map from keys to destination servers.
// serverKeys: two-dimension map: [servers][keys], value is the servers' state of having the keys: active(not-have),
// complete(already has), ""().
// Set keyServers[keys].dest = servers Set serverKeys[servers][keys] = dataMoveId for each
// subrange of keys.
// Set dataMoves[dataMoveId] = DataMoveMetaData.
															#line 12355 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via startMoveShards()
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class StartMoveShardsActor>
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveShardsActorState {
															#line 12361 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveShardsActorState(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& ranges,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState,CancelConflictingDataMoves const& cancelConflictingDataMoves,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ranges(ranges),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   servers(servers),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   startMoveKeysLock(startMoveKeysLock),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   cancelConflictingDataMoves(cancelConflictingDataMoves),
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   bulkLoadTaskState(bulkLoadTaskState),
															#line 1628 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   warningLogger(logWarningAfter("StartMoveShardsTooLong", 600, servers))
															#line 12390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("startMoveShards", reinterpret_cast<unsigned long>(this));

	}
	~StartMoveShardsActorState() 
	{
		fdb_probe_actor_destroy("startMoveShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = startMoveKeysLock->take(TaskPriority::DataDistributionLaunch);
															#line 1630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 1;
															#line 1630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 0, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMoveShardsActorState();
		static_cast<StartMoveShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 1632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 1633 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 1636 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", describe(ranges)) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1642 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(ranges.size() == 1);
															#line 1643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = ranges[0];
															#line 1644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = false;
															#line 1645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 12451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1647 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 12455 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*startMoveKeysLock);
															#line 1632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = false;
															#line 1633 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 1636 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", describe(ranges)) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1642 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(ranges.size() == 1);
															#line 1643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keys = ranges[0];
															#line 1644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = false;
															#line 1645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 12486 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1647 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 12490 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1976 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "StartMoveShardsEnd", relocationIntervalId).detail("DataMoveID", dataMoveId);
															#line 1978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<StartMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveShardsActorState(); static_cast<StartMoveShardsActor*>(this)->destroy(); return 0; }
															#line 12582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<StartMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartMoveShardsActorState();
		static_cast<StartMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1970 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "StartMoveShardsError", relocationIntervalId) .errorUnsuppressed(e) .detail("DataMoveID", dataMoveId);
															#line 1973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 12597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = keys.begin;
															#line 1649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = keys;
															#line 1651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		actors = std::vector<Future<Void>>();
															#line 1652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 12630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 1655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 1656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 1660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 2;
															#line 1660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 1, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1953 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_location_metadata_corruption)
															#line 12684 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 12688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 1955 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (e.code() == error_code_retry)
															#line 12694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1956 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 1957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_17 = delay(1);
															#line 1957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_17.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 18;
															#line 1957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 17, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1959 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevWarn, "StartMoveShardsError", relocationIntervalId) .errorUnsuppressed(e) .detail("DataMoveID", dataMoveId) .detail("DataMoveRange", keys) .detail("CurrentDataMoveMetaData", dataMove.toString());
															#line 1964 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 1965 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_18 = tr.onError(e);
															#line 1965 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_18.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 19;
															#line 1965 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 18, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 1662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12765 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& val,int loopDepth) 
	{
															#line 1663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 12849 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1665 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = dmv;
															#line 1666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsFoundDataMove", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 1670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 12859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "StartMoveShardsDataMoveDeleted", relocationIntervalId) .detail("DataMove", dataMove.toString()) .detail("BackgroundCleanUp", dataMove.ranges.empty());
															#line 1674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 12865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1676 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dataMove.ranges.empty() && dataMove.ranges.front().begin == keys.begin);
															#line 1677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 1679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12881 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 3, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 1691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 12902 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 1695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.id = dataMoveId;
															#line 1696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardssNewDataMove", relocationIntervalId) .detail("DataMoveRange", keys) .detail("DataMoveID", dataMoveId);
															#line 12910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && val,int loopDepth) 
	{
															#line 1663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 12920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1665 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = dmv;
															#line 1666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsFoundDataMove", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 1670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 12930 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "StartMoveShardsDataMoveDeleted", relocationIntervalId) .detail("DataMove", dataMove.toString()) .detail("BackgroundCleanUp", dataMove.ranges.empty());
															#line 1674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 12936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1676 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dataMove.ranges.empty() && dataMove.ranges.front().begin == keys.begin);
															#line 1677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12942 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 1679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12952 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 1680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 3, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 12957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 1691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 12969 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 12973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 1695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.id = dataMoveId;
															#line 1696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardssNewDataMove", relocationIntervalId) .detail("DataMoveRange", keys) .detail("DataMoveID", dataMoveId);
															#line 12981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 1701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!loadedTssMapping)
															#line 13066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = readTSSMapping(&tr, tssMapping);
															#line 1703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13072 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 1703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 4, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13077 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 1683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dataMove.getPhase() == DataMoveMetaData::Running)
															#line 13091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1684 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsDataMove", relocationIntervalId) .detail("DataMoveAlreadyCommitted", dataMoveId);
															#line 1686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(keys == dataMove.ranges.front());
															#line 1687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!static_cast<StartMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartMoveShardsActorState(); static_cast<StartMoveShardsActor*>(this)->destroy(); return 0; }
															#line 13099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			new (&static_cast<StartMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartMoveShardsActorState();
			static_cast<StartMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = dataMove.ranges.front().end;
															#line 13107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1681 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 13116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1681 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 13124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont13(int loopDepth) 
	{
															#line 1707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(servers.size());
															#line 1709 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < servers.size();s++) {
															#line 1710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(servers[s])));
															#line 13213 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_5 = getAll(serverListEntries);
															#line 1712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont13when1(__when_expr_5.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 6;
															#line 1712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 1704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 13233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 1704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		loadedTssMapping = true;
															#line 13242 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont13cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 13328 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 13332 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!currentKeys.empty())
															#line 13339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int rowLimit = SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT;
															#line 1728 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int byteLimit = SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, currentKeys, rowLimit, byteLimit);
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 6, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 13370 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(move_to_removed_server(), loopDepth);
															#line 13374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 1724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(begin, keys.end);
															#line 1726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!currentKeys.empty())
															#line 13381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int rowLimit = SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT;
															#line 1728 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const int byteLimit = SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, currentKeys, rowLimit, byteLimit);
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 6, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont13cont3(int loopDepth) 
	{
															#line 1871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 13485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1872 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (bulkLoadTaskState.present())
															#line 13489 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1873 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newBulkLoadTaskState = BulkLoadTaskState();
															#line 13493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				try {
															#line 1875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_12 = store(newBulkLoadTaskState, getBulkLoadTask(&tr, bulkLoadTaskState.get().getRange(), bulkLoadTaskState.get().getTaskId(), { BulkLoadPhase::Triggered, BulkLoadPhase::Running }));
															#line 1875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 13499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont13cont3Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont3when1(__when_expr_12.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 13;
															#line 1875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 12, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13504 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1cont13cont3Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);
			}
		}
		else
		{
															#line 1910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.setPhase(DataMoveMetaData::Prepare);
															#line 1911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "StartMoveShardsDataMovePartial", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("CurrentRange", currentKeys) .detail("DataMoveRange", keys) .detail("NewDataMoveMetaData", dataMove.toString());
															#line 13524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont13cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6(int loopDepth) 
	{
															#line 1731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = old.back().key;
															#line 1732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 1735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_7 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont6when1(__when_expr_7.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 8;
															#line 1735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 7, RangeResult >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(RangeResult const& __old,int loopDepth) 
	{
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		old = __old;
															#line 13554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(RangeResult && __old,int loopDepth) 
	{
		old = std::move(__old);
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont13cont7(int loopDepth) 
	{
															#line 1736 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		oldIndex = 0;
															#line 1741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 13637 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 1735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 13646 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont6when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1cont13cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont13cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont13cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont13cont8(int loopDepth) 
	{
															#line 1858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1862 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, serverKeysPrefixFor(servers[i]), currentKeys, allKeys, serverKeysValue(dataMoveId)));
															#line 13727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.ranges.clear();
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.ranges.push_back(KeyRangeRef(keys.begin, currentKeys.end));
															#line 1868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.dest.insert(servers.begin(), servers.end());
															#line 13735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont13cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1(int loopDepth) 
	{
															#line 1741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(oldIndex < old.size() - 1))
															#line 13751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont13cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		rangeIntersectKeys = KeyRangeRef(old[oldIndex].key, old[oldIndex + 1].key);
															#line 1743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 1744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 1745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 1746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 1747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, old[oldIndex].value, src, dest, srcId, destId);
															#line 1748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "StartMoveShardsProcessingShard", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("Range", rangeIntersectKeys) .detail("OldSrc", describe(src)) .detail("OldDest", describe(dest)) .detail("SrcID", srcId) .detail("DestID", destId) .detail("ReadVersion", tr.getReadVersion().get());
															#line 1757 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (bulkLoadTaskState.present())
															#line 13771 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1758 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			owners = std::vector<UID>(src.size() + dest.size());
															#line 1759 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), owners.begin());
															#line 1760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const auto& ssid : servers ) {
															#line 1761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (std::find(owners.begin(), owners.end(), ssid) != owners.end())
															#line 13781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1762 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent(SevWarn, "DDBulkLoadTaskStartMoveShardsMoveInConflict") .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("DestServerId", ssid) .detail("OwnerIds", describe(owners)) .detail("DataMove", dataMove.toString());
															#line 1769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					cancelDataMove = true;
															#line 1770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 13789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 1776 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 13795 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1778 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_8 = auditLocationMetadataPreCheck( occ, &tr, rangeIntersectKeys, servers, "startMoveShards_precheck", dataMoveId);
															#line 1779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 9;
															#line 1779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 8, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont13cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7continue1(int loopDepth) 
	{
															#line 1741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++oldIndex;
															#line 13837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont13cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1(int loopDepth) 
	{
															#line 1783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (destId.isValid())
															#line 13846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "StartMoveShardsDestIDExist", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("DestID", destId.toString()) .log();
															#line 1789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(!dest.empty());
															#line 1791 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destId == dataMoveId)
															#line 13854 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1792 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarn, "StartMoveShardsRangeAlreadyCommitted", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId);
															#line 13858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				return a_body1cont1loopBody1cont13cont7continue1(loopDepth); // continue
			}
															#line 1798 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (destId == anonymousShardId)
															#line 13863 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_9 = cleanUpSingleShardDataMove( occ, rangeIntersectKeys, lock, startMoveKeysLock, dataMoveId, ddEnabledState);
															#line 1799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13869 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 10;
															#line 1799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 9, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1803 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (cancelConflictingDataMoves)
															#line 13881 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 1804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					TraceEvent( SevWarn, "StartMoveShardsCancelConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString());
															#line 1809 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_10 = cleanUpDataMove(occ, destId, lock, startMoveKeysLock, keys, ddEnabledState);
															#line 1809 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when2(__when_expr_10.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 11;
															#line 1809 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 10, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_11 = tr.get(dataMoveKeyFor(destId));
															#line 1812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont13cont7loopBody1cont1when3(__when_expr_11.get(), loopDepth); };
					static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 12;
															#line 1812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 13908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont7(int loopDepth) 
	{
															#line 1828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		krmSetPreviouslyEmptyRange(&tr, keyServersPrefix, rangeIntersectKeys, keyServersValue(src, servers, srcId, dataMoveId), old[oldIndex + 1].value);
															#line 1834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.src.insert(src.begin(), src.end());
															#line 1837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (shouldCreateCheckpoint(dataMoveId) && !bulkLoadTaskState.present())
															#line 14015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const UID checkpointId = UID(deterministicRandom()->randomUInt64(), srcId.first());
															#line 1839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			CheckpointMetaData checkpoint(std::vector<KeyRange>{ rangeIntersectKeys }, DataMoveRocksCF, src, checkpointId, dataMoveId);
															#line 1844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Pending);
															#line 1845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.set(checkpointKeyFor(checkpointId), checkpointValue(checkpoint));
															#line 1846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove.checkpoints.insert(checkpointId);
															#line 1847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "InitiatedCheckpoint", relocationIntervalId) .detail("CheckpointID", checkpointId.toString()) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId) .detail("SrcServers", describe(src)) .detail("ReadVersion", tr.getReadVersion().get());
															#line 14029 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++oldIndex;
															#line 14033 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont13cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14042 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14050 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 1810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 1810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont13(Optional<Value> const& val,int loopDepth) 
	{
															#line 1813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(val.present());
															#line 1814 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1815 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( SevWarnAlways, "StartMoveShardsFoundConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString()) .detail("ExistingDataMove", dmv.toString());
															#line 1821 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = true;
															#line 1822 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont13(Optional<Value> && val,int loopDepth) 
	{
															#line 1813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(val.present());
															#line 1814 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		DataMoveMetaData dmv = decodeDataMoveValue(val.get());
															#line 1815 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( SevWarnAlways, "StartMoveShardsFoundConflictingDataMove", relocationIntervalId) .detail("Range", rangeIntersectKeys) .detail("DataMoveID", dataMoveId.toString()) .detail("ExistingDataMoveID", destId.toString()) .detail("ExistingDataMove", dmv.toString());
															#line 1821 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		cancelDataMove = true;
															#line 1822 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 14248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when3(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont13(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont7loopBody1cont1when3(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont7loopBody1cont13(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 11, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont7loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont13cont11(int loopDepth) 
	{
															#line 1918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 1920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_14 = waitForAll(actors);
															#line 1920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11when1(__when_expr_14.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 15;
															#line 1920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 14, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont12(int loopDepth) 
	{
															#line 1903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.setPhase(DataMoveMetaData::Running);
															#line 1904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "StartMoveShardsDataMoveComplete", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 14351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13(int loopDepth) 
	{
															#line 1890 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.setDataMoveId(dataMoveId);
															#line 1891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.startTime = now();
															#line 1892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_13 = krmSetRange(&tr, bulkLoadTaskPrefix, newBulkLoadTaskState.getRange(), bulkLoadTaskStateValue(newBulkLoadTaskState));
															#line 1892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont13when1(__when_expr_13.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 14;
															#line 1892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 13, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (e.code() == error_code_bulkload_task_outdated)
															#line 14381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				cancelDataMove = true;
															#line 1886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(retry(), loopDepth);
															#line 14387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 1888 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 14391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont14(Void const& _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Running;
															#line 14405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont14(Void && _,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newBulkLoadTaskState.phase = BulkLoadPhase::Running;
															#line 14414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont13cont14cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont13cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13cont1(Void const& _,int loopDepth) 
	{
															#line 1896 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetRunningStateTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 1901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 14513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13cont1(Void && _,int loopDepth) 
	{
															#line 1896 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent( bulkLoadVerboseEventSev(), "DDBulkLoadTaskSetRunningStateTransaction", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("JobID", newBulkLoadTaskState.getJobId()) .detail("TaskID", newBulkLoadTaskState.getTaskId());
															#line 1901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove.bulkLoadTaskState = newBulkLoadTaskState;
															#line 14524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont13cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont13cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont13cont11cont1(Void const& _,int loopDepth) 
	{
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_15 = tr.commit();
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont1when1(__when_expr_15.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 15, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1(Void && _,int loopDepth) 
	{
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_15 = tr.commit();
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont1when1(__when_expr_15.get(), loopDepth); };
		static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 16;
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 15, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont13cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont13cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1cont13cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end && bulkLoadTaskState.present())
															#line 14715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 1926 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistRunningState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId.toString()) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 14721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "DataMoveMetaDataCommit", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("CommitVersion", tr.getCommittedVersion()) .detail("DeltaRange", currentKeys.toString()) .detail("Range", describe(dataMove.ranges)) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 14729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1947 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 14733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_16 = auditLocationMetadataPostCheck(occ, keys, "startMoveShards_postcheck", dataMoveId);
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont2when1(__when_expr_16.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 16, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont11cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2(Void && _,int loopDepth) 
	{
															#line 1924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end && bulkLoadTaskState.present())
															#line 14763 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			Version commitVersion = tr.getCommittedVersion();
															#line 1926 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadTaskPersistRunningState", relocationIntervalId) .detail("JobID", bulkLoadTaskState.get().getJobId()) .detail("DataMoveID", dataMoveId.toString()) .detail("TaskID", bulkLoadTaskState.get().getTaskId()) .detail("TaskRange", bulkLoadTaskState.get().getRange()) .detail("CommitVersion", commitVersion);
															#line 14769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 1934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "DataMoveMetaDataCommit", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("CommitVersion", tr.getCommittedVersion()) .detail("DeltaRange", currentKeys.toString()) .detail("Range", describe(dataMove.ranges)) .detail("DataMove", dataMove.toString()) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "");
															#line 1944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dataMove = DataMoveMetaData();
															#line 1945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentKeys.end == keys.end)
															#line 14777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 1947 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (SERVER_KNOBS->AUDIT_DATAMOVE_POST_CHECK)
															#line 14781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_16 = auditLocationMetadataPostCheck(occ, keys, "startMoveShards_postcheck", dataMoveId);
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont11cont2when1(__when_expr_16.get(), loopDepth); };
				static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 1948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< StartMoveShardsActor, 16, Void >*>(static_cast<StartMoveShardsActor*>(this)));
															#line 14792 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont13cont11cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont13cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont13cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1cont13cont11cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont5(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont13cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont13cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont1loopBody1cont13cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<StartMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<StartMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<StartMoveShardsActor*>(this)->ActorCallback< StartMoveShardsActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< StartMoveShardsActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< StartMoveShardsActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> servers;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	MoveKeysLock lock;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock* startMoveKeysLock;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CancelConflictingDataMoves cancelConflictingDataMoves;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Optional<BulkLoadTaskState> bulkLoadTaskState;
															#line 1628 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Future<Void> warningLogger;
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool loadedTssMapping;
															#line 1633 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	DataMoveMetaData dataMove;
															#line 1634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Severity sevDm;
															#line 1643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef keys;
															#line 1644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool cancelDataMove;
															#line 1645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	bool runPreCheck;
															#line 1648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 1652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Transaction tr;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult old;
															#line 1731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 1735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	int oldIndex;
															#line 1742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRangeRef rangeIntersectKeys;
															#line 1743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> src;
															#line 1744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> dest;
															#line 1745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID srcId;
															#line 1746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID destId;
															#line 1758 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	std::vector<UID> owners;
															#line 1873 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	BulkLoadTaskState newBulkLoadTaskState;
															#line 15261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via startMoveShards()
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class StartMoveShardsActor final : public Actor<Void>, public ActorCallback< StartMoveShardsActor, 0, Void >, public ActorCallback< StartMoveShardsActor, 1, Void >, public ActorCallback< StartMoveShardsActor, 2, Optional<Value> >, public ActorCallback< StartMoveShardsActor, 3, Void >, public ActorCallback< StartMoveShardsActor, 4, Void >, public ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >, public ActorCallback< StartMoveShardsActor, 6, RangeResult >, public ActorCallback< StartMoveShardsActor, 7, RangeResult >, public ActorCallback< StartMoveShardsActor, 8, Void >, public ActorCallback< StartMoveShardsActor, 9, Void >, public ActorCallback< StartMoveShardsActor, 10, Void >, public ActorCallback< StartMoveShardsActor, 11, Optional<Value> >, public ActorCallback< StartMoveShardsActor, 12, Void >, public ActorCallback< StartMoveShardsActor, 13, Void >, public ActorCallback< StartMoveShardsActor, 14, Void >, public ActorCallback< StartMoveShardsActor, 15, Void >, public ActorCallback< StartMoveShardsActor, 16, Void >, public ActorCallback< StartMoveShardsActor, 17, Void >, public ActorCallback< StartMoveShardsActor, 18, Void >, public FastAllocated<StartMoveShardsActor>, public StartMoveShardsActorState<StartMoveShardsActor> {
															#line 15266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<StartMoveShardsActor>::operator new;
	using FastAllocated<StartMoveShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(941114661284741120UL, 11160531706947221504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMoveShardsActor, 0, Void >;
friend struct ActorCallback< StartMoveShardsActor, 1, Void >;
friend struct ActorCallback< StartMoveShardsActor, 2, Optional<Value> >;
friend struct ActorCallback< StartMoveShardsActor, 3, Void >;
friend struct ActorCallback< StartMoveShardsActor, 4, Void >;
friend struct ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >;
friend struct ActorCallback< StartMoveShardsActor, 6, RangeResult >;
friend struct ActorCallback< StartMoveShardsActor, 7, RangeResult >;
friend struct ActorCallback< StartMoveShardsActor, 8, Void >;
friend struct ActorCallback< StartMoveShardsActor, 9, Void >;
friend struct ActorCallback< StartMoveShardsActor, 10, Void >;
friend struct ActorCallback< StartMoveShardsActor, 11, Optional<Value> >;
friend struct ActorCallback< StartMoveShardsActor, 12, Void >;
friend struct ActorCallback< StartMoveShardsActor, 13, Void >;
friend struct ActorCallback< StartMoveShardsActor, 14, Void >;
friend struct ActorCallback< StartMoveShardsActor, 15, Void >;
friend struct ActorCallback< StartMoveShardsActor, 16, Void >;
friend struct ActorCallback< StartMoveShardsActor, 17, Void >;
friend struct ActorCallback< StartMoveShardsActor, 18, Void >;
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	StartMoveShardsActor(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& ranges,std::vector<UID> const& servers,MoveKeysLock const& lock,FlowLock* const& startMoveKeysLock,UID const& relocationIntervalId,std::map<UID, StorageServerInterface>* const& tssMapping,const DDEnabledState* const& ddEnabledState,CancelConflictingDataMoves const& cancelConflictingDataMoves,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 15301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   StartMoveShardsActorState<StartMoveShardsActor>(occ, dataMoveId, ranges, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState, cancelConflictingDataMoves, bulkLoadTaskState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMoveShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9292717044462406400UL, 7153354930560426240UL);
		ActorExecutionContextHelper __helper(static_cast<StartMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMoveShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMoveShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMoveShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartMoveShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartMoveShardsActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartMoveShardsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartMoveShardsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StartMoveShardsActor, 5, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StartMoveShardsActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< StartMoveShardsActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< StartMoveShardsActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< StartMoveShardsActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< StartMoveShardsActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< StartMoveShardsActor, 11, Optional<Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< StartMoveShardsActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< StartMoveShardsActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< StartMoveShardsActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< StartMoveShardsActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< StartMoveShardsActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< StartMoveShardsActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< StartMoveShardsActor, 18, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> startMoveShards( Database const& occ, UID const& dataMoveId, std::vector<KeyRange> const& ranges, std::vector<UID> const& servers, MoveKeysLock const& lock, FlowLock* const& startMoveKeysLock, UID const& relocationIntervalId, std::map<UID, StorageServerInterface>* const& tssMapping, const DDEnabledState* const& ddEnabledState, CancelConflictingDataMoves const& cancelConflictingDataMoves, Optional<BulkLoadTaskState> const& bulkLoadTaskState ) {
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new StartMoveShardsActor(occ, dataMoveId, ranges, servers, lock, startMoveKeysLock, relocationIntervalId, tssMapping, ddEnabledState, cancelConflictingDataMoves, bulkLoadTaskState));
															#line 15351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 1980 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

															#line 15356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via checkDataMoveComplete()
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class CheckDataMoveCompleteActor>
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckDataMoveCompleteActorState {
															#line 15362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckDataMoveCompleteActorState(Database const& occ,UID const& dataMoveId,KeyRange const& keys,UID const& relocationIntervalId) 
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   keys(keys),
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId)
															#line 15375 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDataMoveComplete", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataMoveCompleteActorState() 
	{
		fdb_probe_actor_destroy("checkDataMoveComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr = makeReference<ReadYourWritesTransaction>(occ);
															#line 1984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				begin = keys.begin;
															#line 1985 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				;
															#line 15395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataMoveCompleteActorState();
		static_cast<CheckDataMoveCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2042 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<CheckDataMoveCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataMoveCompleteActorState(); static_cast<CheckDataMoveCompleteActor*>(this)->destroy(); return 0; }
															#line 15424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<CheckDataMoveCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataMoveCompleteActorState();
		static_cast<CheckDataMoveCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2038 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevDebug, "CheckDataMoveCompleteError", relocationIntervalId).errorUnsuppressed(e);
															#line 2039 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 15439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1985 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(begin < keys.end))
															#line 15466 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1986 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 15472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1988 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->getTransaction().trState->taskID = TaskPriority::MoveKeys;
															#line 1989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1990 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			currentKeys = KeyRangeRef(begin, keys.end);
															#line 1996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, keyServersPrefix, currentKeys, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 1996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15518 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 1;
															#line 1996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2033 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 2033 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15560 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 3;
															#line 2033 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 2, Void >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 2003 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		endKey = keyServers.back().key;
															#line 2004 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentKeys = KeyRangeRef(currentKeys.begin, endKey);
															#line 2007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15586 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 2;
															#line 2007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*>(static_cast<CheckDataMoveCompleteActor*>(this)));
															#line 15591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 15600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 2008 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2010 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;++i) {
															#line 2011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			KeyRangeRef rangeIntersectKeys(keyServers[i].key, keyServers[i + 1].key);
															#line 2012 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> src;
															#line 2013 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> dest;
															#line 2014 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID srcId;
															#line 2015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			UID destId;
															#line 2016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 2017 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			const KeyRange currentRange = KeyRangeRef(keyServers[i].key, keyServers[i + 1].key);
															#line 2018 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevVerbose, "CheckDataMoveCompleteShard", relocationIntervalId) .detail("Range", currentRange) .detail("SrcID", srcId) .detail("Src", describe(src)) .detail("DestID", destId) .detail("Dest", describe(dest));
															#line 2024 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!dest.empty() || srcId != dataMoveId)
															#line 15699 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2026 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 15703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2030 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		begin = endKey;
															#line 15708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 2007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 15717 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state > 0) static_cast<CheckDataMoveCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataMoveCompleteActor*>(this)->ActorCallback< CheckDataMoveCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataMoveCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Database occ;
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID dataMoveId;
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange keys;
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	UID relocationIntervalId;
															#line 1983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key begin;
															#line 1994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	KeyRange currentKeys;
															#line 1996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult keyServers;
															#line 2003 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	Key endKey;
															#line 2007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 15912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
};
// This generated class is to be used only via checkDataMoveComplete()
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class CheckDataMoveCompleteActor final : public Actor<Void>, public ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >, public ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >, public ActorCallback< CheckDataMoveCompleteActor, 2, Void >, public FastAllocated<CheckDataMoveCompleteActor>, public CheckDataMoveCompleteActorState<CheckDataMoveCompleteActor> {
															#line 15917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
	using FastAllocated<CheckDataMoveCompleteActor>::operator new;
	using FastAllocated<CheckDataMoveCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10298216542648345088UL, 13061617921756399872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >;
friend struct ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >;
friend struct ActorCallback< CheckDataMoveCompleteActor, 2, Void >;
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	CheckDataMoveCompleteActor(Database const& occ,UID const& dataMoveId,KeyRange const& keys,UID const& relocationIntervalId) 
															#line 15936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataMoveCompleteActorState<CheckDataMoveCompleteActor>(occ, dataMoveId, keys, relocationIntervalId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(201830314997397504UL, 2479849471865947136UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataMoveCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataMoveComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataMoveComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataMoveCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
[[nodiscard]] static Future<Void> checkDataMoveComplete( Database const& occ, UID const& dataMoveId, KeyRange const& keys, UID const& relocationIntervalId ) {
															#line 1981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	return Future<Void>(new CheckDataMoveCompleteActor(occ, dataMoveId, keys, relocationIntervalId));
															#line 15970 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
}

#line 2044 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"

// Set keyServers[keys].src = keyServers[keys].dest and keyServers[keys].dest=[], return when successful
// keyServers[k].dest must be the same for all k in keys.
// Set serverKeys[dest][keys] = dataMoveId; serverKeys[src][keys] = false for all src not in dest.
// Clear dataMoves[dataMoveId].
															#line 15979 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
// This generated class is to be used only via finishMoveShards()
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
template <class FinishMoveShardsActor>
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
class FinishMoveShardsActorState {
															#line 15985 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
public:
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
	FinishMoveShardsActorState(Database const& occ,UID const& dataMoveId,std::vector<KeyRange> const& targetRanges,std::vector<UID> const& destinationTeam,MoveKeysLock const& lock,FlowLock* const& finishMoveKeysParallelismLock,bool const& hasRemote,UID const& relocationIntervalId,std::map<UID, StorageServerInterface> const& tssMapping,const DDEnabledState* const& ddEnabledState,Optional<BulkLoadTaskState> const& bulkLoadTaskState) 
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		 : occ(occ),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   targetRanges(targetRanges),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   destinationTeam(destinationTeam),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   lock(lock),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   finishMoveKeysParallelismLock(finishMoveKeysParallelismLock),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   hasRemote(hasRemote),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   relocationIntervalId(relocationIntervalId),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   tssMapping(tssMapping),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		   bulkLoadTaskState(bulkLoadTaskState)
															#line 16012 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
	{
		fdb_probe_actor_create("finishMoveShards", reinterpret_cast<unsigned long>(this));

	}
	~FinishMoveShardsActorState() 
	{
		fdb_probe_actor_destroy("finishMoveShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2061 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(targetRanges.size() == 1);
															#line 2062 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			keys = targetRanges[0];
															#line 2063 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			warningLogger = logWarningAfter("FinishMoveShardsTooLong", 600, destinationTeam);
															#line 2064 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			retries = 0;
															#line 2065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = DataMoveMetaData();
															#line 2066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			cancelDataMove = false;
															#line 2067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 2069 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_0 = finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 2069 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16043 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 1;
															#line 2069 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 0, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16048 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 2071 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 2072 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		skipTss = false;
															#line 2073 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ssReadyTime = std::numeric_limits<double>::max();
															#line 2075 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!destinationTeam.empty());
															#line 16079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "FinishMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", keys);
															#line 2084 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 16085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser = FlowLock::Releaser(*finishMoveKeysParallelismLock);
															#line 2071 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		runPreCheck = true;
															#line 2072 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		skipTss = false;
															#line 2073 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ssReadyTime = std::numeric_limits<double>::max();
															#line 2075 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!destinationTeam.empty());
															#line 16108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevInfo, "FinishMoveShardsBegin", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("TargetRange", keys);
															#line 2084 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			;
															#line 16114 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(SevInfo, "FinishMoveShardsEnd", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("BulkLoadTaskID", bulkLoadTaskState.present() ? bulkLoadTaskState.get().getTaskId().toString() : "") .detail("DataMove", dataMove.toString());
															#line 2430 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsError", relocationIntervalId).errorUnsuppressed(e);
															#line 2423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 16221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		completeSrc = std::vector<UID>();
															#line 2086 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destServers = std::vector<UID>();
															#line 2087 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers = std::unordered_set<UID>();
															#line 2088 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = KeyRange();
															#line 2089 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tr = Transaction(occ);
															#line 16256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		try {
															#line 2091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.trState->taskID = TaskPriority::MoveKeys;
															#line 2092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2093 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2094 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLock(&tr, lock, ddEnabledState);
															#line 2096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 2;
															#line 2096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 1, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 2395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "TryFinishMoveShardsError", relocationIntervalId) .errorUnsuppressed(error) .detail("DataMoveID", dataMoveId);
															#line 2398 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (error.code() == error_code_location_metadata_corruption)
															#line 16312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1Catch1(location_metadata_corruption(), std::max(0, loopDepth - 1));
															#line 16316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
			else
			{
															#line 2400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (error.code() == error_code_retry)
															#line 16322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2401 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					runPreCheck = false;
															#line 2402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					++retries;
															#line 2403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					StrictFuture<Void> __when_expr_16 = delay(1);
															#line 2403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16332 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_16.get(), loopDepth); };
					static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 17;
															#line 2403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 16, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 2404 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					if (error.code() == error_code_actor_cancelled)
															#line 16344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					{
															#line 2405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						return a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
															#line 16348 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
					}
					else
					{
															#line 2407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						err = error;
															#line 2408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						runPreCheck = false;
															#line 2409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						StrictFuture<Void> __when_expr_17 = tr.onError(err);
															#line 2409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when2(__when_expr_17.get(), loopDepth); };
						static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 18;
															#line 2409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
						__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 17, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16365 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16385 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16401 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 3;
															#line 2098 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& val,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 16490 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2100 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = decodeDataMoveValue(val.get());
															#line 2101 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "FinishMoveShardsFoundDataMove", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 2107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 16498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 2109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 3, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 2125 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleted", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = checkDataMoveComplete(occ, dataMoveId, keys, relocationIntervalId);
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_4.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 4, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && val,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (val.present())
															#line 16544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2100 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			dataMove = decodeDataMoveValue(val.get());
															#line 2101 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(sevDm, "FinishMoveShardsFoundDataMove", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveKey", dataMoveKeyFor(dataMoveId)) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString()) .detail("CancelDataMove", cancelDataMove);
															#line 2107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (cancelDataMove)
															#line 16552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				dataMove.setPhase(DataMoveMetaData::Deleting);
															#line 2109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tr.set(dataMoveKeyFor(dataMoveId), dataMoveValue(dataMove));
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16562 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 4;
															#line 2110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 3, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 2125 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleted", relocationIntervalId) .detail("AtVerison", tr.getReadVersion().get()) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_4 = checkDataMoveComplete(occ, dataMoveId, keys, relocationIntervalId);
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_4.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 5;
															#line 2129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 4, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 2133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 6;
															#line 2133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 5, RangeResult >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 2113 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destServers.insert(destServers.end(), dataMove.dest.begin(), dataMove.dest.end());
															#line 2114 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::sort(destServers.begin(), destServers.end());
															#line 2115 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (dataMove.getPhase() == DataMoveMetaData::Deleting)
															#line 16693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarn, "FinishMoveShardsDataMoveDeleting", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("DataMove", dataMove.toString());
															#line 2119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(data_move_cancelled(), loopDepth);
															#line 16699 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2121 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(dataMove.getPhase() == DataMoveMetaData::Running);
															#line 2122 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!dataMove.ranges.empty());
															#line 2123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = dataMove.ranges.front();
															#line 16707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 16716 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		return a_body1cont1loopBody1Catch1(movekeys_conflict(), loopDepth);
															#line 16724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 2130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16807 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 2130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!static_cast<FinishMoveShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishMoveShardsActorState(); static_cast<FinishMoveShardsActor*>(this)->destroy(); return 0; }
															#line 16819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		new (&static_cast<FinishMoveShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishMoveShardsActorState();
		static_cast<FinishMoveShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 2134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = krmGetRanges(&tr, keyServersPrefix, range, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 2136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont11when1(__when_expr_6.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 7;
															#line 2136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 6, RangeResult >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 16915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 2133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 16924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11cont1(int loopDepth) 
	{
															#line 2141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!keyServers.empty());
															#line 2142 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		range = KeyRangeRef(range.begin, keyServers.back().key);
															#line 2143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(!range.empty());
															#line 2145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		currentIndex = 0;
															#line 2146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		;
															#line 17011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 2136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		keyServers = __keyServers;
															#line 17020 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont11cont2(int loopDepth) 
	{
															#line 2202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady = std::vector<Future<Void>>();
															#line 2203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReady = std::vector<Future<Void>>();
															#line 2204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		tssReadyInterfs = std::vector<StorageServerInterface>();
															#line 2205 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		newDestinations = std::vector<UID>();
															#line 2206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> completeSrcSet(completeSrc.begin(), completeSrc.end());
															#line 2207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const UID& id : destServers ) {
															#line 2208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!hasRemote || !completeSrcSet.contains(id))
															#line 17111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				newDestinations.push_back(id);
															#line 17115 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2213 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 2214 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 2215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListEntries.reserve(newDestinations.size());
															#line 2216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for( const UID& id : newDestinations ) {
															#line 2217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(id)));
															#line 17128 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_8 = getAll(serverListEntries);
															#line 2219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17134 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 9;
															#line 2219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont11cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1(int loopDepth) 
	{
															#line 2146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (!(currentIndex < keyServers.size() - 1))
															#line 17155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont11cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		src = std::vector<UID>();
															#line 2148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		dest = std::vector<UID>();
															#line 2149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		srcId = UID();
															#line 2150 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		destId = UID();
															#line 2151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyServers[currentIndex].value, src, dest, srcId, destId);
															#line 2152 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		const KeyRange currentRange = KeyRangeRef(keyServers[currentIndex].key, keyServers[currentIndex + 1].key);
															#line 2154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsProcessingShard", relocationIntervalId) .detail("Range", currentRange) .detail("SrcID", srcId) .detail("Src", describe(src)) .detail("DestID", destId) .detail("Dest", describe(dest)) .detail("DataMove", dataMove.toString());
															#line 2161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers.insert(src.begin(), src.end());
															#line 2162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		allServers.insert(dest.begin(), dest.end());
															#line 2163 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (destId != dataMoveId)
															#line 17179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2164 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			TraceEvent(SevWarnAlways, "FinishMoveShardsInconsistentIDs", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ExistingShardID", destId) .detail("DataMove", dataMove.toString());
															#line 2168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			cancelDataMove = true;
															#line 2169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			return a_body1cont1loopBody1Catch1(retry(), std::max(0, loopDepth - 1));
															#line 17187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (SERVER_KNOBS->AUDIT_DATAMOVE_PRE_CHECK && runPreCheck)
															#line 17191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 2175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 2176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_7 = auditLocationMetadataPreCheck( occ, &tr, currentRange, servers, "finishMoveShards_precheck", dataMoveId);
															#line 2176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont11cont1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 8;
															#line 2176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 7, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont11cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont1(int loopDepth) 
	{
															#line 2180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::sort(dest.begin(), dest.end());
															#line 2181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		ASSERT(std::equal(destServers.begin(), destServers.end(), dest.begin(), dest.end()));
															#line 2183 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		std::set<UID> srcSet;
															#line 2184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < src.size();s++) {
															#line 2185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			srcSet.insert(src[s]);
															#line 17241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (currentIndex == 0)
															#line 17245 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			completeSrc = src;
															#line 17249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
		else
		{
															#line 2191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for(int i = 0;i < completeSrc.size();i++) {
															#line 2192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				if (!srcSet.contains(completeSrc[i]))
															#line 17257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				{
															#line 2193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
					swapAndPop(&completeSrc, i--);
															#line 17261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
				}
			}
		}
															#line 2146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		++currentIndex;
															#line 17267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont11cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont11cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont11cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont11cont3(int loopDepth) 
	{
															#line 2221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		releaser.release();
															#line 2223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 2225 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (!serverListValues[s].present())
															#line 17367 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				return a_body1cont1loopBody1Catch1(retry(), loopDepth);
															#line 17371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2228 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto si = decodeServerListValue(serverListValues[s].get());
															#line 2229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ASSERT(si.id() == newDestinations[s]);
															#line 2230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			storageServerInterfaces.push_back(si);
															#line 17379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		}
															#line 2236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverReady.reserve(storageServerInterfaces.size());
															#line 2237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < storageServerInterfaces.size();s++) {
															#line 2238 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			serverReady.push_back(waitForShardReady( storageServerInterfaces[s], range, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 2241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (skipTss)
															#line 17389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
				continue;
			}
															#line 2244 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			auto tssPair = tssMapping.find(storageServerInterfaces[s].id());
															#line 2246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssPair != tssMapping.end())
															#line 17397 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReadyInterfs.push_back(tssPair->second);
															#line 2248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssReady.push_back(waitForShardReady( tssPair->second, range, tr.getReadVersion().get(), GetShardStateRequest::READABLE));
															#line 17403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitingServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("NewDestinations", describe(newDestinations)) .detail("DataMove", dataMove.toString());
															#line 2260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeout(waitForAll(serverReady) && waitForAllReady(tssReady), SERVER_KNOBS->SERVER_READY_QUORUM_TIMEOUT, Void(), TaskPriority::MoveKeys);
															#line 2260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 10;
															#line 2260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 9, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 2219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		serverListValues = __serverListValues;
															#line 17426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont1loopBody1cont11cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state > 0) static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 0;
		static_cast<FinishMoveShardsActor*>(this)->ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FinishMoveShardsActor, 8, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishMoveShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishMoveShards", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont11cont7(Void const& _,int loopDepth) 
	{
															#line 2265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServers = std::vector<UID>();
															#line 2266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();++s) {
															#line 2267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (serverReady[s].isReady() && !serverReady[s].isError())
															#line 17509 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				readyServers.push_back(storageServerInterfaces[s].uniqueID);
															#line 17513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 2272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 2273 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssReady[s].isReady() && !tssReady[s].isError())
															#line 17522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssCount += 1;
															#line 17526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == serverReady.size() && !skipTss)
															#line 17531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssReadyTime = std::min(now(), ssReadyTime);
															#line 2280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssCount < tssReady.size() && now() - ssReadyTime >= SERVER_KNOBS->DD_WAIT_TSS_DATA_MOVE_DELAY)
															#line 17537 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				skipTss = true;
															#line 2283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "FinishMoveShardsSkipTSS") .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("TSSInfo", describe(tssReadyInterfs)) .detail("SSReadyTime", ssReadyTime);
															#line 17543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitedServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("DataMove", dataMove.toString());
															#line 2300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == newDestinations.size())
															#line 17550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Void>> actors;
															#line 2303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, keyServersPrefix, range, allKeys, keyServersValue(destServers, {}, dataMoveId, UID())));
															#line 2306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& ssId : allServers ) {
															#line 2307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				const bool destHasServer = std::find(destServers.begin(), destServers.end(), ssId) != destServers.end();
															#line 2309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(ssId), range, allKeys, destHasServer ? serverKeysValue(dataMoveId) : serverKeysFalse));
															#line 2315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(sevDm, "FinishMoveShardsSetServerKeyRange", relocationIntervalId) .detail("StorageServerID", ssId) .detail("KeyRange", range) .detail("ShardID", destHasServer ? dataMoveId : UID()) .detail("DataMove", dataMove.toString());
															#line 17564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
															#line 2322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			StrictFuture<Void> __when_expr_10 = waitForAll(actors);
															#line 2322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (static_cast<FinishMoveShardsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont7when1(__when_expr_10.get(), loopDepth); };
			static_cast<FinishMoveShardsActor*>(this)->actor_wait_state = 11;
															#line 2322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FinishMoveShardsActor, 10, Void >*>(static_cast<FinishMoveShardsActor*>(this)));
															#line 17575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			tr.reset();
															#line 17582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont11cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont7(Void && _,int loopDepth) 
	{
															#line 2265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		readyServers = std::vector<UID>();
															#line 2266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < serverReady.size();++s) {
															#line 2267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (serverReady[s].isReady() && !serverReady[s].isError())
															#line 17596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				readyServers.push_back(storageServerInterfaces[s].uniqueID);
															#line 17600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		int tssCount = 0;
															#line 2272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		for(int s = 0;s < tssReady.size();s++) {
															#line 2273 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssReady[s].isReady() && !tssReady[s].isError())
															#line 17609 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				tssCount += 1;
															#line 17613 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == serverReady.size() && !skipTss)
															#line 17618 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			ssReadyTime = std::min(now(), ssReadyTime);
															#line 2280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			if (tssCount < tssReady.size() && now() - ssReadyTime >= SERVER_KNOBS->DD_WAIT_TSS_DATA_MOVE_DELAY)
															#line 17624 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			{
															#line 2282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				skipTss = true;
															#line 2283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				TraceEvent(SevWarnAlways, "FinishMoveShardsSkipTSS") .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("TSSInfo", describe(tssReadyInterfs)) .detail("SSReadyTime", ssReadyTime);
															#line 17630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
			}
		}
															#line 2293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		TraceEvent(sevDm, "FinishMoveShardsWaitedServers", relocationIntervalId) .detail("DataMoveID", dataMoveId) .detail("ReadyServers", describe(readyServers)) .detail("NewDestinations", describe(newDestinations)) .detail("ReadyTSS", tssCount) .detail("DataMove", dataMove.toString());
															#line 2300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
		if (readyServers.size() == newDestinations.size())
															#line 17637 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/MoveKeys.actor.g.cpp"
		{
															#line 2302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			std::vector<Future<Void>> actors;
															#line 2303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			actors.push_back(krmSetRangeCoalescing( &tr, keyServersPrefix, range, allKeys, keyServersValue(destServers, {}, dataMoveId, UID())));
															#line 2306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
			for( const UID& ssId : allServers ) {
															#line 2307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				const bool destHasServer = std::find(destServers.begin(), destServers.end(), ssId) != destServers.end();
															#line 2309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/MoveKeys.actor.cpp"
				actors.push_back( krmSetRangeCoalescing(&tr, serverKeysPrefixFor(ssId), range, allKeys, destHasServer ? serverKeysValue(dataMoveId) : serverKeysFalse));
															#line 2315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/M