#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
/*
 * ClusterRecovery.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cmath>
#include <utility>

#include "fdbclient/FDBTypes.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbrpc/sim_validation.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/WaitFailure.h"
#include "flow/Error.h"
#include "flow/ProtocolVersion.h"
#include "flow/Trace.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
EncryptionAtRestMode getEncryptionAtRest(DatabaseConfiguration config) {
	TraceEvent(SevDebug, "CREncryptionAtRestMode").detail("Mode", config.encryptionAtRestMode.toString());
	return config.encryptionAtRestMode;
}
} // namespace

static std::set<int> const& normalClusterRecoveryErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_operation_failed);
		s.insert(error_code_tlog_stopped);
		s.insert(error_code_tlog_failed);
		s.insert(error_code_commit_proxy_failed);
		s.insert(error_code_grv_proxy_failed);
		s.insert(error_code_resolver_failed);
		s.insert(error_code_backup_worker_failed);
		s.insert(error_code_recruitment_failed);
		s.insert(error_code_no_more_servers);
		s.insert(error_code_cluster_recovery_failed);
		s.insert(error_code_coordinated_state_conflict);
		s.insert(error_code_master_max_versions_in_flight);
		s.insert(error_code_worker_removed);
		s.insert(error_code_new_coordinators_timed_out);
		s.insert(error_code_broken_promise);
	}
	return s;
}

															#line 70 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recoveryTerminateOnConflict()
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecoveryTerminateOnConflictActor>
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoveryTerminateOnConflictActorState {
															#line 77 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoveryTerminateOnConflictActorState(UID const& dbgid,Promise<Void> const& fullyRecovered,Future<Void> const& onConflict,Future<Void> const& switchedState) 
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : dbgid(dbgid),
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fullyRecovered(fullyRecovered),
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   onConflict(onConflict),
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   switchedState(switchedState)
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this));

	}
	~RecoveryTerminateOnConflictActorState() 
	{
		fdb_probe_actor_destroy("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onConflict;
															#line 72 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 81 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = switchedState;
															#line 111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*>(static_cast<RecoveryTerminateOnConflictActor*>(this)));
															#line 81 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*>(static_cast<RecoveryTerminateOnConflictActor*>(this)));
															#line 118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!fullyRecovered.isSet())
															#line 141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 75 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecoveryTerminated", dbgid).detail("Reason", "Conflict");
															#line 76 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Coordinated state conflict, recovery terminating");
															#line 77 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 79 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 153 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!fullyRecovered.isSet())
															#line 165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 75 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecoveryTerminated", dbgid).detail("Reason", "Conflict");
															#line 76 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Coordinated state conflict, recovery terminating");
															#line 77 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 79 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 177 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state > 0) static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state = 0;
		static_cast<RecoveryTerminateOnConflictActor*>(this)->ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >::remove();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UID dbgid;
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Promise<Void> fullyRecovered;
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> onConflict;
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> switchedState;
															#line 338 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recoveryTerminateOnConflict()
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoveryTerminateOnConflictActor final : public Actor<Void>, public ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >, public ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >, public FastAllocated<RecoveryTerminateOnConflictActor>, public RecoveryTerminateOnConflictActorState<RecoveryTerminateOnConflictActor> {
															#line 343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecoveryTerminateOnConflictActor>::operator new;
	using FastAllocated<RecoveryTerminateOnConflictActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13227387546783051776UL, 7874795474698337280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >;
friend struct ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >;
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoveryTerminateOnConflictActor(UID const& dbgid,Promise<Void> const& fullyRecovered,Future<Void> const& onConflict,Future<Void> const& switchedState) 
															#line 361 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecoveryTerminateOnConflictActorState<RecoveryTerminateOnConflictActor>(dbgid, fullyRecovered, onConflict, switchedState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3494608132086867968UL, 16817190675191708928UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoveryTerminateOnConflict");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recoveryTerminateOnConflict( UID const& dbgid, Promise<Void> const& fullyRecovered, Future<Void> const& onConflict, Future<Void> const& switchedState ) {
															#line 68 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecoveryTerminateOnConflictActor(dbgid, fullyRecovered, onConflict, switchedState));
															#line 394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 86 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitNewMaster()
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitNewMasterActor>
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitNewMasterActorState {
															#line 406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitNewMasterActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,MasterInterface* const& newMaster) 
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : cluster(cluster),
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   db(db),
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   newMaster(newMaster),
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fNewMaster(),
															#line 91 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   masterWorker()
															#line 421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitNewMaster", reinterpret_cast<unsigned long>(this));

	}
	~RecruitNewMasterActorState() 
	{
		fdb_probe_actor_destroy("recruitNewMaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitNewMasterActorState();
		static_cast<RecruitNewMasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 97 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 98 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		id_used[cluster->clusterControllerProcessId]++;
															#line 99 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		masterWorker = cluster->getWorkerForRoleInDatacenter( cluster->clusterControllerDcId, ProcessClass::Master, ProcessClass::NeverAssign, db->config, id_used);
															#line 101 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((masterWorker.worker.processClass.machineClassFitness(ProcessClass::Master) > SERVER_KNOBS->EXPECTED_MASTER_FITNESS || masterWorker.worker.interf.locality.processId() == cluster->clusterControllerProcessId) && !cluster->goodRecruitmentTime.isReady())
															#line 472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 105 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id) .detail("Fitness", masterWorker.worker.processClass.machineClassFitness(ProcessClass::Master));
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 0, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 485 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		RecruitMasterRequest rmq;
															#line 111 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		rmq.lifetime = db->serverInfo->get().masterLifetime;
															#line 112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		rmq.forceRecovery = db->forceRecovery;
															#line 114 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cluster->masterProcessId = masterWorker.worker.interf.locality.processId();
															#line 115 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cluster->db.unfinishedRecoveries++;
															#line 116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fNewMaster = masterWorker.worker.interf.master.tryGetReply(rmq);
															#line 117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ready(fNewMaster) || db->forceMasterFailure.onTrigger();
															#line 117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 1, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 518 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (fNewMaster.isReady() && fNewMaster.get().present())
															#line 614 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id).detail("Recruited", fNewMaster.get().get().id());
															#line 122 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitedMasterWorker", cluster->id) .detail("Address", fNewMaster.get().get().address()) .trackLatest(cluster->recruitedMasterWorkerEventHolder->trackingKey);
															#line 126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			*newMaster = fNewMaster.get().get();
															#line 128 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<RecruitNewMasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitNewMasterActorState(); static_cast<RecruitNewMasterActor*>(this)->destroy(); return 0; }
															#line 624 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<RecruitNewMasterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RecruitNewMasterActorState();
			static_cast<RecruitNewMasterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "clusterWatchDatabase() !newMaster.present()");
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->MASTER_SPIN_DELAY);
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 638 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 3;
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 2, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (fNewMaster.isReady() && fNewMaster.get().present())
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id).detail("Recruited", fNewMaster.get().get().id());
															#line 122 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitedMasterWorker", cluster->id) .detail("Address", fNewMaster.get().get().address()) .trackLatest(cluster->recruitedMasterWorkerEventHolder->trackingKey);
															#line 126 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			*newMaster = fNewMaster.get().get();
															#line 128 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<RecruitNewMasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitNewMasterActorState(); static_cast<RecruitNewMasterActor*>(this)->destroy(); return 0; }
															#line 663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<RecruitNewMasterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RecruitNewMasterActorState();
			static_cast<RecruitNewMasterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "clusterWatchDatabase() !newMaster.present()");
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->MASTER_SPIN_DELAY);
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 3;
															#line 131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 2, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* cluster;
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	MasterInterface* newMaster;
															#line 90 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<ErrorOr<MasterInterface>> fNewMaster;
															#line 91 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	WorkerFitnessInfo masterWorker;
															#line 866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitNewMaster()
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitNewMasterActor final : public Actor<Void>, public ActorCallback< RecruitNewMasterActor, 0, Void >, public ActorCallback< RecruitNewMasterActor, 1, Void >, public ActorCallback< RecruitNewMasterActor, 2, Void >, public FastAllocated<RecruitNewMasterActor>, public RecruitNewMasterActorState<RecruitNewMasterActor> {
															#line 871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitNewMasterActor>::operator new;
	using FastAllocated<RecruitNewMasterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2614156676957047552UL, 12489781945542501120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitNewMasterActor, 0, Void >;
friend struct ActorCallback< RecruitNewMasterActor, 1, Void >;
friend struct ActorCallback< RecruitNewMasterActor, 2, Void >;
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitNewMasterActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,MasterInterface* const& newMaster) 
															#line 890 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecruitNewMasterActorState<RecruitNewMasterActor>(cluster, db, newMaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3732730840550338304UL, 7033732201624115456UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitNewMaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recruitNewMaster( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, MasterInterface* const& newMaster ) {
															#line 87 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecruitNewMasterActor(cluster, db, newMaster));
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 930 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecruitFromConfiguration()
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecruitFromConfigurationActor>
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitFromConfigurationActorState {
															#line 937 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitFromConfigurationActorState(ClusterControllerData* const& self,Reference<RecruitWorkersInfo> const& req) 
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   req(req)
															#line 946 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecruitFromConfigurationActorState() 
	{
		fdb_probe_actor_destroy("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "ClusterController RecruitTLogsRequest");
															#line 139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 963 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 141 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req->rep = self->findWorkersForConfiguration(req->req);
															#line 142 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 996 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClusterRecruitFromConfigurationActorState();
			static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 3;
															#line 162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1021 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() == error_code_no_more_servers && self->goodRecruitmentTime.isReady())
															#line 1031 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->outstandingRecruitmentRequests.push_back(req);
															#line 146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarn, "RecruitFromConfigurationNotAvailable", self->id).error(e);
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = req->waitForCompletion.onTrigger();
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1041 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 1;
															#line 147 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1046 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (e.code() == error_code_operation_failed || e.code() == error_code_no_more_servers)
															#line 1053 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent("RecruitFromConfigurationRetry", self->id) .error(e) .detail("GoodRecruitmentTimeReady", self->goodRecruitmentTime.isReady());
															#line 154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					;
															#line 1059 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
				}
				else
				{
															#line 158 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecruitFromConfigurationError", self->id).error(e);
															#line 159 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1068 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->goodRecruitmentTime.isReady()))
															#line 1208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 2;
															#line 155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* self;
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitWorkersInfo> req;
															#line 1417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecruitFromConfiguration()
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitFromConfigurationActor final : public Actor<Void>, public ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >, public ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >, public ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >, public FastAllocated<ClusterRecruitFromConfigurationActor>, public ClusterRecruitFromConfigurationActorState<ClusterRecruitFromConfigurationActor> {
															#line 1422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecruitFromConfigurationActor>::operator new;
	using FastAllocated<ClusterRecruitFromConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15031972467003552768UL, 17126568734416932352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >;
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >;
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >;
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitFromConfigurationActor(ClusterControllerData* const& self,Reference<RecruitWorkersInfo> const& req) 
															#line 1441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterRecruitFromConfigurationActorState<ClusterRecruitFromConfigurationActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12674343851221204992UL, 6486113992575869184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecruitFromConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> clusterRecruitFromConfiguration( ClusterControllerData* const& self, Reference<RecruitWorkersInfo> const& req ) {
															#line 136 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ClusterRecruitFromConfigurationActor(self, req));
															#line 1476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 1481 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecruitRemoteFromConfiguration()
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecruitRemoteFromConfigurationActor>
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitRemoteFromConfigurationActorState {
															#line 1488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitRemoteFromConfigurationActorState(ClusterControllerData* const& self,Reference<RecruitRemoteWorkersInfo> const& req) 
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   req(req)
															#line 1497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecruitRemoteFromConfigurationActorState() 
	{
		fdb_probe_actor_destroy("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "ClusterController RecruitTLogsRequest Remote");
															#line 171 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 1514 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto rep = self->findRemoteWorkersForConfiguration(req->req);
															#line 174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1547 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(rep);
			this->~ClusterRecruitRemoteFromConfigurationActorState();
			static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() == error_code_no_more_servers && self->goodRemoteRecruitmentTime.isReady())
															#line 1582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 177 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->outstandingRemoteRecruitmentRequests.push_back(req);
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarn, "RecruitRemoteFromConfigurationNotAvailable", self->id).error(e);
															#line 179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = req->waitForCompletion.onTrigger();
															#line 179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 1;
															#line 179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (e.code() == error_code_operation_failed || e.code() == error_code_no_more_servers)
															#line 1604 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 183 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent("RecruitRemoteFromConfigurationRetry", self->id) .error(e) .detail("GoodRecruitmentTimeReady", self->goodRemoteRecruitmentTime.isReady());
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					;
															#line 1610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
				}
				else
				{
															#line 190 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecruitRemoteFromConfigurationError", self->id).error(e);
															#line 191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1619 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(req->rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(req->rep);
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(req->rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(req->rep);
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 1759 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 2;
															#line 187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1772 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* self;
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitRemoteWorkersInfo> req;
															#line 1968 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecruitRemoteFromConfiguration()
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitRemoteFromConfigurationActor final : public Actor<RecruitRemoteFromConfigurationReply>, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >, public FastAllocated<ClusterRecruitRemoteFromConfigurationActor>, public ClusterRecruitRemoteFromConfigurationActorState<ClusterRecruitRemoteFromConfigurationActor> {
															#line 1973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecruitRemoteFromConfigurationActor>::operator new;
	using FastAllocated<ClusterRecruitRemoteFromConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3046813347803535360UL, 17463129612215008000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RecruitRemoteFromConfigurationReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >;
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >;
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >;
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitRemoteFromConfigurationActor(ClusterControllerData* const& self,Reference<RecruitRemoteWorkersInfo> const& req) 
															#line 1992 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<RecruitRemoteFromConfigurationReply>(),
		   ClusterRecruitRemoteFromConfigurationActorState<ClusterRecruitRemoteFromConfigurationActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(345303134791771392UL, 3493563476356565248UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecruitRemoteFromConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<RecruitRemoteFromConfigurationReply> clusterRecruitRemoteFromConfiguration( ClusterControllerData* const& self, Reference<RecruitRemoteWorkersInfo> const& req ) {
															#line 166 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<RecruitRemoteFromConfigurationReply>(new ClusterRecruitRemoteFromConfigurationActor(self, req));
															#line 2027 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 197 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2032 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newCommitProxies()
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewCommitProxiesActor>
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewCommitProxiesActorState {
															#line 2039 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewCommitProxiesActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2048 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newCommitProxies", reinterpret_cast<unsigned long>(this));

	}
	~NewCommitProxiesActorState() 
	{
		fdb_probe_actor_destroy("newCommitProxies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<CommitProxyInterface>> initializationReplies;
															#line 200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.commitProxies.size();i++) {
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeCommitProxyRequest req;
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.master = self->masterInterface;
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 205 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryTransactionVersion = self->recoveryTransactionVersion;
															#line 206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.firstProxy = i == 0;
															#line 207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.encryptMode = getEncryptionAtRest(self->configuration);
															#line 208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.commitProxyIndex = i;
															#line 209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("CommitProxyReplies", self->dbgid) .detail("WorkerID", recr.commitProxies[i].id()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("EncryptMode", req.encryptMode.toString()) .detail("FirstProxy", req.firstProxy ? "True" : "False") .detail("CommitProxyIndex", req.commitProxyIndex);
															#line 215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.commitProxies[i].commitProxy.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), commit_proxy_failed()));
															#line 2085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<CommitProxyInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewCommitProxiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewCommitProxiesActor*>(this)->actor_wait_state = 1;
															#line 221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*>(static_cast<NewCommitProxiesActor*>(this)));
															#line 2096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<CommitProxyInterface> const& newRecruits,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("CommitProxyInitializationComplete", self->dbgid).log();
															#line 224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->commitProxies = newRecruits;
															#line 226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewCommitProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewCommitProxiesActorState(); static_cast<NewCommitProxiesActor*>(this)->destroy(); return 0; }
															#line 2123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewCommitProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<CommitProxyInterface> && newRecruits,int loopDepth) 
	{
															#line 222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("CommitProxyInitializationComplete", self->dbgid).log();
															#line 224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->commitProxies = newRecruits;
															#line 226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewCommitProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewCommitProxiesActorState(); static_cast<NewCommitProxiesActor*>(this)->destroy(); return 0; }
															#line 2139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewCommitProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<CommitProxyInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<CommitProxyInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewCommitProxiesActor*>(this)->actor_wait_state > 0) static_cast<NewCommitProxiesActor*>(this)->actor_wait_state = 0;
		static_cast<NewCommitProxiesActor*>(this)->ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,std::vector<CommitProxyInterface> const& value) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,std::vector<CommitProxyInterface> && value) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newCommitProxies()
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewCommitProxiesActor final : public Actor<Void>, public ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >, public FastAllocated<NewCommitProxiesActor>, public NewCommitProxiesActorState<NewCommitProxiesActor> {
															#line 2231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewCommitProxiesActor>::operator new;
	using FastAllocated<NewCommitProxiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16471061762683396864UL, 4125689296154706432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >;
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewCommitProxiesActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewCommitProxiesActorState<NewCommitProxiesActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11322762972454658304UL, 4353504431684175360UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newCommitProxies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newCommitProxies( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewCommitProxiesActor(self, recr));
															#line 2281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 228 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newGrvProxies()
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewGrvProxiesActor>
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewGrvProxiesActorState {
															#line 2293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewGrvProxiesActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newGrvProxies", reinterpret_cast<unsigned long>(this));

	}
	~NewGrvProxiesActorState() 
	{
		fdb_probe_actor_destroy("newGrvProxies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<GrvProxyInterface>> initializationReplies;
															#line 231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.grvProxies.size();i++) {
															#line 232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeGrvProxyRequest req;
															#line 233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.master = self->masterInterface;
															#line 234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 235 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("GrvProxyReplies", self->dbgid).detail("WorkerID", recr.grvProxies[i].id());
															#line 237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.grvProxies[i].grvProxy.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), grv_proxy_failed()));
															#line 2331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 243 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<GrvProxyInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 243 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewGrvProxiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewGrvProxiesActor*>(this)->actor_wait_state = 1;
															#line 243 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*>(static_cast<NewGrvProxiesActor*>(this)));
															#line 2342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<GrvProxyInterface> const& newRecruits,int loopDepth) 
	{
															#line 244 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("GrvProxyInitializationComplete", self->dbgid).log();
															#line 245 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->grvProxies = newRecruits;
															#line 246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewGrvProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewGrvProxiesActorState(); static_cast<NewGrvProxiesActor*>(this)->destroy(); return 0; }
															#line 2369 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewGrvProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<GrvProxyInterface> && newRecruits,int loopDepth) 
	{
															#line 244 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("GrvProxyInitializationComplete", self->dbgid).log();
															#line 245 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->grvProxies = newRecruits;
															#line 246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewGrvProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewGrvProxiesActorState(); static_cast<NewGrvProxiesActor*>(this)->destroy(); return 0; }
															#line 2385 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewGrvProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<GrvProxyInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<GrvProxyInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewGrvProxiesActor*>(this)->actor_wait_state > 0) static_cast<NewGrvProxiesActor*>(this)->actor_wait_state = 0;
		static_cast<NewGrvProxiesActor*>(this)->ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,std::vector<GrvProxyInterface> const& value) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,std::vector<GrvProxyInterface> && value) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newGrvProxies()
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewGrvProxiesActor final : public Actor<Void>, public ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >, public FastAllocated<NewGrvProxiesActor>, public NewGrvProxiesActorState<NewGrvProxiesActor> {
															#line 2477 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewGrvProxiesActor>::operator new;
	using FastAllocated<NewGrvProxiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11062269156354104832UL, 17667236694386417152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >;
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewGrvProxiesActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2494 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewGrvProxiesActorState<NewGrvProxiesActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11438231847512378624UL, 17857379825113892352UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newGrvProxies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newGrvProxies( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewGrvProxiesActor(self, recr));
															#line 2527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2532 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newResolvers()
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewResolversActor>
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewResolversActorState {
															#line 2539 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewResolversActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newResolvers", reinterpret_cast<unsigned long>(this));

	}
	~NewResolversActorState() 
	{
		fdb_probe_actor_destroy("newResolvers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<ResolverInterface>> initializationReplies;
															#line 251 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.resolvers.size();i++) {
															#line 252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeResolverRequest req;
															#line 253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 254 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 255 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.commitProxyCount = recr.commitProxies.size();
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.resolverCount = recr.resolvers.size();
															#line 257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.encryptMode = getEncryptionAtRest(self->configuration);
															#line 258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("ResolverReplies", self->dbgid).detail("WorkerID", recr.resolvers[i].id());
															#line 259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.resolvers[i].resolver.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), resolver_failed()));
															#line 2581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<ResolverInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewResolversActor*>(this)->actor_wait_state = 1;
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*>(static_cast<NewResolversActor*>(this)));
															#line 2592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolverInterface> const& newRecruits,int loopDepth) 
	{
															#line 266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ResolverInitializationComplete", self->dbgid).log();
															#line 267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->resolvers = newRecruits;
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewResolversActorState(); static_cast<NewResolversActor*>(this)->destroy(); return 0; }
															#line 2619 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolverInterface> && newRecruits,int loopDepth) 
	{
															#line 266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ResolverInitializationComplete", self->dbgid).log();
															#line 267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->resolvers = newRecruits;
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewResolversActorState(); static_cast<NewResolversActor*>(this)->destroy(); return 0; }
															#line 2635 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolverInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolverInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewResolversActor*>(this)->actor_wait_state > 0) static_cast<NewResolversActor*>(this)->actor_wait_state = 0;
		static_cast<NewResolversActor*>(this)->ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,std::vector<ResolverInterface> const& value) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,std::vector<ResolverInterface> && value) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2722 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newResolvers()
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewResolversActor final : public Actor<Void>, public ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >, public FastAllocated<NewResolversActor>, public NewResolversActorState<NewResolversActor> {
															#line 2727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewResolversActor>::operator new;
	using FastAllocated<NewResolversActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15464976984355718144UL, 14043265036934897920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >;
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewResolversActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewResolversActorState<NewResolversActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8367740995656328448UL, 13882773353061823744UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newResolvers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newResolvers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewResolversActor(self, recr));
															#line 2777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newTLogServers()
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewTLogServersActor>
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewTLogServersActorState {
															#line 2789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewTLogServersActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr,Reference<ILogSystem> const& oldLogSystem,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges) 
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr),
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   initialConfChanges(initialConfChanges)
															#line 2802 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newTLogServers", reinterpret_cast<unsigned long>(this));

	}
	~NewTLogServersActorState() 
	{
		fdb_probe_actor_destroy("newTLogServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("NewTLogServersStarted", self->dbgid).detail("UsableRegions", self->configuration.usableRegions);
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.usableRegions > 1)
															#line 2819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcId = self->remoteDcIds.size() ? self->remoteDcIds[0] : Optional<Key>();
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!self->dcId_locality.contains(recr.dcId))
															#line 2825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					int8_t loc = self->getNextLocality();
															#line 281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> tr;
															#line 282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					tr.set(tr.arena(), tagLocalityListKeyFor(recr.dcId), tagLocalityListValue(loc));
															#line 283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					initialConfChanges->push_back(tr);
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->dcId_locality[recr.dcId] = loc;
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevWarn, "UnknownPrimaryDCID", self->dbgid).detail("PrimaryId", recr.dcId).detail("Loc", loc);
															#line 2839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!self->dcId_locality.contains(remoteDcId))
															#line 2843 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					int8_t loc = self->getNextLocality();
															#line 290 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> tr;
															#line 291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					tr.set(tr.arena(), tagLocalityListKeyFor(remoteDcId), tagLocalityListValue(loc));
															#line 292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					initialConfChanges->push_back(tr);
															#line 293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->dcId_locality[remoteDcId] = loc;
															#line 294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevWarn, "UnknownRemoteDCID", self->dbgid).detail("RemoteId", remoteDcId).detail("Loc", loc);
															#line 2857 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::vector<UID> exclusionWorkerIds;
															#line 298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::transform(recr.tLogs.begin(), recr.tLogs.end(), std::back_inserter(exclusionWorkerIds), [](const WorkerInterface& in) { return in.id(); });
															#line 302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::transform(recr.satelliteTLogs.begin(), recr.satelliteTLogs.end(), std::back_inserter(exclusionWorkerIds), [](const WorkerInterface& in) { return in.id(); });
															#line 307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				RecruitRemoteFromConfigurationRequest remoteRecruitReq( self->configuration, remoteDcId, recr.tLogs.size() * std::max<int>(1, self->configuration.desiredLogRouterCount / std::max<int>(1, recr.tLogs.size())), exclusionWorkerIds);
															#line 313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteRecruitReq.dbgId = self->dbgid;
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				recruitWorkersInfo = makeReference<RecruitRemoteWorkersInfo>(remoteRecruitReq);
															#line 316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				recruitWorkersInfo->dbgId = self->dbgid;
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Future<RecruitRemoteFromConfigurationReply> fRemoteWorkers = clusterRecruitRemoteFromConfiguration(self->controllerData, recruitWorkersInfo);
															#line 320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->primaryLocality = self->dcId_locality[recr.dcId];
															#line 321 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->logSystem = Reference<ILogSystem>();
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Reference<ILogSystem>> __when_expr_0 = oldLogSystem->newEpoch(recr, fRemoteWorkers, self->configuration, self->cstate.myDBState.recoveryCount + 1, self->recoveryTransactionVersion, self->primaryLocality, self->dcId_locality[remoteDcId], self->allTags, self->recruitmentStalled);
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<NewTLogServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewTLogServersActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*>(static_cast<NewTLogServersActor*>(this)));
															#line 2888 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->primaryLocality = tagLocalitySpecial;
															#line 334 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->logSystem = Reference<ILogSystem>();
															#line 335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Reference<ILogSystem>> __when_expr_1 = oldLogSystem->newEpoch(recr, Never(), self->configuration, self->cstate.myDBState.recoveryCount + 1, self->recoveryTransactionVersion, self->primaryLocality, tagLocalitySpecial, self->allTags, self->recruitmentStalled);
															#line 335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<NewTLogServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<NewTLogServersActor*>(this)->actor_wait_state = 2;
															#line 335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*>(static_cast<NewTLogServersActor*>(this)));
															#line 2906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewTLogServersActorState();
		static_cast<NewTLogServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("NewTLogServersFinished", self->dbgid);
															#line 347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewTLogServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewTLogServersActorState(); static_cast<NewTLogServersActor*>(this)->destroy(); return 0; }
															#line 2932 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewTLogServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewTLogServersActorState();
		static_cast<NewTLogServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 2944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 2953 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont2(newLogSystem, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(newLogSystem), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewTLogServersActor*>(this)->actor_wait_state > 0) static_cast<NewTLogServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewTLogServersActor*>(this)->ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >::remove();

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Reference<ILogSystem> const& value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Reference<ILogSystem> && value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Error err) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 3037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 3046 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont6(newLogSystem, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(newLogSystem), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewTLogServersActor*>(this)->actor_wait_state > 0) static_cast<NewTLogServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewTLogServersActor*>(this)->ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >::remove();

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Reference<ILogSystem> const& value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Reference<ILogSystem> && value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Error err) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>>* initialConfChanges;
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Key> remoteDcId;
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitRemoteWorkersInfo> recruitWorkersInfo;
															#line 3138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newTLogServers()
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewTLogServersActor final : public Actor<Void>, public ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >, public ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >, public FastAllocated<NewTLogServersActor>, public NewTLogServersActorState<NewTLogServersActor> {
															#line 3143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewTLogServersActor>::operator new;
	using FastAllocated<NewTLogServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5492078471758438912UL, 5576555047220445952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >;
friend struct ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >;
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewTLogServersActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr,Reference<ILogSystem> const& oldLogSystem,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges) 
															#line 3161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewTLogServersActorState<NewTLogServersActor>(self, recr, oldLogSystem, initialConfChanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12044362103626689536UL, 4721329108795407104UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newTLogServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newTLogServers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr, Reference<ILogSystem> const& oldLogSystem, std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges ) {
															#line 272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewTLogServersActor(self, recr, oldLogSystem, initialConfChanges));
															#line 3195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 3200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newSeedServers()
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewSeedServersActor>
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewSeedServersActorState {
															#line 3207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewSeedServersActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recruits,std::vector<StorageServerInterface>* const& servers) 
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recruits(recruits),
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   servers(servers)
															#line 3218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newSeedServers", reinterpret_cast<unsigned long>(this));

	}
	~NewSeedServersActorState() 
	{
		fdb_probe_actor_destroy("newSeedServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->clear();
															#line 355 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->lastEpochEnd)
															#line 3235 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!static_cast<NewSeedServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewSeedServersActorState(); static_cast<NewSeedServersActor*>(this)->destroy(); return 0; }
															#line 3239 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				new (&static_cast<NewSeedServersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~NewSeedServersActorState();
				static_cast<NewSeedServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx = 0;
															#line 359 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			dcId_tags = std::map<Optional<Value>, Tag>();
															#line 360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			nextLocality = 0;
															#line 361 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 3253 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewSeedServersActorState();
		static_cast<NewSeedServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& it : dcId_tags ) {
															#line 401 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[it.first] = it.second.locality;
															#line 3280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 404 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ClusterRecoveryRecruitedInitialStorageServers", self->dbgid) .detail("TargetCount", self->configuration.storageTeamSize) .detail("Servers", describe(*servers));
															#line 408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewSeedServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewSeedServersActorState(); static_cast<NewSeedServersActor*>(this)->destroy(); return 0; }
															#line 3286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewSeedServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewSeedServersActorState();
		static_cast<NewSeedServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 361 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(idx < recruits.storageServers.size()))
															#line 3305 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME).c_str(), self->dbgid) .detail("CandidateWorker", recruits.storageServers[idx].locality.toString());
															#line 366 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		InitializeStorageRequest isr;
															#line 367 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.seedTag = dcId_tags.contains(recruits.storageServers[idx].locality.dcId()) ? dcId_tags[recruits.storageServers[idx].locality.dcId()] : Tag(nextLocality, 0);
															#line 370 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.storeType = self->configuration.storageServerStoreType;
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.reqId = deterministicRandom()->randomUniqueID();
															#line 372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.interfaceId = deterministicRandom()->randomUniqueID();
															#line 373 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.initialClusterVersion = self->recoveryTransactionVersion;
															#line 374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.encryptMode = self->configuration.encryptionAtRestMode;
															#line 376 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<ErrorOr<InitializeStorageReply>> __when_expr_0 = recruits.storageServers[idx].storage.tryGetReply(isr);
															#line 376 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<NewSeedServersActor*>(this)->actor_wait_state = 1;
															#line 376 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3334 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<InitializeStorageReply> const& newServer,int loopDepth) 
	{
															#line 378 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (newServer.isError())
															#line 3356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newServer.isError(error_code_recruitment_failed) && !newServer.isError(error_code_request_maybe_delivered))
															#line 3360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1Catch1(newServer.getError(), std::max(0, loopDepth - 1));
															#line 3364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "initial storage recuitment loop failed to get new server");
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->STORAGE_RECRUITMENT_DELAY);
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NewSeedServersActor*>(this)->actor_wait_state = 2;
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 1, Void >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3377 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 386 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!dcId_tags.contains(recruits.storageServers[idx].locality.dcId()))
															#line 3384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				dcId_tags[recruits.storageServers[idx].locality.dcId()] = Tag(nextLocality, 0);
															#line 388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				nextLocality++;
															#line 3390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Tag& tag = dcId_tags[recruits.storageServers[idx].locality.dcId()];
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tag.id++;
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx++;
															#line 395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->push_back(newServer.get().interf);
															#line 3400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<InitializeStorageReply> && newServer,int loopDepth) 
	{
															#line 378 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (newServer.isError())
															#line 3410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newServer.isError(error_code_recruitment_failed) && !newServer.isError(error_code_request_maybe_delivered))
															#line 3414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1Catch1(newServer.getError(), std::max(0, loopDepth - 1));
															#line 3418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "initial storage recuitment loop failed to get new server");
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->STORAGE_RECRUITMENT_DELAY);
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NewSeedServersActor*>(this)->actor_wait_state = 2;
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 1, Void >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 386 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!dcId_tags.contains(recruits.storageServers[idx].locality.dcId()))
															#line 3438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				dcId_tags[recruits.storageServers[idx].locality.dcId()] = Tag(nextLocality, 0);
															#line 388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				nextLocality++;
															#line 3444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Tag& tag = dcId_tags[recruits.storageServers[idx].locality.dcId()];
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tag.id++;
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx++;
															#line 395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->push_back(newServer.get().interf);
															#line 3454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<InitializeStorageReply> const& newServer,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(newServer, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<InitializeStorageReply> && newServer,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(newServer), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state > 0) static_cast<NewSeedServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewSeedServersActor*>(this)->ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >::remove();

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,ErrorOr<InitializeStorageReply> const& value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,ErrorOr<InitializeStorageReply> && value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,Error err) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state > 0) static_cast<NewSeedServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewSeedServersActor*>(this)->ActorCallback< NewSeedServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewSeedServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recruits;
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* servers;
															#line 358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int idx;
															#line 359 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::map<Optional<Value>, Tag> dcId_tags;
															#line 360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int8_t nextLocality;
															#line 3640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newSeedServers()
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewSeedServersActor final : public Actor<Void>, public ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >, public ActorCallback< NewSeedServersActor, 1, Void >, public FastAllocated<NewSeedServersActor>, public NewSeedServersActorState<NewSeedServersActor> {
															#line 3645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewSeedServersActor>::operator new;
	using FastAllocated<NewSeedServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1322671804839624704UL, 13009874932977985024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >;
friend struct ActorCallback< NewSeedServersActor, 1, Void >;
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewSeedServersActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recruits,std::vector<StorageServerInterface>* const& servers) 
															#line 3663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewSeedServersActorState<NewSeedServersActor>(self, recruits, servers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7274580659293080832UL, 11591227406186479104UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newSeedServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewSeedServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newSeedServers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recruits, std::vector<StorageServerInterface>* const& servers ) {
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewSeedServersActor(self, recruits, servers));
															#line 3697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

Future<Void> waitCommitProxyFailure(std::vector<CommitProxyInterface> const& commitProxies) {
	std::vector<Future<Void>> failed;
	failed.reserve(commitProxies.size());
	for (auto commitProxy : commitProxies) {
		failed.push_back(waitFailureClient(commitProxy.waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	}
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), commit_proxy_failed());
}

Future<Void> waitGrvProxyFailure(std::vector<GrvProxyInterface> const& grvProxies) {
	std::vector<Future<Void>> failed;
	failed.reserve(grvProxies.size());
	for (int i = 0; i < grvProxies.size(); i++)
		failed.push_back(waitFailureClient(grvProxies[i].waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), grv_proxy_failed());
}

Future<Void> waitResolverFailure(std::vector<ResolverInterface> const& resolvers) {
	std::vector<Future<Void>> failed;
	failed.reserve(resolvers.size());
	for (auto resolver : resolvers) {
		failed.push_back(waitFailureClient(resolver.waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	}
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), resolver_failed());
}

															#line 3740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via rejoinRequestHandler()
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RejoinRequestHandlerActor>
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RejoinRequestHandlerActorState {
															#line 3747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RejoinRequestHandlerActorState(Reference<ClusterRecoveryData> const& self) 
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self)
															#line 3754 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("rejoinRequestHandler", reinterpret_cast<unsigned long>(this));

	}
	~RejoinRequestHandlerActorState() 
	{
		fdb_probe_actor_destroy("rejoinRequestHandler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 3769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinRequestHandlerActorState();
		static_cast<RejoinRequestHandlerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto __when_expr_0 = self->clusterController.tlogRejoin.getFuture();
															#line 3799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TLogRejoinRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TLogRejoinRequest>>::value, "invalid type");
															#line 451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3803 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state = 1;
															#line 451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*>(static_cast<RejoinRequestHandlerActor*>(this)));
															#line 3808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TLogRejoinRequest const& req,int loopDepth) 
	{
															#line 452 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(SevDebug, "TLogRejoinRequestHandler") .detail("MasterLifeTime", self->dbInfo->get().masterLifetime.toString());
															#line 454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(true);
															#line 3819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TLogRejoinRequest && req,int loopDepth) 
	{
															#line 452 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(SevDebug, "TLogRejoinRequestHandler") .detail("MasterLifeTime", self->dbInfo->get().masterLifetime.toString());
															#line 454 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(true);
															#line 3830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state > 0) static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinRequestHandlerActor*>(this)->ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,TLogRejoinRequest const& value) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,TLogRejoinRequest && value) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 3912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via rejoinRequestHandler()
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RejoinRequestHandlerActor final : public Actor<Void>, public ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >, public FastAllocated<RejoinRequestHandlerActor>, public RejoinRequestHandlerActorState<RejoinRequestHandlerActor> {
															#line 3917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RejoinRequestHandlerActor>::operator new;
	using FastAllocated<RejoinRequestHandlerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(502523049954544128UL, 8773529054596824576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >;
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RejoinRequestHandlerActor(Reference<ClusterRecoveryData> const& self) 
															#line 3934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RejoinRequestHandlerActorState<RejoinRequestHandlerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15236639655740148224UL, 4543991541925031168UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinRequestHandler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> rejoinRequestHandler( Reference<ClusterRecoveryData> const& self ) {
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RejoinRequestHandlerActor(self));
															#line 3967 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 457 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// Keeps the coordinated state (cstate) updated as the set of recruited tlogs change through recovery.
															#line 3973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via trackTlogRecovery()
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class TrackTlogRecoveryActor>
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TrackTlogRecoveryActorState {
															#line 3980 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TrackTlogRecoveryActorState(Reference<ClusterRecoveryData> const& self,Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems,Future<Void> const& minRecoveryDuration) 
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystems(oldLogSystems),
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   minRecoveryDuration(minRecoveryDuration),
															#line 462 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   rejoinRequests(Never()),
															#line 463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoverCount(self->cstate.myDBState.recoveryCount + 1),
															#line 464 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   encryptionAtRestMode(getEncryptionAtRest(self->configuration)),
															#line 465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   configuration(self->configuration)
															#line 3999 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("trackTlogRecovery", reinterpret_cast<unsigned long>(this));

	}
	~TrackTlogRecoveryActorState() 
	{
		fdb_probe_actor_destroy("trackTlogRecovery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 4014 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackTlogRecoveryActorState();
		static_cast<TrackTlogRecoveryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState = DBCoreState();
															#line 469 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->toCoreState(newState);
															#line 473 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsCoreState(newState);
															#line 474 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.recoveryCount = recoverCount;
															#line 477 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.encryptionAtRestMode = encryptionAtRestMode;
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changed = self->logSystem->onCoreStateChanged();
															#line 481 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(newState.tLogs[0].tLogWriteAntiQuorum == configuration.tLogWriteAntiQuorum && newState.tLogs[0].tLogReplicationFactor == configuration.tLogReplicationFactor);
															#line 484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		allLogs = newState.tLogs.size() == configuration.expectedLogSets(self->primaryDcId.size() ? self->primaryDcId[0] : Optional<Key>());
															#line 487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		finalUpdate = !newState.oldTLogData.size() && allLogs;
															#line 488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("TrackTLogRecovery") .detail("FinalUpdate", finalUpdate) .detail("NewState.tlogs", newState.tLogs.size()) .detail("NewState.OldTLogs", newState.oldTLogData.size()) .detail("NewState.EncryptionAtRestMode", newState.encryptionAtRestMode.toString()) .detail("Expected.tlogs", configuration.expectedLogSets(self->primaryDcId.size() ? self->primaryDcId[0] : Optional<Key>())) .detail("RecoveryCount", newState.recoveryCount);
															#line 496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->cstate.write(newState, finalUpdate);
															#line 496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 0, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4071 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsInMemory(newState);
															#line 499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstateUpdated.canBeSet())
															#line 4082 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->cstateUpdated.send(Void());
															#line 4086 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = minRecoveryDuration;
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 2;
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 1, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsInMemory(newState);
															#line 499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstateUpdated.canBeSet())
															#line 4108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->cstateUpdated.send(Void());
															#line 4112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = minRecoveryDuration;
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 2;
															#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 1, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->coreStateWritten(newState);
															#line 506 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->recoveryReadyForCommits.canBeSet())
															#line 4209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryReadyForCommits.send(Void());
															#line 4213 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::FULLY_RECOVERED;
															#line 512 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::fully_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::fully_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 518 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 4225 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newState.oldTLogData.size() && self->recoveryState < RecoveryState::STORAGE_RECOVERED)
															#line 4231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryState = RecoveryState::STORAGE_RECOVERED;
															#line 524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::storage_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::storage_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (allLogs && self->recoveryState < RecoveryState::ALL_LOGS_RECRUITED)
															#line 4243 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->recoveryState = RecoveryState::ALL_LOGS_RECRUITED;
															#line 531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::all_logs_recruited) .detail("Status", RecoveryStatus::names[RecoveryStatus::all_logs_recruited]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
															#line 538 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			oldLogSystems->get()->stopRejoins();
															#line 542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rejoinRequests = rejoinRequestHandler(self);
															#line 543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TrackTlogRecoveryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackTlogRecoveryActorState(); static_cast<TrackTlogRecoveryActor*>(this)->destroy(); return 0; }
															#line 4265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TrackTlogRecoveryActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TrackTlogRecoveryActorState();
			static_cast<TrackTlogRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changed;
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 3;
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 2, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->coreStateWritten(newState);
															#line 506 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->recoveryReadyForCommits.canBeSet())
															#line 4291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryReadyForCommits.send(Void());
															#line 4295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::FULLY_RECOVERED;
															#line 512 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::fully_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::fully_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 518 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 4307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newState.oldTLogData.size() && self->recoveryState < RecoveryState::STORAGE_RECOVERED)
															#line 4313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryState = RecoveryState::STORAGE_RECOVERED;
															#line 524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::storage_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::storage_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (allLogs && self->recoveryState < RecoveryState::ALL_LOGS_RECRUITED)
															#line 4325 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->recoveryState = RecoveryState::ALL_LOGS_RECRUITED;
															#line 531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::all_logs_recruited) .detail("Status", RecoveryStatus::names[RecoveryStatus::all_logs_recruited]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
															#line 538 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			oldLogSystems->get()->stopRejoins();
															#line 542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rejoinRequests = rejoinRequestHandler(self);
															#line 543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TrackTlogRecoveryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackTlogRecoveryActorState(); static_cast<TrackTlogRecoveryActor*>(this)->destroy(); return 0; }
															#line 4347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TrackTlogRecoveryActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TrackTlogRecoveryActorState();
			static_cast<TrackTlogRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changed;
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4357 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 3;
															#line 546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 2, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<Reference<ILogSystem>>> oldLogSystems;
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> minRecoveryDuration;
															#line 462 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> rejoinRequests;
															#line 463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DBRecoveryCount recoverCount;
															#line 464 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	EncryptionAtRestMode encryptionAtRestMode;
															#line 465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DatabaseConfiguration configuration;
															#line 468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DBCoreState newState;
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> changed;
															#line 484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool allLogs;
															#line 487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool finalUpdate;
															#line 4551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via trackTlogRecovery()
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TrackTlogRecoveryActor final : public Actor<Void>, public ActorCallback< TrackTlogRecoveryActor, 0, Void >, public ActorCallback< TrackTlogRecoveryActor, 1, Void >, public ActorCallback< TrackTlogRecoveryActor, 2, Void >, public FastAllocated<TrackTlogRecoveryActor>, public TrackTlogRecoveryActorState<TrackTlogRecoveryActor> {
															#line 4556 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<TrackTlogRecoveryActor>::operator new;
	using FastAllocated<TrackTlogRecoveryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8971123830303783936UL, 448883995006765824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackTlogRecoveryActor, 0, Void >;
friend struct ActorCallback< TrackTlogRecoveryActor, 1, Void >;
friend struct ActorCallback< TrackTlogRecoveryActor, 2, Void >;
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TrackTlogRecoveryActor(Reference<ClusterRecoveryData> const& self,Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems,Future<Void> const& minRecoveryDuration) 
															#line 4575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   TrackTlogRecoveryActorState<TrackTlogRecoveryActor>(self, oldLogSystems, minRecoveryDuration),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10869225822354720768UL, 5259300671006810112UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackTlogRecovery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> trackTlogRecovery( Reference<ClusterRecoveryData> const& self, Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems, Future<Void> const& minRecoveryDuration ) {
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new TrackTlogRecoveryActor(self, oldLogSystems, minRecoveryDuration));
															#line 4610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 4615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via changeCoordinators()
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ChangeCoordinatorsActor>
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ChangeCoordinatorsActorState {
															#line 4622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsActorState(Reference<ClusterRecoveryData> const& self) 
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self)
															#line 4629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~ChangeCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 4644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeCoordinatorsActorState();
		static_cast<ChangeCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto __when_expr_0 = self->clusterController.changeCoordinators.getFuture();
															#line 4674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ChangeCoordinatorsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ChangeCoordinatorsRequest>>::value, "invalid type");
															#line 552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ChangeCoordinatorsRequest const& req,int loopDepth) 
	{
															#line 553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ChangeCoordinators", self->dbgid).log();
															#line 554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		++self->changeCoordinatorsRequests;
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changeCoordinatorsRequest = req;
															#line 556 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->masterInterface.id() != changeCoordinatorsRequest.masterId)
															#line 4698 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 1));
															#line 4702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->controllerData->shouldCommitSuicide)
															#line 4706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->shouldCommitSuicide = true;
															#line 576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 4716 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(ChangeCoordinatorsRequest && req,int loopDepth) 
	{
															#line 553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ChangeCoordinators", self->dbgid).log();
															#line 554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		++self->changeCoordinatorsRequests;
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changeCoordinatorsRequest = req;
															#line 556 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->masterInterface.id() != changeCoordinatorsRequest.masterId)
															#line 4731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 1));
															#line 4735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->controllerData->shouldCommitSuicide)
															#line 4739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->shouldCommitSuicide = true;
															#line 576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 4749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ChangeCoordinatorsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ChangeCoordinatorsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,ChangeCoordinatorsRequest const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,ChangeCoordinatorsRequest && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.fullyRecovered.isSet())
															#line 4833 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->cstate.write(self->cstate.myDBState, true);
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 3, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->cstate.previousWrite.isReady()))
															#line 4865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->cstate.previousWrite;
															#line 577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4873 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 577 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 1, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4878 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay( 0);
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4902 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 2, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay( 0);
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 2, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
															#line 587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ClusterConnectionString conn(changeCoordinatorsRequest.newConnectionString.toString());
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->cstate.move(conn);
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 5099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont5Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 5;
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 4, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 5104 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 590 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				changeCoordinatorsRequest.reply.sendError(e);
															#line 5219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 555 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsRequest changeCoordinatorsRequest;
															#line 5337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via changeCoordinators()
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ChangeCoordinatorsActor final : public Actor<Void>, public ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >, public ActorCallback< ChangeCoordinatorsActor, 1, Void >, public ActorCallback< ChangeCoordinatorsActor, 2, Void >, public ActorCallback< ChangeCoordinatorsActor, 3, Void >, public ActorCallback< ChangeCoordinatorsActor, 4, Void >, public FastAllocated<ChangeCoordinatorsActor>, public ChangeCoordinatorsActorState<ChangeCoordinatorsActor> {
															#line 5342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ChangeCoordinatorsActor>::operator new;
	using FastAllocated<ChangeCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7419942397195033344UL, 6116974186747098112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >;
friend struct ActorCallback< ChangeCoordinatorsActor, 1, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 2, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 3, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 4, Void >;
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsActor(Reference<ClusterRecoveryData> const& self) 
															#line 5363 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeCoordinatorsActorState<ChangeCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3491648785959313408UL, 8764310282253397504UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> changeCoordinators( Reference<ClusterRecoveryData> const& self ) {
															#line 550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ChangeCoordinatorsActor(self));
															#line 5400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 5405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via configurationMonitor()
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ConfigurationMonitorActor>
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ConfigurationMonitorActorState {
															#line 5412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ConfigurationMonitorActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 5421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	~ConfigurationMonitorActorState() 
	{
		fdb_probe_actor_destroy("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 601 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 5436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigurationMonitorActorState();
		static_cast<ConfigurationMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 602 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 604 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 5468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 606 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 1;
															#line 607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5537 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 4;
															#line 634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 3, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult const& results,int loopDepth) 
	{
															#line 608 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration conf;
															#line 611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		conf.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ConfigurationMonitor", self->dbgid) .detail(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->recoveryState);
															#line 615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (conf != self->configuration)
															#line 5565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState != RecoveryState::ALL_LOGS_RECRUITED && self->recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 5569 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 618 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->controllerData->shouldCommitSuicide = true;
															#line 619 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 5575 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = conf;
															#line 623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->registrationTrigger.trigger();
															#line 5581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult && results,int loopDepth) 
	{
															#line 608 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration conf;
															#line 611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		conf.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ConfigurationMonitor", self->dbgid) .detail(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->recoveryState);
															#line 615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (conf != self->configuration)
															#line 5611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState != RecoveryState::ALL_LOGS_RECRUITED && self->recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 5615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 618 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->controllerData->shouldCommitSuicide = true;
															#line 619 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 5621 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = conf;
															#line 623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->registrationTrigger.trigger();
															#line 5627 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5635 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 602 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> watchFuture;
															#line 6009 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via configurationMonitor()
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ConfigurationMonitorActor final : public Actor<Void>, public ActorCallback< ConfigurationMonitorActor, 0, RangeResult >, public ActorCallback< ConfigurationMonitorActor, 1, Void >, public ActorCallback< ConfigurationMonitorActor, 2, Void >, public ActorCallback< ConfigurationMonitorActor, 3, Void >, public FastAllocated<ConfigurationMonitorActor>, public ConfigurationMonitorActorState<ConfigurationMonitorActor> {
															#line 6014 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ConfigurationMonitorActor>::operator new;
	using FastAllocated<ConfigurationMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11057134830641279232UL, 7593699119410631168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigurationMonitorActor, 0, RangeResult >;
friend struct ActorCallback< ConfigurationMonitorActor, 1, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 2, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 3, Void >;
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ConfigurationMonitorActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 6034 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigurationMonitorActorState<ConfigurationMonitorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11255558610263663616UL, 7933841004617470208UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configurationMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> configurationMonitor( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ConfigurationMonitorActor(self, cx));
															#line 6070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// Returns the minimum backup version and the maximum backup worker noop version.
															#line 6076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via getMinBackupVersion()
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class GetMinBackupVersionActor>
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class GetMinBackupVersionActorState {
															#line 6083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	GetMinBackupVersionActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 6092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("getMinBackupVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetMinBackupVersionActorState() 
	{
		fdb_probe_actor_destroy("getMinBackupVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 6107 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 6137 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		try {
															#line 648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			fValue = tr.get(backupStartedKey);
															#line 651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			fNoopValue = tr.get(backupWorkerMaxNoopVersionKey);
															#line 652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fValue) && success(fNoopValue);
															#line 652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 1;
															#line 652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMinBackupVersionActor, 0, Void >*>(static_cast<GetMinBackupVersionActor*>(this)));
															#line 6156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 2;
															#line 674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMinBackupVersionActor, 1, Void >*>(static_cast<GetMinBackupVersionActor*>(this)));
															#line 6185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> value = fValue.get();
															#line 654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> noopValue = fNoopValue.get();
															#line 655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion, noopVersion;
															#line 656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (value.present())
															#line 6206 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto uidVersions = decodeBackupStartedValue(value.get());
															#line 658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent e("GotBackupStartKey", self->dbgid);
															#line 659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int i = 1;
															#line 660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minVersion = minVersion.present() ? std::min(version, minVersion.get()) : version;
															#line 6222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmptyBackupStartKey", self->dbgid).log();
															#line 6229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (noopValue.present())
															#line 6233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 6237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<GetMinBackupVersionActor*>(this)->SAV<std::pair<Optional<Version>, Optional<Version>>>::futures) { (void)(std::make_pair(minVersion, noopVersion)); this->~GetMinBackupVersionActorState(); static_cast<GetMinBackupVersionActor*>(this)->destroy(); return 0; }
															#line 6241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<GetMinBackupVersionActor*>(this)->SAV< std::pair<Optional<Version>, Optional<Version>> >::value()) std::pair<Optional<Version>, Optional<Version>>(std::make_pair(minVersion, noopVersion));
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> value = fValue.get();
															#line 654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> noopValue = fNoopValue.get();
															#line 655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion, noopVersion;
															#line 656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (value.present())
															#line 6259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto uidVersions = decodeBackupStartedValue(value.get());
															#line 658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent e("GotBackupStartKey", self->dbgid);
															#line 659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int i = 1;
															#line 660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minVersion = minVersion.present() ? std::min(version, minVersion.get()) : version;
															#line 6275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmptyBackupStartKey", self->dbgid).log();
															#line 6282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (noopValue.present())
															#line 6286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 6290 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<GetMinBackupVersionActor*>(this)->SAV<std::pair<Optional<Version>, Optional<Version>>>::futures) { (void)(std::make_pair(minVersion, noopVersion)); this->~GetMinBackupVersionActorState(); static_cast<GetMinBackupVersionActor*>(this)->destroy(); return 0; }
															#line 6294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<GetMinBackupVersionActor*>(this)->SAV< std::pair<Optional<Version>, Optional<Version>> >::value()) std::pair<Optional<Version>, Optional<Version>>(std::make_pair(minVersion, noopVersion));
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state > 0) static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinBackupVersionActor*>(this)->ActorCallback< GetMinBackupVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state > 0) static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinBackupVersionActor*>(this)->ActorCallback< GetMinBackupVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Optional<Value>> fValue;
															#line 651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Optional<Value>> fNoopValue;
															#line 6474 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via getMinBackupVersion()
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class GetMinBackupVersionActor final : public Actor<std::pair<Optional<Version>, Optional<Version>>>, public ActorCallback< GetMinBackupVersionActor, 0, Void >, public ActorCallback< GetMinBackupVersionActor, 1, Void >, public FastAllocated<GetMinBackupVersionActor>, public GetMinBackupVersionActorState<GetMinBackupVersionActor> {
															#line 6479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<GetMinBackupVersionActor>::operator new;
	using FastAllocated<GetMinBackupVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5025904604405248UL, 12245168140442364160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<Version>, Optional<Version>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMinBackupVersionActor, 0, Void >;
friend struct ActorCallback< GetMinBackupVersionActor, 1, Void >;
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	GetMinBackupVersionActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 6497 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<std::pair<Optional<Version>, Optional<Version>>>(),
		   GetMinBackupVersionActorState<GetMinBackupVersionActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15001475540261082112UL, 3363868253404307200UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMinBackupVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMinBackupVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMinBackupVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<Version>, Optional<Version>>> getMinBackupVersion( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<std::pair<Optional<Version>, Optional<Version>>>(new GetMinBackupVersionActor(self, cx));
															#line 6531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 6536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitBackupWorkers()
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitBackupWorkersActor>
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitBackupWorkersActorState {
															#line 6543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitBackupWorkersActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 6552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	~RecruitBackupWorkersActorState() 
	{
		fdb_probe_actor_destroy("recruitBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->backupWorkers.size() > 0);
															#line 683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->SECONDS_BEFORE_RECRUIT_BACKUP_WORKER);
															#line 683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 1;
															#line 683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 0, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		epoch = self->cstate.myDBState.recoveryCount;
															#line 686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		backupProgress = Reference<BackupProgress>(new BackupProgress(self->dbgid, self->logSystem->getOldEpochTagsVersionsInfo()));
															#line 688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		gotProgress = getBackupProgress(cx, self->dbgid, backupProgress, true);
															#line 689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initializationReplies = std::vector<Future<InitializeBackupReply>>();
															#line 691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags = std::vector<std::pair<UID, Tag>>();
															#line 692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logRouterTags = self->logSystem->getLogRouterTags();
															#line 693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags.reserve(logRouterTags);
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(int i = 0;i < logRouterTags;i++) {
															#line 695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idsTags.emplace_back(deterministicRandom()->randomUniqueID(), Tag(tagLocalityLogRouter, i));
															#line 6615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 698 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		const Version startVersion = self->logSystem->getBackupStartVersion();
															#line 699 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		i = 0;
															#line 700 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;i < logRouterTags;i++) {
															#line 701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			InitializeBackupRequest req(idsTags[i].first);
															#line 703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.recruitedEpoch = epoch;
															#line 704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.backupEpoch = epoch;
															#line 705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.routerTag = idsTags[i].second;
															#line 706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.totalTags = logRouterTags;
															#line 707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.startVersion = startVersion;
															#line 708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", epoch) .detail("StartVersion", req.startVersion);
															#line 714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initializationReplies.push_back( transformErrors(throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6641 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fMinVersion = getMinBackupVersion(self, cx);
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = gotProgress && success(fMinVersion);
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 1, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		epoch = self->cstate.myDBState.recoveryCount;
															#line 686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		backupProgress = Reference<BackupProgress>(new BackupProgress(self->dbgid, self->logSystem->getOldEpochTagsVersionsInfo()));
															#line 688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		gotProgress = getBackupProgress(cx, self->dbgid, backupProgress, true);
															#line 689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initializationReplies = std::vector<Future<InitializeBackupReply>>();
															#line 691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags = std::vector<std::pair<UID, Tag>>();
															#line 692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logRouterTags = self->logSystem->getLogRouterTags();
															#line 693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags.reserve(logRouterTags);
															#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(int i = 0;i < logRouterTags;i++) {
															#line 695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idsTags.emplace_back(deterministicRandom()->randomUniqueID(), Tag(tagLocalityLogRouter, i));
															#line 6679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 698 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		const Version startVersion = self->logSystem->getBackupStartVersion();
															#line 699 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		i = 0;
															#line 700 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;i < logRouterTags;i++) {
															#line 701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			InitializeBackupRequest req(idsTags[i].first);
															#line 703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.recruitedEpoch = epoch;
															#line 704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.backupEpoch = epoch;
															#line 705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.routerTag = idsTags[i].second;
															#line 706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.totalTags = logRouterTags;
															#line 707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.startVersion = startVersion;
															#line 708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", epoch) .detail("StartVersion", req.startVersion);
															#line 714 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initializationReplies.push_back( transformErrors(throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fMinVersion = getMinBackupVersion(self, cx);
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = gotProgress && success(fMinVersion);
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 1, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6718 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 722 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion = fMinVersion.get().first;
															#line 723 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> noopVersion = fMinVersion.get().second;
															#line 724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MinBackupVersion", self->dbgid) .detail("Version", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1);
															#line 728 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit = backupProgress->getUnfinishedBackup();
															#line 730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( const auto& [epochVersionTags, tagVersions] : toRecruit ) {
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const Version oldEpochEnd = std::get<1>(epochVersionTags);
															#line 732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if ((!minVersion.present() || minVersion.get() + 1 >= oldEpochEnd) || (noopVersion.present() && noopVersion.get() >= oldEpochEnd))
															#line 6814 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 734 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("SkipBackupRecruitment", self->dbgid) .detail("MinVersion", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1) .detail("Epoch", epoch) .detail("OldEpoch", std::get<0>(epochVersionTags)) .detail("OldEpochEnd", oldEpochEnd);
															#line 6818 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				continue;
			}
															#line 742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( const auto& [tag, version] : tagVersions ) {
															#line 743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recruitedEpoch = epoch;
															#line 747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.backupEpoch = std::get<0>(epochVersionTags);
															#line 748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.routerTag = tag;
															#line 749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.totalTags = std::get<2>(epochVersionTags);
															#line 750 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.startVersion = version;
															#line 751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.endVersion = std::get<1>(epochVersionTags) - 1;
															#line 752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", req.backupEpoch) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.get());
															#line 759 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back(transformErrors( throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<InitializeBackupReply>> __when_expr_2 = getAll(initializationReplies);
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6852 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 3;
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6857 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 722 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion = fMinVersion.get().first;
															#line 723 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> noopVersion = fMinVersion.get().second;
															#line 724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MinBackupVersion", self->dbgid) .detail("Version", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1);
															#line 728 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit = backupProgress->getUnfinishedBackup();
															#line 730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( const auto& [epochVersionTags, tagVersions] : toRecruit ) {
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const Version oldEpochEnd = std::get<1>(epochVersionTags);
															#line 732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if ((!minVersion.present() || minVersion.get() + 1 >= oldEpochEnd) || (noopVersion.present() && noopVersion.get() >= oldEpochEnd))
															#line 6878 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 734 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("SkipBackupRecruitment", self->dbgid) .detail("MinVersion", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1) .detail("Epoch", epoch) .detail("OldEpoch", std::get<0>(epochVersionTags)) .detail("OldEpochEnd", oldEpochEnd);
															#line 6882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				continue;
			}
															#line 742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( const auto& [tag, version] : tagVersions ) {
															#line 743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 744 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recruitedEpoch = epoch;
															#line 747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.backupEpoch = std::get<0>(epochVersionTags);
															#line 748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.routerTag = tag;
															#line 749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.totalTags = std::get<2>(epochVersionTags);
															#line 750 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.startVersion = version;
															#line 751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.endVersion = std::get<1>(epochVersionTags) - 1;
															#line 752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", req.backupEpoch) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.get());
															#line 759 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back(transformErrors( throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6909 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<InitializeBackupReply>> __when_expr_2 = getAll(initializationReplies);
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 3;
															#line 766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::vector<InitializeBackupReply> const& newRecruits,int loopDepth) 
	{
															#line 767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->setBackupWorkers(newRecruits);
															#line 768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("BackupRecruitmentDone", self->dbgid).log();
															#line 769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitBackupWorkersActorState(); static_cast<RecruitBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 7011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(std::vector<InitializeBackupReply> && newRecruits,int loopDepth) 
	{
															#line 767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->setBackupWorkers(newRecruits);
															#line 768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("BackupRecruitmentDone", self->dbgid).log();
															#line 769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitBackupWorkersActorState(); static_cast<RecruitBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 7029 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<InitializeBackupReply> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont5(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<InitializeBackupReply> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,std::vector<InitializeBackupReply> const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,std::vector<InitializeBackupReply> && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	LogEpoch epoch;
															#line 686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<BackupProgress> backupProgress;
															#line 688 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> gotProgress;
															#line 689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Future<InitializeBackupReply>> initializationReplies;
															#line 691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<std::pair<UID, Tag>> idsTags;
															#line 692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int logRouterTags;
															#line 699 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int i;
															#line 720 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<std::pair<Optional<Version>, Optional<Version>>> fMinVersion;
															#line 7132 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitBackupWorkers()
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitBackupWorkersActor final : public Actor<Void>, public ActorCallback< RecruitBackupWorkersActor, 0, Void >, public ActorCallback< RecruitBackupWorkersActor, 1, Void >, public ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >, public FastAllocated<RecruitBackupWorkersActor>, public RecruitBackupWorkersActorState<RecruitBackupWorkersActor> {
															#line 7137 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitBackupWorkersActor>::operator new;
	using FastAllocated<RecruitBackupWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15318783002737821184UL, 1590802779215924480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitBackupWorkersActor, 0, Void >;
friend struct ActorCallback< RecruitBackupWorkersActor, 1, Void >;
friend struct ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >;
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitBackupWorkersActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 7156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecruitBackupWorkersActorState<RecruitBackupWorkersActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3680272819488559360UL, 2489044161561874944UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitBackupWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] static Future<Void> recruitBackupWorkers( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecruitBackupWorkersActor(self, cx));
															#line 7191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 772 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 7196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLogsValue()
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateLogsValueActor>
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLogsValueActorState {
															#line 7203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLogsValueActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx),
															#line 774 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   tr(cx)
															#line 7214 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLogsValue", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLogsValueActorState() 
	{
		fdb_probe_actor_destroy("updateLogsValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 775 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 7229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = tr.get(logsKey);
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 1;
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7267 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 3;
															#line 808 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 2, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7296 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
															#line 778 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(value.present());
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::set<UID> logIds;
															#line 782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& log : logs.first ) {
															#line 783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logIds.insert(log.first);
															#line 7319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 786 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		bool found = false;
															#line 787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& logSet : self->logSystem->getLogSystemConfig().tLogs ) {
															#line 788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& log : logSet.tLogs ) {
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (logIds.contains(log.id()))
															#line 7329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					found = true;
															#line 7333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					break;
				}
			}
															#line 794 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (found)
															#line 7339 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
				break;
			}
		}
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!found)
															#line 7346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "old master attempted to change logsKey", probe::decoration::rare);
															#line 801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateLogsValueActorState();
			static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(logsKey, self->logSystem->getLogsValue());
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 2;
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 1, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7369 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
															#line 778 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(value.present());
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::set<UID> logIds;
															#line 782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& log : logs.first ) {
															#line 783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logIds.insert(log.first);
															#line 7386 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 786 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		bool found = false;
															#line 787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& logSet : self->logSystem->getLogSystemConfig().tLogs ) {
															#line 788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& log : logSet.tLogs ) {
															#line 789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (logIds.contains(log.id()))
															#line 7396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					found = true;
															#line 7400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					break;
				}
			}
															#line 794 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (found)
															#line 7406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
				break;
			}
		}
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!found)
															#line 7413 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "old master attempted to change logsKey", probe::decoration::rare);
															#line 801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateLogsValueActorState();
			static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(logsKey, self->logSystem->getLogsValue());
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 2;
															#line 805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 1, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 806 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7520 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 806 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7532 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 774 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Transaction tr;
															#line 7708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateLogsValue()
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLogsValueActor final : public Actor<Void>, public ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >, public ActorCallback< UpdateLogsValueActor, 1, Void >, public ActorCallback< UpdateLogsValueActor, 2, Void >, public FastAllocated<UpdateLogsValueActor>, public UpdateLogsValueActorState<UpdateLogsValueActor> {
															#line 7713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateLogsValueActor>::operator new;
	using FastAllocated<UpdateLogsValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15705889653809969664UL, 2845816258333753600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< UpdateLogsValueActor, 1, Void >;
friend struct ActorCallback< UpdateLogsValueActor, 2, Void >;
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLogsValueActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 7732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLogsValueActorState<UpdateLogsValueActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14887805552584892160UL, 15469785806168203264UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLogsValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateLogsValue( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateLogsValueActor(self, cx));
															#line 7767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// TODO(ahusain): ClusterController orchestrating recovery, self message can be avoided.
Future<Void> sendMasterRegistration(ClusterRecoveryData* self,
                                    LogSystemConfig const& logSystemConfig,
                                    std::vector<CommitProxyInterface> commitProxies,
                                    std::vector<GrvProxyInterface> grvProxies,
                                    std::vector<ResolverInterface> resolvers,
                                    DBRecoveryCount recoveryCount,
                                    std::vector<UID> priorCommittedLogServers) {
	RegisterMasterRequest masterReq;
	masterReq.id = self->masterInterface.id();
	masterReq.mi = self->masterInterface.locality;
	masterReq.logSystemConfig = logSystemConfig;
	masterReq.commitProxies = commitProxies;
	masterReq.grvProxies = grvProxies;
	masterReq.resolvers = resolvers;
	masterReq.recoveryCount = recoveryCount;
	if (self->hasConfiguration)
		masterReq.configuration = self->configuration;
	masterReq.registrationCount = ++self->registrationCount;
	masterReq.priorCommittedLogServers = priorCommittedLogServers;
	masterReq.recoveryState = self->recoveryState;
	masterReq.recoveryStalled = self->recruitmentStalled->get();
	return brokenPromiseToNever(self->clusterController.registerMaster.getReply(masterReq));
}

															#line 7797 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRegistration()
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateRegistrationActor>
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateRegistrationActorState {
															#line 7804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateRegistrationActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& logSystem) 
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   logSystem(logSystem),
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True)),
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   trigger(self->registrationTrigger.onTrigger()),
															#line 841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   updateLogsKey()
															#line 7819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRegistration", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRegistrationActorState() 
	{
		fdb_probe_actor_destroy("updateRegistration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 843 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 7834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRegistrationActorState();
		static_cast<UpdateRegistrationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = trigger;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 1;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 0, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(.001);
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 2;
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 1, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7887 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(.001);
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 2;
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 1, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		trigger = self->registrationTrigger.onTrigger();
															#line 849 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logSystemConfig = logSystem->getLogSystemConfig();
															#line 850 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdateRegistration", self->dbgid) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("OldestBackupEpoch", logSystemConfig.oldestBackupEpoch) .detail("Logs", describe(logSystemConfig.tLogs)) .detail("OldGenerations", logSystemConfig.oldTLogs.size()) .detail("CStateUpdated", self->cstateUpdated.isSet()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd);
															#line 859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstateUpdated.isSet())
															#line 7993 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->provisionalCommitProxies, self->provisionalGrvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, self->cstate.prevDBState.getPriorCommittedLogServers());
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7999 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 3;
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 2, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8004 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 8011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 869 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				updateLogsKey = updateLogsValue(self, cx);
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_3 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->commitProxies, self->grvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, std::vector<UID>());
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 4;
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 3, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8024 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "cstate is updated but we aren't accepting commits yet", probe::decoration::rare);
															#line 8031 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		trigger = self->registrationTrigger.onTrigger();
															#line 849 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logSystemConfig = logSystem->getLogSystemConfig();
															#line 850 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdateRegistration", self->dbgid) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("OldestBackupEpoch", logSystemConfig.oldestBackupEpoch) .detail("Logs", describe(logSystemConfig.tLogs)) .detail("OldGenerations", logSystemConfig.oldTLogs.size()) .detail("CStateUpdated", self->cstateUpdated.isSet()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd);
															#line 859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstateUpdated.isSet())
															#line 8048 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->provisionalCommitProxies, self->provisionalGrvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, self->cstate.prevDBState.getPriorCommittedLogServers());
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8054 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 3;
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 2, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8059 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 8066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 869 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				updateLogsKey = updateLogsValue(self, cx);
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_3 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->commitProxies, self->grvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, std::vector<UID>());
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8074 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 4;
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 3, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "cstate is updated but we aren't accepting commits yet", probe::decoration::rare);
															#line 8086 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> trigger;
															#line 841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> updateLogsKey;
															#line 8364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateRegistration()
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateRegistrationActor final : public Actor<Void>, public ActorCallback< UpdateRegistrationActor, 0, Void >, public ActorCallback< UpdateRegistrationActor, 1, Void >, public ActorCallback< UpdateRegistrationActor, 2, Void >, public ActorCallback< UpdateRegistrationActor, 3, Void >, public FastAllocated<UpdateRegistrationActor>, public UpdateRegistrationActorState<UpdateRegistrationActor> {
															#line 8369 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateRegistrationActor>::operator new;
	using FastAllocated<UpdateRegistrationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8452135726925381376UL, 18345342320924676096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRegistrationActor, 0, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 1, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 2, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 3, Void >;
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateRegistrationActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& logSystem) 
															#line 8389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRegistrationActorState<UpdateRegistrationActor>(self, logSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13255450057400323584UL, 112464096235605248UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRegistration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateRegistration( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& logSystem ) {
															#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateRegistrationActor(self, logSystem));
															#line 8425 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 8430 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via provisionalMaster()
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ProvisionalMasterActor>
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ProvisionalMasterActorState {
															#line 8437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ProvisionalMasterActorState(Reference<ClusterRecoveryData> const& parent,Future<Void> const& activate) 
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : parent(parent),
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   activate(activate)
															#line 8446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("provisionalMaster", reinterpret_cast<unsigned long>(this));

	}
	~ProvisionalMasterActorState() 
	{
		fdb_probe_actor_destroy("provisionalMaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = activate;
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 1;
															#line 886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 0, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 8468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvisionalMasterActorState();
		static_cast<ProvisionalMasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies = std::vector<CommitProxyInterface>(1);
															#line 890 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].provisional = true;
															#line 891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].initEndpoints();
															#line 892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies = std::vector<GrvProxyInterface>(1);
															#line 893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].provisional = true;
															#line 894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].initEndpoints();
															#line 895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitCommitProxyFailure = waitFailureServer(parent->provisionalCommitProxies[0].waitFailure.getFuture());
															#line 897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitGrvProxyFailure = waitFailureServer(parent->provisionalGrvProxies[0].waitFailure.getFuture());
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->registrationTrigger.trigger();
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto lockedKey = parent->txnStateStore->readValue(databaseLockedKey).get();
															#line 902 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locked = lockedKey.present() && lockedKey.get().size();
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		metadataVersion = parent->txnStateStore->readValue(metadataVersionKey).get();
															#line 908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 8515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies = std::vector<CommitProxyInterface>(1);
															#line 890 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].provisional = true;
															#line 891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].initEndpoints();
															#line 892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies = std::vector<GrvProxyInterface>(1);
															#line 893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].provisional = true;
															#line 894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].initEndpoints();
															#line 895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitCommitProxyFailure = waitFailureServer(parent->provisionalCommitProxies[0].waitFailure.getFuture());
															#line 897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitGrvProxyFailure = waitFailureServer(parent->provisionalGrvProxies[0].waitFailure.getFuture());
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->registrationTrigger.trigger();
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto lockedKey = parent->txnStateStore->readValue(databaseLockedKey).get();
															#line 902 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locked = lockedKey.present() && lockedKey.get().size();
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		metadataVersion = parent->txnStateStore->readValue(metadataVersionKey).get();
															#line 908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 8548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state > 0) static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 0;
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 909 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto __when_expr_1 = parent->provisionalGrvProxies[0].getConsistentReadVersion.getFuture();
															#line 8639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetReadVersionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetReadVersionRequest>>::value, "invalid type");
															#line 908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto __when_expr_2 = parent->provisionalCommitProxies[0].commit.getFuture();
															#line 8647 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<CommitTransactionRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<CommitTransactionRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.pop(), loopDepth); };
															#line 952 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto __when_expr_3 = parent->provisionalCommitProxies[0].getKeyServersLocations.getFuture();
															#line 8652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<GetKeyServerLocationsRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<GetKeyServerLocationsRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 956 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitCommitProxyFailure;
															#line 8657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when4(__when_expr_4.get(), loopDepth); };
															#line 959 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitGrvProxyFailure;
															#line 8661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 2;
															#line 909 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 952 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 956 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 4, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 959 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 5, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 8674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetReadVersionRequest const& req,int loopDepth) 
	{
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((req.flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY) && (req.flags & GetReadVersionRequest::FLAG_USE_PROVISIONAL_PROXIES) && parent->lastEpochEnd)
															#line 8689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			GetReadVersionReply rep;
															#line 914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.version = parent->lastEpochEnd;
															#line 915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.locked = locked;
															#line 916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.metadataVersion = metadataVersion;
															#line 917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.proxyId = parent->provisionalGrvProxies[0].id();
															#line 918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(rep);
															#line 8703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(Never());
															#line 8709 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetReadVersionRequest && req,int loopDepth) 
	{
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((req.flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY) && (req.flags & GetReadVersionRequest::FLAG_USE_PROVISIONAL_PROXIES) && parent->lastEpochEnd)
															#line 8719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			GetReadVersionReply rep;
															#line 914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.version = parent->lastEpochEnd;
															#line 915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.locked = locked;
															#line 916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.metadataVersion = metadataVersion;
															#line 917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.proxyId = parent->provisionalGrvProxies[0].id();
															#line 918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(rep);
															#line 8733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 920 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(Never());
															#line 8739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(CommitTransactionRequest const& req,int loopDepth) 
	{
															#line 923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto t = &req.transaction;
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (t->read_snapshot == parent->lastEpochEnd && !std::any_of(t->read_conflict_ranges.begin(), t->read_conflict_ranges.end(), [](KeyRangeRef const& r) { return r.contains(lastEpochEndKey); }))
															#line 8753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 933 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(auto m = t->mutations.begin();m != t->mutations.end();++m) {
															#line 934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("PM_CTM", parent->dbgid) .detail("MType", m->type) .detail("Param1", m->param1) .detail("Param2", m->param2);
															#line 939 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (parent->configuration.involveMutation(*m))
															#line 8761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 942 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> out;
															#line 943 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.read_snapshot = invalidVersion;
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.mutations.append_deep(out.arena(), t->mutations.begin(), t->mutations.size());
															#line 945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.write_conflict_ranges.append_deep( out.arena(), t->write_conflict_ranges.begin(), t->write_conflict_ranges.size());
															#line 947 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!static_cast<ProvisionalMasterActor*>(this)->SAV<Standalone<CommitTransactionRef>>::futures) { (void)(out); this->~ProvisionalMasterActorState(); static_cast<ProvisionalMasterActor*>(this)->destroy(); return 0; }
															#line 8773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					new (&static_cast<ProvisionalMasterActor*>(this)->SAV< Standalone<CommitTransactionRef> >::value()) Standalone<CommitTransactionRef>(out);
					this->~ProvisionalMasterActorState();
					static_cast<ProvisionalMasterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(CommitTransactionRequest && req,int loopDepth) 
	{
															#line 923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto t = &req.transaction;
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (t->read_snapshot == parent->lastEpochEnd && !std::any_of(t->read_conflict_ranges.begin(), t->read_conflict_ranges.end(), [](KeyRangeRef const& r) { return r.contains(lastEpochEndKey); }))
															#line 8793 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 933 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(auto m = t->mutations.begin();m != t->mutations.end();++m) {
															#line 934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("PM_CTM", parent->dbgid) .detail("MType", m->type) .detail("Param1", m->param1) .detail("Param2", m->param2);
															#line 939 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (parent->configuration.involveMutation(*m))
															#line 8801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 942 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> out;
															#line 943 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.read_snapshot = invalidVersion;
															#line 944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.mutations.append_deep(out.arena(), t->mutations.begin(), t->mutations.size());
															#line 945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.write_conflict_ranges.append_deep( out.arena(), t->write_conflict_ranges.begin(), t->write_conflict_ranges.size());
															#line 947 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!static_cast<ProvisionalMasterActor*>(this)->SAV<Standalone<CommitTransactionRef>>::futures) { (void)(out); this->~ProvisionalMasterActorState(); static_cast<ProvisionalMasterActor*>(this)->destroy(); return 0; }
															#line 8813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					new (&static_cast<ProvisionalMasterActor*>(this)->SAV< Standalone<CommitTransactionRef> >::value()) Standalone<CommitTransactionRef>(out);
					this->~ProvisionalMasterActorState();
					static_cast<ProvisionalMasterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
															#line 954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8829 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
															#line 954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 957 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 960 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8863 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(Void && _,int loopDepth) 
	{
															#line 960 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state > 0) static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 0;
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 4, Void >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,GetReadVersionRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,GetReadVersionRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,CommitTransactionRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,CommitTransactionRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> parent;
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> activate;
															#line 895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> waitCommitProxyFailure;
															#line 897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> waitGrvProxyFailure;
															#line 902 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool locked;
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Value> metadataVersion;
															#line 9182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via provisionalMaster()
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ProvisionalMasterActor final : public Actor<Standalone<CommitTransactionRef>>, public ActorCallback< ProvisionalMasterActor, 0, Void >, public ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >, public ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >, public ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >, public ActorCallback< ProvisionalMasterActor, 4, Void >, public ActorCallback< ProvisionalMasterActor, 5, Void >, public FastAllocated<ProvisionalMasterActor>, public ProvisionalMasterActorState<ProvisionalMasterActor> {
															#line 9187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ProvisionalMasterActor>::operator new;
	using FastAllocated<ProvisionalMasterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17163467160176159488UL, 10160622205101227776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<CommitTransactionRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvisionalMasterActor, 0, Void >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >;
friend struct ActorCallback< ProvisionalMasterActor, 4, Void >;
friend struct ActorCallback< ProvisionalMasterActor, 5, Void >;
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ProvisionalMasterActor(Reference<ClusterRecoveryData> const& parent,Future<Void> const& activate) 
															#line 9209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Standalone<CommitTransactionRef>>(),
		   ProvisionalMasterActorState<ProvisionalMasterActor>(parent, activate),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9488506576048902144UL, 11989355939878536192UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provisionalMaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvisionalMasterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Standalone<CommitTransactionRef>> provisionalMaster( Reference<ClusterRecoveryData> const& parent, Future<Void> const& activate ) {
															#line 884 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Standalone<CommitTransactionRef>>(new ProvisionalMasterActor(parent, activate));
															#line 9243 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 964 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// Monitors the initialization of transaction system roles (commit proxies, GRV proxies, resolvers, TLogs, LogRouters)
// during cluster recovery and enforces a timeout if they take too long to initialize.
//
// The timeout uses exponential backoff based on the number of previous failed recovery attempts:
// - By default: base timeout (30s) doubles with each unfinished recovery: 30s, 60s, 120s, 240s, up to max (300s)
// - This prevents rapid recovery retry loops while allowing quick initial attempts
// - All timeout values are configurable via SERVER_KNOBS
															#line 9255 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorInitializingTxnSystem()
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class MonitorInitializingTxnSystemActor>
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class MonitorInitializingTxnSystemActorState {
															#line 9262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	MonitorInitializingTxnSystemActorState(int const& unfinishedRecoveries) 
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : unfinishedRecoveries(unfinishedRecoveries)
															#line 9269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this));

	}
	~MonitorInitializingTxnSystemActorState() 
	{
		fdb_probe_actor_destroy("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 975 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const bool validParameters = unfinishedRecoveries >= 1 && SERVER_KNOBS->CC_RECOVERY_INIT_REQ_TIMEOUT > 0 && SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_TIMEOUT > 0 && SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR > 1.0 && SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR <= 10.0;
															#line 980 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!validParameters)
															#line 9286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarnAlways, "InitializingTxnSystemTimeoutInvalid") .detail("BaseTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_TIMEOUT) .detail("GrowthFactor", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR) .detail("MaxTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_TIMEOUT) .detail("UnfinishedRecoveries", unfinishedRecoveries) .detail("MaxUnfinishedRecoveries", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_UNFINISHED_RECOVERIES);
															#line 987 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				ASSERT_WE_THINK(false);
															#line 989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				this->~MonitorInitializingTxnSystemActorState();
															#line 9294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				static_cast<MonitorInitializingTxnSystemActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 992 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const bool tooManyUnfinishedRecoveries = unfinishedRecoveries >= SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_UNFINISHED_RECOVERIES;
															#line 994 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (tooManyUnfinishedRecoveries)
															#line 9302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 995 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarnAlways, "InitializingTxnSystemTimeoutTooMany") .detail("BaseTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_TIMEOUT) .detail("GrowthFactor", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR) .detail("MaxTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_TIMEOUT) .detail("UnfinishedRecoveries", unfinishedRecoveries) .detail("MaxUnfinishedRecoveries", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_UNFINISHED_RECOVERIES);
															#line 1001 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				this->~MonitorInitializingTxnSystemActorState();
															#line 9308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				static_cast<MonitorInitializingTxnSystemActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 1007 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const double scalingFactor = std::pow(SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR, unfinishedRecoveries);
															#line 1008 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const double scaledTimeout = std::min(SERVER_KNOBS->CC_RECOVERY_INIT_REQ_TIMEOUT * scalingFactor, SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_TIMEOUT);
															#line 1011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("InitializingTxnSystemTimeout") .detail("BaseTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_TIMEOUT) .detail("GrowthFactor", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_GROWTH_FACTOR) .detail("MaxTimeout", SERVER_KNOBS->CC_RECOVERY_INIT_REQ_MAX_TIMEOUT) .detail("UnfinishedRecoveries", unfinishedRecoveries) .detail("ScalingFactor", scalingFactor) .detail("ScaledTimeout", scaledTimeout);
															#line 1019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(scaledTimeout);
															#line 1019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<MonitorInitializingTxnSystemActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorInitializingTxnSystemActor*>(this)->actor_wait_state = 1;
															#line 1019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >*>(static_cast<MonitorInitializingTxnSystemActor*>(this)));
															#line 9327 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorInitializingTxnSystemActorState();
		static_cast<MonitorInitializingTxnSystemActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("InitializingTxnSystemTimeoutTriggered");
															#line 1022 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 9352 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("InitializingTxnSystemTimeoutTriggered");
															#line 1022 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 9362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorInitializingTxnSystemActor*>(this)->actor_wait_state > 0) static_cast<MonitorInitializingTxnSystemActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorInitializingTxnSystemActor*>(this)->ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorInitializingTxnSystemActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorInitializingTxnSystemActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorInitializingTxnSystemActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int unfinishedRecoveries;
															#line 9443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via monitorInitializingTxnSystem()
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class MonitorInitializingTxnSystemActor final : public Actor<Void>, public ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >, public FastAllocated<MonitorInitializingTxnSystemActor>, public MonitorInitializingTxnSystemActorState<MonitorInitializingTxnSystemActor> {
															#line 9448 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<MonitorInitializingTxnSystemActor>::operator new;
	using FastAllocated<MonitorInitializingTxnSystemActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16979283831336510208UL, 14270753447201398016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >;
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	MonitorInitializingTxnSystemActor(int const& unfinishedRecoveries) 
															#line 9465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorInitializingTxnSystemActorState<MonitorInitializingTxnSystemActor>(unfinishedRecoveries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6784107914364990720UL, 2544754587531207936UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorInitializingTxnSystemActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorInitializingTxnSystem");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorInitializingTxnSystem", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorInitializingTxnSystemActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> monitorInitializingTxnSystem( int const& unfinishedRecoveries ) {
															#line 972 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new MonitorInitializingTxnSystemActor(unfinishedRecoveries));
															#line 9498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1024 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 9503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitEverything()
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitEverythingActor>
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitEverythingActorState {
															#line 9510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitEverythingActorState(Reference<ClusterRecoveryData> const& self,std::vector<StorageServerInterface>* const& seedServers,Reference<ILogSystem> const& oldLogSystem) 
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   seedServers(seedServers),
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem)
															#line 9521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitEverything", reinterpret_cast<unsigned long>(this));

	}
	~RecruitEverythingActorState() 
	{
		fdb_probe_actor_destroy("recruitEverything", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1029 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!self->configuration.isValid())
															#line 9536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1030 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				RecoveryStatus::RecoveryStatus status;
															#line 1031 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->configuration.initialized)
															#line 9542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1032 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent( SevWarn, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_INVALID_CONFIG_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString());
															#line 1039 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					status = RecoveryStatus::configuration_invalid;
															#line 9548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
				else
				{
															#line 1040 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!self->cstate.prevDBState.tLogs.size())
															#line 9554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					{
															#line 1041 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						status = RecoveryStatus::configuration_never_created;
															#line 1042 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						self->neverCreated = true;
															#line 9560 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					}
					else
					{
															#line 1044 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						status = RecoveryStatus::configuration_missing;
															#line 9566 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					}
				}
															#line 1046 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", status) .detail("Status", RecoveryStatus::names[status]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1051 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				this->~RecruitEverythingActorState();
															#line 9573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				static_cast<RecruitEverythingActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			else
			{
															#line 1053 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .setMaxFieldLength(-1) .detail("StatusCode", RecoveryStatus::recruiting_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::recruiting_transaction_servers]) .detail("Conf", self->configuration.toString()) .detail("RequiredCommitProxies", 1) .detail("RequiredGrvProxies", 1) .detail("RequiredResolvers", 1) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1064 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->controllerData->encryptionAtRestMode.canBeSet())
															#line 9583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->controllerData->encryptionAtRestMode.send(getEncryptionAtRest(self->configuration));
															#line 9587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
															#line 1070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int maxLogRouters = self->cstate.prevDBState.logRouterTags;
															#line 1071 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& old : self->cstate.prevDBState.oldTLogData ) {
															#line 1072 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				maxLogRouters = std::max(maxLogRouters, old.logRouterTags);
															#line 9596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1075 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			RecruitFromConfigurationRequest recruitReq(self->configuration, self->lastEpochEnd == 0, maxLogRouters);
															#line 1076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitWorkersInfo = makeReference<RecruitWorkersInfo>(recruitReq);
															#line 1077 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitWorkersInfo->dbgId = self->dbgid;
															#line 1078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = clusterRecruitFromConfiguration(self->controllerData, recruitWorkersInfo);
															#line 1078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9608 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 1;
															#line 1078 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 0, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9613 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruits = recruitWorkersInfo->rep;
															#line 1081 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::string primaryDcIds, remoteDcIds;
															#line 1083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryDcId.clear();
															#line 1084 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->remoteDcIds.clear();
															#line 1085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recruits.dcId.present())
															#line 9644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1086 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->primaryDcId.push_back(recruits.dcId);
															#line 1087 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!primaryDcIds.empty())
															#line 9650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1088 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				primaryDcIds += ',';
															#line 9654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			primaryDcIds += printable(recruits.dcId);
															#line 1091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.regions.size() > 1)
															#line 9660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key remoteDcId = recruits.dcId.get() == self->configuration.regions[0].dcId ? self->configuration.regions[1].dcId : self->configuration.regions[0].dcId;
															#line 1095 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->remoteDcIds.push_back(remoteDcId);
															#line 1096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!remoteDcIds.empty())
															#line 9668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					remoteDcIds += ',';
															#line 9672 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 1099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcIds += printable(remoteDcId);
															#line 9676 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->backupWorkers.swap(recruits.backupWorkers);
															#line 1106 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryRecruitment = recruits;
															#line 1108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::initializing_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::initializing_transaction_servers]) .detail("CommitProxies", recruits.commitProxies.size()) .detail("GrvProxies", recruits.grvProxies.size()) .detail("TLogs", recruits.tLogs.size()) .detail("Resolvers", recruits.resolvers.size()) .detail("SatelliteTLogs", recruits.satelliteTLogs.size()) .detail("OldLogRouters", recruits.oldLogRouters.size()) .detail("StorageServers", recruits.storageServers.size()) .detail("BackupWorkers", self->backupWorkers.size()) .detail("PrimaryDcIds", primaryDcIds) .detail("RemoteDcIds", remoteDcIds) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newSeedServers(self, recruits, seedServers);
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 2;
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 1, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruits = recruitWorkersInfo->rep;
															#line 1081 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::string primaryDcIds, remoteDcIds;
															#line 1083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryDcId.clear();
															#line 1084 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->remoteDcIds.clear();
															#line 1085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recruits.dcId.present())
															#line 9711 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1086 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->primaryDcId.push_back(recruits.dcId);
															#line 1087 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!primaryDcIds.empty())
															#line 9717 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1088 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				primaryDcIds += ',';
															#line 9721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			primaryDcIds += printable(recruits.dcId);
															#line 1091 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.regions.size() > 1)
															#line 9727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1092 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key remoteDcId = recruits.dcId.get() == self->configuration.regions[0].dcId ? self->configuration.regions[1].dcId : self->configuration.regions[0].dcId;
															#line 1095 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->remoteDcIds.push_back(remoteDcId);
															#line 1096 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!remoteDcIds.empty())
															#line 9735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					remoteDcIds += ',';
															#line 9739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 1099 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcIds += printable(remoteDcId);
															#line 9743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->backupWorkers.swap(recruits.backupWorkers);
															#line 1106 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryRecruitment = recruits;
															#line 1108 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::initializing_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::initializing_transaction_servers]) .detail("CommitProxies", recruits.commitProxies.size()) .detail("GrvProxies", recruits.grvProxies.size()) .detail("TLogs", recruits.tLogs.size()) .detail("Resolvers", recruits.resolvers.size()) .detail("SatelliteTLogs", recruits.satelliteTLogs.size()) .detail("OldLogRouters", recruits.oldLogRouters.size()) .detail("StorageServers", recruits.storageServers.size()) .detail("BackupWorkers", self->backupWorkers.size()) .detail("PrimaryDcIds", primaryDcIds) .detail("RemoteDcIds", remoteDcIds) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newSeedServers(self, recruits, seedServers);
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9756 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 2;
															#line 1127 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 1, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		confChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Future<Void> txnSystemInitialized = traceAfter(newCommitProxies(self, recruits), "CommitProxiesInitialized") && traceAfter(newGrvProxies(self, recruits), "GRVProxiesInitialized") && traceAfter(newResolvers(self, recruits), "ResolversInitialized") && traceAfter(newTLogServers(self, recruits, oldLogSystem, &confChanges), "TLogServersInitialized");
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = txnSystemInitialized || monitorInitializingTxnSystem(self->controllerData->db.unfinishedRecoveries);
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 3;
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 2, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9856 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		confChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1130 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Future<Void> txnSystemInitialized = traceAfter(newCommitProxies(self, recruits), "CommitProxiesInitialized") && traceAfter(newGrvProxies(self, recruits), "GRVProxiesInitialized") && traceAfter(newResolvers(self, recruits), "ResolversInitialized") && traceAfter(newTLogServers(self, recruits, oldLogSystem, &confChanges), "TLogServersInitialized");
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = txnSystemInitialized || monitorInitializingTxnSystem(self->controllerData->db.unfinishedRecoveries);
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 3;
															#line 1135 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 2, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9876 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = brokenPromiseToNever( self->masterInterface.updateRecoveryData.getReply(UpdateRecoveryDataRequest(self->recoveryTransactionVersion, self->lastEpochEnd, self->commitProxies, self->resolvers, self->versionEpoch, self->primaryLocality)));
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 4;
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 3, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9967 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = brokenPromiseToNever( self->masterInterface.updateRecoveryData.getReply(UpdateRecoveryDataRequest(self->recoveryTransactionVersion, self->lastEpochEnd, self->commitProxies, self->resolvers, self->versionEpoch, self->primaryLocality)));
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 4;
															#line 1138 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 3, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9983 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 1146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitEverythingActor*>(this)->SAV<std::vector<Standalone<CommitTransactionRef>>>::futures) { (void)(confChanges); this->~RecruitEverythingActorState(); static_cast<RecruitEverythingActor*>(this)->destroy(); return 0; }
															#line 10067 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitEverythingActor*>(this)->SAV< std::vector<Standalone<CommitTransactionRef>> >::value()) std::vector<Standalone<CommitTransactionRef>>(std::move(confChanges)); // state_var_RVO
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
															#line 1146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitEverythingActor*>(this)->SAV<std::vector<Standalone<CommitTransactionRef>>>::futures) { (void)(confChanges); this->~RecruitEverythingActorState(); static_cast<RecruitEverythingActor*>(this)->destroy(); return 0; }
															#line 10079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitEverythingActor*>(this)->SAV< std::vector<Standalone<CommitTransactionRef>> >::value()) std::vector<Standalone<CommitTransactionRef>>(std::move(confChanges)); // state_var_RVO
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* seedServers;
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitWorkersInfo> recruitWorkersInfo;
															#line 1079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recruits;
															#line 1129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>> confChanges;
															#line 10174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitEverything()
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitEverythingActor final : public Actor<std::vector<Standalone<CommitTransactionRef>>>, public ActorCallback< RecruitEverythingActor, 0, Void >, public ActorCallback< RecruitEverythingActor, 1, Void >, public ActorCallback< RecruitEverythingActor, 2, Void >, public ActorCallback< RecruitEverythingActor, 3, Void >, public FastAllocated<RecruitEverythingActor>, public RecruitEverythingActorState<RecruitEverythingActor> {
															#line 10179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitEverythingActor>::operator new;
	using FastAllocated<RecruitEverythingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7506093884796275712UL, 8318388740002276096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Standalone<CommitTransactionRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitEverythingActor, 0, Void >;
friend struct ActorCallback< RecruitEverythingActor, 1, Void >;
friend struct ActorCallback< RecruitEverythingActor, 2, Void >;
friend struct ActorCallback< RecruitEverythingActor, 3, Void >;
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitEverythingActor(Reference<ClusterRecoveryData> const& self,std::vector<StorageServerInterface>* const& seedServers,Reference<ILogSystem> const& oldLogSystem) 
															#line 10199 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<std::vector<Standalone<CommitTransactionRef>>>(),
		   RecruitEverythingActorState<RecruitEverythingActor>(self, seedServers, oldLogSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9272114927119600896UL, 817781714740981504UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitEverything");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitEverythingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitEverythingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitEverythingActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecruitEverythingActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<std::vector<Standalone<CommitTransactionRef>>> recruitEverything( Reference<ClusterRecoveryData> const& self, std::vector<StorageServerInterface>* const& seedServers, Reference<ILogSystem> const& oldLogSystem ) {
															#line 1025 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<std::vector<Standalone<CommitTransactionRef>>>(new RecruitEverythingActor(self, seedServers, oldLogSystem));
															#line 10235 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1148 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 10240 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLocalityForDcId()
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateLocalityForDcIdActor>
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLocalityForDcIdActorState {
															#line 10247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLocalityForDcIdActorState(Optional<Key> const& dcId,Reference<ILogSystem> const& oldLogSystem,Reference<AsyncVar<PeekTxsInfo>> const& locality) 
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : dcId(dcId),
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   locality(locality)
															#line 10258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLocalityForDcId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLocalityForDcIdActorState() 
	{
		fdb_probe_actor_destroy("updateLocalityForDcId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1152 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 10273 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLocalityForDcIdActorState();
		static_cast<UpdateLocalityForDcIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1153 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::pair<int8_t, int8_t> loc = oldLogSystem->getLogSystemConfig().getLocalityForDcId(dcId);
															#line 1154 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version ver = locality->get().knownCommittedVersion;
															#line 1155 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (ver == invalidVersion)
															#line 10307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ver = oldLogSystem->getKnownCommittedVersion();
															#line 10311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1159 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locality->set(PeekTxsInfo(loc.first, loc.second, ver));
															#line 1160 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdatedLocalityForDcId") .detail("DcId", dcId) .detail("Locality0", loc.first) .detail("Locality1", loc.second) .detail("Version", ver);
															#line 1165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = oldLogSystem->onLogSystemConfigChange() || oldLogSystem->onKnownCommittedVersionChange();
															#line 1165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10321 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state = 1;
															#line 1165 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*>(static_cast<UpdateLocalityForDcIdActor*>(this)));
															#line 10326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLocalityForDcIdActor*>(this)->ActorCallback< UpdateLocalityForDcIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Key> dcId;
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<PeekTxsInfo>> locality;
															#line 10424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateLocalityForDcId()
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLocalityForDcIdActor final : public Actor<Void>, public ActorCallback< UpdateLocalityForDcIdActor, 0, Void >, public FastAllocated<UpdateLocalityForDcIdActor>, public UpdateLocalityForDcIdActorState<UpdateLocalityForDcIdActor> {
															#line 10429 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateLocalityForDcIdActor>::operator new;
	using FastAllocated<UpdateLocalityForDcIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14449647963168674816UL, 11378159177756117504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLocalityForDcIdActor, 0, Void >;
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLocalityForDcIdActor(Optional<Key> const& dcId,Reference<ILogSystem> const& oldLogSystem,Reference<AsyncVar<PeekTxsInfo>> const& locality) 
															#line 10446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLocalityForDcIdActorState<UpdateLocalityForDcIdActor>(dcId, oldLogSystem, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11153092578858990848UL, 10071858602761177088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLocalityForDcId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateLocalityForDcId( Optional<Key> const& dcId, Reference<ILogSystem> const& oldLogSystem, Reference<AsyncVar<PeekTxsInfo>> const& locality ) {
															#line 1149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateLocalityForDcIdActor(dcId, oldLogSystem, locality));
															#line 10479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1168 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 10484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via readTransactionSystemState()
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ReadTransactionSystemStateActor>
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ReadTransactionSystemStateActorState {
															#line 10491 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadTransactionSystemStateActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,Version const& txsPoppedVersion) 
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txsPoppedVersion(txsPoppedVersion),
															#line 1172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   myLocality(Reference<AsyncVar<PeekTxsInfo>>( new AsyncVar<PeekTxsInfo>(PeekTxsInfo(tagLocalityInvalid, tagLocalityInvalid, invalidVersion)))),
															#line 1174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   localityUpdater(updateLocalityForDcId(self->masterInterface.locality.dcId(), oldLogSystem, myLocality)),
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   enableEncryptionForTxnStateStore(false)
															#line 10508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("readTransactionSystemState", reinterpret_cast<unsigned long>(this));

	}
	~ReadTransactionSystemStateActorState() 
	{
		fdb_probe_actor_destroy("readTransactionSystemState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->controllerData->encryptionAtRestMode.getFuture().isReady())
															#line 10523 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<EncryptionAtRestMode> __when_expr_0 = self->controllerData->encryptionAtRestMode.getFuture();
															#line 1189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 1;
															#line 1189 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(enableEncryptionForTxnStateStore, "Enable encryption for txnStateStore", probe::decoration::rare);
															#line 1193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->txnStateStore)
															#line 10564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->txnStateStore->close();
															#line 10568 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter = openDiskQueueAdapter(oldLogSystem, myLocality, txsPoppedVersion);
															#line 1196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateStore = keyValueStoreLogSystem(self->txnStateLogAdapter, self->dbInfo, self->dbgid, self->memoryLimit, false, false, true, enableEncryptionForTxnStateStore);
															#line 1207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->versionEpoch.reset();
															#line 1208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = self->txnStateStore->readValue(versionEpochKey);
															#line 1208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10580 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 2;
															#line 1208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10585 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EncryptionAtRestMode const& encryptMode,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		enableEncryptionForTxnStateStore = encryptMode.isEncryptionEnabled();
															#line 10594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(EncryptionAtRestMode && encryptMode,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		enableEncryptionForTxnStateStore = encryptMode.isEncryptionEnabled();
															#line 10603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode const& encryptMode,int loopDepth) 
	{
		loopDepth = a_body1cont2(encryptMode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode && encryptMode,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(encryptMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 1209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (versionEpochValue.present())
															#line 10687 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 10691 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = self->txnStateStore->readValue(minRequiredCommitVersionKey);
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 3;
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 1209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (versionEpochValue.present())
															#line 10711 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 10715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = self->txnStateStore->readValue(minRequiredCommitVersionKey);
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 3;
															#line 1216 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont4(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Optional<Standalone<StringRef>> const& requiredCommitVersion,int loopDepth) 
	{
															#line 1218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version minRequiredCommitVersion = -1;
															#line 1219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (requiredCommitVersion.present())
															#line 10812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1220 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(requiredCommitVersion.get(), Unversioned());
															#line 10816 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->versionEpoch.present())
															#line 10820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = std::max( minRequiredCommitVersion, static_cast<Version>(g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - self->versionEpoch.get()));
															#line 10824 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->lastEpochEnd = oldLogSystem->getEnd() - 1;
															#line 1230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd == 0)
															#line 10830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryTransactionVersion = 1;
															#line 10834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 10840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT_FORCED;
															#line 10844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 1236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 10850 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1239 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryTransactionVersion < minRequiredCommitVersion)
															#line 10854 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1240 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = minRequiredCommitVersion;
															#line 10858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 10862 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion += deterministicRandom()->randomInt64(0, 10000000);
															#line 10866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1251 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME).c_str(), self->dbgid) .detail("LastEpochEnd", self->lastEpochEnd) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->txnStateStore->readRange(configKeys);
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10875 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 4;
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10880 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Standalone<StringRef>> && requiredCommitVersion,int loopDepth) 
	{
															#line 1218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version minRequiredCommitVersion = -1;
															#line 1219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (requiredCommitVersion.present())
															#line 10891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1220 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(requiredCommitVersion.get(), Unversioned());
															#line 10895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1222 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->versionEpoch.present())
															#line 10899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = std::max( minRequiredCommitVersion, static_cast<Version>(g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - self->versionEpoch.get()));
															#line 10903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->lastEpochEnd = oldLogSystem->getEnd() - 1;
															#line 1230 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd == 0)
															#line 10909 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryTransactionVersion = 1;
															#line 10913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 10919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT_FORCED;
															#line 10923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 1236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 10929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1239 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryTransactionVersion < minRequiredCommitVersion)
															#line 10933 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1240 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = minRequiredCommitVersion;
															#line 10937 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 10941 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion += deterministicRandom()->randomInt64(0, 10000000);
															#line 10945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1251 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME).c_str(), self->dbgid) .detail("LastEpochEnd", self->lastEpochEnd) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->txnStateStore->readRange(configKeys);
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10954 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 4;
															#line 1256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10959 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Standalone<StringRef>> const& requiredCommitVersion,int loopDepth) 
	{
		loopDepth = a_body1cont6(requiredCommitVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Standalone<StringRef>> && requiredCommitVersion,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(requiredCommitVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(RangeResult const& rawConf,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration.fromKeyValues(rawConf.castTo<VectorRef<KeyValueRef>>());
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->originalConfiguration = self->configuration;
															#line 1259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->hasConfiguration = true;
															#line 1261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString()) .trackLatest(self->recoveredConfigEventHolder->trackingKey);
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = self->txnStateStore->readRange(tagLocalityListKeys);
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11053 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 5;
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(RangeResult && rawConf,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration.fromKeyValues(rawConf.castTo<VectorRef<KeyValueRef>>());
															#line 1258 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->originalConfiguration = self->configuration;
															#line 1259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->hasConfiguration = true;
															#line 1261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString()) .trackLatest(self->recoveredConfigEventHolder->trackingKey);
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = self->txnStateStore->readRange(tagLocalityListKeys);
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11077 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 5;
															#line 1268 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11082 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult const& rawConf,int loopDepth) 
	{
		loopDepth = a_body1cont8(rawConf, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult && rawConf,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(rawConf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(RangeResult const& rawLocalities,int loopDepth) 
	{
															#line 1269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 1270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawLocalities ) {
															#line 1271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[decodeTagLocalityListKey(kv.key)] = decodeTagLocalityListValue(kv.value);
															#line 11170 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = self->txnStateStore->readRange(serverTagKeys);
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 6;
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11181 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17(RangeResult && rawLocalities,int loopDepth) 
	{
															#line 1269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 1270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawLocalities ) {
															#line 1271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[decodeTagLocalityListKey(kv.key)] = decodeTagLocalityListValue(kv.value);
															#line 11194 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = self->txnStateStore->readRange(serverTagKeys);
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11200 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 6;
															#line 1274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11205 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult const& rawLocalities,int loopDepth) 
	{
		loopDepth = a_body1cont17(rawLocalities, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult && rawLocalities,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(rawLocalities), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont17cont1(RangeResult const& rawTags,int loopDepth) 
	{
															#line 1275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->allTags.clear();
															#line 1276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd > 0)
															#line 11291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(cacheTag);
															#line 11295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 11299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->safeLocality = oldLogSystem->getLogSystemConfig().tLogs[0].locality;
															#line 1282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Tag tag = decodeServerTagValue(kv.value);
															#line 1284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (tag.locality == self->safeLocality)
															#line 11309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->allTags.push_back(tag);
															#line 11313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1290 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11323 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = self->txnStateStore->readRange(serverTagHistoryKeys);
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11330 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont17cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 7;
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11335 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont1(RangeResult && rawTags,int loopDepth) 
	{
															#line 1275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->allTags.clear();
															#line 1276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd > 0)
															#line 11346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(cacheTag);
															#line 11350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1280 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 11354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->safeLocality = oldLogSystem->getLogSystemConfig().tLogs[0].locality;
															#line 1282 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Tag tag = decodeServerTagValue(kv.value);
															#line 1284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (tag.locality == self->safeLocality)
															#line 11364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->allTags.push_back(tag);
															#line 11368 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1289 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1290 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11378 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = self->txnStateStore->readRange(serverTagHistoryKeys);
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11385 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont17cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 7;
															#line 1294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17when1(RangeResult const& rawTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(rawTags, loopDepth);

		return loopDepth;
	}
	int a_body1cont17when1(RangeResult && rawTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(std::move(rawTags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont17cont3(RangeResult const& rawHistoryTags,int loopDepth) 
	{
															#line 1295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawHistoryTags ) {
															#line 1296 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = self->txnStateStore->readValue(metacluster::metadata::metaclusterRegistration().key);
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11482 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont17cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 8;
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont3(RangeResult && rawHistoryTags,int loopDepth) 
	{
															#line 1295 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawHistoryTags ) {
															#line 1296 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = self->txnStateStore->readValue(metacluster::metadata::metaclusterRegistration().key);
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11504 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont17cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 8;
															#line 1299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11509 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont1when1(RangeResult const& rawHistoryTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont3(rawHistoryTags, loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont1when1(RangeResult && rawHistoryTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont3(std::move(rawHistoryTags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont17cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont17cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont17cont10(Optional<Value> const& metaclusterRegistrationVal,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UnversionedMetaclusterRegistrationEntry> metaclusterRegistration = UnversionedMetaclusterRegistrationEntry::decode(metaclusterRegistrationVal);
															#line 1303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> metaclusterName;
															#line 1304 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> metaclusterId;
															#line 1305 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> clusterName;
															#line 1306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> clusterId;
															#line 1307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->db.metaclusterRegistration = metaclusterRegistration;
															#line 1308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (metaclusterRegistration.present())
															#line 11605 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1310 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = metaclusterRegistration.get().clusterType;
															#line 1311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterId = metaclusterRegistration.get().metaclusterId;
															#line 1313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA)
															#line 11617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterName = metaclusterRegistration.get().name;
															#line 1315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterId = metaclusterRegistration.get().id;
															#line 11623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = Optional<ClusterName>();
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = ClusterType::STANDALONE;
															#line 11632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MetaclusterMetadata") .detail("ClusterType", clusterTypeToString(self->controllerData->db.clusterType)) .detail("MetaclusterName", metaclusterName) .detail("MetaclusterId", metaclusterId) .detail("DataClusterName", clusterName) .detail("DataClusterId", clusterId) .trackLatest(self->metaclusterEventHolder->trackingKey);
															#line 1330 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		uniquify(self->allTags);
															#line 1336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter->setNextVersion( oldLogSystem->getEnd());
															#line 1341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RTSSComplete", self->dbgid).log();
															#line 1343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ReadTransactionSystemStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTransactionSystemStateActorState(); static_cast<ReadTransactionSystemStateActor*>(this)->destroy(); return 0; }
															#line 11644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ReadTransactionSystemStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont17cont10(Optional<Value> && metaclusterRegistrationVal,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UnversionedMetaclusterRegistrationEntry> metaclusterRegistration = UnversionedMetaclusterRegistrationEntry::decode(metaclusterRegistrationVal);
															#line 1303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> metaclusterName;
															#line 1304 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> metaclusterId;
															#line 1305 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> clusterName;
															#line 1306 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> clusterId;
															#line 1307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->db.metaclusterRegistration = metaclusterRegistration;
															#line 1308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (metaclusterRegistration.present())
															#line 11668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1309 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1310 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = metaclusterRegistration.get().clusterType;
															#line 1311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterId = metaclusterRegistration.get().metaclusterId;
															#line 1313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA)
															#line 11680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterName = metaclusterRegistration.get().name;
															#line 1315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterId = metaclusterRegistration.get().id;
															#line 11686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1318 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = Optional<ClusterName>();
															#line 1319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = ClusterType::STANDALONE;
															#line 11695 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MetaclusterMetadata") .detail("ClusterType", clusterTypeToString(self->controllerData->db.clusterType)) .detail("MetaclusterName", metaclusterName) .detail("MetaclusterId", metaclusterId) .detail("DataClusterName", clusterName) .detail("DataClusterId", clusterId) .trackLatest(self->metaclusterEventHolder->trackingKey);
															#line 1330 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		uniquify(self->allTags);
															#line 1336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter->setNextVersion( oldLogSystem->getEnd());
															#line 1341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RTSSComplete", self->dbgid).log();
															#line 1343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ReadTransactionSystemStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTransactionSystemStateActorState(); static_cast<ReadTransactionSystemStateActor*>(this)->destroy(); return 0; }
															#line 11707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ReadTransactionSystemStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont17cont3when1(Optional<Value> const& metaclusterRegistrationVal,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(metaclusterRegistrationVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont3when1(Optional<Value> && metaclusterRegistrationVal,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(std::move(metaclusterRegistrationVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont17cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont17cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Version txsPoppedVersion;
															#line 1172 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<PeekTxsInfo>> myLocality;
															#line 1174 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> localityUpdater;
															#line 1187 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool enableEncryptionForTxnStateStore;
															#line 11802 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via readTransactionSystemState()
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ReadTransactionSystemStateActor final : public Actor<Void>, public ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >, public ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >, public ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >, public FastAllocated<ReadTransactionSystemStateActor>, public ReadTransactionSystemStateActorState<ReadTransactionSystemStateActor> {
															#line 11807 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ReadTransactionSystemStateActor>::operator new;
	using FastAllocated<ReadTransactionSystemStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3338820371746085632UL, 17954792204176712192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >;
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadTransactionSystemStateActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,Version const& txsPoppedVersion) 
															#line 11831 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ReadTransactionSystemStateActorState<ReadTransactionSystemStateActor>(self, oldLogSystem, txsPoppedVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7841846366999263232UL, 14796013456903908864UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readTransactionSystemState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> readTransactionSystemState( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem, Version const& txsPoppedVersion ) {
															#line 1169 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ReadTransactionSystemStateActor(self, oldLogSystem, txsPoppedVersion));
															#line 11871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1345 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 11876 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via sendInitialCommitToResolvers()
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class SendInitialCommitToResolversActor>
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class SendInitialCommitToResolversActorState {
															#line 11883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	SendInitialCommitToResolversActorState(Reference<ClusterRecoveryData> const& self) 
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txnKeys(allKeys),
															#line 1348 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txnSequence(0)
															#line 11894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this));

	}
	~SendInitialCommitToResolversActorState() 
	{
		fdb_probe_actor_destroy("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->recoveryTransactionVersion);
															#line 1351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			data = self->txnStateStore ->readRange(txnKeys, BUGGIFY ? 3 : SERVER_KNOBS->DESIRED_TOTAL_BYTES, SERVER_KNOBS->DESIRED_TOTAL_BYTES) .get();
															#line 1355 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			txnReplies = std::vector<Future<Void>>();
															#line 1356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			dataOutstanding = 0;
															#line 1358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			endpoints = std::vector<Endpoint>();
															#line 1359 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& it : self->commitProxies ) {
															#line 1360 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				endpoints.push_back(it.txnState.getEndpoint());
															#line 11921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1362 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 11925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1364 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				for( auto& it : self->resolvers ) {
															#line 1365 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					endpoints.push_back(it.txnState.getEndpoint());
															#line 11931 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
															#line 1368 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 11936 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(txnReplies);
															#line 1396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11961 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 3;
															#line 1396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 2, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 11966 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1369 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!data.size())
															#line 11982 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 1372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		RangeResult nextData = self->txnStateStore ->readRange(txnKeys, BUGGIFY ? 3 : SERVER_KNOBS->DESIRED_TOTAL_BYTES, SERVER_KNOBS->DESIRED_TOTAL_BYTES) .get();
															#line 1377 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TxnStateRequest req;
															#line 1378 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.arena = data.arena();
															#line 1379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.data = data;
															#line 1380 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.sequence = txnSequence;
															#line 1381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.last = !nextData.size();
															#line 1382 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.broadcastInfo = endpoints;
															#line 1383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies.push_back(broadcastTxnRequest(req, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, false));
															#line 1384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding += SERVER_KNOBS->TXN_STATE_SEND_AMOUNT * data.arena().getSize();
															#line 1385 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		data = nextData;
															#line 1386 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnSequence++;
															#line 1388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (dataOutstanding > SERVER_KNOBS->MAX_TXS_SEND_MEMORY)
															#line 12012 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(txnReplies);
															#line 1389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12018 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 1;
															#line 1389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 0, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12023 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12052 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 2;
															#line 1394 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 1, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12057 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies = std::vector<Future<Void>>();
															#line 1391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding = 0;
															#line 12068 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies = std::vector<Future<Void>>();
															#line 1391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding = 0;
															#line 12079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "SentTxnStateStoreToCommitProxies");
															#line 1404 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 1405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& r : self->resolvers ) {
															#line 1406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ResolveTransactionBatchRequest req;
															#line 1407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.prevVersion = -1;
															#line 1408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.version = self->lastEpochEnd;
															#line 1409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastReceivedVersion = -1;
															#line 1410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastShardMove = -1;
															#line 1411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			replies.push_back(brokenPromiseToNever(r.resolve.getReply(req)));
															#line 12266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12272 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 4;
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 3, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "SentTxnStateStoreToCommitProxies");
															#line 1404 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 1405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& r : self->resolvers ) {
															#line 1406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ResolveTransactionBatchRequest req;
															#line 1407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.prevVersion = -1;
															#line 1408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.version = self->lastEpochEnd;
															#line 1409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastReceivedVersion = -1;
															#line 1410 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastShardMove = -1;
															#line 1411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			replies.push_back(brokenPromiseToNever(r.resolve.getReply(req)));
															#line 12302 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 4;
															#line 1414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 3, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "InitializedAllResolvers");
															#line 1421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<SendInitialCommitToResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendInitialCommitToResolversActorState(); static_cast<SendInitialCommitToResolversActor*>(this)->destroy(); return 0; }
															#line 12399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<SendInitialCommitToResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "InitializedAllResolvers");
															#line 1421 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<SendInitialCommitToResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendInitialCommitToResolversActorState(); static_cast<SendInitialCommitToResolversActor*>(this)->destroy(); return 0; }
															#line 12413 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<SendInitialCommitToResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	KeyRange txnKeys;
															#line 1348 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Sequence txnSequence;
															#line 1351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RangeResult data;
															#line 1355 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Future<Void>> txnReplies;
															#line 1356 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int64_t dataOutstanding;
															#line 1358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Endpoint> endpoints;
															#line 12510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via sendInitialCommitToResolvers()
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class SendInitialCommitToResolversActor final : public Actor<Void>, public ActorCallback< SendInitialCommitToResolversActor, 0, Void >, public ActorCallback< SendInitialCommitToResolversActor, 1, Void >, public ActorCallback< SendInitialCommitToResolversActor, 2, Void >, public ActorCallback< SendInitialCommitToResolversActor, 3, Void >, public FastAllocated<SendInitialCommitToResolversActor>, public SendInitialCommitToResolversActorState<SendInitialCommitToResolversActor> {
															#line 12515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<SendInitialCommitToResolversActor>::operator new;
	using FastAllocated<SendInitialCommitToResolversActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7844807525343752960UL, 17527885536728776704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendInitialCommitToResolversActor, 0, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 1, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 2, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 3, Void >;
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	SendInitialCommitToResolversActor(Reference<ClusterRecoveryData> const& self) 
															#line 12535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   SendInitialCommitToResolversActorState<SendInitialCommitToResolversActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8619307040494944512UL, 12515564514269263616UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendInitialCommitToResolvers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> sendInitialCommitToResolvers( Reference<ClusterRecoveryData> const& self ) {
															#line 1346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new SendInitialCommitToResolversActor(self));
															#line 12571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 12576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerUpdates()
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class TriggerUpdatesActor>
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TriggerUpdatesActorState {
															#line 12583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TriggerUpdatesActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem) 
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem)
															#line 12592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerUpdates", reinterpret_cast<unsigned long>(this));

	}
	~TriggerUpdatesActorState() 
	{
		fdb_probe_actor_destroy("triggerUpdates", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1425 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 12607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerUpdatesActorState();
		static_cast<TriggerUpdatesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = oldLogSystem->onLogSystemConfigChange() || self->cstate.fullyRecovered.getFuture() || self->recruitmentStalled->onChange();
															#line 1426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TriggerUpdatesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerUpdatesActor*>(this)->actor_wait_state = 1;
															#line 1426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerUpdatesActor, 0, Void >*>(static_cast<TriggerUpdatesActor*>(this)));
															#line 12644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.fullyRecovered.isSet())
															#line 12653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1429 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TriggerUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerUpdatesActorState(); static_cast<TriggerUpdatesActor*>(this)->destroy(); return 0; }
															#line 12657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TriggerUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TriggerUpdatesActorState();
			static_cast<TriggerUpdatesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 12665 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1428 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.fullyRecovered.isSet())
															#line 12674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1429 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TriggerUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerUpdatesActorState(); static_cast<TriggerUpdatesActor*>(this)->destroy(); return 0; }
															#line 12678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TriggerUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TriggerUpdatesActorState();
			static_cast<TriggerUpdatesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1431 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 12686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerUpdatesActor*>(this)->actor_wait_state > 0) static_cast<TriggerUpdatesActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerUpdatesActor*>(this)->ActorCallback< TriggerUpdatesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerUpdatesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerUpdatesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerUpdatesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 12770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via triggerUpdates()
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TriggerUpdatesActor final : public Actor<Void>, public ActorCallback< TriggerUpdatesActor, 0, Void >, public FastAllocated<TriggerUpdatesActor>, public TriggerUpdatesActorState<TriggerUpdatesActor> {
															#line 12775 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<TriggerUpdatesActor>::operator new;
	using FastAllocated<TriggerUpdatesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11720508941977490944UL, 12984747351198046720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerUpdatesActor, 0, Void >;
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TriggerUpdatesActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem) 
															#line 12792 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerUpdatesActorState<TriggerUpdatesActor>(self, oldLogSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9654815222670740224UL, 9248498678420781568UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerUpdates");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerUpdatesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> triggerUpdates( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem ) {
															#line 1424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new TriggerUpdatesActor(self, oldLogSystem));
															#line 12825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1434 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 12830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via discardCommit()
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class DiscardCommitActor>
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class DiscardCommitActorState {
															#line 12837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DiscardCommitActorState(IKeyValueStore* const& store,LogSystemDiskQueueAdapter* const& adapter) 
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : store(store),
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   adapter(adapter),
															#line 1436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fcm(adapter->getCommitMessage()),
															#line 1437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   committed(store->commit())
															#line 12850 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	~DiscardCommitActorState() 
	{
		fdb_probe_actor_destroy("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<LogSystemDiskQueueAdapter::CommitMessage> __when_expr_0 = fcm;
															#line 1438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<DiscardCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DiscardCommitActor*>(this)->actor_wait_state = 1;
															#line 1438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*>(static_cast<DiscardCommitActor*>(this)));
															#line 12872 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!committed.isReady());
															#line 1440 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cm.acknowledge.send(Void());
															#line 1441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(committed.isReady());
															#line 1442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<DiscardCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiscardCommitActorState(); static_cast<DiscardCommitActor*>(this)->destroy(); return 0; }
															#line 12901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<DiscardCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!committed.isReady());
															#line 1440 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cm.acknowledge.send(Void());
															#line 1441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(committed.isReady());
															#line 1442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<DiscardCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiscardCommitActorState(); static_cast<DiscardCommitActor*>(this)->destroy(); return 0; }
															#line 12919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<DiscardCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(cm, loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscardCommitActor*>(this)->actor_wait_state > 0) static_cast<DiscardCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DiscardCommitActor*>(this)->ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >::remove();

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage const& value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage && value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,Error err) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	IKeyValueStore* store;
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	LogSystemDiskQueueAdapter* adapter;
															#line 1436 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<LogSystemDiskQueueAdapter::CommitMessage> fcm;
															#line 1437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> committed;
															#line 13010 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via discardCommit()
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class DiscardCommitActor final : public Actor<Void>, public ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >, public FastAllocated<DiscardCommitActor>, public DiscardCommitActorState<DiscardCommitActor> {
															#line 13015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<DiscardCommitActor>::operator new;
	using FastAllocated<DiscardCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13507563709222515200UL, 17832414385598320128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >;
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DiscardCommitActor(IKeyValueStore* const& store,LogSystemDiskQueueAdapter* const& adapter) 
															#line 13032 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   DiscardCommitActorState<DiscardCommitActor>(store, adapter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7339418273539287808UL, 9304446022786112512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discardCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> discardCommit( IKeyValueStore* const& store, LogSystemDiskQueueAdapter* const& adapter ) {
															#line 1435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new DiscardCommitActor(store, adapter));
															#line 13065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

void updateConfigForForcedRecovery(Reference<ClusterRecoveryData> self,
                                   std::vector<Standalone<CommitTransactionRef>>* initialConfChanges) {
	bool regionsChanged = false;
	for (auto& it : self->configuration.regions) {
		if (it.dcId == self->controllerData->clusterControllerDcId.get() && it.priority < 0) {
			it.priority = 1;
			regionsChanged = true;
		} else if (it.dcId != self->controllerData->clusterControllerDcId.get() && it.priority >= 0) {
			it.priority = -1;
			regionsChanged = true;
		}
	}
	Standalone<CommitTransactionRef> regionCommit;
	regionCommit.mutations.push_back_deep(
	    regionCommit.arena(),
	    MutationRef(MutationRef::SetValue, configKeysPrefix.toString() + "usable_regions", "1"_sr));
	self->configuration.applyMutation(regionCommit.mutations.back());
	if (regionsChanged) {
		std::sort(
		    self->configuration.regions.begin(), self->configuration.regions.end(), RegionInfo::sort_by_priority());
		StatusObject regionJSON;
		regionJSON["regions"] = self->configuration.getRegionJSON();
		regionCommit.mutations.push_back_deep(
		    regionCommit.arena(),
		    MutationRef(MutationRef::SetValue,
		                configKeysPrefix.toString() + "regions",
		                BinaryWriter::toValue(regionJSON, IncludeVersion(ProtocolVersion::withRegionConfiguration()))
		                    .toString()));
		self->configuration.applyMutation(
		    regionCommit.mutations.back()); // modifying the configuration directly does not change the configuration
		                                    // when it is re-serialized unless we call applyMutation
		TraceEvent("ForcedRecoveryConfigChange", self->dbgid)
		    .setMaxEventLength(11000)
		    .setMaxFieldLength(10000)
		    .detail("Conf", self->configuration.toString());
	}
	initialConfChanges->push_back(regionCommit);
}

															#line 13109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recoverFrom()
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecoverFromActor>
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoverFromActorState {
															#line 13116 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoverFromActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,std::vector<StorageServerInterface>* const& seedServers,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges,Future<Version> const& poppedTxsVersion) 
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   seedServers(seedServers),
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   initialConfChanges(initialConfChanges),
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   poppedTxsVersion(poppedTxsVersion)
															#line 13131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recoverFrom", reinterpret_cast<unsigned long>(this));

	}
	~RecoverFromActorState() 
	{
		fdb_probe_actor_destroy("recoverFrom", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1489 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::reading_transaction_system_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::reading_transaction_system_state]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->hasConfiguration = false;
															#line 1495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 13150 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(10.0);
															#line 1496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecoverFromActor*>(this)->actor_wait_state = 1;
															#line 1496 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 0, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 13161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoverFromActorState();
		static_cast<RecoverFromActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Version> __when_expr_1 = poppedTxsVersion;
															#line 1498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 2;
															#line 1498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 1, Version >*>(static_cast<RecoverFromActor*>(this)));
															#line 13196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Version const& txsPoppedVersion,int loopDepth) 
	{
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readTransactionSystemState(self, oldLogSystem, txsPoppedVersion);
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13294 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 3;
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 2, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 13299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Version && txsPoppedVersion,int loopDepth) 
	{
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readTransactionSystemState(self, oldLogSystem, txsPoppedVersion);
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13310 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 3;
															#line 1499 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 2, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 13315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& txsPoppedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(txsPoppedVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && txsPoppedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(txsPoppedVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : *initialConfChanges ) {
															#line 1501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& m : itr.mutations ) {
															#line 1502 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->configuration.applyMutation(m);
															#line 13403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1506 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13408 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_checkMaxRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery");
															#line 1516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		originalLocalityMap = self->dcId_locality;
															#line 1517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 1519 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = SERVER_KNOBS->PROVISIONAL_START_DELAY;
															#line 1520 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 13424 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : *initialConfChanges ) {
															#line 1501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& m : itr.mutations ) {
															#line 1502 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->configuration.applyMutation(m);
															#line 13437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1506 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1507 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_checkMaxRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery");
															#line 1516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		originalLocalityMap = self->dcId_locality;
															#line 1517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 1519 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = SERVER_KNOBS->PROVISIONAL_START_DELAY;
															#line 1520 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 13458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoverFromActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoverFromActorState(); static_cast<RecoverFromActor*>(this)->destroy(); return 0; }
															#line 13542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoverFromActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoverFromActorState();
		static_cast<RecoverFromActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 1521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional = provisionalMaster(self, delay(provisionalDelay));
															#line 1522 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = std::min(SERVER_KNOBS->PROVISIONAL_MAX_DELAY, provisionalDelay * SERVER_KNOBS->PROVISIONAL_DELAY_GROWTH);
															#line 1525 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<Standalone<CommitTransactionRef>>> __when_expr_3 = recruitments;
															#line 1524 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 1530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Standalone<CommitTransactionRef>> __when_expr_4 = provisional;
															#line 13571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 4;
															#line 1525 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*>(static_cast<RecoverFromActor*>(this)));
															#line 1530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*>(static_cast<RecoverFromActor*>(this)));
															#line 13578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 1564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13600 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::vector<Standalone<CommitTransactionRef>> const& confChanges,int loopDepth) 
	{
															#line 1526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->insert(initialConfChanges->end(), confChanges.begin(), confChanges.end());
															#line 1527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::vector<Standalone<CommitTransactionRef>> && confChanges,int loopDepth) 
	{
															#line 1526 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->insert(initialConfChanges->end(), confChanges.begin(), confChanges.end());
															#line 1527 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Standalone<CommitTransactionRef> const& _req,int loopDepth) 
	{
															#line 1531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req = _req;
															#line 1532 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(true, "Emergency transaction processing during recovery");
															#line 1533 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("EmergencyTransaction", self->dbgid).log();
															#line 1534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(auto m = req.mutations.begin();m != req.mutations.end();++m) {
															#line 1535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmergencyTransactionMutation", self->dbgid) .detail("MType", m->type) .detail("P1", m->param1) .detail("P2", m->param2);
															#line 13639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration oldConf = self->configuration;
															#line 1541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration = self->originalConfiguration;
															#line 1542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& m : req.mutations ) {
															#line 1543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration.applyMutation(m);
															#line 13649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->clear();
															#line 1546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->originalConfiguration.isValid() && self->configuration.usableRegions != self->originalConfiguration.usableRegions)
															#line 13655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "CannotChangeUsableRegions", self->dbgid).log();
															#line 1549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = self->originalConfiguration;
															#line 13661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initialConfChanges->push_back(req);
															#line 13667 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration != oldConf)
															#line 13679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality = originalLocalityMap;
															#line 1559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 13685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Standalone<CommitTransactionRef> && _req,int loopDepth) 
	{
															#line 1531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req = _req;
															#line 1532 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(true, "Emergency transaction processing during recovery");
															#line 1533 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("EmergencyTransaction", self->dbgid).log();
															#line 1534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(auto m = req.mutations.begin();m != req.mutations.end();++m) {
															#line 1535 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmergencyTransactionMutation", self->dbgid) .detail("MType", m->type) .detail("P1", m->param1) .detail("P2", m->param2);
															#line 13703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1540 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration oldConf = self->configuration;
															#line 1541 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration = self->originalConfiguration;
															#line 1542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& m : req.mutations ) {
															#line 1543 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration.applyMutation(m);
															#line 13713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->clear();
															#line 1546 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->originalConfiguration.isValid() && self->configuration.usableRegions != self->originalConfiguration.usableRegions)
															#line 13719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "CannotChangeUsableRegions", self->dbgid).log();
															#line 1549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = self->originalConfiguration;
															#line 13725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1551 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initialConfChanges->push_back(req);
															#line 13731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1554 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1557 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration != oldConf)
															#line 13743 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality = originalLocalityMap;
															#line 1559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 13749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >::remove();
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,std::vector<Standalone<CommitTransactionRef>> const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,std::vector<Standalone<CommitTransactionRef>> && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Standalone<CommitTransactionRef> const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Standalone<CommitTransactionRef> && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* seedServers;
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>>* initialConfChanges;
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Version> poppedTxsVersion;
															#line 1516 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::map<Optional<Value>, int8_t> originalLocalityMap;
															#line 1517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<std::vector<Standalone<CommitTransactionRef>>> recruitments;
															#line 1519 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	double provisionalDelay;
															#line 1521 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Standalone<CommitTransactionRef>> provisional;
															#line 1531 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Standalone<CommitTransactionRef> req;
															#line 13896 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recoverFrom()
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoverFromActor final : public Actor<Void>, public ActorCallback< RecoverFromActor, 0, Void >, public ActorCallback< RecoverFromActor, 1, Version >, public ActorCallback< RecoverFromActor, 2, Void >, public ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >, public ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >, public FastAllocated<RecoverFromActor>, public RecoverFromActorState<RecoverFromActor> {
															#line 13901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecoverFromActor>::operator new;
	using FastAllocated<RecoverFromActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14812279173184306944UL, 7751022800733473536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoverFromActor, 0, Void >;
friend struct ActorCallback< RecoverFromActor, 1, Version >;
friend struct ActorCallback< RecoverFromActor, 2, Void >;
friend struct ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >;
friend struct ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >;
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoverFromActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,std::vector<StorageServerInterface>* const& seedServers,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges,Future<Version> const& poppedTxsVersion) 
															#line 13922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecoverFromActorState<RecoverFromActor>(self, oldLogSystem, seedServers, initialConfChanges, poppedTxsVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11048513393176218368UL, 5213727738079110912UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoverFrom");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoverFromActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecoverFromActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecoverFromActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recoverFrom( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem, std::vector<StorageServerInterface>* const& seedServers, std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges, Future<Version> const& poppedTxsVersion ) {
															#line 1484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecoverFromActor(self, oldLogSystem, seedServers, initialConfChanges, poppedTxsVersion));
															#line 13958 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1569 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 13963 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecoveryCore()
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecoveryCoreActor>
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecoveryCoreActorState {
															#line 13970 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecoveryCoreActorState(Reference<ClusterRecoveryData> const& self) 
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoveryInterval("ClusterRecovery"),
															#line 1572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoverStartTime(now())
															#line 13981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecoveryCore", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecoveryCoreActorState() 
	{
		fdb_probe_actor_destroy("clusterRecoveryCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(waitFailureServer(self->masterInterface.waitFailure.getFuture()));
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(recoveryInterval.begin(), self->dbgid).log();
															#line 1578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::READING_CSTATE;
															#line 1579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::reading_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::reading_coordinated_state]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->cstate.read();
															#line 1584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14006 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 1;
															#line 1584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 0, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecoveryCoreActorState();
		static_cast<ClusterRecoveryCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.myDBState.tLogs.empty() && self->controllerData->encryptionAtRestMode.canBeSet())
															#line 14034 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->encryptionAtRestMode.send(self->cstate.myDBState.encryptionAtRestMode);
															#line 14038 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.lowestCompatibleProtocolVersion > currentProtocolVersion())
															#line 14042 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "IncompatibleProtocolVersion", self->dbgid).log();
															#line 1594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(internal_error(), loopDepth);
															#line 14048 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::LOCKING_CSTATE;
															#line 1598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::locking_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::locking_coordinated_state]) .detail("TLogs", self->cstate.prevDBState.tLogs.size()) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .detail("MyRecoveryCount", self->cstate.prevDBState.recoveryCount + 2) .detail("ForceRecovery", self->forceRecovery) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 1615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_OVERRIDE)
															#line 14058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->cstate.myDBState.oldTLogData.size() >= CLIENT_KNOBS->MAX_GENERATIONS)
															#line 14062 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevError, "RecoveryStoppedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery stopped because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 2;
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 1, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14075 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1624 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION)
															#line 14082 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1625 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecoveryDelayedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery is delayed because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->RECOVERY_DELAY_SECONDS_PER_GENERATION * (self->cstate.myDBState.oldTLogData.size() - CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION));
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14090 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 3;
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 2, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14095 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.myDBState.tLogs.empty() && self->controllerData->encryptionAtRestMode.canBeSet())
															#line 14115 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->encryptionAtRestMode.send(self->cstate.myDBState.encryptionAtRestMode);
															#line 14119 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1592 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.lowestCompatibleProtocolVersion > currentProtocolVersion())
															#line 14123 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "IncompatibleProtocolVersion", self->dbgid).log();
															#line 1594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(internal_error(), loopDepth);
															#line 14129 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1597 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::LOCKING_CSTATE;
															#line 1598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::locking_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::locking_coordinated_state]) .detail("TLogs", self->cstate.prevDBState.tLogs.size()) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .detail("MyRecoveryCount", self->cstate.prevDBState.recoveryCount + 2) .detail("ForceRecovery", self->forceRecovery) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 1615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_OVERRIDE)
															#line 14139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1616 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->cstate.myDBState.oldTLogData.size() >= CLIENT_KNOBS->MAX_GENERATIONS)
															#line 14143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevError, "RecoveryStoppedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery stopped because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 2;
															#line 1623 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 1, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14156 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1624 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION)
															#line 14163 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1625 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecoveryDelayedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery is delayed because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->RECOVERY_DELAY_SECONDS_PER_GENERATION * (self->cstate.myDBState.oldTLogData.size() - CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION));
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14171 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 3;
															#line 1631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 2, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		oldLogSystems = Reference<AsyncVar<Reference<ILogSystem>>>(new AsyncVar<Reference<ILogSystem>>);
															#line 1640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoverAndEndEpoch = ILogSystem::recoverAndEndEpoch(oldLogSystems, self->dbgid, self->cstate.prevDBState, self->clusterController.tlogRejoin.getFuture(), self->controllerData->db.serverInfo->get().myLocality, std::addressof(self->forceRecovery));
															#line 1648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DBCoreState newState = self->cstate.myDBState;
															#line 1649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.recoveryCount++;
															#line 1650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.newestProtocolVersion.isInvalid() || self->cstate.prevDBState.newestProtocolVersion < currentProtocolVersion())
															#line 14279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->cstate.myDBState.lowestCompatibleProtocolVersion.isInvalid() || !self->cstate.myDBState.newestProtocolVersion.isInvalid());
															#line 1654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			newState.newestProtocolVersion = currentProtocolVersion();
															#line 1655 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			newState.lowestCompatibleProtocolVersion = minCompatibleProtocolVersion;
															#line 14287 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->cstate.write(newState) || recoverAndEndEpoch;
															#line 1657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14293 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 4;
															#line 1657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 3, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_SIM)
															#line 14307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1635 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			disableConnectionFailures("TooManyGenerations");
															#line 14311 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 1659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ProtocolVersionCompatibilityChecked", self->dbgid) .detail("NewestProtocolVersion", self->cstate.myDBState.newestProtocolVersion) .detail("LowestCompatibleProtocolVersion", self->cstate.myDBState.lowestCompatibleProtocolVersion) .trackLatest(self->swVersionCheckedEventHolder->trackingKey);
															#line 1664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECRUITING;
															#line 1666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		seedServers = std::vector<StorageServerInterface>();
															#line 1667 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logChanges = Future<Void>();
															#line 1669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		minRecoveryDuration = Future<Void>();
															#line 1670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		poppedTxsVersion = Future<Version>();
															#line 1672 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 14515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 1659 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ProtocolVersionCompatibilityChecked", self->dbgid) .detail("NewestProtocolVersion", self->cstate.myDBState.newestProtocolVersion) .detail("LowestCompatibleProtocolVersion", self->cstate.myDBState.lowestCompatibleProtocolVersion) .trackLatest(self->swVersionCheckedEventHolder->trackingKey);
															#line 1664 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECRUITING;
															#line 1666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		seedServers = std::vector<StorageServerInterface>();
															#line 1667 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logChanges = Future<Void>();
															#line 1669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		minRecoveryDuration = Future<Void>();
															#line 1670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		poppedTxsVersion = Future<Version>();
															#line 1672 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 14538 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 1702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->neverCreated)
															#line 14622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recoverStartTime = now();
															#line 14626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoverAndEndEpoch.cancel();
															#line 1708 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->commitProxies.size(), self->configuration.getDesiredCommitProxies());
															#line 1709 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->commitProxies.size(), 1);
															#line 1710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->grvProxies.size(), self->configuration.getDesiredGrvProxies());
															#line 1711 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->grvProxies.size(), 1);
															#line 1712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->resolvers.size(), self->configuration.getDesiredResolvers());
															#line 1713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->resolvers.size(), 1);
															#line 1715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECOVERY_TRANSACTION;
															#line 1716 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("PrimaryLocality", self->primaryLocality) .detail("DcId", self->masterInterface.locality.dcId()) .detail("LastEpochEnd", self->lastEpochEnd) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debugResult = debug_checkMinRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery", SevWarn);
															#line 1727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CommitTransactionRequest recoveryCommitRequest;
															#line 1728 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoveryCommitRequest.flags = recoveryCommitRequest.flags | CommitTransactionRequest::FLAG_IS_LOCK_AWARE;
															#line 1729 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CommitTransactionRef& tr = recoveryCommitRequest.transaction;
															#line 1730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		int mmApplied = 0;
															#line 1731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd != 0)
															#line 14658 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1732 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Optional<Value> snapRecoveryFlag = self->txnStateStore->readValue(writeRecoveryKey).get();
															#line 1733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_SNAPSHOT_CHECK_EVENT_NAME).c_str()) .detail("SnapRecoveryFlag", snapRecoveryFlag.present() ? snapRecoveryFlag.get().toString() : "N/A") .detail("LastEpochEnd", self->lastEpochEnd);
															#line 1736 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (snapRecoveryFlag.present())
															#line 14666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1737 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "Recovering from snapshot, writing to snapShotEndVersionKey");
															#line 1738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				BinaryWriter bw(Unversioned());
															#line 1739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, snapshotEndVersionKey, (bw << self->lastEpochEnd).toValue());
															#line 1742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_PAUSE_AGENT_BACKUP_EVENT_NAME).c_str()) .log();
															#line 1745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key backupPauseKey = FileBackupAgent::getPauseKey();
															#line 1746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, backupPauseKey, StringRef());
															#line 1748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.clear(recoveryCommitRequest.arena, singleKeyRange(writeRecoveryKey));
															#line 14682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1750 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 14686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				BinaryWriter bw(Unversioned());
															#line 1752 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, killStorageKey, (bw << self->safeLocality).toValue());
															#line 14692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1762 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			BinaryWriter bw(Unversioned());
															#line 1763 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, lastEpochEndKey, (bw << self->lastEpochEnd).toValue());
															#line 1765 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 14700 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, rebootWhenDurableKey, StringRef());
															#line 1767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, moveKeysLockOwnerKey, BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned()));
															#line 14706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1774 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			seedShardServers(recoveryCommitRequest.arena, tr, seedServers);
															#line 14713 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : initialConfChanges ) {
															#line 1780 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.mutations.append_deep(recoveryCommitRequest.arena, itr.mutations.begin(), itr.mutations.size());
															#line 1781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.write_conflict_ranges.append_deep( recoveryCommitRequest.arena, itr.write_conflict_ranges.begin(), itr.write_conflict_ranges.size());
															#line 14721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set( recoveryCommitRequest.arena, primaryLocalityKey, BinaryWriter::toValue(self->primaryLocality, Unversioned()));
															#line 1787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, backupVersionKey, backupVersionValue);
															#line 1788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> txnStateStoreCoords = self->txnStateStore->readValue(coordinatorsKey).get();
															#line 1789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (txnStateStoreCoords.present() && txnStateStoreCoords.get() != self->coordinators.ccr->getConnectionString().toString())
															#line 14731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1791 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, previousCoordinatorsKey, txnStateStoreCoords.get());
															#line 14735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1793 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, coordinatorsKey, self->coordinators.ccr->getConnectionString().toString());
															#line 1794 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, logsKey, self->logSystem->getLogsValue());
															#line 1795 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, primaryDatacenterKey, self->controllerData->clusterControllerDcId.present() ? self->controllerData->clusterControllerDcId.get() : StringRef());
															#line 1800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.clear(recoveryCommitRequest.arena, tLogDatacentersKeys);
															#line 1801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& dc : self->primaryDcId ) {
															#line 1802 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, tLogDatacentersKeyFor(dc), StringRef());
															#line 14749 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1804 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.usableRegions > 1)
															#line 14753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& dc : self->remoteDcIds ) {
															#line 1806 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, tLogDatacentersKeyFor(dc), StringRef());
															#line 14759 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		applyMetadataMutations(SpanContext(), self->dbgid, recoveryCommitRequest.arena, tr.mutations.slice(mmApplied, tr.mutations.size()), self->txnStateStore);
															#line 1815 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		mmApplied = tr.mutations.size();
															#line 1817 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.read_snapshot = self->recoveryTransactionVersion;
															#line 1820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid);
															#line 1822 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoveryCommit = self->commitProxies[0].commit.tryGetReply(recoveryCommitRequest);
															#line 1823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(self->logSystem->onError());
															#line 1824 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitResolverFailure(self->resolvers));
															#line 1825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitCommitProxyFailure(self->commitProxies));
															#line 1826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitGrvProxyFailure(self->grvProxies));
															#line 1827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(reportErrors(updateRegistration(self, self->logSystem), "UpdateRegistration", self->dbgid));
															#line 1828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 1830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_8 = traceAfter(discardCommit(self->txnStateStore, self->txnStateLogAdapter), "DiscardCommitFinished");
															#line 1830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 6;
															#line 1830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 8, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14793 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1(int loopDepth) 
	{
															#line 1673 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Reference<ILogSystem> oldLogSystem = oldLogSystems->get();
															#line 1674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (oldLogSystem)
															#line 14811 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logChanges = triggerUpdates(self, oldLogSystem);
															#line 1676 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!minRecoveryDuration.isValid())
															#line 14817 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1677 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minRecoveryDuration = delay(SERVER_KNOBS->ENFORCED_MIN_RECOVERY_DURATION);
															#line 1678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				poppedTxsVersion = oldLogSystem->getTxsPoppedVersion();
															#line 14823 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg = oldLogSystem ? updateRegistration(self, oldLogSystem) : Never();
															#line 1683 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 1686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = oldLogSystem ? recoverFrom(self, oldLogSystem, &seedServers, &initialConfChanges, poppedTxsVersion) : Never();
															#line 1685 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when1(__when_expr_4.get(), loopDepth); };
															#line 1692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = oldLogSystems->onChange();
															#line 14838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2(__when_expr_5.get(), loopDepth); };
															#line 1693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_6 = reg;
															#line 14842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when3(__when_expr_6.get(), loopDepth); };
															#line 1696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_7 = recoverAndEndEpoch;
															#line 14846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when4(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 5;
															#line 1686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 4, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1692 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 5, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1693 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 6, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 7, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14857 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg.cancel();
															#line 14885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg.cancel();
															#line 14894 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 1697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14931 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(Void && _,int loopDepth) 
	{
															#line 1697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14939 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 4, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 5, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 6, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_9 = traceAfter(success(recoveryCommit), "RecoveryCommitFinished") && traceAfter(sendInitialCommitToResolvers(self), "InitialCommitToResolversFinished");
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 7;
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 9, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_9 = traceAfter(success(recoveryCommit), "RecoveryCommitFinished") && traceAfter(sendInitialCommitToResolvers(self), "InitialCommitToResolversFinished");
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 7;
															#line 1835 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 9, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15207 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont14(Void const& _,int loopDepth) 
	{
															#line 1837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recoveryCommit.isReady() && recoveryCommit.get().isError())
															#line 15291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .errorUnsuppressed(recoveryCommit.get().getError());
															#line 1841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Cluster recovery failed because of the initial commit failed");
															#line 1842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 15299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(self->recoveryTransactionVersion != 0);
															#line 1847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::WRITING_CSTATE;
															#line 1848 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::writing_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::writing_coordinated_state]) .detail("TLogList", self->logSystem->describe()) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(trackTlogRecovery(self, oldLogSystems, minRecoveryDuration));
															#line 1866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMaxCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->cstateUpdated.getFuture();
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont14when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 8;
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 10, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14(Void && _,int loopDepth) 
	{
															#line 1837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recoveryCommit.isReady() && recoveryCommit.get().isError())
															#line 15329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .errorUnsuppressed(recoveryCommit.get().getError());
															#line 1841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Cluster recovery failed because of the initial commit failed");
															#line 1842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 15337 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(self->recoveryTransactionVersion != 0);
															#line 1847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::WRITING_CSTATE;
															#line 1848 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::writing_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::writing_coordinated_state]) .detail("TLogList", self->logSystem->describe()) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(trackTlogRecovery(self, oldLogSystems, minRecoveryDuration));
															#line 1866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMaxCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->cstateUpdated.getFuture();
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15353 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont14when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 8;
															#line 1867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 10, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15358 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont14cont1(Void const& _,int loopDepth) 
	{
															#line 1868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMinCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (debugResult)
															#line 15444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(self->forceRecovery ? SevWarn : SevError, "DBRecoveryDurabilityError").log();
															#line 15448 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .detail("TLogs", self->logSystem->describe()) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(recoveryInterval.end(), self->dbgid) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::ACCEPTING_COMMITS;
															#line 1883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		double recoveryDuration = now() - recoverStartTime;
															#line 1885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent((recoveryDuration > 4 && !g_network->isSimulated()) ? SevWarnAlways : SevInfo, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME).c_str(), self->dbgid) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryDurationEventHolder->trackingKey);
															#line 1891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::accepting_commits) .detail("Status", RecoveryStatus::names[RecoveryStatus::accepting_commits]) .detail("StoreType", self->configuration.storageServerStoreType) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME).c_str(), self->dbgid) .detail("NumOfOldGensOfLogs", self->cstate.myDBState.oldTLogData.size()) .detail("AvailableAtVersion", self->recoveryTransactionVersion) .trackLatest(self->clusterRecoveryAvailableEventHolder->trackingKey);
															#line 1904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(changeCoordinators(self));
															#line 1905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Database cx = openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 1906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(configurationMonitor(self, cx));
															#line 1907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.backupWorkerEnabled)
															#line 15472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(recruitBackupWorkers(self, cx));
															#line 15476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->logSystem->setOldestBackupEpoch(self->cstate.myDBState.recoveryCount);
															#line 15482 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_11 = Future<Void>(Never());
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont14cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 9;
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 11, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14cont1(Void && _,int loopDepth) 
	{
															#line 1868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMinCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (debugResult)
															#line 15504 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(self->forceRecovery ? SevWarn : SevError, "DBRecoveryDurabilityError").log();
															#line 15508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .detail("TLogs", self->logSystem->describe()) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(recoveryInterval.end(), self->dbgid) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1882 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::ACCEPTING_COMMITS;
															#line 1883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		double recoveryDuration = now() - recoverStartTime;
															#line 1885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent((recoveryDuration > 4 && !g_network->isSimulated()) ? SevWarnAlways : SevInfo, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME).c_str(), self->dbgid) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryDurationEventHolder->trackingKey);
															#line 1891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::accepting_commits) .detail("Status", RecoveryStatus::names[RecoveryStatus::accepting_commits]) .detail("StoreType", self->configuration.storageServerStoreType) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME).c_str(), self->dbgid) .detail("NumOfOldGensOfLogs", self->cstate.myDBState.oldTLogData.size()) .detail("AvailableAtVersion", self->recoveryTransactionVersion) .trackLatest(self->clusterRecoveryAvailableEventHolder->trackingKey);
															#line 1904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(changeCoordinators(self));
															#line 1905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Database cx = openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 1906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(configurationMonitor(self, cx));
															#line 1907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.backupWorkerEnabled)
															#line 15532 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(recruitBackupWorkers(self, cx));
															#line 15536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->logSystem->setOldestBackupEpoch(self->cstate.myDBState.recoveryCount);
															#line 15542 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_11 = Future<Void>(Never());
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont14cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 9;
															#line 1913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 11, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15553 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont14cont3(Void const& _,int loopDepth) 
	{
															#line 1914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15637 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11cont14cont3(Void && _,int loopDepth) 
	{
															#line 1914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1571 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TraceInterval recoveryInterval;
															#line 1572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	double recoverStartTime;
															#line 1639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<Reference<ILogSystem>>> oldLogSystems;
															#line 1640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> recoverAndEndEpoch;
															#line 1666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface> seedServers;
															#line 1667 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>> initialConfChanges;
															#line 1668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> logChanges;
															#line 1669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> minRecoveryDuration;
															#line 1670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Version> poppedTxsVersion;
															#line 1682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> reg;
															#line 1725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool debugResult;
															#line 1822 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<ErrorOr<CommitID>> recoveryCommit;
															#line 15750 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecoveryCore()
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecoveryCoreActor final : public Actor<Void>, public ActorCallback< ClusterRecoveryCoreActor, 0, Void >, public ActorCallback< ClusterRecoveryCoreActor, 1, Void >, public ActorCallback< ClusterRecoveryCoreActor, 2, Void >, public ActorCallback< ClusterRecoveryCoreActor, 3, Void >, public ActorCallback< ClusterRecoveryCoreActor, 4, Void >, public ActorCallback< ClusterRecoveryCoreActor, 5, Void >, public ActorCallback< ClusterRecoveryCoreActor, 6, Void >, public ActorCallback< ClusterRecoveryCoreActor, 7, Void >, public ActorCallback< ClusterRecoveryCoreActor, 8, Void >, public ActorCallback< ClusterRecoveryCoreActor, 9, Void >, public ActorCallback< ClusterRecoveryCoreActor, 10, Void >, public ActorCallback< ClusterRecoveryCoreActor, 11, Void >, public FastAllocated<ClusterRecoveryCoreActor>, public ClusterRecoveryCoreActorState<ClusterRecoveryCoreActor> {
															#line 15755 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecoveryCoreActor>::operator new;
	using FastAllocated<ClusterRecoveryCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17116519657718775040UL, 1352229142427465728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecoveryCoreActor, 0, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 1, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 2, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 3, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 4, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 5, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 6, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 7, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 8, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 9, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 10, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 11, Void >;
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecoveryCoreActor(Reference<ClusterRecoveryData> const& self) 
															#line 15783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterRecoveryCoreActorState<ClusterRecoveryCoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6439010016757150976UL, 1216318683808140800UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecoveryCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 8, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 9, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 10, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> clusterRecoveryCore( Reference<ClusterRecoveryData> const& self ) {
															#line 1570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ClusterRecoveryCoreActor(self));
															#line 15824 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 15829 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupRecoveryActorCollection()
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class CleanupRecoveryActorCollectionActor>
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class CleanupRecoveryActorCollectionActorState {
															#line 15836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	CleanupRecoveryActorCollectionActorState(Reference<ClusterRecoveryData> const& self,bool const& exThrown) 
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   exThrown(exThrown)
															#line 15845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this));

	}
	~CleanupRecoveryActorCollectionActorState() 
	{
		fdb_probe_actor_destroy("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1918 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self.isValid())
															#line 15860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 1919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state = 1;
															#line 1919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*>(static_cast<CleanupRecoveryActorCollectionActor*>(this)));
															#line 15871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupRecoveryActorCollectionActorState();
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1926 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<CleanupRecoveryActorCollectionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupRecoveryActorCollectionActorState(); static_cast<CleanupRecoveryActorCollectionActor*>(this)->destroy(); return 0; }
															#line 15899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<CleanupRecoveryActorCollectionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupRecoveryActorCollectionActorState();
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;!self->addActor.isEmpty();) {
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.getFuture().pop();
															#line 15913 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;!self->addActor.isEmpty();) {
															#line 1922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.getFuture().pop();
															#line 15925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state > 0) static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool exThrown;
															#line 16010 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via cleanupRecoveryActorCollection()
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class CleanupRecoveryActorCollectionActor final : public Actor<Void>, public ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >, public FastAllocated<CleanupRecoveryActorCollectionActor>, public CleanupRecoveryActorCollectionActorState<CleanupRecoveryActorCollectionActor> {
															#line 16015 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<CleanupRecoveryActorCollectionActor>::operator new;
	using FastAllocated<CleanupRecoveryActorCollectionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2960680565975133696UL, 5037408503538366976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >;
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	CleanupRecoveryActorCollectionActor(Reference<ClusterRecoveryData> const& self,bool const& exThrown) 
															#line 16032 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupRecoveryActorCollectionActorState<CleanupRecoveryActorCollectionActor>(self, exThrown),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17904544212101105152UL, 12520490447510957056UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupRecoveryActorCollection");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> cleanupRecoveryActorCollection( Reference<ClusterRecoveryData> const& self, bool const& exThrown ) {
															#line 1917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new CleanupRecoveryActorCollectionActor(self, exThrown));
															#line 16065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1928 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

bool isNormalClusterRecoveryError(const Error& error) {
	return normalClusterRecoveryErrors().contains(error.code());
}

std::string& getRecoveryEventName(ClusterRecoveryEventType type) {
	ASSERT(type >= ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME &&
	       type < ClusterRecoveryEventType::CLUSTER_RECOVERY_LAST);

	// Cluster recovery state machine used to be driven from master/sequencer process, recovery state
	// tracking is used by test environment and tooling scripts. To ease the process of migration, prefix
	// is controlled by a ServerKnob for now.
	//
	// TODO: ServerKnob should be removed ones all tooling scripts and usage is identified and updated accordingly

	static std::map<ClusterRecoveryEventType, std::string> recoveryEventNameMap;
	if (recoveryEventNameMap.empty()) {
		// initialize the map
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryState" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_TLOG_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryCommittedTLogs" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryDuration" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryGenerations" });
		recoveryEventNameMap.insert(
		    { ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME,
		      SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryRecruitingInitialStorageServer" });
		recoveryEventNameMap.insert(
		    { ClusterRecoveryEventType::CLUSTER_RECOVERY_INVALID_CONFIG_EVENT_NAME,
		      SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryInvalidConfiguration" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "Recovering" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveredConfig" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_SNAPSHOT_CHECK_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoverySnapshotCheck" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoverySnapshotCheck" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_PAUSE_AGENT_BACKUP_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryPauseBackupAgents" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryCommit" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryAvailable" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_METRICS_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryMetrics" });
	}

	auto iter = recoveryEventNameMap.find(type);
	ASSERT(iter != recoveryEventNameMap.end());
	return iter->second;
}
