#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
/*
 * TenantCommands.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "metacluster/Metacluster.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

const KeyRangeRef tenantMapSpecialKeyRange("\xff\xff/management/tenant/map/"_sr, "\xff\xff/management/tenant/map0"_sr);
const KeyRangeRef tenantConfigSpecialKeyRange("\xff\xff/management/tenant/configure/"_sr,
                                              "\xff\xff/management/tenant/configure0"_sr);
const KeyRangeRef tenantRenameSpecialKeyRange("\xff\xff/management/tenant/rename/"_sr,
                                              "\xff\xff/management/tenant/rename0"_sr);

Optional<std::map<Standalone<StringRef>, Optional<Value>>>
parseTenantConfiguration(std::vector<StringRef> const& tokens, int startIndex, int endIndex, bool allowUnset) {
	std::map<Standalone<StringRef>, Optional<Value>> configParams;
	for (int tokenNum = startIndex; tokenNum < endIndex; ++tokenNum) {
		Optional<Value> value;

		StringRef token = tokens[tokenNum];
		StringRef param;
		if (allowUnset && token == "unset"_sr) {
			if (++tokenNum == tokens.size()) {
				fmt::print(stderr, "ERROR: `unset' specified without a configuration parameter.\n");
				return {};
			}
			param = tokens[tokenNum];
		} else {
			bool foundEquals = false;
			param = token.eat("=", &foundEquals);
			if (!foundEquals) {
				fmt::print(stderr,
				           "ERROR: invalid configuration string `{}'. String must specify a value using `='.\n",
				           param.toString().c_str());
				return {};
			}
			value = token;
		}

		if (configParams.count(param)) {
			fmt::print(
			    stderr, "ERROR: configuration parameter `{}' specified more than once.\n", param.toString().c_str());
			return {};
		}

		if (tokencmp(param, "tenant_group")) {
			configParams[param] = value;
		} else if (tokencmp(param, "assigned_cluster")) {
			configParams[param] = value;
		} else if (tokencmp(param, "tenant_state")) {
			if (!value.present() ||
			    value.compare(metacluster::tenantStateToString(metacluster::TenantState::READY)) != 0) {
				fmt::print(stderr,
				           "ERROR: only support setting tenant state back to `ready', but `{}' given.\n",
				           value.present() ? value.get().toString().c_str() : "null");
				return {};
			}
			configParams[param] = value;
		} else {
			fmt::print(stderr, "ERROR: unrecognized configuration parameter `{}'.\n", param.toString().c_str());
			return {};
		}
	}

	return configParams;
}

bool parseTenantListOptions(std::vector<StringRef> const& tokens,
                            int startIndex,
                            int& limit,
                            int& offset,
                            std::vector<metacluster::TenantState>& filters,
                            Optional<TenantGroupName>& tenantGroup,
                            bool& useJson) {
	for (int tokenNum = startIndex; tokenNum < tokens.size(); ++tokenNum) {
		Optional<Value> value;
		StringRef token = tokens[tokenNum];
		StringRef param;
		bool foundEquals;
		param = token.eat("=", &foundEquals);
		if (!foundEquals && !tokencmp(param, "JSON")) {
			fmt::print(stderr,
			           "ERROR: invalid option string `{}'. String must specify a value using `=' or be `JSON'.\n",
			           param.toString().c_str());
			return false;
		}
		value = token;
		if (tokencmp(param, "limit")) {
			int n = 0;
			if (sscanf(value.get().toString().c_str(), "%d%n", &limit, &n) != 1 || n != value.get().size() ||
			    limit <= 0) {
				fmt::print(stderr, "ERROR: invalid limit `{}'\n", token.toString().c_str());
				return false;
			}
		} else if (tokencmp(param, "offset")) {
			int n = 0;
			if (sscanf(value.get().toString().c_str(), "%d%n", &offset, &n) != 1 || n != value.get().size() ||
			    offset < 0) {
				fmt::print(stderr, "ERROR: invalid offset `{}'\n", token.toString().c_str());
				return false;
			}
		} else if (tokencmp(param, "state")) {
			auto filterStrings = value.get().splitAny(","_sr);
			try {
				for (auto sref : filterStrings) {
					filters.push_back(metacluster::stringToTenantState(sref.toString()));
				}
			} catch (Error& e) {
				fmt::print(stderr, "ERROR: unrecognized tenant state(s) `{}'.\n", value.get().toString());
				return false;
			}
		} else if (tokencmp(param, "tenant_group")) {
			tenantGroup = TenantGroupName(value.get().toString());
		} else if (tokencmp(param, "JSON")) {
			useJson = true;
		} else {
			fmt::print(stderr, "ERROR: unrecognized parameter `{}'.\n", param.toString().c_str());
			return false;
		}
	}
	return true;
}

Key makeConfigKey(TenantNameRef tenantName, StringRef configName) {
	return tenantConfigSpecialKeyRange.begin.withSuffix(Tuple().append(tenantName).append(configName).pack());
}

void applyConfigurationToSpecialKeys(Reference<ITransaction> tr,
                                     TenantNameRef tenantName,
                                     std::map<Standalone<StringRef>, Optional<Value>> configuration) {
	for (auto [configName, value] : configuration) {
		if (configName == "assigned_cluster"_sr) {
			fmt::print(stderr, "ERROR: assigned_cluster is only valid in metacluster configuration.\n");
			throw invalid_tenant_configuration();
		}
		if (value.present()) {
			tr->set(makeConfigKey(tenantName, configName), value.get());
		} else {
			tr->clear(makeConfigKey(tenantName, configName));
		}
	}
}

// tenant create command
															#line 180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantCreateCommand()
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantCreateCommandActor>
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantCreateCommandActorState {
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantCreateCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantCreateCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantCreateCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantCreateCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() < 3 || tokens.size() > 6)
															#line 210 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 180 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant create <NAME> [tenant_group=<TENANT_GROUP>] [assigned_cluster=<CLUSTER_NAME>] " "[ignore_capacity_limit]\n\n");
															#line 182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Creates a new tenant in the cluster with the specified name.\n");
															#line 183 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("An optional group can be specified that will require this tenant\n");
															#line 184 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("to be placed on the same cluster as other tenants in the same group.\n");
															#line 185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("An optional cluster name can be specified that this tenant will be placed in.\n");
															#line 186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Optionally, `ignore_capacity_limit' can be specified together with `assigned_cluster' to allow " "creation of a new tenant group on a cluster with no tenant group capacity remaining.\n");
															#line 188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantCreateCommandActorState();
				static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantNameKey = tenantMapSpecialKeyRange.begin.withSuffix(tokens[2]);
															#line 192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			doneExistenceCheck = false;
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			ignoreCapacityLimit = tokens.back() == "ignore_capacity_limit";
															#line 196 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int configurationEndIndex = tokens.size() - (ignoreCapacityLimit ? 1 : 0);
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			configuration = parseTenantConfiguration(tokens, 3, configurationEndIndex, false);
															#line 201 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!configuration.present())
															#line 246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 202 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 250 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantCreateCommandActorState();
				static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 203 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (ignoreCapacityLimit && !configuration.get().contains("assigned_cluster"_sr))
															#line 260 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print(stderr, "ERROR: `ignore_capacity_limit' can only be used if `assigned_cluster' is set.\n");
															#line 205 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantCreateCommandActorState();
					static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 208 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantCreateCommandActorState();
		static_cast<TenantCreateCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print("The tenant `{}' has been created\n", printable(tokens[2]).c_str());
															#line 257 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantCreateCommandActorState();
		static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 210 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 211 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 1;
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 0, ClusterType >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			err = Error(e);
															#line 247 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 368 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_4 = getSpecialKeysFailureErrorMessage(tr);
															#line 248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 5;
															#line 248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 4, std::string >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 213 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 214 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			metacluster::MetaclusterTenantMapEntry tenantEntry;
															#line 215 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			metacluster::AssignClusterAutomatically assignClusterAutomatically = metacluster::AssignClusterAutomatically::True;
															#line 217 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			for( auto const& [name, value] : configuration.get() ) {
															#line 218 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (name == "assigned_cluster"_sr)
															#line 409 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 219 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					assignClusterAutomatically = metacluster::AssignClusterAutomatically::False;
															#line 413 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
															#line 221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				tenantEntry.configure(name, value);
															#line 417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 223 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantEntry.tenantName = tokens[2];
															#line 224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::createTenant(db, tenantEntry, assignClusterAutomatically, metacluster::IgnoreCapacityLimit(ignoreCapacityLimit));
															#line 224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 425 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 2;
															#line 224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 1, Void >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 430 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 229 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!doneExistenceCheck)
															#line 437 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				existingTenantFuture = tr->get(tenantNameKey);
															#line 232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(existingTenantFuture);
															#line 232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 239 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tr->set(tenantNameKey, ValueRef());
															#line 240 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		applyConfigurationToSpecialKeys(tr, tokens[2], configuration.get());
															#line 241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->commit());
															#line 241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 4;
															#line 241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 3, Void >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Optional<Value> const& existingTenant,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (existingTenant.present())
															#line 657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		doneExistenceCheck = true;
															#line 665 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Optional<Value> && existingTenant,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (existingTenant.present())
															#line 674 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 234 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		doneExistenceCheck = true;
															#line 682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> const& existingTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(existingTenant, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> && existingTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(existingTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_5 = safeThreadFutureToFuture(tr->onError(err));
															#line 252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 6;
															#line 252 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantCreateCommandActor, 5, Void >*>(static_cast<TenantCreateCommandActor*>(this)));
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 250 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantCreateCommandActorState();
		static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 250 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantCreateCommandActorState(); static_cast<TenantCreateCommandActor*>(this)->destroy(); return 0; }
															#line 885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantCreateCommandActorState();
		static_cast<TenantCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreateCommandActor*>(this)->ActorCallback< TenantCreateCommandActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantCreateCommandActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantCreateCommandActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 191 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantNameKey;
															#line 192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool doneExistenceCheck;
															#line 195 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool ignoreCapacityLimit;
															#line 198 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Optional<std::map<Standalone<StringRef>, Optional<Value>>> configuration;
															#line 212 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 231 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> existingTenantFuture;
															#line 246 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Error err;
															#line 1075 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantCreateCommand()
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantCreateCommandActor final : public Actor<bool>, public ActorCallback< TenantCreateCommandActor, 0, ClusterType >, public ActorCallback< TenantCreateCommandActor, 1, Void >, public ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >, public ActorCallback< TenantCreateCommandActor, 3, Void >, public ActorCallback< TenantCreateCommandActor, 4, std::string >, public ActorCallback< TenantCreateCommandActor, 5, Void >, public FastAllocated<TenantCreateCommandActor>, public TenantCreateCommandActorState<TenantCreateCommandActor> {
															#line 1080 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantCreateCommandActor>::operator new;
	using FastAllocated<TenantCreateCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(340898053032966912UL, 15986187046991843840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantCreateCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantCreateCommandActor, 1, Void >;
friend struct ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >;
friend struct ActorCallback< TenantCreateCommandActor, 3, Void >;
friend struct ActorCallback< TenantCreateCommandActor, 4, std::string >;
friend struct ActorCallback< TenantCreateCommandActor, 5, Void >;
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantCreateCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantCreateCommandActorState<TenantCreateCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantCreateCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(735583285635983616UL, 335341177867802624UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantCreateCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantCreateCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 4, std::string >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantCreateCommandActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantCreateCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 178 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantCreateCommandActor(db, tokens));
															#line 1139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 259 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// tenant delete command
															#line 1145 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantDeleteCommand()
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantDeleteCommandActor>
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantDeleteCommandActorState {
															#line 1151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantDeleteCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 1160 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantDeleteCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantDeleteCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantDeleteCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 262 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() != 3)
															#line 1175 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 263 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant delete <NAME>\n\n");
															#line 264 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Deletes a tenant from the cluster by name.\n");
															#line 265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Deletion will be allowed only if the specified tenant contains no data.\n");
															#line 266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantDeleteCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteCommandActorState(); static_cast<TenantDeleteCommandActor*>(this)->destroy(); return 0; }
															#line 1185 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantDeleteCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantDeleteCommandActorState();
				static_cast<TenantDeleteCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantNameKey = tenantMapSpecialKeyRange.begin.withSuffix(tokens[2]);
															#line 270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			doneExistenceCheck = false;
															#line 273 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 1199 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantDeleteCommandActorState();
		static_cast<TenantDeleteCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 307 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print("The tenant `{}' has been deleted\n", printable(tokens[2]).c_str());
															#line 308 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantDeleteCommandActorState(); static_cast<TenantDeleteCommandActor*>(this)->destroy(); return 0; }
															#line 1224 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantDeleteCommandActorState();
		static_cast<TenantDeleteCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 275 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 276 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1250 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 0, ClusterType >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1255 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			err = Error(e);
															#line 298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 1292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_4 = getSpecialKeysFailureErrorMessage(tr);
															#line 299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1298 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 5;
															#line 299 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 4, std::string >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 278 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 1323 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::deleteTenant(db, tokens[2]);
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 2;
															#line 279 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 1, Void >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1334 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 281 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!doneExistenceCheck)
															#line 1341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				existingTenantFuture = tr->get(tenantNameKey);
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(existingTenantFuture);
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1349 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 3;
															#line 284 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1354 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 1369 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tr->clear(tenantNameKey);
															#line 292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->commit());
															#line 292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 4;
															#line 292 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 3, Void >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1550 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Value> const& existingTenant,int loopDepth) 
	{
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!existingTenant.present())
															#line 1559 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 1563 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		doneExistenceCheck = true;
															#line 1567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Value> && existingTenant,int loopDepth) 
	{
															#line 285 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!existingTenant.present())
															#line 1576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 286 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 1580 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		doneExistenceCheck = true;
															#line 1584 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> const& existingTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(existingTenant, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> && existingTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(existingTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_5 = safeThreadFutureToFuture(tr->onError(err));
															#line 303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1757 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 6;
															#line 303 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteCommandActor, 5, Void >*>(static_cast<TenantDeleteCommandActor*>(this)));
															#line 1762 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteCommandActorState(); static_cast<TenantDeleteCommandActor*>(this)->destroy(); return 0; }
															#line 1773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantDeleteCommandActorState();
		static_cast<TenantDeleteCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 300 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 301 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteCommandActorState(); static_cast<TenantDeleteCommandActor*>(this)->destroy(); return 0; }
															#line 1787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantDeleteCommandActorState();
		static_cast<TenantDeleteCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteCommandActor*>(this)->ActorCallback< TenantDeleteCommandActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantDeleteCommandActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantDeleteCommandActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 269 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantNameKey;
															#line 270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 271 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool doneExistenceCheck;
															#line 277 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> existingTenantFuture;
															#line 297 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Error err;
															#line 1973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantDeleteCommand()
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantDeleteCommandActor final : public Actor<bool>, public ActorCallback< TenantDeleteCommandActor, 0, ClusterType >, public ActorCallback< TenantDeleteCommandActor, 1, Void >, public ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >, public ActorCallback< TenantDeleteCommandActor, 3, Void >, public ActorCallback< TenantDeleteCommandActor, 4, std::string >, public ActorCallback< TenantDeleteCommandActor, 5, Void >, public FastAllocated<TenantDeleteCommandActor>, public TenantDeleteCommandActorState<TenantDeleteCommandActor> {
															#line 1978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantDeleteCommandActor>::operator new;
	using FastAllocated<TenantDeleteCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3178923508179200256UL, 12775890511945520896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantDeleteCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantDeleteCommandActor, 1, Void >;
friend struct ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >;
friend struct ActorCallback< TenantDeleteCommandActor, 3, Void >;
friend struct ActorCallback< TenantDeleteCommandActor, 4, std::string >;
friend struct ActorCallback< TenantDeleteCommandActor, 5, Void >;
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantDeleteCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2000 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantDeleteCommandActorState<TenantDeleteCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2687736233026979584UL, 15895218362080447744UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantDeleteCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantDeleteCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 4, std::string >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantDeleteCommandActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantDeleteCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 261 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantDeleteCommandActor(db, tokens));
															#line 2037 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 310 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// tenant deleteID command
															#line 2043 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantDeleteIdCommand()
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantDeleteIdCommandActor>
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantDeleteIdCommandActorState {
															#line 2049 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantDeleteIdCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 2058 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantDeleteIdCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() != 3)
															#line 2073 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 314 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant deleteId <ID>\n\n");
															#line 315 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Deletes a tenant from the cluster by ID.\n");
															#line 316 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Deletion will be allowed only if the specified tenant contains no data.\n");
															#line 317 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantDeleteIdCommandActorState();
				static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 320 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 2093 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantDeleteIdCommandActorState();
		static_cast<TenantDeleteIdCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 350 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print("The tenant with ID `{}' has been deleted\n", printable(tokens[2]).c_str());
															#line 351 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2118 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantDeleteIdCommandActorState();
		static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 322 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 323 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2144 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >*>(static_cast<TenantDeleteIdCommandActor*>(this)));
															#line 2149 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			err = Error(e);
															#line 341 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 2186 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_2 = getSpecialKeysFailureErrorMessage(tr);
															#line 342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2192 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 3;
															#line 342 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteIdCommandActor, 2, std::string >*>(static_cast<TenantDeleteIdCommandActor*>(this)));
															#line 2197 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 325 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		int64_t tenantId;
															#line 326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		int n;
															#line 327 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType != ClusterType::METACLUSTER_MANAGEMENT)
															#line 2221 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: delete by ID should only be run on a management cluster.\n");
															#line 329 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2227 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantDeleteIdCommandActorState();
			static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 331 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (sscanf(tokens[2].toString().c_str(), "%" PRId64 "%n", &tenantId, &n) != 1 || n != tokens[2].size() || tenantId < 0)
															#line 2235 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 333 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: invalid ID `{}'\n", tokens[2].toString().c_str());
															#line 334 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2241 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantDeleteIdCommandActorState();
			static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_1 = metacluster::deleteTenant(db, tenantId);
															#line 336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2251 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 2;
															#line 336 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteIdCommandActor, 1, Void >*>(static_cast<TenantDeleteIdCommandActor*>(this)));
															#line 2256 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 2265 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteIdCommandActor*>(this)->ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteIdCommandActor*>(this)->ActorCallback< TenantDeleteIdCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantDeleteIdCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(err));
															#line 346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2433 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 4;
															#line 346 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantDeleteIdCommandActor, 3, Void >*>(static_cast<TenantDeleteIdCommandActor*>(this)));
															#line 2438 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantDeleteIdCommandActorState();
		static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 343 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 344 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantDeleteIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantDeleteIdCommandActorState(); static_cast<TenantDeleteIdCommandActor*>(this)->destroy(); return 0; }
															#line 2463 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantDeleteIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantDeleteIdCommandActorState();
		static_cast<TenantDeleteIdCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteIdCommandActor*>(this)->ActorCallback< TenantDeleteIdCommandActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantDeleteIdCommandActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantDeleteIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantDeleteIdCommandActor*>(this)->ActorCallback< TenantDeleteIdCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantDeleteIdCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantDeleteIdCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 319 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 324 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 340 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Error err;
															#line 2643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantDeleteIdCommand()
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantDeleteIdCommandActor final : public Actor<bool>, public ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >, public ActorCallback< TenantDeleteIdCommandActor, 1, Void >, public ActorCallback< TenantDeleteIdCommandActor, 2, std::string >, public ActorCallback< TenantDeleteIdCommandActor, 3, Void >, public FastAllocated<TenantDeleteIdCommandActor>, public TenantDeleteIdCommandActorState<TenantDeleteIdCommandActor> {
															#line 2648 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantDeleteIdCommandActor>::operator new;
	using FastAllocated<TenantDeleteIdCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4268823538048488704UL, 11608855654328801536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantDeleteIdCommandActor, 1, Void >;
friend struct ActorCallback< TenantDeleteIdCommandActor, 2, std::string >;
friend struct ActorCallback< TenantDeleteIdCommandActor, 3, Void >;
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantDeleteIdCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantDeleteIdCommandActorState<TenantDeleteIdCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16642673266920671232UL, 14144432302106285056UL);
		ActorExecutionContextHelper __helper(static_cast<TenantDeleteIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantDeleteIdCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantDeleteIdCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantDeleteIdCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantDeleteIdCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantDeleteIdCommandActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantDeleteIdCommandActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantDeleteIdCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 312 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantDeleteIdCommandActor(db, tokens));
															#line 2703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 353 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

void tenantListOutputJson(std::map<TenantName, int64_t> tenants) {
	json_spirit::mArray tenantsArr;
	for (auto const& [tenantName, tenantId] : tenants) {
		json_spirit::mObject tenantObj;
		tenantObj["name"] = binaryToJson(tenantName);
		tenantObj["id"] = tenantId;
		tenantsArr.push_back(tenantObj);
	}

	json_spirit::mObject resultObj;
	resultObj["tenants"] = tenantsArr;
	resultObj["type"] = "success";

	fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print).c_str());
}

// tenant list command
															#line 2725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantListCommand()
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantListCommandActor>
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantListCommandActorState {
															#line 2731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantListCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 2740 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantListCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantListCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantListCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 372 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() > 9)
															#line 2755 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 373 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print( "Usage: tenant list [BEGIN] [END] " "[limit=<LIMIT>|offset=<OFFSET>|state=<STATE1>,<STATE2>,...|tenant_group=<TENANT_GROUP>] [JSON] ...\n\n");
															#line 376 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Lists the tenants in a cluster.\n");
															#line 377 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Only tenants in the range BEGIN - END will be printed.\n");
															#line 378 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("An optional LIMIT can be specified to limit the number of results (default 100).\n");
															#line 379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Optionally skip over the first OFFSET results (default 0).\n");
															#line 380 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Optional comma-separated tenant state(s) can be provided to filter the list.\n");
															#line 381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Optional tenant group can be provided to filter the list.\n");
															#line 382 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Specifying [offset] and [state] is only supported in a metacluster.\n");
															#line 384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantListCommandActorState(); static_cast<TenantListCommandActor*>(this)->destroy(); return 0; }
															#line 2777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantListCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantListCommandActorState();
				static_cast<TenantListCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			beginTenant = ""_sr;
															#line 388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			endTenant = "\xff\xff"_sr;
															#line 389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			limit = 100;
															#line 390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			offset = 0;
															#line 391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			filters = std::vector<metacluster::TenantState>();
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantGroup = Optional<TenantGroupName>();
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			useJson = false;
															#line 395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() >= 3)
															#line 2799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 396 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				beginTenant = tokens[2];
															#line 2803 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 398 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() >= 4)
															#line 2807 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				endTenant = tokens[3];
															#line 400 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (endTenant <= beginTenant)
															#line 2813 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 401 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print(stderr, "ERROR: end must be larger than begin\n");
															#line 402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (!static_cast<TenantListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantListCommandActorState(); static_cast<TenantListCommandActor*>(this)->destroy(); return 0; }
															#line 2819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					new (&static_cast<TenantListCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantListCommandActorState();
					static_cast<TenantListCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() >= 5)
															#line 2828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!parseTenantListOptions(tokens, 4, limit, offset, filters, tenantGroup, useJson))
															#line 2832 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 407 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (!static_cast<TenantListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantListCommandActorState(); static_cast<TenantListCommandActor*>(this)->destroy(); return 0; }
															#line 2836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					new (&static_cast<TenantListCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantListCommandActorState();
					static_cast<TenantListCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			beginTenantKey = tenantMapSpecialKeyRange.begin.withSuffix(beginTenant);
															#line 412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			endTenantKey = tenantMapSpecialKeyRange.begin.withSuffix(endTenant);
															#line 413 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 415 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 2851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantListCommandActorState();
		static_cast<TenantListCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 417 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2886 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantListCommandActor*>(this)->actor_wait_state = 1;
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 0, ClusterType >*>(static_cast<TenantListCommandActor*>(this)));
															#line 2891 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 475 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 475 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 2916 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TenantListCommandActor*>(this)->actor_wait_state = 5;
															#line 475 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 4, Void >*>(static_cast<TenantListCommandActor*>(this)));
															#line 2921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantInfo = std::map<TenantName, int64_t>();
															#line 422 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 2944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>>> __when_expr_1 = metacluster::listTenantMetadata(db, beginTenant, endTenant, limit, offset, filters, tenantGroup);
															#line 423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2950 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantListCommandActor*>(this)->actor_wait_state = 2;
															#line 423 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<TenantListCommandActor*>(this)));
															#line 2955 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 429 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tenantGroup.present())
															#line 2962 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 432 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_2 = TenantAPI::listTenantGroupTenants(db, tenantGroup.get(), beginTenant, endTenant, limit);
															#line 432 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2968 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<TenantListCommandActor*>(this)->actor_wait_state = 3;
															#line 432 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<TenantListCommandActor*>(this)));
															#line 2973 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				kvsFuture = tr->getRange(firstGreaterOrEqual(beginTenantKey), firstGreaterOrEqual(endTenantKey), limit);
															#line 441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<RangeResult> __when_expr_3 = safeThreadFutureToFuture(kvsFuture);
															#line 441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2984 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when3(__when_expr_3.get(), loopDepth); };
				static_cast<TenantListCommandActor*>(this)->actor_wait_state = 4;
															#line 441 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 3, RangeResult >*>(static_cast<TenantListCommandActor*>(this)));
															#line 2989 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 3000 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 455 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (useJson)
															#line 3079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 456 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantListOutputJson(tenantInfo);
															#line 3083 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 458 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tenantInfo.empty())
															#line 3089 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (tokens.size() == 2)
															#line 3093 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 460 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print("The cluster has no tenants\n");
															#line 3097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				else
				{
															#line 462 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print("The cluster has no tenants in the specified range\n");
															#line 3103 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
			}
															#line 466 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int index = 0;
															#line 467 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			for( const auto& [tenantName, tenantId] : tenantInfo ) {
															#line 468 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("  {}. {}\n", ++index, printable(tenantName).c_str());
															#line 3112 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
		}
															#line 472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantListCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantListCommandActorState(); static_cast<TenantListCommandActor*>(this)->destroy(); return 0; }
															#line 3117 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantListCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantListCommandActorState();
		static_cast<TenantListCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& tenants,int loopDepth) 
	{
															#line 425 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( const auto& [tenantName, entry] : tenants ) {
															#line 426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tenantName] = entry.id;
															#line 3131 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && tenants,int loopDepth) 
	{
															#line 425 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( const auto& [tenantName, entry] : tenants ) {
															#line 426 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tenantName] = entry.id;
															#line 3143 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(std::vector<std::pair<TenantName, int64_t>> const& tenants,int loopDepth) 
	{
															#line 434 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( const auto& [tenantName, tenantId] : tenants ) {
															#line 435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tenantName] = tenantId;
															#line 3236 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(std::vector<std::pair<TenantName, int64_t>> && tenants,int loopDepth) 
	{
															#line 434 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( const auto& [tenantName, tenantId] : tenants ) {
															#line 435 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tenantName] = tenantId;
															#line 3248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(std::vector<std::pair<TenantName, int64_t>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(std::vector<std::pair<TenantName, int64_t>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(RangeResult const& tenants,int loopDepth) 
	{
															#line 442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( auto tenant : tenants ) {
															#line 443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			TenantName tName = tenant.key.removePrefix(tenantMapSpecialKeyRange.begin);
															#line 444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::mValue jsonObject;
															#line 445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::read_string(tenant.value.toString(), jsonObject);
															#line 446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			JSONDoc jsonDoc(jsonObject);
															#line 448 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int64_t tId;
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			jsonDoc.get("id", tId);
															#line 450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tName] = tId;
															#line 3347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(RangeResult && tenants,int loopDepth) 
	{
															#line 442 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		for( auto tenant : tenants ) {
															#line 443 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			TenantName tName = tenant.key.removePrefix(tenantMapSpecialKeyRange.begin);
															#line 444 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::mValue jsonObject;
															#line 445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::read_string(tenant.value.toString(), jsonObject);
															#line 446 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			JSONDoc jsonDoc(jsonObject);
															#line 448 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int64_t tId;
															#line 449 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			jsonDoc.get("id", tId);
															#line 450 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantInfo[tName] = tId;
															#line 3371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when3(RangeResult const& tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when3(RangeResult && tenants,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& finalErr,int loopDepth=0) 
	{
		try {
															#line 477 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			errorStr = std::string();
															#line 478 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (finalErr.code() == error_code_special_keys_api_failure)
															#line 3465 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_5 = getSpecialKeysFailureErrorMessage(tr);
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantListCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3471 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<TenantListCommandActor*>(this)->actor_wait_state = 6;
															#line 479 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantListCommandActor, 5, std::string >*>(static_cast<TenantListCommandActor*>(this)));
															#line 3476 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 481 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (useJson)
															#line 3483 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 482 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					errorStr = finalErr.what();
															#line 3487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				else
				{
															#line 484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					return a_body1Catch1(finalErr, std::max(0, loopDepth - 1));
															#line 3493 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont1(int loopDepth) 
	{
															#line 487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (useJson)
															#line 3610 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 488 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::mObject resultObj;
															#line 489 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["type"] = "error";
															#line 490 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["error"] = errorStr;
															#line 491 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print( "{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print).c_str());
															#line 3620 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 495 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: {}\n", errorStr.c_str());
															#line 3626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 498 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantListCommandActorState(); static_cast<TenantListCommandActor*>(this)->destroy(); return 0; }
															#line 3630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantListCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantListCommandActorState();
		static_cast<TenantListCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string const& str,int loopDepth) 
	{
															#line 480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 3642 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string && str,int loopDepth) 
	{
															#line 480 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 3651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string const& str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(str, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string && str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantListCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantListCommandActor*>(this)->ActorCallback< TenantListCommandActor, 5, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 5, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantListCommandActor, 5, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantListCommandActor, 5, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	StringRef beginTenant;
															#line 388 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	StringRef endTenant;
															#line 389 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	int limit;
															#line 390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	int offset;
															#line 391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<metacluster::TenantState> filters;
															#line 392 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Optional<TenantGroupName> tenantGroup;
															#line 393 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool useJson;
															#line 411 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key beginTenantKey;
															#line 412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key endTenantKey;
															#line 413 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 418 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 419 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::map<TenantName, int64_t> tenantInfo;
															#line 439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<RangeResult> kvsFuture;
															#line 477 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::string errorStr;
															#line 3763 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantListCommand()
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantListCommandActor final : public Actor<bool>, public ActorCallback< TenantListCommandActor, 0, ClusterType >, public ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< TenantListCommandActor, 3, RangeResult >, public ActorCallback< TenantListCommandActor, 4, Void >, public ActorCallback< TenantListCommandActor, 5, std::string >, public FastAllocated<TenantListCommandActor>, public TenantListCommandActorState<TenantListCommandActor> {
															#line 3768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantListCommandActor>::operator new;
	using FastAllocated<TenantListCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8578267121449481984UL, 8358228757555443968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantListCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< TenantListCommandActor, 3, RangeResult >;
friend struct ActorCallback< TenantListCommandActor, 4, Void >;
friend struct ActorCallback< TenantListCommandActor, 5, std::string >;
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantListCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 3790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantListCommandActorState<TenantListCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantListCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8658818310982958592UL, 9590503082722109952UL);
		ActorExecutionContextHelper __helper(static_cast<TenantListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantListCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantListCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantListCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantListCommandActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantListCommandActor, 2, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantListCommandActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantListCommandActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantListCommandActor, 5, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantListCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantListCommandActor(db, tokens));
															#line 3827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 503 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

void tenantGetCmdOutput(json_spirit::mValue jsonObject, bool useJson) {
	if (useJson) {
		json_spirit::mObject resultObj;
		resultObj["tenant"] = jsonObject;
		resultObj["type"] = "success";
		fmt::print("{}\n",
		           json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print).c_str());
	} else {
		JSONDoc doc(jsonObject);

		int64_t id;
		std::string name;
		std::string prefix;
		std::string tenantState;
		std::string tenantLockState;
		std::string lockId;
		std::string tenantGroup;
		std::string assignedCluster;
		std::string error;

		doc.get("id", id);
		doc.get("prefix.printable", prefix);
		doc.get("lock_state", tenantLockState);

		bool hasName = doc.tryGet("name.printable", name);
		bool hasTenantState = doc.tryGet("tenant_state", tenantState);
		bool hasLockId = doc.tryGet("lock_id", lockId);
		bool hasTenantGroup = doc.tryGet("tenant_group.printable", tenantGroup);
		bool hasAssignedCluster = doc.tryGet("assigned_cluster.printable", assignedCluster);
		bool hasError = doc.tryGet("error", error);

		fmt::print("  id: {}\n", id);
		fmt::print("  prefix: {}\n", printable(prefix));

		if (hasName) {
			fmt::print("  name: {}\n", name);
		}

		if (hasTenantState) {
			fmt::print("  tenant state: {}\n", printable(tenantState));
		}

		fmt::print("  lock state: {}\n", tenantLockState);
		if (hasLockId) {
			fmt::print("  lock id: {}\n", lockId);
		}

		if (hasTenantGroup) {
			fmt::print("  tenant group: {}\n", tenantGroup);
		}
		if (hasAssignedCluster) {
			fmt::print("  assigned cluster: {}\n", printable(assignedCluster));
		}
		if (hasError) {
			fmt::print("  error: {}\n", error);
		}
	}
}

// tenant get command
															#line 3892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantGetCommand()
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantGetCommandActor>
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantGetCommandActorState {
															#line 3898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantGetCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 3907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantGetCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantGetCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantGetCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 565 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() < 3 || tokens.size() > 4 || (tokens.size() == 4 && tokens[3] != "JSON"_sr))
															#line 3922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 566 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant get <NAME> [JSON]\n\n");
															#line 567 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Prints metadata associated with the given tenant.\n");
															#line 568 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 569 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGetCommandActorState(); static_cast<TenantGetCommandActor*>(this)->destroy(); return 0; }
															#line 3932 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantGetCommandActorState();
				static_cast<TenantGetCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			useJson = tokens.size() == 4;
															#line 573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantNameKey = tenantMapSpecialKeyRange.begin.withSuffix(tokens[2]);
															#line 574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 3946 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantGetCommandActorState();
		static_cast<TenantGetCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 578 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3981 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 1;
															#line 579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantGetCommandActor, 0, ClusterType >*>(static_cast<TenantGetCommandActor*>(this)));
															#line 3986 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4011 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 4;
															#line 599 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantGetCommandActor, 3, Void >*>(static_cast<TenantGetCommandActor*>(this)));
															#line 4016 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 580 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = std::string();
															#line 581 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 4039 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_1 = metacluster::getTenantTransaction(tr, tokens[2]);
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4045 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 2;
															#line 582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >*>(static_cast<TenantGetCommandActor*>(this)));
															#line 4050 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 586 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantFuture = tr->get(tenantNameKey);
															#line 587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(tenantFuture);
															#line 587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4061 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 3;
															#line 587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantGetCommandActor, 2, Optional<Value> >*>(static_cast<TenantGetCommandActor*>(this)));
															#line 4066 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 4076 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetCommandActor*>(this)->ActorCallback< TenantGetCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantGetCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 593 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		json_spirit::mValue jsonObject;
															#line 594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		json_spirit::read_string(tenantJson, jsonObject);
															#line 595 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantGetCmdOutput(jsonObject, useJson);
															#line 596 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantGetCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantGetCommandActorState(); static_cast<TenantGetCommandActor*>(this)->destroy(); return 0; }
															#line 4161 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantGetCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantGetCommandActorState();
		static_cast<TenantGetCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = entry.toJson();
															#line 4173 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
															#line 583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = entry.toJson();
															#line 4182 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetCommandActor*>(this)->ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Optional<Value> const& tenant,int loopDepth) 
	{
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!tenant.present())
															#line 4266 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 4270 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = tenant.get().toString();
															#line 4274 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Value> && tenant,int loopDepth) 
	{
															#line 588 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!tenant.present())
															#line 4283 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 4287 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = tenant.get().toString();
															#line 4291 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> const& tenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(tenant, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> && tenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(tenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetCommandActor*>(this)->ActorCallback< TenantGetCommandActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantGetCommandActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& finalErr,int loopDepth=0) 
	{
		try {
															#line 601 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			errorStr = std::string();
															#line 602 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (finalErr.code() == error_code_special_keys_api_failure)
															#line 4384 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_4 = getSpecialKeysFailureErrorMessage(tr);
															#line 603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4390 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 5;
															#line 603 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantGetCommandActor, 4, std::string >*>(static_cast<TenantGetCommandActor*>(this)));
															#line 4395 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 605 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (useJson)
															#line 4402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 606 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					errorStr = finalErr.what();
															#line 4406 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				else
				{
															#line 608 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					return a_body1Catch1(finalErr, std::max(0, loopDepth - 1));
															#line 4412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetCommandActor*>(this)->ActorCallback< TenantGetCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantGetCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont1(int loopDepth) 
	{
															#line 611 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (useJson)
															#line 4529 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::mObject resultObj;
															#line 613 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["type"] = "error";
															#line 614 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["error"] = errorStr;
															#line 615 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print( "{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print).c_str());
															#line 4539 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 619 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: {}\n", errorStr.c_str());
															#line 4545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGetCommandActorState(); static_cast<TenantGetCommandActor*>(this)->destroy(); return 0; }
															#line 4549 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantGetCommandActorState();
		static_cast<TenantGetCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string const& str,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 4561 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string && str,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 4570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string const& str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(str, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string && str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantGetCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetCommandActor*>(this)->ActorCallback< TenantGetCommandActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantGetCommandActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantGetCommandActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 572 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool useJson;
															#line 573 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantNameKey;
															#line 574 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 579 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 580 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::string tenantJson;
															#line 586 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> tenantFuture;
															#line 601 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::string errorStr;
															#line 4668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantGetCommand()
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantGetCommandActor final : public Actor<bool>, public ActorCallback< TenantGetCommandActor, 0, ClusterType >, public ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< TenantGetCommandActor, 2, Optional<Value> >, public ActorCallback< TenantGetCommandActor, 3, Void >, public ActorCallback< TenantGetCommandActor, 4, std::string >, public FastAllocated<TenantGetCommandActor>, public TenantGetCommandActorState<TenantGetCommandActor> {
															#line 4673 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantGetCommandActor>::operator new;
	using FastAllocated<TenantGetCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(751897806253638656UL, 12041996701512810496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantGetCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< TenantGetCommandActor, 2, Optional<Value> >;
friend struct ActorCallback< TenantGetCommandActor, 3, Void >;
friend struct ActorCallback< TenantGetCommandActor, 4, std::string >;
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantGetCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 4694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantGetCommandActorState<TenantGetCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantGetCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3459944109615696384UL, 991462824800686592UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantGetCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantGetCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantGetCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantGetCommandActor, 1, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantGetCommandActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantGetCommandActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantGetCommandActor, 4, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantGetCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 564 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantGetCommandActor(db, tokens));
															#line 4730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 627 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// tenant getId command
															#line 4736 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantGetIdCommand()
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantGetIdCommandActor>
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantGetIdCommandActorState {
															#line 4742 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantGetIdCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 4751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantGetIdCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantGetIdCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantGetIdCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 630 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() < 3 || tokens.size() > 4 || (tokens.size() == 4 && tokens[3] != "JSON"_sr))
															#line 4766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 631 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant getId <ID> [JSON]\n\n");
															#line 632 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Prints metadata associated with the given tenant ID.\n");
															#line 633 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 634 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantGetIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGetIdCommandActorState(); static_cast<TenantGetIdCommandActor*>(this)->destroy(); return 0; }
															#line 4776 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantGetIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantGetIdCommandActorState();
				static_cast<TenantGetIdCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 637 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			useJson = tokens.size() == 4;
															#line 638 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantId = int64_t();
															#line 639 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int n = 0;
															#line 640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (sscanf(tokens[2].toString().c_str(), "%" PRId64 "%n", &tenantId, &n) != 1 || n != tokens[2].size() || tenantId < 0)
															#line 4790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 642 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print(stderr, "ERROR: invalid ID `{}'\n", tokens[2].toString().c_str());
															#line 643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantGetIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGetIdCommandActorState(); static_cast<TenantGetIdCommandActor*>(this)->destroy(); return 0; }
															#line 4796 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantGetIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantGetIdCommandActorState();
				static_cast<TenantGetIdCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 647 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 4806 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantGetIdCommandActorState();
		static_cast<TenantGetIdCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 649 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 1;
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantGetIdCommandActor, 0, ClusterType >*>(static_cast<TenantGetIdCommandActor*>(this)));
															#line 4846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 4;
															#line 666 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantGetIdCommandActor, 3, Void >*>(static_cast<TenantGetIdCommandActor*>(this)));
															#line 4876 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = std::string();
															#line 652 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType != ClusterType::METACLUSTER_MANAGEMENT)
															#line 4899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<TenantMapEntry> __when_expr_1 = TenantAPI::getTenantTransaction(tr, tenantId);
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 2;
															#line 653 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >*>(static_cast<TenantGetIdCommandActor*>(this)));
															#line 4910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_2 = metacluster::getTenantTransaction(tr, tenantId);
															#line 656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 3;
															#line 656 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >*>(static_cast<TenantGetIdCommandActor*>(this)));
															#line 4924 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 4934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetIdCommandActor*>(this)->ActorCallback< TenantGetIdCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantGetIdCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 660 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		json_spirit::mValue jsonObject;
															#line 661 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		json_spirit::read_string(tenantJson, jsonObject);
															#line 662 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantGetCmdOutput(jsonObject, useJson);
															#line 663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantGetIdCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantGetIdCommandActorState(); static_cast<TenantGetIdCommandActor*>(this)->destroy(); return 0; }
															#line 5019 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantGetIdCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantGetIdCommandActorState();
		static_cast<TenantGetIdCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = entry.toJson();
															#line 5031 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(TenantMapEntry && entry,int loopDepth) 
	{
															#line 654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = entry.toJson();
															#line 5040 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetIdCommandActor*>(this)->ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(metacluster::MetaclusterTenantMapEntry const& mEntry,int loopDepth) 
	{
															#line 657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = mEntry.toJson();
															#line 5124 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(metacluster::MetaclusterTenantMapEntry && mEntry,int loopDepth) 
	{
															#line 657 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tenantJson = mEntry.toJson();
															#line 5133 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(metacluster::MetaclusterTenantMapEntry const& mEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(mEntry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(metacluster::MetaclusterTenantMapEntry && mEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(mEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetIdCommandActor*>(this)->ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& finalErr,int loopDepth=0) 
	{
		try {
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			errorStr = std::string();
															#line 669 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (finalErr.code() == error_code_special_keys_api_failure)
															#line 5226 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_4 = getSpecialKeysFailureErrorMessage(tr);
															#line 670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5232 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 5;
															#line 670 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantGetIdCommandActor, 4, std::string >*>(static_cast<TenantGetIdCommandActor*>(this)));
															#line 5237 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 672 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (useJson)
															#line 5244 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 673 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					errorStr = finalErr.what();
															#line 5248 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				else
				{
															#line 675 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					return a_body1Catch1(finalErr, std::max(0, loopDepth - 1));
															#line 5254 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetIdCommandActor*>(this)->ActorCallback< TenantGetIdCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantGetIdCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont1(int loopDepth) 
	{
															#line 678 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (useJson)
															#line 5371 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			json_spirit::mObject resultObj;
															#line 680 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["type"] = "error";
															#line 681 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			resultObj["error"] = errorStr;
															#line 682 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print( "{}\n", json_spirit::write_string(json_spirit::mValue(resultObj), json_spirit::pretty_print).c_str());
															#line 5381 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 686 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: {}\n", errorStr.c_str());
															#line 5387 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 689 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantGetIdCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantGetIdCommandActorState(); static_cast<TenantGetIdCommandActor*>(this)->destroy(); return 0; }
															#line 5391 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantGetIdCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantGetIdCommandActorState();
		static_cast<TenantGetIdCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string const& str,int loopDepth) 
	{
															#line 671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 5403 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1cont2(std::string && str,int loopDepth) 
	{
															#line 671 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		errorStr = str;
															#line 5412 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string const& str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(str, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1when1(std::string && str,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1Catch1cont2(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantGetIdCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantGetIdCommandActor*>(this)->ActorCallback< TenantGetIdCommandActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantGetIdCommandActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantGetIdCommandActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 637 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool useJson;
															#line 638 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	int64_t tenantId;
															#line 645 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 650 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 651 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::string tenantJson;
															#line 668 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::string errorStr;
															#line 5508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantGetIdCommand()
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantGetIdCommandActor final : public Actor<bool>, public ActorCallback< TenantGetIdCommandActor, 0, ClusterType >, public ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >, public ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< TenantGetIdCommandActor, 3, Void >, public ActorCallback< TenantGetIdCommandActor, 4, std::string >, public FastAllocated<TenantGetIdCommandActor>, public TenantGetIdCommandActorState<TenantGetIdCommandActor> {
															#line 5513 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantGetIdCommandActor>::operator new;
	using FastAllocated<TenantGetIdCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12695415029121090048UL, 4749943272877976064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantGetIdCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >;
friend struct ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< TenantGetIdCommandActor, 3, Void >;
friend struct ActorCallback< TenantGetIdCommandActor, 4, std::string >;
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantGetIdCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 5534 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantGetIdCommandActorState<TenantGetIdCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17072906349128740864UL, 10182180643298900992UL);
		ActorExecutionContextHelper __helper(static_cast<TenantGetIdCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantGetIdCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantGetIdCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantGetIdCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantGetIdCommandActor, 1, TenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantGetIdCommandActor, 2, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantGetIdCommandActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantGetIdCommandActor, 4, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantGetIdCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 629 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantGetIdCommandActor(db, tokens));
															#line 5570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 694 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// tenant configure command
															#line 5576 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantConfigureCommand()
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantConfigureCommandActor>
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantConfigureCommandActorState {
															#line 5582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantConfigureCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 5591 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantConfigureCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantConfigureCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantConfigureCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 697 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() < 4)
															#line 5606 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 698 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print( "Usage: tenant configure <TENANT_NAME> <[unset] tenant_group[=<GROUP_NAME>]> [ignore_capacity_limit]\n\n");
															#line 700 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Updates the configuration for a tenant.\n");
															#line 701 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Use `tenant_group=<GROUP_NAME>' to change the tenant group that a\n");
															#line 702 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("tenant is assigned to or `unset tenant_group' to remove a tenant from\n");
															#line 703 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("its tenant group.\n");
															#line 704 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("If `ignore_capacity_limit' is specified, a new tenant group can be\n");
															#line 705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("created or the tenant can be ungrouped on a cluster with no tenant group\n");
															#line 706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("capacity remaining\n");
															#line 707 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantConfigureCommandActorState(); static_cast<TenantConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 5626 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantConfigureCommandActorState();
				static_cast<TenantConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			ignoreCapacityLimit = tokens.back() == "ignore_capacity_limit";
															#line 711 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int configurationEndIndex = tokens.size() - (ignoreCapacityLimit ? 1 : 0);
															#line 712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			configuration = parseTenantConfiguration(tokens, 3, configurationEndIndex, true);
															#line 715 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!configuration.present())
															#line 5640 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 716 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantConfigureCommandActorState(); static_cast<TenantConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 5644 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantConfigureCommandActorState();
				static_cast<TenantConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 721 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 5654 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantConfigureCommandActorState();
		static_cast<TenantConfigureCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 745 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print("The configuration for tenant `{}' has been updated\n", printable(tokens[2]).c_str());
															#line 746 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantConfigureCommandActorState(); static_cast<TenantConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 5679 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantConfigureCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantConfigureCommandActorState();
		static_cast<TenantConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 723 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 724 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5705 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 1;
															#line 725 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 0, ClusterType >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			err = Error(e);
															#line 736 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 5747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 737 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_3 = getSpecialKeysFailureErrorMessage(tr);
															#line 737 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5753 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 4;
															#line 737 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 3, std::string >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5758 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ClusterType const& clusterType,int loopDepth) 
	{
															#line 726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 5778 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::configureTenant( db, tokens[2], configuration.get(), metacluster::IgnoreCapacityLimit(ignoreCapacityLimit));
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 2;
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 1, Void >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5789 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			applyConfigurationToSpecialKeys(tr, tokens[2], configuration.get());
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 3;
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 2, Void >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ClusterType && clusterType,int loopDepth) 
	{
															#line 726 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 5815 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::configureTenant( db, tokens[2], configuration.get(), metacluster::IgnoreCapacityLimit(ignoreCapacityLimit));
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5821 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 2;
															#line 727 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 1, Void >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 730 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			applyConfigurationToSpecialKeys(tr, tokens[2], configuration.get());
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5837 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 3;
															#line 731 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 2, Void >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 5842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& clusterType,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusterType, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && clusterType,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusterType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantConfigureCommandActor*>(this)->ActorCallback< TenantConfigureCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantConfigureCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantConfigureCommandActor*>(this)->ActorCallback< TenantConfigureCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantConfigureCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantConfigureCommandActor*>(this)->ActorCallback< TenantConfigureCommandActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantConfigureCommandActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(err));
															#line 741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6109 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 5;
															#line 741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantConfigureCommandActor, 4, Void >*>(static_cast<TenantConfigureCommandActor*>(this)));
															#line 6114 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantConfigureCommandActorState(); static_cast<TenantConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 6125 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantConfigureCommandActorState();
		static_cast<TenantConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 738 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 739 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantConfigureCommandActorState(); static_cast<TenantConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 6139 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantConfigureCommandActorState();
		static_cast<TenantConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantConfigureCommandActor*>(this)->ActorCallback< TenantConfigureCommandActor, 3, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 3, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 3, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantConfigureCommandActor, 3, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantConfigureCommandActor*>(this)->ActorCallback< TenantConfigureCommandActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantConfigureCommandActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantConfigureCommandActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 710 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool ignoreCapacityLimit;
															#line 712 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Optional<std::map<Standalone<StringRef>, Optional<Value>>> configuration;
															#line 719 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 735 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Error err;
															#line 6321 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantConfigureCommand()
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantConfigureCommandActor final : public Actor<bool>, public ActorCallback< TenantConfigureCommandActor, 0, ClusterType >, public ActorCallback< TenantConfigureCommandActor, 1, Void >, public ActorCallback< TenantConfigureCommandActor, 2, Void >, public ActorCallback< TenantConfigureCommandActor, 3, std::string >, public ActorCallback< TenantConfigureCommandActor, 4, Void >, public FastAllocated<TenantConfigureCommandActor>, public TenantConfigureCommandActorState<TenantConfigureCommandActor> {
															#line 6326 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantConfigureCommandActor>::operator new;
	using FastAllocated<TenantConfigureCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10665266862582658048UL, 4916737333083320064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantConfigureCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantConfigureCommandActor, 1, Void >;
friend struct ActorCallback< TenantConfigureCommandActor, 2, Void >;
friend struct ActorCallback< TenantConfigureCommandActor, 3, std::string >;
friend struct ActorCallback< TenantConfigureCommandActor, 4, Void >;
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantConfigureCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 6347 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantConfigureCommandActorState<TenantConfigureCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14958911593271168256UL, 8697091845943696128UL);
		ActorExecutionContextHelper __helper(static_cast<TenantConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantConfigureCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantConfigureCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantConfigureCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantConfigureCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantConfigureCommandActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantConfigureCommandActor, 3, std::string >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantConfigureCommandActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantConfigureCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 696 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantConfigureCommandActor(db, tokens));
															#line 6383 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 748 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// Helper function to extract tenant ID from json metadata string
int64_t getTenantId(Value metadata) {
	json_spirit::mValue jsonObject;
	json_spirit::read_string(metadata.toString(), jsonObject);
	JSONDoc doc(jsonObject);
	int64_t id;
	doc.get("id", id);
	return id;
}

// tenant rename command
															#line 6399 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantRenameCommand()
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantRenameCommandActor>
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantRenameCommandActorState {
															#line 6405 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantRenameCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens)
															#line 6414 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantRenameCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantRenameCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantRenameCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() != 4)
															#line 6429 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 762 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant rename <OLD_NAME> <NEW_NAME>\n\n");
															#line 763 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Renames a tenant in the cluster. The old name must exist and the new\n");
															#line 764 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("name must not exist in the cluster.\n");
															#line 765 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantRenameCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantRenameCommandActorState(); static_cast<TenantRenameCommandActor*>(this)->destroy(); return 0; }
															#line 6439 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantRenameCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantRenameCommandActorState();
				static_cast<TenantRenameCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr = db->createTransaction();
															#line 768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantRenameKey = tenantRenameSpecialKeyRange.begin.withSuffix(tokens[2]);
															#line 769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantOldNameKey = tenantMapSpecialKeyRange.begin.withSuffix(tokens[2]);
															#line 770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantNewNameKey = tenantMapSpecialKeyRange.begin.withSuffix(tokens[3]);
															#line 771 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			firstTry = true;
															#line 772 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			id = -1;
															#line 773 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			;
															#line 6459 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantRenameCommandActorState();
		static_cast<TenantRenameCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 834 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print( "The tenant `{}' has been renamed to `{}'\n", printable(tokens[2]).c_str(), printable(tokens[3]).c_str());
															#line 836 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantRenameCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantRenameCommandActorState(); static_cast<TenantRenameCommandActor*>(this)->destroy(); return 0; }
															#line 6484 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantRenameCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantRenameCommandActorState();
		static_cast<TenantRenameCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 775 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 776 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6510 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 1;
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 0, ClusterType >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6515 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 824 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			err = Error(e);
															#line 825 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 6552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				StrictFuture<std::string> __when_expr_5 = getSpecialKeysFailureErrorMessage(tr);
															#line 826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 6;
															#line 826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 5, std::string >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6563 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 778 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 6583 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::renameTenant(db, tokens[2], tokens[3]);
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6589 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 2;
															#line 779 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 1, Void >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			oldEntryFuture = tr->get(tenantOldNameKey);
															#line 783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			newEntryFuture = tr->get(tenantNewNameKey);
															#line 784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(oldEntryFuture);
															#line 784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6607 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 3;
															#line 784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6612 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		clusterType = __clusterType;
															#line 6622 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = safeThreadFutureToFuture(newEntryFuture);
															#line 785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6796 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 4;
															#line 785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> const& __oldEntry,int loopDepth) 
	{
															#line 784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		oldEntry = __oldEntry;
															#line 6810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Optional<Value> && __oldEntry,int loopDepth) 
	{
		oldEntry = std::move(__oldEntry);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 786 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (firstTry)
															#line 6889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!oldEntry.present())
															#line 6893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 788 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 6897 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 790 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (newEntry.present())
															#line 6901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 791 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 6905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 794 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			id = getTenantId(oldEntry.get());
															#line 796 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			firstTry = false;
															#line 6911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 799 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (newEntry.present())
															#line 6917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 800 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				int64_t checkId = getTenantId(newEntry.get());
															#line 801 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (id == checkId)
															#line 6923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 802 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					ASSERT(!oldEntry.present() || getTenantId(oldEntry.get()) != id);
															#line 803 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (!static_cast<TenantRenameCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantRenameCommandActorState(); static_cast<TenantRenameCommandActor*>(this)->destroy(); return 0; }
															#line 6929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					new (&static_cast<TenantRenameCommandActor*>(this)->SAV< bool >::value()) bool(true);
					this->~TenantRenameCommandActorState();
					static_cast<TenantRenameCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 807 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 6937 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 809 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!oldEntry.present())
															#line 6941 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 6945 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
															#line 812 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			int64_t checkId = getTenantId(oldEntry.get());
															#line 815 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (id != checkId)
															#line 6951 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 816 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 6955 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
		}
															#line 819 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tr->set(tenantRenameKey, tokens[3]);
															#line 820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->commit());
															#line 820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6964 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 5;
															#line 820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 4, Void >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 6969 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<Value> const& __newEntry,int loopDepth) 
	{
															#line 785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		newEntry = __newEntry;
															#line 6978 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<Value> && __newEntry,int loopDepth) 
	{
		newEntry = std::move(__newEntry);
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_6 = safeThreadFutureToFuture(tr->onError(err));
															#line 830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7146 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 7;
															#line 830 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TenantRenameCommandActor, 6, Void >*>(static_cast<TenantRenameCommandActor*>(this)));
															#line 7151 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantRenameCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantRenameCommandActorState(); static_cast<TenantRenameCommandActor*>(this)->destroy(); return 0; }
															#line 7162 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantRenameCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantRenameCommandActorState();
		static_cast<TenantRenameCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 827 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		fmt::print(stderr, "ERROR: {}\n", errorMsgStr.c_str());
															#line 828 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantRenameCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantRenameCommandActorState(); static_cast<TenantRenameCommandActor*>(this)->destroy(); return 0; }
															#line 7176 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantRenameCommandActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TenantRenameCommandActorState();
		static_cast<TenantRenameCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 5, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 5, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 5, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 5, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TenantRenameCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantRenameCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantRenameCommandActor*>(this)->ActorCallback< TenantRenameCommandActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TenantRenameCommandActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TenantRenameCommandActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 767 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 768 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantRenameKey;
															#line 769 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantOldNameKey;
															#line 770 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key tenantNewNameKey;
															#line 771 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	bool firstTry;
															#line 772 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	int64_t id;
															#line 777 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ClusterType clusterType;
															#line 782 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> oldEntryFuture;
															#line 783 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> newEntryFuture;
															#line 784 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Optional<Value> oldEntry;
															#line 785 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Optional<Value> newEntry;
															#line 824 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Error err;
															#line 7374 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantRenameCommand()
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantRenameCommandActor final : public Actor<bool>, public ActorCallback< TenantRenameCommandActor, 0, ClusterType >, public ActorCallback< TenantRenameCommandActor, 1, Void >, public ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >, public ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >, public ActorCallback< TenantRenameCommandActor, 4, Void >, public ActorCallback< TenantRenameCommandActor, 5, std::string >, public ActorCallback< TenantRenameCommandActor, 6, Void >, public FastAllocated<TenantRenameCommandActor>, public TenantRenameCommandActorState<TenantRenameCommandActor> {
															#line 7379 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantRenameCommandActor>::operator new;
	using FastAllocated<TenantRenameCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17202222787575556096UL, 13806253648929403904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantRenameCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantRenameCommandActor, 1, Void >;
friend struct ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >;
friend struct ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >;
friend struct ActorCallback< TenantRenameCommandActor, 4, Void >;
friend struct ActorCallback< TenantRenameCommandActor, 5, std::string >;
friend struct ActorCallback< TenantRenameCommandActor, 6, Void >;
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantRenameCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 7402 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantRenameCommandActorState<TenantRenameCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantRenameCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2736169111722183168UL, 11877146006844024064UL);
		ActorExecutionContextHelper __helper(static_cast<TenantRenameCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantRenameCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantRenameCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 5, std::string >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TenantRenameCommandActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantRenameCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 760 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantRenameCommandActor(db, tokens));
															#line 7440 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 838 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

															#line 7445 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
// This generated class is to be used only via tenantLockCommand()
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
template <class TenantLockCommandActor>
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantLockCommandActorState {
															#line 7451 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantLockCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		 : db(db),
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tokens(tokens),
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   uid(),
															#line 841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   tr(),
															#line 842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   name(),
															#line 843 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   nameKey(),
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   desiredLockState(),
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		   uidIdx()
															#line 7472 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantLockCommand", reinterpret_cast<unsigned long>(this));

	}
	~TenantLockCommandActorState() 
	{
		fdb_probe_actor_destroy("tenantLockCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 846 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens[1] == "lock"_sr && (tokens.size() < 3 || tokens.size() > 5))
															#line 7487 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 847 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Usage: tenant lock <NAME> [w|rw] [UID]\n\n");
															#line 848 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("Locks a tenant for read-write or read-only with a given UID.\n");
															#line 849 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("By default a read-write lock is created.\n");
															#line 850 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("If no UID is passed, fdbcli will generate one.\n");
															#line 851 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				fmt::print("UID has to be a 16-byte number represented in hex.\n");
															#line 852 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7501 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantLockCommandActorState();
				static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 853 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (tokens[1] == "unlock"_sr && tokens.size() != 4)
															#line 7511 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 854 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print("Usage: tenant unlock <NAME> <UID>\n\n");
															#line 855 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7517 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TenantLockCommandActorState();
					static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 857 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			name = tokens[2];
															#line 858 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			nameKey = tenantMapSpecialKeyRange.begin.withSuffix(name);
															#line 859 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens[1] == "unlock"_sr)
															#line 7530 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 860 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				uidIdx = 3;
															#line 861 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				desiredLockState = TenantAPI::TenantLockState::UNLOCKED;
															#line 7536 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			}
			else
			{
															#line 863 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				uidIdx = 4;
															#line 864 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (tokens.size() > 3)
															#line 7544 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 865 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (tokens[3] == "w"_sr)
															#line 7548 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					{
															#line 866 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
						desiredLockState = TenantAPI::TenantLockState::READ_ONLY;
															#line 7552 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					}
					else
					{
															#line 867 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
						if (tokens[3] == "rw"_sr)
															#line 7558 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
						{
															#line 868 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
							desiredLockState = TenantAPI::TenantLockState::LOCKED;
															#line 7562 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
						}
						else
						{
															#line 870 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
							fmt::print(stderr, "ERROR: Invalid lock type `{}'\n", tokens[3]);
															#line 871 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
							if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7570 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
							new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
							this->~TenantLockCommandActorState();
							static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
				else
				{
															#line 874 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					desiredLockState = TenantAPI::TenantLockState::LOCKED;
															#line 7582 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
			}
															#line 877 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (tokens.size() > uidIdx)
															#line 7587 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
				try {
															#line 879 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					auto uidStr = tokens[uidIdx].toString();
															#line 880 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					if (uidStr.size() < 32)
															#line 7594 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					{
															#line 883 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
						uidStr.insert(0, 32 - uidStr.size(), '0');
															#line 7598 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					}
															#line 885 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					uid = UID::fromStringThrowsOnFailure(uidStr);
															#line 7602 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
					loopDepth = a_body1cont16(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 892 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				ASSERT(desiredLockState != TenantAPI::TenantLockState::UNLOCKED);
															#line 893 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				uid = deterministicRandom()->randomUniqueID();
															#line 7617 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantLockCommandActorState();
		static_cast<TenantLockCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 895 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		tr = db->createTransaction();
															#line 896 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		;
															#line 7643 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 887 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			ASSERT(e.code() == error_code_operation_failed);
															#line 888 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: Couldn't not parse `{}' as a valid UID", tokens[uidIdx].toString());
															#line 889 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7663 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantLockCommandActorState();
			static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 898 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7706 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1cont1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 1;
															#line 899 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 0, ClusterType >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7711 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 921 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (e.code() == error_code_tenant_locked)
															#line 7733 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			{
															#line 922 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (desiredLockState == TenantAPI::TenantLockState::UNLOCKED)
															#line 7737 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				{
															#line 923 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print(stderr, "ERROR: Wrong lock UID\n");
															#line 7741 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
				else
				{
															#line 925 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
					fmt::print(stderr, "ERROR: Tenant locked with a different UID\n");
															#line 7747 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				}
															#line 927 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
				if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7751 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
				new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TenantLockCommandActorState();
				static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_5 = safeThreadFutureToFuture(tr->onError(e));
															#line 929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7761 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 6;
															#line 929 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 5, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7766 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ClusterType const& clusterType,int loopDepth) 
	{
															#line 900 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 7781 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::changeTenantLockState(db, name, desiredLockState, uid);
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7787 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 2;
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 1, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7792 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantFuture = tr->get(nameKey);
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(tenantFuture);
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7805 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 3;
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7810 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ClusterType && clusterType,int loopDepth) 
	{
															#line 900 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 7820 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::changeTenantLockState(db, name, desiredLockState, uid);
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7826 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 2;
															#line 901 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 1, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7831 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 903 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			tenantFuture = tr->get(nameKey);
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = safeThreadFutureToFuture(tenantFuture);
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 3;
															#line 905 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 7849 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ClusterType const& clusterType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(clusterType, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ClusterType && clusterType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(clusterType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 914 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (desiredLockState != TenantAPI::TenantLockState::UNLOCKED)
															#line 7934 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 915 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print("Locked tenant `{}' with UID `{}'\n", name.toString(), uid.toString());
															#line 7938 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
		else
		{
															#line 917 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print("Unlocked tenant `{}'\n", name.toString());
															#line 7944 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		}
															#line 919 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 7948 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TenantLockCommandActorState();
		static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont5(Optional<Value> const& entry,int loopDepth) 
	{
															#line 906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!entry.present())
															#line 8047 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: Tenant `{}' does not exist\n", name);
															#line 908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 8053 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantLockCommandActorState();
			static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		auto tenantId = getTenantId(entry.get());
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::changeLockState(tr.getPtr(), tenantId, desiredLockState, uid);
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8065 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 4;
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 3, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 8070 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Optional<Value> && entry,int loopDepth) 
	{
															#line 906 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (!entry.present())
															#line 8079 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		{
															#line 907 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			fmt::print(stderr, "ERROR: Tenant `{}' does not exist\n", name);
															#line 908 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
			if (!static_cast<TenantLockCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TenantLockCommandActorState(); static_cast<TenantLockCommandActor*>(this)->destroy(); return 0; }
															#line 8085 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
			new (&static_cast<TenantLockCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TenantLockCommandActorState();
			static_cast<TenantLockCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 910 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		auto tenantId = getTenantId(entry.get());
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::changeLockState(tr.getPtr(), tenantId, desiredLockState, uid);
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8097 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 4;
															#line 911 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 3, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 8102 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Optional<Value> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Optional<Value> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->commit());
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8188 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 5;
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 4, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 8193 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->commit());
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8204 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 5;
															#line 912 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantLockCommandActor, 4, Void >*>(static_cast<TenantLockCommandActor*>(this)));
															#line 8209 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantLockCommandActor*>(this)->actor_wait_state > 0) static_cast<TenantLockCommandActor*>(this)->actor_wait_state = 0;
		static_cast<TenantLockCommandActor*>(this)->ActorCallback< TenantLockCommandActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantLockCommandActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantLockCommandActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 840 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	UID uid;
															#line 841 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 842 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	StringRef name;
															#line 843 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	Key nameKey;
															#line 844 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantAPI::TenantLockState desiredLockState;
															#line 845 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	int uidIdx;
															#line 904 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	ThreadFuture<Optional<Value>> tenantFuture;
															#line 8481 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
};
// This generated class is to be used only via tenantLockCommand()
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
class TenantLockCommandActor final : public Actor<bool>, public ActorCallback< TenantLockCommandActor, 0, ClusterType >, public ActorCallback< TenantLockCommandActor, 1, Void >, public ActorCallback< TenantLockCommandActor, 2, Optional<Value> >, public ActorCallback< TenantLockCommandActor, 3, Void >, public ActorCallback< TenantLockCommandActor, 4, Void >, public ActorCallback< TenantLockCommandActor, 5, Void >, public FastAllocated<TenantLockCommandActor>, public TenantLockCommandActorState<TenantLockCommandActor> {
															#line 8486 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
public:
	using FastAllocated<TenantLockCommandActor>::operator new;
	using FastAllocated<TenantLockCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7833015050159474176UL, 468172057746257920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantLockCommandActor, 0, ClusterType >;
friend struct ActorCallback< TenantLockCommandActor, 1, Void >;
friend struct ActorCallback< TenantLockCommandActor, 2, Optional<Value> >;
friend struct ActorCallback< TenantLockCommandActor, 3, Void >;
friend struct ActorCallback< TenantLockCommandActor, 4, Void >;
friend struct ActorCallback< TenantLockCommandActor, 5, Void >;
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	TenantLockCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 8508 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
		 : Actor<bool>(),
		   TenantLockCommandActorState<TenantLockCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantLockCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1023135724604357632UL, 1161524578771731200UL);
		ActorExecutionContextHelper __helper(static_cast<TenantLockCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantLockCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantLockCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantLockCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantLockCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantLockCommandActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantLockCommandActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantLockCommandActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantLockCommandActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
[[nodiscard]] Future<bool> tenantLockCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 839 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"
	return Future<bool>(new TenantLockCommandActor(db, tokens));
															#line 8545 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/build_output/fdbcli/TenantCommands.actor.g.cpp"
}

#line 933 "/codebuild/output/src2323865134/src/github.com/apple/foundationdb/fdbcli/TenantCommands.actor.cpp"

// tenant command
Future<bool> tenantCommand(Reference<IDatabase> db, std::vector<StringRef> tokens) {
	if (tokens.size() == 1) {
		printUsage(tokens[0]);
		return true;
	} else if (tokencmp(tokens[1], "create")) {
		return tenantCreateCommand(db, tokens);
	} else if (tokencmp(tokens[1], "delete")) {
		return tenantDeleteCommand(db, tokens);
	} else if (tokencmp(tokens[1], "deleteId")) {
		return tenantDeleteIdCommand(db, tokens);
	} else if (tokencmp(tokens[1], "list")) {
		return tenantListCommand(db, tokens);
	} else if (tokencmp(tokens[1], "get")) {
		return tenantGetCommand(db, tokens);
	} else if (tokencmp(tokens[1], "getId")) {
		return tenantGetIdCommand(db, tokens);
	} else if (tokencmp(tokens[1], "configure")) {
		return tenantConfigureCommand(db, tokens);
	} else if (tokencmp(tokens[1], "rename")) {
		return tenantRenameCommand(db, tokens);
	} else if (tokencmp(tokens[1], "lock")) {
		return tenantLockCommand(db, tokens);
	} else if (tokencmp(tokens[1], "unlock")) {
		return tenantLockCommand(db, tokens);
	} else {
		printUsage(tokens[0]);
		return true;
	}
}

Future<bool> tenantCommandForwarder(Reference<IDatabase> db, std::vector<StringRef> tokens) {
	ASSERT(!tokens.empty() && (tokens[0].endsWith("tenant"_sr) || tokens[0].endsWith("tenants"_sr)));
	std::vector<StringRef> forwardedTokens = { "tenant"_sr,
		                                       tokens[0].endsWith("tenant"_sr) ? tokens[0].removeSuffix("tenant"_sr)
		                                                                       : tokens[0].removeSuffix("tenants"_sr) };
	for (int i = 1; i < tokens.size(); ++i) {
		forwardedTokens.push_back(tokens[i]);
	}

	return tenantCommand(db, forwardedTokens);
}

void tenantGenerator(const char* text,
                     const char* line,
                     std::vector<std::string>& lc,
                     std::vector<StringRef> const& tokens) {
	if (tokens.size() == 1) {
		const char* opts[] = { "create",    "delete", "deleteId", "list",   "get",
			                   "configure", "rename", "lock",     "unlock", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() >= 3 && tokencmp(tokens[1], "create")) {
		const char* opts[] = { "tenant_group=", "assigned_cluster=", "ignore_capacity_limit", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() == 3 && tokencmp(tokens[1], "get")) {
		const char* opts[] = { "JSON", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() == 3 && tokencmp(tokens[1], "getId")) {
		const char* opts[] = { "JSON", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() >= 4 && tokencmp(tokens[1], "list")) {
		const char* opts[] = { "limit=", "offset=", "state=", "tenant_group=", "JSON", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokencmp(tokens[1], "configure")) {
		if (tokens.size() == 3) {
			const char* opts[] = { "tenant_group=", "unset", nullptr };
			arrayGenerator(text, line, opts, lc);
		} else if (tokens.size() == 4 && tokencmp(tokens[3], "unset")) {
			const char* opts[] = { "tenant_group=", nullptr };
			arrayGenerator(text, line, opts, lc);
		} else if (tokens.size() == 4 + tokencmp(tokens[3], "unset")) {
			const char* opts[] = { "ignore_capacity_limit", nullptr };
			arrayGenerator(text, line, opts, lc);
		}
	} else if (tokencmp(tokens[1], "lock")) {
		if (tokens.size() == 3) {
			const char* opts[] = { "w", "rw", nullptr };
			arrayGenerator(text, line, opts, lc);
		}
	}
}

std::vector<const char*> tenantHintGenerator(std::vector<StringRef> const& tokens, bool inArgument) {
	if (tokens.size() == 1) {
		return { "<create|delete|deleteId|list|get|getId|configure|rename>", "[ARGS]" };
	} else if (tokencmp(tokens[1], "create") && tokens.size() < 5) {
		static std::vector<const char*> opts = {
			"<NAME>", "[tenant_group=<TENANT_GROUP>]", "[assigned_cluster=<CLUSTER_NAME>]", "[ignore_capacity_limit]"
		};
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "delete") && tokens.size() < 3) {
		static std::vector<const char*> opts = { "<NAME>" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "deleteId") && tokens.size() < 3) {
		static std::vector<const char*> opts = { "<ID>" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "list") && tokens.size() < 7) {
		static std::vector<const char*> opts = { "[BEGIN]",
			                                     "[END]",
			                                     "[limit=LIMIT]",
			                                     "[offset=OFFSET]",
			                                     "[state=<STATE1>,<STATE2>,...]",
			                                     "[tenant_group=TENANT_GROUP]",
			                                     "[JSON]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "get") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<NAME>", "[JSON]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "getId") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<ID>", "[JSON]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "configure")) {
		if (tokens.size() < 4) {
			static std::vector<const char*> opts = { "<TENANT_NAME>",
				                                     "<[unset] tenant_group[=<GROUP_NAME>]>",
				                                     "[ignore_capacity_limit]" };
			return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
		} else if ("unset"_sr.startsWith(tokens[3]) && tokens[3].size() <= 5) {
			if (tokens.size() < 6) {
				static std::vector<const char*> opts = { "<tenant_group[=<GROUP_NAME>]>", "[ignore_capacity_limit]" };
				return std::vector<const char*>(opts.begin() + tokens.size() - 4, opts.end());
			}
		} else if (tokens.size() == 4) {
			static std::vector<const char*> opts = { "[ignore_capacity_limit]" };
			return opts;
		}
		return {};
	} else if (tokencmp(tokens[1], "rename") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<OLD_NAME>", "<NEW_NAME>" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "lock") && tokens.size() < 5) {
		static std::vector<const char*> opts = { "<NAME>", "[w|rw]", "[UID]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "unlock") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<NAME>", "<UID>" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else {
		return {};
	}
}

CommandFactory tenantRegisterFactory(
    "tenant",
    CommandHelp("tenant <create|delete|list|get|getId|configure|rename|lock|unlock> [ARGS]",
                "view and manage tenants in a cluster or metacluster",
                "`create' and `delete' add and remove tenants from the cluster.\n"
                "`list' prints a list of tenants in the cluster.\n"
                "`get' prints the metadata for a particular tenant.\n"
                "`configure' modifies the configuration for a tenant.\n"
                "`rename' changes the name of a tenant.\n"
                "`lock` locks a tenant.\n"
                "`unlock` unlocks a tenant.\n"),
    &tenantGenerator,
    &tenantHintGenerator);

// Generate hidden commands for the old versions of the tenant commands
CommandFactory createTenantFactory("createtenant");
CommandFactory deleteTenantFactory("deletetenant");
CommandFactory listTenantsFactory("listtenants");
CommandFactory getTenantFactory("gettenant");
CommandFactory configureTenantFactory("configuretenant");
CommandFactory renameTenantFactory("renametenant");

} // namespace fdb_cli
