#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
/*
 * AsyncFileWrite.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "flow/SystemMonitor.h"
#include "flow/IAsyncFile.h"
#include "fdbserver/workloads/AsyncFile.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct AsyncFileWriteWorkload : public AsyncFileWorkload {
	static constexpr auto NAME = "AsyncFileWrite";
	// Buffer used to store what is being written
	Reference<AsyncFileBuffer> writeBuffer;

	// The futures for the asynchronous write futures
	std::vector<Future<Void>> writeFutures;

	// Number of writes to perform in parallel.  Write tests are performed only if this is greater than zero and
	// numParallelReads is zero
	int numParallelWrites;

	// The number of bytes written in each call of write
	int writeSize;

	// Whether or not writes should be performed sequentially
	bool sequential;

	double averageCpuUtilization;
	PerfIntCounter bytesWritten;

	AsyncFileWriteWorkload(WorkloadContext const& wcx)
	  : AsyncFileWorkload(wcx), writeBuffer(nullptr), bytesWritten("Bytes Written") {
		numParallelWrites = getOption(options, "numParallelWrites"_sr, 0);
		writeSize = getOption(options, "writeSize"_sr, _PAGE_SIZE);
		fileSize = getOption(options, "fileSize"_sr, 10002432);
		sequential = getOption(options, "sequential"_sr, true);
	}

	Future<Void> setup(Database const& cx) override {
		if (enabled)
			return _setup(this);

		return Void();
	}

																#line 66 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
template <class _setupActor>
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class _setupActorState {
															#line 72 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	_setupActorState(AsyncFileWriteWorkload* const& self) 
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		 : self(self)
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 66 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			if (self->unbufferedIO && self->writeSize % AsyncFileWorkload::_PAGE_SIZE != 0)
															#line 94 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			{
															#line 67 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
				self->writeSize = std::max(AsyncFileWorkload::_PAGE_SIZE, self->writeSize - self->writeSize % AsyncFileWorkload::_PAGE_SIZE);
															#line 98 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			}
															#line 71 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			self->writeBuffer = self->allocateBuffer(self->writeSize);
															#line 73 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			int64_t initialSize = self->fileSize;
															#line 74 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			if (self->sequential)
															#line 106 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			{
															#line 75 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
				initialSize = 0;
															#line 110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			}
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->openFile(self, IAsyncFile::OPEN_READWRITE, 0666, initialSize);
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = self->fileHandle->file->size();
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, int64_t >*>(static_cast<_setupActor*>(this)));
															#line 151 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = self->fileHandle->file->size();
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 162 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, int64_t >*>(static_cast<_setupActor*>(this)));
															#line 167 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int64_t const& fileSize,int loopDepth) 
	{
															#line 80 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (fileSize != 0)
															#line 251 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		{
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			self->fileSize = fileSize;
															#line 255 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		}
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 259 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && fileSize,int loopDepth) 
	{
															#line 80 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (fileSize != 0)
															#line 271 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		{
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			self->fileSize = fileSize;
															#line 275 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		}
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont4(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	AsyncFileWriteWorkload* self;
															#line 364 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, int64_t >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16081069946849195008UL, 12595629861658223616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, int64_t >;
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	_setupActor(AsyncFileWriteWorkload* const& self) 
															#line 387 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
[[nodiscard]] Future<Void> _setup( AsyncFileWriteWorkload* const& self ) {
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	return Future<Void>(new _setupActor(self));
															#line 420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
}

#line 85 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (enabled)
			return _start(this);

		return Void();
	}

																#line 432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
template <class _startActor>
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class _startActorState {
															#line 438 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	_startActorState(AsyncFileWriteWorkload* const& self) 
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		 : self(self),
															#line 94 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		   statState()
															#line 447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			customSystemMonitor("AsyncFile Metrics", &statState);
															#line 97 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->runWriteTest(self), self->testDuration, Void());
															#line 97 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 466 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 471 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		SystemStatistics stats = customSystemMonitor("AsyncFile Metrics", &statState);
															#line 100 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->averageCpuUtilization = stats.processCPUSeconds / stats.elapsed;
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout(waitForAll(self->writeFutures), 10, Void());
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 500 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 505 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		SystemStatistics stats = customSystemMonitor("AsyncFile Metrics", &statState);
															#line 100 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->averageCpuUtilization = stats.processCPUSeconds / stats.elapsed;
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout(waitForAll(self->writeFutures), 10, Void());
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 520 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	AsyncFileWriteWorkload* self;
															#line 94 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	StatisticsState statState;
															#line 708 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 713 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1062497502886967808UL, 5842096426775058688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	_startActor(AsyncFileWriteWorkload* const& self) 
															#line 731 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
[[nodiscard]] Future<Void> _start( AsyncFileWriteWorkload* const& self ) {
															#line 93 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	return Future<Void>(new _startActor(self));
															#line 764 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
}

#line 107 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"

																#line 769 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via runWriteTest()
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
template <class RunWriteTestActor>
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class RunWriteTestActorState {
															#line 775 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	RunWriteTestActorState(AsyncFileWriteWorkload* const& self) 
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		 : self(self),
															#line 109 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		   offset(self->fileSize),
															#line 110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		   prevSync(Void())
															#line 786 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runWriteTest", reinterpret_cast<unsigned long>(this));

	}
	~RunWriteTestActorState() 
	{
		fdb_probe_actor_destroy("runWriteTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			;
															#line 801 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunWriteTestActorState();
		static_cast<RunWriteTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		for(int i = 0;i < self->numParallelWrites;i++) {
															#line 116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			self->writeFutures.push_back(uncancellable(holdWhile( self->fileHandle, holdWhile(self->writeBuffer, self->fileHandle->file->write(self->writeBuffer->buffer, std::min((int64_t)self->writeSize, self->fileSize - offset), offset)))));
															#line 123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
			if (self->sequential)
															#line 835 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
			{
															#line 124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
				offset += self->writeSize;
															#line 127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
				if (offset >= self->fileSize)
															#line 841 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
				{
															#line 128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
					offset = 0;
															#line 845 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
				if (self->unbufferedIO)
															#line 852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
				{
															#line 130 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
					offset = (int64_t)(deterministicRandom()->random01() * (self->fileSize - 1) / AsyncFileWorkload::_PAGE_SIZE) * AsyncFileWorkload::_PAGE_SIZE;
															#line 856 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
				}
				else
				{
															#line 134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
					offset = (int64_t)(deterministicRandom()->random01() * (self->fileSize - 1));
															#line 862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
				}
			}
		}
															#line 137 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(self->writeFutures);
															#line 137 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<RunWriteTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunWriteTestActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunWriteTestActor, 0, Void >*>(static_cast<RunWriteTestActor*>(this)));
															#line 875 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = prevSync;
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<RunWriteTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 886 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunWriteTestActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunWriteTestActor, 1, Void >*>(static_cast<RunWriteTestActor*>(this)));
															#line 891 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = prevSync;
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		if (static_cast<RunWriteTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunWriteTestActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunWriteTestActor, 1, Void >*>(static_cast<RunWriteTestActor*>(this)));
															#line 907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunWriteTestActor*>(this)->actor_wait_state > 0) static_cast<RunWriteTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunWriteTestActor*>(this)->ActorCallback< RunWriteTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWriteTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunWriteTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunWriteTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		prevSync = self->fileHandle->file->sync();
															#line 141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->writeFutures.clear();
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->bytesWritten += self->writeSize * self->numParallelWrites;
															#line 995 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		prevSync = self->fileHandle->file->sync();
															#line 141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->writeFutures.clear();
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
		self->bytesWritten += self->writeSize * self->numParallelWrites;
															#line 1008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunWriteTestActor*>(this)->actor_wait_state > 0) static_cast<RunWriteTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunWriteTestActor*>(this)->ActorCallback< RunWriteTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWriteTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunWriteTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunWriteTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	AsyncFileWriteWorkload* self;
															#line 109 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	int64_t offset;
															#line 110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	Future<Void> prevSync;
															#line 1094 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runWriteTest()
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
class RunWriteTestActor final : public Actor<Void>, public ActorCallback< RunWriteTestActor, 0, Void >, public ActorCallback< RunWriteTestActor, 1, Void >, public FastAllocated<RunWriteTestActor>, public RunWriteTestActorState<RunWriteTestActor> {
															#line 1099 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunWriteTestActor>::operator new;
	using FastAllocated<RunWriteTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(942094492662984704UL, 13184147964675329792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunWriteTestActor, 0, Void >;
friend struct ActorCallback< RunWriteTestActor, 1, Void >;
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	RunWriteTestActor(AsyncFileWriteWorkload* const& self) 
															#line 1117 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunWriteTestActorState<RunWriteTestActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runWriteTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(623858871605325824UL, 15401090166565925632UL);
		ActorExecutionContextHelper __helper(static_cast<RunWriteTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runWriteTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runWriteTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunWriteTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunWriteTestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
[[nodiscard]] Future<Void> runWriteTest( AsyncFileWriteWorkload* const& self ) {
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"
	return Future<Void>(new RunWriteTestActor(self));
															#line 1150 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileWrite.actor.g.cpp.py_gen"
}

#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileWrite.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (enabled) {
			m.emplace_back("Bytes written/sec", bytesWritten.getValue() / testDuration, Averaged::False);
			m.emplace_back("Average CPU Utilization (Percentage)", averageCpuUtilization * 100, Averaged::False);
		}
	}
};

WorkloadFactory<AsyncFileWriteWorkload> AsyncFileWriteWorkloadFactory;
