#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
/*
 * CoroFlow.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/CoroFlow.h"
#include "flow/ActorCollection.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include <boost/coroutine2/all.hpp>
#include <boost/coroutine2/coroutine.hpp>
#include <functional>
#include "flow/flow.h"
#include "flow/network.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // has to be last include

using coro_t = boost::coroutines2::coroutine<Future<Void>>;

// Coro *current_coro = 0, *main_coro = 0;
// Coro* swapCoro( Coro* n ) {
// 	Coro* t = current_coro;
// 	current_coro = n;
// 	return t;
// }

/*struct IThreadlike {
public:
    virtual void start() = 0;     // Call at most once!  Causes run() to be called on the 'thread'.
    virtual ~IThreadlike() {}     // Pre: start hasn't been called, or run() has returned
    virtual void unblock() = 0;   // Pre: block() has been called by run().  Causes block() to return.

protected:
    virtual void block() = 0;     // Call only from run().  Returns when unblock() is called elsewhere.
    virtual void run() = 0;       // To be overridden by client.  Returning causes the thread to block until it is
destroyed.
};*/

struct Coroutine;
Coroutine* current_coro;

struct Coroutine /*: IThreadlike*/ {
	Coroutine() = default;
	~Coroutine() { *alive = false; }

	static constexpr auto kStackSize = 32 * (1 << 10);

	void start() {
		coro.reset(new coro_t::pull_type(boost::coroutines2::fixedsize_stack(kStackSize),
		                                 [this](coro_t::push_type& sink) { entry(sink); }));
		switcher(this);
	}

	void unblock() {
		// Coro_switchTo_( swapCoro(coro), coro );

		// Copy blocked before calling send, since the call to send might destroy it.
		auto b = blocked;
		b.send(Void());
	}

	void waitFor(Future<Void> const& what) {
		ASSERT(current_coro == this);
		current_coro = nullptr;
		(*sink)(what); // Pass control back to the switcher actor
		ASSERT(what.isReady());
		current_coro = this;
	}

protected:
																#line 89 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
// This generated class is to be used only via switcher()
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
template <class SwitcherActor>
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class SwitcherActorState {
															#line 95 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	SwitcherActorState(Coroutine* const& self) 
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		 : self(self),
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		   alive(self->alive)
															#line 104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("switcher", reinterpret_cast<unsigned long>(this));

	}
	~SwitcherActorState() 
	{
		fdb_probe_actor_destroy("switcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			;
															#line 119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<SwitcherActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 89 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		if (!(*alive && *self->coro))
															#line 154 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->coro->get();
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 163 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			static_cast<SwitcherActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitcherActor, 0, Void >*>(static_cast<SwitcherActor*>(this)));
															#line 167 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		(*self->coro)();
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, g_network->getCurrentTask());
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		static_cast<SwitcherActor*>(this)->actor_wait_state = 2;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitcherActor, 1, Void >*>(static_cast<SwitcherActor*>(this)));
															#line 203 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitcherActor*>(this)->actor_wait_state > 0) static_cast<SwitcherActor*>(this)->actor_wait_state = 0;
		static_cast<SwitcherActor*>(this)->ActorCallback< SwitcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SwitcherActor*>(this)->actor_wait_state > 0) static_cast<SwitcherActor*>(this)->actor_wait_state = 0;
		static_cast<SwitcherActor*>(this)->ActorCallback< SwitcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		delete static_cast<SwitcherActor*>(this);
															#line 412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	Coroutine* self;
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	std::shared_ptr<bool> alive;
															#line 421 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
};
// This generated class is to be used only via switcher()
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class SwitcherActor final : public Actor<void>, public ActorCallback< SwitcherActor, 0, Void >, public ActorCallback< SwitcherActor, 1, Void >, public FastAllocated<SwitcherActor>, public SwitcherActorState<SwitcherActor> {
															#line 426 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
	using FastAllocated<SwitcherActor>::operator new;
	using FastAllocated<SwitcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7366933717498325504UL, 10162506643150352384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< SwitcherActor, 0, Void >;
friend struct ActorCallback< SwitcherActor, 1, Void >;
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	SwitcherActor(Coroutine* const& self) 
															#line 444 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   SwitcherActorState<SwitcherActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2155695165987439872UL, 6007550310086936064UL);
		ActorExecutionContextHelper __helper(static_cast<SwitcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switcher", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
static void switcher( Coroutine* const& self ) {
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	new SwitcherActor(self);
															#line 467 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
}

#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"

	void entry(coro_t::push_type& sink) {
		current_coro = this;
		this->sink = &sink;
		run();
	}

	void block() {
		// Coro_switchTo_( swapCoro(main_coro), main_coro );
		blocked = Promise<Void>();
		double before = now();
		CoroThreadPool::waitFor(blocked.getFuture());
		if (g_network->isSimulated() && g_simulator->getCurrentProcess()->rebooting)
			TraceEvent("CoroUnblocked").detail("After", now() - before);
	}

	virtual void run() = 0;

private:
	coro_t::push_type* sink;
	Promise<Void> blocked;
	std::shared_ptr<bool> alive{ std::make_shared<bool>(true) };
	std::unique_ptr<coro_t::pull_type> coro;
};

template <class Threadlike, class Mutex, bool IS_CORO>
class WorkPool final : public IThreadPool, public ReferenceCounted<WorkPool<Threadlike, Mutex, IS_CORO>> {
	struct Worker;

	// Pool can survive the destruction of WorkPool while it waits for workers to terminate
	struct Pool : ReferenceCounted<Pool> {
		Mutex queueLock;
		Deque<PThreadAction> work;
		std::vector<Worker*> idle, workers;
		ActorCollection anyError, allStopped;
		Future<Void> m_holdRefUntilStopped;

		Pool() : anyError(false), allStopped(true) { m_holdRefUntilStopped = holdRefUntilStopped(this); }

		~Pool() {
			for (int c = 0; c < workers.size(); c++)
				delete workers[c];
		}

																	#line 515 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
// This generated class is to be used only via holdRefUntilStopped()
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
template <class HoldRefUntilStoppedActor>
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class HoldRefUntilStoppedActorState {
															#line 521 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	HoldRefUntilStoppedActorState(Pool* const& p) 
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		 : p(p)
															#line 528 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("holdRefUntilStopped", reinterpret_cast<unsigned long>(this));

	}
	~HoldRefUntilStoppedActorState() 
	{
		fdb_probe_actor_destroy("holdRefUntilStopped", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			p->addref();
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			StrictFuture<Void> __when_expr_0 = p->allStopped.getResult();
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			if (static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 547 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state = 1;
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldRefUntilStoppedActor, 0, Void >*>(static_cast<HoldRefUntilStoppedActor*>(this)));
															#line 552 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		p->delref();
															#line 147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		if (!static_cast<HoldRefUntilStoppedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldRefUntilStoppedActorState(); static_cast<HoldRefUntilStoppedActor*>(this)->destroy(); return 0; }
															#line 577 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		new (&static_cast<HoldRefUntilStoppedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		p->delref();
															#line 147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		if (!static_cast<HoldRefUntilStoppedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldRefUntilStoppedActorState(); static_cast<HoldRefUntilStoppedActor*>(this)->destroy(); return 0; }
															#line 591 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		new (&static_cast<HoldRefUntilStoppedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldRefUntilStoppedActorState();
		static_cast<HoldRefUntilStoppedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state > 0) static_cast<HoldRefUntilStoppedActor*>(this)->actor_wait_state = 0;
		static_cast<HoldRefUntilStoppedActor*>(this)->ActorCallback< HoldRefUntilStoppedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldRefUntilStoppedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	Pool* p;
															#line 676 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
};
// This generated class is to be used only via holdRefUntilStopped()
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class HoldRefUntilStoppedActor final : public Actor<Void>, public ActorCallback< HoldRefUntilStoppedActor, 0, Void >, public FastAllocated<HoldRefUntilStoppedActor>, public HoldRefUntilStoppedActorState<HoldRefUntilStoppedActor> {
															#line 681 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
	using FastAllocated<HoldRefUntilStoppedActor>::operator new;
	using FastAllocated<HoldRefUntilStoppedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13553588787387405568UL, 4510719759886889984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldRefUntilStoppedActor, 0, Void >;
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	HoldRefUntilStoppedActor(Pool* const& p) 
															#line 698 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HoldRefUntilStoppedActorState<HoldRefUntilStoppedActor>(p),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10458263095740810496UL, 16562495286564435456UL);
		ActorExecutionContextHelper __helper(static_cast<HoldRefUntilStoppedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdRefUntilStopped");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdRefUntilStopped", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldRefUntilStoppedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
[[nodiscard]] Future<Void> holdRefUntilStopped( Pool* const& p ) {
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	return Future<Void>(new HoldRefUntilStoppedActor(p));
															#line 730 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
}

#line 149 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	};

	struct Worker final : Threadlike {
		Pool* pool;
		IThreadPoolReceiver* userData;
		bool stop;
		ThreadReturnPromise<Void> stopped;
		ThreadReturnPromise<Void> error;

		Worker(Pool* pool, IThreadPoolReceiver* userData) : pool(pool), userData(userData), stop(false) {}

		void run() override {
			try {
				if (!stop)
					userData->init();

				while (!stop) {
					pool->queueLock.enter();
					if (pool->work.empty()) {
						pool->idle.push_back(this);
						pool->queueLock.leave();
						Threadlike::block();
					} else {
						PThreadAction a = pool->work.front();
						pool->work.pop_front();
						pool->queueLock.leave();
						(*a)(userData);
						if (IS_CORO)
							CoroThreadPool::waitFor(yield());
					}
				}

				TraceEvent("CoroStop").log();
				delete userData;
				stopped.send(Void());
				return;
			} catch (Error& e) {
				TraceEvent("WorkPoolError").errorUnsuppressed(e);
				error.sendError(e);
			} catch (...) {
				TraceEvent("WorkPoolError").log();
				error.sendError(unknown_error());
			}

			try {
				delete userData;
			} catch (...) {
				TraceEvent(SevError, "WorkPoolErrorShutdownError").log();
			}
			stopped.send(Void());
		}
	};

	Reference<Pool> pool;
	Future<Void> m_stopOnError; // must be last, because its cancellation calls stop()!
	Error error;

																#line 791 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
// This generated class is to be used only via stopOnError()
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
template <class StopOnErrorActor>
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class StopOnErrorActorState {
															#line 797 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	StopOnErrorActorState(WorkPool* const& w) 
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		 : w(w)
															#line 804 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("stopOnError", reinterpret_cast<unsigned long>(this));

	}
	~StopOnErrorActorState() 
	{
		fdb_probe_actor_destroy("stopOnError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
				StrictFuture<Void> __when_expr_0 = w->getError();
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
				if (static_cast<StopOnErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 822 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StopOnErrorActor*>(this)->actor_wait_state = 1;
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopOnErrorActor, 0, Void >*>(static_cast<StopOnErrorActor*>(this)));
															#line 827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopOnErrorActorState();
		static_cast<StopOnErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		if (!static_cast<StopOnErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StopOnErrorActorState(); static_cast<StopOnErrorActor*>(this)->destroy(); return 0; }
															#line 856 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		new (&static_cast<StopOnErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StopOnErrorActorState();
		static_cast<StopOnErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			w->stop(e);
															#line 869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		ASSERT(false);
															#line 884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		ASSERT(false);
															#line 893 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopOnErrorActor*>(this)->actor_wait_state > 0) static_cast<StopOnErrorActor*>(this)->actor_wait_state = 0;
		static_cast<StopOnErrorActor*>(this)->ActorCallback< StopOnErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StopOnErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopOnErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopOnErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	WorkPool* w;
															#line 988 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
};
// This generated class is to be used only via stopOnError()
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class StopOnErrorActor final : public Actor<Void>, public ActorCallback< StopOnErrorActor, 0, Void >, public FastAllocated<StopOnErrorActor>, public StopOnErrorActorState<StopOnErrorActor> {
															#line 993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
	using FastAllocated<StopOnErrorActor>::operator new;
	using FastAllocated<StopOnErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1272087119979599616UL, 17234929238478524160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StopOnErrorActor, 0, Void >;
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	StopOnErrorActor(WorkPool* const& w) 
															#line 1010 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StopOnErrorActorState<StopOnErrorActor>(w),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stopOnError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17814525371531013120UL, 5797053966738890240UL);
		ActorExecutionContextHelper __helper(static_cast<StopOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopOnError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopOnError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopOnErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
[[nodiscard]] Future<Void> stopOnError( WorkPool* const& w ) {
															#line 206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	return Future<Void>(new StopOnErrorActor(w));
															#line 1042 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
}

#line 215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"

	void checkError() {
		if (error.code() != invalid_error_code) {
			ASSERT(error.code() != error_code_success); // Calling post or addThread after stop is an error
			throw error;
		}
	}

public:
	WorkPool() : pool(new Pool) { m_stopOnError = stopOnError(this); }

	Future<Void> getError() const override { return pool->anyError.getResult(); }
	void addThread(IThreadPoolReceiver* userData, const char*) override {
		checkError();

		auto w = new Worker(pool.getPtr(), userData);
		pool->queueLock.enter();
		pool->workers.push_back(w);
		pool->queueLock.leave();
		pool->anyError.add(w->error.getFuture());
		pool->allStopped.add(w->stopped.getFuture());
		startWorker(w);
	}
																#line 1069 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
// This generated class is to be used only via startWorker()
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
template <class StartWorkerActor>
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class StartWorkerActorState {
															#line 1075 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	StartWorkerActorState(Worker* const& w) 
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		 : w(w)
															#line 1082 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startWorker", reinterpret_cast<unsigned long>(this));

	}
	~StartWorkerActorState() 
	{
		fdb_probe_actor_destroy("startWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 241 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, g_network->getCurrentTask());
															#line 241 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1099 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			static_cast<StartWorkerActor*>(this)->actor_wait_state = 1;
															#line 241 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartWorkerActor, 0, Void >*>(static_cast<StartWorkerActor*>(this)));
															#line 1103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<StartWorkerActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		w->start();
															#line 1125 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		w->start();
															#line 1134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartWorkerActor*>(this)->actor_wait_state > 0) static_cast<StartWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<StartWorkerActor*>(this)->ActorCallback< StartWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
		delete static_cast<StartWorkerActor*>(this);
															#line 1218 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	Worker* w;
															#line 1225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startWorker()
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
class StartWorkerActor final : public Actor<void>, public ActorCallback< StartWorkerActor, 0, Void >, public FastAllocated<StartWorkerActor>, public StartWorkerActorState<StartWorkerActor> {
															#line 1230 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartWorkerActor>::operator new;
	using FastAllocated<StartWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7017181008951356416UL, 11702886339476521984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< StartWorkerActor, 0, Void >;
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	StartWorkerActor(Worker* const& w) 
															#line 1247 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   StartWorkerActorState<StartWorkerActor>(w),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3882448018856564480UL, 10602434915089516544UL);
		ActorExecutionContextHelper __helper(static_cast<StartWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startWorker", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
static void startWorker( Worker* const& w ) {
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	new StartWorkerActor(w);
															#line 1270 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbserver/coroimpl/CoroFlow.actor.g.cpp.py_gen"
}

#line 244 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbserver/coroimpl/CoroFlow.actor.cpp"
	void post(PThreadAction action) override {
		checkError();

		pool->queueLock.enter();
		pool->work.push_back(action);
		if (!pool->idle.empty()) {
			Worker* c = pool->idle.back();
			pool->idle.pop_back();
			pool->queueLock.leave();
			c->unblock();
		} else
			pool->queueLock.leave();
	}
	Future<Void> stop(Error const& e) override {
		if (error.code() == invalid_error_code) {
			error = e;
		}

		pool->queueLock.enter();
		TraceEvent("WorkPool_Stop")
		    .errorUnsuppressed(e)
		    .detail("Workers", pool->workers.size())
		    .detail("Idle", pool->idle.size())
		    .detail("Work", pool->work.size());

		for (uint32_t i = 0; i < pool->work.size(); i++)
			pool->work[i]->cancel(); // What if cancel() does something to this?
		pool->work.clear();
		for (int i = 0; i < pool->workers.size(); i++)
			pool->workers[i]->stop = true;

		std::vector<Worker*> idle;
		std::swap(idle, pool->idle);
		pool->queueLock.leave();

		for (int i = 0; i < idle.size(); i++)
			idle[i]->unblock();

		pool->allStopped.add(Void());

		return pool->allStopped.getResult();
	}
	bool isCoro() const override { return IS_CORO; }
	void addref() override { ReferenceCounted<WorkPool>::addref(); }
	void delref() override { ReferenceCounted<WorkPool>::delref(); }
};

typedef WorkPool<Coroutine, ThreadUnsafeSpinLock, true> CoroPool;

void CoroThreadPool::waitFor(Future<Void> what) {
	ASSERT(current_coro != nullptr);
	if (what.isReady())
		return;
	// double t = now();
	current_coro->waitFor(what);
	what.get(); // Throw if |what| is an error
}

// Right After INet2::run
void CoroThreadPool::init() {}

Reference<IThreadPool> CoroThreadPool::createThreadPool() {
	return Reference<IThreadPool>(new CoroPool);
}
