#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
/*
 * NativeAPI.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"

#include <algorithm>
#include <cstdio>
#include <iterator>
#include <limits>
#include <memory>
#include <regex>
#include <string>
#include <unordered_set>
#include <tuple>
#include <utility>
#include <vector>

#include "boost/algorithm/string.hpp"

#include "fdbclient/Knobs.h"
#include "flow/CodeProbe.h"
#include "fmt/format.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/MultiInterface.h"

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/AnnotateActor.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbclient/ClusterConnectionFile.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/IKnobCollection.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NameLineage.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/ParallelStream.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/versions.h"
#include "fdbrpc/WellKnownEndpoints.h"
#include "fdbrpc/LoadBalance.h"
#include "fdbrpc/Net2FileSystem.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/sim_validation.h"
#include "flow/Arena.h"
#include "flow/ActorCollection.h"
#include "flow/DeterministicRandom.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/GetSourceVersion.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/ProtocolVersion.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/Knobs.h"
#include "flow/Platform.h"
#include "flow/SystemMonitor.h"
#include "flow/TLSConfig.actor.h"
#include "fdbclient/Tracing.h"
#include "flow/UnitTest.h"
#include "flow/network.h"
#include "flow/serialize.h"

#ifdef ADDRESS_SANITIZER
#include <sanitizer/lsan_interface.h>
#endif

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#undef min
#undef max
#else
#include <time.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

template class RequestStream<OpenDatabaseRequest, false>;
template struct NetNotifiedQueue<OpenDatabaseRequest, false>;

namespace {

TransactionLineageCollector transactionLineageCollector;
NameLineageCollector nameLineageCollector;

} // namespace

FDB_BOOLEAN_PARAM(TransactionRecordLogInfo);

NetworkOptions networkOptions;
TLSConfig tlsConfig(TLSEndpointType::CLIENT);

// The default values, TRACE_DEFAULT_ROLL_SIZE and TRACE_DEFAULT_MAX_LOGS_SIZE are located in Trace.h.
NetworkOptions::NetworkOptions()
  : traceRollSize(TRACE_DEFAULT_ROLL_SIZE), traceMaxLogsSize(TRACE_DEFAULT_MAX_LOGS_SIZE), traceLogGroup("default"),
    traceFormat("xml"), traceClockSource("now"), traceInitializeOnSetup(false),
    supportedVersions(new ReferencedObject<Standalone<VectorRef<ClientVersionRef>>>()), runLoopProfilingEnabled(false),
    primaryClient(true) {}

template <>
void addref(DatabaseContext* ptr) {
	ptr->addref();
}
template <>
void delref(DatabaseContext* ptr) {
	ptr->delref();
}

															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via refreshTransaction()
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class RefreshTransactionActor>
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActorState {
															#line 151 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActorState(DatabaseContext* const& self,Transaction* const& tr) 
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : self(self),
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(tr)
															#line 160 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RefreshTransactionActorState() 
	{
		fdb_probe_actor_destroy("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			*tr = Transaction();
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 1;
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshTransactionActor, 0, Void >*>(static_cast<RefreshTransactionActor*>(this)));
															#line 184 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state > 0) static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshTransactionActor*>(this)->ActorCallback< RefreshTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction* tr;
															#line 310 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via refreshTransaction()
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActor final : public Actor<Void>, public ActorCallback< RefreshTransactionActor, 0, Void >, public FastAllocated<RefreshTransactionActor>, public RefreshTransactionActorState<RefreshTransactionActor> {
															#line 315 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<RefreshTransactionActor>::operator new;
	using FastAllocated<RefreshTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15401139198178724352UL, 6813294384903292160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshTransactionActor, 0, Void >;
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActor(DatabaseContext* const& self,Transaction* const& tr) 
															#line 332 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RefreshTransactionActorState<RefreshTransactionActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4345345362439766272UL, 3425069992022049280UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> refreshTransaction( DatabaseContext* const& self, Transaction* const& tr ) {
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new RefreshTransactionActor(self, tr));
															#line 365 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// FIXME: get a prototype in a header file, ugh.
															#line 371 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
[[nodiscard]] Future<RangeResult> getWorkerInterfaces( Reference<IClusterConnectionRecord> const& clusterRecord );

#line 151 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Optional<KeyRangeLocationInfo> DatabaseContext::getCachedLocation(const KeyRef& key, Reverse isBackward) {
	Arena arena;

	auto range = isBackward ? locationCache.rangeContainingKeyBefore(key) : locationCache.rangeContaining(key);
	if (range->value()) {
		return KeyRangeLocationInfo(range->range(), range->value());
	}

	return Optional<KeyRangeLocationInfo>();
}

bool DatabaseContext::getCachedLocations(const KeyRangeRef& range,
                                         std::vector<KeyRangeLocationInfo>& result,
                                         int limit,
                                         Reverse reverse) {
	result.clear();

	Arena arena;

	auto begin = locationCache.rangeContaining(range.begin);
	auto end = locationCache.rangeContainingKeyBefore(range.end);

	loop {
		auto r = reverse ? end : begin;
		if (!r->value()) {
			CODE_PROBE(result.size(), "had some but not all cached locations");
			result.clear();
			return false;
		}
		result.emplace_back((r->range() & range), r->value());
		if (result.size() == limit || begin == end) {
			break;
		}

		if (reverse)
			--end;
		else
			++begin;
	}

	return true;
}

Reference<LocationInfo> DatabaseContext::setCachedLocation(const KeyRangeRef& absoluteKeys,
                                                           const std::vector<StorageServerInterface>& servers) {
	std::vector<Reference<ReferencedInterface<StorageServerInterface>>> serverRefs;
	serverRefs.reserve(servers.size());
	for (const auto& interf : servers) {
		serverRefs.push_back(StorageServerInfo::getInterface(this, interf, clientLocality));
	}

	int maxEvictionAttempts = 100, attempts = 0;
	auto loc = makeReference<LocationInfo>(serverRefs);
	while (locationCache.size() > locationCacheSize && attempts < maxEvictionAttempts) {
		CODE_PROBE(true, "NativeAPI storage server locationCache entry evicted");
		attempts++;
		auto r = locationCache.randomRange();
		Key begin = r.begin(), end = r.end(); // insert invalidates r, so can't be passed a mere reference into it
		locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
	}
	locationCache.insert(absoluteKeys, loc);
	return loc;
}

void DatabaseContext::invalidateCache(const KeyRef& key, Reverse isBackward) {
	Arena arena;
	KeyRef resolvedKey = key;

	if (isBackward) {
		locationCache.rangeContainingKeyBefore(resolvedKey)->value() = Reference<LocationInfo>();
	} else {
		locationCache.rangeContaining(resolvedKey)->value() = Reference<LocationInfo>();
	}
}

void DatabaseContext::invalidateCache(const KeyRangeRef& keys) {
	Arena arena;

	auto rs = locationCache.intersectingRanges(keys);
	Key begin = rs.begin().begin(),
	    end = rs.end().begin(); // insert invalidates rs, so can't be passed a mere reference into it
	locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
}

void DatabaseContext::setFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		failedEndpointsOnHealthyServersInfo[endpoint] =
		    EndpointFailureInfo{ .startTime = now(), .lastRefreshTime = now() };
	}
}

void DatabaseContext::updateFailedEndpointRefreshTime(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		// The endpoint is not failed. Nothing to update.
		return;
	}
	failedEndpointsOnHealthyServersInfo[endpoint].lastRefreshTime = now();
}

Optional<EndpointFailureInfo> DatabaseContext::getEndpointFailureInfo(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		return Optional<EndpointFailureInfo>();
	}
	return failedEndpointsOnHealthyServersInfo[endpoint];
}

void DatabaseContext::clearFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	failedEndpointsOnHealthyServersInfo.erase(endpoint);
}

Future<Void> DatabaseContext::onProxiesChanged() {
	backoffDelay = 0.0;
	return this->proxiesChangeTrigger.onTrigger();
}

bool DatabaseContext::sampleReadTags() const {
	double sampleRate = globalConfig->get(transactionTagSampleRate, CLIENT_KNOBS->READ_TAG_SAMPLE_RATE);
	return sampleRate > 0 && deterministicRandom()->random01() <= sampleRate;
}

bool DatabaseContext::sampleOnCost(uint64_t cost) const {
	double sampleCost = globalConfig->get<double>(transactionTagSampleCost, CLIENT_KNOBS->COMMIT_SAMPLE_COST);
	if (sampleCost <= 0)
		return false;
	return deterministicRandom()->random01() <= (double)cost / sampleCost;
}

void validateOptionValuePresent(Optional<StringRef> value) {
	if (!value.present()) {
		throw invalid_option_value();
	}
}

void validateOptionValueNotPresent(Optional<StringRef> value) {
	if (value.present() && value.get().size() > 0) {
		throw invalid_option_value();
	}
}

int64_t extractIntOption(Optional<StringRef> value, int64_t minValue, int64_t maxValue) {
	validateOptionValuePresent(value);
	if (value.get().size() != 8) {
		throw invalid_option_value();
	}

	int64_t passed = *((int64_t*)(value.get().begin()));
	if (passed > maxValue || passed < minValue) {
		throw invalid_option_value();
	}

	return passed;
}

uint64_t extractHexOption(StringRef value) {
	char* end;
	uint64_t id = strtoull(value.toString().c_str(), &end, 16);
	if (*end)
		throw invalid_option_value();
	return id;
}

void DatabaseContext::setOption(FDBDatabaseOptions::Option option, Optional<StringRef> value) {
	int defaultFor = FDBDatabaseOptions::optionInfo.getMustExist(option).defaultFor;
	if (defaultFor >= 0) {
		ASSERT(FDBTransactionOptions::optionInfo.find((FDBTransactionOptions::Option)defaultFor) !=
		       FDBTransactionOptions::optionInfo.end());
		TraceEvent(SevDebug, "DatabaseContextSetPersistentOption").detail("Option", option).detail("Value", value);
		transactionDefaults.addOption((FDBTransactionOptions::Option)defaultFor, value.castTo<Standalone<StringRef>>());
	} else {
		switch (option) {
		case FDBDatabaseOptions::LOCATION_CACHE_SIZE:
			locationCacheSize = (int)extractIntOption(value, 0, std::numeric_limits<int>::max());
			break;
		case FDBDatabaseOptions::MACHINE_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>(),
			                 clientLocality.machineId(),
			                 clientLocality.dcId());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::MAX_WATCHES:
			maxOutstandingWatches = (int)extractIntOption(value, 0, CLIENT_KNOBS->ABSOLUTE_MAX_WATCHES);
			break;
		case FDBDatabaseOptions::DATACENTER_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 clientLocality.zoneId(),
			                 clientLocality.machineId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_ENABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled++;
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_DISABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled--;
			break;
		case FDBDatabaseOptions::USE_CONFIG_DATABASE:
			validateOptionValueNotPresent(value);
			useConfigDatabase = true;
			break;
		case FDBDatabaseOptions::TEST_CAUSAL_READ_RISKY:
			verifyCausalReadsProp = double(extractIntOption(value, 0, 100)) / 100.0;
			break;
		default:
			break;
		}
	}
}

void DatabaseContext::increaseWatchCounter() {
	if (outstandingWatches >= maxOutstandingWatches)
		throw too_many_watches();

	++outstandingWatches;
}

void DatabaseContext::decreaseWatchCounter() {
	--outstandingWatches;
	ASSERT(outstandingWatches >= 0);
}

Future<Void> DatabaseContext::onConnected() const {
	return connected;
}

															#line 615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SwitchConnectionRecordImplActor>
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActorState {
															#line 622 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActorState(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : connRecord(connRecord),
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   self(self)
															#line 631 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	~SwitchConnectionRecordImplActorState() 
	{
		fdb_probe_actor_destroy("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 393 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Switch connection file");
															#line 394 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecord") .detail("ClusterFile", connRecord->toString()) .detail("ConnectionString", connRecord->getConnectionString().toString());
															#line 399 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->commitProxies.clear();
															#line 400 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->grvProxies.clear();
															#line 401 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->minAcceptableReadVersion = std::numeric_limits<Version>::max();
															#line 402 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->invalidateCache(allKeys);
															#line 404 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->ssVersionVectorCache.clear();
															#line 406 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto clearedClientInfo = self->clientInfo->get();
															#line 407 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.commitProxies.clear();
															#line 408 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.grvProxies.clear();
															#line 409 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.id = deterministicRandom()->randomUniqueID();
															#line 410 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->clientInfo->set(clearedClientInfo);
															#line 411 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->connectionRecord->set(connRecord);
															#line 413 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			db = Database(Reference<DatabaseContext>::addRef(self));
															#line 414 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(db);
															#line 415 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 676 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 416 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 706 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 418 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordAttemptingGRV").log();
															#line 419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 714 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 1;
															#line 419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 719 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 427 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordError").detail("Error", e.what());
															#line 428 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 428 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 745 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 2;
															#line 428 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 750 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 424 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 771 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 424 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 789 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 413 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database db;
															#line 414 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 967 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActor final : public Actor<Void>, public ActorCallback< SwitchConnectionRecordImplActor, 0, Version >, public ActorCallback< SwitchConnectionRecordImplActor, 1, Void >, public FastAllocated<SwitchConnectionRecordImplActor>, public SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor> {
															#line 972 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<SwitchConnectionRecordImplActor>::operator new;
	using FastAllocated<SwitchConnectionRecordImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15842832385095849728UL, 8033091920761186048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwitchConnectionRecordImplActor, 0, Version >;
friend struct ActorCallback< SwitchConnectionRecordImplActor, 1, Void >;
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActor(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 990 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor>(connRecord, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7312653141277564928UL, 2692131377335283456UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchConnectionRecordImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> switchConnectionRecordImpl( Reference<IClusterConnectionRecord> const& connRecord, DatabaseContext* const& self ) {
															#line 391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SwitchConnectionRecordImplActor(connRecord, self));
															#line 1024 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Reference<IClusterConnectionRecord> DatabaseContext::getConnectionRecord() {
	if (connectionRecord) {
		return connectionRecord->get();
	}
	return Reference<IClusterConnectionRecord>();
}

Future<Void> DatabaseContext::switchConnectionRecord(Reference<IClusterConnectionRecord> standby) {
	ASSERT(switchable);
	return switchConnectionRecordImpl(standby, this);
}

Future<Void> DatabaseContext::connectionFileChanged() {
	return connectionFileChangedTrigger.onTrigger();
}

void DatabaseContext::expireThrottles() {
	for (auto& priorityItr : throttledTags) {
		for (auto tagItr = priorityItr.second.begin(); tagItr != priorityItr.second.end();) {
			if (tagItr->second.expired()) {
				CODE_PROBE(true, "Expiring client throttle");
				tagItr = priorityItr.second.erase(tagItr);
			} else {
				++tagItr;
			}
		}
	}
}

// Initialize tracing for FDB client
//
// connRecord is necessary for determining the local IP, which is then included in the trace
// file name, and also used to annotate all trace events.
//
// If trace_initialize_on_setup is not set, tracing is initialized when opening a database.
// In that case we can immediately determine the IP. Thus, we can use the IP in the
// trace file name and annotate all events with it.
//
// If trace_initialize_on_setup network option is set, tracing is at first initialized without
// connRecord and thus without the local IP. In that case we cannot use the local IP in the
// trace file names. The IP is then provided by a repeated call to initializeClientTracing
// when opening a database. All tracing events from this point are annotated with the local IP
//
// If tracing initialization is completed, further calls to initializeClientTracing are ignored
void initializeClientTracing(Reference<IClusterConnectionRecord> connRecord, Optional<int> apiVersion) {
	if (!networkOptions.traceDirectory.present()) {
		return;
	}

	bool initialized = traceFileIsOpen();
	if (initialized && (isTraceLocalAddressSet() || !connRecord)) {
		// Tracing initialization is completed
		return;
	}

	// Network must be created before initializing tracing
	ASSERT(g_network);

	Optional<NetworkAddress> localAddress;
	if (connRecord) {
		auto publicIP = connRecord->getConnectionString().determineLocalSourceIP();
		localAddress = NetworkAddress(publicIP, ::getpid());
	}
	platform::ImageInfo imageInfo = platform::getImageInfo();

	if (initialized) {
		// Tracing already initialized, just need to update the IP address
		setTraceLocalAddress(localAddress.get());
		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");
	} else {
		// Initialize tracing
		selectTraceFormatter(networkOptions.traceFormat);
		selectTraceClockSource(networkOptions.traceClockSource);
		addUniversalTraceField("ClientDescription",
		                       format("%s-%s-%" PRIu64,
		                              networkOptions.primaryClient ? "primary" : "external",
		                              FDB_VT_VERSION,
		                              deterministicRandom()->randomUInt64()));

		std::string identifier = networkOptions.traceFileIdentifier;
		openTraceFile(localAddress,
		              networkOptions.traceRollSize,
		              networkOptions.traceMaxLogsSize,
		              networkOptions.traceDirectory.get(),
		              "trace",
		              networkOptions.traceLogGroup,
		              identifier,
		              networkOptions.tracePartialFileSuffix,
		              InitializeTraceMetrics::True);

		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");

		g_network->initMetrics();
		FlowTransport::transport().initMetrics();
	}

	// Initialize system monitoring once the local IP is available
	if (localAddress.present()) {
		initializeSystemMonitorMachineState(SystemMonitorMachineState(IPAddress(localAddress.get().ip)));
		systemMonitor();
		uncancellable(recurring(&systemMonitor, CLIENT_KNOBS->SYSTEM_MONITOR_INTERVAL, TaskPriority::FlushTrace));
	}
}

// Creates a database object that represents a connection to a cluster
// This constructor uses a preallocated DatabaseContext that may have been created
// on another thread
Database Database::createDatabase(Reference<IClusterConnectionRecord> connRecord,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality,
                                  DatabaseContext* preallocatedDb) {
	if (!g_network)
		throw network_not_setup();

	ASSERT(TraceEvent::isNetworkThread());

	initializeClientTracing(connRecord, apiVersion);

	g_network->initTLS();

	auto clientInfo = makeReference<AsyncVar<ClientDBInfo>>();
	auto coordinator = makeReference<AsyncVar<Optional<ClientLeaderRegInterface>>>();
	auto connectionRecord = makeReference<AsyncVar<Reference<IClusterConnectionRecord>>>();
	connectionRecord->set(connRecord);
	Future<Void> clientInfoMonitor = monitorProxies(connectionRecord,
	                                                clientInfo,
	                                                coordinator,
	                                                networkOptions.supportedVersions,
	                                                StringRef(networkOptions.traceLogGroup),
	                                                internal);

	DatabaseContext* db;
	if (preallocatedDb) {
		db = new (preallocatedDb) DatabaseContext(connectionRecord,
		                                          clientInfo,
		                                          coordinator,
		                                          clientInfoMonitor,
		                                          TaskPriority::DefaultEndpoint,
		                                          clientLocality,
		                                          EnableLocalityLoadBalance::True,
		                                          LockAware::False,
		                                          internal,
		                                          apiVersion,
		                                          IsSwitchable::True);
	} else {
		db = new DatabaseContext(connectionRecord,
		                         clientInfo,
		                         coordinator,
		                         clientInfoMonitor,
		                         TaskPriority::DefaultEndpoint,
		                         clientLocality,
		                         EnableLocalityLoadBalance::True,
		                         LockAware::False,
		                         internal,
		                         apiVersion,
		                         IsSwitchable::True);
	}

	auto database = Database(db);
	database->globalConfig->init(Reference<AsyncVar<ClientDBInfo> const>(clientInfo),
	                             std::addressof(clientInfo->get()));
	database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	database->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);

	TraceEvent("ConnectToDatabase", database->dbId)
	    .detail("Version", FDB_VT_VERSION)
	    .detail("ClusterFile", connRecord ? connRecord->toString() : "None")
	    .detail("ConnectionString", connRecord ? connRecord->getConnectionString().toString() : "None")
	    .detail("ClientLibrary", platform::getImageInfo().fileName)
	    .detail("Primary", networkOptions.primaryClient)
	    .detail("Internal", internal)
	    .trackLatest(database->connectToDatabaseEventCacheHolder.trackingKey);

	return database;
}

Database Database::createDatabase(std::string connFileName,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality) {
	Reference<IClusterConnectionRecord> rccr = ClusterConnectionFile::openOrDefault(connFileName);
	return Database::createDatabase(rccr, apiVersion, internal, clientLocality);
}

Database Database::createSimulatedExtraDatabase(std::string connectionString) {
	auto extraFile = makeReference<ClusterConnectionMemoryRecord>(ClusterConnectionString(connectionString));
	Database db = Database::createDatabase(extraFile, ApiVersion::LATEST_VERSION);
	return db;
}

const UniqueOrderedOptionList<FDBTransactionOptions>& Database::getTransactionDefaults() const {
	ASSERT(db);
	return db->transactionDefaults;
}

void setNetworkOption(FDBNetworkOptions::Option option, Optional<StringRef> value) {
	std::regex identifierRegex("^[a-zA-Z0-9_]*$");
	switch (option) {
	// SOMEDAY: If the network is already started, should these five throw an error?
	case FDBNetworkOptions::TRACE_ENABLE:
		networkOptions.traceDirectory = value.present() ? value.get().toString() : "";
		break;
	case FDBNetworkOptions::TRACE_ROLL_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceRollSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_MAX_LOGS_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceMaxLogsSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_FORMAT:
		validateOptionValuePresent(value);
		networkOptions.traceFormat = value.get().toString();
		if (!validateTraceFormat(networkOptions.traceFormat)) {
			fprintf(stderr, "Unrecognized trace format: `%s'\n", networkOptions.traceFormat.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_FILE_IDENTIFIER:
		validateOptionValuePresent(value);
		networkOptions.traceFileIdentifier = value.get().toString();
		if (networkOptions.traceFileIdentifier.length() > CLIENT_KNOBS->TRACE_LOG_FILE_IDENTIFIER_MAX_LENGTH) {
			fprintf(stderr, "Trace file identifier provided is too long.\n");
			throw invalid_option_value();
		} else if (!std::regex_match(networkOptions.traceFileIdentifier, identifierRegex)) {
			fprintf(stderr, "Trace file identifier should only contain alphanumerics and underscores.\n");
			throw invalid_option_value();
		}
		break;

	case FDBNetworkOptions::TRACE_LOG_GROUP:
		if (value.present()) {
			if (traceFileIsOpen()) {
				setTraceLogGroup(value.get().toString());
			} else {
				networkOptions.traceLogGroup = value.get().toString();
			}
		}
		break;
	case FDBNetworkOptions::TRACE_CLOCK_SOURCE:
		validateOptionValuePresent(value);
		networkOptions.traceClockSource = value.get().toString();
		if (!validateTraceClockSource(networkOptions.traceClockSource)) {
			fprintf(stderr, "Unrecognized trace clock source: `%s'\n", networkOptions.traceClockSource.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_PARTIAL_FILE_SUFFIX:
		validateOptionValuePresent(value);
		networkOptions.tracePartialFileSuffix = value.get().toString();
		break;
	case FDBNetworkOptions::TRACE_INITIALIZE_ON_SETUP:
		networkOptions.traceInitializeOnSetup = true;
		break;
	case FDBNetworkOptions::KNOB: {
		validateOptionValuePresent(value);

		std::string optionValue = value.get().toString();
		TraceEvent("SetKnob").detail("KnobString", optionValue);

		size_t eq = optionValue.find_first_of('=');
		if (eq == optionValue.npos) {
			TraceEvent(SevWarnAlways, "InvalidKnobString").detail("KnobString", optionValue);
			throw invalid_option_value();
		}

		std::string knobName = optionValue.substr(0, eq);
		std::string knobValueString = optionValue.substr(eq + 1);

		try {
			auto knobValue = IKnobCollection::parseKnobValue(knobName, knobValueString, IKnobCollection::Type::CLIENT);
			if (g_network) {
				IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
			} else {
				networkOptions.knobs[knobName] = knobValue;
			}
		} catch (Error& e) {
			TraceEvent(SevWarnAlways, "UnrecognizedKnob").detail("Knob", knobName.c_str());
			fprintf(stderr, "FoundationDB client ignoring unrecognized knob option '%s'\n", knobName.c_str());
		}
		break;
	}
	case FDBNetworkOptions::TLS_PLUGIN:
		validateOptionValuePresent(value);
		break;
	case FDBNetworkOptions::TLS_CERT_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setCertificatePath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_CERT_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCertificateBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_PATH: {
		validateOptionValuePresent(value);
		tlsConfig.setCAPath(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCABytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_PASSWORD:
		validateOptionValuePresent(value);
		tlsConfig.setPassword(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setKeyPath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setKeyBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_VERIFY_PEERS:
		validateOptionValuePresent(value);
		tlsConfig.clearVerifyPeers();
		tlsConfig.addVerifyPeers(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_DISABLE_PLAINTEXT_CONNECTION:
		tlsConfig.setDisablePlainTextConnection(true);
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_ENABLE:
		enableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_DISABLE:
		disableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_ACTIVATED_PROBABILITY:
		validateOptionValuePresent(value);
		clearClientBuggifySections();
		P_CLIENT_BUGGIFIED_SECTION_ACTIVATED = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_FIRED_PROBABILITY:
		validateOptionValuePresent(value);
		P_CLIENT_BUGGIFIED_SECTION_FIRES = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING:
		validateOptionValueNotPresent(value);
		networkOptions.logClientInfo = false;
		break;
	case FDBNetworkOptions::SUPPORTED_CLIENT_VERSIONS: {
		// The multi-version API should be providing us these guarantees
		ASSERT(g_network);
		ASSERT(value.present());

		Standalone<VectorRef<ClientVersionRef>> supportedVersions;
		std::vector<StringRef> supportedVersionsStrings = value.get().splitAny(";"_sr);
		for (StringRef versionString : supportedVersionsStrings) {
#ifdef ADDRESS_SANITIZER
			__lsan_disable();
#endif
			// LSAN reports that we leak this allocation in client
			// tests, but I cannot seem to figure out why. AFAICT
			// it's not actually leaking. If it is a leak, it's only a few bytes.
			supportedVersions.push_back_deep(supportedVersions.arena(), ClientVersionRef(versionString));
#ifdef ADDRESS_SANITIZER
			__lsan_enable();
#endif
		}

		ASSERT(supportedVersions.size() > 0);
		networkOptions.supportedVersions->set(supportedVersions);

		break;
	}
	case FDBNetworkOptions::ENABLE_RUN_LOOP_PROFILING: // Same as ENABLE_SLOW_TASK_PROFILING
		validateOptionValueNotPresent(value);
		networkOptions.runLoopProfilingEnabled = true;
		break;
	case FDBNetworkOptions::DISTRIBUTED_CLIENT_TRACER: {
		validateOptionValuePresent(value);
		std::string tracer = value.get().toString();
		if (tracer == "none" || tracer == "disabled") {
			openTracer(TracerType::DISABLED);
		} else if (tracer == "logfile" || tracer == "file" || tracer == "log_file") {
			openTracer(TracerType::LOG_FILE);
		} else if (tracer == "network_lossy") {
			openTracer(TracerType::NETWORK_LOSSY);
		} else {
			fprintf(stderr, "ERROR: Unknown or unsupported tracer: `%s'", tracer.c_str());
			throw invalid_option_value();
		}
		break;
	}
	case FDBNetworkOptions::EXTERNAL_CLIENT:
		networkOptions.primaryClient = false;
		break;
	default:
		break;
	}
}

// update the network busyness on a 1s cadence
															#line 1445 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorNetworkBusyness()
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class MonitorNetworkBusynessActor>
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActorState {
															#line 1452 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActorState() 
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 850 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : prevTime(now())
															#line 1459 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	~MonitorNetworkBusynessActorState() 
	{
		fdb_probe_actor_destroy("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 851 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1474 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorNetworkBusynessActorState();
		static_cast<MonitorNetworkBusynessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(CLIENT_KNOBS->NETWORK_BUSYNESS_MONITOR_INTERVAL, TaskPriority::FlushTrace);
															#line 852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1506 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 1;
															#line 852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorNetworkBusynessActor, 0, Void >*>(static_cast<MonitorNetworkBusynessActor*>(this)));
															#line 1511 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 854 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 855 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 857 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1526 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 858 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 859 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 860 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1534 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 871 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 872 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1542 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1546 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 881 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 854 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 855 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 857 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1569 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 858 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 859 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 860 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1577 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 871 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 872 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1585 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1589 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 881 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1597 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state > 0) static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorNetworkBusynessActor*>(this)->ActorCallback< MonitorNetworkBusynessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 850 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double prevTime;
															#line 1679 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorNetworkBusyness()
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActor final : public Actor<Void>, public ActorCallback< MonitorNetworkBusynessActor, 0, Void >, public FastAllocated<MonitorNetworkBusynessActor>, public MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor> {
															#line 1684 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorNetworkBusynessActor>::operator new;
	using FastAllocated<MonitorNetworkBusynessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5681946845339302144UL, 14763906581160433664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorNetworkBusynessActor, 0, Void >;
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActor() 
															#line 1701 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9706183877542601984UL, 10068029726573410048UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorNetworkBusyness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorNetworkBusynessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> monitorNetworkBusyness(  ) {
															#line 849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new MonitorNetworkBusynessActor());
															#line 1734 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 887 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static void setupGlobalKnobs() {
	IKnobCollection::setGlobalKnobCollection(IKnobCollection::Type::CLIENT, Randomize::False, IsSimulated::False);
	for (const auto& [knobName, knobValue] : networkOptions.knobs) {
		IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
	}
}

// Setup g_network and start monitoring for network busyness
void setupNetwork(uint64_t transportId, UseMetrics useMetrics) {
	if (g_network)
		throw network_already_setup();

	if (!networkOptions.logClientInfo.present())
		networkOptions.logClientInfo = true;

	setupGlobalKnobs();
	g_network = newNet2(tlsConfig, false, useMetrics || networkOptions.traceDirectory.present());
	g_network->addStopCallback(Net2FileSystem::stop);
	FlowTransport::createInstance(true, transportId, WLTOKEN_RESERVED_COUNT);
	Net2FileSystem::newFileSystem();

	if (networkOptions.traceInitializeOnSetup) {
		::initializeClientTracing({}, {});
	}

	uncancellable(monitorNetworkBusyness());
}

void runNetwork() {
	if (!g_network) {
		throw network_not_setup();
	}

	if (!g_network->checkRunnable()) {
		throw network_cannot_be_restarted();
	}

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		setupRunLoopProfiler();
	}

	g_network->run();

	if (networkOptions.traceDirectory.present())
		systemMonitor();
}

void stopNetwork() {
	if (!g_network)
		throw network_not_setup();

	TraceEvent("ClientStopNetwork").log();

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		stopRunLoopProfiler();
	}

	g_network->stop();
}

void DatabaseContext::updateProxies() {
	if (proxiesLastChange == clientInfo->get().id)
		return;
	proxiesLastChange = clientInfo->get().id;
	commitProxies.clear();
	grvProxies.clear();
	bool commitProxyProvisional = false, grvProxyProvisional = false;
	if (clientInfo->get().commitProxies.size()) {
		commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
		commitProxyProvisional = clientInfo->get().commitProxies[0].provisional;
	}
	if (clientInfo->get().grvProxies.size()) {
		grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
		grvProxyProvisional = clientInfo->get().grvProxies[0].provisional;
	}
	if (clientInfo->get().commitProxies.size() && clientInfo->get().grvProxies.size()) {
		ASSERT(commitProxyProvisional == grvProxyProvisional);
		proxyProvisional = commitProxyProvisional;
	}
}

Reference<CommitProxyInfo> DatabaseContext::getCommitProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<CommitProxyInfo>();
	}
	return commitProxies;
}

Reference<GrvProxyInfo> DatabaseContext::getGrvProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<GrvProxyInfo>();
	}
	return grvProxies;
}

bool DatabaseContext::isCurrentGrvProxy(UID proxyId) const {
	for (const auto& proxy : clientInfo->get().grvProxies) {
		if (proxy.id() == proxyId)
			return true;
	}
	CODE_PROBE(true, "stale GRV proxy detected", probe::decoration::rare);
	return false;
}

// Actor which will wait until the MultiInterface<CommitProxyInterface> returned by the DatabaseContext cx is not
// nullptr
															#line 1847 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getCommitProxiesFuture()
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetCommitProxiesFutureActor>
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActorState {
															#line 1854 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActorState(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 1863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesFutureActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 998 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1878 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesFutureActorState();
		static_cast<GetCommitProxiesFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 999 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<CommitProxyInfo> commitProxies = cx->getCommitProxies(useProvisionalProxies);
															#line 1000 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (commitProxies)
															#line 1910 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1001 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetCommitProxiesFutureActor*>(this)->SAV<Reference<CommitProxyInfo>>::futures) { (void)(commitProxies); this->~GetCommitProxiesFutureActorState(); static_cast<GetCommitProxiesFutureActor*>(this)->destroy(); return 0; }
															#line 1914 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetCommitProxiesFutureActor*>(this)->SAV< Reference<CommitProxyInfo> >::value()) Reference<CommitProxyInfo>(commitProxies);
			this->~GetCommitProxiesFutureActorState();
			static_cast<GetCommitProxiesFutureActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1002 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 1002 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1924 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 1;
															#line 1002 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesFutureActor, 0, Void >*>(static_cast<GetCommitProxiesFutureActor*>(this)));
															#line 1929 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesFutureActor*>(this)->ActorCallback< GetCommitProxiesFutureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* cx;
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2025 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCommitProxiesFuture()
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActor final : public Actor<Reference<CommitProxyInfo>>, public ActorCallback< GetCommitProxiesFutureActor, 0, Void >, public FastAllocated<GetCommitProxiesFutureActor>, public GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor> {
															#line 2030 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCommitProxiesFutureActor>::operator new;
	using FastAllocated<GetCommitProxiesFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5101301777668718592UL, 3655028470245714432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<CommitProxyInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesFutureActor, 0, Void >;
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActor(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2047 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Reference<CommitProxyInfo>>(),
		   GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor>(cx, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5140351585656034048UL, 11319334858847052544UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesFutureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Reference<CommitProxyInfo>> getCommitProxiesFuture( DatabaseContext* const& cx, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Reference<CommitProxyInfo>>(new GetCommitProxiesFutureActor(cx, useProvisionalProxies));
															#line 2080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1005 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Returns a future which will not be set until the CommitProxyInfo of this DatabaseContext is not nullptr
Future<Reference<CommitProxyInfo>> DatabaseContext::getCommitProxiesFuture(
    UseProvisionalProxies useProvisionalProxies) {
	return ::getCommitProxiesFuture(this, useProvisionalProxies);
}

void GetRangeLimits::decrement(VectorRef<KeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(KeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(KeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

void GetRangeLimits::decrement(VectorRef<MappedKeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(MappedKeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(MappedKeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

// True if either the row or byte limit has been reached
bool GetRangeLimits::isReached() const {
	return rows == 0 || (bytes == 0 && minRows == 0);
}

// True if data would cause the row or byte limit to be reached
bool GetRangeLimits::reachedBy(VectorRef<KeyValueRef> const& data) const {
	return (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED && data.size() >= rows) ||
	       (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED &&
	        (int)data.expectedSize() + (8 - (int)sizeof(KeyValueRef)) * data.size() >= bytes && data.size() >= minRows);
}

bool GetRangeLimits::hasByteLimit() const {
	return bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasRowLimit() const {
	return rows != GetRangeLimits::ROW_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasSatisfiedMinRows() const {
	return hasByteLimit() && minRows == 0;
}

AddressExclusion AddressExclusion::parse(StringRef const& key) {
	// Must not change: serialized to the database!
	auto parsedIp = IPAddress::parse(key.toString());
	if (parsedIp.present()) {
		return AddressExclusion(parsedIp.get());
	}

	// Not a whole machine, includes `port'.
	try {
		auto addr = NetworkAddress::parse(key.toString());
		if (addr.isTLS()) {
			TraceEvent(SevWarnAlways, "AddressExclusionParseError")
			    .detail("String", key)
			    .detail("Description", "Address inclusion string should not include `:tls' suffix.");
			return AddressExclusion();
		}
		return AddressExclusion(addr.ip, addr.port);
	} catch (Error&) {
		TraceEvent(SevWarnAlways, "AddressExclusionParseError").detail("String", key);
		return AddressExclusion();
	}
}

Future<Optional<Value>> getValue(Reference<TransactionState> const& trState,
                                 Key const& key,
                                 TransactionRecordLogInfo const& recordLogInfo = TransactionRecordLogInfo::True);

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse);

															#line 2192 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via fetchServerInterface()
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class FetchServerInterfaceActor>
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActorState {
															#line 2199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActorState(Reference<TransactionState> const& trState,UID const& id) 
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   id(id)
															#line 2208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	~FetchServerInterfaceActorState() 
	{
		fdb_probe_actor_destroy("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = getValue(trState, serverListKeyFor(id), TransactionRecordLogInfo::False);
															#line 1114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 1;
															#line 1114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*>(static_cast<FetchServerInterfaceActor*>(this)));
															#line 2230 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1118 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2257 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2265 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1118 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2281 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2289 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<FetchServerInterfaceActor*>(this)->ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UID id;
															#line 2376 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchServerInterface()
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActor final : public Actor<Optional<StorageServerInterface>>, public ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >, public FastAllocated<FetchServerInterfaceActor>, public FetchServerInterfaceActorState<FetchServerInterfaceActor> {
															#line 2381 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchServerInterfaceActor>::operator new;
	using FastAllocated<FetchServerInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(170845163920180224UL, 15221742750140329984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >;
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActor(Reference<TransactionState> const& trState,UID const& id) 
															#line 2398 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Optional<StorageServerInterface>>(),
		   FetchServerInterfaceActorState<FetchServerInterfaceActor>(trState, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14331509920591601920UL, 209697105602724096UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchServerInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<StorageServerInterface>> fetchServerInterface( Reference<TransactionState> const& trState, UID const& id ) {
															#line 1113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<StorageServerInterface>>(new FetchServerInterfaceActor(trState, id));
															#line 2431 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 2436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class TransactionalGetServerInterfacesActor>
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActorState {
															#line 2443 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActorState(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ids(ids),
															#line 1127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   serverListEntries()
															#line 2454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~TransactionalGetServerInterfacesActorState() 
	{
		fdb_probe_actor_destroy("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverListEntries.reserve(ids.size());
															#line 1129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int s = 0;s < ids.size();s++) {
															#line 1130 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				serverListEntries.push_back(fetchServerInterface(trState, ids[s]));
															#line 2473 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<std::vector<Optional<StorageServerInterface>>> __when_expr_0 = getAll(serverListEntries);
															#line 1133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2479 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 1;
															#line 1133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*>(static_cast<TransactionalGetServerInterfacesActor*>(this)));
															#line 2484 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
															#line 1134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1136 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2511 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2515 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1140 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2523 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2527 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
															#line 1134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1136 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2547 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1140 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionalGetServerInterfacesActor*>(this)->ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> const& value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> && value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<UID> ids;
															#line 1127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Optional<StorageServerInterface>>> serverListEntries;
															#line 2648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActor final : public Actor<Optional<std::vector<StorageServerInterface>>>, public ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >, public FastAllocated<TransactionalGetServerInterfacesActor>, public TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor> {
															#line 2653 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator new;
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9352298449635641600UL, 12551213468555914752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::vector<StorageServerInterface>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >;
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActor(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 2670 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Optional<std::vector<StorageServerInterface>>>(),
		   TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor>(trState, ids),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8960874033469204480UL, 15207940511002765056UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionalGetServerInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<std::vector<StorageServerInterface>>> transactionalGetServerInterfaces( Reference<TransactionState> const& trState, std::vector<UID> const& ids ) {
															#line 1124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<std::vector<StorageServerInterface>>>(new TransactionalGetServerInterfacesActor(trState, ids));
															#line 2703 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

void updateTssMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	// Since a ss -> tss mapping is included in resultsTssMapping iff that SS is in results and has a tss pair,
	// all SS in results that do not have a mapping present must not have a tss pair.
	std::unordered_map<UID, const StorageServerInterface*> ssiById;
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			ssiById[ssi.id()] = &ssi;
		}
	}

	for (const auto& mapping : reply.resultsTssMapping) {
		auto ssi = ssiById.find(mapping.first);
		ASSERT(ssi != ssiById.end());
		cx->addTssMapping(*ssi->second, mapping.second);
		ssiById.erase(mapping.first);
	}

	// if SS didn't have a mapping above, it's still in the ssiById map, so remove its tss mapping
	for (const auto& it : ssiById) {
		cx->removeTssMapping(*it.second);
	}
}

void updateTagMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	for (const auto& mapping : reply.resultsTagMapping) {
		cx->addSSIdTagMapping(mapping.first, mapping.second);
	}
}

// If isBackward == true, returns the shard containing the key before 'key' (an infinitely long, inexpressible key).
// Otherwise returns the shard containing key
															#line 2739 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyLocation_internal()
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyLocation_internalActor>
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActorState {
															#line 2746 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActorState(Database const& cx,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   isBackward(isBackward),
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1184 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyLocation"_loc, spanContext)
															#line 2767 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocation_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1185 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (isBackward)
															#line 2782 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1186 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key != allKeys.begin && key <= allKeys.end);
															#line 2786 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1188 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key < allKeys.end);
															#line 2792 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1191 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 2796 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1192 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.Before");
															#line 2800 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1194 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 2804 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2837 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 1;
															#line 1196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 0, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2842 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 2864 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForKeyLocation").suppressFor(5);
															#line 1224 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 2870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1228 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2875 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1198 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2893 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2897 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1198 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2917 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2921 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2928 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& rep,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1207 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3032 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3036 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1212 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1214 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1216 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo(KeyRange(rep.results[0].first, rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo(KeyRange(rep.results[0].first, rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && rep,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1207 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3064 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3068 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1212 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1214 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1216 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo(KeyRange(rep.results[0].first, rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3082 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo(KeyRange(rep.results[0].first, rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 1, Void >::remove();
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse isBackward;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1184 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3240 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyLocation_internal()
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActor final : public Actor<KeyRangeLocationInfo>, public ActorCallback< GetKeyLocation_internalActor, 0, Void >, public ActorCallback< GetKeyLocation_internalActor, 1, Void >, public ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >, public FastAllocated<GetKeyLocation_internalActor>, public GetKeyLocation_internalActorState<GetKeyLocation_internalActor> {
															#line 3245 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyLocation_internalActor>::operator new;
	using FastAllocated<GetKeyLocation_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17799571675440891904UL, 10856866347482347520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRangeLocationInfo>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocation_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >;
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActor(Database const& cx,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 3264 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<KeyRangeLocationInfo>(),
		   GetKeyLocation_internalActorState<GetKeyLocation_internalActor>(cx, key, spanContext, debugID, useProvisionalProxies, isBackward, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1277245642794616832UL, 6556686229128886016UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocation_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<KeyRangeLocationInfo> getKeyLocation_internal( Database const& cx, Key const& key, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Reverse const& isBackward, Version const& version ) {
															#line 1176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<KeyRangeLocationInfo>(new GetKeyLocation_internalActor(cx, key, spanContext, debugID, useProvisionalProxies, isBackward, version));
															#line 3298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Checks if `endpoint` is failed on a healthy server or not. Returns true if we need to refresh the location cache for
// the endpoint.
bool checkOnlyEndpointFailed(const Database& cx, const Endpoint& endpoint) {
	if (IFailureMonitor::failureMonitor().onlyEndpointFailed(endpoint)) {
		// This endpoint is failed, but the server is still healthy. There are two cases this can happen:
		//    - There is a recent bounce in the cluster where the endpoints in SSes get updated.
		//    - The SS is failed and terminated on a server, but the server is kept running.
		// To account for the first case, we invalidate the cache and issue GetKeyLocation requests to the proxy to
		// update the cache with the new SS points. However, if the failure is caused by the second case, the
		// requested key location will continue to be the failed endpoint until the data movement is finished. But
		// every read will generate a GetKeyLocation request to the proxies (and still getting the failed endpoint
		// back), which may overload the proxy and affect data movement speed. Therefore, we only refresh the
		// location cache for short period of time, and after the initial grace period that we keep retrying
		// resolving key location, we will slow it down to resolve it only once every
		// `LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL`.
		cx->setFailedEndpointOnHealthyServer(endpoint);
		const auto& failureInfo = cx->getEndpointFailureInfo(endpoint);
		ASSERT(failureInfo.present());
		if (now() - failureInfo.get().startTime < CLIENT_KNOBS->LOCATION_CACHE_ENDPOINT_FAILURE_GRACE_PERIOD ||
		    now() - failureInfo.get().lastRefreshTime > CLIENT_KNOBS->LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL) {
			cx->updateFailedEndpointRefreshTime(endpoint);
			return true;
		}
	} else {
		cx->clearFailedEndpointOnHealthyServer(endpoint);
	}
	return false;
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Database const& cx,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            SpanContext spanContext,
                                            Optional<UID> debugID,
                                            UseProvisionalProxies useProvisionalProxies,
                                            Reverse isBackward,
                                            Version version) {
	// we first check whether this range is cached
	Optional<KeyRangeLocationInfo> locationInfo = cx->getCachedLocation(key, isBackward);
	if (!locationInfo.present()) {
		return getKeyLocation_internal(cx, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	bool onlyEndpointFailedAndNeedRefresh = false;
	for (int i = 0; i < locationInfo.get().locations->size(); i++) {
		if (checkOnlyEndpointFailed(cx, locationInfo.get().locations->get(i, member).getEndpoint())) {
			onlyEndpointFailedAndNeedRefresh = true;
		}
	}

	if (onlyEndpointFailedAndNeedRefresh) {
		cx->invalidateCache(key);

		// Refresh the cache with a new getKeyLocations made to proxies.
		return getKeyLocation_internal(cx, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	return locationInfo.get();
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Reference<TransactionState> trState,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            Reverse isBackward) {
	return getKeyLocation(trState->cx,
	                      key,
	                      member,
	                      trState->spanContext,
	                      trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                      trState->useProvisionalProxies,
	                      isBackward,
	                      trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                          ? trState->readVersion()
	                          : latestVersion);
}

void DatabaseContext::updateBackoff(const Error& err) {
	switch (err.code()) {
	case error_code_success:
		backoffDelay = backoffDelay / CLIENT_KNOBS->BACKOFF_GROWTH_RATE;
		if (backoffDelay < CLIENT_KNOBS->DEFAULT_BACKOFF) {
			backoffDelay = 0.0;
		}
		break;

	case error_code_commit_proxy_memory_limit_exceeded:
		++transactionsResourceConstrained;
		if (backoffDelay == 0.0) {
			backoffDelay = CLIENT_KNOBS->DEFAULT_BACKOFF;
		} else {
			backoffDelay = std::min(backoffDelay * CLIENT_KNOBS->BACKOFF_GROWTH_RATE,
			                        CLIENT_KNOBS->RESOURCE_CONSTRAINED_MAX_BACKOFF);
		}
		break;

	default:
		ASSERT_WE_THINK(false);
	}
}

															#line 3405 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyRangeLocations_internalActor>
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActorState {
															#line 3412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActorState(Database const& cx,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limit(limit),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1344 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyRangeLocations"_loc, spanContext)
															#line 3435 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyRangeLocations_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1345 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 3450 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1346 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.Before");
															#line 3454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1348 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 3458 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3491 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 1;
															#line 1350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3496 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1385 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 3518 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1387 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForRangeLocation").suppressFor(5);
															#line 1388 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 3524 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1392 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3529 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1352 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3547 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3558 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1352 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3571 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3575 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3582 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& _rep,int loopDepth) 
	{
															#line 1360 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1361 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1362 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3688 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1363 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3692 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1365 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1367 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3702 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && _rep,int loopDepth) 
	{
															#line 1360 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1361 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1362 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3715 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1363 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3719 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1365 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1367 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3729 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >::remove();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2when2cont1(int loopDepth) 
	{
															#line 1377 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1378 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1380 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1381 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV<std::vector<KeyRangeLocationInfo>>::futures) { (void)(results); this->~GetKeyRangeLocations_internalActorState(); static_cast<GetKeyRangeLocations_internalActor*>(this)->destroy(); return 0; }
															#line 3808 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV< std::vector<KeyRangeLocationInfo> >::value()) std::vector<KeyRangeLocationInfo>(std::move(results)); // state_var_RVO
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1(int loopDepth) 
	{
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(shard < rep.results.size()))
															#line 3827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1372 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results.emplace_back( (rep.results[shard].first & keys), cx->setCachedLocation(rep.results[shard].first, rep.results[shard].second));
															#line 1375 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1375 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3837 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 3;
															#line 1375 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3842 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2when2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3864 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3873 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int limit;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1344 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1361 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyServerLocationsReply rep;
															#line 1367 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> results;
															#line 1368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 4047 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActor final : public Actor<std::vector<KeyRangeLocationInfo>>, public ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >, public ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >, public FastAllocated<GetKeyRangeLocations_internalActor>, public GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor> {
															#line 4052 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator new;
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8001238772556720640UL, 5937500352321938176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRangeLocationInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >;
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActor(Database const& cx,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 4072 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyRangeLocationInfo>>(),
		   GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor>(cx, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7661675249109580544UL, 8773323650101319936UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyRangeLocations_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations_internal( Database const& cx, KeyRange const& keys, int const& limit, Reverse const& reverse, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Version const& version ) {
															#line 1335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<std::vector<KeyRangeLocationInfo>>(new GetKeyRangeLocations_internalActor(cx, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version));
															#line 4107 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1396 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Get the SS locations for each shard in the 'keys' key-range;
// Returned vector size is the number of shards in the input keys key-range.
// Returned vector element is <ShardRange, storage server location info> pairs, where
// ShardRange is the whole shard key-range, not a part of the given key range.
// Example: If query the function with  key range (b, d), the returned list of pairs could be something like:
// [([a, b1), locationInfo), ([b1, c), locationInfo), ([c, d1), locationInfo)].
template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Database const& cx,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member,
                                                               SpanContext const& spanContext,
                                                               Optional<UID> const& debugID,
                                                               UseProvisionalProxies useProvisionalProxies,
                                                               Version version) {

	ASSERT(!keys.empty());

	std::vector<KeyRangeLocationInfo> locations;
	if (!cx->getCachedLocations(keys, locations, limit, reverse)) {
		return getKeyRangeLocations_internal(
		    cx, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	bool foundFailed = false;
	for (const auto& locationInfo : locations) {
		bool onlyEndpointFailedAndNeedRefresh = false;
		for (int i = 0; i < locationInfo.locations->size(); i++) {
			if (checkOnlyEndpointFailed(cx, locationInfo.locations->get(i, member).getEndpoint())) {
				onlyEndpointFailedAndNeedRefresh = true;
			}
		}

		if (onlyEndpointFailedAndNeedRefresh) {
			cx->invalidateCache(locationInfo.range.begin);
			foundFailed = true;
		}
	}

	if (foundFailed) {
		// Refresh the cache with a new getKeyRangeLocations made to proxies.
		return getKeyRangeLocations_internal(
		    cx, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	return locations;
}

template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Reference<TransactionState> trState,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member) {
	return getKeyRangeLocations(trState->cx,
	                            keys,
	                            limit,
	                            reverse,
	                            member,
	                            trState->spanContext,
	                            trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                            trState->useProvisionalProxies,
	                            trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                                ? trState->readVersion()
	                                : latestVersion);
}

															#line 4180 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via warmRange_impl()
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WarmRange_implActor>
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActorState {
															#line 4187 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActorState(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1466 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRanges(0),
															#line 1467 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRequests(0)
															#line 4200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~WarmRange_implActorState() 
	{
		fdb_probe_actor_destroy("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1469 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1469 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 1;
															#line 1469 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 0, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4222 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1471 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4245 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1471 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4254 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1505 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WarmRange_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WarmRange_implActorState(); static_cast<WarmRange_implActor*>(this)->destroy(); return 0; }
															#line 4338 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<WarmRange_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1472 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_1 = getKeyRangeLocations_internal( trState->cx, keys, CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT, Reverse::False, trState->spanContext, trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(), trState->useProvisionalProxies, trState->readVersion());
															#line 1472 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4359 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WarmRange_implActor*>(this)->actor_wait_state = 2;
															#line 1472 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4364 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
															#line 1481 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1482 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1483 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 4390 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1487 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1489 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 4398 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1491 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx);
															#line 1492 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4404 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
															#line 1481 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1482 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1483 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 4422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1487 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1489 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 4430 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1491 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx);
															#line 1492 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(locations, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(locations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1494 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1495 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 1496 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(tr.getReadVersion());
															#line 1496 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 3;
															#line 1496 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 2, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4556 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1499 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1499 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4593 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 4;
															#line 1499 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 3, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4598 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1466 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRanges;
															#line 1467 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRequests;
															#line 1491 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 4793 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via warmRange_impl()
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActor final : public Actor<Void>, public ActorCallback< WarmRange_implActor, 0, Void >, public ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >, public ActorCallback< WarmRange_implActor, 2, Void >, public ActorCallback< WarmRange_implActor, 3, Void >, public FastAllocated<WarmRange_implActor>, public WarmRange_implActorState<WarmRange_implActor> {
															#line 4798 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WarmRange_implActor>::operator new;
	using FastAllocated<WarmRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15141757576172202496UL, 5382283072992776192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WarmRange_implActor, 0, Void >;
friend struct ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< WarmRange_implActor, 2, Void >;
friend struct ActorCallback< WarmRange_implActor, 3, Void >;
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActor(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 4818 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WarmRange_implActorState<WarmRange_implActor>(trState, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8548379736654756608UL, 17106069152090307840UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("warmRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WarmRange_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WarmRange_implActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WarmRange_implActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> warmRange_impl( Reference<TransactionState> const& trState, KeyRange const& keys ) {
															#line 1465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WarmRange_implActor(trState, keys));
															#line 4854 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1507 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

SpanContext generateSpanID(bool transactionTracingSample, SpanContext parentContext = SpanContext()) {
	if (parentContext.isValid()) {
		return SpanContext(parentContext.traceID, deterministicRandom()->randomUInt64(), parentContext.m_Flags);
	}
	if (transactionTracingSample) {
		return SpanContext(deterministicRandom()->randomUniqueID(),
		                   deterministicRandom()->randomUInt64(),
		                   deterministicRandom()->random01() <= FLOW_KNOBS->TRACING_SAMPLE_RATE
		                       ? TraceFlags::sampled
		                       : TraceFlags::unsampled);
	}
	return SpanContext(
	    deterministicRandom()->randomUniqueID(), deterministicRandom()->randomUInt64(), TraceFlags::unsampled);
}

TransactionState::TransactionState(Database cx,
                                   TaskPriority taskID,
                                   SpanContext spanContext,
                                   Reference<TransactionLogInfo> trLogInfo)
  : cx(cx), trLogInfo(trLogInfo), options(cx), taskID(taskID), spanContext(spanContext),
    readVersionObtainedFromGrvProxy(true) {}

Reference<TransactionState> TransactionState::cloneAndReset(Reference<TransactionLogInfo> newTrLogInfo,
                                                            bool generateNewSpan) const {

	SpanContext newSpanContext = generateNewSpan ? generateSpanID(cx->transactionTracingSample) : spanContext;
	Reference<TransactionState> newState =
	    makeReference<TransactionState>(cx, cx->taskID, newSpanContext, newTrLogInfo);

	if (!cx->apiVersionAtLeast(16)) {
		newState->options = options;
	}

	newState->readVersionFuture = Future<Version>();
	newState->metadataVersion = Promise<Optional<Key>>();
	newState->numErrors = numErrors;
	newState->startTime = startTime;
	newState->committedVersion = committedVersion;
	newState->conflictingKeys = conflictingKeys;

	return newState;
}

															#line 4902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startTransaction()
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class StartTransactionActor>
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActorState {
															#line 4909 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActorState(Reference<TransactionState> const& trState) 
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState)
															#line 4916 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	~StartTransactionActorState() 
	{
		fdb_probe_actor_destroy("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1552 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(trState->readVersionFuture);
															#line 1552 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4933 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 1;
															#line 1552 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 0, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 4938 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1553 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<StartTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTransactionActorState(); static_cast<StartTransactionActor*>(this)->destroy(); return 0; }
															#line 4961 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<StartTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1553 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<StartTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTransactionActorState(); static_cast<StartTransactionActor*>(this)->destroy(); return 0; }
															#line 4973 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<StartTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 5058 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startTransaction()
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActor final : public Actor<Void>, public ActorCallback< StartTransactionActor, 0, Void >, public FastAllocated<StartTransactionActor>, public StartTransactionActorState<StartTransactionActor> {
															#line 5063 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartTransactionActor>::operator new;
	using FastAllocated<StartTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7776847381807088640UL, 10901370747646678784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTransactionActor, 0, Void >;
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActor(Reference<TransactionState> const& trState) 
															#line 5080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartTransactionActorState<StartTransactionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7927092769933293824UL, 16612754116029991424UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> startTransaction( Reference<TransactionState> const& trState ) {
															#line 1551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new StartTransactionActor(trState));
															#line 5113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> TransactionState::startTransaction(uint32_t readVersionFlags) {
	if (!startFuture.isValid()) {
		if (!readVersionFuture.isValid()) {
			readVersionFuture = getReadVersion(readVersionFlags);
		}
		if (readVersionFuture.isReady()) {
			startFuture = Void();
		} else {
			startFuture = ::startTransaction(Reference<TransactionState>::addRef(this));
		}
	}

	return startFuture;
}

Future<Void> Transaction::warmRange(KeyRange keys) {
	return warmRange_impl(trState, keys);
}

namespace {

template <class Interface, class Request, bool P>
Future<REPLY_TYPE(Request)> loadBalance(
    DatabaseContext* ctx,
    const Reference<LocationInfo> alternatives,
    RequestStream<Request, P> Interface::* channel,
    const Request& request = Request(),
    TaskPriority taskID = TaskPriority::DefaultPromiseEndpoint,
    AtMostOnce atMostOnce =
        AtMostOnce::False, // if true, throws request_maybe_delivered() instead of retrying automatically
    QueueModel* model = nullptr,
    bool compareReplicas = false,
    int requiredReplicas = 0) {
	if (alternatives->hasCaches) {
		return loadBalance(
		    alternatives->locations(), channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas);
	}
	return fmap(
	    [ctx](auto const& res) {
		    if (res.cached) {
			    ctx->updateCache.trigger();
		    }
		    return res;
	    },
	    loadBalance(
	        alternatives->locations(), channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas));
}
} // namespace

															#line 5167 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getValue()
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetValueActor>
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActorState {
															#line 5174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActorState(Reference<TransactionState> const& trState,Key const& key,TransactionRecordLogInfo const& recordLogInfo) 
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   recordLogInfo(recordLogInfo)
															#line 5185 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getValue", reinterpret_cast<unsigned long>(this));

	}
	~GetValueActorState() 
	{
		fdb_probe_actor_destroy("getValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1608 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1608 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetValueActor*>(this)->actor_wait_state = 1;
															#line 1608 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 0, Void >*>(static_cast<GetValueActor*>(this)));
															#line 5207 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 5234 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 5247 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation(trState, key, &StorageServerInterface::getValue, Reverse::False);
															#line 1615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5340 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetValueActor*>(this)->actor_wait_state = 2;
															#line 1615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*>(static_cast<GetValueActor*>(this)));
															#line 5345 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getValueID = Optional<UID>();
															#line 1619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = uint64_t();
															#line 1620 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTimeD = double();
															#line 1621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 1622 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1624 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 5364 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 1626 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 5368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1627 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getValueID = nondeterministicRandom()->randomUniqueID();
															#line 1628 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				readOptions.get().debugID = getValueID;
															#line 1630 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "GetValueAttachID", trState->readOptions.get().debugID.get().first(), getValueID.get().first());
															#line 1632 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Before");
															#line 5378 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1641 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->getValueSubmitted;
															#line 1642 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTime = timer_int();
															#line 1643 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTimeD = now();
															#line 1644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 1646 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetValueReply();
															#line 5390 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			try {
															#line 1648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 5394 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 1649 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont1loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 5398 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 1653 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 1652 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 5404 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1656 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetValueReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getValue, GetValueRequest(span.context, key, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions), TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 5408 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 3;
															#line 1653 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 2, Void >*>(static_cast<GetValueActor*>(this)));
															#line 1656 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 3, GetValueReply >*>(static_cast<GetValueActor*>(this)));
															#line 5415 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 5436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1707 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 1708 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->log();
															#line 1709 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getValueID.present())
															#line 5526 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1710 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Error");
															#line 5530 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1712 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 5534 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1713 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(key);
															#line 1714 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 1714 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5542 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 4;
															#line 1714 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 4, Void >*>(static_cast<GetValueActor*>(this)));
															#line 5547 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1716 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo && recordLogInfo)
															#line 5554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 1717 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog(FdbClientLogEvents::EventGetError( startTimeD, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), key));
															#line 5558 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 1719 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 1681 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double latency = now() - startTimeD;
															#line 1682 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->readLatencies.addSample(latency);
															#line 1683 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->trLogInfo && recordLogInfo)
															#line 5581 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1684 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			int valueSize = reply.value.present() ? reply.value.get().size() : 0;
															#line 1685 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->trLogInfo->addLog(FdbClientLogEvents::EventGet( startTimeD, trState->cx->clientLocality.dcId(), latency, valueSize, key));
															#line 5587 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1688 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 1689 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->log();
															#line 1690 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->totalCost += getReadOperationCost(key.size() + (reply.value.present() ? reply.value.get().size() : 0));
															#line 1693 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getValueID.present())
															#line 5597 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1694 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.After");
															#line 5601 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1703 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += reply.value.present() ? reply.value.get().size() : 0;
															#line 1704 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionKeysRead;
															#line 1705 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(reply.value); this->~GetValueActorState(); static_cast<GetValueActor*>(this)->destroy(); return 0; }
															#line 5609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(reply.value);
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1677 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 1678 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 5624 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 1675 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 5638 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1654 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 5647 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1654 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 5655 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply const& _reply,int loopDepth) 
	{
															#line 1672 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 5663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply && _reply,int loopDepth) 
	{
															#line 1672 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 5672 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 2, Void >::remove();
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 3, GetValueReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetValueActor, 3, GetValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetValueActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionRecordLogInfo recordLogInfo;
															#line 1610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getValueID;
															#line 1619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	uint64_t startTime;
															#line 1620 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTimeD;
															#line 1621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 1622 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 1646 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueReply reply;
															#line 5926 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getValue()
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActor final : public Actor<Optional<Value>>, public ActorCallback< GetValueActor, 0, Void >, public ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetValueActor, 2, Void >, public ActorCallback< GetValueActor, 3, GetValueReply >, public ActorCallback< GetValueActor, 4, Void >, public FastAllocated<GetValueActor>, public GetValueActorState<GetValueActor> {
															#line 5931 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetValueActor>::operator new;
	using FastAllocated<GetValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7354956123716784128UL, 1997227472370565120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetValueActor, 0, Void >;
friend struct ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetValueActor, 2, Void >;
friend struct ActorCallback< GetValueActor, 3, GetValueReply >;
friend struct ActorCallback< GetValueActor, 4, Void >;
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActor(Reference<TransactionState> const& trState,Key const& key,TransactionRecordLogInfo const& recordLogInfo) 
															#line 5952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   GetValueActorState<GetValueActor>(trState, key, recordLogInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4269006456623515904UL, 18410873568439542016UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetValueActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetValueActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getValue( Reference<TransactionState> const& trState, Key const& key, TransactionRecordLogInfo const& recordLogInfo ) {
															#line 1605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<Value>>(new GetValueActor(trState, key, recordLogInfo));
															#line 5988 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1724 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 5993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKey()
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyActor>
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActorState {
															#line 6000 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActorState(Reference<TransactionState> const& trState,KeySelector const& k) 
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   k(k)
															#line 6009 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKey", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyActorState() 
	{
		fdb_probe_actor_destroy("getKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1726 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1726 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6026 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyActor*>(this)->actor_wait_state = 1;
															#line 1726 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 0, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 6031 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1728 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 1729 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1731 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 1732 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1733 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 1734 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 1736 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 1738 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 6070 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1745 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6074 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1728 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 1729 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1731 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 1732 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6089 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1733 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 1734 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 1736 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 1738 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 6099 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1745 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1746 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (k.getKey() == allKeys.end)
															#line 6194 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1747 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.offset > 0)
															#line 6198 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1748 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(allKeys.end); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 6202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(allKeys.end);
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1750 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			k.orEqual = false;
															#line 6210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1751 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.getKey() == allKeys.begin && k.offset <= 0)
															#line 6216 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1752 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(Key()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 6220 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(Key());
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1755 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey(k.getKey(), k.arena());
															#line 1756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation(trState, locationKey, &StorageServerInterface::getKey, Reverse{ k.isBackward() });
															#line 1756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyActor*>(this)->actor_wait_state = 2;
															#line 1756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*>(static_cast<GetKeyActor*>(this)));
															#line 6238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1759 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 1760 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 6249 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 1763 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 6253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1764 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Before");
															#line 6257 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1769 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 1771 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyRequest req(span.context, k, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions);
															#line 1777 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(k.arena());
															#line 1779 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetKeyReply();
															#line 6267 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			try {
															#line 1782 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 1781 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 6273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1785 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getKey, req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 6277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 3;
															#line 1782 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 2, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 1785 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 3, GetKeyReply >*>(static_cast<GetKeyActor*>(this)));
															#line 6284 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 6305 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1813 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 6391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1814 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Error");
															#line 6395 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1815 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 6399 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1816 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(k.getKey(), Reverse{ k.isBackward() });
															#line 1818 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 1818 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6407 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 4;
															#line 1818 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 4, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 6412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1820 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetKeyError").error(e).detail("AtKey", k.getKey()).detail("Offset", k.offset);
															#line 1821 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6421 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 1803 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getKeyID.present())
															#line 6436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1804 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.After");
															#line 6440 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1808 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		k = reply.sel;
															#line 1809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!k.offset && k.orEqual)
															#line 6446 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1810 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(k.getKey()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 6450 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(k.getKey());
			this->~GetKeyActorState();
			static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1800 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 1801 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 6467 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
															#line 1798 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 6481 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1783 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 6490 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1783 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 6498 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply const& _reply,int loopDepth) 
	{
															#line 1795 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 6506 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply && _reply,int loopDepth) 
	{
															#line 1795 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 6515 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 2, Void >::remove();
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 3, GetKeyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 3, GetKeyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont15(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector k;
															#line 1728 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getKeyID;
															#line 1729 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 1731 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1759 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 1779 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyReply reply;
															#line 6776 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKey()
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActor final : public Actor<Key>, public ActorCallback< GetKeyActor, 0, Void >, public ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetKeyActor, 2, Void >, public ActorCallback< GetKeyActor, 3, GetKeyReply >, public ActorCallback< GetKeyActor, 4, Void >, public FastAllocated<GetKeyActor>, public GetKeyActorState<GetKeyActor> {
															#line 6781 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyActor>::operator new;
	using FastAllocated<GetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14182871729349999872UL, 1382534406324509696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyActor, 0, Void >;
friend struct ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetKeyActor, 2, Void >;
friend struct ActorCallback< GetKeyActor, 3, GetKeyReply >;
friend struct ActorCallback< GetKeyActor, 4, Void >;
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActor(Reference<TransactionState> const& trState,KeySelector const& k) 
															#line 6802 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   GetKeyActorState<GetKeyActor>(trState, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3161838746568296704UL, 16159820804706226432UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetKeyActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Key> getKey( Reference<TransactionState> const& trState, KeySelector const& k ) {
															#line 1725 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Key>(new GetKeyActor(trState, k));
															#line 6838 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1826 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 6843 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitForCommittedVersion()
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WaitForCommittedVersionActor>
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActorState {
															#line 6850 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActorState(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1828 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:waitForCommittedVersion"_loc, spanContext)
															#line 6863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~WaitForCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1829 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 6878 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForCommittedVersionActorState();
		static_cast<WaitForCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1832 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 1831 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6911 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1833 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance( cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest( span.context, 0, TransactionPriority::IMMEDIATE, cx->ssVersionVectorCache.getMaxVersion()), cx->taskID);
															#line 6915 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 1832 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 0, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 1833 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 6922 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1857 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_batch_transaction_throttled || e.code() == error_code_grv_proxy_memory_limit_exceeded)
															#line 6944 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1860 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delayJittered(CLIENT_KNOBS->GRV_ERROR_RETRY_DELAY);
															#line 1860 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6950 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 1860 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 3, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 6955 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "WaitForCommittedVersionError").error(e);
															#line 1863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6964 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 1839 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 1840 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 6999 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 7003 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1842 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7007 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1843 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 7011 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1844 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7015 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1846 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 7021 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 1849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 7026 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1850 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 7030 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7040 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7045 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 1839 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 1840 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 7056 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1841 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 7060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1842 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7064 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1843 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 7068 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1844 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7072 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1846 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 7078 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 1849 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 7083 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1850 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 7087 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7097 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 1853 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 7102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 0, Void >::remove();
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1828 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 7429 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitForCommittedVersion()
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActor final : public Actor<Version>, public ActorCallback< WaitForCommittedVersionActor, 0, Void >, public ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >, public ActorCallback< WaitForCommittedVersionActor, 2, Void >, public ActorCallback< WaitForCommittedVersionActor, 3, Void >, public FastAllocated<WaitForCommittedVersionActor>, public WaitForCommittedVersionActorState<WaitForCommittedVersionActor> {
															#line 7434 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitForCommittedVersionActor>::operator new;
	using FastAllocated<WaitForCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14834717808799872000UL, 6963196102571707392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForCommittedVersionActor, 0, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >;
friend struct ActorCallback< WaitForCommittedVersionActor, 2, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 3, Void >;
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActor(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 7454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WaitForCommittedVersionActorState<WaitForCommittedVersionActor>(cx, version, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9303840678792357376UL, 476365445843715840UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> waitForCommittedVersion( Database const& cx, Version const& version, SpanContext const& spanContext ) {
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WaitForCommittedVersionActor(cx, version, spanContext));
															#line 7489 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1868 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 7494 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getRawVersion()
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRawVersionActor>
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActorState {
															#line 7501 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActorState(Reference<TransactionState> const& trState) 
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRawVersion"_loc, trState->spanContext)
															#line 7510 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetRawVersionActorState() 
	{
		fdb_probe_actor_destroy("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1871 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 7525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1873 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = trState->cx->onProxiesChanged();
															#line 1872 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance(trState->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest(trState->spanContext, 0, TransactionPriority::IMMEDIATE, trState->cx->ssVersionVectorCache.getMaxVersion()), trState->cx->taskID);
															#line 7561 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetRawVersionActor*>(this)->actor_wait_state = 1;
															#line 1873 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 0, Void >*>(static_cast<GetRawVersionActor*>(this)));
															#line 1874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*>(static_cast<GetRawVersionActor*>(this)));
															#line 7568 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7595 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 7599 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7603 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1886 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 7609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 1889 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 7614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 1882 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 7626 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 7630 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 7634 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1886 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 7640 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 1889 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 7645 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRawVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 0, Void >::remove();
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 7778 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRawVersion()
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActor final : public Actor<Version>, public ActorCallback< GetRawVersionActor, 0, Void >, public ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >, public FastAllocated<GetRawVersionActor>, public GetRawVersionActorState<GetRawVersionActor> {
															#line 7783 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRawVersionActor>::operator new;
	using FastAllocated<GetRawVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6415457307528868352UL, 7670650983149908224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRawVersionActor, 0, Void >;
friend struct ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >;
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActor(Reference<TransactionState> const& trState) 
															#line 7801 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetRawVersionActorState<GetRawVersionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6451071362418865408UL, 866680570832095232UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRawVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRawVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> getRawVersion( Reference<TransactionState> const& trState ) {
															#line 1869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new GetRawVersionActor(trState));
															#line 7834 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1894 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 7839 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> readVersionBatcher( DatabaseContext* const& cx, FutureStream<std::pair<Promise<GetReadVersionReply>, Optional<UID>>> const& versionStream, uint32_t const& flags );

#line 1899 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 7844 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watchValue()
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueActor>
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActorState {
															#line 7851 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActorState(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 1901 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:watchValue"_loc, parameters->spanContext),
															#line 1902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ver(parameters->version)
															#line 7864 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchValue", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueActorState() 
	{
		fdb_probe_actor_destroy("watchValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1903 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->validateVersion(parameters->version);
															#line 1904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(parameters->version != latestVersion);
															#line 1906 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 7883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueActorState();
		static_cast<WatchValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_0 = getKeyLocation(cx, parameters->key, &StorageServerInterface::watchValue, parameters->spanContext, parameters->debugID, parameters->useProvisionalProxies, Reverse::False, parameters->version);
															#line 1907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7915 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 1;
															#line 1907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*>(static_cast<WatchValueActor*>(this)));
															#line 7920 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 1916 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			watchValueID = Optional<UID>();
															#line 1917 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (parameters->debugID.present())
															#line 7932 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1918 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				watchValueID = nondeterministicRandom()->randomUniqueID();
															#line 1920 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "WatchValueAttachID", parameters->debugID.get().first(), watchValueID.get().first());
															#line 1922 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Before");
															#line 7940 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 1926 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			resp = WatchValueReply();
															#line 1928 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<WatchValueReply> __when_expr_1 = loadBalance(cx.getPtr(), locationInfo.locations, &StorageServerInterface::watchValue, WatchValueRequest(span.context, parameters->key, parameters->value, ver, cx->sampleReadTags() ? parameters->tags : Optional<TagSet>(), watchValueID), TaskPriority::DefaultPromiseEndpoint);
															#line 1927 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7948 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1941 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = cx->connectionRecord ? cx->connectionRecord->onChange() : Never();
															#line 7952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<WatchValueActor*>(this)->actor_wait_state = 2;
															#line 1928 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 1, WatchValueReply >*>(static_cast<WatchValueActor*>(this)));
															#line 1941 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 2, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 7959 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 7974 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1971 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 8060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1972 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->invalidateCache(parameters->key);
															#line 1973 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, parameters->taskID);
															#line 1973 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8068 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<WatchValueActor*>(this)->actor_wait_state = 5;
															#line 1973 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 5, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8073 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1974 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_watch_cancelled || e.code() == error_code_process_behind)
															#line 8080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 1976 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_watch_cancelled, "Too many watches on the storage server, poll for changes instead");
															#line 1977 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_process_behind, "The storage servers are all behind", probe::decoration::rare);
															#line 1979 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WATCH_POLLING_TIME, parameters->taskID);
															#line 1979 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8090 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when2(__when_expr_6.get(), loopDepth); };
					static_cast<WatchValueActor*>(this)->actor_wait_state = 6;
															#line 1979 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 6, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8095 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1980 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_timed_out)
															#line 8102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
															#line 1982 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						CODE_PROBE(true, "A watch timed out");
															#line 1983 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_7 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 1983 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
						if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when3(__when_expr_7.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 7;
															#line 1983 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 7, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 1985 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						err = e;
															#line 1986 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_8 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 1986 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8126 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
						if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when4(__when_expr_8.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 8;
															#line 1986 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 8, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8131 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1945 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 8149 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1946 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.After");
															#line 8153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 1952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Version> __when_expr_4 = waitForCommittedVersion(cx, resp.version, span.context);
															#line 1952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8159 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 4;
															#line 1952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 4, Version >*>(static_cast<WatchValueActor*>(this)));
															#line 8164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply const& r,int loopDepth) 
	{
															#line 1939 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 8173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply && r,int loopDepth) 
	{
															#line 1939 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 8182 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8193 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8198 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 1942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 8214 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 1, WatchValueReply >::remove();
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 1, WatchValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Version const& v,int loopDepth) 
	{
															#line 1960 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 1961 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 1962 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 8435 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1963 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 8439 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1965 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 1967 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 8449 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1968 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 8453 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Version && v,int loopDepth) 
	{
															#line 1960 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 1961 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 1962 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 8467 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1963 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 8471 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1965 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 1967 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 8481 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 1968 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 8485 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 1987 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 8862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 1987 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 8870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<const WatchParameters> parameters;
															#line 1901 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 1907 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1916 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> watchValueID;
															#line 1926 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueReply resp;
															#line 1985 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Error err;
															#line 8965 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchValue()
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActor final : public Actor<Version>, public ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >, public ActorCallback< WatchValueActor, 1, WatchValueReply >, public ActorCallback< WatchValueActor, 2, Void >, public ActorCallback< WatchValueActor, 3, Void >, public ActorCallback< WatchValueActor, 4, Version >, public ActorCallback< WatchValueActor, 5, Void >, public ActorCallback< WatchValueActor, 6, Void >, public ActorCallback< WatchValueActor, 7, Void >, public ActorCallback< WatchValueActor, 8, Void >, public FastAllocated<WatchValueActor>, public WatchValueActorState<WatchValueActor> {
															#line 8970 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchValueActor>::operator new;
	using FastAllocated<WatchValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3629485180411845376UL, 7046903559950592256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >;
friend struct ActorCallback< WatchValueActor, 1, WatchValueReply >;
friend struct ActorCallback< WatchValueActor, 2, Void >;
friend struct ActorCallback< WatchValueActor, 3, Void >;
friend struct ActorCallback< WatchValueActor, 4, Version >;
friend struct ActorCallback< WatchValueActor, 5, Void >;
friend struct ActorCallback< WatchValueActor, 6, Void >;
friend struct ActorCallback< WatchValueActor, 7, Void >;
friend struct ActorCallback< WatchValueActor, 8, Void >;
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActor(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 8995 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   WatchValueActorState<WatchValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460336902643348224UL, 8395577603832240640UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueActor, 1, WatchValueReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchValueActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatchValueActor, 4, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WatchValueActor, 5, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WatchValueActor, 6, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WatchValueActor, 7, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WatchValueActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> watchValue( Database const& cx, Reference<const WatchParameters> const& parameters ) {
															#line 1900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WatchValueActor(cx, parameters));
															#line 9035 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 1992 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 9040 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watchStorageServerResp()
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchStorageServerRespActor>
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActorState {
															#line 9047 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActorState(Key const& key,Database const& cx) 
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : key(key),
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx)
															#line 9056 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	~WatchStorageServerRespActorState() 
	{
		fdb_probe_actor_destroy("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1994 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 9071 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchStorageServerRespActorState();
		static_cast<WatchStorageServerRespActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = cx->getWatchMetadata(key);
															#line 1997 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 9104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 1998 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2001 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = watchValue(cx, metadata->parameters);
															#line 2001 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9118 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 1;
															#line 2001 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchStorageServerRespActor, 0, Version >*>(static_cast<WatchStorageServerRespActor*>(this)));
															#line 9123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2024 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 9145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2025 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9149 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2028 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Reference<WatchMetadata> metadata = cx->getWatchMetadata(key);
															#line 2029 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 9155 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2030 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9159 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2031 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 9169 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2032 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					cx->deleteWatchMetadata(key);
															#line 2033 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9175 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~WatchStorageServerRespActorState();
					static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2034 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_future_version)
															#line 9185 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
						return a_body1loopHead1(loopDepth); // continue
					}
				}
			}
															#line 2037 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(key);
															#line 2038 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.sendError(e);
															#line 2039 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9197 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& watchVersion,int loopDepth) 
	{
															#line 2003 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(key);
															#line 2004 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 9213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2005 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 9225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2009 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(key);
															#line 2010 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 9231 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2011 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 9235 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2015 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2019 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 9244 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2020 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(key);
															#line 9248 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && watchVersion,int loopDepth) 
	{
															#line 2003 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(key);
															#line 2004 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 9261 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2005 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 9265 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 9273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2009 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(key);
															#line 2010 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 9279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2011 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 9283 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2015 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2019 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 9292 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2020 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(key);
															#line 9296 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(watchVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(watchVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state > 0) static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 0;
		static_cast<WatchStorageServerRespActor*>(this)->ActorCallback< WatchStorageServerRespActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1996 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchMetadata> metadata;
															#line 9397 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchStorageServerResp()
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActor final : public Actor<Void>, public ActorCallback< WatchStorageServerRespActor, 0, Version >, public FastAllocated<WatchStorageServerRespActor>, public WatchStorageServerRespActorState<WatchStorageServerRespActor> {
															#line 9402 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchStorageServerRespActor>::operator new;
	using FastAllocated<WatchStorageServerRespActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14039339247301166592UL, 16302623143082865152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchStorageServerRespActor, 0, Version >;
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActor(Key const& key,Database const& cx) 
															#line 9419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WatchStorageServerRespActorState<WatchStorageServerRespActor>(key, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5937245291561340160UL, 16097796804231101184UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchStorageServerResp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchStorageServerRespActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchStorageServerResp( Key const& key, Database const& cx ) {
															#line 1993 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchStorageServerRespActor(key, cx));
															#line 9452 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2043 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 9457 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sameVersionDiffValue()
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SameVersionDiffValueActor>
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActorState {
															#line 9464 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActorState(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 2045 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(cx)
															#line 9475 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	~SameVersionDiffValueActorState() 
	{
		fdb_probe_actor_destroy("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2047 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 9490 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2049 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(parameters->key);
															#line 2050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 1;
															#line 2050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 9530 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2072 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2072 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 3;
															#line 2072 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 2, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 9559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2051 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->key);
															#line 2054 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (metadata.isValid() && valSS != metadata->parameters->value)
															#line 9576 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2055 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(parameters->key);
															#line 2057 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.send(parameters->version);
															#line 2058 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS.cancel();
															#line 9584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2062 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (valSS == parameters->value)
															#line 9588 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2063 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = makeReference<WatchMetadata>(parameters);
															#line 2064 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->setWatchMetadata(metadata);
															#line 2066 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS = watchStorageServerResp(parameters->key, cx);
															#line 2067 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(metadata->watchPromise.getFuture());
															#line 2067 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9600 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 2;
															#line 2067 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 1, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 9605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __valSS,int loopDepth) 
	{
															#line 2050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		valSS = __valSS;
															#line 9619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __valSS,int loopDepth) 
	{
		valSS = std::move(__valSS);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2070 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 9698 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchParameters> parameters;
															#line 2045 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> valSS;
															#line 9888 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sameVersionDiffValue()
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActor final : public Actor<Void>, public ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >, public ActorCallback< SameVersionDiffValueActor, 1, Void >, public ActorCallback< SameVersionDiffValueActor, 2, Void >, public FastAllocated<SameVersionDiffValueActor>, public SameVersionDiffValueActorState<SameVersionDiffValueActor> {
															#line 9893 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<SameVersionDiffValueActor>::operator new;
	using FastAllocated<SameVersionDiffValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16828558845945014528UL, 7477366134468897792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >;
friend struct ActorCallback< SameVersionDiffValueActor, 1, Void >;
friend struct ActorCallback< SameVersionDiffValueActor, 2, Void >;
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActor(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 9912 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SameVersionDiffValueActorState<SameVersionDiffValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345293727184951296UL, 14775766526751535104UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sameVersionDiffValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> sameVersionDiffValue( Database const& cx, Reference<WatchParameters> const& parameters ) {
															#line 2044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SameVersionDiffValueActor(cx, parameters));
															#line 9947 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2076 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> getWatchFuture(Database cx, Reference<WatchParameters> parameters) {
	Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->key);

	// case 1: key not in map
	if (!metadata.isValid()) {
		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->key, cx);
		return success(metadata->watchPromise.getFuture());
	}
	// case 2: val_1 == val_2 (received watch with same value as key already in the map so just update)
	else if (metadata->parameters->value == parameters->value) {
		if (parameters->version > metadata->parameters->version) {
			metadata->parameters = parameters;
		}

		return success(metadata->watchPromise.getFuture());
	}
	// case 3: val_1 != val_2 && version_2 > version_1 (received watch with different value and a higher version so
	// recreate in SS)
	else if (parameters->version > metadata->parameters->version) {
		CODE_PROBE(true,
		           "Setting a watch that has a different value than the one in the map but a higher version (newer)");
		cx->deleteWatchMetadata(parameters->key);

		metadata->watchPromise.send(parameters->version);
		metadata->watchFutureSS.cancel();

		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->key, cx);

		return success(metadata->watchPromise.getFuture());
	}
	// case 5: val_1 != val_2 && version_1 == version_2 (received watch with different value but same version)
	else if (metadata->parameters->version == parameters->version) {
		CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but the same version");
		return sameVersionDiffValue(cx, parameters);
	}
	CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but a lower version (older)");

	// case 4: val_1 != val_2 && version_2 < version_1
	return Void();
}

namespace {

// NOTE: Since an ACTOR could receive multiple exceptions for a single catch clause, e.g. broken promise together with
// operation cancelled, If the decreaseWatchRefCount is placed at the catch clause, it might be triggered for multiple
// times. One could check if the SAV isSet, but seems a more intuitive way is to use RAII-style constructor/destructor
// pair. Yet the object has to be constructed after a wait statement, so it must be trivially-constructible. This
// requires move-assignment operator implemented.
class WatchRefCountUpdater {
	Database cx;
	KeyRef key;
	Version version;

public:
	WatchRefCountUpdater() = default;

	WatchRefCountUpdater(const Database& cx_, KeyRef key_, const Version& ver) : cx(cx_), key(key_), version(ver) {}

	WatchRefCountUpdater& operator=(WatchRefCountUpdater&& other) {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(key, version);
		}

		cx = std::move(other.cx);
		key = std::move(other.key);
		version = std::move(other.version);

		cx->increaseWatchRefCount(key, version);

		return *this;
	}

	~WatchRefCountUpdater() {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(key, version);
		}
	}
};

} // namespace

															#line 10039 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watchValueMap()
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueMapActor>
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActorState {
															#line 10046 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActorState(Future<Version> const& version,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : version(version),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   value(value),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 10069 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueMapActorState() 
	{
		fdb_probe_actor_destroy("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = version;
															#line 2173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10086 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchValueMapActor*>(this)->actor_wait_state = 1;
															#line 2173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 0, Version >*>(static_cast<WatchValueMapActor*>(this)));
															#line 10091 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		watchRefCountUpdater = WatchRefCountUpdater(cx, key, ver);
															#line 2176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = getWatchFuture( cx, makeReference<WatchParameters>(key, value, ver, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 2176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10118 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchValueMapActor*>(this)->actor_wait_state = 2;
															#line 2176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 1, Void >*>(static_cast<WatchValueMapActor*>(this)));
															#line 10123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __ver,int loopDepth) 
	{
															#line 2173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = __ver;
															#line 10132 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __ver,int loopDepth) 
	{
		ver = std::move(__ver);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2180 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 10211 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2180 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 10223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Version> version;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> value;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 2174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchRefCountUpdater watchRefCountUpdater;
															#line 10328 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchValueMap()
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActor final : public Actor<Void>, public ActorCallback< WatchValueMapActor, 0, Version >, public ActorCallback< WatchValueMapActor, 1, Void >, public FastAllocated<WatchValueMapActor>, public WatchValueMapActorState<WatchValueMapActor> {
															#line 10333 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchValueMapActor>::operator new;
	using FastAllocated<WatchValueMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15182618928005555712UL, 17799777993537486592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueMapActor, 0, Version >;
friend struct ActorCallback< WatchValueMapActor, 1, Void >;
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActor(Future<Version> const& version,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 10351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WatchValueMapActorState<WatchValueMapActor>(version, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15055311216113119744UL, 3063023898867388672UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValueMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueMapActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueMapActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchValueMap( Future<Version> const& version, Key const& key, Optional<Value> const& value, Database const& cx, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchValueMapActor(version, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 10385 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2182 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class GetKeyValuesFamilyRequest>
void transformRangeLimits(GetRangeLimits limits, Reverse reverse, GetKeyValuesFamilyRequest& req) {
	if (limits.bytes != 0) {
		if (!limits.hasRowLimit())
			req.limit = CLIENT_KNOBS->REPLY_BYTE_LIMIT; // Can't get more than this many rows anyway
		else
			req.limit = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.rows);

		if (reverse)
			req.limit *= -1;

		if (!limits.hasByteLimit())
			req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		else
			req.limitBytes = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.bytes);
	} else {
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		req.limit = reverse ? -limits.minRows : limits.minRows;
	}
}

template <class GetKeyValuesFamilyRequest>
PublicRequestStream<GetKeyValuesFamilyRequest> StorageServerInterface::* getRangeRequestStream() {
	if constexpr (std::is_same<GetKeyValuesFamilyRequest, GetKeyValuesRequest>::value) {
		return &StorageServerInterface::getKeyValues;
	} else if (std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value) {
		return &StorageServerInterface::getMappedKeyValues;
	} else {
		UNREACHABLE();
	}
}

															#line 10422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getExactRange()
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetExactRangeActor>
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActorState {
															#line 10429 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActorState(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2222 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getExactRange"_loc, trState->spanContext)
															#line 10448 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	~GetExactRangeActorState() 
	{
		fdb_probe_actor_destroy("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2224 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 10463 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExactRangeActorState();
		static_cast<GetExactRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations(trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, getRangeRequestStream<GetKeyValuesFamilyRequest>());
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10495 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetExactRangeActor*>(this)->actor_wait_state = 1;
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetExactRangeActor*>(this)));
															#line 10500 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2231 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 2232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 2233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 10513 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 10522 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2234 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRangeRef& range = locations[shard].range;
															#line 2236 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		GetKeyValuesFamilyRequest req;
															#line 2237 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2240 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2241 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 2242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 2244 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 2245 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 2248 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(locations[shard].range.arena());
															#line 2250 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2251 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 2254 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 2256 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 10640 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 2259 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 10644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2260 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.Before");
															#line 10648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2272 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 10654 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			try {
															#line 2276 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 2275 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 10660 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance( trState->cx.getPtr(), locations[shard].locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 10664 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 2;
															#line 2276 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 1, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 2279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetExactRangeActor*>(this)));
															#line 10671 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2378 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 10712 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2379 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2381 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 10718 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2382 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 10722 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2384 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 10728 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 2386 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(keys);
															#line 2388 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2388 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10736 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 3;
															#line 2388 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 3, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 10741 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2391 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetExactRangeError") .error(e) .detail("ShardBegin", locations[shard].range.begin) .detail("ShardEnd", locations[shard].range.end);
															#line 2395 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 10750 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2297 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 10765 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 10769 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2301 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 2302 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 2304 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasRowLimit() && rep.data.size() > limits.rows)
															#line 10777 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2305 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevError, "GetExactRangeTooManyRows") .detail("RowLimit", limits.rows) .detail("DeliveredRows", output.size());
															#line 2308 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(false);
															#line 10783 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2310 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 2312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.isReached())
															#line 10789 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2313 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2314 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 10795 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2317 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool more = rep.more;
															#line 2319 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 10805 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2321 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			more = false;
															#line 10809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2323 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (more)
															#line 10813 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2324 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 10817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2325 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetExactRangeError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 2333 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 10823 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getExactRange");
															#line 2337 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 10829 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2338 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 10833 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2341 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 10839 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 2345 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool redoKeyLocationRequest = false;
															#line 2346 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!more || locations[shard].range.empty())
															#line 10846 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2347 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "getExactrange (!more || locations[shard].first.empty())");
															#line 2348 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 10852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2349 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 2351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 2353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 10862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = false;
															#line 2355 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 10868 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
					this->~GetExactRangeActorState();
					static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2358 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 2359 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				redoKeyLocationRequest = true;
															#line 10878 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2362 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++shard;
															#line 10882 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasSatisfiedMinRows() && output.size() > 0)
															#line 10886 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2370 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 10892 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2373 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (redoKeyLocationRequest)
															#line 10900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2374 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Multiple requests of key locations");
															#line 10904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2294 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2295 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1loopBody1cont1loopBody1Catch1(__current_error, loopDepth);
															#line 10918 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(int loopDepth) 
	{
															#line 2292 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 10932 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 10941 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 10949 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 2289 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 10957 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 2289 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 10966 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 1, Void >::remove();
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2222 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 2232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 2273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 11225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getExactRange()
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >, public FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 11232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13344778123450702080UL, 2878294400965964032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >;
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActor(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 11252 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<RangeResultFamily>(),
		   GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, keys, mapper, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3520479274471320064UL, 12983301301951641856UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExactRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getExactRange( Reference<TransactionState> const& trState, KeyRange const& keys, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 2215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, keys, mapper, limits, reverse));
															#line 11289 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2401 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Key> resolveKey(Reference<TransactionState> trState, KeySelector const& key) {
	if (key.isFirstGreaterOrEqual())
		return Future<Key>(key.getKey());

	if (key.isFirstGreaterThan())
		return Future<Key>(keyAfter(key.getKey()));

	return getKey(trState, key);
}

															#line 11304 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getRangeFallback()
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeFallbackActor>
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActorState {
															#line 11311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse)
															#line 11328 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeFallbackActorState() 
	{
		fdb_probe_actor_destroy("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Future<Key> fb = resolveKey(trState, begin);
															#line 2420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			fe = resolveKey(trState, end);
															#line 2422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Key> __when_expr_0 = fb;
															#line 2422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11349 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 1;
															#line 2422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 0, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 11354 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fe;
															#line 2423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11379 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 2;
															#line 2423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 1, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 11384 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& __b,int loopDepth) 
	{
															#line 2422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 11393 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2424 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 11472 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(RangeResultFamily()); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 11476 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(RangeResultFamily());
			this->~GetRangeFallbackActorState();
			static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResultFamily> __when_expr_2 = getExactRange<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, KeyRangeRef(b, e), mapper, limits, reverse);
															#line 2432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11486 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 3;
															#line 2432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 11491 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __e,int loopDepth) 
	{
															#line 2423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 11500 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(RangeResultFamily const& _r,int loopDepth) 
	{
															#line 2434 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 11581 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2437 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 11585 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2444 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 11589 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2445 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 11593 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2450 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 11599 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 11603 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2461 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 11607 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(RangeResultFamily && _r,int loopDepth) 
	{
															#line 2434 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 11621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2437 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 11625 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2444 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 11629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2445 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 11633 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2450 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 11639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 11643 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2461 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 11647 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily const& _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(_r, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily && _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 2422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 2423 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 11748 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeFallback()
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >, public FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 11755 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16047310259345721344UL, 7441581885451106304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >;
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 11774 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<RangeResultFamily>(),
		   GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3517076735759144704UL, 3895872481659177216UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRangeFallback( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 2412 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, reverse));
															#line 11811 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2463 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

int64_t inline getRangeResultFamilyBytes(RangeResultRef result) {
	return result.expectedSize();
}

int64_t inline getRangeResultFamilyBytes(MappedRangeResultRef result) {
	int64_t bytes = 0;
	for (const MappedKeyValueRef& mappedKeyValue : result) {
		bytes += mappedKeyValue.key.size() + mappedKeyValue.value.size();
		auto& reqAndResult = mappedKeyValue.reqAndResult;
		if (std::holds_alternative<GetValueReqAndResultRef>(reqAndResult)) {
			auto getValue = std::get<GetValueReqAndResultRef>(reqAndResult);
			bytes += getValue.expectedSize();
		} else if (std::holds_alternative<GetRangeReqAndResultRef>(reqAndResult)) {
			auto getRange = std::get<GetRangeReqAndResultRef>(reqAndResult);
			bytes += getRange.result.expectedSize();
		} else {
			throw internal_error();
		}
	}
	return bytes;
}

// TODO: Client should add mapped keys to conflict ranges.
template <class RangeResultFamily> // RangeResult or MappedRangeResult
void getRangeFinished(Reference<TransactionState> trState,
                      double startTime,
                      KeySelector begin,
                      KeySelector end,
                      Snapshot snapshot,
                      Promise<std::pair<Key, Key>> conflictRange,
                      Reverse reverse,
                      RangeResultFamily result) {
	int64_t bytes = getRangeResultFamilyBytes(result);

	trState->totalCost += getReadOperationCost(bytes);
	trState->cx->transactionBytesRead += bytes;
	trState->cx->transactionKeysRead += result.size();

	if (trState->trLogInfo) {
		trState->trLogInfo->addLog(FdbClientLogEvents::EventGetRange(
		    startTime, trState->cx->clientLocality.dcId(), now() - startTime, bytes, begin.getKey(), end.getKey()));
	}

	if (!snapshot) {
		Key rangeBegin;
		Key rangeEnd;

		if (result.readToBegin) {
			rangeBegin = allKeys.begin;
		} else if (((!reverse || !result.more || begin.offset > 1) && begin.offset > 0) || result.size() == 0) {
			rangeBegin = Key(begin.getKey(), begin.arena());
		} else {
			rangeBegin = reverse ? result.end()[-1].key : result[0].key;
		}

		if (end.offset > begin.offset && end.getKey() < rangeBegin) {
			rangeBegin = Key(end.getKey(), end.arena());
		}

		if (result.readThroughEnd) {
			rangeEnd = allKeys.end;
		} else if (((reverse || !result.more || end.offset <= 0) && end.offset <= 1) || result.size() == 0) {
			rangeEnd = Key(end.getKey(), end.arena());
		} else {
			rangeEnd = keyAfter(reverse ? result[0].key : result.end()[-1].key);
		}

		if (begin.offset < end.offset && begin.getKey() > rangeEnd) {
			rangeEnd = Key(begin.getKey(), begin.arena());
		}

		conflictRange.send(std::make_pair(rangeBegin, rangeEnd));
	}
}

															#line 11891 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getRange()
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeActor>
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActorState {
															#line 11898 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalLimits(limits),
															#line 2555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalBegin(begin),
															#line 2556 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalEnd(end),
															#line 2557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2558 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRange"_loc, trState->spanContext),
															#line 2559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   getRangeID(Optional<UID>())
															#line 11931 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRange", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeActorState() 
	{
		fdb_probe_actor_destroy("getRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 2562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11949 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 1;
															#line 2562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 0, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 11954 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2831 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (conflictRange.canBeSet())
															#line 11984 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2832 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				conflictRange.send(std::make_pair(Key(), Key()));
															#line 11988 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2835 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 11992 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2563 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2567 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 12010 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2568 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2569 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 12016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2572 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2573 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2575 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 12024 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2563 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2567 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 12037 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2568 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2569 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 12043 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2572 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2573 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2575 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 12051 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2576 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (end.getKey() == allKeys.begin && (end.offset < 1 || end.isFirstGreaterOrEqual()))
															#line 12142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2577 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2579 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2582 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey = reverse ? Key(end.getKey(), end.arena()) : Key(begin.getKey(), begin.arena());
															#line 2583 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reverse locationBackward{ reverse ? (end - 1).isBackward() : begin.isBackward() };
															#line 2584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation( trState, locationKey, getRangeRequestStream<GetKeyValuesFamilyRequest>(), locationBackward);
															#line 2584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12162 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 2;
															#line 2584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*>(static_cast<GetRangeActor*>(this)));
															#line 12167 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2586 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = beginServer.range;
															#line 2587 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		modifiedSelectors = false;
															#line 2588 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesFamilyRequest();
															#line 2589 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2590 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2591 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 2592 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2593 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.taskID = trState->taskID;
															#line 2595 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(beginServer.locations, trState, req.ssLatestCommitVersions);
															#line 2599 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool dependOnShard = false;
															#line 2600 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && (begin - 1).isDefinitelyLess(shard.begin) && (!begin.isFirstGreaterOrEqual() || begin.getKey() != shard.begin))
															#line 12196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2605 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = firstGreaterOrEqual(shard.begin);
															#line 2606 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2607 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(shard.arena());
															#line 2608 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			dependOnShard = true;
															#line 12206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = begin;
															#line 2611 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(begin.arena());
															#line 12214 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!reverse && end.isDefinitelyGreater(shard.end))
															#line 12218 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = firstGreaterOrEqual(shard.end);
															#line 2616 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2617 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!dependOnShard)
															#line 12226 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				req.arena.dependsOn(shard.arena());
															#line 12230 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = end;
															#line 2622 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(end.arena());
															#line 12239 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2625 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2626 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 2628 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 2629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 2630 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 12251 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2631 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeID = nondeterministicRandom()->randomUniqueID();
															#line 2632 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "TransactionAttachID", trState->readOptions.get().debugID.get().first(), getRangeID.get().first());
															#line 12257 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		try {
															#line 2636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 12262 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2637 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Before");
															#line 12266 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2657 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2658 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 12272 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			try {
															#line 2660 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 12276 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2661 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont2loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 12280 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 2665 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance(trState->cx.getPtr(), beginServer.locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 2665 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 12286 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 3;
															#line 2665 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetRangeActor*>(this)));
															#line 12291 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(KeyRangeLocationInfo const& __beginServer,int loopDepth) 
	{
															#line 2584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		beginServer = __beginServer;
															#line 12312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(KeyRangeLocationInfo && __beginServer,int loopDepth) 
	{
		beginServer = std::move(__beginServer);
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2800 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 12398 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2801 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Error");
															#line 2802 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent("TransactionDebugError", getRangeID.get()).error(e);
															#line 12404 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2804 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 12408 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2805 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(reverse ? end.getKey() : begin.getKey(), Reverse{ reverse ? (end - 1).isBackward() : begin.isBackward() });
															#line 2808 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_wrong_shard_server)
															#line 12414 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<RangeResultFamily> __when_expr_4 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse);
															#line 2809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12420 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
					static_cast<GetRangeActor*>(this)->actor_wait_state = 5;
															#line 2809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 4, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 12425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2loopBody1cont1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 2819 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo)
															#line 12437 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2820 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog( FdbClientLogEvents::EventGetRangeError(startTime, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), begin.getKey(), end.getKey()));
															#line 12441 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 2826 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 12445 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10(int loopDepth) 
	{
															#line 2682 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getRangeID.present())
															#line 12460 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2683 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.After");
															#line 12464 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2697 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!rep.more || rep.data.size());
															#line 2698 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || rep.data.size() <= limits.rows);
															#line 2700 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 2702 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && begin.isLastLessOrEqual() && rep.data.size() && rep.data.end()[-1].key == begin.getKey())
															#line 12474 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2704 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = false;
															#line 12478 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2707 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool finished = limits.isReached() || (!modifiedSelectors && !rep.more) || limits.hasSatisfiedMinRows();
															#line 2708 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool readThrough = modifiedSelectors && !rep.more;
															#line 2711 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished && !output.size())
															#line 12486 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2712 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readToBegin = output.readToBegin;
															#line 2713 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readThroughEnd = output.readThroughEnd;
															#line 2715 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			using RangeResultRefFamily = typename RangeResultFamily::RefType;
															#line 2716 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output = RangeResultFamily( RangeResultRefFamily(rep.data, modifiedSelectors || limits.isReached() || rep.more), rep.arena);
															#line 2718 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = readToBegin;
															#line 2719 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = readThroughEnd;
															#line 2721 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (BUGGIFY && limits.hasByteLimit() && output.size() > std::max(1, originalLimits.minRows) && (!std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value))
															#line 12502 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2726 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				RangeResultFamily copy;
															#line 2727 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				int newSize = deterministicRandom()->randomInt(std::max(1, originalLimits.minRows), output.size());
															#line 2729 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				for(int i = 0;i < newSize;i++) {
															#line 2730 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					copy.push_back_deep(copy.arena(), output[i]);
															#line 12512 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 2732 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output = copy;
															#line 2733 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 2735 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2737 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12522 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
				this->~GetRangeActorState();
				static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2740 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 12530 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2741 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 2743 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(modifiedSelectors);
															#line 2744 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 2745 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 12540 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2748 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2750 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 12546 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2751 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 12550 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2753 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 2757 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 2759 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished)
															#line 12566 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2760 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = modifiedSelectors || limits.isReached() || rep.more;
															#line 2761 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 12572 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2762 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 2763 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 12578 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2766 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2768 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 12584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2769 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 12588 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2771 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12592 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2774 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!rep.more)
															#line 12600 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2775 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(modifiedSelectors);
															#line 2776 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "!GetKeyValuesFamilyReply.more and modifiedSelectors in getRange");
															#line 2778 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 12608 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2779 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<RangeResultFamily> __when_expr_3 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse);
															#line 2779 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 12614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont10when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 4;
															#line 2779 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 3, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 12619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont10cont12(loopDepth);
			}
		}
		else
		{
															#line 2792 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getRange");
															#line 2793 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 12633 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2794 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				end = firstGreaterOrEqual(output[output.size() - 1].key);
															#line 12637 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2796 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				begin = firstGreaterThan(output[output.size() - 1].key);
															#line 12643 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2678 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2679 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont2loopBody1cont1Catch1(__current_error, loopDepth);
															#line 12657 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont12(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 2675 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 2676 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 12673 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont12(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 2675 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 2676 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 12684 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont12(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont12(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10cont12(int loopDepth) 
	{
															#line 2787 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 12787 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2788 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			end = firstGreaterOrEqual(shard.begin);
															#line 12791 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2790 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = firstGreaterOrEqual(shard.end);
															#line 12797 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10cont13(RangeResultFamily const& result,int loopDepth) 
	{
															#line 2782 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 2784 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10cont13(RangeResultFamily && result,int loopDepth) 
	{
															#line 2782 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 2784 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12823 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont10cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont10cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 3, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont3(int loopDepth) 
	{
															#line 2817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12931 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1Catch1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 6;
															#line 2817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 5, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 12936 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont4(RangeResultFamily const& result,int loopDepth) 
	{
															#line 2812 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 2814 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12947 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont4(RangeResultFamily && result,int loopDepth) 
	{
															#line 2812 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 2814 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 12961 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont4(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont4(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 4, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits originalLimits;
															#line 2555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalBegin;
															#line 2556 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalEnd;
															#line 2557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2558 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getRangeID;
															#line 2565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 2584 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo beginServer;
															#line 2586 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shard;
															#line 2587 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool modifiedSelectors;
															#line 2588 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyRequest req;
															#line 2658 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 13171 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRange()
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >, public FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 13178 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6780225968907315712UL, 2564664237733793280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >;
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 13200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<RangeResultFamily>(),
		   GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2910272544121951744UL, 708275608187718144UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRange( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse ) {
															#line 2539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse));
															#line 13240 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2838 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class StreamReply>
struct TSSDuplicateStreamData {
	PromiseStream<StreamReply> stream;
	Promise<Void> tssComparisonDone;

	// empty constructor for optional?
	TSSDuplicateStreamData() {}

	TSSDuplicateStreamData(PromiseStream<StreamReply> stream) : stream(stream) {}

	bool done() { return tssComparisonDone.getFuture().isReady(); }

	void setDone() {
		if (tssComparisonDone.canBeSet()) {
			tssComparisonDone.send(Void());
		}
	}

	~TSSDuplicateStreamData() {}
};

// Error tracking here is weird, and latency doesn't really mean the same thing here as it does with normal tss
// comparisons, so this is pretty much just counting mismatches
															#line 13268 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via tssStreamComparison()
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request, class TssStreamComparisonActor>
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActorState {
															#line 13275 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActorState(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : request(request),
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   streamData(streamData),
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReplyStream(tssReplyStream),
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssData(tssData),
															#line 2867 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssEndOfStream(false),
															#line 2868 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssEndOfStream(false),
															#line 2869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssReply(Optional<REPLYSTREAM_TYPE(Request)>()),
															#line 2870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReply(Optional<REPLYSTREAM_TYPE(Request)>())
															#line 13296 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	~TssStreamComparisonActorState() 
	{
		fdb_probe_actor_destroy("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2872 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 13311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssStreamComparisonActorState();
		static_cast<TssStreamComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 2875 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 2877 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 13345 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 2880 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_0 = streamData.stream.getFuture();
															#line 13349 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 2880 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 1;
															#line 2880 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 13358 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2897 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		sleepTime = std::max(startTime + FLOW_KNOBS->LOAD_BALANCE_TSS_TIMEOUT - now(), 0.0);
															#line 13373 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 2901 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_1 = tssReplyStream.getFuture();
															#line 13377 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 2900 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 13381 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
															#line 2904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(sleepTime);
															#line 13385 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 2;
															#line 2901 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 2904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssStreamComparisonActor, 2, Void >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 13392 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2883 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13408 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 2885 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 13414 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2887 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 13418 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2890 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ssEndOfStream = true;
															#line 13422 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2892 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->ssError(e.code());
															#line 13428 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2894 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "SS got error in TSS stream comparison");
															#line 13432 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
															#line 2881 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 13447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
															#line 2881 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 13456 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_ssReply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_ssReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 2924 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssEndOfStream || !tssEndOfStream)
															#line 13553 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2925 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++tssData.metrics->streamComparisons;
															#line 13557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 2929 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (ssReply.present() && tssReply.present())
															#line 13561 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2936 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if ((!ssEndOfStream || !tssEndOfStream) && !TSS_doCompare(ssReply.get(), tssReply.get()))
															#line 13565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2937 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				CODE_PROBE(true, "TSS mismatch in stream comparison");
															#line 2938 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent mismatchEvent( (g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 2943 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.setMaxEventLength(FLOW_KNOBS->TSS_LARGE_TRACE_SIZE);
															#line 2944 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.detail("TSSID", tssData.tssId);
															#line 2946 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssData.metrics->shouldRecordDetailedMismatch())
															#line 13577 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 2947 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					TSS_traceMismatch(mismatchEvent, request, ssReply.get(), tssReply.get(), TSS_COMPARISON);
															#line 2949 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Full TSS Mismatch in stream comparison", probe::decoration::rare);
															#line 2952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Partial TSS Mismatch in stream comparison and storing the rest in FDB");
															#line 2955 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL)
															#line 13587 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
															#line 2956 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						mismatchEvent.disable();
															#line 2957 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						UID mismatchUID = deterministicRandom()->randomUniqueID();
															#line 2958 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssData.metrics->recordDetailedMismatchData(mismatchUID, mismatchEvent.getFields().toString());
															#line 2961 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						TraceEvent summaryEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 2966 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						summaryEvent.detail("TSSID", tssData.tssId).detail("MismatchId", mismatchUID);
															#line 13599 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2970 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					mismatchEvent.disable();
															#line 13606 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 2972 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 2973 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 13612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TssStreamComparisonActorState();
				static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 2976 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssReply.present() || !tssReply.present() || ssEndOfStream || tssEndOfStream)
															#line 13621 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 2978 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			streamData.setDone();
															#line 2979 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 13627 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TssStreamComparisonActorState();
			static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2910 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13642 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2911 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 2912 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 13648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2914 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 13652 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 2917 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssEndOfStream = true;
															#line 13656 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2919 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->tssError(e.code());
															#line 13662 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 2921 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "TSS got error in TSS stream comparison");
															#line 13666 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) const& _tssReply,int loopDepth) 
	{
															#line 2902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 13687 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) && _tssReply,int loopDepth) 
	{
															#line 2902 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 13696 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 2905 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 2906 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 13707 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 2905 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 2906 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 13718 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >::remove();
		static_cast<TssStreamComparisonActor*>(this)->ActorCallback< TssStreamComparisonActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssStreamComparisonActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Request request;
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData;
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream;
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSEndpointData tssData;
															#line 2867 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool ssEndOfStream;
															#line 2868 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool tssEndOfStream;
															#line 2869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> ssReply;
															#line 2870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> tssReply;
															#line 2877 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 2897 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double sleepTime;
															#line 13877 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tssStreamComparison()
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActor final : public Actor<Void>, public ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >, public ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >, public ActorCallback< TssStreamComparisonActor<Request>, 2, Void >, public FastAllocated<TssStreamComparisonActor<Request>>, public TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>> {
															#line 13884 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<TssStreamComparisonActor<Request>>::operator new;
	using FastAllocated<TssStreamComparisonActor<Request>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6105835456194956544UL, 17633354705739776000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >;
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >;
friend struct ActorCallback< TssStreamComparisonActor<Request>, 2, Void >;
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActor(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 13903 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>>(request, streamData, tssReplyStream, tssData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12049828901958652672UL, 1449468964280732928UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssStreamComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> tssStreamComparison( Request const& request, TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData, ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream, TSSEndpointData const& tssData ) {
															#line 2862 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new TssStreamComparisonActor<Request>(request, streamData, tssReplyStream, tssData));
															#line 13939 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 2983 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Currently only used for GetKeyValuesStream but could easily be plugged for other stream types
// User of the stream has to forward the SS's responses to the returned promise stream, if it is set
template <class Request, bool P>
Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>
maybeDuplicateTSSStreamFragment(Request& req, QueueModel* model, RequestStream<Request, P> const* ssStream) {
	if (model) {
		Optional<TSSEndpointData> tssData = model->getTssData(ssStream->getEndpoint().token.first());

		if (tssData.present()) {
			CODE_PROBE(true, "duplicating stream to TSS");
			resetReply(req);
			// FIXME: optimize to avoid creating new netNotifiedQueueWithAcknowledgements for each stream duplication
			RequestStream<Request> tssRequestStream(tssData.get().endpoint);
			ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream = tssRequestStream.getReplyStream(req);
			PromiseStream<REPLYSTREAM_TYPE(Request)> ssDuplicateReplyStream;
			TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData(ssDuplicateReplyStream);
			model->addActor.send(tssStreamComparison(req, streamData, tssReplyStream, tssData.get()));
			return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>(streamData);
		}
	}
	return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>();
}

// Streams all of the KV pairs in a target key range into a ParallelStream fragment
															#line 13968 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getRangeStreamFragment()
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamFragmentActor>
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActorState {
															#line 13975 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActorState(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(results),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext)
															#line 13994 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamFragmentActorState() 
	{
		fdb_probe_actor_destroy("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3015 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 14009 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations( trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, &StorageServerInterface::getKeyValuesStream);
															#line 3016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14041 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 1;
															#line 3016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14046 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3018 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 3019 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 3020 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 14059 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 3016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 14068 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 3021 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRange& range = locations[shard].range;
															#line 3023 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>>();
															#line 3024 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesStreamRequest();
															#line 3025 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 3026 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 3027 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 3028 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = spanContext;
															#line 3029 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limit = reverse ? -CLIENT_KNOBS->REPLY_BYTE_LIMIT : CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 3030 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limitBytes = std::numeric_limits<int>::max();
															#line 3031 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 3033 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 3036 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(range.arena());
															#line 3038 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 3041 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 14186 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		try {
															#line 3044 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 14190 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3045 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.RangeStream.Before");
															#line 14194 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3049 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 3050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 3052 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (locations[shard].locations->size() == 0)
															#line 14202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3053 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 3053 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 2;
															#line 3053 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 1, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3252 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 14253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssDuplicateStream.get().stream.sendError(e);
															#line 14257 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3255 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14261 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3256 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 14265 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3258 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_connection_failed || e.code() == error_code_request_maybe_delivered)
															#line 14269 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3260 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 3262 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 14275 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 3263 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 14279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
				else
				{
															#line 3265 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 14285 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 3267 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(keys);
															#line 3269 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 3269 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14293 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 6;
															#line 3269 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 6, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 3272 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				results->sendError(e);
															#line 3273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 14307 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeStreamFragmentActorState();
				static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 3058 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = -1;
															#line 3060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 14328 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 3054 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3055 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 14339 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 3054 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3055 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 14353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
															#line 3099 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		replyStream = locations[shard] .locations->get(useIdx, &StorageServerInterface::getKeyValuesStream) .getReplyStream(req);
															#line 3104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = maybeDuplicateTSSStreamFragment( req, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, &locations[shard].locations->get(useIdx, &StorageServerInterface::getKeyValuesStream));
															#line 3109 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		breakAgain = false;
															#line 3110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 14446 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 3063 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int count = 0;
															#line 3064 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < locations[shard].locations->size();i++) {
															#line 3065 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!IFailureMonitor::failureMonitor() .getState(locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint()) .failed)
															#line 14466 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3070 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (deterministicRandom()->random01() <= 1.0 / ++count)
															#line 14470 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 3071 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					useIdx = i;
															#line 14474 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
			}
		}
															#line 3076 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useIdx >= 0)
															#line 14480 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<Future<Void>> ok(locations[shard].locations->size());
															#line 3081 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < ok.size();i++) {
															#line 3082 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ok[i] = IFailureMonitor::failureMonitor().onStateEqual( locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint(), FailureStatus(false));
															#line 14490 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3090 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (now() - g_network->networkInfo.newestAlternativesFailure > 1 || deterministicRandom()->random01() < 0.01)
															#line 14494 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3092 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("AllAlternativesFailed") .detail("Alternatives", locations[shard].locations->description());
															#line 14498 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3096 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = allAlternativesFailedDelay(quorum(ok, 1));
															#line 3096 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14504 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 3;
															#line 3096 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 2, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14509 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont7(int loopDepth) 
	{
															#line 3247 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (breakAgain)
															#line 14618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1(int loopDepth) 
	{
															#line 3111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = results->onEmpty();
															#line 3111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont6loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 4;
															#line 3111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 3, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 3114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14669 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 14673 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14681 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 3114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14699 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 14703 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 14711 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont2(int loopDepth) 
	{
															#line 3143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 14801 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 14805 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResult output(RangeResultRef(rep.data, rep.more), rep.arena);
															#line 3149 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 14811 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3151 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyValuesStreamReply replyCopy;
															#line 3152 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.version = rep.version;
															#line 3153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.more = rep.more;
															#line 3154 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.cached = rep.cached;
															#line 3155 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.arena.dependsOn(rep.arena);
															#line 3156 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.data.append(replyCopy.arena, rep.data.begin(), rep.data.size());
															#line 3157 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.send(replyCopy);
															#line 14827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3160 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int64_t bytes = 0;
															#line 3161 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( const KeyValueRef& kv : output ) {
															#line 3162 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bytes += kv.key.size() + kv.value.size();
															#line 14835 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3165 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += bytes;
															#line 3166 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionKeysRead += output.size();
															#line 3169 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && output.more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 14843 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3171 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 14847 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (output.more)
															#line 14851 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3175 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 14855 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetRangeStreamError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 3184 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 14861 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3186 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesStreamReply.more in getRangeStream");
															#line 3188 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 14867 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3189 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 14871 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3192 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 14877 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
		}
															#line 3196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations[shard].range.empty())
															#line 14882 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3197 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 14886 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!output.more)
															#line 14890 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3201 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			const KeyRange& range = locations[shard].range;
															#line 3202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 14896 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3203 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 3204 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 3206 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 14904 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 3207 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.begin == allKeys.begin)
															#line 14908 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
															#line 3208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readToBegin = true;
															#line 14912 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					}
															#line 3210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.end == allKeys.end)
															#line 14916 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
															#line 3211 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readThroughEnd = true;
															#line 14920 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					}
															#line 3213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.arena().dependsOn(keys.arena());
															#line 3216 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = true;
															#line 3217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.setReadThrough(reverse ? keys.begin : keys.end);
															#line 3218 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->send(std::move(output));
															#line 3219 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->finish();
															#line 3220 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 14934 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					{
															#line 3221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssDuplicateStream.get().stream.sendError(end_of_stream());
															#line 14938 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					}
															#line 3223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 14942 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeStreamFragmentActorState();
					static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 3225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 3226 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				breakAgain = true;
															#line 14952 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
			else
			{
															#line 3228 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				++shard;
															#line 14958 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3230 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.arena().dependsOn(range.arena());
															#line 3232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 3233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.setReadThrough(reverse ? range.begin : range.end);
															#line 3234 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			results->send(std::move(output));
															#line 14968 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(output.size());
															#line 3239 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.begin == allKeys.begin && !reverse)
															#line 14975 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3240 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 14979 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.end == allKeys.end && reverse)
															#line 14983 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3243 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = true;
															#line 14987 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3245 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->send(std::move(output));
															#line 14991 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 3129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 15003 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3130 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15007 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 3131 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(connection_failed());
															#line 15011 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 3133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(connection_failed(), std::max(0, loopDepth - 1));
															#line 15015 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 15019 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			{
															#line 3136 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15023 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				{
															#line 3137 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(e);
															#line 15027 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				}
															#line 3139 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 15031 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 15035 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont3(int loopDepth) 
	{
															#line 3126 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 15050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 3115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15061 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3117 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 15065 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15069 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 3115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15083 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3117 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 15087 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15091 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply const& _rep,int loopDepth) 
	{
															#line 3123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 15103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply && _rep,int loopDepth) 
	{
															#line 3123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 15112 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 4, Void >::remove();
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult>::Fragment* results;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3016 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 3019 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 3023 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>> tssDuplicateStream;
															#line 3024 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamRequest req;
															#line 3050 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamReply rep;
															#line 3058 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 3099 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<GetKeyValuesStreamReply> replyStream;
															#line 3109 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool breakAgain;
															#line 15381 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeStreamFragment()
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActor final : public Actor<Void>, public ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetRangeStreamFragmentActor, 1, Void >, public ActorCallback< GetRangeStreamFragmentActor, 2, Void >, public ActorCallback< GetRangeStreamFragmentActor, 3, Void >, public ActorCallback< GetRangeStreamFragmentActor, 4, Void >, public ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >, public ActorCallback< GetRangeStreamFragmentActor, 6, Void >, public FastAllocated<GetRangeStreamFragmentActor>, public GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor> {
															#line 15386 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeStreamFragmentActor>::operator new;
	using FastAllocated<GetRangeStreamFragmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10715729539891876096UL, 9279515194274731008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 1, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 2, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 4, Void >;
friend struct ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 6, Void >;
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActor(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 15409 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor>(trState, results, keys, limits, snapshot, reverse, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5899419315066500352UL, 5523941769855860224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStreamFragment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStreamFragment( Reference<TransactionState> const& trState, ParallelStream<RangeResult>::Fragment* const& results, KeyRange const& keys, GetRangeLimits const& limits, Snapshot const& snapshot, Reverse const& reverse, SpanContext const& spanContext ) {
															#line 3008 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamFragmentActor(trState, results, keys, limits, snapshot, reverse, spanContext));
															#line 15447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 3279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 15452 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
[[nodiscard]] Future<Standalone<VectorRef<KeyRef>>> getRangeSplitPoints( Reference<TransactionState> const& trState, KeyRange const& keys, int64_t const& chunkSize );

#line 3283 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static KeyRange intersect(KeyRangeRef lhs, KeyRangeRef rhs) {
	return KeyRange(KeyRangeRef(std::max(lhs.begin, rhs.begin), std::min(lhs.end, rhs.end)));
}

// Divides the requested key range into 1MB fragments, create range streams for each fragment, and merges the results so
// the client get them in order
															#line 15463 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getRangeStream()
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamActor>
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActorState {
															#line 15470 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActorState(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   _results(_results),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(_results, CLIENT_KNOBS->RANGESTREAM_BUFFERED_FRAGMENTS_LIMIT)
															#line 15493 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamActorState() 
	{
		fdb_probe_actor_destroy("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3301 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(!limits.hasRowLimit());
															#line 3302 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span = Span("NAPI:getRangeStream"_loc, trState->spanContext);
															#line 3304 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3304 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15514 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 1;
															#line 3304 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 0, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15519 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3306 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3308 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin);
															#line 3309 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end);
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15550 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3306 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3308 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin);
															#line 3309 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end);
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15572 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15577 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_2 = fe;
															#line 3312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 3;
															#line 3312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 2, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15668 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __b,int loopDepth) 
	{
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 15677 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3314 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!snapshot)
															#line 15756 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3316 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(std::min(b, Key(begin.getKey(), begin.arena())), std::max(e, Key(end.getKey(), end.arena()))));
															#line 15760 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3320 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 15764 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3321 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = results.finish();
															#line 3321 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15770 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 4;
															#line 3321 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 3, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15775 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Key const& __e,int loopDepth) 
	{
															#line 3312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 15789 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3329 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests = std::vector<Future<Void>>();
															#line 3330 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15870 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 3322 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 15879 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 3322 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 15891 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 3366 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(outstandingRequests) && results.finish();
															#line 3366 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15980 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 8;
															#line 3366 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 7, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 15985 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 3330 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(b < e))
															#line 16001 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3331 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_4 = getKeyLocation(trState, reverse ? e : b, &StorageServerInterface::getKeyValuesStream, reverse);
															#line 3331 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16009 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 5;
															#line 3331 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16014 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 3333 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shardIntersection = intersect(locationInfo.range, KeyRangeRef(b, e));
															#line 3334 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_5 = getRangeSplitPoints(trState, shardIntersection, CLIENT_KNOBS->RANGESTREAM_FRAGMENT_SIZE);
															#line 3334 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16040 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 6;
															#line 3334 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16045 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 3331 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 16054 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4loopBody1cont3(int loopDepth) 
	{
															#line 3336 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		toSend = std::vector<KeyRange>();
															#line 3339 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!splitPoints.empty())
															#line 16135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3340 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, splitPoints.front()), splitPoints.arena()));
															#line 3341 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int i = 0;i < splitPoints.size() - 1;++i) {
															#line 3342 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				toSend.push_back(KeyRange(KeyRangeRef(splitPoints[i], splitPoints[i + 1]), splitPoints.arena()));
															#line 16143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			}
															#line 3344 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(splitPoints.back(), shardIntersection.end), splitPoints.arena()));
															#line 16147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3346 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, shardIntersection.end)));
															#line 16153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3349 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		idx = 0;
															#line 3350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = 0;
															#line 3351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 16161 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> const& __splitPoints,int loopDepth) 
	{
															#line 3334 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		splitPoints = __splitPoints;
															#line 16170 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> && __splitPoints,int loopDepth) 
	{
		splitPoints = std::move(__splitPoints);
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4loopBody1cont4(int loopDepth) 
	{
															#line 3360 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 16249 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3361 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			e = shardIntersection.begin;
															#line 16253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3363 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			b = shardIntersection.end;
															#line 16259 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 3351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(idx < toSend.size()))
															#line 16276 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1cont4loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3352 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = reverse ? toSend.size() - idx - 1 : idx;
															#line 3353 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (toSend[useIdx].empty())
															#line 16284 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
			return a_body1cont4loopBody1cont3continue1(loopDepth); // continue
		}
															#line 3356 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<ParallelStream<RangeResult>::Fragment*> __when_expr_6 = results.createFragment();
															#line 3356 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16292 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 7;
															#line 3356 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 16297 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3continue1(int loopDepth) 
	{
															#line 3351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 16319 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
															#line 3357 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 16330 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
															#line 3357 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 16341 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(fragment, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(std::move(fragment), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 3367 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 16425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 3367 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 16437 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	PromiseStream<RangeResult> _results;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult> results;
															#line 3302 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3309 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 3311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 3312 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 3329 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Void>> outstandingRequests;
															#line 3331 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 3333 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shardIntersection;
															#line 3334 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Standalone<VectorRef<KeyRef>> splitPoints;
															#line 3336 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRange> toSend;
															#line 3349 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int idx;
															#line 3350 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 16560 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeStream()
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActor final : public Actor<Void>, public ActorCallback< GetRangeStreamActor, 0, Void >, public ActorCallback< GetRangeStreamActor, 1, Key >, public ActorCallback< GetRangeStreamActor, 2, Key >, public ActorCallback< GetRangeStreamActor, 3, Void >, public ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >, public ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >, public ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >, public ActorCallback< GetRangeStreamActor, 7, Void >, public FastAllocated<GetRangeStreamActor>, public GetRangeStreamActorState<GetRangeStreamActor> {
															#line 16565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeStreamActor>::operator new;
	using FastAllocated<GetRangeStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4547566035109526784UL, 15486824451324915968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamActor, 0, Void >;
friend struct ActorCallback< GetRangeStreamActor, 1, Key >;
friend struct ActorCallback< GetRangeStreamActor, 2, Key >;
friend struct ActorCallback< GetRangeStreamActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >;
friend struct ActorCallback< GetRangeStreamActor, 7, Void >;
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActor(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 16589 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetRangeStreamActorState<GetRangeStreamActor>(trState, _results, begin, end, limits, conflictRange, snapshot, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10544369634926336512UL, 15814804397175604224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetRangeStreamActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStream( Reference<TransactionState> const& trState, PromiseStream<RangeResult> const& _results, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse ) {
															#line 3290 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamActor(trState, _results, begin, end, limits, conflictRange, snapshot, reverse));
															#line 16629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 3369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse) {
	return getRange<GetKeyValuesRequest, GetKeyValuesReply, RangeResult>(
	    trState, begin, end, ""_sr, limits, Promise<std::pair<Key, Key>>(), Snapshot::True, reverse);
}

bool DatabaseContext::debugUseTags = false;
const std::vector<std::string> DatabaseContext::debugTransactionTagChoices = { "a", "b", "c", "d", "e", "f", "g",
	                                                                           "h", "i", "j", "k", "l", "m", "n",
	                                                                           "o", "p", "q", "r", "s", "t" };

void debugAddTags(Reference<TransactionState> trState) {
	int numTags = deterministicRandom()->randomInt(0, CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION + 1);
	for (int i = 0; i < numTags; ++i) {
		TransactionTag tag;
		if (deterministicRandom()->random01() < 0.7) {
			tag = TransactionTagRef(deterministicRandom()->randomChoice(DatabaseContext::debugTransactionTagChoices));
		} else {
			int length = deterministicRandom()->randomInt(1, CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH + 1);
			uint8_t* s = new (tag.arena()) uint8_t[length];
			for (int j = 0; j < length; ++j) {
				s[j] = (uint8_t)deterministicRandom()->randomInt(0, 256);
			}

			tag.contents() = TransactionTagRef(s, length);
		}

		if (deterministicRandom()->coinflip()) {
			trState->options.readTags.addTag(tag);
		}
		trState->options.tags.addTag(tag);
	}
}

Transaction::Transaction()
  : trState(makeReference<TransactionState>(TaskPriority::DefaultEndpoint, generateSpanID(false))) {}

Transaction::Transaction(Database const& cx)
  : trState(makeReference<TransactionState>(cx,
                                            cx->taskID,
                                            generateSpanID(cx->transactionTracingSample),
                                            createTrLogInfoProbabilistically(cx))),
    span(trState->spanContext, "Transaction"_loc), backoff(CLIENT_KNOBS->DEFAULT_BACKOFF), tr(trState->spanContext) {
	if (DatabaseContext::debugUseTags) {
		debugAddTags(trState);
	}
}

Transaction::~Transaction() {
	flushTrLogsIfEnabled();
	cancelWatches();
}

void Transaction::operator=(Transaction&& r) noexcept {
	flushTrLogsIfEnabled();
	tr = std::move(r.tr);
	trState = std::move(r.trState);
	extraConflictRanges = std::move(r.extraConflictRanges);
	commitResult = std::move(r.commitResult);
	committing = std::move(r.committing);
	backoff = r.backoff;
	watches = r.watches;
}

void Transaction::flushTrLogsIfEnabled() {
	if (trState && trState->trLogInfo && trState->trLogInfo->logsAdded && trState->trLogInfo->trLogWriter.getData()) {
		ASSERT(trState->trLogInfo->flushed == false);
		trState->cx->clientStatusUpdater.inStatusQ.push_back(
		    { trState->trLogInfo->identifier, std::move(trState->trLogInfo->trLogWriter) });
		trState->trLogInfo->flushed = true;
	}
}

VersionVector Transaction::getVersionVector() const {
	return trState->cx->ssVersionVectorCache;
}

void Transaction::setVersion(Version v) {
	trState->startTime = now();
	if (trState->readVersionFuture.isValid())
		throw read_version_already_set();
	if (v <= 0)
		throw version_invalid();

	trState->readVersionFuture = v;
	trState->readVersionObtainedFromGrvProxy = false;
}

Future<Optional<Value>> Transaction::get(const Key& key, Snapshot snapshot) {
	++trState->cx->transactionLogicalReads;
	++trState->cx->transactionGetValueRequests;
	// ASSERT (key < allKeys.end);

	// There are no keys in the database with size greater than the max key size
	if (key.size() > getMaxReadKeySize(key)) {
		return Optional<Value>();
	}

	auto ver = getReadVersion();

	/*	if (!systemKeys.contains(key))
	        return Optional<Value>(Value()); */

	if (!snapshot)
		tr.transaction.read_conflict_ranges.push_back(tr.arena, singleKeyRange(key, tr.arena));

	if (key == metadataVersionKey) {
		++trState->cx->transactionMetadataVersionReads;
		if (!ver.isReady() || trState->metadataVersion.isSet()) {
			return trState->metadataVersion.getFuture();
		} else {
			if (ver.isError()) {
				return ver.getError();
			}
			if (ver.get() == trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].first) {
				return trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].second;
			}

			Version v = ver.get();
			int hi = trState->cx->mvCacheInsertLocation;
			int lo = (trState->cx->mvCacheInsertLocation + 1) % trState->cx->metadataVersionCache.size();

			while (hi != lo) {
				int cu = hi > lo ? (hi + lo) / 2
				                 : ((hi + trState->cx->metadataVersionCache.size() + lo) / 2) %
				                       trState->cx->metadataVersionCache.size();
				if (v == trState->cx->metadataVersionCache[cu].first) {
					return trState->cx->metadataVersionCache[cu].second;
				}
				if (cu == lo) {
					break;
				}
				if (v < trState->cx->metadataVersionCache[cu].first) {
					hi = cu;
				} else {
					lo = (cu + 1) % trState->cx->metadataVersionCache.size();
				}
			}
		}
	}

	return getValue(trState, key);
}

void Watch::setWatch(Future<Void> watchFuture) {
	this->watchFuture = watchFuture;

	// Cause the watch loop to go around and start waiting on watchFuture
	onSetWatchTrigger.send(Void());
}

// Restarts a watch after a database switch
															#line 16789 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via restartWatch()
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class RestartWatchActor>
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RestartWatchActorState {
															#line 16796 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RestartWatchActorState(Database const& cx,Key const& key,Optional<Value> const& value,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   value(value),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 16817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("restartWatch", reinterpret_cast<unsigned long>(this));

	}
	~RestartWatchActorState() 
	{
		fdb_probe_actor_destroy("restartWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3534 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(key, true);
															#line 3536 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = watchValueMap( cx->minAcceptableReadVersion, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies);
															#line 3536 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<RestartWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16836 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestartWatchActor*>(this)->actor_wait_state = 1;
															#line 3536 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestartWatchActor, 0, Void >*>(static_cast<RestartWatchActor*>(this)));
															#line 16841 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RestartWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestartWatchActorState(); static_cast<RestartWatchActor*>(this)->destroy(); return 0; }
															#line 16864 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<RestartWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3539 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RestartWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestartWatchActorState(); static_cast<RestartWatchActor*>(this)->destroy(); return 0; }
															#line 16876 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<RestartWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestartWatchActorState();
		static_cast<RestartWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestartWatchActor*>(this)->actor_wait_state > 0) static_cast<RestartWatchActor*>(this)->actor_wait_state = 0;
		static_cast<RestartWatchActor*>(this)->ActorCallback< RestartWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestartWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestartWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestartWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> value;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 16975 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via restartWatch()
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RestartWatchActor final : public Actor<Void>, public ActorCallback< RestartWatchActor, 0, Void >, public FastAllocated<RestartWatchActor>, public RestartWatchActorState<RestartWatchActor> {
															#line 16980 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestartWatchActor>::operator new;
	using FastAllocated<RestartWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5527721022847578880UL, 10896128677351557888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestartWatchActor, 0, Void >;
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RestartWatchActor(Database const& cx,Key const& key,Optional<Value> const& value,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 16997 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RestartWatchActorState<RestartWatchActor>(cx, key, value, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restartWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(415901849338767872UL, 13846331734017316352UL);
		ActorExecutionContextHelper __helper(static_cast<RestartWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restartWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restartWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestartWatchActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> restartWatch( Database const& cx, Key const& key, Optional<Value> const& value, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 3525 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new RestartWatchActor(cx, key, value, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 17030 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 3541 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// FIXME: This seems pretty horrible. Now a Database can't die until all of its watches do...
															#line 17036 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via watch()
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchActor>
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchActorState {
															#line 17043 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchActorState(Reference<Watch> const& watch,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : watch(watch),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 17062 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watch", reinterpret_cast<unsigned long>(this));

	}
	~WatchActorState() 
	{
		fdb_probe_actor_destroy("watch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_0 = watch->onChangeTrigger.getFuture();
															#line 3551 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = watch->onSetWatchTrigger.getFuture();
															#line 17084 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WatchActor*>(this)->actor_wait_state = 1;
															#line 3554 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 0, Void >*>(static_cast<WatchActor*>(this)));
															#line 3557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 1, Void >*>(static_cast<WatchActor*>(this)));
															#line 17091 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchActorState();
		static_cast<WatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3586 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->decreaseWatchCounter();
															#line 3587 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchActorState(); static_cast<WatchActor*>(this)->destroy(); return 0; }
															#line 17122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<WatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchActorState();
		static_cast<WatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3582 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->decreaseWatchCounter();
															#line 3583 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 17137 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 3559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 17169 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1when2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 3559 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 17178 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1when2loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchActor*>(this)->actor_wait_state > 0) static_cast<WatchActor*>(this)->actor_wait_state = 0;
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 0, Void >::remove();
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1when2loopBody1(int loopDepth) 
	{
															#line 3562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch->watchFuture;
															#line 3560 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17266 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 3566 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->connectionFileChanged();
															#line 17270 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1when2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<WatchActor*>(this)->actor_wait_state = 2;
															#line 3562 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 2, Void >*>(static_cast<WatchActor*>(this)));
															#line 3566 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchActor, 3, Void >*>(static_cast<WatchActor*>(this)));
															#line 17277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2break1(int loopDepth) 
	{
		try {
			return a_body1when2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1when2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1when2loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1when2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1when2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 3567 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Recreated a watch after switch");
															#line 3568 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		watch->watchFuture = restartWatch(cx, watch->key, watch->value, tags, spanContext, taskID, debugID, useProvisionalProxies);
															#line 17319 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 3567 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Recreated a watch after switch");
															#line 3568 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		watch->watchFuture = restartWatch(cx, watch->key, watch->value, tags, spanContext, taskID, debugID, useProvisionalProxies);
															#line 17330 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchActor*>(this)->actor_wait_state > 0) static_cast<WatchActor*>(this)->actor_wait_state = 0;
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 2, Void >::remove();
		static_cast<WatchActor*>(this)->ActorCallback< WatchActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<Watch> watch;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 17540 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watch()
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchActor final : public Actor<Void>, public ActorCallback< WatchActor, 0, Void >, public ActorCallback< WatchActor, 1, Void >, public ActorCallback< WatchActor, 2, Void >, public ActorCallback< WatchActor, 3, Void >, public FastAllocated<WatchActor>, public WatchActorState<WatchActor> {
															#line 17545 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchActor>::operator new;
	using FastAllocated<WatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6339882460394541824UL, 16611125132126251008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchActor, 0, Void >;
friend struct ActorCallback< WatchActor, 1, Void >;
friend struct ActorCallback< WatchActor, 2, Void >;
friend struct ActorCallback< WatchActor, 3, Void >;
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchActor(Reference<Watch> const& watch,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 17565 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WatchActorState<WatchActor>(watch, cx, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16365673208262377216UL, 4470840757189902080UL);
		ActorExecutionContextHelper __helper(static_cast<WatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watch( Reference<Watch> const& watch, Database const& cx, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 3543 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchActor(watch, cx, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 17599 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 3589 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Version> Transaction::getRawReadVersion() {
	return ::getRawVersion(trState);
}

Future<Void> Transaction::watch(Reference<Watch> watch) {
	++trState->cx->transactionWatchRequests;

	trState->cx->increaseWatchCounter();
	watch->readOptions = trState->readOptions;
	watches.push_back(watch);
	return ::watch(watch,
	               trState->cx,
	               trState->options.readTags,
	               trState->spanContext,
	               trState->taskID,
	               trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	               trState->useProvisionalProxies);
}

															#line 17623 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAddressesForKeyActor()
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetAddressesForKeyActorActor>
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetAddressesForKeyActorActorState {
															#line 17630 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetAddressesForKeyActorActorState(Reference<TransactionState> const& trState,Key const& key) 
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 3610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssi()
															#line 17641 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this));

	}
	~GetAddressesForKeyActorActorState() 
	{
		fdb_probe_actor_destroy("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17658 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 1;
															#line 3612 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 0, Void >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAddressesForKeyActorActorState();
		static_cast<GetAddressesForKeyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resolvedKey = key;
															#line 3618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ksKey = keyServersKey(resolvedKey);
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = getRange(trState, lastLessOrEqual(serverTagKeys.begin), firstGreaterThan(serverTagKeys.end), GetRangeLimits(CLIENT_KNOBS->TOO_MANY), Reverse::False);
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17692 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 2;
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17697 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resolvedKey = key;
															#line 3618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ksKey = keyServersKey(resolvedKey);
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = getRange(trState, lastLessOrEqual(serverTagKeys.begin), firstGreaterThan(serverTagKeys.end), GetRangeLimits(CLIENT_KNOBS->TOO_MANY), Reverse::False);
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17712 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 2;
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17717 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAddressesForKeyActorActor*>(this)->ActorCallback< GetAddressesForKeyActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAddressesForKeyActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3624 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!serverTagResult.more && serverTagResult.size() < CLIENT_KNOBS->TOO_MANY);
															#line 3625 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<RangeResult> futureServerUids = getRange(trState, lastLessOrEqual(ksKey), firstGreaterThan(ksKey), GetRangeLimits(1), Reverse::False);
															#line 3627 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = futureServerUids;
															#line 3627 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17807 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 3;
															#line 3627 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17812 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& __serverTagResult,int loopDepth) 
	{
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		serverTagResult = __serverTagResult;
															#line 17821 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && __serverTagResult,int loopDepth) 
	{
		serverTagResult = std::move(__serverTagResult);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAddressesForKeyActorActor*>(this)->ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(RangeResult const& serverUids,int loopDepth) 
	{
															#line 3629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(serverUids.size());
															#line 3631 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<UID> src;
															#line 3632 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<UID> ignore;
															#line 3635 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		decodeKeyServersValue(serverTagResult, serverUids[0].value, src, ignore);
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Optional<std::vector<StorageServerInterface>>> __when_expr_3 = transactionalGetServerInterfaces(trState, src);
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17910 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 4;
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17915 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(RangeResult && serverUids,int loopDepth) 
	{
															#line 3629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(serverUids.size());
															#line 3631 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<UID> src;
															#line 3632 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<UID> ignore;
															#line 3635 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		decodeKeyServersValue(serverTagResult, serverUids[0].value, src, ignore);
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Optional<std::vector<StorageServerInterface>>> __when_expr_3 = transactionalGetServerInterfaces(trState, src);
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17934 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 4;
															#line 3636 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*>(static_cast<GetAddressesForKeyActorActor*>(this)));
															#line 17939 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult const& serverUids,int loopDepth) 
	{
		loopDepth = a_body1cont3(serverUids, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult && serverUids,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(serverUids), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAddressesForKeyActorActor*>(this)->ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Optional<std::vector<StorageServerInterface>> const& serverInterfaces,int loopDepth) 
	{
															#line 3639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(serverInterfaces.present());
															#line 3641 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssi = serverInterfaces.get();
															#line 3643 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Standalone<VectorRef<const char*>> addresses;
															#line 3644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( auto i : ssi ) {
															#line 3645 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			std::string ipString = trState->options.includePort ? i.address().toString() : i.address().ip.toString();
															#line 3646 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			char* c_string = new (addresses.arena()) char[ipString.length() + 1];
															#line 3647 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			strcpy(c_string, ipString.c_str());
															#line 3648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			addresses.push_back(addresses.arena(), c_string);
															#line 18037 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3650 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetAddressesForKeyActorActor*>(this)->SAV<Standalone<VectorRef<const char*>>>::futures) { (void)(addresses); this->~GetAddressesForKeyActorActorState(); static_cast<GetAddressesForKeyActorActor*>(this)->destroy(); return 0; }
															#line 18041 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetAddressesForKeyActorActor*>(this)->SAV< Standalone<VectorRef<const char*>> >::value()) Standalone<VectorRef<const char*>>(addresses);
		this->~GetAddressesForKeyActorActorState();
		static_cast<GetAddressesForKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<std::vector<StorageServerInterface>> && serverInterfaces,int loopDepth) 
	{
															#line 3639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(serverInterfaces.present());
															#line 3641 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssi = serverInterfaces.get();
															#line 3643 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Standalone<VectorRef<const char*>> addresses;
															#line 3644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( auto i : ssi ) {
															#line 3645 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			std::string ipString = trState->options.includePort ? i.address().toString() : i.address().ip.toString();
															#line 3646 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			char* c_string = new (addresses.arena()) char[ipString.length() + 1];
															#line 3647 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			strcpy(c_string, ipString.c_str());
															#line 3648 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			addresses.push_back(addresses.arena(), c_string);
															#line 18067 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3650 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetAddressesForKeyActorActor*>(this)->SAV<Standalone<VectorRef<const char*>>>::futures) { (void)(addresses); this->~GetAddressesForKeyActorActorState(); static_cast<GetAddressesForKeyActorActor*>(this)->destroy(); return 0; }
															#line 18071 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetAddressesForKeyActorActor*>(this)->SAV< Standalone<VectorRef<const char*>> >::value()) Standalone<VectorRef<const char*>>(addresses);
		this->~GetAddressesForKeyActorActorState();
		static_cast<GetAddressesForKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<std::vector<StorageServerInterface>> const& serverInterfaces,int loopDepth) 
	{
		loopDepth = a_body1cont4(serverInterfaces, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<std::vector<StorageServerInterface>> && serverInterfaces,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(serverInterfaces), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetAddressesForKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAddressesForKeyActorActor*>(this)->ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*,Optional<std::vector<StorageServerInterface>> const& value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*,Optional<std::vector<StorageServerInterface>> && value) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 3610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<StorageServerInterface> ssi;
															#line 3614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key resolvedKey;
															#line 3618 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key ksKey;
															#line 3619 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResult serverTagResult;
															#line 18166 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAddressesForKeyActor()
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetAddressesForKeyActorActor final : public Actor<Standalone<VectorRef<const char*>>>, public ActorCallback< GetAddressesForKeyActorActor, 0, Void >, public ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >, public ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >, public ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >, public FastAllocated<GetAddressesForKeyActorActor>, public GetAddressesForKeyActorActorState<GetAddressesForKeyActorActor> {
															#line 18171 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAddressesForKeyActorActor>::operator new;
	using FastAllocated<GetAddressesForKeyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17577030903455149312UL, 10914165073667475968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<const char*>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAddressesForKeyActorActor, 0, Void >;
friend struct ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >;
friend struct ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >;
friend struct ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >;
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetAddressesForKeyActorActor(Reference<TransactionState> const& trState,Key const& key) 
															#line 18191 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<const char*>>>(),
		   GetAddressesForKeyActorActorState<GetAddressesForKeyActorActor>(trState, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11226909598906315008UL, 6503601696181471744UL);
		ActorExecutionContextHelper __helper(static_cast<GetAddressesForKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAddressesForKeyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAddressesForKeyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAddressesForKeyActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAddressesForKeyActorActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAddressesForKeyActorActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetAddressesForKeyActorActor, 3, Optional<std::vector<StorageServerInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<const char*>>> getAddressesForKeyActor( Reference<TransactionState> const& trState, Key const& key ) {
															#line 3609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Standalone<VectorRef<const char*>>>(new GetAddressesForKeyActorActor(trState, key));
															#line 18227 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
}

#line 3652 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Standalone<VectorRef<const char*>>> Transaction::getAddressesForKey(const Key& key) {
	++trState->cx->transactionLogicalReads;
	++trState->cx->transactionGetAddressesForKeyRequests;
	return getAddressesForKeyActor(trState, key);
}

															#line 18238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getKeyAndConflictRange()
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyAndConflictRangeActor>
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyAndConflictRangeActorState {
															#line 18245 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyAndConflictRangeActorState(Reference<TransactionState> const& trState,KeySelector const& k,Promise<std::pair<Key, Key>> const& conflictRange) 
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   k(k),
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange)
															#line 18256 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyAndConflictRangeActorState() 
	{
		fdb_probe_actor_destroy("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Key> __when_expr_0 = getKey(trState, k);
															#line 3663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyAndConflictRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18274 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetKeyAndConflictRangeActor*>(this)->actor_wait_state = 1;
															#line 3663 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyAndConflictRangeActor, 0, Key >*>(static_cast<GetKeyAndConflictRangeActor*>(this)));
															#line 18279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyAndConflictRangeActorState();
		static_cast<GetKeyAndConflictRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3671 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(Key(), Key()));
															#line 3672 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18311 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Key const& rep,int loopDepth) 
	{
															#line 3664 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (k.offset <= 0)
															#line 18325 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3665 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(rep, k.orEqual ? keyAfter(k.getKey()) : Key(k.getKey(), k.arena())));
															#line 18329 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3667 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send( std::make_pair(k.orEqual ? keyAfter(k.getKey()) : Key(k.getKey(), k.arena()), keyAfter(rep)));
															#line 18335 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3669 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyAndConflictRangeActor*>(this)->SAV<Key>::futures) { (void)(rep); this->~GetKeyAndConflictRangeActorState(); static_cast<GetKeyAndConflictRangeActor*>(this)->destroy(); return 0; }
															#line 18339 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyAndConflictRangeActor*>(this)->SAV< Key >::value()) Key(rep);
		this->~GetKeyAndConflictRangeActorState();
		static_cast<GetKeyAndConflictRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Key && rep,int loopDepth) 
	{
															#line 3664 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (k.offset <= 0)
															#line 18351 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		{
															#line 3665 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(rep, k.orEqual ? keyAfter(k.getKey()) : Key(k.getKey(), k.arena())));
															#line 18355 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3667 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send( std::make_pair(k.orEqual ? keyAfter(k.getKey()) : Key(k.getKey(), k.arena()), keyAfter(rep)));
															#line 18361 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		}
															#line 3669 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyAndConflictRangeActor*>(this)->SAV<Key>::futures) { (void)(rep); this->~GetKeyAndConflictRangeActorState(); static_cast<GetKeyAndConflictRangeActor*>(this)->destroy(); return 0; }
															#line 18365 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyAndConflictRangeActor*>(this)->SAV< Key >::value()) Key(rep);
		this->~GetKeyAndConflictRangeActorState();
		static_cast<GetKeyAndConflictRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && rep,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyAndConflictRangeActor*>(this)->actor_wait_state > 0) static_cast<GetKeyAndConflictRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyAndConflictRangeActor*>(this)->ActorCallback< GetKeyAndConflictRangeActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyAndConflictRangeActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndConflictRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyAndConflictRangeActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndConflictRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyAndConflictRangeActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndConflictRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector k;
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 18454 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyAndConflictRange()
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyAndConflictRangeActor final : public Actor<Key>, public ActorCallback< GetKeyAndConflictRangeActor, 0, Key >, public FastAllocated<GetKeyAndConflictRangeActor>, public GetKeyAndConflictRangeActorState<GetKeyAndConflictRangeActor> {
															#line 18459 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyAndConflictRangeActor>::operator new;
	using FastAllocated<GetKeyAndConflictRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12110393912379753728UL, 13115166776786108160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyAndConflictRangeActor, 0, Key >;
															#line 3659 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyAndConflictRangeActor(Reference<TransactionState> const& trState,KeySelector const& k,Promise<std::pair<Key, Key>> const& conflictRange) 
															#line 18476 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   GetKeyAndConflictRangeActorState<GetKeyAndConflictRangeActor>(trState, k, conflictRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8434504866380745984UL, 7085230067086901504UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndConflictRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyAndConflictRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyAndConflictRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback