#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
/*
 * TssqCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/SystemData.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 37 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via tssQuarantineList()
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
template <class TssQuarantineListActor>
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssQuarantineListActorState {
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssQuarantineListActorState(Reference<IDatabase> const& db) 
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		 : db(db),
															#line 36 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 52 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tssQuarantineList", reinterpret_cast<unsigned long>(this));

	}
	~TssQuarantineListActorState() 
	{
		fdb_probe_actor_destroy("tssQuarantineList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			;
															#line 67 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssQuarantineListActorState();
		static_cast<TssQuarantineListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 39 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 40 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 42 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			resultFuture = tr->getRange(tssQuarantineKeys, CLIENT_KNOBS->TOO_MANY);
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (static_cast<TssQuarantineListActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 106 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TssQuarantineListActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineListActor, 0, RangeResult >*>(static_cast<TssQuarantineListActor*>(this)));
															#line 111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 52 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (static_cast<TssQuarantineListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TssQuarantineListActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineListActor, 1, Void >*>(static_cast<TssQuarantineListActor*>(this)));
															#line 140 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		ASSERT(!result.more);
															#line 46 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		printf("Found %d quarantined TSS processes%s\n", result.size(), result.size() == 0 ? "." : ":");
															#line 47 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		for( auto& it : result ) {
															#line 48 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("  %s\n", decodeTssQuarantineKey(it.key).toString().c_str());
															#line 161 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
															#line 50 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssQuarantineListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssQuarantineListActorState(); static_cast<TssQuarantineListActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssQuarantineListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TssQuarantineListActorState();
		static_cast<TssQuarantineListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 45 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		ASSERT(!result.more);
															#line 46 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		printf("Found %d quarantined TSS processes%s\n", result.size(), result.size() == 0 ? "." : ":");
															#line 47 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		for( auto& it : result ) {
															#line 48 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("  %s\n", decodeTssQuarantineKey(it.key).toString().c_str());
															#line 183 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
															#line 50 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssQuarantineListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssQuarantineListActorState(); static_cast<TssQuarantineListActor*>(this)->destroy(); return 0; }
															#line 187 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssQuarantineListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TssQuarantineListActorState();
		static_cast<TssQuarantineListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssQuarantineListActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineListActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineListActor*>(this)->ActorCallback< TssQuarantineListActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineListActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssQuarantineListActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TssQuarantineListActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssQuarantineListActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineListActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineListActor*>(this)->ActorCallback< TssQuarantineListActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineListActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssQuarantineListActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TssQuarantineListActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 36 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 42 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 363 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tssQuarantineList()
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssQuarantineListActor final : public Actor<Void>, public ActorCallback< TssQuarantineListActor, 0, RangeResult >, public ActorCallback< TssQuarantineListActor, 1, Void >, public FastAllocated<TssQuarantineListActor>, public TssQuarantineListActorState<TssQuarantineListActor> {
															#line 368 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<TssQuarantineListActor>::operator new;
	using FastAllocated<TssQuarantineListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17469409743947538176UL, 2996282447385101312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TssQuarantineListActor, 0, RangeResult >;
friend struct ActorCallback< TssQuarantineListActor, 1, Void >;
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssQuarantineListActor(Reference<IDatabase> const& db) 
															#line 386 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TssQuarantineListActorState<TssQuarantineListActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssQuarantineList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2189547972046962176UL, 9579544315150671616UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssQuarantineList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssQuarantineList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TssQuarantineListActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TssQuarantineListActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
[[nodiscard]] Future<Void> tssQuarantineList( Reference<IDatabase> const& db ) {
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	return Future<Void>(new TssQuarantineListActor(db));
															#line 419 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
}

#line 56 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"

															#line 424 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via tssQuarantine()
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
template <class TssQuarantineActor>
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssQuarantineActorState {
															#line 430 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssQuarantineActorState(Reference<IDatabase> const& db,bool const& enable,UID const& tssId) 
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		 : db(db),
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   enable(enable),
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   tssId(tssId),
															#line 58 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   tr(db->createTransaction()),
															#line 59 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   tssMapDB(KeyBackedMap<UID, UID>(tssMappingKeys.begin))
															#line 445 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tssQuarantine", reinterpret_cast<unsigned long>(this));

	}
	~TssQuarantineActorState() 
	{
		fdb_probe_actor_destroy("tssQuarantine", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			;
															#line 460 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssQuarantineActorState();
		static_cast<TssQuarantineActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 105 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		printf("Successfully %s TSS %s\n", enable ? "quarantined" : "removed", tssId.toString().c_str());
															#line 106 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 485 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TssQuarantineActorState();
		static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 63 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 68 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			serverListValueF = tr->get(serverListKeyFor(tssId));
															#line 69 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(serverListValueF);
															#line 69 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 513 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TssQuarantineActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 0, Optional<Value> >*>(static_cast<TssQuarantineActor*>(this)));
															#line 518 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 555 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TssQuarantineActor*>(this)->actor_wait_state = 4;
															#line 102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 3, Void >*>(static_cast<TssQuarantineActor*>(this)));
															#line 560 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& serverListValue,int loopDepth) 
	{
															#line 70 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!serverListValue.present())
															#line 575 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 71 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("No TSS %s found in cluster!\n", tssId.toString().c_str());
															#line 72 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 581 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 74 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		ssi = decodeServerListValue(serverListValue.get());
															#line 75 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!ssi.isTss())
															#line 591 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("Cannot quarantine Non-TSS storage ID %s!\n", tssId.toString().c_str());
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 597 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		currentQuarantineValueF = tr->get(tssQuarantineKeyFor(tssId));
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(currentQuarantineValueF);
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 609 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TssQuarantineActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 1, Optional<Value> >*>(static_cast<TssQuarantineActor*>(this)));
															#line 614 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && serverListValue,int loopDepth) 
	{
															#line 70 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!serverListValue.present())
															#line 623 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 71 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("No TSS %s found in cluster!\n", tssId.toString().c_str());
															#line 72 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 629 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 74 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		ssi = decodeServerListValue(serverListValue.get());
															#line 75 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!ssi.isTss())
															#line 639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("Cannot quarantine Non-TSS storage ID %s!\n", tssId.toString().c_str());
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 645 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		currentQuarantineValueF = tr->get(tssQuarantineKeyFor(tssId));
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(currentQuarantineValueF);
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 657 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TssQuarantineActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 1, Optional<Value> >*>(static_cast<TssQuarantineActor*>(this)));
															#line 662 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverListValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverListValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineActor*>(this)->ActorCallback< TssQuarantineActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TssQuarantineActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& currentQuarantineValue,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (enable && currentQuarantineValue.present())
															#line 746 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 84 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("TSS %s already in quarantine, doing nothing.\n", tssId.toString().c_str());
															#line 85 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 752 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 86 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!enable && !currentQuarantineValue.present())
															#line 762 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			{
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				printf("TSS %s is not in quarantine, cannot remove from quarantine!.\n", tssId.toString().c_str());
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 768 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
				new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TssQuarantineActorState();
				static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (enable)
															#line 777 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 92 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->set(tssQuarantineKeyFor(tssId), ""_sr);
															#line 94 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tssMapDB.erase(tr, ssi.tssPairID.get());
															#line 783 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->clear(tssQuarantineKeyFor(tssId));
															#line 789 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 795 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TssQuarantineActor*>(this)->actor_wait_state = 3;
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 2, Void >*>(static_cast<TssQuarantineActor*>(this)));
															#line 800 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && currentQuarantineValue,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (enable && currentQuarantineValue.present())
															#line 809 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 84 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			printf("TSS %s already in quarantine, doing nothing.\n", tssId.toString().c_str());
															#line 85 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 815 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TssQuarantineActorState();
			static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 86 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (!enable && !currentQuarantineValue.present())
															#line 825 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			{
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				printf("TSS %s is not in quarantine, cannot remove from quarantine!.\n", tssId.toString().c_str());
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				if (!static_cast<TssQuarantineActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssQuarantineActorState(); static_cast<TssQuarantineActor*>(this)->destroy(); return 0; }
															#line 831 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
				new (&static_cast<TssQuarantineActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TssQuarantineActorState();
				static_cast<TssQuarantineActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (enable)
															#line 840 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		{
															#line 92 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->set(tssQuarantineKeyFor(tssId), ""_sr);
															#line 94 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tssMapDB.erase(tr, ssi.tssPairID.get());
															#line 846 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			tr->clear(tssQuarantineKeyFor(tssId));
															#line 852 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		}
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 858 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TssQuarantineActor*>(this)->actor_wait_state = 3;
															#line 99 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssQuarantineActor, 2, Void >*>(static_cast<TssQuarantineActor*>(this)));
															#line 863 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& currentQuarantineValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(currentQuarantineValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && currentQuarantineValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(currentQuarantineValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineActor*>(this)->ActorCallback< TssQuarantineActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TssQuarantineActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineActor*>(this)->ActorCallback< TssQuarantineActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssQuarantineActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TssQuarantineActor*>(this)->actor_wait_state > 0) static_cast<TssQuarantineActor*>(this)->actor_wait_state = 0;
		static_cast<TssQuarantineActor*>(this)->ActorCallback< TssQuarantineActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TssQuarantineActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TssQuarantineActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	bool enable;
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	UID tssId;
															#line 58 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 59 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	KeyBackedMap<UID, UID> tssMapDB;
															#line 68 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	ThreadFuture<Optional<Value>> serverListValueF;
															#line 74 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	StorageServerInterface ssi;
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	ThreadFuture<Optional<Value>> currentQuarantineValueF;
															#line 1133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tssQuarantine()
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssQuarantineActor final : public Actor<bool>, public ActorCallback< TssQuarantineActor, 0, Optional<Value> >, public ActorCallback< TssQuarantineActor, 1, Optional<Value> >, public ActorCallback< TssQuarantineActor, 2, Void >, public ActorCallback< TssQuarantineActor, 3, Void >, public FastAllocated<TssQuarantineActor>, public TssQuarantineActorState<TssQuarantineActor> {
															#line 1138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<TssQuarantineActor>::operator new;
	using FastAllocated<TssQuarantineActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4042507267454021376UL, 13202826903890886912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TssQuarantineActor, 0, Optional<Value> >;
friend struct ActorCallback< TssQuarantineActor, 1, Optional<Value> >;
friend struct ActorCallback< TssQuarantineActor, 2, Void >;
friend struct ActorCallback< TssQuarantineActor, 3, Void >;
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssQuarantineActor(Reference<IDatabase> const& db,bool const& enable,UID const& tssId) 
															#line 1158 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   TssQuarantineActorState<TssQuarantineActor>(db, enable, tssId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssQuarantine", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14226657720135446016UL, 14742354772989358336UL);
		ActorExecutionContextHelper __helper(static_cast<TssQuarantineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssQuarantine");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssQuarantine", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TssQuarantineActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TssQuarantineActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TssQuarantineActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TssQuarantineActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
[[nodiscard]] Future<bool> tssQuarantine( Reference<IDatabase> const& db, bool const& enable, UID const& tssId ) {
															#line 57 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	return Future<bool>(new TssQuarantineActor(db, enable, tssId));
															#line 1193 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
}

#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"

} // namespace

namespace fdb_cli {

															#line 1202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via tssqCommandActor()
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
template <class TssqCommandActorActor>
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssqCommandActorActorState {
															#line 1208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssqCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		 : db(db),
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		   tokens(tokens)
															#line 1217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("tssqCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~TssqCommandActorActorState() 
	{
		fdb_probe_actor_destroy("tssqCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
			if (tokens.size() == 2)
															#line 1232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
			{
															#line 115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				if (tokens[1] != "list"_sr)
															#line 1236 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
				{
															#line 116 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 117 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
					new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TssqCommandActorActorState();
					static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = tssQuarantineList(db);
															#line 119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					if (static_cast<TssqCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1254 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TssqCommandActorActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TssqCommandActorActor, 0, Void >*>(static_cast<TssqCommandActorActor*>(this)));
															#line 1259 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
			}
			else
			{
															#line 121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
				if (tokens.size() == 3)
															#line 1267 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
				{
															#line 122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					if ((tokens[1] != "start"_sr && tokens[1] != "stop"_sr) || (tokens[2].size() != 32) || !std::all_of(tokens[2].begin(), tokens[2].end(), &isxdigit))
															#line 1271 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
					{
															#line 124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 125 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1277 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
						new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~TssqCommandActorActorState();
						static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						bool enable = tokens[1] == "start"_sr;
															#line 128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						UID tssId = UID::fromString(tokens[2].toString());
															#line 129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						StrictFuture<bool> __when_expr_1 = tssQuarantine(db, enable, tssId);
															#line 129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						if (static_cast<TssqCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1293 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<TssqCommandActorActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssqCommandActorActor, 1, bool >*>(static_cast<TssqCommandActorActor*>(this)));
															#line 1298 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
				}
				else
				{
															#line 133 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
					if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1308 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
					new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~TssqCommandActorActorState();
					static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssqCommandActorActorState();
		static_cast<TssqCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 136 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1336 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TssqCommandActorActorState();
		static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssqCommandActorActor*>(this)->actor_wait_state > 0) static_cast<TssqCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<TssqCommandActorActor*>(this)->ActorCallback< TssqCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssqCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssqCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TssqCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(bool const& success,int loopDepth) 
	{
															#line 130 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(success); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1441 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(success);
		this->~TssqCommandActorActorState();
		static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(bool && success,int loopDepth) 
	{
															#line 130 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
		if (!static_cast<TssqCommandActorActor*>(this)->SAV<bool>::futures) { (void)(success); this->~TssqCommandActorActorState(); static_cast<TssqCommandActorActor*>(this)->destroy(); return 0; }
															#line 1453 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		new (&static_cast<TssqCommandActorActor*>(this)->SAV< bool >::value()) bool(success);
		this->~TssqCommandActorActorState();
		static_cast<TssqCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont8(success, loopDepth);

		return loopDepth;
	}
	int a_body1when2(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssqCommandActorActor*>(this)->actor_wait_state > 0) static_cast<TssqCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<TssqCommandActorActor*>(this)->ActorCallback< TssqCommandActorActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TssqCommandActorActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssqCommandActorActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TssqCommandActorActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 1540 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via tssqCommandActor()
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
class TssqCommandActorActor final : public Actor<bool>, public ActorCallback< TssqCommandActorActor, 0, Void >, public ActorCallback< TssqCommandActorActor, 1, bool >, public FastAllocated<TssqCommandActorActor>, public TssqCommandActorActorState<TssqCommandActorActor> {
															#line 1545 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<TssqCommandActorActor>::operator new;
	using FastAllocated<TssqCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15283260985129496320UL, 10061680548043165952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TssqCommandActorActor, 0, Void >;
friend struct ActorCallback< TssqCommandActorActor, 1, bool >;
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	TssqCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1563 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   TssqCommandActorActorState<TssqCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssqCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17309698773224748800UL, 1924158897302581248UL);
		ActorExecutionContextHelper __helper(static_cast<TssqCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssqCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssqCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TssqCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TssqCommandActorActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
[[nodiscard]] Future<bool> tssqCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"
	return Future<bool>(new TssqCommandActorActor(db, tokens));
															#line 1596 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/TssqCommand.actor.g.cpp.py_gen"
}

#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/TssqCommand.actor.cpp"

CommandFactory tssqFactory(
    "tssq",
    CommandHelp("tssq start|stop <StorageUID>",
                "start/stop tss quarantine",
                "Toggles Quarantine mode for a Testing Storage Server. Quarantine will happen automatically if the "
                "TSS is detected to have incorrect data, but can also be initiated manually. You can also remove a "
                "TSS from quarantine once your investigation is finished, which will destroy the TSS process."));

} // namespace fdb_cli
