#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
/*
 * GetAuditStatusCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fmt/core.h>

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/IClientApi.h"
#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 37 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgressByRange()
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressByRangeActor>
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByRangeActorState {
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByRangeActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange),
															#line 36 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToRead(auditRange),
															#line 37 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToReadBegin(auditRange.begin),
															#line 38 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   retryCount(0),
															#line 39 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   finishCount(0)
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgressByRange", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressByRangeActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgressByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressByRangeActorState();
		static_cast<GetAuditProgressByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 73 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Finished range count: {}", finishCount);
															#line 74 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressByRangeActorState(); static_cast<GetAuditProgressByRangeActor*>(this)->destroy(); return 0; }
															#line 104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAuditProgressByRangeActorState();
		static_cast<GetAuditProgressByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 40 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 123 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 41 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 129 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 43 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 44 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByRange(cx, auditType, auditId, rangeToRead);
															#line 44 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 169 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*>(static_cast<GetAuditProgressByRangeActor*>(this)));
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 62 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 213 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
															#line 64 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (retryCount > 30)
															#line 217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				fmt::println("Incomplete check");
															#line 66 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressByRangeActorState(); static_cast<GetAuditProgressByRangeActor*>(this)->destroy(); return 0; }
															#line 223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetAuditProgressByRangeActorState();
				static_cast<GetAuditProgressByRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 68 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 68 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByRangeActor, 1, Void >*>(static_cast<GetAuditProgressByRangeActor*>(this)));
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 46 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 47 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 48 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 257 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 49 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				fmt::println("( Ongoing ) {}", auditStates[i].range.toString());
															#line 261 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 50 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (phase == AuditPhase::Error)
															#line 267 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 51 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fmt::println("( Error   ) {}", auditStates[i].range.toString());
															#line 52 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					++finishCount;
															#line 273 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 54 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					++finishCount;
															#line 279 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 58 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 286 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 44 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		auditStates = __auditStates;
															#line 295 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByRangeActor*>(this)->ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 374 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 383 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByRangeActor*>(this)->ActorCallback< GetAuditProgressByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 36 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange rangeToRead;
															#line 37 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Key rangeToReadBegin;
															#line 38 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int retryCount;
															#line 39 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int64_t finishCount;
															#line 44 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 481 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgressByRange()
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByRangeActor final : public Actor<Void>, public ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< GetAuditProgressByRangeActor, 1, Void >, public FastAllocated<GetAuditProgressByRangeActor>, public GetAuditProgressByRangeActorState<GetAuditProgressByRangeActor> {
															#line 486 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressByRangeActor>::operator new;
	using FastAllocated<GetAuditProgressByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3044942798274470144UL, 1984956414116918784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditProgressByRangeActor, 1, Void >;
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByRangeActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 504 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAuditProgressByRangeActorState<GetAuditProgressByRangeActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3099155687841437696UL, 2572556085011420416UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgressByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<Void> getAuditProgressByRange( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 35 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<Void>(new GetAuditProgressByRangeActor(cx, auditType, auditId, auditRange));
															#line 537 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 76 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 542 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getStorageServers()
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetStorageServersActor>
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetStorageServersActorState {
															#line 548 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetStorageServersActorState(Database const& cx) 
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 78 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   tr(cx)
															#line 557 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 572 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 80 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 81 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 604 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		try {
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 610 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, RangeResult >*>(static_cast<GetStorageServersActor*>(this)));
															#line 615 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 639 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 2;
															#line 91 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 1, Void >*>(static_cast<GetStorageServersActor*>(this)));
															#line 644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& serverList,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 85 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 86 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		servers.reserve(serverList.size());
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 667 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 671 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && serverList,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 85 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 86 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		servers.reserve(serverList.size());
															#line 87 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 88 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 691 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 695 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 78 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Transaction tr;
															#line 869 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getStorageServers()
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetStorageServersActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< GetStorageServersActor, 0, RangeResult >, public ActorCallback< GetStorageServersActor, 1, Void >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 874 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9789154172895129344UL, 15726365813063919360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, RangeResult >;
friend struct ActorCallback< GetStorageServersActor, 1, Void >;
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetStorageServersActor(Database const& cx) 
															#line 892 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<std::vector<StorageServerInterface>>(),
		   GetStorageServersActorState<GetStorageServersActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> getStorageServers( Database const& cx ) {
															#line 77 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new GetStorageServersActor(cx));
															#line 925 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 95 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 930 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgressByServer()
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressByServerActor>
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByServerActorState {
															#line 936 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByServerActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId) 
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange),
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   serverId(serverId),
															#line 101 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToRead(auditRange),
															#line 102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToReadBegin(auditRange.begin),
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   retryCount(0)
															#line 957 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgressByServer", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressByServerActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgressByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 972 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressByServerActorState();
		static_cast<GetAuditProgressByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Complete); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 995 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Complete);
		this->~GetAuditProgressByServerActorState();
		static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 1014 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 1020 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 107 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByServer(cx, auditType, auditId, serverId, rangeToRead);
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*>(static_cast<GetAuditProgressByServerActor*>(this)));
															#line 1065 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1100 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 1104 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
															#line 124 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (retryCount > 30)
															#line 1108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 125 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Invalid); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1112 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Invalid);
				this->~GetAuditProgressByServerActorState();
				static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1122 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByServerActor, 1, Void >*>(static_cast<GetAuditProgressByServerActor*>(this)));
															#line 1127 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 110 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 112 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 1146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 113 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Running); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1150 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Running);
				this->~GetAuditProgressByServerActorState();
				static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 114 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (phase == AuditPhase::Error)
															#line 1160 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Error); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Error);
					this->~GetAuditProgressByServerActorState();
					static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 118 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 1174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		auditStates = __auditStates;
															#line 1183 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByServerActor*>(this)->ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 1262 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 1271 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByServerActor*>(this)->ActorCallback< GetAuditProgressByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID serverId;
															#line 101 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange rangeToRead;
															#line 102 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Key rangeToReadBegin;
															#line 103 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int retryCount;
															#line 108 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 1369 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgressByServer()
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByServerActor final : public Actor<AuditPhase>, public ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >, public ActorCallback< GetAuditProgressByServerActor, 1, Void >, public FastAllocated<GetAuditProgressByServerActor>, public GetAuditProgressByServerActorState<GetAuditProgressByServerActor> {
															#line 1374 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressByServerActor>::operator new;
	using FastAllocated<GetAuditProgressByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18263964425799437312UL, 6191032665779153664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditPhase>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditProgressByServerActor, 1, Void >;
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByServerActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId) 
															#line 1392 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<AuditPhase>(),
		   GetAuditProgressByServerActorState<GetAuditProgressByServerActor>(cx, auditType, auditId, auditRange, serverId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6092320488064633088UL, 17915599859443968512UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgressByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<AuditPhase> getAuditProgressByServer( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange, UID const& serverId ) {
															#line 96 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<AuditPhase>(new GetAuditProgressByServerActor(cx, auditType, auditId, auditRange, serverId));
															#line 1425 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 134 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 1430 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgress()
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressActor>
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressActorState {
															#line 1436 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange)
															#line 1449 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgress", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 136 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica || auditType == AuditType::ValidateLocationMetadata)
															#line 1464 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getAuditProgressByRange(cx, auditType, auditId, auditRange);
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1470 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 1;
															#line 138 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 0, Void >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1475 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 139 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (auditType == AuditType::ValidateStorageServerShard)
															#line 1482 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 140 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fs = std::vector<Future<Void>>();
															#line 141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					res = std::unordered_map<UID, bool>();
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1492 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1497 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 169 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fmt::println("AuditType not implemented");
															#line 1504 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressActorState();
		static_cast<GetAuditProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 171 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressActorState(); static_cast<GetAuditProgressActor*>(this)->destroy(); return 0; }
															#line 1529 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAuditProgressActorState();
		static_cast<GetAuditProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i = 0;
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numCompleteServers = 0;
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numOngoingServers = 0;
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numErrorServers = 0;
															#line 147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numTSSes = 0;
															#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 1644 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<StorageServerInterface> const& __interfs,int loopDepth) 
	{
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		interfs = __interfs;
															#line 1653 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<StorageServerInterface> && __interfs,int loopDepth) 
	{
		interfs = std::move(__interfs);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("CompleteServers: {}", numCompleteServers);
															#line 165 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("OngoingServers: {}", numOngoingServers);
															#line 166 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("ErrorServers: {}", numErrorServers);
															#line 167 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("IgnoredTSSes: {}", numTSSes);
															#line 1738 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(i < interfs.size()))
															#line 1754 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 149 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (interfs[i].isTss())
															#line 1760 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 150 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numTSSes++;
															#line 1764 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			return a_body1cont4continue1(loopDepth); // continue
		}
															#line 153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		StrictFuture<AuditPhase> __when_expr_2 = getAuditProgressByServer(cx, auditType, auditId, allKeys, interfs[i].id());
															#line 153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1771 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 3;
															#line 153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 2, AuditPhase >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1776 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4continue1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1798 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(AuditPhase const& serverPhase,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (serverPhase == AuditPhase::Running)
															#line 1807 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 155 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numOngoingServers++;
															#line 1811 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 156 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (serverPhase == AuditPhase::Complete)
															#line 1817 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 157 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				numCompleteServers++;
															#line 1821 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (serverPhase == AuditPhase::Error)
															#line 1827 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 159 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					numErrorServers++;
															#line 1831 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 160 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (serverPhase == AuditPhase::Invalid)
															#line 1837 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 161 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						fmt::println("SS {} partial progress fetched", interfs[i].id().toString());
															#line 1841 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1848 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(AuditPhase && serverPhase,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (serverPhase == AuditPhase::Running)
															#line 1857 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 155 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numOngoingServers++;
															#line 1861 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 156 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (serverPhase == AuditPhase::Complete)
															#line 1867 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 157 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				numCompleteServers++;
															#line 1871 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (serverPhase == AuditPhase::Error)
															#line 1877 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 159 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					numErrorServers++;
															#line 1881 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 160 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (serverPhase == AuditPhase::Invalid)
															#line 1887 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 161 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						fmt::println("SS {} partial progress fetched", interfs[i].id().toString());
															#line 1891 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 148 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1898 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(AuditPhase const& serverPhase,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(serverPhase, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(AuditPhase && serverPhase,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(serverPhase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 2, AuditPhase >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,AuditPhase const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,AuditPhase && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 140 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::unordered_map<UID, bool> res;
															#line 142 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<StorageServerInterface> interfs;
															#line 143 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int i;
															#line 144 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numCompleteServers;
															#line 145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numOngoingServers;
															#line 146 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numErrorServers;
															#line 147 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numTSSes;
															#line 2002 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgress()
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressActor final : public Actor<Void>, public ActorCallback< GetAuditProgressActor, 0, Void >, public ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< GetAuditProgressActor, 2, AuditPhase >, public FastAllocated<GetAuditProgressActor>, public GetAuditProgressActorState<GetAuditProgressActor> {
															#line 2007 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressActor>::operator new;
	using FastAllocated<GetAuditProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18162751721388052992UL, 15242730676268492032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressActor, 0, Void >;
friend struct ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetAuditProgressActor, 2, AuditPhase >;
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 2026 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAuditProgressActorState<GetAuditProgressActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1505681669917957376UL, 1459007093216598528UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAuditProgressActor, 2, AuditPhase >*)0, actor_cancelled()); break;
		}

	}
};
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<Void> getAuditProgress( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<Void>(new GetAuditProgressActor(cx, auditType, auditId, auditRange));
															#line 2060 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 173 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 2065 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditStatusCommandActor()
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditStatusCommandActorActor>
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditStatusCommandActorActorState {
															#line 2071 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditStatusCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   tokens(tokens)
															#line 2080 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStatusCommandActorActorState() 
	{
		fdb_probe_actor_destroy("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokens.size() < 2 || tokens.size() > 5)
															#line 2095 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 176 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 177 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2101 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetAuditStatusCommandActorActorState();
				static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 180 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditType type = AuditType::Invalid;
															#line 181 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokencmp(tokens[1], "ha"))
															#line 2111 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 182 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				type = AuditType::ValidateHA;
															#line 2115 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 183 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokencmp(tokens[1], "replica"))
															#line 2121 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 184 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					type = AuditType::ValidateReplica;
															#line 2125 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 185 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokencmp(tokens[1], "locationmetadata"))
															#line 2131 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 186 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						type = AuditType::ValidateLocationMetadata;
															#line 2135 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 187 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokencmp(tokens[1], "ssshard"))
															#line 2141 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 188 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							type = AuditType::ValidateStorageServerShard;
															#line 2145 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						}
						else
						{
															#line 190 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 191 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2153 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~GetAuditStatusCommandActorActorState();
							static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
															#line 194 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokencmp(tokens[2], "id"))
															#line 2164 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 195 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokens.size() != 4)
															#line 2168 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 196 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 197 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~GetAuditStatusCommandActorActorState();
					static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 199 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				const UID id = UID::fromString(tokens[3].toString());
															#line 200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				StrictFuture<AuditStorageState> __when_expr_0 = getAuditState(cx, type, id);
															#line 200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2186 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 1;
															#line 200 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2191 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokencmp(tokens[2], "progress"))
															#line 2198 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 203 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokens.size() != 4)
															#line 2202 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 204 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 205 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetAuditStatusCommandActorActorState();
						static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 207 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					const UID id = UID::fromString(tokens[3].toString());
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					StrictFuture<AuditStorageState> __when_expr_1 = getAuditState(cx, type, id);
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2220 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 2;
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 214 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokencmp(tokens[2], "recent"))
															#line 2232 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 215 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						int count = CLIENT_KNOBS->TOO_MANY;
															#line 216 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokens.size() == 4)
															#line 2238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 217 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							count = std::stoi(tokens[3].toString());
															#line 2242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						}
															#line 219 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, type, true, count);
															#line 219 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2248 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when3(__when_expr_3.get(), loopDepth); };
						static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 4;
															#line 219 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2253 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 223 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokencmp(tokens[2], "phase"))
															#line 2260 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 224 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							AuditPhase phase = stringToAuditPhase(tokens[3].toString());
															#line 225 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (phase == AuditPhase::Invalid)
															#line 2266 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							{
															#line 226 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 227 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2272 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
								new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~GetAuditStatusCommandActorActorState();
								static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 229 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							int count = CLIENT_KNOBS->TOO_MANY;
															#line 230 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (tokens.size() == 5)
															#line 2282 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							{
															#line 231 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								count = std::stoi(tokens[4].toString());
															#line 2286 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							}
															#line 233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							StrictFuture<std::vector<AuditStorageState>> __when_expr_4 = getAuditStates(cx, type, true, count, phase);
															#line 233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2292 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when4(__when_expr_4.get(), loopDepth); };
							static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 5;
															#line 233 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2297 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 238 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 239 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2306 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~GetAuditStatusCommandActorActorState();
							static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStatusCommandActorActorState();
		static_cast<GetAuditStatusCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 242 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2336 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetAuditStatusCommandActorActorState();
		static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(AuditStorageState const& res,int loopDepth) 
	{
															#line 201 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Audit result is:\n{}", res.toString());
															#line 2348 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(AuditStorageState && res,int loopDepth) 
	{
															#line 201 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Audit result is:\n{}", res.toString());
															#line 2357 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(AuditStorageState const& res,int loopDepth) 
	{
		loopDepth = a_body1cont11(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(AuditStorageState && res,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 209 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (res.getPhase() == AuditPhase::Running)
															#line 2447 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = getAuditProgress(cx, res.getType(), res.id, res.range);
															#line 210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2453 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont14when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 3;
															#line 210 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2458 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 212 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Already complete");
															#line 2465 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1cont14cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2(AuditStorageState const& __res,int loopDepth) 
	{
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		res = __res;
															#line 2475 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when2(AuditStorageState && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14cont1(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
															#line 220 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2655 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(std::vector<AuditStorageState> && res,int loopDepth) 
	{
															#line 220 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 221 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2667 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1when3(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont17(res, loopDepth);

		return loopDepth;
	}
	int a_body1when3(std::vector<AuditStorageState> && res,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
															#line 234 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 235 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2760 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(std::vector<AuditStorageState> && res,int loopDepth) 
	{
															#line 234 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 235 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2772 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1when4(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont20(res, loopDepth);

		return loopDepth;
	}
	int a_body1when4(std::vector<AuditStorageState> && res,int loopDepth) 
	{
		loopDepth = a_body1cont20(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 208 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditStorageState res;
															#line 2859 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStatusCommandActor()
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditStatusCommandActorActor final : public Actor<bool>, public ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >, public ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >, public ActorCallback< GetAuditStatusCommandActorActor, 2, Void >, public ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >, public ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >, public FastAllocated<GetAuditStatusCommandActorActor>, public GetAuditStatusCommandActorActorState<GetAuditStatusCommandActorActor> {
															#line 2864 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStatusCommandActorActor>::operator new;
	using FastAllocated<GetAuditStatusCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(411176048977352192UL, 7400623199594572032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 2, Void >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >;
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditStatusCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 2885 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   GetAuditStatusCommandActorActorState<GetAuditStatusCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11706623673812082688UL, 3755119283022406400UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStatusCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<bool> getAuditStatusCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 174 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<bool>(new GetAuditStatusCommandActorActor(cx, tokens));
															#line 2921 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/build_output/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 244 "/codebuild/output/src3428585126/src/github.com/apple/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

CommandFactory getAuditStatusFactory(
    "get_audit_status",
    CommandHelp("get_audit_status [ha|replica|locationmetadata|ssshard] [id|recent|phase|progress] [ARGs]",
                "Retrieve audit storage status",
                "To fetch audit status via ID: `get_audit_status [Type] id [ID]'\n"
                "To fetch status of most recent audit: `get_audit_status [Type] recent [Count]'\n"
                "To fetch status of audits in a specific phase: `get_audit_status [Type] phase "
                "[running|complete|failed|error] count'\n"
                "To fetch audit progress via ID: `get_audit_status [Type] progress [ID]'\n"
                "Supported types include: 'ha', `replica`, `locationmetadata`, `ssshard`. \n"
                "If specified, `Count' is how many rows to audit.\n"
                "If not specified, check all rows in audit.\n"
                "Phase can be `Invalid=0', `Running=1', `Complete=2', `Error=3', or `Failed=4'.\n"
                "See also `audit_storage' command."));
} // namespace fdb_cli
