#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
/*
 * VersionStamp.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct VersionStampWorkload : TestWorkload {
	static constexpr auto NAME = "VersionStamp";

	uint64_t nodeCount;
	double testDuration;
	double transactionsPerSecond;
	std::vector<Future<Void>> clients;
	int64_t nodePrefix;
	int keyBytes;
	bool failIfDataLost;
	Key vsKeyPrefix;
	Key vsValuePrefix;
	bool validateExtraDB;
	std::map<Key, std::vector<std::pair<Version, Standalone<StringRef>>>> key_commit;
	std::map<Key, std::vector<std::pair<Version, Standalone<StringRef>>>> versionStampKey_commit;
	int apiVersion;
	bool soleOwnerOfMetadataVersionKey;
	bool allowMetadataVersionKey;

	VersionStampWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0);
		nodeCount = getOption(options, "nodeCount"_sr, (uint64_t)10000);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 4);
		failIfDataLost = getOption(options, "failIfDataLost"_sr, true);
		const Key prefix = getOption(options, "prefix"_sr, "VS_"_sr);
		vsKeyPrefix = "K_"_sr.withPrefix(prefix);
		vsValuePrefix = "V_"_sr.withPrefix(prefix);
		validateExtraDB = getOption(options, "validateExtraDB"_sr, false);
		soleOwnerOfMetadataVersionKey = getOption(options, "soleOwnerOfMetadataVersionKey"_sr, false);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		// Versionstamp behavior changed starting with API version 520, so
		// choose a version to check compatibility.
		double choice = deterministicRandom()->random01();
		if (choice < 0.1) {
			apiVersion = 500;
		} else if (choice < 0.2) {
			apiVersion = 510;
		} else if (choice < 0.3) {
			apiVersion = 520;
		} else {
			apiVersion = ApiVersion::LATEST_VERSION;
		}
		TraceEvent("VersionStampApiVersion").detail("ApiVersion", apiVersion);

		allowMetadataVersionKey = apiVersion >= 610 || apiVersion == ApiVersion::LATEST_VERSION;

		cx->apiVersion = ApiVersion(apiVersion);
		if (clientId == 0)
			return _start(cx, this, 1 / transactionsPerSecond);
		return Void();
	}

	Key keyForIndex(uint64_t index) {
		if (allowMetadataVersionKey && index == 0) {
			return metadataVersionKey;
		}

		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodeCount;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result.withPrefix(vsValuePrefix);
	}

	Key versionStampKeyForIndex(uint64_t index, bool oldVSFormat) {
		const size_t keySize = 38 + (oldVSFormat ? 0 : 2);
		Key result = makeString(keySize);
		uint8_t* data = mutateString(result);
		memset(&data[0], 'V', keySize);

		double d = double(index) / nodeCount;
		emplaceIndex(data, 4, *(int64_t*)&d);

		if (oldVSFormat) {
			data[keySize - 2] = 24 + vsKeyPrefix.size();
			data[keySize - 1] = 0;
		} else {
			data[keySize - 4] = 24 + vsKeyPrefix.size();
			data[keySize - 3] = 0;
			data[keySize - 2] = 0;
			data[keySize - 1] = 0;
		}
		return result.withPrefix(vsKeyPrefix);
	}

	static Key endOfRange(Key startOfRange) {
		int n = startOfRange.size();
		Key result = makeString(n);
		uint8_t* data = mutateString(result);
		uint8_t* src = mutateString(startOfRange);
		memcpy(data, src, n);
		data[n - 1] += 1;
		return result;
	}

	Future<bool> check(Database const& cx) override {
		if (clientId == 0)
			return _check(cx, this);
		return true;
	}

	static std::pair<Version, Standalone<StringRef>> versionFromValue(const Standalone<StringRef>& value) {
		Version parsedVersion;
		Standalone<StringRef> parsedVersionstamp = makeString(10);
		memcpy(&parsedVersion, value.begin(), sizeof(Version));
		memcpy(mutateString(parsedVersionstamp), value.begin(), 10);
		return { bigEndian64(parsedVersion), parsedVersionstamp };
	}

	// `key` needs to be the non-prefixed key, as we use a fixed offset for the versionstamp location.
	static std::pair<Version, Standalone<StringRef>> versionFromKey(const Standalone<StringRef>& key) {
		Version parsedVersion;
		Standalone<StringRef> parsedVersionstamp = makeString(10);
		memcpy(&parsedVersion, &(key.begin())[24], sizeof(Version));
		memcpy(mutateString(parsedVersionstamp), &(key.begin())[24], 10);
		return { bigEndian64(parsedVersion), parsedVersionstamp };
	}

																#line 158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
template <class _checkActor>
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
class _checkActorState {
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
public:
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	_checkActorState(Database const& cx,VersionStampWorkload* const& self) 
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		 : cx(cx),
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   self(self)
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 157 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (self->validateExtraDB)
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(g_simulator->extraDatabases.size() == 1);
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				cx = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 161 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			readVersion = Version();
															#line 165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			;
															#line 202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (BUGGIFY)
															#line 225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 229 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				;
															#line 233 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 262 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Version >*>(static_cast<_checkActor*>(this)));
															#line 267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 304 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& _readVersion,int loopDepth) 
	{
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		readVersion = _readVersion;
															#line 324 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && _readVersion,int loopDepth) 
	{
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		readVersion = _readVersion;
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& _readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && _readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		result = RangeResult();
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		;
															#line 506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		tr.reset();
															#line 189 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		tr.setVersion(readVersion);
															#line 517 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr.makeSelfConflicting();
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 591 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		readVersion = tr.getCommittedVersion() - 1;
															#line 606 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		readVersion = tr.getCommittedVersion() - 1;
															#line 615 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 304 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		TraceEvent("VST_CheckEnd").log();
															#line 305 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 788 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange( KeyRangeRef(self->vsValuePrefix, endOfRange(self->vsValuePrefix)), self->nodeCount + 1);
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 810 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 815 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 301 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 301 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 852 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 301 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, Void >*>(static_cast<_checkActor*>(this)));
															#line 857 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(RangeResult const& result_,int loopDepth) 
	{
															#line 197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		result = result_;
															#line 198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (self->allowMetadataVersionKey && self->key_commit.contains(metadataVersionKey))
															#line 874 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_5 = tr.get(metadataVersionKey);
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 880 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Optional<Value> >*>(static_cast<_checkActor*>(this)));
															#line 885 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(RangeResult && result_,int loopDepth) 
	{
															#line 197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		result = result_;
															#line 198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (self->allowMetadataVersionKey && self->key_commit.contains(metadataVersionKey))
															#line 901 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_5 = tr.get(metadataVersionKey);
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 907 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Optional<Value> >*>(static_cast<_checkActor*>(this)));
															#line 912 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(RangeResult const& result_,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(result_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(RangeResult && result_,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(result_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont3(int loopDepth) 
	{
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		ASSERT(result.size() <= self->nodeCount);
															#line 205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (self->failIfDataLost)
															#line 1003 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(result.size() == self->key_commit.size());
															#line 1007 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			CODE_PROBE(result.size() > 0, "Not all data should always be lost.");
															#line 1013 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		for( auto it : result ) {
															#line 213 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const Standalone<StringRef> key = it.key == metadataVersionKey ? metadataVersionKey : it.key.removePrefix(self->vsValuePrefix);
															#line 215 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Version parsedVersion;
															#line 216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Standalone<StringRef> parsedVersionstamp;
															#line 217 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			std::tie(parsedVersion, parsedVersionstamp) = versionFromValue(it.value);
															#line 218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(parsedVersion <= readVersion);
															#line 221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values_iter = self->key_commit.find(key);
															#line 222 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(all_values_iter != self->key_commit.end());
															#line 223 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values = all_values_iter->second;
															#line 225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (it.key == metadataVersionKey && !self->soleOwnerOfMetadataVersionKey)
															#line 1035 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 226 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				if (self->failIfDataLost)
															#line 1039 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				{
															#line 227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					for( auto& it : all_values ) {
															#line 228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
						ASSERT(it.first <= parsedVersion);
															#line 229 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
						if (it.first == parsedVersion)
															#line 1047 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
						{
															#line 230 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
							ASSERT(it.second.compare(parsedVersionstamp) == 0);
															#line 1051 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
						}
					}
				}
			}
			else
			{
															#line 235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				const auto& value_pair_iter = std::find_if(all_values.cbegin(), all_values.cend(), [parsedVersion](const std::pair<Version, Standalone<StringRef>>& pair) { return pair.first == parsedVersion; });
															#line 241 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(value_pair_iter != all_values.cend());
															#line 243 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				if (self->failIfDataLost)
															#line 1064 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				{
															#line 244 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					auto last_element_iter = all_values.cend();
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					last_element_iter--;
															#line 246 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					ASSERT(value_pair_iter == last_element_iter);
															#line 1072 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				}
															#line 249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				Standalone<StringRef> commitVersionstamp = value_pair_iter->second;
															#line 252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(commitVersionstamp.compare(parsedVersionstamp) == 0);
															#line 1078 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
		}
															#line 256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr.getRange(KeyRangeRef(self->vsKeyPrefix, endOfRange(self->vsKeyPrefix)), self->nodeCount + 1);
															#line 256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1085 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 1090 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Optional<Value> const& mVal,int loopDepth) 
	{
															#line 200 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (mVal.present())
															#line 1099 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(metadataVersionKey, mVal.get()));
															#line 1103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Optional<Value> && mVal,int loopDepth) 
	{
															#line 200 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (mVal.present())
															#line 1113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(metadataVersionKey, mVal.get()));
															#line 1117 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Optional<Value> const& mVal,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(mVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Optional<Value> && mVal,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(std::move(mVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont7(RangeResult const& result__,int loopDepth) 
	{
															#line 258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		result = result__;
															#line 259 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		ASSERT(result.size() <= self->nodeCount);
															#line 260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (self->failIfDataLost)
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(result.size() == self->versionStampKey_commit.size());
															#line 1210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 263 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			CODE_PROBE(result.size() > 0, "Not all data should always be lost (2)");
															#line 1216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
															#line 267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		for( auto it : result ) {
															#line 268 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const Standalone<StringRef> key = it.key.removePrefix(self->vsKeyPrefix);
															#line 269 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Version parsedVersion;
															#line 270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Standalone<StringRef> parsedVersionstamp;
															#line 271 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			std::tie(parsedVersion, parsedVersionstamp) = versionFromKey(key);
															#line 273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const Key vsKey = key.substr(4, 16);
															#line 275 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values_iter = self->versionStampKey_commit.find(vsKey);
															#line 276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(all_values_iter != self->versionStampKey_commit.end());
															#line 278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values = all_values_iter->second;
															#line 280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& value_pair_iter = std::find_if(all_values.cbegin(), all_values.cend(), [parsedVersion](const std::pair<Version, Standalone<StringRef>>& pair) { return pair.first == parsedVersion; });
															#line 286 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(value_pair_iter != all_values.cend());
															#line 287 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (self->failIfDataLost)
															#line 1242 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 288 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				auto last_element_iter = all_values.cend();
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				last_element_iter--;
															#line 290 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(value_pair_iter == last_element_iter);
															#line 1250 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 294 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Standalone<StringRef> commitVersionstamp = value_pair_iter->second;
															#line 296 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(parsedVersion <= readVersion);
															#line 297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(commitVersionstamp.compare(parsedVersionstamp) == 0);
															#line 1258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7(RangeResult && result__,int loopDepth) 
	{
															#line 258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		result = result__;
															#line 259 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		ASSERT(result.size() <= self->nodeCount);
															#line 260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (self->failIfDataLost)
															#line 1272 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(result.size() == self->versionStampKey_commit.size());
															#line 1276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 263 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			CODE_PROBE(result.size() > 0, "Not all data should always be lost (2)");
															#line 1282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
															#line 267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		for( auto it : result ) {
															#line 268 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const Standalone<StringRef> key = it.key.removePrefix(self->vsKeyPrefix);
															#line 269 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Version parsedVersion;
															#line 270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Standalone<StringRef> parsedVersionstamp;
															#line 271 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			std::tie(parsedVersion, parsedVersionstamp) = versionFromKey(key);
															#line 273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const Key vsKey = key.substr(4, 16);
															#line 275 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values_iter = self->versionStampKey_commit.find(vsKey);
															#line 276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(all_values_iter != self->versionStampKey_commit.end());
															#line 278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& all_values = all_values_iter->second;
															#line 280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			const auto& value_pair_iter = std::find_if(all_values.cbegin(), all_values.cend(), [parsedVersion](const std::pair<Version, Standalone<StringRef>>& pair) { return pair.first == parsedVersion; });
															#line 286 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(value_pair_iter != all_values.cend());
															#line 287 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (self->failIfDataLost)
															#line 1308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 288 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				auto last_element_iter = all_values.cend();
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				last_element_iter--;
															#line 290 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(value_pair_iter == last_element_iter);
															#line 1316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 294 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			Standalone<StringRef> commitVersionstamp = value_pair_iter->second;
															#line 296 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(parsedVersion <= readVersion);
															#line 297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			ASSERT(commitVersionstamp.compare(parsedVersionstamp) == 0);
															#line 1324 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(RangeResult const& result__,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont7(result__, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(RangeResult && result__,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont7(std::move(result__), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Database cx;
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	VersionStampWorkload* self;
															#line 161 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Version readVersion;
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	RangeResult result;
															#line 1502 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Version >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Void >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, RangeResult >, public ActorCallback< _checkActor, 5, Optional<Value> >, public ActorCallback< _checkActor, 6, RangeResult >, public ActorCallback< _checkActor, 7, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1507 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1344318780724159488UL, 3036798067465251840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Version >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Void >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, RangeResult >;
friend struct ActorCallback< _checkActor, 5, Optional<Value> >;
friend struct ActorCallback< _checkActor, 6, RangeResult >;
friend struct ActorCallback< _checkActor, 7, Void >;
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	_checkActor(Database const& cx,VersionStampWorkload* const& self) 
															#line 1531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, VersionStampWorkload* const& self ) {
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
}

#line 307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 1577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
template <class _startActor>
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
class _startActorState {
															#line 1583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
public:
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	_startActorState(Database const& cx,VersionStampWorkload* const& self,double const& delay) 
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		 : cx(cx),
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   self(self),
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   delay(delay),
															#line 311 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   startTime(now()),
															#line 312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   lastTime(now()),
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		   extraDB()
															#line 1600 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 315 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (!g_simulator->extraDatabases.empty())
															#line 1615 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				ASSERT(g_simulator->extraDatabases.size() == 1);
															#line 317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);
															#line 1621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			metadataWatch = Void();
															#line 321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			;
															#line 1627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 450 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		bool oldVSFormat = !cx->apiVersionAtLeast(520);
															#line 325 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		cx_is_primary = true;
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 327 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		key = self->keyForIndex(deterministicRandom()->randomInt(0, self->nodeCount));
															#line 328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		value = Value(std::string(deterministicRandom()->randomInt(10, 100), 'x'));
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		versionStampKey = self->versionStampKeyForIndex(deterministicRandom()->randomInt(0, self->nodeCount), oldVSFormat);
															#line 331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		prefix = versionStampKey.substr(0, 20 + self->vsKeyPrefix.size());
															#line 332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		endOfRange = self->endOfRange(prefix);
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		range = KeyRangeRef(prefix, endOfRange);
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersionStamp = Standalone<StringRef>();
															#line 335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersion = Version();
															#line 337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		versionStampValue = Value();
															#line 339 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (key == metadataVersionKey)
															#line 1722 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 340 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			value = metadataVersionRequiredValue;
															#line 341 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			versionStampValue = value;
															#line 1728 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 342 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (oldVSFormat)
															#line 1734 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				versionStampValue = value;
															#line 1738 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
			else
			{
															#line 345 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				versionStampValue = value.withSuffix("\x00\x00\x00\x00"_sr);
															#line 1744 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
		}
															#line 348 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		ryw = deterministicRandom()->coinflip();
															#line 349 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		;
															#line 1751 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		bool oldVSFormat = !cx->apiVersionAtLeast(520);
															#line 325 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		cx_is_primary = true;
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 327 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		key = self->keyForIndex(deterministicRandom()->randomInt(0, self->nodeCount));
															#line 328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		value = Value(std::string(deterministicRandom()->randomInt(10, 100), 'x'));
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		versionStampKey = self->versionStampKeyForIndex(deterministicRandom()->randomInt(0, self->nodeCount), oldVSFormat);
															#line 331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		prefix = versionStampKey.substr(0, 20 + self->vsKeyPrefix.size());
															#line 332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		endOfRange = self->endOfRange(prefix);
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		range = KeyRangeRef(prefix, endOfRange);
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersionStamp = Standalone<StringRef>();
															#line 335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersion = Version();
															#line 337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		versionStampValue = Value();
															#line 339 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (key == metadataVersionKey)
															#line 1784 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 340 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			value = metadataVersionRequiredValue;
															#line 341 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			versionStampValue = value;
															#line 1790 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 342 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (oldVSFormat)
															#line 1796 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				versionStampValue = value;
															#line 1800 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
			else
			{
															#line 345 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				versionStampValue = value.withSuffix("\x00\x00\x00\x00"_sr);
															#line 1806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
		}
															#line 348 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		ryw = deterministicRandom()->coinflip();
															#line 349 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		;
															#line 1813 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (now() - startTime > self->testDuration)
															#line 1897 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 350 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (!ryw)
															#line 1916 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 1920 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
															#line 353 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		error = false;
															#line 354 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		err = Error();
															#line 356 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		testKey = Key();
															#line 357 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		nextMetadataWatch = Future<Void>();
															#line 1930 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		try {
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr.atomicOp(key, versionStampValue, MutationRef::SetVersionstampedValue);
															#line 360 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (key == metadataVersionKey)
															#line 1936 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				testKey = "testKey" + deterministicRandom()->randomUniqueID().toString();
															#line 362 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				tr.atomicOp(testKey, versionStampValue, MutationRef::SetVersionstampedValue);
															#line 1942 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 364 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr.clear(range);
															#line 365 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			tr.atomicOp(versionStampKey, value, MutationRef::SetVersionstampedKey);
															#line 366 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (key == metadataVersionKey)
															#line 1950 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				nextMetadataWatch = tr.watch(versionStampKey);
															#line 1954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			}
															#line 369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			fTrVs = tr.getVersionstamp();
															#line 370 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 370 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1962 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 370 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1967 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 428 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (error)
															#line 1995 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 429 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			TraceEvent("VST_CommitFailed") .error(err) .detail("Key", printable(key)) .detail("VsKey", printable(versionStampKey));
															#line 433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(err);
															#line 433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2003 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2008 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			err = e;
															#line 383 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (err.code() == error_code_database_locked && !g_simulator->extraDatabases.empty())
															#line 2025 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			{
															#line 385 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				cx_is_primary = !cx_is_primary;
															#line 386 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				tr = ReadYourWritesTransaction(cx_is_primary ? cx : extraDB);
															#line 2031 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 388 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
				if (err.code() == error_code_commit_unknown_result)
															#line 2038 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
				{
															#line 390 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					;
															#line 2042 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1cont1loopBody1Catch1loopHead1(loopDepth);
				}
				else
				{
															#line 424 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
					error = true;
															#line 2049 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1cont1loopBody1Catch1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 372 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersion = tr.getCommittedVersion();
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = fTrVs;
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2070 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Standalone<StringRef> >*>(static_cast<_startActor*>(this)));
															#line 2075 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 372 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersion = tr.getCommittedVersion();
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = fTrVs;
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2088 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Standalone<StringRef> >*>(static_cast<_startActor*>(this)));
															#line 2093 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont6(Standalone<StringRef> const& committedVersionStamp_,int loopDepth) 
	{
															#line 374 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersionStamp = committedVersionStamp_;
															#line 376 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (key == metadataVersionKey)
															#line 2179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeoutError(metadataWatch, 30);
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6(Standalone<StringRef> && committedVersionStamp_,int loopDepth) 
	{
															#line 374 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		committedVersionStamp = committedVersionStamp_;
															#line 376 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (key == metadataVersionKey)
															#line 2206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_3 = timeoutError(metadataWatch, 30);
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2217 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Standalone<StringRef> const& committedVersionStamp_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(committedVersionStamp_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Standalone<StringRef> && committedVersionStamp_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(std::move(committedVersionStamp_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 378 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		nextMetadataWatch = metadataWatch;
															#line 2312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 378 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		nextMetadataWatch = metadataWatch;
															#line 2321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		cur_tr = ReadYourWritesTransaction(cx_is_primary ? cx : extraDB);
															#line 392 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		cur_tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2445 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		try {
															#line 394 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = cur_tr.get(key == metadataVersionKey ? testKey : key);
															#line 394 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1Catch1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 394 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2456 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1Catch1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			StrictFuture<Void> __when_expr_5 = cur_tr.onError(e);
															#line 420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 2493 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1cont2(Optional<Value> const& vs_value,int loopDepth) 
	{
															#line 395 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (!vs_value.present())
															#line 2513 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 396 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			error = true;
															#line 2517 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 399 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const Version value_version = versionFromValue(vs_value.get()).first;
															#line 401 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const auto& value_ts = self->key_commit[key == metadataVersionKey ? metadataVersionKey : key.removePrefix(self->vsValuePrefix)];
															#line 404 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const auto& iter = std::find_if( value_ts.cbegin(), value_ts.cend(), [value_version](const std::pair<Version, Standalone<StringRef>>& pair) { return value_version == pair.first; });
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (iter == value_ts.cend())
															#line 2528 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 412 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			committedVersion = value_version;
															#line 413 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			committedVersionStamp = vs_value.get().substr(0, 10);
															#line 2534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			error = true;
															#line 2540 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
		return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1cont2(Optional<Value> && vs_value,int loopDepth) 
	{
															#line 395 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (!vs_value.present())
															#line 2551 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 396 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			error = true;
															#line 2555 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 399 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const Version value_version = versionFromValue(vs_value.get()).first;
															#line 401 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const auto& value_ts = self->key_commit[key == metadataVersionKey ? metadataVersionKey : key.removePrefix(self->vsValuePrefix)];
															#line 404 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const auto& iter = std::find_if( value_ts.cbegin(), value_ts.cend(), [value_version](const std::pair<Version, Standalone<StringRef>>& pair) { return value_version == pair.first; });
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		if (iter == value_ts.cend())
															#line 2566 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		{
															#line 412 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			committedVersion = value_version;
															#line 413 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			committedVersionStamp = vs_value.get().substr(0, 10);
															#line 2572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		}
		else
		{
															#line 415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
			error = true;
															#line 2578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
			return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
		return a_body1loopBody1cont1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1when1(Optional<Value> const& vs_value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1cont2(vs_value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1when1(Optional<Value> && vs_value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1cont2(std::move(vs_value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont11(int loopDepth) 
	{
															#line 437 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const Standalone<StringRef> vsKeyKey = versionStampKey.removePrefix(self->vsKeyPrefix).substr(4, 16);
															#line 438 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		const auto& committedVersionPair = std::make_pair(committedVersion, committedVersionStamp);
															#line 440 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		self->key_commit[key == metadataVersionKey ? metadataVersionKey : key.removePrefix(self->vsValuePrefix)] .push_back(committedVersionPair);
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
		self->versionStampKey_commit[vsKeyKey].push_back(committedVersionPair);
															#line 2757 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Database cx;
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	VersionStampWorkload* self;
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	double delay;
															#line 311 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	double startTime;
															#line 312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	double lastTime;
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Database extraDB;
															#line 320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Future<Void> metadataWatch;
															#line 325 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	bool cx_is_primary;
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 327 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Key key;
															#line 328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Value value;
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Key versionStampKey;
															#line 331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	StringRef prefix;
															#line 332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Key endOfRange;
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	KeyRangeRef range;
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Standalone<StringRef> committedVersionStamp;
															#line 335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Version committedVersion;
															#line 337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Value versionStampValue;
															#line 348 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	bool ryw;
															#line 353 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	bool error;
															#line 354 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Error err;
															#line 356 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Key testKey;
															#line 357 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Future<Void> nextMetadataWatch;
															#line 369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	Future<Standalone<StringRef>> fTrVs;
															#line 391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	ReadYourWritesTransaction cur_tr;
															#line 2899 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Standalone<StringRef> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Optional<Value> >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2904 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(117628422900989696UL, 9453669327132358144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Standalone<StringRef> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Optional<Value> >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	_startActor(Database const& cx,VersionStampWorkload* const& self,double const& delay) 
															#line 2927 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, VersionStampWorkload* const& self, double const& delay ) {
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
	return Future<Void>(new _startActor(cx, self, delay));
															#line 2965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/VersionStamp.actor.g.cpp.py_gen"
}

#line 452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/VersionStamp.actor.cpp"
};

WorkloadFactory<VersionStampWorkload> VersionStampWorkloadFactory;
