#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
/*
 * Ping.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/ActorCollection.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct PingWorkloadInterface {
	RequestStream<LoadedPingRequest> payloadPing;

	UID id() const { return payloadPing.getEndpoint().token; }

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, payloadPing);
	}
};

struct PingWorkload : TestWorkload {
	static constexpr auto NAME = "Ping";

	double testDuration, operationsPerSecond;
	PingWorkloadInterface interf;
	bool logging, pingWorkers, registerInterface, broadcastTest, usePayload, parallelBroadcast, workerBroadcast;
	Standalone<StringRef> payloadOut, payloadBack;
	int actorCount;

	std::vector<Future<Void>> clients;
	PerfIntCounter messages;
	PerfDoubleCounter totalMessageLatency;
	PerfDoubleCounter maxMessageLatency;

	PingWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), messages("Messages"), totalMessageLatency("TotalLatency"),
	    maxMessageLatency("Max Latency (ms)") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		operationsPerSecond = getOption(options, "operationsPerSecondPerClient"_sr, 50.0);
		usePayload = getOption(options, "usePayload"_sr, false);
		logging = getOption(options, "logging"_sr, false);
		pingWorkers = getOption(options, "pingWorkers"_sr, false);
		registerInterface = getOption(options, "registerInterface"_sr, true);
		broadcastTest = getOption(options, "broadcastTest"_sr, false);
		parallelBroadcast = getOption(options, "parallelBroadcast"_sr, false);
		workerBroadcast = getOption(options, "workerBroadcast"_sr, false);
		int payloadSize = getOption(options, "payloadSizeOut"_sr, 1024);
		payloadOut = std::string(payloadSize, '.');
		payloadSize = getOption(options, "payloadSizeBack"_sr, 1024);
		payloadBack = std::string(payloadSize, '.');
		actorCount = getOption(options, "actorCount"_sr, 1);
	}

	Future<Void> setup(Database const& cx) override {
		if (pingWorkers || !registerInterface)
			return Void();
		return persistInterface(this, cx);
	}
	Future<Void> start(Database const& cx) override {
		std::vector<Future<Void>> clients;
		if (pingWorkers) {
			clients.push_back(workerPinger(this));
		} else if (broadcastTest) {
			if (parallelBroadcast || !clientId)
				clients.push_back(payloadSender(this, cx));
			// clients.push_back( payloadPinger( this, cx ) );
		} else if (!broadcastTest) {
			clients.push_back(pinger(this, cx));
		}
		clients.push_back(ponger(this));
		return timeout(waitForAll(clients), testDuration, Void()); // delay( testDuration );
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(messages.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalMessageLatency.getValue() / messages.getValue(), Averaged::True);
		m.push_back(maxMessageLatency.getMetric());
	}

																#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via persistInterface()
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PersistInterfaceActor>
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PersistInterfaceActorState {
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PersistInterfaceActorState(PingWorkload* const& self,Database const& cx) 
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   cx(cx),
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   tr(cx)
															#line 120 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistInterface", reinterpret_cast<unsigned long>(this));

	}
	~PersistInterfaceActorState() 
	{
		fdb_probe_actor_destroy("persistInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			BinaryWriter wr(IncludeVersion());
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			wr << self->interf;
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			serializedInterface = wr.toValue();
															#line 106 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			;
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistInterfaceActorState();
		static_cast<PersistInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<PersistInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistInterfaceActorState(); static_cast<PersistInterfaceActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<PersistInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistInterfaceActorState();
		static_cast<PersistInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef(format("Ping/Client/%d", self->clientId)));
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 118 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 3;
															#line 118 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 2, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 233 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (val.present())
															#line 248 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (val.get() != serializedInterface)
															#line 252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		tr.set(format("Ping/Client/%d", self->clientId), serializedInterface);
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 266 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 2;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 1, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 271 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (val.present())
															#line 280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (val.get() != serializedInterface)
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			{
															#line 111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 288 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		tr.set(format("Ping/Client/%d", self->clientId), serializedInterface);
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 2;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistInterfaceActor, 1, Void >*>(static_cast<PersistInterfaceActor*>(this)));
															#line 303 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistInterfaceActor*>(this)->ActorCallback< PersistInterfaceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistInterfaceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistInterfaceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Database cx;
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Transaction tr;
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Standalone<StringRef> serializedInterface;
															#line 565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistInterface()
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PersistInterfaceActor final : public Actor<Void>, public ActorCallback< PersistInterfaceActor, 0, Optional<Value> >, public ActorCallback< PersistInterfaceActor, 1, Void >, public ActorCallback< PersistInterfaceActor, 2, Void >, public FastAllocated<PersistInterfaceActor>, public PersistInterfaceActorState<PersistInterfaceActor> {
															#line 570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistInterfaceActor>::operator new;
	using FastAllocated<PersistInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7844173949537793280UL, 12274979122921660672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistInterfaceActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistInterfaceActor, 1, Void >;
friend struct ActorCallback< PersistInterfaceActor, 2, Void >;
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PersistInterfaceActor(PingWorkload* const& self,Database const& cx) 
															#line 589 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistInterfaceActorState<PersistInterfaceActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(399411798609655552UL, 427757437812594432UL);
		ActorExecutionContextHelper __helper(static_cast<PersistInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistInterfaceActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistInterfaceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistInterfaceActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> persistInterface( PingWorkload* const& self, Database const& cx ) {
															#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PersistInterfaceActor(self, cx));
															#line 623 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 123 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

																#line 628 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via fetchInterfaces()
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class FetchInterfacesActor>
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class FetchInterfacesActorState {
															#line 634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	FetchInterfacesActorState(PingWorkload* const& self,Database const& cx) 
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   cx(cx),
															#line 125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   tr(cx)
															#line 645 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetchInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~FetchInterfacesActorState() 
	{
		fdb_probe_actor_destroy("fetchInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			;
															#line 660 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchInterfacesActorState();
		static_cast<FetchInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 128 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			result = std::vector<PingWorkloadInterface>();
															#line 129 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			i = int();
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			i = 0;
															#line 695 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<FetchInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 719 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchInterfacesActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchInterfacesActor, 1, Void >*>(static_cast<FetchInterfacesActor*>(this)));
															#line 724 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<FetchInterfacesActor*>(this)->SAV<std::vector<PingWorkloadInterface>>::futures) { (void)(result); this->~FetchInterfacesActorState(); static_cast<FetchInterfacesActor*>(this)->destroy(); return 0; }
															#line 739 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<FetchInterfacesActor*>(this)->SAV< std::vector<PingWorkloadInterface> >::value()) std::vector<PingWorkloadInterface>(std::move(result)); // state_var_RVO
		this->~FetchInterfacesActorState();
		static_cast<FetchInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!(i < self->clientCount))
															#line 758 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef(format("Ping/Client/%d", i)));
															#line 131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<FetchInterfacesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 766 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchInterfacesActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchInterfacesActor, 0, Optional<Value> >*>(static_cast<FetchInterfacesActor*>(this)));
															#line 771 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!val.present())
															#line 793 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), std::max(0, loopDepth - 1));
															#line 797 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		PingWorkloadInterface interf;
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		BinaryReader br(val.get(), IncludeVersion());
															#line 137 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		br >> interf;
															#line 138 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		result.push_back(interf);
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		i++;
															#line 809 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!val.present())
															#line 818 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), std::max(0, loopDepth - 1));
															#line 822 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		PingWorkloadInterface interf;
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		BinaryReader br(val.get(), IncludeVersion());
															#line 137 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		br >> interf;
															#line 138 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		result.push_back(interf);
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		i++;
															#line 834 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchInterfacesActor*>(this)->actor_wait_state > 0) static_cast<FetchInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchInterfacesActor*>(this)->ActorCallback< FetchInterfacesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchInterfacesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchInterfacesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchInterfacesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchInterfacesActor*>(this)->actor_wait_state > 0) static_cast<FetchInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchInterfacesActor*>(this)->ActorCallback< FetchInterfacesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchInterfacesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchInterfacesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchInterfacesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Database cx;
															#line 125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Transaction tr;
															#line 128 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	std::vector<PingWorkloadInterface> result;
															#line 129 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	int i;
															#line 1011 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetchInterfaces()
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class FetchInterfacesActor final : public Actor<std::vector<PingWorkloadInterface>>, public ActorCallback< FetchInterfacesActor, 0, Optional<Value> >, public ActorCallback< FetchInterfacesActor, 1, Void >, public FastAllocated<FetchInterfacesActor>, public FetchInterfacesActorState<FetchInterfacesActor> {
															#line 1016 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetchInterfacesActor>::operator new;
	using FastAllocated<FetchInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17853871991892912896UL, 3338351719685627136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<PingWorkloadInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchInterfacesActor, 0, Optional<Value> >;
friend struct ActorCallback< FetchInterfacesActor, 1, Void >;
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	FetchInterfacesActor(PingWorkload* const& self,Database const& cx) 
															#line 1034 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<std::vector<PingWorkloadInterface>>(),
		   FetchInterfacesActorState<FetchInterfacesActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14113708507311096320UL, 9642376210661601792UL);
		ActorExecutionContextHelper __helper(static_cast<FetchInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchInterfacesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchInterfacesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<std::vector<PingWorkloadInterface>> fetchInterfaces( PingWorkload* const& self, Database const& cx ) {
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<std::vector<PingWorkloadInterface>>(new FetchInterfacesActor(self, cx));
															#line 1067 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

																#line 1072 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via pinger()
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PingerActor>
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PingerActorState {
															#line 1078 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingerActorState(PingWorkload* const& self,std::vector<RequestStream<LoadedPingRequest>> const& peers) 
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   peers(peers),
															#line 148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   lastTime(now())
															#line 1089 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("pinger", reinterpret_cast<unsigned long>(this));

	}
	~PingerActorState() 
	{
		fdb_probe_actor_destroy("pinger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			;
															#line 1104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PingerActorState();
		static_cast<PingerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, self->actorCount / self->operationsPerSecond);
															#line 151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PingerActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PingerActor, 0, Void >*>(static_cast<PingerActor*>(this)));
															#line 1141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		auto& peer = deterministicRandom()->randomChoice(peers);
															#line 153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		addr = peer.getEndpoint().getPrimaryAddress();
															#line 154 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		before = now();
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		LoadedPingRequest req;
															#line 157 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.id = deterministicRandom()->randomUniqueID();
															#line 158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.payload = self->usePayload ? self->payloadOut : ""_sr;
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.loadReply = self->usePayload;
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<LoadedReply> __when_expr_1 = peer.getReply(req);
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1166 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingerActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingerActor, 1, LoadedReply >*>(static_cast<PingerActor*>(this)));
															#line 1171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		auto& peer = deterministicRandom()->randomChoice(peers);
															#line 153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		addr = peer.getEndpoint().getPrimaryAddress();
															#line 154 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		before = now();
															#line 156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		LoadedPingRequest req;
															#line 157 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.id = deterministicRandom()->randomUniqueID();
															#line 158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.payload = self->usePayload ? self->payloadOut : ""_sr;
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.loadReply = self->usePayload;
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<LoadedReply> __when_expr_1 = peer.getReply(req);
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingerActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingerActor, 1, LoadedReply >*>(static_cast<PingerActor*>(this)));
															#line 1201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PingerActor*>(this)->actor_wait_state > 0) static_cast<PingerActor*>(this)->actor_wait_state = 0;
		static_cast<PingerActor*>(this)->ActorCallback< PingerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PingerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PingerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(LoadedReply const& rep,int loopDepth) 
	{
															#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		double elapsed = now() - before;
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		self->totalMessageLatency += elapsed;
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		self->maxMessageLatency += std::max(0.0, elapsed * 1000.0 - self->maxMessageLatency.getValue());
															#line 165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		++self->messages;
															#line 166 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (self->logging)
															#line 1293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			TraceEvent("Ping").detail("Elapsed", elapsed).detail("To", addr);
															#line 1297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(LoadedReply && rep,int loopDepth) 
	{
															#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		double elapsed = now() - before;
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		self->totalMessageLatency += elapsed;
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		self->maxMessageLatency += std::max(0.0, elapsed * 1000.0 - self->maxMessageLatency.getValue());
															#line 165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		++self->messages;
															#line 166 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (self->logging)
															#line 1315 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			TraceEvent("Ping").detail("Elapsed", elapsed).detail("To", addr);
															#line 1319 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(LoadedReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(LoadedReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PingerActor*>(this)->actor_wait_state > 0) static_cast<PingerActor*>(this)->actor_wait_state = 0;
		static_cast<PingerActor*>(this)->ActorCallback< PingerActor, 1, LoadedReply >::remove();

	}
	void a_callback_fire(ActorCallback< PingerActor, 1, LoadedReply >*,LoadedReply const& value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PingerActor, 1, LoadedReply >*,LoadedReply && value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PingerActor, 1, LoadedReply >*,Error err) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	double lastTime;
															#line 153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	NetworkAddress addr;
															#line 154 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	double before;
															#line 1410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via pinger()
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PingerActor final : public Actor<Void>, public ActorCallback< PingerActor, 0, Void >, public ActorCallback< PingerActor, 1, LoadedReply >, public FastAllocated<PingerActor>, public PingerActorState<PingerActor> {
															#line 1415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PingerActor>::operator new;
	using FastAllocated<PingerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13219892245258710528UL, 15069327083996716288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PingerActor, 0, Void >;
friend struct ActorCallback< PingerActor, 1, LoadedReply >;
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingerActor(PingWorkload* const& self,std::vector<RequestStream<LoadedPingRequest>> const& peers) 
															#line 1433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PingerActorState<PingerActor>(self, peers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151316949234226176UL, 7767342210387935744UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pinger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PingerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PingerActor, 1, LoadedReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> pinger( PingWorkload* const& self, std::vector<RequestStream<LoadedPingRequest>> const& peers ) {
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PingerActor(self, peers));
															#line 1466 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

																#line 1471 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via pinger()
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PingerActor1>
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PingerActor1State {
															#line 1477 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingerActor1State(PingWorkload* const& self,Database const& cx) 
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   cx(cx)
															#line 1486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("pinger", reinterpret_cast<unsigned long>(this));

	}
	~PingerActor1State() 
	{
		fdb_probe_actor_destroy("pinger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<std::vector<PingWorkloadInterface>> __when_expr_0 = self->fetchInterfaces(self, cx);
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<PingerActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PingerActor1*>(this)->actor_wait_state = 1;
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >*>(static_cast<PingerActor1*>(this)));
															#line 1508 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PingerActor1State();
		static_cast<PingerActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<PingWorkloadInterface> const& testers,int loopDepth) 
	{
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		peers.reserve(testers.size());
															#line 175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < testers.size();i++) {
															#line 176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			peers.push_back(testers[i].payloadPing);
															#line 1537 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<Future<Void>> pingers;
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		pingers.reserve(self->actorCount);
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < self->actorCount;i++) {
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			pingers.push_back(self->pinger(self, peers));
															#line 1547 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(pingers);
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PingerActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1553 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingerActor1*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingerActor1, 1, Void >*>(static_cast<PingerActor1*>(this)));
															#line 1558 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<PingWorkloadInterface> && testers,int loopDepth) 
	{
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		peers.reserve(testers.size());
															#line 175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < testers.size();i++) {
															#line 176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			peers.push_back(testers[i].payloadPing);
															#line 1573 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<Future<Void>> pingers;
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		pingers.reserve(self->actorCount);
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < self->actorCount;i++) {
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			pingers.push_back(self->pinger(self, peers));
															#line 1583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(pingers);
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PingerActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1589 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingerActor1*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingerActor1, 1, Void >*>(static_cast<PingerActor1*>(this)));
															#line 1594 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<PingWorkloadInterface> const& testers,int loopDepth) 
	{
		loopDepth = a_body1cont1(testers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<PingWorkloadInterface> && testers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(testers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PingerActor1*>(this)->actor_wait_state > 0) static_cast<PingerActor1*>(this)->actor_wait_state = 0;
		static_cast<PingerActor1*>(this)->ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >*,std::vector<PingWorkloadInterface> const& value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >*,std::vector<PingWorkloadInterface> && value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<PingerActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingerActor1State(); static_cast<PingerActor1*>(this)->destroy(); return 0; }
															#line 1678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<PingerActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingerActor1State();
		static_cast<PingerActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<PingerActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingerActor1State(); static_cast<PingerActor1*>(this)->destroy(); return 0; }
															#line 1690 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<PingerActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingerActor1State();
		static_cast<PingerActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PingerActor1*>(this)->actor_wait_state > 0) static_cast<PingerActor1*>(this)->actor_wait_state = 0;
		static_cast<PingerActor1*>(this)->ActorCallback< PingerActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingerActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PingerActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PingerActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Database cx;
															#line 1777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via pinger()
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PingerActor1 final : public Actor<Void>, public ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >, public ActorCallback< PingerActor1, 1, Void >, public FastAllocated<PingerActor1>, public PingerActor1State<PingerActor1> {
															#line 1782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PingerActor1>::operator new;
	using FastAllocated<PingerActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13219892245258710528UL, 15069327083996716288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >;
friend struct ActorCallback< PingerActor1, 1, Void >;
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingerActor1(PingWorkload* const& self,Database const& cx) 
															#line 1800 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PingerActor1State<PingerActor1>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pinger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(837520557422790656UL, 11275160824876156160UL);
		ActorExecutionContextHelper __helper(static_cast<PingerActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pinger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pinger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PingerActor1, 0, std::vector<PingWorkloadInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PingerActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> pinger( PingWorkload* const& self, Database const& cx ) {
															#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PingerActor1(self, cx));
															#line 1833 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

																#line 1838 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via workerPinger()
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class WorkerPingerActor>
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class WorkerPingerActorState {
															#line 1844 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	WorkerPingerActorState(PingWorkload* const& self) 
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self)
															#line 1851 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerPinger", reinterpret_cast<unsigned long>(this));

	}
	~WorkerPingerActorState() 
	{
		fdb_probe_actor_destroy("workerPinger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<WorkerPingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1868 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerPingerActor*>(this)->actor_wait_state = 1;
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >*>(static_cast<WorkerPingerActor*>(this)));
															#line 1873 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerPingerActorState();
		static_cast<WorkerPingerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		peers.reserve(workers.size());
															#line 189 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			peers.push_back(workers[i].interf.debugPing);
															#line 1902 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<Future<Void>> pingers;
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		pingers.reserve(self->actorCount);
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < self->actorCount;i++) {
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			pingers.push_back(self->pinger(self, peers));
															#line 1912 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(pingers);
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<WorkerPingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1918 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkerPingerActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerPingerActor, 1, Void >*>(static_cast<WorkerPingerActor*>(this)));
															#line 1923 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		peers.reserve(workers.size());
															#line 189 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			peers.push_back(workers[i].interf.debugPing);
															#line 1938 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		std::vector<Future<Void>> pingers;
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		pingers.reserve(self->actorCount);
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < self->actorCount;i++) {
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			pingers.push_back(self->pinger(self, peers));
															#line 1948 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(pingers);
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<WorkerPingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkerPingerActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerPingerActor, 1, Void >*>(static_cast<WorkerPingerActor*>(this)));
															#line 1959 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerPingerActor*>(this)->actor_wait_state > 0) static_cast<WorkerPingerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerPingerActor*>(this)->ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<WorkerPingerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerPingerActorState(); static_cast<WorkerPingerActor*>(this)->destroy(); return 0; }
															#line 2043 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<WorkerPingerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerPingerActorState();
		static_cast<WorkerPingerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<WorkerPingerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerPingerActorState(); static_cast<WorkerPingerActor*>(this)->destroy(); return 0; }
															#line 2055 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<WorkerPingerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerPingerActorState();
		static_cast<WorkerPingerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerPingerActor*>(this)->actor_wait_state > 0) static_cast<WorkerPingerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerPingerActor*>(this)->ActorCallback< WorkerPingerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerPingerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerPingerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerPingerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 2140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerPinger()
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class WorkerPingerActor final : public Actor<Void>, public ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >, public ActorCallback< WorkerPingerActor, 1, Void >, public FastAllocated<WorkerPingerActor>, public WorkerPingerActorState<WorkerPingerActor> {
															#line 2145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerPingerActor>::operator new;
	using FastAllocated<WorkerPingerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18084399607271519232UL, 16263468457209057536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< WorkerPingerActor, 1, Void >;
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	WorkerPingerActor(PingWorkload* const& self) 
															#line 2163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerPingerActorState<WorkerPingerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerPinger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14057710909405252608UL, 13327269067115619328UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerPinger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerPinger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerPingerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerPingerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> workerPinger( PingWorkload* const& self ) {
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new WorkerPingerActor(self));
															#line 2196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

	// ACTOR Future<Void> poisson_spin( double *last, double meanInterval ) {
	// 	*last += meanInterval*-log( deterministicRandom()->random01() );
	// 	wait( delay( std::max( *last - timer() - 0.01, 0.0 ) ) );
	// 	if( timer() >= *last )
	// 		TraceEvent(SevWarnAlways, "SpinPoissonInaccurateTime").detail("Diff", timer() - *last);
	// 	while( timer() < *last )
	// 		_mm_pause();
	// 	return Void();
	// }

																#line 2211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via payloadSender()
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PayloadSenderActor>
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PayloadSenderActorState {
															#line 2217 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PayloadSenderActorState(PingWorkload* const& self,Database const& cx) 
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   cx(cx),
															#line 210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   endpoints(),
															#line 211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   lastTime(timer()),
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   addActor(),
															#line 213 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   collection(actorCollection(addActor.getFuture()))
															#line 2234 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("payloadSender", reinterpret_cast<unsigned long>(this));

	}
	~PayloadSenderActorState() 
	{
		fdb_probe_actor_destroy("payloadSender", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 215 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (self->workerBroadcast)
															#line 2249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			{
															#line 216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				if (static_cast<PayloadSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2255 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<PayloadSenderActor*>(this)->actor_wait_state = 1;
															#line 216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >*>(static_cast<PayloadSenderActor*>(this)));
															#line 2260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				StrictFuture<std::vector<PingWorkloadInterface>> __when_expr_1 = self->fetchInterfaces(self, cx);
															#line 220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				if (static_cast<PayloadSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2269 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<PayloadSenderActor*>(this)->actor_wait_state = 2;
															#line 220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >*>(static_cast<PayloadSenderActor*>(this)));
															#line 2274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PayloadSenderActorState();
		static_cast<PayloadSenderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 226 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		;
															#line 2298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 217 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			endpoints.push_back(workers[i].interf.debugPing);
															#line 2309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 217 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			endpoints.push_back(workers[i].interf.debugPing);
															#line 2321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PayloadSenderActor*>(this)->actor_wait_state > 0) static_cast<PayloadSenderActor*>(this)->actor_wait_state = 0;
		static_cast<PayloadSenderActor*>(this)->ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(std::vector<PingWorkloadInterface> const& peers,int loopDepth) 
	{
															#line 221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < peers.size();i++) {
															#line 222 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			endpoints.push_back(peers[i].payloadPing);
															#line 2408 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(std::vector<PingWorkloadInterface> && peers,int loopDepth) 
	{
															#line 221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		for(int i = 0;i < peers.size();i++) {
															#line 222 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			endpoints.push_back(peers[i].payloadPing);
															#line 2420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<PingWorkloadInterface> const& peers,int loopDepth) 
	{
		loopDepth = a_body1cont5(peers, loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<PingWorkloadInterface> && peers,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(peers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PayloadSenderActor*>(this)->actor_wait_state > 0) static_cast<PayloadSenderActor*>(this)->actor_wait_state = 0;
		static_cast<PayloadSenderActor*>(this)->ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >*,std::vector<PingWorkloadInterface> const& value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >*,std::vector<PingWorkloadInterface> && value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = poisson(&lastTime, 1.0 / 6.0);
															#line 227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PayloadSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2514 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<PayloadSenderActor*>(this)->actor_wait_state = 3;
															#line 227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PayloadSenderActor, 2, Void >*>(static_cast<PayloadSenderActor*>(this)));
															#line 2519 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		addActor.send(self->payloadPinger(self, cx, endpoints));
															#line 2528 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		addActor.send(self->payloadPinger(self, cx, endpoints));
															#line 2537 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PayloadSenderActor*>(this)->actor_wait_state > 0) static_cast<PayloadSenderActor*>(this)->actor_wait_state = 0;
		static_cast<PayloadSenderActor*>(this)->ActorCallback< PayloadSenderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PayloadSenderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PayloadSenderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Database cx;
															#line 210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	std::vector<RequestStream<LoadedPingRequest>> endpoints;
															#line 211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	double lastTime;
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 213 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Future<Void> collection;
															#line 2629 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via payloadSender()
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PayloadSenderActor final : public Actor<Void>, public ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >, public ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >, public ActorCallback< PayloadSenderActor, 2, Void >, public FastAllocated<PayloadSenderActor>, public PayloadSenderActorState<PayloadSenderActor> {
															#line 2634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PayloadSenderActor>::operator new;
	using FastAllocated<PayloadSenderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4567837385281445632UL, 6472123044180573952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >;
friend struct ActorCallback< PayloadSenderActor, 2, Void >;
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PayloadSenderActor(PingWorkload* const& self,Database const& cx) 
															#line 2653 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PayloadSenderActorState<PayloadSenderActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("payloadSender", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11620625340381996544UL, 13353046157146248192UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("payloadSender");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("payloadSender", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PayloadSenderActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PayloadSenderActor, 1, std::vector<PingWorkloadInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PayloadSenderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> payloadSender( PingWorkload* const& self, Database const& cx ) {
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PayloadSenderActor(self, cx));
															#line 2687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 231 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

	// ACTOR Future<Void> receptionLogger( PingWorkload* self, Future<PingReply> done, NetworkAddress to, UID id ) {
	// 	wait(success( done ));
	// 	if( now() > self->testStart + 29 && now() < self->testStart + 31 )
	// 		TraceEvent("PayloadReplyReceived", id).detail("To", to);
	// 	return Void();
	// }

	// ACTOR Future<Void> payloadDelayer( PingRequest req, PromiseStream<PingRequest> stream ) {
	// 	wait( delay( deterministicRandom()->random01() * 0.100 ) );
	// 	PingReply rep = wait( stream.getReply( req ) );
	// 	return Void();
	// }

																#line 2705 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via payloadPinger()
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PayloadPingerActor>
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PayloadPingerActorState {
															#line 2711 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PayloadPingerActorState(PingWorkload* const& self,Database const& cx,std::vector<RequestStream<LoadedPingRequest>> const& peers) 
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self),
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   cx(cx),
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   peers(peers),
															#line 251 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   start(now()),
															#line 252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		   pingId(deterministicRandom()->randomUniqueID())
															#line 2726 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("payloadPinger", reinterpret_cast<unsigned long>(this));

	}
	~PayloadPingerActorState() 
	{
		fdb_probe_actor_destroy("payloadPinger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			std::vector<Future<Void>> replies;
															#line 254 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			for(int i = 0;i < peers.size();i++) {
															#line 255 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				LoadedPingRequest req;
															#line 256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				req.id = pingId;
															#line 257 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				req.payload = self->payloadOut;
															#line 258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				req.loadReply = true;
															#line 259 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
				replies.push_back(success(peers[i].getReply(req)));
															#line 2753 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			}
															#line 264 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			TraceEvent("PayloadPingSent", pingId).log();
															#line 265 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 265 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			if (static_cast<PayloadPingerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2761 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PayloadPingerActor*>(this)->actor_wait_state = 1;
															#line 265 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PayloadPingerActor, 0, Void >*>(static_cast<PayloadPingerActor*>(this)));
															#line 2766 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PayloadPingerActorState();
		static_cast<PayloadPingerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 266 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		double elapsed = now() - start;
															#line 267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		TraceEvent("PayloadPingDone", pingId).detail("Elapsed", elapsed);
															#line 270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<PayloadPingerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PayloadPingerActorState(); static_cast<PayloadPingerActor*>(this)->destroy(); return 0; }
															#line 2793 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<PayloadPingerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PayloadPingerActorState();
		static_cast<PayloadPingerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 266 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		double elapsed = now() - start;
															#line 267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		TraceEvent("PayloadPingDone", pingId).detail("Elapsed", elapsed);
															#line 270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (!static_cast<PayloadPingerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PayloadPingerActorState(); static_cast<PayloadPingerActor*>(this)->destroy(); return 0; }
															#line 2809 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		new (&static_cast<PayloadPingerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PayloadPingerActorState();
		static_cast<PayloadPingerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PayloadPingerActor*>(this)->actor_wait_state > 0) static_cast<PayloadPingerActor*>(this)->actor_wait_state = 0;
		static_cast<PayloadPingerActor*>(this)->ActorCallback< PayloadPingerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PayloadPingerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("payloadPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadPinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PayloadPingerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("payloadPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadPinger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PayloadPingerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("payloadPinger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("payloadPinger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	Database cx;
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	std::vector<RequestStream<LoadedPingRequest>> peers;
															#line 251 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	double start;
															#line 252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	UID pingId;
															#line 2902 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via payloadPinger()
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PayloadPingerActor final : public Actor<Void>, public ActorCallback< PayloadPingerActor, 0, Void >, public FastAllocated<PayloadPingerActor>, public PayloadPingerActorState<PayloadPingerActor> {
															#line 2907 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PayloadPingerActor>::operator new;
	using FastAllocated<PayloadPingerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2938915480513666048UL, 7618313225285720832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PayloadPingerActor, 0, Void >;
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PayloadPingerActor(PingWorkload* const& self,Database const& cx,std::vector<RequestStream<LoadedPingRequest>> const& peers) 
															#line 2924 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PayloadPingerActorState<PayloadPingerActor>(self, cx, peers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("payloadPinger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5665017628006313984UL, 4337396137223859456UL);
		ActorExecutionContextHelper __helper(static_cast<PayloadPingerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("payloadPinger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("payloadPinger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PayloadPingerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> payloadPinger( PingWorkload* const& self, Database const& cx, std::vector<RequestStream<LoadedPingRequest>> const& peers ) {
															#line 245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PayloadPingerActor(self, cx, peers));
															#line 2956 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 272 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"

	// ACTOR Future<Void> packetPonger( PingWorkload* self, LoadedPingRequest req ) {
	// 	wait( delay( deterministicRandom()->random01() * 0.100 ) );

	// 	LoadedReply rep;
	// 	rep.id = req.id;
	// 	rep.payload = req.loadReply ? self->payloadBack : ""_sr;
	// 	req.reply.send( rep );

	// 	return Void();
	// }

																#line 2972 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
// This generated class is to be used only via ponger()
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
template <class PongerActor>
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PongerActorState {
															#line 2978 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PongerActorState(PingWorkload* const& self) 
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		 : self(self)
															#line 2985 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ponger", reinterpret_cast<unsigned long>(this));

	}
	~PongerActorState() 
	{
		fdb_probe_actor_destroy("ponger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 288 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
			;
															#line 3000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PongerActorState();
		static_cast<PongerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		auto __when_expr_0 = self->interf.payloadPing.getFuture();
															#line 3030 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<LoadedPingRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<LoadedPingRequest>>::value, "invalid type");
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		if (static_cast<PongerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3034 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<PongerActor*>(this)->actor_wait_state = 1;
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< PongerActor, 0, LoadedPingRequest >*>(static_cast<PongerActor*>(this)));
															#line 3039 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest const& req,int loopDepth) 
	{
															#line 297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		LoadedReply rep;
															#line 298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		rep.id = req.id;
															#line 299 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		rep.payload = req.loadReply ? self->payloadBack : ""_sr;
															#line 300 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.reply.send(rep);
															#line 3054 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest && req,int loopDepth) 
	{
															#line 297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		LoadedReply rep;
															#line 298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		rep.id = req.id;
															#line 299 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		rep.payload = req.loadReply ? self->payloadBack : ""_sr;
															#line 300 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
		req.reply.send(rep);
															#line 3069 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PongerActor*>(this)->actor_wait_state > 0) static_cast<PongerActor*>(this)->actor_wait_state = 0;
		static_cast<PongerActor*>(this)->ActorSingleCallback< PongerActor, 0, LoadedPingRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< PongerActor, 0, LoadedPingRequest >*,LoadedPingRequest const& value) 
	{
		fdb_probe_actor_enter("ponger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ponger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< PongerActor, 0, LoadedPingRequest >*,LoadedPingRequest && value) 
	{
		fdb_probe_actor_enter("ponger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ponger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< PongerActor, 0, LoadedPingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("ponger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ponger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PingWorkload* self;
															#line 3151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ponger()
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
class PongerActor final : public Actor<Void>, public ActorSingleCallback< PongerActor, 0, LoadedPingRequest >, public FastAllocated<PongerActor>, public PongerActorState<PongerActor> {
															#line 3156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
public:
	using FastAllocated<PongerActor>::operator new;
	using FastAllocated<PongerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11901387007425753344UL, 15411080348424545792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< PongerActor, 0, LoadedPingRequest >;
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	PongerActor(PingWorkload* const& self) 
															#line 3173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PongerActorState<PongerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ponger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14936752018465895680UL, 11879090981986934272UL);
		ActorExecutionContextHelper __helper(static_cast<PongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ponger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ponger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< PongerActor, 0, LoadedPingRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
[[nodiscard]] Future<Void> ponger( PingWorkload* const& self ) {
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
	return Future<Void>(new PongerActor(self));
															#line 3205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Ping.actor.g.cpp.py_gen"
}

#line 305 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/Ping.actor.cpp"
};

WorkloadFactory<PingWorkload> PingWorkloadFactory;
