#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
/**
 * ExpectStableThroughput.actor.cpp
 */

#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // This must be the last include

// This workload is meant to be run with the ThroughputQuotaWorklaod.
// The ThroughputQuotaWorkload sets a total quota, and then this workload runs
// with tagged transactions for a long duration, attempting to achieve a higher
// throughput than the specified quota. The check phase of this workload then
// verifies that the achieved throughput is near the total quota.
//
// TODO:
//   - Test write workloads
//   - Randomize the number of operations per transaction
//   - Test multi-page operations
class ExpectStableThroughputWorkload : public TestWorkload {
	// Metrics:
	uint64_t totalCost{ 0 };
	double throttledDuration{ 0.0 };
	int tagThrottledErrors{ 0 };

	// Parameters:
	double testDuration;
	uint64_t expectedThroughputPagesRate;
	TransactionTag throttlingTag;
	double errorTolerance;
	Key keyPrefix;
	int numActors;
	double attemptedTransactionRatePerActor;
	double warmupTime;
	int opsPerTransaction;

	double startTime;

	void finishTransaction(Transaction const& tr) {
		if (now() > startTime + warmupTime) {
			totalCost += tr.getTotalCost();
			throttledDuration += tr.getTagThrottledDuration();
		}
	}

	Key getKey(int index) { return Key(format("%06d", index)).withPrefix(keyPrefix); }

																#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
// This generated class is to be used only via runTransaction()
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
template <class RunTransactionActor>
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
class RunTransactionActorState {
															#line 56 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
public:
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	RunTransactionActorState(ExpectStableThroughputWorkload* const& self,Database const& cx) 
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		 : self(self),
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		   cx(cx),
															#line 49 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		   tr(cx),
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		   futures()
															#line 69 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunTransactionActorState() 
	{
		fdb_probe_actor_destroy("runTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			;
															#line 84 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTransactionActorState();
		static_cast<RunTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 53 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			tr.setOption(FDBTransactionOptions::AUTO_THROTTLE_TAG, self->throttlingTag);
															#line 54 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			futures.clear();
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			futures.reserve(self->opsPerTransaction);
															#line 56 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			for(int i = 0;i < self->opsPerTransaction;++i) {
															#line 57 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
				futures.push_back(success(tr.get(self->getKey(i))));
															#line 123 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			}
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 129 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunTransactionActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 0, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			self->finishTransaction(tr);
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			if (e.code() == error_code_proxy_tag_throttled && now() > self->startTime + self->warmupTime)
															#line 158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
				++self->tagThrottledErrors;
															#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			}
															#line 67 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 67 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunTransactionActor*>(this)->actor_wait_state = 2;
															#line 67 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 1, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		self->finishTransaction(tr);
															#line 61 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		if (!static_cast<RunTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTransactionActorState(); static_cast<RunTransactionActor*>(this)->destroy(); return 0; }
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		new (&static_cast<RunTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTransactionActorState();
		static_cast<RunTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		self->finishTransaction(tr);
															#line 61 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		if (!static_cast<RunTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTransactionActorState(); static_cast<RunTransactionActor*>(this)->destroy(); return 0; }
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		new (&static_cast<RunTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTransactionActorState();
		static_cast<RunTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	ExpectStableThroughputWorkload* self;
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	Database cx;
															#line 49 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	Transaction tr;
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runTransaction()
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
class RunTransactionActor final : public Actor<Void>, public ActorCallback< RunTransactionActor, 0, Void >, public ActorCallback< RunTransactionActor, 1, Void >, public FastAllocated<RunTransactionActor>, public RunTransactionActorState<RunTransactionActor> {
															#line 387 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunTransactionActor>::operator new;
	using FastAllocated<RunTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5663812479989579008UL, 15410048662435299328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTransactionActor, 0, Void >;
friend struct ActorCallback< RunTransactionActor, 1, Void >;
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	RunTransactionActor(ExpectStableThroughputWorkload* const& self,Database const& cx) 
															#line 405 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunTransactionActorState<RunTransactionActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(431366012606644224UL, 110055432891511040UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
[[nodiscard]] static Future<Void> runTransaction( ExpectStableThroughputWorkload* const& self, Database const& cx ) {
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	return Future<Void>(new RunTransactionActor(self, cx));
															#line 438 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
}

#line 71 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"

																#line 443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
// This generated class is to be used only via runClient()
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
template <class RunClientActor>
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
class RunClientActorState {
															#line 449 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
public:
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	RunClientActorState(ExpectStableThroughputWorkload* const& self,Database const& cx) 
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		 : self(self),
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		   cx(cx)
															#line 458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runClient", reinterpret_cast<unsigned long>(this));

	}
	~RunClientActorState() 
	{
		fdb_probe_actor_destroy("runClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
			;
															#line 473 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunClientActorState();
		static_cast<RunClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1 / self->attemptedTransactionRatePerActor) && runTransaction(self, cx);
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		if (static_cast<RunClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 505 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunClientActor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunClientActor, 0, Void >*>(static_cast<RunClientActor*>(this)));
															#line 510 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunClientActor*>(this)->actor_wait_state > 0) static_cast<RunClientActor*>(this)->actor_wait_state = 0;
		static_cast<RunClientActor*>(this)->ActorCallback< RunClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	ExpectStableThroughputWorkload* self;
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	Database cx;
															#line 606 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runClient()
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
class RunClientActor final : public Actor<Void>, public ActorCallback< RunClientActor, 0, Void >, public FastAllocated<RunClientActor>, public RunClientActorState<RunClientActor> {
															#line 611 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunClientActor>::operator new;
	using FastAllocated<RunClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1395620734260722432UL, 4482708824989096960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunClientActor, 0, Void >;
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	RunClientActor(ExpectStableThroughputWorkload* const& self,Database const& cx) 
															#line 628 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunClientActorState<RunClientActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17320794064144289280UL, 14301634185507036928UL);
		ActorExecutionContextHelper __helper(static_cast<RunClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunClientActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
[[nodiscard]] static Future<Void> runClient( ExpectStableThroughputWorkload* const& self, Database const& cx ) {
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"
	return Future<Void>(new RunClientActor(self, cx));
															#line 660 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExpectStableThroughput.actor.g.cpp.py_gen"
}

#line 77 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/ExpectStableThroughput.actor.cpp"

public:
	static constexpr auto NAME = "ExpectStableThroughput";
	explicit ExpectStableThroughputWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 1200.0);
		throttlingTag = getOption(options, "throttlingTag"_sr, "testTag"_sr);
		expectedThroughputPagesRate = getOption(options, "expectedThroughputPagesRate"_sr, 1);
		errorTolerance = getOption(options, "errorTolerance"_sr, 0.2);
		keyPrefix = getOption(options, "keyPrefix"_sr, "testKey"_sr);
		numActors = getOption(options, "numActors"_sr, 100);
		attemptedTransactionRatePerActor = getOption(options, "attemptedTransactionRatePerActor"_sr, 0.4);
		warmupTime = getOption(options, "warmupTime"_sr, 10.0);
		opsPerTransaction = getOption(options, "opsPerTransaction"_sr, 5);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0 || !SERVER_KNOBS->GLOBAL_TAG_THROTTLING) {
			return Void();
		}
		startTime = now();
		std::vector<Future<Void>> clients;
		for (int i = 0; i < numActors; ++i) {
			clients.push_back(runClient(this, cx));
		}
		return success(timeout(waitForAll(clients), warmupTime + testDuration));
	}

	Future<bool> check(Database const& cx) override {
		if (clientId != 0 || !SERVER_KNOBS->GLOBAL_TAG_THROTTLING) {
			return true;
		}
		auto const expectedTotalCost =
		    testDuration * expectedThroughputPagesRate * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
		bool const passed = (static_cast<double>(expectedTotalCost) * (1.0 - errorTolerance) <= totalCost) &&
		                    (totalCost <= static_cast<double>(expectedTotalCost) * (1.0 + errorTolerance));
		auto const severity = passed ? SevInfo : SevError;
		TraceEvent(severity, "CheckingStableThroughput")
		    .detail("ExpectedTotalCost", expectedTotalCost)
		    .detail("ErrorTolerance", errorTolerance)
		    .detail("TotalCost", totalCost);
		return passed;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Total Cost", totalCost, Averaged::False);
		m.emplace_back("TagThrottled Errors", tagThrottledErrors, Averaged::False);
		m.emplace_back("Total Throttling Duration", throttledDuration, Averaged::False);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert("Attrition");
		out.insert("RandomClogging");
	}
};

WorkloadFactory<ExpectStableThroughputWorkload> ExpectStableThroughputWorkloadFactory;
