#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
/*
 * CommitBugCheck.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Regression tests for 2 commit related bugs
struct CommitBugWorkload : TestWorkload {
	static constexpr auto NAME = "CommitBug";
	bool success;

	CommitBugWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) { success = true; }

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return timeout(bug1(cx, this) && bug2(cx, this), 60, Void()); }

																#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
// This generated class is to be used only via bug1()
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
template <class Bug1Actor>
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
class Bug1ActorState {
															#line 44 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
public:
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Bug1ActorState(Database const& cx,CommitBugWorkload* const& self) 
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		 : cx(cx),
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   self(self),
															#line 37 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   key(StringRef(format("B1Key%d", self->clientId))),
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   val1("Value1"_sr),
															#line 39 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   val2("Value2"_sr)
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bug1", reinterpret_cast<unsigned long>(this));

	}
	~Bug1ActorState() 
	{
		fdb_probe_actor_destroy("bug1", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			;
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Bug1ActorState();
		static_cast<Bug1Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 42 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr = Transaction(cx);
															#line 43 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		;
															#line 106 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 45 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			tr.set(key, val1);
															#line 46 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 46 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 0, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBugSetVal1Error").error(e);
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			CODE_PROBE(e.code() == error_code_commit_unknown_result, "Commit unknown result");
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 1, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 68 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		;
															#line 382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 58 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			tr.set(key, val2);
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 403 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 3;
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 2, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 408 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBugSetVal2Error").error(e);
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 4;
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 3, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 476 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 85 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		;
															#line 647 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 70 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = tr.get(key);
															#line 70 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 666 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 5;
															#line 70 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 4, Optional<Value> >*>(static_cast<Bug1Actor*>(this)));
															#line 671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBugGetValError").error(e);
															#line 81 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 81 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 710 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 6;
															#line 81 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 5, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 715 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 71 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (!v.present() || v.get() != val2)
															#line 730 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		{
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent(SevError, "CommitBugFailed") .detail("Value", v.present() ? printable(v.get()) : "Not present");
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			self->success = false;
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (!static_cast<Bug1Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Bug1ActorState(); static_cast<Bug1Actor*>(this)->destroy(); return 0; }
															#line 738 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			new (&static_cast<Bug1Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~Bug1ActorState();
			static_cast<Bug1Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 71 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (!v.present() || v.get() != val2)
															#line 752 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		{
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent(SevError, "CommitBugFailed") .detail("Value", v.present() ? printable(v.get()) : "Not present");
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			self->success = false;
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (!static_cast<Bug1Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Bug1ActorState(); static_cast<Bug1Actor*>(this)->destroy(); return 0; }
															#line 760 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			new (&static_cast<Bug1Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~Bug1ActorState();
			static_cast<Bug1Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 87 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			tr.clear(key);
															#line 88 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.commit();
															#line 88 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 7;
															#line 88 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 6, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 959 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBugClearValError").error(e);
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug1Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 998 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<Bug1Actor*>(this)->actor_wait_state = 8;
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< Bug1Actor, 7, Void >*>(static_cast<Bug1Actor*>(this)));
															#line 1003 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 1018 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.reset();
															#line 1027 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<Bug1Actor*>(this)->actor_wait_state > 0) static_cast<Bug1Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug1Actor*>(this)->ActorCallback< Bug1Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< Bug1Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< Bug1Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Database cx;
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	CommitBugWorkload* self;
															#line 37 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Key key;
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Value val1;
															#line 39 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Value val2;
															#line 42 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Transaction tr;
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bug1()
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
class Bug1Actor final : public Actor<Void>, public ActorCallback< Bug1Actor, 0, Void >, public ActorCallback< Bug1Actor, 1, Void >, public ActorCallback< Bug1Actor, 2, Void >, public ActorCallback< Bug1Actor, 3, Void >, public ActorCallback< Bug1Actor, 4, Optional<Value> >, public ActorCallback< Bug1Actor, 5, Void >, public ActorCallback< Bug1Actor, 6, Void >, public ActorCallback< Bug1Actor, 7, Void >, public FastAllocated<Bug1Actor>, public Bug1ActorState<Bug1Actor> {
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
public:
	using FastAllocated<Bug1Actor>::operator new;
	using FastAllocated<Bug1Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10979943857085417728UL, 16732215233610750464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Bug1Actor, 0, Void >;
friend struct ActorCallback< Bug1Actor, 1, Void >;
friend struct ActorCallback< Bug1Actor, 2, Void >;
friend struct ActorCallback< Bug1Actor, 3, Void >;
friend struct ActorCallback< Bug1Actor, 4, Optional<Value> >;
friend struct ActorCallback< Bug1Actor, 5, Void >;
friend struct ActorCallback< Bug1Actor, 6, Void >;
friend struct ActorCallback< Bug1Actor, 7, Void >;
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Bug1Actor(Database const& cx,CommitBugWorkload* const& self) 
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   Bug1ActorState<Bug1Actor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bug1", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8643313704249577472UL, 8814497400784123904UL);
		ActorExecutionContextHelper __helper(static_cast<Bug1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bug1");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bug1", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Bug1Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Bug1Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Bug1Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Bug1Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< Bug1Actor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< Bug1Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< Bug1Actor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< Bug1Actor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
[[nodiscard]] Future<Void> bug1( Database const& cx, CommitBugWorkload* const& self ) {
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	return Future<Void>(new Bug1Actor(cx, self));
															#line 1274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
}

#line 98 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"

																#line 1279 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
// This generated class is to be used only via bug2()
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
template <class Bug2Actor>
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
class Bug2ActorState {
															#line 1285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
public:
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Bug2ActorState(Database const& cx,CommitBugWorkload* const& self) 
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		 : cx(cx),
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   self(self),
															#line 100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   key(StringRef(format("B2Key%d", self->clientId))),
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		   i()
															#line 1298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bug2", reinterpret_cast<unsigned long>(this));

	}
	~Bug2ActorState() 
	{
		fdb_probe_actor_destroy("bug2", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			i = 0;
															#line 1313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Bug2ActorState();
		static_cast<Bug2Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (!static_cast<Bug2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Bug2ActorState(); static_cast<Bug2Actor*>(this)->destroy(); return 0; }
															#line 1336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		new (&static_cast<Bug2Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Bug2ActorState();
		static_cast<Bug2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (!(i < 1000))
															#line 1355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr = Transaction(cx);
															#line 106 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		;
															#line 1363 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		++i;
															#line 1385 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(key);
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1404 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Bug2Actor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 0, Optional<Value> >*>(static_cast<Bug2Actor*>(this)));
															#line 1409 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			e = error;
															#line 126 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (e.code() != error_code_not_committed && e.code() != error_code_transaction_too_old)
															#line 1446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			{
															#line 127 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				tr.reset();
															#line 128 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				;
															#line 1452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1loopBody1Catch1loopHead1(loopDepth);
			}
			else
			{
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				CODE_PROBE(true, "Commit conflict");
															#line 144 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				TraceEvent("CommitBug2Error").error(e).detail("AttemptedNum", i + 1);
															#line 145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1465 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<Bug2Actor*>(this)->actor_wait_state = 5;
															#line 145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 4, Void >*>(static_cast<Bug2Actor*>(this)));
															#line 1470 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		num = 0;
															#line 110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (val.present())
															#line 1488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		{
															#line 111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			num = atoi(val.get().toString().c_str());
															#line 112 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (num != i)
															#line 1494 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			{
															#line 113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				TraceEvent(SevError, "CommitBug2Failed").detail("Value", num).detail("Expected", i);
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				self->success = false;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				if (!static_cast<Bug2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Bug2ActorState(); static_cast<Bug2Actor*>(this)->destroy(); return 0; }
															#line 1502 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
				new (&static_cast<Bug2Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~Bug2ActorState();
				static_cast<Bug2Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 119 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		TraceEvent("CommitBug2SetKey").detail("Num", i + 1);
															#line 120 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.set(key, StringRef(format("%d", i + 1)));
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1517 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Bug2Actor*>(this)->actor_wait_state = 2;
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 1, Void >*>(static_cast<Bug2Actor*>(this)));
															#line 1522 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		num = 0;
															#line 110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (val.present())
															#line 1533 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		{
															#line 111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			num = atoi(val.get().toString().c_str());
															#line 112 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (num != i)
															#line 1539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			{
															#line 113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				TraceEvent(SevError, "CommitBug2Failed").detail("Value", num).detail("Expected", i);
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				self->success = false;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
				if (!static_cast<Bug2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Bug2ActorState(); static_cast<Bug2Actor*>(this)->destroy(); return 0; }
															#line 1547 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
				new (&static_cast<Bug2Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~Bug2ActorState();
				static_cast<Bug2Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 119 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		TraceEvent("CommitBug2SetKey").detail("Num", i + 1);
															#line 120 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		tr.set(key, StringRef(format("%d", i + 1)));
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1562 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Bug2Actor*>(this)->actor_wait_state = 2;
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 1, Void >*>(static_cast<Bug2Actor*>(this)));
															#line 1567 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Bug2Actor*>(this)->actor_wait_state > 0) static_cast<Bug2Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug2Actor*>(this)->ActorCallback< Bug2Actor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Bug2Actor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		TraceEvent("CommitBug2SetCompleted").detail("Num", i + 1);
															#line 1651 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
		TraceEvent("CommitBug2SetCompleted").detail("Num", i + 1);
															#line 1660 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Bug2Actor*>(this)->actor_wait_state > 0) static_cast<Bug2Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug2Actor*>(this)->ActorCallback< Bug2Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Bug2Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1(int loopDepth) 
	{
		try {
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBug2SetKey").detail("Num", i + 1);
															#line 131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			tr.set(key, StringRef(format("%d", i + 1)));
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			TraceEvent("CommitBug2SetCompleted").detail("Num", i + 1);
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1772 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1Catch1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Bug2Actor*>(this)->actor_wait_state = 3;
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 2, Void >*>(static_cast<Bug2Actor*>(this)));
															#line 1777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1Catch1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(err);
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			if (static_cast<Bug2Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 1814 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1loopBody1Catch1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<Bug2Actor*>(this)->actor_wait_state = 4;
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Bug2Actor, 3, Void >*>(static_cast<Bug2Actor*>(this)));
															#line 1819 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Bug2Actor*>(this)->actor_wait_state > 0) static_cast<Bug2Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug2Actor*>(this)->ActorCallback< Bug2Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Bug2Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Bug2Actor*>(this)->actor_wait_state > 0) static_cast<Bug2Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug2Actor*>(this)->ActorCallback< Bug2Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Bug2Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<Bug2Actor*>(this)->actor_wait_state > 0) static_cast<Bug2Actor*>(this)->actor_wait_state = 0;
		static_cast<Bug2Actor*>(this)->ActorCallback< Bug2Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< Bug2Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< Bug2Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Database cx;
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	CommitBugWorkload* self;
															#line 100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Key key;
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	int i;
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Transaction tr;
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	int num;
															#line 125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Error e;
															#line 2105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bug2()
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
class Bug2Actor final : public Actor<Void>, public ActorCallback< Bug2Actor, 0, Optional<Value> >, public ActorCallback< Bug2Actor, 1, Void >, public ActorCallback< Bug2Actor, 2, Void >, public ActorCallback< Bug2Actor, 3, Void >, public ActorCallback< Bug2Actor, 4, Void >, public FastAllocated<Bug2Actor>, public Bug2ActorState<Bug2Actor> {
															#line 2110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
public:
	using FastAllocated<Bug2Actor>::operator new;
	using FastAllocated<Bug2Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14366366115509161216UL, 17740517366460790784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Bug2Actor, 0, Optional<Value> >;
friend struct ActorCallback< Bug2Actor, 1, Void >;
friend struct ActorCallback< Bug2Actor, 2, Void >;
friend struct ActorCallback< Bug2Actor, 3, Void >;
friend struct ActorCallback< Bug2Actor, 4, Void >;
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	Bug2Actor(Database const& cx,CommitBugWorkload* const& self) 
															#line 2131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   Bug2ActorState<Bug2Actor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bug2", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7853006366851451136UL, 244525856868745216UL);
		ActorExecutionContextHelper __helper(static_cast<Bug2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bug2");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bug2", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Bug2Actor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Bug2Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Bug2Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Bug2Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< Bug2Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
[[nodiscard]] Future<Void> bug2( Database const& cx, CommitBugWorkload* const& self ) {
															#line 99 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"
	return Future<Void>(new Bug2Actor(cx, self));
															#line 2167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CommitBugCheck.actor.g.cpp.py_gen"
}

#line 153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/workloads/CommitBugCheck.actor.cpp"

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<CommitBugWorkload> CommitBugWorkloadFactory;
